import { Widget } from '@lumino/widgets';
import { Git, IGitExtension } from '../tokens';
export declare enum Operation {
    Pull = "Pull",
    Push = "Push"
}
/**
 * The UI for the content shown within the Git push/pull modal.
 */
export declare class GitPullPushDialog extends Widget {
    private _spinner;
    private _model;
    private _body;
    private _operation;
    /**
     * Instantiates the dialog and makes the relevant service API call.
     */
    constructor(model: IGitExtension, operation: Operation, auth?: Git.IAuth);
    /**
     * Executes the relevant service API depending on the _operation and handles response and errors.
     * @param currentFileBrowserPath the path to the current repo
     */
    private executeGitApi;
    /**
     * Handles the response from the server by removing the _spinner and showing the appropriate
     * success or error message.
     * @param response the response from the server API call
     */
    private handleResponse;
    private handleError;
    private handleSuccess;
    private createBody;
}
