"use strict";
/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(require("react"));
const utils_1 = __importDefault(require("./utils"));
const EnvForm = ({ env }) => {
    if (env.length > 0) {
        return (React.createElement(React.Fragment, null,
            React.createElement("tr", null,
                React.createElement("td", { colSpan: 4 })),
            React.createElement("tr", null,
                React.createElement("td", { colSpan: 4 },
                    React.createElement("div", { style: { fontSize: 'var(--jp-ui-font-size3)' } }, "Environmental Variables"))),
            utils_1.default.chunkArray(env, 4).map((col, i) => (React.createElement("tr", { key: i }, col.map(envVar => (React.createElement("td", { key: envVar },
                React.createElement("label", { htmlFor: envVar },
                    envVar,
                    ":"),
                React.createElement("br", null),
                React.createElement("input", { type: "text", id: envVar, className: "envVar", name: envVar, size: 20 })))))))));
    }
    return null;
};
class NotebookSubmissionDialog extends React.Component {
    render() {
        const { runtimes, images, env } = this.props;
        return (React.createElement("form", null,
            React.createElement("table", { id: "table-submit-dialog", className: "elyra-table" },
                React.createElement("tbody", null,
                    React.createElement("tr", null,
                        React.createElement("td", { colSpan: 2 },
                            React.createElement("label", { htmlFor: "runtime_config" }, "Runtime Config:"),
                            React.createElement("br", null),
                            React.createElement("select", { id: "runtime_config", name: "runtime_config", className: "elyra-form-runtime-config" }, runtimes.map(runtime => (React.createElement("option", { key: runtime.name, value: runtime.name }, runtime.display_name))))),
                        React.createElement("td", { colSpan: 2 },
                            React.createElement("label", { htmlFor: "framework" }, "Runtime images:"),
                            React.createElement("br", null),
                            React.createElement("select", { id: "framework", name: "framework", className: "elyra-form-framework" }, Object.entries(images).map(([key, val]) => (React.createElement("option", { key: key, value: key }, val)))))),
                    React.createElement("tr", null,
                        React.createElement("td", null,
                            React.createElement("br", null),
                            React.createElement("input", { type: "checkbox", id: "dependency_include", name: "dependency_include", size: 20, defaultChecked: true }),
                            React.createElement("label", { htmlFor: "dependency_include" }, "Include dependencies"),
                            React.createElement("br", null)),
                        React.createElement("td", { colSpan: 3 },
                            React.createElement("br", null),
                            React.createElement("input", { type: "text", id: "dependencies", name: "dependencies", placeholder: "*.py", defaultValue: "*.py", size: 20 }))),
                    React.createElement(EnvForm, { env: env })))));
    }
}
exports.NotebookSubmissionDialog = NotebookSubmissionDialog;
//# sourceMappingURL=NotebookSubmissionDialog.js.map