import { IDictionary } from '@elyra/application';
export declare const RUNTIMES_NAMESPACE = "runtimes";
export declare const KFP_SCHEMA = "kfp";
export declare const RUNTIME_IMAGES_NAMESPACE = "runtime-images";
export declare const RUNTIME_IMAGE_SCHEMA = "runtime-image";
export interface IRuntime {
    name: string;
    display_name: string;
}
export declare class PipelineService {
    /**
     * Returns a list of external runtime configurations available as
     * `runtimes metadata`. This is used to submit the pipeline to be
     * executed on these runtimes.
     */
    static getRuntimes(showError?: boolean): Promise<any>;
    /**
     * Return a list of configured docker images that are used as runtimes environments
     * to run the pipeline nodes.
     */
    static getRuntimeImages(): Promise<any>;
    static getDisplayName(name: string, metadataArr: IDictionary<any>[]): string;
    /**
     * The runtime name is currently based on the schema name (one schema per runtime)
     * @param name
     * @param metadataArr
     */
    static getRuntimeName(name: string, metadataArr: IDictionary<any>[]): string;
    /**
     * Submit the pipeline to be executed on an external runtime (e.g. Kbeflow Pipelines)
     *
     * @param pipeline
     * @param runtimeName
     */
    static submitPipeline(pipeline: any, runtimeName: string): Promise<any>;
    /**
     * Export a pipeline to different formats (e.g. DSL, YAML, etc). These formats
     * are understood by a given runtime.
     *
     * @param pipeline
     * @param pipeline_export_format
     * @param pipeline_export_path
     * @param overwrite
     */
    static exportPipeline(pipeline: any, pipeline_export_format: string, pipeline_export_path: string, overwrite: boolean): Promise<any>;
    /**
     * Verify if the given pipeline is "current" by looking on it's version, and perform
     * any conversion if needed.
     *
     * @param pipelineDefinition
     */
    static convertPipeline(pipelineDefinition: any, pipelinePath: string): any;
    private static convertPipelineV0toV1;
    private static convertPipelineV1toV2;
    private static convertPipelineV2toV3;
    static getPipelineRelativeNodePath(pipelinePath: string, nodePath: string): string;
    static getWorkspaceRelativeNodePath(pipelinePath: string, nodePath: string): string;
    static setNodePathsRelativeToPipeline(pipeline: any, pipelinePath: string): any;
    static setNodePathsRelativeToWorkspace(pipeline: any, pipelinePath: string): any;
}
