import { DocumentRegistry } from '@jupyterlab/docregistry';
import { Contents } from '@jupyterlab/services';
import { LabIcon } from '@jupyterlab/ui-components';
export declare class CanvasManager {
    canvasController: any;
    widgetContext: DocumentRegistry.Context;
    constructor(widgetContext: DocumentRegistry.Context, canvasController: any);
    /**
     * Check if a given file is allowed to be added to the pipeline
     * @param item
     */
    isSupportedNode(file: Contents.IModel): boolean;
    addNode(file: Contents.IModel, fileContent: string, x: number, y: number): boolean;
    static getOperationName(filepath: string): string;
    static getNodeIcon(filepath: string): LabIcon;
    private static getNodeType;
}
