"use strict";
/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const application_1 = require("@elyra/application");
const ui_components_1 = require("@elyra/ui-components");
const ui_components_2 = require("@jupyterlab/ui-components");
const PipelineService_1 = require("./PipelineService");
var ContentType;
(function (ContentType) {
    ContentType["notebook"] = "notebook";
    ContentType["python"] = "python";
    ContentType["other"] = "other";
})(ContentType || (ContentType = {}));
const CONTENT_TYPE_MAPPER = new Map([
    ['.py', ContentType.python],
    ['.ipynb', ContentType.notebook]
]);
const ICON_MAPPER = new Map([
    ['.py', ui_components_2.pythonIcon],
    ['.ipynb', ui_components_2.notebookIcon]
]);
class CanvasManager {
    constructor(widgetContext, canvasController) {
        this.widgetContext = widgetContext;
        this.canvasController = canvasController;
    }
    /**
     * Check if a given file is allowed to be added to the pipeline
     * @param item
     */
    isSupportedNode(file) {
        if (CanvasManager.getNodeType(file.path)) {
            return true;
        }
        else {
            return false;
        }
    }
    addNode(file, fileContent, x, y) {
        console.log('Adding ==> ' + file.path);
        const nodeTemplate = this.canvasController.getPaletteNode(CanvasManager.getOperationName(file.path));
        if (nodeTemplate) {
            const data = {
                editType: 'createNode',
                offsetX: x,
                offsetY: y,
                nodeTemplate: this.canvasController.convertNodeTemplate(nodeTemplate)
            };
            let env_vars;
            if (CanvasManager.getNodeType(file.path) == ContentType.notebook) {
                env_vars = application_1.NotebookParser.getEnvVars(fileContent).map(str => str + '=');
            }
            data.nodeTemplate.label = path.basename(file.path);
            data.nodeTemplate.image = ui_components_1.IconUtil.encode(CanvasManager.getNodeIcon(file.path));
            data.nodeTemplate.app_data['filename'] = PipelineService_1.PipelineService.getPipelineRelativeNodePath(this.widgetContext.path, file.path);
            data.nodeTemplate.app_data['runtime_image'] = '';
            data.nodeTemplate.app_data['env_vars'] = env_vars;
            data.nodeTemplate.app_data['include_subdirectories'] = false;
            this.canvasController.editActionHandler(data);
            return true;
        }
        else {
            return false;
        }
    }
    static getOperationName(filepath) {
        const type = CanvasManager.getNodeType(filepath);
        return `execute-${type}-node`;
    }
    static getNodeIcon(filepath) {
        const extension = path.extname(filepath);
        const icon = ICON_MAPPER.get(extension);
        // TODO: throw error when file extension is not supported?
        return icon;
    }
    // Private
    static getNodeType(filepath) {
        const extension = path.extname(filepath);
        const type = CONTENT_TYPE_MAPPER.get(extension);
        // TODO: throw error when file extension is not supported?
        return type;
    }
}
exports.CanvasManager = CanvasManager;
//# sourceMappingURL=canvas.js.map