"use strict";
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
const is_heading_filtered_1 = require("./is_heading_filtered");
/**
 * Appends a notebook heading to a list of headings.
 *
 * @private
 * @param headings - list of notebook headings
 * @param heading - rendered heading
 * @param prev - previous heading
 * @param collapseLevel - collapse level
 * @param tags - filter tags
 * @returns result tuple
 */
function appendHeading(headings, heading, prev, collapseLevel, tags) {
    if (heading && !is_heading_filtered_1.isHeadingFiltered(heading, tags) && heading.text) {
        // Determine whether this heading is a child of a "header" notebook heading...
        if (prev && prev.type === 'header') {
            for (let j = headings.length - 1; j >= 0; j--) {
                if (headings[j] === prev) {
                    // TODO: can a heading be the child of multiple headings? If not, we can `break` here upon finding a parent heading, so we don't traverse the entire heading list...
                    headings[j].hasChild = true;
                }
            }
        }
        if (collapseLevel < 0) {
            headings.push(heading);
        }
        prev = heading;
    }
    return [headings, prev];
}
exports.appendHeading = appendHeading;
