import { Cell } from '@jupyterlab/cells';
import { INotebookHeading } from '../../utils/headings';
/**
 * Returns a "click" handler.
 *
 * @private
 * @param line - line number
 * @returns "click" handler
 */
declare type onClickFactory = (line: number) => () => void;
/**
 * Returns a code entry notebook heading from a code string.
 *
 * @private
 * @param text - code string
 * @param onClick - callback which returns a "click" handler
 * @param executionCount - execution count
 * @param lastLevel - last heading level
 * @param cellRef - cell reference
 * @returns notebook heading
 */
declare function getCodeCellHeading(text: string, onClick: onClickFactory, executionCount: string, lastLevel: number, cellRef: Cell): INotebookHeading;
/**
 * Exports.
 */
export { getCodeCellHeading };
