import { CodeEditor } from '@jupyterlab/codeeditor';
import { Kernel, KernelManager, KernelSpec, KernelSpecManager } from '@jupyterlab/services';
/**
 * Class: An enhanced Python Script Editor that enables developing and running the script
 */
export declare class PythonRunner {
    kernelSpecManager: KernelSpecManager;
    kernelManager: KernelManager;
    kernel: Kernel.IKernelConnection;
    model: CodeEditor.IModel;
    disableRun: Function;
    /**
     * Construct a new runner.
     */
    constructor(model: CodeEditor.IModel, disableRun: Function);
    private errorDialog;
    /**
     * Function: Starts a python kernel and executes code from file editor.
     */
    runPython: (kernelName: string, handleKernelMsg: Function) => Promise<any>;
    /**
     * Function: Gets available kernel specs.
     */
    getKernelSpecs: () => Promise<KernelSpec.ISpecModels>;
    /**
     * Function: Starts new kernel.
     */
    startKernel: (options: Partial<Pick<Kernel.IModel, "name">>) => Promise<Kernel.IKernelConnection>;
    /**
     * Function: Shuts down kernel.
     */
    shutDownKernel: () => Promise<void>;
}
