from ck.pgm import PGM


class Mildew(PGM):

    def __init__(self):
        super().__init__(self.__class__.__name__)

        pgm_rv0 = self.new_rv('dm_1', (
            '0_00_kg_m2', '0_02_kg_m2', '0_04_kg_m2', '0_06_kg_m2', '0_08_kg_m2', '0_10_kg_m2', '0_12_kg_m2',
            '0_14_kg_m2', '0_16_kg_m2', '0_18_kg_m2', '0_20_kg_m2', '0_22_kg_m2', '0_24_kg_m2', '0_26_kg_m2',
            '0_28_kg_m2',
            '0_30_kg_m2', '0_32_kg_m2', '0_34_kg_m2', '0_36_kg_m2', '0_38_kg_m2', '0_40_kg_m2', '0_42_kg_m2',
            '0_44_kg_m2',
            '0_46_kg_m2', '0_48_kg_m2', '0_50_kg_m2', '0_52_kg_m2', '0_54_kg_m2', '0_56_kg_m2', '0_58_kg_m2',
            '0_60_kg_m2',
            '0_62_kg_m2'))
        pgm_rv1 = self.new_rv('foto_1', (
            '0_00_kg_m2', '0_05_kg_m2', '0_10_kg_m2', '0_15_kg_m2', '0_20_kg_m2', '0_25_kg_m2', '0_30_kg_m2',
            '0_35_kg_m2', '0_40_kg_m2', '0_45_kg_m2', '0_50_kg_m2', '0_55_kg_m2', '0_60_kg_m2', '0_65_kg_m2',
            '0_70_kg_m2',
            '0_75_kg_m2', '0_80_kg_m2', '0_85_kg_m2', '0_90_kg_m2', '0_95_kg_m2'))
        pgm_rv2 = self.new_rv('straaling_1', ('___150_MJ_m2', '150___199_MJ_m2', '200___249_MJ_m2', '____250_MJ_m2'))
        pgm_rv3 = self.new_rv('temp_1', ('___13_0_C', '13_0___14_9_C', '15_0___16_9_C', '____17_0_C'))
        pgm_rv4 = self.new_rv('lai_1', (
            '0_0___0_5', '0_5___1_5', '1_5___2_5', '2_5___3_5', '3_5___4_5', '4_5___5_5', '5_5___6_5', '___6_5'))
        pgm_rv5 = self.new_rv('meldug_1', (
            '0_00___0_01__', '0_01___0_5__', '0_5___1__', '1___2__', '2___6__', '6___10__', '10___25__', '25___50__',
            '50___100__'))
        pgm_rv6 = self.new_rv('lai_0', (
            '0_0___0_5', '0_5___1_5', '1_5___2_5', '2_5___3_5', '3_5___4_5', '4_5___5_5', '5_5___6_5', '___6_5'))
        pgm_rv7 = self.new_rv('dm_2', (
            '0_00_kg_m2', '0_02_kg_m2', '0_04_kg_m2', '0_06_kg_m2', '0_08_kg_m2', '0_10_kg_m2', '0_12_kg_m2',
            '0_14_kg_m2', '0_16_kg_m2', '0_18_kg_m2', '0_20_kg_m2', '0_22_kg_m2', '0_24_kg_m2', '0_26_kg_m2',
            '0_28_kg_m2',
            '0_30_kg_m2', '0_32_kg_m2', '0_34_kg_m2', '0_36_kg_m2', '0_38_kg_m2', '0_40_kg_m2', '0_42_kg_m2',
            '0_44_kg_m2',
            '0_46_kg_m2', '0_48_kg_m2', '0_50_kg_m2', '0_52_kg_m2', '0_54_kg_m2', '0_56_kg_m2', '0_58_kg_m2',
            '0_60_kg_m2',
            '0_62_kg_m2', '0_64_kg_m2', '0_66_kg_m2', '0_68_kg_m2', '0_70_kg_m2', '0_72_kg_m2', '0_74_kg_m2',
            '0_76_kg_m2',
            '0_78_kg_m2', '0_80_kg_m2', '0_82_kg_m2', '0_84_kg_m2', '0_86_kg_m2', '0_88_kg_m2', '0_90_kg_m2',
            '0_92_kg_m2',
            '0_94_kg_m2',
            '0_96_kg_m2', '0_98_kg_m2', '1_00_kg_m2', '1_02_kg_m2', '1_04_kg_m2', '1_06_kg_m2', '1_08_kg_m2',
            '1_10_kg_m2', '1_12_kg_m2', '1_14_kg_m2', '1_16_kg_m2', '1_18_kg_m2', '1_20_kg_m2'))
        pgm_rv8 = self.new_rv('foto_2', (
            '0_00_kg_m2', '0_05_kg_m2', '0_10_kg_m2', '0_15_kg_m2', '0_20_kg_m2', '0_25_kg_m2', '0_30_kg_m2',
            '0_35_kg_m2',
            '0_40_kg_m2', '0_45_kg_m2', '0_50_kg_m2', '0_55_kg_m2', '0_60_kg_m2', '0_65_kg_m2', '0_70_kg_m2',
            '0_75_kg_m2',
            '0_80_kg_m2', '0_85_kg_m2', '0_90_kg_m2', '0_95_kg_m2'))
        pgm_rv9 = self.new_rv('straaling_2', ('___150_MJ_m2', '150___199_MJ_m2', '200___249_MJ_m2', '____250_MJ_m2'))
        pgm_rv10 = self.new_rv('temp_2', ('___13_0_C', '13_0___14_9_C', '15_0___16_9_C', '____17_0_C'))
        pgm_rv11 = self.new_rv('lai_2', (
            '0_0___0_5', '0_5___1_5', '1_5___2_5', '2_5___3_5', '3_5___4_5', '4_5___5_5', '5_5___6_5', '___6_5'))
        pgm_rv12 = self.new_rv('meldug_2', (
            '0_00___0_01__', '0_01___0_5__', '0_5___1__', '1___2__', '2___6__', '6___10__', '10___25__', '25___50__',
            '50___100__'))
        pgm_rv13 = self.new_rv('dm_3', (
            '0_00_kg_m2', '0_02_kg_m2', '0_04_kg_m2', '0_06_kg_m2', '0_08_kg_m2', '0_10_kg_m2', '0_12_kg_m2',
            '0_14_kg_m2',
            '0_16_kg_m2', '0_18_kg_m2', '0_20_kg_m2', '0_22_kg_m2', '0_24_kg_m2', '0_26_kg_m2', '0_28_kg_m2',
            '0_30_kg_m2',
            '0_32_kg_m2', '0_34_kg_m2', '0_36_kg_m2', '0_38_kg_m2', '0_40_kg_m2', '0_42_kg_m2', '0_44_kg_m2',
            '0_46_kg_m2',
            '0_48_kg_m2', '0_50_kg_m2', '0_52_kg_m2', '0_54_kg_m2', '0_56_kg_m2', '0_58_kg_m2', '0_60_kg_m2',
            '0_62_kg_m2',
            '0_64_kg_m2', '0_66_kg_m2', '0_68_kg_m2', '0_70_kg_m2', '0_72_kg_m2', '0_74_kg_m2', '0_76_kg_m2',
            '0_78_kg_m2',
            '0_80_kg_m2', '0_82_kg_m2', '0_84_kg_m2', '0_86_kg_m2', '0_88_kg_m2', '0_90_kg_m2', '0_92_kg_m2',
            '0_94_kg_m2',
            '0_96_kg_m2', '0_98_kg_m2', '1_00_kg_m2', '1_02_kg_m2', '1_04_kg_m2', '1_06_kg_m2', '1_08_kg_m2',
            '1_10_kg_m2',
            '1_12_kg_m2', '1_14_kg_m2', '1_16_kg_m2', '1_18_kg_m2', '1_20_kg_m2', '1_22_kg_m2', '1_24_kg_m2',
            '1_26_kg_m2',
            '1_28_kg_m2', '1_30_kg_m2', '1_32_kg_m2', '1_34_kg_m2', '1_36_kg_m2', '1_38_kg_m2', '1_40_kg_m2',
            '1_42_kg_m2',
            '1_44_kg_m2', '1_46_kg_m2', '1_48_kg_m2', '1_50_kg_m2', '1_52_kg_m2', '1_54_kg_m2', '1_56_kg_m2',
            '1_58_kg_m2',
            '1_60_kg_m2', '1_62_kg_m2', '1_64_kg_m2', '1_66_kg_m2', '1_68_kg_m2', '1_70_kg_m2', '1_72_kg_m2',
            '1_74_kg_m2',
            '1_76_kg_m2', '1_78_kg_m2', '1_80_kg_m2', '1_82_kg_m2', '1_84_kg_m2', '1_86_kg_m2', '1_88_kg_m2',
            '1_90_kg_m2',
            '1_92_kg_m2', '1_94_kg_m2', '1_96_kg_m2', '1_98_kg_m2'))
        pgm_rv14 = self.new_rv('foto_3', (
            '0_00_kg_m2', '0_05_kg_m2', '0_10_kg_m2', '0_15_kg_m2', '0_20_kg_m2', '0_25_kg_m2', '0_30_kg_m2',
            '0_35_kg_m2',
            '0_40_kg_m2', '0_45_kg_m2', '0_50_kg_m2', '0_55_kg_m2', '0_60_kg_m2', '0_65_kg_m2', '0_70_kg_m2',
            '0_75_kg_m2',
            '0_80_kg_m2', '0_85_kg_m2', '0_90_kg_m2', '0_95_kg_m2', '1_00_kg_m2', '1_05_kg_m2', '1_10_kg_m2',
            '1_15_kg_m2',
            '1_20_kg_m2', '1_25_kg_m2', '1_30_kg_m2', '1_35_kg_m2', '1_40_kg_m2', '1_45_kg_m2', '1_50_kg_m2',
            '1_55_kg_m2',
            '1_60_kg_m2'))
        pgm_rv15 = self.new_rv('straaling_3', ('___300_MJ_m2', '300___349_MJ_m2', '350___399_MJ_m2', '____400_MJ_m2'))
        pgm_rv16 = self.new_rv('temp_3', ('___13_0_C', '13_0___14_9_C', '15_0___16_9_C', '____17_0_C'))
        pgm_rv17 = self.new_rv('lai_3',
                               ('0_0___0_5', '0_5___1_5', '1_5___2_5', '2_5___3_5', '3_5___4_5', '4_5___5_5',
                                '5_5___6_5'))
        pgm_rv18 = self.new_rv('meldug_3', (
            '0_00___0_01__', '0_01___0_5__', '0_5___1__', '1___2__', '2___6__', '6___10__', '10___25__', '25___50__',
            '50___100__'))
        pgm_rv19 = self.new_rv('dm_4', (
            '0_00_kg_m2', '0_02_kg_m2', '0_04_kg_m2', '0_06_kg_m2', '0_08_kg_m2', '0_10_kg_m2', '0_12_kg_m2',
            '0_14_kg_m2',
            '0_16_kg_m2', '0_18_kg_m2', '0_20_kg_m2', '0_22_kg_m2', '0_24_kg_m2', '0_26_kg_m2', '0_28_kg_m2',
            '0_30_kg_m2',
            '0_32_kg_m2', '0_34_kg_m2', '0_36_kg_m2', '0_38_kg_m2', '0_40_kg_m2', '0_42_kg_m2', '0_44_kg_m2',
            '0_46_kg_m2',
            '0_48_kg_m2', '0_50_kg_m2', '0_52_kg_m2', '0_54_kg_m2', '0_56_kg_m2', '0_58_kg_m2', '0_60_kg_m2',
            '0_62_kg_m2',
            '0_64_kg_m2', '0_66_kg_m2', '0_68_kg_m2', '0_70_kg_m2', '0_72_kg_m2', '0_74_kg_m2', '0_76_kg_m2',
            '0_78_kg_m2',
            '0_80_kg_m2', '0_82_kg_m2', '0_84_kg_m2', '0_86_kg_m2', '0_88_kg_m2', '0_90_kg_m2', '0_92_kg_m2',
            '0_94_kg_m2',
            '0_96_kg_m2', '0_98_kg_m2', '1_00_kg_m2', '1_02_kg_m2', '1_04_kg_m2', '1_06_kg_m2', '1_08_kg_m2',
            '1_10_kg_m2',
            '1_12_kg_m2', '1_14_kg_m2', '1_16_kg_m2', '1_18_kg_m2', '1_20_kg_m2', '1_22_kg_m2', '1_24_kg_m2',
            '1_26_kg_m2',
            '1_28_kg_m2', '1_30_kg_m2', '1_32_kg_m2', '1_34_kg_m2', '1_36_kg_m2', '1_38_kg_m2', '1_40_kg_m2',
            '1_42_kg_m2',
            '1_44_kg_m2', '1_46_kg_m2', '1_48_kg_m2', '1_50_kg_m2', '1_52_kg_m2', '1_54_kg_m2', '1_56_kg_m2',
            '1_58_kg_m2',
            '1_60_kg_m2', '1_62_kg_m2', '1_64_kg_m2', '1_66_kg_m2', '1_68_kg_m2', '1_70_kg_m2', '1_72_kg_m2',
            '1_74_kg_m2',
            '1_76_kg_m2', '1_78_kg_m2', '1_80_kg_m2', '1_82_kg_m2', '1_84_kg_m2', '1_86_kg_m2', '1_88_kg_m2',
            '1_90_kg_m2',
            '1_92_kg_m2', '1_94_kg_m2', '1_96_kg_m2', '1_98_kg_m2'))
        pgm_rv20 = self.new_rv('foto_4', (
            '0_00_kg_m2', '0_05_kg_m2', '0_10_kg_m2', '0_15_kg_m2', '0_20_kg_m2', '0_25_kg_m2', '0_30_kg_m2',
            '0_35_kg_m2',
            '0_40_kg_m2', '0_45_kg_m2', '0_50_kg_m2', '0_55_kg_m2', '0_60_kg_m2', '0_65_kg_m2', '0_70_kg_m2',
            '0_75_kg_m2',
            '0_80_kg_m2', '0_85_kg_m2', '0_90_kg_m2', '0_95_kg_m2', '1_00_kg_m2', '1_05_kg_m2', '1_10_kg_m2',
            '1_15_kg_m2',
            '1_20_kg_m2', '1_25_kg_m2', '1_30_kg_m2', '1_35_kg_m2'))
        pgm_rv21 = self.new_rv('straaling_4', ('___300_MJ_m2', '300___349_MJ_m2', '350___399_MJ_m2', '____400_MJ_m2'))
        pgm_rv22 = self.new_rv('temp_4', ('___13_0_C', '13_0___14_9_C', '15_0___16_9_C', '____17_0_C'))
        pgm_rv23 = self.new_rv('lai_4', ('0_0___0_5', '0_5___1_5', '1_5___2_5', '2_5___3_5'))
        pgm_rv24 = self.new_rv('meldug_4', (
            '0_00___0_01__', '0_01___0_5__', '0_5___1__', '1___2__', '2___6__', '6___10__', '10___25__', '25___50__',
            '50___100__'))
        pgm_rv25 = self.new_rv('mikro_1', ('T_rt_og_koldt', 'V_dt_og_koldt', 'T_rt_og_varmt', 'V_dt_og_varmt'))
        pgm_rv26 = self.new_rv('middel_1', ('0_l_ha', '0_25_l_ha', '0_50_l_ha', '0_75_l_ha'))
        pgm_rv27 = self.new_rv('mikro_2', ('T_rt_og_koldt', 'V_dt_og_koldt', 'T_rt_og_varmt', 'V_dt_og_varmt'))
        pgm_rv28 = self.new_rv('middel_2', ('0_l_ha', '0_25_l_ha', '0_50_l_ha', '0_75_l_ha'))
        pgm_rv29 = self.new_rv('mikro_3', ('T_rt_og_koldt', 'V_dt_og_koldt', 'T_rt_og_varmt', 'V_dt_og_varmt'))
        pgm_rv30 = self.new_rv('middel_3', ('0_l_ha', '0_25_l_ha', '0_50_l_ha', '0_75_l_ha'))
        pgm_rv31 = self.new_rv('nedboer_1', ('0___1', '2___3', '____4'))
        pgm_rv32 = self.new_rv('nedboer_2', ('0___1', '2___3', '____4'))
        pgm_rv33 = self.new_rv('nedboer_3', ('0___1', '2___3', '____4'))
        pgm_rv34 = self.new_rv('udbytte', (
            '0___1_hkg_ha', '1___3_hkg_ha', '3___5_hkg_ha', '5___7_hkg_ha', '7___9_hkg_ha', '9___11_hkg_ha',
            '11___13_hkg_ha',
            '13___15_hkg_ha', '15___17_hkg_ha', '17___19_hkg_ha', '19___21_hkg_ha', '21___23_hkg_ha', '23___25_hkg_ha',
            '25___27_hkg_ha', '27___29_hkg_ha', '29___31_hkg_ha', '31___33_hkg_ha', '33___35_hkg_ha', '35___37_hkg_ha',
            '37___39_hkg_ha', '39___41_hkg_ha', '41___43_hkg_ha', '43___45_hkg_ha', '45___47_hkg_ha', '47___49_hkg_ha',
            '49___51_hkg_ha', '51___53_hkg_ha', '53___55_hkg_ha', '55___57_hkg_ha', '57___59_hkg_ha', '59___61_hkg_ha',
            '61___63_hkg_ha', '63___65_hkg_ha', '65___67_hkg_ha', '67___69_hkg_ha', '69___71_hkg_ha', '71___73_hkg_ha',
            '73___75_hkg_ha', '75___77_hkg_ha', '77___79_hkg_ha', '79___81_hkg_ha', '81___83_hkg_ha', '83___85_hkg_ha',
            '85___87_hkg_ha', '87___89_hkg_ha', '89___91_hkg_ha', '91___93_hkg_ha', '93___95_hkg_ha', '95___97_hkg_ha',
            '97___99_hkg_ha', '99___101_hkg_ha', '101___103_hkg_ha', '103___105_hkg_ha', '105___107_hkg_ha',
            '107___109_hkg_ha',
            '109___111_hkg_ha', '111___113_hkg_ha', '113___115_hkg_ha', '115___117_hkg_ha', '117___119_hkg_ha',
            '119___121_hkg_ha',
            '121___123_hkg_ha', '123___125_hkg_ha', '125___127_hkg_ha', '127___129_hkg_ha', '129___131_hkg_ha',
            '131___133_hkg_ha',
            '133___135_hkg_ha', '135___137_hkg_ha', '137___139_hkg_ha', '139___141_hkg_ha', '141___143_hkg_ha',
            '143___145_hkg_ha',
            '145___147_hkg_ha', '147___149_hkg_ha', '149___151_hkg_ha', '151___153_hkg_ha', '153___155_hkg_ha',
            '155___157_hkg_ha',
            '157___159_hkg_ha', '159___161_hkg_ha', '161___163_hkg_ha', '163___165_hkg_ha', '165___167_hkg_ha',
            '167___169_hkg_ha',
            '___169_hkg_ha'))
        pgm_factor0 = self.new_factor(pgm_rv0, pgm_rv1)
        pgm_factor1 = self.new_factor(pgm_rv1, pgm_rv4, pgm_rv3, pgm_rv2)
        pgm_factor2 = self.new_factor(pgm_rv2)
        pgm_factor3 = self.new_factor(pgm_rv3)
        pgm_factor4 = self.new_factor(pgm_rv4, pgm_rv6, pgm_rv5)
        pgm_factor5 = self.new_factor(pgm_rv5)
        pgm_factor6 = self.new_factor(pgm_rv6)
        pgm_factor7 = self.new_factor(pgm_rv7, pgm_rv8, pgm_rv0)
        pgm_factor8 = self.new_factor(pgm_rv8, pgm_rv11, pgm_rv10, pgm_rv9)
        pgm_factor9 = self.new_factor(pgm_rv9)
        pgm_factor10 = self.new_factor(pgm_rv10)
        pgm_factor11 = self.new_factor(pgm_rv11, pgm_rv4, pgm_rv12)
        pgm_factor12 = self.new_factor(pgm_rv12, pgm_rv26, pgm_rv25, pgm_rv5)
        pgm_factor13 = self.new_factor(pgm_rv13, pgm_rv14, pgm_rv7)
        pgm_factor14 = self.new_factor(pgm_rv14, pgm_rv17, pgm_rv16, pgm_rv15)
        pgm_factor15 = self.new_factor(pgm_rv15)
        pgm_factor16 = self.new_factor(pgm_rv16)
        pgm_factor17 = self.new_factor(pgm_rv17, pgm_rv11, pgm_rv18)
        pgm_factor18 = self.new_factor(pgm_rv18, pgm_rv28, pgm_rv27, pgm_rv12)
        pgm_factor19 = self.new_factor(pgm_rv19, pgm_rv20, pgm_rv13)
        pgm_factor20 = self.new_factor(pgm_rv20, pgm_rv23, pgm_rv22, pgm_rv21)
        pgm_factor21 = self.new_factor(pgm_rv21)
        pgm_factor22 = self.new_factor(pgm_rv22)
        pgm_factor23 = self.new_factor(pgm_rv23, pgm_rv17, pgm_rv24)
        pgm_factor24 = self.new_factor(pgm_rv24, pgm_rv30, pgm_rv29, pgm_rv18)
        pgm_factor25 = self.new_factor(pgm_rv25, pgm_rv4, pgm_rv3, pgm_rv31)
        pgm_factor26 = self.new_factor(pgm_rv26)
        pgm_factor27 = self.new_factor(pgm_rv27, pgm_rv11, pgm_rv10, pgm_rv32)
        pgm_factor28 = self.new_factor(pgm_rv28)
        pgm_factor29 = self.new_factor(pgm_rv29, pgm_rv17, pgm_rv16, pgm_rv33)
        pgm_factor30 = self.new_factor(pgm_rv30)
        pgm_factor31 = self.new_factor(pgm_rv31)
        pgm_factor32 = self.new_factor(pgm_rv32)
        pgm_factor33 = self.new_factor(pgm_rv33)
        pgm_factor34 = self.new_factor(pgm_rv34, pgm_rv19)

        pgm_function0 = pgm_factor0.set_sparse()
        pgm_function0[(0, 0)] = 1.0
        pgm_function0[(0, 1)] = 1.0
        pgm_function0[(0, 2)] = 0.8222
        pgm_function0[(0, 3)] = 0.16668315
        pgm_function0[(1, 2)] = 0.1778
        pgm_function0[(1, 3)] = 0.37776234
        pgm_function0[(1, 4)] = 0.0333
        pgm_function0[(2, 3)] = 0.36666333
        pgm_function0[(2, 4)] = 0.2333
        pgm_function0[(3, 3)] = 0.08889118
        pgm_function0[(3, 4)] = 0.4
        pgm_function0[(3, 5)] = 0.0556
        pgm_function0[(4, 4)] = 0.2778
        pgm_function0[(4, 5)] = 0.3
        pgm_function0[(5, 4)] = 0.0556
        pgm_function0[(5, 5)] = 0.4
        pgm_function0[(5, 6)] = 0.1222
        pgm_function0[(6, 5)] = 0.2333
        pgm_function0[(6, 6)] = 0.3444
        pgm_function0[(6, 7)] = 0.0222
        pgm_function0[(7, 5)] = 0.0111
        pgm_function0[(7, 6)] = 0.3778
        pgm_function0[(7, 7)] = 0.1667
        pgm_function0[(8, 6)] = 0.1556
        pgm_function0[(8, 7)] = 0.3889
        pgm_function0[(8, 8)] = 0.03330331
        pgm_function0[(9, 7)] = 0.3333
        pgm_function0[(9, 8)] = 0.23332307
        pgm_function0[(10, 7)] = 0.0889
        pgm_function0[(10, 8)] = 0.42224213
        pgm_function0[(10, 9)] = 0.0778
        pgm_function0[(11, 8)] = 0.26672708
        pgm_function0[(11, 9)] = 0.2889
        pgm_function0[(11, 10)] = 0.0111
        pgm_function0[(12, 8)] = 0.04440441
        pgm_function0[(12, 9)] = 0.4111
        pgm_function0[(12, 10)] = 0.1333
        pgm_function0[(13, 9)] = 0.2111
        pgm_function0[(13, 10)] = 0.3333
        pgm_function0[(13, 11)] = 0.0222
        pgm_function0[(14, 9)] = 0.0111
        pgm_function0[(14, 10)] = 0.3667
        pgm_function0[(14, 11)] = 0.1889
        pgm_function0[(15, 10)] = 0.1556
        pgm_function0[(15, 11)] = 0.3778
        pgm_function0[(15, 12)] = 0.04440441
        pgm_function0[(16, 11)] = 0.3333
        pgm_function0[(16, 12)] = 0.25562605
        pgm_function0[(17, 11)] = 0.0778
        pgm_function0[(17, 12)] = 0.41114108
        pgm_function0[(17, 13)] = 0.0889
        pgm_function0[(18, 12)] = 0.24442405
        pgm_function0[(18, 13)] = 0.2889
        pgm_function0[(18, 14)] = 0.0111
        pgm_function0[(19, 12)] = 0.04440441
        pgm_function0[(19, 13)] = 0.4111
        pgm_function0[(19, 14)] = 0.1333
        pgm_function0[(20, 13)] = 0.2
        pgm_function0[(20, 14)] = 0.3556
        pgm_function0[(20, 15)] = 0.0333
        pgm_function0[(21, 13)] = 0.0111
        pgm_function0[(21, 14)] = 0.3778
        pgm_function0[(21, 15)] = 0.2111
        pgm_function0[(22, 14)] = 0.1222
        pgm_function0[(22, 15)] = 0.3667
        pgm_function0[(22, 16)] = 0.05560566
        pgm_function0[(23, 15)] = 0.3222
        pgm_function0[(23, 16)] = 0.24442424
        pgm_function0[(24, 15)] = 0.0667
        pgm_function0[(24, 16)] = 0.42224242
        pgm_function0[(24, 17)] = 0.1
        pgm_function0[(25, 16)] = 0.23332323
        pgm_function0[(25, 17)] = 0.3333
        pgm_function0[(25, 18)] = 0.0222
        pgm_function0[(26, 16)] = 0.04440444
        pgm_function0[(26, 17)] = 0.3667
        pgm_function0[(26, 18)] = 0.1556
        pgm_function0[(27, 17)] = 0.1889
        pgm_function0[(27, 18)] = 0.3444
        pgm_function0[(27, 19)] = 0.0333
        pgm_function0[(28, 17)] = 0.0111
        pgm_function0[(28, 18)] = 0.3556
        pgm_function0[(28, 19)] = 0.2111
        pgm_function0[(29, 18)] = 0.1222
        pgm_function0[(29, 19)] = 0.3889
        pgm_function0[(30, 19)] = 0.3
        pgm_function0[(31, 19)] = 0.0667

        pgm_function1 = pgm_factor1.set_sparse()
        pgm_function1[(0, 0, 0, 0)] = 0.5999403
        pgm_function1[(0, 0, 0, 1)] = 0.58835829
        pgm_function1[(0, 0, 0, 2)] = 0.5167
        pgm_function1[(0, 0, 0, 3)] = 0.5
        pgm_function1[(0, 0, 1, 0)] = 0.6
        pgm_function1[(0, 0, 1, 1)] = 0.59
        pgm_function1[(0, 0, 1, 2)] = 0.5187
        pgm_function1[(0, 0, 1, 3)] = 0.5
        pgm_function1[(0, 0, 2, 0)] = 0.6
        pgm_function1[(0, 0, 2, 1)] = 0.59
        pgm_function1[(0, 0, 2, 2)] = 0.5223
        pgm_function1[(0, 0, 2, 3)] = 0.4999501
        pgm_function1[(0, 0, 3, 0)] = 0.6
        pgm_function1[(0, 0, 3, 1)] = 0.59
        pgm_function1[(0, 0, 3, 2)] = 0.52324748
        pgm_function1[(0, 0, 3, 3)] = 0.5
        pgm_function1[(1, 0, 0, 0)] = 0.17668209
        pgm_function1[(1, 0, 0, 1)] = 0.10931087
        pgm_function1[(1, 0, 0, 2)] = 0.1247
        pgm_function1[(1, 0, 0, 3)] = 0.1
        pgm_function1[(1, 0, 1, 0)] = 0.1843
        pgm_function1[(1, 0, 1, 1)] = 0.1133
        pgm_function1[(1, 0, 1, 2)] = 0.1303
        pgm_function1[(1, 0, 1, 3)] = 0.1007
        pgm_function1[(1, 0, 2, 0)] = 0.1897
        pgm_function1[(1, 0, 2, 1)] = 0.1157
        pgm_function1[(1, 0, 2, 2)] = 0.133
        pgm_function1[(1, 0, 2, 3)] = 0.10469
        pgm_function1[(1, 0, 3, 0)] = 0.1997
        pgm_function1[(1, 0, 3, 1)] = 0.1183
        pgm_function1[(1, 0, 3, 2)] = 0.13868586
        pgm_function1[(1, 0, 3, 3)] = 0.109
        pgm_function1[(2, 0, 0, 0)] = 0.1986801
        pgm_function1[(2, 0, 0, 1)] = 0.15531581
        pgm_function1[(2, 0, 0, 2)] = 0.124
        pgm_function1[(2, 0, 0, 3)] = 0.1107
        pgm_function1[(2, 0, 1, 0)] = 0.197
        pgm_function1[(2, 0, 1, 1)] = 0.1653
        pgm_function1[(2, 0, 1, 2)] = 0.13
        pgm_function1[(2, 0, 1, 3)] = 0.1187
        pgm_function1[(2, 0, 2, 0)] = 0.1983
        pgm_function1[(2, 0, 2, 1)] = 0.1767
        pgm_function1[(2, 0, 2, 2)] = 0.1387
        pgm_function1[(2, 0, 2, 3)] = 0.126687
        pgm_function1[(2, 0, 3, 0)] = 0.1923
        pgm_function1[(2, 0, 3, 1)] = 0.192
        pgm_function1[(2, 0, 3, 2)] = 0.14468586
        pgm_function1[(2, 0, 3, 3)] = 0.1353
        pgm_function1[(2, 1, 0, 0)] = 0.044
        pgm_function1[(2, 1, 1, 0)] = 0.062
        pgm_function1[(2, 1, 2, 0)] = 0.079691982
        pgm_function1[(2, 1, 3, 0)] = 0.10099
        pgm_function1[(3, 0, 0, 0)] = 0.02469751
        pgm_function1[(3, 0, 0, 1)] = 0.13531384
        pgm_function1[(3, 0, 0, 2)] = 0.1443
        pgm_function1[(3, 0, 0, 3)] = 0.12
        pgm_function1[(3, 0, 1, 0)] = 0.0187
        pgm_function1[(3, 0, 1, 1)] = 0.1257
        pgm_function1[(3, 0, 1, 2)] = 0.1547
        pgm_function1[(3, 0, 1, 3)] = 0.1283
        pgm_function1[(3, 0, 2, 0)] = 0.012
        pgm_function1[(3, 0, 2, 1)] = 0.1173
        pgm_function1[(3, 0, 2, 2)] = 0.1593
        pgm_function1[(3, 0, 2, 3)] = 0.138286
        pgm_function1[(3, 0, 3, 0)] = 0.008
        pgm_function1[(3, 0, 3, 1)] = 0.0997
        pgm_function1[(3, 0, 3, 2)] = 0.16368384
        pgm_function1[(3, 0, 3, 3)] = 0.1557
        pgm_function1[(3, 1, 0, 0)] = 0.288
        pgm_function1[(3, 1, 0, 1)] = 0.058
        pgm_function1[(3, 1, 1, 0)] = 0.323
        pgm_function1[(3, 1, 1, 1)] = 0.08999106
        pgm_function1[(3, 1, 1, 2)] = 0.004
        pgm_function1[(3, 1, 2, 0)] = 0.365662916
        pgm_function1[(3, 1, 2, 1)] = 0.123
        pgm_function1[(3, 1, 2, 2)] = 0.0133
        pgm_function1[(3, 1, 3, 0)] = 0.40965899
        pgm_function1[(3, 1, 3, 1)] = 0.1653
        pgm_function1[(3, 1, 3, 2)] = 0.028
        pgm_function1[(3, 2, 3, 0)] = 0.001000099
        pgm_function1[(4, 0, 0, 1)] = 0.01170119
        pgm_function1[(4, 0, 0, 2)] = 0.0873
        pgm_function1[(4, 0, 0, 3)] = 0.121
        pgm_function1[(4, 0, 1, 1)] = 0.0057
        pgm_function1[(4, 0, 1, 2)] = 0.0663
        pgm_function1[(4, 0, 1, 3)] = 0.1253
        pgm_function1[(4, 0, 2, 1)] = 0.0003
        pgm_function1[(4, 0, 2, 2)] = 0.0467
        pgm_function1[(4, 0, 2, 3)] = 0.118688
        pgm_function1[(4, 0, 3, 2)] = 0.02969697
        pgm_function1[(4, 0, 3, 3)] = 0.0993
        pgm_function1[(4, 1, 0, 0)] = 0.3743
        pgm_function1[(4, 1, 0, 1)] = 0.2317
        pgm_function1[(4, 1, 0, 2)] = 0.0827
        pgm_function1[(4, 1, 0, 3)] = 0.01030101
        pgm_function1[(4, 1, 1, 0)] = 0.397
        pgm_function1[(4, 1, 1, 1)] = 0.265673178
        pgm_function1[(4, 1, 1, 2)] = 0.1303
        pgm_function1[(4, 1, 1, 3)] = 0.0277
        pgm_function1[(4, 1, 2, 0)] = 0.402259907
        pgm_function1[(4, 1, 2, 1)] = 0.3117
        pgm_function1[(4, 1, 2, 2)] = 0.1737
        pgm_function1[(4, 1, 2, 3)] = 0.06000596
        pgm_function1[(4, 1, 3, 0)] = 0.38996099
        pgm_function1[(4, 1, 3, 1)] = 0.3517
        pgm_function1[(4, 1, 3, 2)] = 0.2263
        pgm_function1[(4, 1, 3, 3)] = 0.1023
        pgm_function1[(4, 2, 0, 0)] = 0.0347
        pgm_function1[(4, 2, 1, 0)] = 0.0743
        pgm_function1[(4, 2, 2, 0)] = 0.13
        pgm_function1[(4, 2, 3, 0)] = 0.205320815
        pgm_function1[(4, 3, 3, 0)] = 0.004999503
        pgm_function1[(5, 0, 0, 2)] = 0.003
        pgm_function1[(5, 0, 0, 3)] = 0.0483
        pgm_function1[(5, 0, 1, 3)] = 0.027
        pgm_function1[(5, 0, 2, 3)] = 0.0116988
        pgm_function1[(5, 0, 3, 3)] = 0.0007
        pgm_function1[(5, 1, 0, 0)] = 0.2397
        pgm_function1[(5, 1, 0, 1)] = 0.296
        pgm_function1[(5, 1, 0, 2)] = 0.2033
        pgm_function1[(5, 1, 0, 3)] = 0.11171115
        pgm_function1[(5, 1, 1, 0)] = 0.195
        pgm_function1[(5, 1, 1, 1)] = 0.335666225
        pgm_function1[(5, 1, 1, 2)] = 0.24
        pgm_function1[(5, 1, 1, 3)] = 0.159
        pgm_function1[(5, 1, 2, 0)] = 0.144685967
        pgm_function1[(5, 1, 2, 1)] = 0.356
        pgm_function1[(5, 1, 2, 2)] = 0.2837
        pgm_function1[(5, 1, 2, 3)] = 0.20632088
        pgm_function1[(5, 1, 3, 0)] = 0.0986901
        pgm_function1[(5, 1, 3, 1)] = 0.352
        pgm_function1[(5, 1, 3, 2)] = 0.322
        pgm_function1[(5, 1, 3, 3)] = 0.253
        pgm_function1[(5, 2, 0, 0)] = 0.3023
        pgm_function1[(5, 2, 0, 1)] = 0.00130013
        pgm_function1[(5, 2, 1, 0)] = 0.3957
        pgm_function1[(5, 2, 1, 1)] = 0.0157
        pgm_function1[(5, 2, 2, 0)] = 0.472
        pgm_function1[(5, 2, 2, 1)] = 0.0487
        pgm_function1[(5, 2, 3, 0)] = 0.516051536
        pgm_function1[(5, 2, 3, 1)] = 0.112310974
        pgm_function1[(5, 3, 0, 0)] = 0.03899609
        pgm_function1[(5, 3, 1, 0)] = 0.09230926
        pgm_function1[(5, 3, 2, 0)] = 0.1613
        pgm_function1[(5, 3, 3, 0)] = 0.245675147
        pgm_function1[(5, 4, 1, 0)] = 0.0093
        pgm_function1[(5, 4, 2, 0)] = 0.04129594
        pgm_function1[(5, 4, 3, 0)] = 0.08
        pgm_function1[(5, 5, 2, 0)] = 0.002
        pgm_function1[(5, 5, 3, 0)] = 0.02669731
        pgm_function1[(5, 6, 3, 0)] = 0.001
        pgm_function1[(6, 1, 0, 0)] = 0.0537
        pgm_function1[(6, 1, 0, 1)] = 0.276
        pgm_function1[(6, 1, 0, 2)] = 0.2493
        pgm_function1[(6, 1, 0, 3)] = 0.18331824
        pgm_function1[(6, 1, 1, 0)] = 0.023
        pgm_function1[(6, 1, 1, 1)] = 0.241976162
        pgm_function1[(6, 1, 1, 2)] = 0.292
        pgm_function1[(6, 1, 1, 3)] = 0.2263
        pgm_function1[(6, 1, 2, 0)] = 0.007699228
        pgm_function1[(6, 1, 2, 1)] = 0.1843
        pgm_function1[(6, 1, 2, 2)] = 0.3133
        pgm_function1[(6, 1, 2, 3)] = 0.26802684
        pgm_function1[(6, 1, 3, 0)] = 0.00069993
        pgm_function1[(6, 1, 3, 1)] = 0.1257
        pgm_function1[(6, 1, 3, 2)] = 0.2987
        pgm_function1[(6, 1, 3, 3)] = 0.306
        pgm_function1[(6, 2, 0, 0)] = 0.42
        pgm_function1[(6, 2, 0, 1)] = 0.105011
        pgm_function1[(6, 2, 1, 0)] = 0.3927
        pgm_function1[(6, 2, 1, 1)] = 0.2127
        pgm_function1[(6, 2, 1, 2)] = 0.0057
        pgm_function1[(6, 2, 2, 0)] = 0.33
        pgm_function1[(6, 2, 2, 1)] = 0.3303
        pgm_function1[(6, 2, 2, 2)] = 0.0367
        pgm_function1[(6, 2, 3, 0)] = 0.249324776
        pgm_function1[(6, 2, 3, 1)] = 0.427742902
        pgm_function1[(6, 2, 3, 2)] = 0.1053
        pgm_function1[(6, 2, 3, 3)] = 0.002
        pgm_function1[(6, 3, 0, 0)] = 0.27497295
        pgm_function1[(6, 3, 1, 0)] = 0.37233722
        pgm_function1[(6, 3, 1, 1)] = 0.00170017
        pgm_function1[(6, 3, 2, 0)] = 0.4457
        pgm_function1[(6, 3, 2, 1)] = 0.0217
        pgm_function1[(6, 3, 3, 0)] = 0.475652285
        pgm_function1[(6, 3, 3, 1)] = 0.071
        pgm_function1[(6, 4, 0, 0)] = 0.12998703
        pgm_function1[(6, 4, 1, 0)] = 0.212
        pgm_function1[(6, 4, 2, 0)] = 0.28567129
        pgm_function1[(6, 4, 3, 0)] = 0.3733
        pgm_function1[(6, 5, 0, 0)] = 0.0653
        pgm_function1[(6, 5, 1, 0)] = 0.122
        pgm_function1[(6, 5, 2, 0)] = 0.2003
        pgm_function1[(6, 5, 3, 0)] = 0.2556741
        pgm_function1[(6, 6, 0, 0)] = 0.041
        pgm_function1[(6, 6, 1, 0)] = 0.0797
        pgm_function1[(6, 6, 2, 0)] = 0.13798607
        pgm_function1[(6, 6, 3, 0)] = 0.206
        pgm_function1[(6, 7, 0, 0)] = 0.02399759
        pgm_function1[(6, 7, 1, 0)] = 0.0603
        pgm_function1[(6, 7, 2, 0)] = 0.0987
        pgm_function1[(6, 7, 3, 0)] = 0.1623
        pgm_function1[(7, 1, 0, 0)] = 0.0003
        pgm_function1[(7, 1, 0, 1)] = 0.121
        pgm_function1[(7, 1, 0, 2)] = 0.2597
        pgm_function1[(7, 1, 0, 3)] = 0.22232229
        pgm_function1[(7, 1, 1, 1)] = 0.064993544
        pgm_function1[(7, 1, 1, 2)] = 0.2327
        pgm_function1[(7, 1, 1, 3)] = 0.2643
        pgm_function1[(7, 1, 2, 1)] = 0.025
        pgm_function1[(7, 1, 2, 2)] = 0.181
        pgm_function1[(7, 1, 2, 3)] = 0.27502783
        pgm_function1[(7, 1, 3, 1)] = 0.0053
        pgm_function1[(7, 1, 3, 2)] = 0.1187
        pgm_function1[(7, 1, 3, 3)] = 0.2387
        pgm_function1[(7, 2, 0, 0)] = 0.2043
        pgm_function1[(7, 2, 0, 1)] = 0.33403301
        pgm_function1[(7, 2, 0, 2)] = 0.043
        pgm_function1[(7, 2, 1, 0)] = 0.129
        pgm_function1[(7, 2, 1, 1)] = 0.408
        pgm_function1[(7, 2, 1, 2)] = 0.1343
        pgm_function1[(7, 2, 1, 3)] = 0.005
        pgm_function1[(7, 2, 2, 0)] = 0.068
        pgm_function1[(7, 2, 2, 1)] = 0.411
        pgm_function1[(7, 2, 2, 2)] = 0.2543
        pgm_function1[(7, 2, 2, 3)] = 0.0447
        pgm_function1[(7, 2, 3, 0)] = 0.028302775
        pgm_function1[(7, 2, 3, 1)] = 0.356335918
        pgm_function1[(7, 2, 3, 2)] = 0.359
        pgm_function1[(7, 2, 3, 3)] = 0.1247
        pgm_function1[(7, 3, 0, 0)] = 0.39865992
        pgm_function1[(7, 3, 0, 1)] = 0.0463
        pgm_function1[(7, 3, 1, 0)] = 0.36973722
        pgm_function1[(7, 3, 1, 1)] = 0.141314
        pgm_function1[(7, 3, 2, 0)] = 0.3133
        pgm_function1[(7, 3, 2, 1)] = 0.2547
        pgm_function1[(7, 3, 2, 2)] = 0.001
        pgm_function1[(7, 3, 3, 0)] = 0.242976146
        pgm_function1[(7, 3, 3, 1)] = 0.3593
        pgm_function1[(7, 3, 3, 2)] = 0.024
        pgm_function1[(7, 4, 0, 0)] = 0.33866607
        pgm_function1[(7, 4, 1, 0)] = 0.4043
        pgm_function1[(7, 4, 1, 1)] = 0.01170122
        pgm_function1[(7, 4, 2, 0)] = 0.41565842
        pgm_function1[(7, 4, 2, 1)] = 0.06669323
        pgm_function1[(7, 4, 3, 0)] = 0.3843
        pgm_function1[(7, 4, 3, 1)] = 0.140014052
        pgm_function1[(7, 5, 0, 0)] = 0.2553
        pgm_function1[(7, 5, 1, 0)] = 0.3437
        pgm_function1[(7, 5, 2, 0)] = 0.4037
        pgm_function1[(7, 5, 2, 1)] = 0.004
        pgm_function1[(7, 5, 3, 0)] = 0.42265817
        pgm_function1[(7, 5, 3, 1)] = 0.04330428
        pgm_function1[(7, 6, 0, 0)] = 0.207
        pgm_function1[(7, 6, 1, 0)] = 0.2883
        pgm_function1[(7, 6, 2, 0)] = 0.35666418
        pgm_function1[(7, 6, 3, 0)] = 0.408
        pgm_function1[(7, 6, 3, 1)] = 0.0033
        pgm_function1[(7, 7, 0, 0)] = 0.18398193
        pgm_function1[(7, 7, 1, 0)] = 0.247
        pgm_function1[(7, 7, 2, 0)] = 0.3263
        pgm_function1[(7, 7, 3, 0)] = 0.372
        pgm_function1[(8, 1, 0, 1)] = 0.0173
        pgm_function1[(8, 1, 0, 2)] = 0.1563
        pgm_function1[(8, 1, 0, 3)] = 0.2343233
        pgm_function1[(8, 1, 1, 1)] = 0.001699831
        pgm_function1[(8, 1, 1, 2)] = 0.093
        pgm_function1[(8, 1, 1, 3)] = 0.21
        pgm_function1[(8, 1, 2, 2)] = 0.035
        pgm_function1[(8, 1, 2, 3)] = 0.15431491
        pgm_function1[(8, 1, 3, 2)] = 0.0063
        pgm_function1[(8, 1, 3, 3)] = 0.0963
        pgm_function1[(8, 2, 0, 0)] = 0.0387
        pgm_function1[(8, 2, 0, 1)] = 0.35133501
        pgm_function1[(8, 2, 0, 2)] = 0.2133
        pgm_function1[(8, 2, 0, 3)] = 0.026
        pgm_function1[(8, 2, 1, 0)] = 0.0083
        pgm_function1[(8, 2, 1, 1)] = 0.2773
        pgm_function1[(8, 2, 1, 2)] = 0.332
        pgm_function1[(8, 2, 1, 3)] = 0.1117
        pgm_function1[(8, 2, 2, 1)] = 0.185
        pgm_function1[(8, 2, 2, 2)] = 0.3847
        pgm_function1[(8, 2, 2, 3)] = 0.2217
        pgm_function1[(8, 2, 3, 1)] = 0.101309977
        pgm_function1[(8, 2, 3, 2)] = 0.354
        pgm_function1[(8, 2, 3, 3)] = 0.3263
        pgm_function1[(8, 3, 0, 0)] = 0.22867695
        pgm_function1[(8, 3, 0, 1)] = 0.2507
        pgm_function1[(8, 3, 0, 2)] = 0.0017
        pgm_function1[(8, 3, 1, 0)] = 0.15331509
        pgm_function1[(8, 3, 1, 1)] = 0.35733601
        pgm_function1[(8, 3, 1, 2)] = 0.0360036
        pgm_function1[(8, 3, 2, 0)] = 0.0797
        pgm_function1[(8, 3, 2, 1)] = 0.405
        pgm_function1[(8, 3, 2, 2)] = 0.132
        pgm_function1[(8, 3, 3, 0)] = 0.030696918
        pgm_function1[(8, 3, 3, 1)] = 0.3877
        pgm_function1[(8, 3, 3, 2)] = 0.2503
        pgm_function1[(8, 3, 3, 3)] = 0.0113011
        pgm_function1[(8, 4, 0, 0)] = 0.32666707
        pgm_function1[(8, 4, 0, 1)] = 0.089991015
        pgm_function1[(8, 4, 1, 0)] = 0.2747
        pgm_function1[(8, 4, 1, 1)] = 0.19431931
        pgm_function1[(8, 4, 2, 0)] = 0.21867822
        pgm_function1[(8, 4, 2, 1)] = 0.29467071
        pgm_function1[(8, 4, 2, 2)] = 0.001300129
        pgm_function1[(8, 4, 3, 0)] = 0.1577
        pgm_function1[(8, 4, 3, 1)] = 0.374037138
        pgm_function1[(8, 4, 3, 2)] = 0.0286971
        pgm_function1[(8, 5, 0, 0)] = 0.3647
        pgm_function1[(8, 5, 0, 1)] = 0.02170218
        pgm_function1[(8, 5, 1, 0)] = 0.3327
        pgm_function1[(8, 5, 1, 1)] = 0.0937
        pgm_function1[(8, 5, 2, 0)] = 0.286
        pgm_function1[(8, 5, 2, 1)] = 0.1797
        pgm_function1[(8, 5, 3, 0)] = 0.2382761
        pgm_function1[(8, 5, 3, 1)] = 0.26302589
        pgm_function1[(8, 6, 0, 0)] = 0.3557
        pgm_function1[(8, 6, 0, 1)] = 0.00129987
        pgm_function1[(8, 6, 1, 0)] = 0.358
        pgm_function1[(8, 6, 1, 1)] = 0.0457
        pgm_function1[(8, 6, 2, 0)] = 0.32596716
        pgm_function1[(8, 6, 2, 1)] = 0.108
        pgm_function1[(8, 6, 3, 0)] = 0.2823
        pgm_function1[(8, 6, 3, 1)] = 0.1827
        pgm_function1[(8, 7, 0, 0)] = 0.33766586
        pgm_function1[(8, 7, 1, 0)] = 0.3697
        pgm_function1[(8, 7, 1, 1)] = 0.0163
        pgm_function1[(8, 7, 2, 0)] = 0.343
        pgm_function1[(8, 7, 2, 1)] = 0.072992727
        pgm_function1[(8, 7, 3, 0)] = 0.318
        pgm_function1[(8, 7, 3, 1)] = 0.1267
        pgm_function1[(9, 1, 0, 2)] = 0.047
        pgm_function1[(9, 1, 0, 3)] = 0.16071621
        pgm_function1[(9, 1, 1, 2)] = 0.008
        pgm_function1[(9, 1, 1, 3)] = 0.099
        pgm_function1[(9, 1, 2, 3)] = 0.03630358
        pgm_function1[(9, 1, 3, 3)] = 0.0037
        pgm_function1[(9, 2, 0, 1)] = 0.17031701
        pgm_function1[(9, 2, 0, 2)] = 0.3357
        pgm_function1[(9, 2, 0, 3)] = 0.15
        pgm_function1[(9, 2, 1, 1)] = 0.0833
        pgm_function1[(9, 2, 1, 2)] = 0.3237
        pgm_function1[(9, 2, 1, 3)] = 0.2773
        pgm_function1[(9, 2, 2, 1)] = 0.025
        pgm_function1[(9, 2, 2, 2)] = 0.2483
        pgm_function1[(9, 2, 2, 3)] = 0.3493
        pgm_function1[(9, 2, 3, 1)] = 0.002300229
        pgm_function1[(9, 2, 3, 2)] = 0.162
        pgm_function1[(9, 2, 3, 3)] = 0.3277
        pgm_function1[(9, 3, 0, 0)] = 0.05869409
        pgm_function1[(9, 3, 0, 1)] = 0.3583
        pgm_function1[(9, 3, 0, 2)] = 0.0937
        pgm_function1[(9, 3, 1, 0)] = 0.01230121
        pgm_function1[(9, 3, 1, 1)] = 0.33033301
        pgm_function1[(9, 3, 1, 2)] = 0.232723
        pgm_function1[(9, 3, 1, 3)] = 0.008
        pgm_function1[(9, 3, 2, 1)] = 0.2573
        pgm_function1[(9, 3, 2, 2)] = 0.3307
        pgm_function1[(9, 3, 2, 3)] = 0.070692822
        pgm_function1[(9, 3, 3, 1)] = 0.1687
        pgm_function1[(9, 3, 3, 2)] = 0.3617
        pgm_function1[(9, 3, 3, 3)] = 0.18431804
        pgm_function1[(9, 4, 0, 0)] = 0.17268303
        pgm_function1[(9, 4, 0, 1)] = 0.267673046
        pgm_function1[(9, 4, 0, 2)] = 0.001
        pgm_function1[(9, 4, 1, 0)] = 0.0987
        pgm_function1[(9, 4, 1, 1)] = 0.35433557
        pgm_function1[(9, 4, 1, 2)] = 0.0417
        pgm_function1[(9, 4, 2, 0)] = 0.03869614
        pgm_function1[(9, 4, 2, 1)] = 0.36366364
        pgm_function1[(9, 4, 2, 2)] = 0.14271391
        pgm_function1[(9, 4, 3, 0)] = 0.0047
        pgm_function1[(9, 4, 3, 1)] = 0.335334124
        pgm_function1[(9, 4, 3, 2)] = 0.25097504
        pgm_function1[(9, 4, 3, 3)] = 0.002
        pgm_function1[(9, 5, 0, 0)] = 0.2247
        pgm_function1[(9, 5, 0, 1)] = 0.17901787
        pgm_function1[(9, 5, 1, 0)] = 0.1733
        pgm_function1[(9, 5, 1, 1)] = 0.274
        pgm_function1[(9, 5, 2, 0)] = 0.108
        pgm_function1[(9, 5, 2, 1)] = 0.3537
        pgm_function1[(9, 5, 2, 2)] = 0.0269973
        pgm_function1[(9, 5, 3, 0)] = 0.05669432
        pgm_function1[(9, 5, 3, 1)] = 0.36633685
        pgm_function1[(9, 5, 3, 2)] = 0.10199
        pgm_function1[(9, 6, 0, 0)] = 0.2583
        pgm_function1[(9, 6, 0, 1)] = 0.12668699
        pgm_function1[(9, 6, 1, 0)] = 0.207
        pgm_function1[(9, 6, 1, 1)] = 0.2137
        pgm_function1[(9, 6, 2, 0)] = 0.16468408
        pgm_function1[(9, 6, 2, 1)] = 0.2937
        pgm_function1[(9, 6, 3, 0)] = 0.1027
        pgm_function1[(9, 6, 3, 1)] = 0.3597
        pgm_function1[(9, 6, 3, 2)] = 0.02330227
        pgm_function1[(9, 7, 0, 0)] = 0.27067289
        pgm_function1[(9, 7, 0, 1)] = 0.096
        pgm_function1[(9, 7, 1, 0)] = 0.2317
        pgm_function1[(9, 7, 1, 1)] = 0.1747
        pgm_function1[(9, 7, 2, 0)] = 0.1883
        pgm_function1[(9, 7, 2, 1)] = 0.2456750909
        pgm_function1[(9, 7, 3, 0)] = 0.144
        pgm_function1[(9, 7, 3, 1)] = 0.317
        pgm_function1[(9, 7, 3, 2)] = 0.0003000297
        pgm_function1[(10, 1, 0, 2)] = 0.0017
        pgm_function1[(10, 1, 0, 3)] = 0.06930699
        pgm_function1[(10, 1, 1, 3)] = 0.0137
        pgm_function1[(10, 2, 0, 1)] = 0.0377038
        pgm_function1[(10, 2, 0, 2)] = 0.2627
        pgm_function1[(10, 2, 0, 3)] = 0.2803
        pgm_function1[(10, 2, 1, 1)] = 0.003
        pgm_function1[(10, 2, 1, 2)] = 0.1683
        pgm_function1[(10, 2, 1, 3)] = 0.312
        pgm_function1[(10, 2, 2, 2)] = 0.0737
        pgm_function1[(10, 2, 2, 3)] = 0.2557
        pgm_function1[(10, 2, 3, 2)] = 0.0197
        pgm_function1[(10, 2, 3, 3)] = 0.179
        pgm_function1[(10, 3, 0, 1)] = 0.247
        pgm_function1[(10, 3, 0, 2)] = 0.2663
        pgm_function1[(10, 3, 0, 3)] = 0.0257
        pgm_function1[(10, 3, 1, 1)] = 0.151015
        pgm_function1[(10, 3, 1, 2)] = 0.328333
        pgm_function1[(10, 3, 1, 3)] = 0.1427
        pgm_function1[(10, 3, 2, 1)] = 0.0613
        pgm_function1[(10, 3, 2, 2)] = 0.3243
        pgm_function1[(10, 3, 2, 3)] = 0.26397371
        pgm_function1[(10, 3, 3, 1)] = 0.0133
        pgm_function1[(10, 3, 3, 2)] = 0.279
        pgm_function1[(10, 3, 3, 3)] = 0.31803206
        pgm_function1[(10, 4, 0, 0)] = 0.03199681
        pgm_function1[(10, 4, 0, 1)] = 0.327967056
        pgm_function1[(10, 4, 0, 2)] = 0.1017
        pgm_function1[(10, 4, 1, 0)] = 0.001
        pgm_function1[(10, 4, 1, 1)] = 0.29302947
        pgm_function1[(10, 4, 1, 2)] = 0.2263
        pgm_function1[(10, 4, 1, 3)] = 0.0013
        pgm_function1[(10, 4, 2, 1)] = 0.22167778
        pgm_function1[(10, 4, 2, 2)] = 0.310330804
        pgm_function1[(10, 4, 2, 3)] = 0.0436956
        pgm_function1[(10, 4, 3, 1)] = 0.144314053
        pgm_function1[(10, 4, 3, 2)] = 0.32796706
        pgm_function1[(10, 4, 3, 3)] = 0.1477
        pgm_function1[(10, 5, 0, 0)] = 0.0893
        pgm_function1[(10, 5, 0, 1)] = 0.31633178
        pgm_function1[(10, 5, 0, 2)] = 0.016
        pgm_function1[(10, 5, 1, 0)] = 0.0283
        pgm_function1[(10, 5, 1, 1)] = 0.3307
        pgm_function1[(10, 5, 1, 2)] = 0.112311146
        pgm_function1[(10, 5, 2, 1)] = 0.3023
        pgm_function1[(10, 5, 2, 2)] = 0.208679
        pgm_function1[(10, 5, 3, 1)] = 0.2460249
        pgm_function1[(10, 5, 3, 2)] = 0.291671
        pgm_function1[(10, 5, 3, 3)] = 0.0093
        pgm_function1[(10, 6, 0, 0)] = 0.125
        pgm_function1[(10, 6, 0, 1)] = 0.27167297
        pgm_function1[(10, 6, 1, 0)] = 0.067
        pgm_function1[(10, 6, 1, 1)] = 0.33
        pgm_function1[(10, 6, 1, 2)] = 0.0413
        pgm_function1[(10, 6, 2, 0)] = 0.01469851
        pgm_function1[(10, 6, 2, 1)] = 0.3293
        pgm_function1[(10, 6, 2, 2)] = 0.1306868785
        pgm_function1[(10, 6, 3, 1)] = 0.3003
        pgm_function1[(10, 6, 3, 2)] = 0.20702073
        pgm_function1[(10, 7, 0, 0)] = 0.15168494
        pgm_function1[(10, 7, 0, 1)] = 0.2337
        pgm_function1[(10, 7, 1, 0)] = 0.0913
        pgm_function1[(10, 7, 1, 1)] = 0.319
        pgm_function1[(10, 7, 1, 2)] = 0.008699123
        pgm_function1[(10, 7, 2, 0)] = 0.0437
        pgm_function1[(10, 7, 2, 1)] = 0.3316671227
        pgm_function1[(10, 7, 2, 2)] = 0.0777
        pgm_function1[(10, 7, 3, 0)] = 0.0037
        pgm_function1[(10, 7, 3, 1)] = 0.3253
        pgm_function1[(10, 7, 3, 2)] = 0.1500148305
        pgm_function1[(11, 1, 0, 3)] = 0.00800081
        pgm_function1[(11, 2, 0, 1)] = 0.00030003
        pgm_function1[(11, 2, 0, 2)] = 0.1203
        pgm_function1[(11, 2, 0, 3)] = 0.2767
        pgm_function1[(11, 2, 1, 2)] = 0.036
        pgm_function1[(11, 2, 1, 3)] = 0.2053
        pgm_function1[(11, 2, 2, 2)] = 0.0023
        pgm_function1[(11, 2, 2, 3)] = 0.1143
        pgm_function1[(11, 2, 3, 3)] = 0.0403
        pgm_function1[(11, 3, 0, 1)] = 0.092
        pgm_function1[(11, 3, 0, 2)] = 0.3007
        pgm_function1[(11, 3, 0, 3)] = 0.1687
        pgm_function1[(11, 3, 1, 1)] = 0.0183018
        pgm_function1[(11, 3, 1, 2)] = 0.272327
        pgm_function1[(11, 3, 1, 3)] = 0.2757
        pgm_function1[(11, 3, 2, 2)] = 0.18
        pgm_function1[(11, 3, 2, 3)] = 0.303669666
        pgm_function1[(11, 3, 3, 2)] = 0.0837
        pgm_function1[(11, 3, 3, 3)] = 0.29833006
        pgm_function1[(11, 4, 0, 1)] = 0.222978038
        pgm_function1[(11, 4, 0, 2)] = 0.2523
        pgm_function1[(11, 4, 0, 3)] = 0.01
        pgm_function1[(11, 4, 1, 1)] = 0.13431321
        pgm_function1[(11, 4, 1, 2)] = 0.2987
        pgm_function1[(11, 4, 1, 3)] = 0.112
        pgm_function1[(11, 4, 2, 1)] = 0.05329465
        pgm_function1[(11, 4, 2, 2)] = 0.305330808
        pgm_function1[(11, 4, 2, 3)] = 0.233677
        pgm_function1[(11, 4, 3, 1)] = 0.006300632
        pgm_function1[(11, 4, 3, 2)] = 0.28067205
        pgm_function1[(11, 4, 3, 3)] = 0.286
        pgm_function1[(11, 5, 0, 0)] = 0.0007
        pgm_function1[(11, 5, 0, 1)] = 0.27832781
        pgm_function1[(11, 5, 0, 2)] = 0.1597
        pgm_function1[(11, 5, 1, 1)] = 0.2173
        pgm_function1[(11, 5, 1, 2)] = 0.263326342
        pgm_function1[(11, 5, 1, 3)] = 0.007001399
        pgm_function1[(11, 5, 2, 1)] = 0.149
        pgm_function1[(11, 5, 2, 2)] = 0.29867
        pgm_function1[(11, 5, 2, 3)] = 0.0847
        pgm_function1[(11, 5, 3, 1)] = 0.08130807
        pgm_function1[(11, 5, 3, 2)] = 0.29997
        pgm_function1[(11, 5, 3, 3)] = 0.1873
        pgm_function1[(11, 6, 0, 0)] = 0.013
        pgm_function1[(11, 6, 0, 1)] = 0.29866997
        pgm_function1[(11, 6, 0, 2)] = 0.10069003
        pgm_function1[(11, 6, 1, 1)] = 0.263
        pgm_function1[(11, 6, 1, 2)] = 0.194
        pgm_function1[(11, 6, 2, 1)] = 0.202
        pgm_function1[(11, 6, 2, 2)] = 0.281671738
        pgm_function1[(11, 6, 2, 3)] = 0.008
        pgm_function1[(11, 6, 3, 1)] = 0.1457
        pgm_function1[(11, 6, 3, 2)] = 0.29702961
        pgm_function1[(11, 6, 3, 3)] = 0.07900787
        pgm_function1[(11, 7, 0, 0)] = 0.03199679
        pgm_function1[(11, 7, 0, 1)] = 0.305
        pgm_function1[(11, 7, 0, 2)] = 0.058305812
        pgm_function1[(11, 7, 1, 1)] = 0.2827
        pgm_function1[(11, 7, 1, 2)] = 0.153684883
        pgm_function1[(11, 7, 2, 1)] = 0.2392760885
        pgm_function1[(11, 7, 2, 2)] = 0.2273
        pgm_function1[(11, 7, 3, 1)] = 0.1833
        pgm_function1[(11, 7, 3, 2)] = 0.2960296655
        pgm_function1[(11, 7, 3, 3)] = 0.0133013089
        pgm_function1[(12, 2, 0, 2)] = 0.025
        pgm_function1[(12, 2, 0, 3)] = 0.1823
        pgm_function1[(12, 2, 1, 3)] = 0.081
        pgm_function1[(12, 2, 2, 3)] = 0.0143
        pgm_function1[(12, 3, 0, 1)] = 0.0057
        pgm_function1[(12, 3, 0, 2)] = 0.2333
        pgm_function1[(12, 3, 0, 3)] = 0.2603
        pgm_function1[(12, 3, 1, 2)] = 0.117312
        pgm_function1[(12, 3, 1, 3)] = 0.2783
        pgm_function1[(12, 3, 2, 2)] = 0.032
        pgm_function1[(12, 3, 2, 3)] = 0.251674723
        pgm_function1[(12, 3, 3, 2)] = 0.0013
        pgm_function1[(12, 3, 3, 3)] = 0.16131603
        pgm_function1[(12, 4, 0, 1)] = 0.087691215
        pgm_function1[(12, 4, 0, 2)] = 0.274
        pgm_function1[(12, 4, 0, 3)] = 0.1397
        pgm_function1[(12, 4, 1, 1)] = 0.01230122
        pgm_function1[(12, 4, 1, 2)] = 0.273
        pgm_function1[(12, 4, 1, 3)] = 0.2493
        pgm_function1[(12, 4, 2, 2)] = 0.195019877
        pgm_function1[(12, 4, 2, 3)] = 0.270973
        pgm_function1[(12, 4, 3, 2)] = 0.10898902
        pgm_function1[(12, 4, 3, 3)] = 0.2827
        pgm_function1[(12, 5, 0, 1)] = 0.15931589
        pgm_function1[(12, 5, 0, 2)] = 0.2687
        pgm_function1[(12, 5, 0, 3)] = 0.0277
        pgm_function1[(12, 5, 1, 1)] = 0.084
        pgm_function1[(12, 5, 1, 2)] = 0.271327353
        pgm_function1[(12, 5, 1, 3)] = 0.153330985
        pgm_function1[(12, 5, 2, 1)] = 0.0113
        pgm_function1[(12, 5, 2, 2)] = 0.287971
        pgm_function1[(12, 5, 2, 3)] = 0.2433
        pgm_function1[(12, 5, 3, 2)] = 0.226677
        pgm_function1[(12, 5, 3, 3)] = 0.2757
        pgm_function1[(12, 6, 0, 1)] = 0.20367998
        pgm_function1[(12, 6, 0, 2)] = 0.22427807
        pgm_function1[(12, 6, 0, 3)] = 0.0003000302
        pgm_function1[(12, 6, 1, 1)] = 0.1323
        pgm_function1[(12, 6, 1, 2)] = 0.2767
        pgm_function1[(12, 6, 1, 3)] = 0.062
        pgm_function1[(12, 6, 2, 1)] = 0.067
        pgm_function1[(12, 6, 2, 2)] = 0.2712727477
        pgm_function1[(12, 6, 2, 3)] = 0.172
        pgm_function1[(12, 6, 3, 1)] = 0.0083
        pgm_function1[(12, 6, 3, 2)] = 0.29532962
        pgm_function1[(12, 6, 3, 3)] = 0.23432291
        pgm_function1[(12, 7, 0, 1)] = 0.2287
        pgm_function1[(12, 7, 0, 2)] = 0.182018036
        pgm_function1[(12, 7, 1, 1)] = 0.159
        pgm_function1[(12, 7, 1, 2)] = 0.273972792
        pgm_function1[(12, 7, 1, 3)] = 0.0143
        pgm_function1[(12, 7, 2, 1)] = 0.1096890406
        pgm_function1[(12, 7, 2, 2)] = 0.268
        pgm_function1[(12, 7, 2, 3)] = 0.1033
        pgm_function1[(12, 7, 3, 1)] = 0.0477
        pgm_function1[(12, 7, 3, 2)] = 0.2763276877
        pgm_function1[(12, 7, 3, 3)] = 0.1830181226
        pgm_function1[(13, 2, 0, 3)] = 0.0747
        pgm_function1[(13, 2, 1, 3)] = 0.0077
        pgm_function1[(13, 3, 0, 2)] = 0.094
        pgm_function1[(13, 3, 0, 3)] = 0.2573
        pgm_function1[(13, 3, 1, 2)] = 0.0133013
        pgm_function1[(13, 3, 1, 3)] = 0.2133
        pgm_function1[(13, 3, 2, 3)] = 0.101989888
        pgm_function1[(13, 3, 3, 3)] = 0.02670271
        pgm_function1[(13, 4, 0, 1)] = 0.003699631
        pgm_function1[(13, 4, 0, 2)] = 0.234
        pgm_function1[(13, 4, 0, 3)] = 0.2393
        pgm_function1[(13, 4, 1, 2)] = 0.141
        pgm_function1[(13, 4, 1, 3)] = 0.2527
        pgm_function1[(13, 4, 2, 2)] = 0.045304471
        pgm_function1[(13, 4, 2, 3)] = 0.267673
        pgm_function1[(13, 4, 3, 2)] = 0.00269973
        pgm_function1[(13, 4, 3, 3)] = 0.2163
        pgm_function1[(13, 5, 0, 1)] = 0.04530447
        pgm_function1[(13, 5, 0, 2)] = 0.2593
        pgm_function1[(13, 5, 0, 3)] = 0.1683
        pgm_function1[(13, 5, 1, 1)] = 0.0003
        pgm_function1[(13, 5, 1, 2)] = 0.232323302
        pgm_function1[(13, 5, 1, 3)] = 0.251349975
        pgm_function1[(13, 5, 2, 2)] = 0.153985
        pgm_function1[(13, 5, 2, 3)] = 0.2417
        pgm_function1[(13, 5, 3, 2)] = 0.079692
        pgm_function1[(13, 5, 3, 3)] = 0.2687
        pgm_function1[(13, 6, 0, 1)] = 0.09429059
        pgm_function1[(13, 6, 0, 2)] = 0.24667507
        pgm_function1[(13, 6, 0, 3)] = 0.0990099792
        pgm_function1[(13, 6, 1, 1)] = 0.0153
        pgm_function1[(13, 6, 1, 2)] = 0.272
        pgm_function1[(13, 6, 1, 3)] = 0.1993
        pgm_function1[(13, 6, 2, 2)] = 0.2146788003
        pgm_function1[(13, 6, 2, 3)] = 0.259
        pgm_function1[(13, 6, 3, 2)] = 0.1570158
        pgm_function1[(13, 6, 3, 3)] = 0.23732391
        pgm_function1[(13, 7, 0, 1)] = 0.1183
        pgm_function1[(13, 7, 0, 2)] = 0.257026051
        pgm_function1[(13, 7, 0, 3)] = 0.045
        pgm_function1[(13, 7, 1, 1)] = 0.0483
        pgm_function1[(13, 7, 1, 2)] = 0.253274808
        pgm_function1[(13, 7, 1, 3)] = 0.1593
        pgm_function1[(13, 7, 2, 1)] = 0.0006999303
        pgm_function1[(13, 7, 2, 2)] = 0.2653
        pgm_function1[(13, 7, 2, 3)] = 0.2253
        pgm_function1[(13, 7, 3, 2)] = 0.1963197782
        pgm_function1[(13, 7, 3, 3)] = 0.2643261771
        pgm_function1[(14, 2, 0, 3)] = 0.01
        pgm_function1[(14, 3, 0, 2)] = 0.0103
        pgm_function1[(14, 3, 0, 3)] = 0.1983
        pgm_function1[(14, 3, 1, 3)] = 0.077
        pgm_function1[(14, 3, 2, 3)] = 0.007999191
        pgm_function1[(14, 4, 0, 2)] = 0.1203
        pgm_function1[(14, 4, 0, 3)] = 0.2363
        pgm_function1[(14, 4, 1, 2)] = 0.0193
        pgm_function1[(14, 4, 1, 3)] = 0.2403
        pgm_function1[(14, 4, 2, 3)] = 0.156684
        pgm_function1[(14, 4, 3, 3)] = 0.0653
        pgm_function1[(14, 5, 0, 2)] = 0.1953
        pgm_function1[(14, 5, 0, 3)] = 0.2343
        pgm_function1[(14, 5, 1, 2)] = 0.113711148
        pgm_function1[(14, 5, 1, 3)] = 0.229345977
        pgm_function1[(14, 5, 2, 2)] = 0.0236976
        pgm_function1[(14, 5, 2, 3)] = 0.2573
        pgm_function1[(14, 5, 3, 3)] = 0.1963
        pgm_function1[(14, 6, 0, 1)] = 0.00369963
        pgm_function1[(14, 6, 0, 2)] = 0.24567507
        pgm_function1[(14, 6, 0, 3)] = 0.2023201619
        pgm_function1[(14, 6, 1, 2)] = 0.161
        pgm_function1[(14, 6, 1, 3)] = 0.235
        pgm_function1[(14, 6, 2, 2)] = 0.1009899061
        pgm_function1[(14, 6, 2, 3)] = 0.233
        pgm_function1[(14, 6, 3, 2)] = 0.02030197
        pgm_function1[(14, 6, 3, 3)] = 0.26602689
        pgm_function1[(14, 7, 0, 1)] = 0.0183
        pgm_function1[(14, 7, 0, 2)] = 0.24832505
        pgm_function1[(14, 7, 0, 3)] = 0.1673
        pgm_function1[(14, 7, 1, 2)] = 0.199979848
        pgm_function1[(14, 7, 1, 3)] = 0.245
        pgm_function1[(14, 7, 2, 2)] = 0.142
        pgm_function1[(14, 7, 2, 3)] = 0.2173
        pgm_function1[(14, 7, 3, 2)] = 0.0810080085
        pgm_function1[(14, 7, 3, 3)] = 0.2453251644
        pgm_function1[(15, 3, 0, 3)] = 0.0797
        pgm_function1[(15, 3, 1, 3)] = 0.005
        pgm_function1[(15, 4, 0, 2)] = 0.0167
        pgm_function1[(15, 4, 0, 3)] = 0.2217
        pgm_function1[(15, 4, 1, 3)] = 0.1277
        pgm_function1[(15, 4, 2, 3)] = 0.0272973
        pgm_function1[(15, 5, 0, 2)] = 0.0943
        pgm_function1[(15, 5, 0, 3)] = 0.219
        pgm_function1[(15, 5, 1, 2)] = 0.007000709
        pgm_function1[(15, 5, 1, 3)] = 0.222343978
        pgm_function1[(15, 5, 2, 3)] = 0.1507
        pgm_function1[(15, 5, 3, 3)] = 0.0627
        pgm_function1[(15, 6, 0, 2)] = 0.13998604
        pgm_function1[(15, 6, 0, 3)] = 0.2133211707
        pgm_function1[(15, 6, 1, 2)] = 0.055
        pgm_function1[(15, 6, 1, 3)] = 0.2437
        pgm_function1[(15, 6, 2, 2)] = 0.0006999293
        pgm_function1[(15, 6, 2, 3)] = 0.209
        pgm_function1[(15, 6, 3, 3)] = 0.15831594
        pgm_function1[(15, 7, 0, 2)] = 0.164316033
        pgm_function1[(15, 7, 0, 3)] = 0.229
        pgm_function1[(15, 7, 1, 2)] = 0.106688919
        pgm_function1[(15, 7, 1, 3)] = 0.203
        pgm_function1[(15, 7, 2, 2)] = 0.0197
        pgm_function1[(15, 7, 2, 3)] = 0.2557
        pgm_function1[(15, 7, 3, 3)] = 0.1917191285
        pgm_function1[(16, 3, 0, 3)] = 0.01
        pgm_function1[(16, 4, 0, 3)] = 0.126
        pgm_function1[(16, 4, 1, 3)] = 0.0167
        pgm_function1[(16, 5, 0, 2)] = 0.0067
        pgm_function1[(16, 5, 0, 3)] = 0.208
        pgm_function1[(16, 5, 1, 3)] = 0.123324988
        pgm_function1[(16, 5, 2, 3)] = 0.0223
        pgm_function1[(16, 6, 0, 2)] = 0.04269571
        pgm_function1[(16, 6, 0, 3)] = 0.2280231824
        pgm_function1[(16, 6, 1, 3)] = 0.173
        pgm_function1[(16, 6, 2, 3)] = 0.115
        pgm_function1[(16, 6, 3, 3)] = 0.02500249
        pgm_function1[(16, 7, 0, 2)] = 0.087008717
        pgm_function1[(16, 7, 0, 3)] = 0.2007
        pgm_function1[(16, 7, 1, 2)] = 0.003699627
        pgm_function1[(16, 7, 1, 3)] = 0.2187
        pgm_function1[(16, 7, 2, 3)] = 0.1537
        pgm_function1[(16, 7, 3, 3)] = 0.1020100683
        pgm_function1[(17, 4, 0, 3)] = 0.027
        pgm_function1[(17, 5, 0, 3)] = 0.119
        pgm_function1[(17, 5, 1, 3)] = 0.013302699
        pgm_function1[(17, 6, 0, 3)] = 0.1643161315
        pgm_function1[(17, 6, 1, 3)] = 0.0857
        pgm_function1[(17, 6, 2, 3)] = 0.004
        pgm_function1[(17, 7, 0, 2)] = 0.003000301
        pgm_function1[(17, 7, 0, 3)] = 0.2013
        pgm_function1[(17, 7, 1, 3)] = 0.1357
        pgm_function1[(17, 7, 2, 3)] = 0.0447
        pgm_function1[(17, 7, 3, 3)] = 0.0003000302
        pgm_function1[(18, 5, 0, 3)] = 0.0237
        pgm_function1[(18, 6, 0, 3)] = 0.0870087696
        pgm_function1[(18, 6, 1, 3)] = 0.0013
        pgm_function1[(18, 7, 0, 3)] = 0.124
        pgm_function1[(18, 7, 1, 3)] = 0.024
        pgm_function1[(19, 6, 0, 3)] = 0.0057005746
        pgm_function1[(19, 7, 0, 3)] = 0.0327

        pgm_function2 = pgm_factor2.set_dense()
        pgm_function2.set_flat(0.133, 0.467, 0.333, 0.067)

        pgm_function3 = pgm_factor3.set_dense()
        pgm_function3.set_flat(0.133, 0.567, 0.167, 0.133)

        pgm_function4 = pgm_factor4.set_sparse()
        pgm_function4[(0, 0, 0)] = 1.0
        pgm_function4[(0, 0, 1)] = 1.0
        pgm_function4[(0, 0, 2)] = 1.0
        pgm_function4[(0, 0, 3)] = 1.0
        pgm_function4[(0, 0, 4)] = 1.0
        pgm_function4[(0, 0, 5)] = 1.0
        pgm_function4[(0, 0, 6)] = 1.0
        pgm_function4[(0, 0, 7)] = 1.0
        pgm_function4[(0, 0, 8)] = 1.0
        pgm_function4[(0, 1, 0)] = 0.03330331
        pgm_function4[(0, 1, 1)] = 0.03330331
        pgm_function4[(0, 1, 2)] = 0.03330331
        pgm_function4[(0, 1, 3)] = 0.03330331
        pgm_function4[(0, 1, 4)] = 0.03330331
        pgm_function4[(0, 1, 5)] = 0.04
        pgm_function4[(0, 1, 6)] = 0.11
        pgm_function4[(0, 1, 7)] = 0.3167
        pgm_function4[(0, 1, 8)] = 0.91
        pgm_function4[(0, 2, 8)] = 0.5133
        pgm_function4[(0, 3, 8)] = 0.34
        pgm_function4[(0, 4, 8)] = 0.25
        pgm_function4[(0, 5, 8)] = 0.19998014
        pgm_function4[(0, 6, 8)] = 0.1866812
        pgm_function4[(0, 7, 8)] = 0.1367
        pgm_function4[(1, 1, 0)] = 0.93339337
        pgm_function4[(1, 1, 1)] = 0.93339337
        pgm_function4[(1, 1, 2)] = 0.93339337
        pgm_function4[(1, 1, 3)] = 0.93339337
        pgm_function4[(1, 1, 4)] = 0.93339337
        pgm_function4[(1, 1, 5)] = 0.96
        pgm_function4[(1, 1, 6)] = 0.89
        pgm_function4[(1, 1, 7)] = 0.6833
        pgm_function4[(1, 1, 8)] = 0.09
        pgm_function4[(1, 2, 0)] = 0.06669333
        pgm_function4[(1, 2, 1)] = 0.06669333
        pgm_function4[(1, 2, 2)] = 0.06669333
        pgm_function4[(1, 2, 3)] = 0.06669333
        pgm_function4[(1, 2, 4)] = 0.1
        pgm_function4[(1, 2, 5)] = 0.14
        pgm_function4[(1, 2, 6)] = 0.3367
        pgm_function4[(1, 2, 7)] = 0.8233
        pgm_function4[(1, 2, 8)] = 0.4867
        pgm_function4[(1, 3, 7)] = 0.1233
        pgm_function4[(1, 3, 8)] = 0.62
        pgm_function4[(1, 4, 8)] = 0.5033
        pgm_function4[(1, 5, 8)] = 0.40665928
        pgm_function4[(1, 6, 8)] = 0.3199683
        pgm_function4[(1, 7, 8)] = 0.3
        pgm_function4[(2, 1, 0)] = 0.03330331
        pgm_function4[(2, 1, 1)] = 0.03330331
        pgm_function4[(2, 1, 2)] = 0.03330331
        pgm_function4[(2, 1, 3)] = 0.03330331
        pgm_function4[(2, 1, 4)] = 0.03330331
        pgm_function4[(2, 2, 0)] = 0.86661335
        pgm_function4[(2, 2, 1)] = 0.86661335
        pgm_function4[(2, 2, 2)] = 0.86661335
        pgm_function4[(2, 2, 3)] = 0.86661335
        pgm_function4[(2, 2, 4)] = 0.8567
        pgm_function4[(2, 2, 5)] = 0.85
        pgm_function4[(2, 2, 6)] = 0.6633
        pgm_function4[(2, 2, 7)] = 0.1767
        pgm_function4[(2, 3, 0)] = 0.1
        pgm_function4[(2, 3, 1)] = 0.1
        pgm_function4[(2, 3, 2)] = 0.1
        pgm_function4[(2, 3, 3)] = 0.1
        pgm_function4[(2, 3, 4)] = 0.1667
        pgm_function4[(2, 3, 5)] = 0.25
        pgm_function4[(2, 3, 6)] = 0.5433
        pgm_function4[(2, 3, 7)] = 0.84
        pgm_function4[(2, 3, 8)] = 0.04
        pgm_function4[(2, 4, 6)] = 0.01
        pgm_function4[(2, 4, 7)] = 0.5233
        pgm_function4[(2, 4, 8)] = 0.2467
        pgm_function4[(2, 5, 7)] = 0.09330937
        pgm_function4[(2, 5, 8)] = 0.35666425
        pgm_function4[(2, 6, 8)] = 0.3366663
        pgm_function4[(2, 7, 8)] = 0.2833
        pgm_function4[(3, 2, 0)] = 0.06669333
        pgm_function4[(3, 2, 1)] = 0.06669333
        pgm_function4[(3, 2, 2)] = 0.06669333
        pgm_function4[(3, 2, 3)] = 0.06669333
        pgm_function4[(3, 2, 4)] = 0.0433
        pgm_function4[(3, 2, 5)] = 0.01
        pgm_function4[(3, 3, 0)] = 0.8
        pgm_function4[(3, 3, 1)] = 0.8
        pgm_function4[(3, 3, 2)] = 0.8
        pgm_function4[(3, 3, 3)] = 0.8
        pgm_function4[(3, 3, 4)] = 0.7733
        pgm_function4[(3, 3, 5)] = 0.7367
        pgm_function4[(3, 3, 6)] = 0.4567
        pgm_function4[(3, 3, 7)] = 0.0367
        pgm_function4[(3, 4, 0)] = 0.1333131
        pgm_function4[(3, 4, 1)] = 0.1333131
        pgm_function4[(3, 4, 2)] = 0.1333131
        pgm_function4[(3, 4, 3)] = 0.17
        pgm_function4[(3, 4, 4)] = 0.2333
        pgm_function4[(3, 4, 5)] = 0.3433
        pgm_function4[(3, 4, 6)] = 0.6867
        pgm_function4[(3, 4, 7)] = 0.47
        pgm_function4[(3, 5, 6)] = 0.0833
        pgm_function4[(3, 5, 7)] = 0.68336848
        pgm_function4[(3, 5, 8)] = 0.03669633
        pgm_function4[(3, 6, 7)] = 0.3567
        pgm_function4[(3, 6, 8)] = 0.1566842
        pgm_function4[(3, 7, 7)] = 0.0833
        pgm_function4[(3, 7, 8)] = 0.25
        pgm_function4[(4, 3, 0)] = 0.1
        pgm_function4[(4, 3, 1)] = 0.1
        pgm_function4[(4, 3, 2)] = 0.1
        pgm_function4[(4, 3, 3)] = 0.1
        pgm_function4[(4, 3, 4)] = 0.06
        pgm_function4[(4, 3, 5)] = 0.0133
        pgm_function4[(4, 4, 0)] = 0.7333737
        pgm_function4[(4, 4, 1)] = 0.7333737
        pgm_function4[(4, 4, 2)] = 0.7333737
        pgm_function4[(4, 4, 3)] = 0.7167
        pgm_function4[(4, 4, 4)] = 0.6867
        pgm_function4[(4, 4, 5)] = 0.64
        pgm_function4[(4, 4, 6)] = 0.3033
        pgm_function4[(4, 4, 7)] = 0.0067
        pgm_function4[(4, 5, 0)] = 0.1666832
        pgm_function4[(4, 5, 1)] = 0.1666832
        pgm_function4[(4, 5, 2)] = 0.1666832
        pgm_function4[(4, 5, 3)] = 0.23
        pgm_function4[(4, 5, 4)] = 0.3
        pgm_function4[(4, 5, 5)] = 0.44
        pgm_function4[(4, 5, 6)] = 0.69
        pgm_function4[(4, 5, 7)] = 0.22332216
        pgm_function4[(4, 6, 6)] = 0.22
        pgm_function4[(4, 6, 7)] = 0.5333
        pgm_function4[(4, 7, 6)] = 0.0033
        pgm_function4[(4, 7, 7)] = 0.51
        pgm_function4[(4, 7, 8)] = 0.03
        pgm_function4[(5, 4, 0)] = 0.1333131
        pgm_function4[(5, 4, 1)] = 0.1333131
        pgm_function4[(5, 4, 2)] = 0.1333131
        pgm_function4[(5, 4, 3)] = 0.1133
        pgm_function4[(5, 4, 4)] = 0.08
        pgm_function4[(5, 4, 5)] = 0.0167
        pgm_function4[(5, 5, 0)] = 0.6666337
        pgm_function4[(5, 5, 1)] = 0.6666337
        pgm_function4[(5, 5, 2)] = 0.6666337
        pgm_function4[(5, 5, 3)] = 0.6367
        pgm_function4[(5, 5, 4)] = 0.6033
        pgm_function4[(5, 5, 5)] = 0.5367
        pgm_function4[(5, 5, 6)] = 0.2267
        pgm_function4[(5, 6, 0)] = 0.2
        pgm_function4[(5, 6, 1)] = 0.2
        pgm_function4[(5, 6, 2)] = 0.23
        pgm_function4[(5, 6, 3)] = 0.2666733
        pgm_function4[(5, 6, 4)] = 0.3633
        pgm_function4[(5, 6, 5)] = 0.4933
        pgm_function4[(5, 6, 6)] = 0.6133
        pgm_function4[(5, 6, 7)] = 0.11
        pgm_function4[(5, 7, 5)] = 0.04669533
        pgm_function4[(5, 7, 6)] = 0.35
        pgm_function4[(5, 7, 7)] = 0.36
        pgm_function4[(6, 5, 0)] = 0.1666832
        pgm_function4[(6, 5, 1)] = 0.1666832
        pgm_function4[(6, 5, 2)] = 0.1666832
        pgm_function4[(6, 5, 3)] = 0.1333
        pgm_function4[(6, 5, 4)] = 0.0967
        pgm_function4[(6, 5, 5)] = 0.0233
        pgm_function4[(6, 6, 0)] = 0.6
        pgm_function4[(6, 6, 1)] = 0.6
        pgm_function4[(6, 6, 2)] = 0.59
        pgm_function4[(6, 6, 3)] = 0.5666436
        pgm_function4[(6, 6, 4)] = 0.52
        pgm_function4[(6, 6, 5)] = 0.48
        pgm_function4[(6, 6, 6)] = 0.1667
        pgm_function4[(6, 7, 0)] = 0.2333
        pgm_function4[(6, 7, 1)] = 0.24
        pgm_function4[(6, 7, 2)] = 0.2833
        pgm_function4[(6, 7, 3)] = 0.31
        pgm_function4[(6, 7, 4)] = 0.4133
        pgm_function4[(6, 7, 5)] = 0.47665233
        pgm_function4[(6, 7, 6)] = 0.5167
        pgm_function4[(6, 7, 7)] = 0.0467
        pgm_function4[(7, 6, 0)] = 0.2
        pgm_function4[(7, 6, 1)] = 0.2
        pgm_function4[(7, 6, 2)] = 0.18
        pgm_function4[(7, 6, 3)] = 0.1666832
        pgm_function4[(7, 6, 4)] = 0.1167
        pgm_function4[(7, 6, 5)] = 0.0267
        pgm_function4[(7, 7, 0)] = 0.7667
        pgm_function4[(7, 7, 1)] = 0.76
        pgm_function4[(7, 7, 2)] = 0.7167
        pgm_function4[(7, 7, 3)] = 0.69
        pgm_function4[(7, 7, 4)] = 0.5867
        pgm_function4[(7, 7, 5)] = 0.47665233
        pgm_function4[(7, 7, 6)] = 0.13

        pgm_function5 = pgm_factor5.set_dense()
        pgm_function5.set_flat(
            0.111111, 0.111111, 0.111111, 0.111111, 0.111111,
            0.111111, 0.111111, 0.111111, 0.111111
        )

        pgm_function6 = pgm_factor6.set_dense()
        pgm_function6.set_flat(
            0.0, 0.0, 0.0, 0.1, 0.2,
            0.2, 0.4, 0.1
        )

        pgm_function7 = pgm_factor7.set_sparse()
        pgm_function7[(0, 0, 0)] = 1.0
        pgm_function7[(0, 0, 1)] = 1.0
        pgm_function7[(0, 0, 2)] = 1.0
        pgm_function7[(0, 0, 3)] = 0.9678
        pgm_function7[(0, 0, 4)] = 0.6844
        pgm_function7[(0, 0, 5)] = 0.2878
        pgm_function7[(0, 0, 6)] = 0.04330867
        pgm_function7[(0, 1, 0)] = 1.0
        pgm_function7[(0, 1, 1)] = 0.9778
        pgm_function7[(0, 1, 2)] = 0.7889
        pgm_function7[(0, 1, 3)] = 0.4311
        pgm_function7[(0, 1, 4)] = 0.1256
        pgm_function7[(0, 1, 5)] = 0.0111
        pgm_function7[(0, 2, 0)] = 0.7889
        pgm_function7[(0, 2, 1)] = 0.4744
        pgm_function7[(0, 2, 2)] = 0.1511
        pgm_function7[(0, 2, 3)] = 0.0178
        pgm_function7[(0, 3, 0)] = 0.140014109
        pgm_function7[(0, 3, 1)] = 0.02440241
        pgm_function7[(1, 0, 3)] = 0.0322
        pgm_function7[(1, 0, 4)] = 0.2889
        pgm_function7[(1, 0, 5)] = 0.43
        pgm_function7[(1, 0, 6)] = 0.27445484
        pgm_function7[(1, 0, 7)] = 0.0522
        pgm_function7[(1, 1, 1)] = 0.0222
        pgm_function7[(1, 1, 2)] = 0.1933
        pgm_function7[(1, 1, 3)] = 0.3856
        pgm_function7[(1, 1, 4)] = 0.3344
        pgm_function7[(1, 1, 5)] = 0.1344
        pgm_function7[(1, 1, 6)] = 0.014401404
        pgm_function7[(1, 2, 0)] = 0.2011
        pgm_function7[(1, 2, 1)] = 0.37
        pgm_function7[(1, 2, 2)] = 0.3578
        pgm_function7[(1, 2, 3)] = 0.1533
        pgm_function7[(1, 2, 4)] = 0.0211
        pgm_function7[(1, 3, 0)] = 0.360036281
        pgm_function7[(1, 3, 1)] = 0.17781807
        pgm_function7[(1, 3, 2)] = 0.03109692
        pgm_function7[(1, 4, 0)] = 0.0267
        pgm_function7[(2, 0, 4)] = 0.0267
        pgm_function7[(2, 0, 5)] = 0.2622
        pgm_function7[(2, 0, 6)] = 0.43338674
        pgm_function7[(2, 0, 7)] = 0.2956
        pgm_function7[(2, 0, 8)] = 0.0678
        pgm_function7[(2, 1, 2)] = 0.0178
        pgm_function7[(2, 1, 3)] = 0.17
        pgm_function7[(2, 1, 4)] = 0.3789
        pgm_function7[(2, 1, 5)] = 0.3478
        pgm_function7[(2, 1, 6)] = 0.151115041
        pgm_function7[(2, 1, 7)] = 0.0189
        pgm_function7[(2, 2, 0)] = 0.01
        pgm_function7[(2, 2, 1)] = 0.1478
        pgm_function7[(2, 2, 2)] = 0.3578
        pgm_function7[(2, 2, 3)] = 0.3689
        pgm_function7[(2, 2, 4)] = 0.1756
        pgm_function7[(2, 2, 5)] = 0.0267
        pgm_function7[(2, 3, 0)] = 0.374437292
        pgm_function7[(2, 3, 1)] = 0.38333815
        pgm_function7[(2, 3, 2)] = 0.19778014
        pgm_function7[(2, 3, 3)] = 0.0356
        pgm_function7[(2, 4, 0)] = 0.1978
        pgm_function7[(2, 4, 1)] = 0.0511
        pgm_function7[(2, 4, 2)] = 0.001099891
        pgm_function7[(3, 0, 5)] = 0.02
        pgm_function7[(3, 0, 6)] = 0.23444686
        pgm_function7[(3, 0, 7)] = 0.4333
        pgm_function7[(3, 0, 8)] = 0.3189
        pgm_function7[(3, 0, 9)] = 0.078907952
        pgm_function7[(3, 1, 3)] = 0.0133
        pgm_function7[(3, 1, 4)] = 0.1522
        pgm_function7[(3, 1, 5)] = 0.3633
        pgm_function7[(3, 1, 6)] = 0.361136098
        pgm_function7[(3, 1, 7)] = 0.1689
        pgm_function7[(3, 1, 8)] = 0.025597418
        pgm_function7[(3, 2, 1)] = 0.0078
        pgm_function7[(3, 2, 2)] = 0.1289
        pgm_function7[(3, 2, 3)] = 0.3456
        pgm_function7[(3, 2, 4)] = 0.3733
        pgm_function7[(3, 2, 5)] = 0.1944
        pgm_function7[(3, 2, 6)] = 0.03440342
        pgm_function7[(3, 3, 0)] = 0.123312096
        pgm_function7[(3, 3, 1)] = 0.32223213
        pgm_function7[(3, 3, 2)] = 0.38666127
        pgm_function7[(3, 3, 3)] = 0.2189
        pgm_function7[(3, 3, 4)] = 0.0467
        pgm_function7[(3, 4, 0)] = 0.3911
        pgm_function7[(3, 4, 1)] = 0.2378
        pgm_function7[(3, 4, 2)] = 0.058894142
        pgm_function7[(3, 4, 3)] = 0.0011
        pgm_function7[(3, 5, 0)] = 0.0478
        pgm_function7[(3, 5, 1)] = 0.0044
        pgm_function7[(4, 0, 6)] = 0.01440289
        pgm_function7[(4, 0, 7)] = 0.2078
        pgm_function7[(4, 0, 8)] = 0.4233
        pgm_function7[(4, 0, 9)] = 0.343334227
        pgm_function7[(4, 0, 10)] = 0.0956
        pgm_function7[(4, 1, 4)] = 0.0089
        pgm_function7[(4, 1, 5)] = 0.1378
        pgm_function7[(4, 1, 6)] = 0.345635093
        pgm_function7[(4, 1, 7)] = 0.3722
        pgm_function7[(4, 1, 8)] = 0.185581132
        pgm_function7[(4, 1, 9)] = 0.0322
        pgm_function7[(4, 2, 2)] = 0.0044
        pgm_function7[(4, 2, 3)] = 0.1122
        pgm_function7[(4, 2, 4)] = 0.33
        pgm_function7[(4, 2, 5)] = 0.38
        pgm_function7[(4, 2, 6)] = 0.21112111
        pgm_function7[(4, 2, 7)] = 0.0433
        pgm_function7[(4, 3, 0)] = 0.002200222
        pgm_function7[(4, 3, 1)] = 0.09110914
        pgm_function7[(4, 3, 2)] = 0.30886922
        pgm_function7[(4, 3, 3)] = 0.39
        pgm_function7[(4, 3, 4)] = 0.2356
        pgm_function7[(4, 3, 5)] = 0.05560567
        pgm_function7[(4, 3, 6)] = 0.001099891
        pgm_function7[(4, 4, 0)] = 0.31
        pgm_function7[(4, 4, 1)] = 0.4011
        pgm_function7[(4, 4, 2)] = 0.255574181
        pgm_function7[(4, 4, 3)] = 0.0722
        pgm_function7[(4, 4, 4)] = 0.0022
        pgm_function7[(4, 5, 0)] = 0.2633
        pgm_function7[(4, 5, 1)] = 0.0844
        pgm_function7[(4, 5, 2)] = 0.005600566
        pgm_function7[(5, 0, 7)] = 0.0111
        pgm_function7[(5, 0, 8)] = 0.1822
        pgm_function7[(5, 0, 9)] = 0.410041271
        pgm_function7[(5, 0, 10)] = 0.3589
        pgm_function7[(5, 0, 11)] = 0.118912106
        pgm_function7[(5, 1, 5)] = 0.0056
        pgm_function7[(5, 1, 6)] = 0.124412034
        pgm_function7[(5, 1, 7)] = 0.3311
        pgm_function7[(5, 1, 8)] = 0.377762268
        pgm_function7[(5, 1, 9)] = 0.2022
        pgm_function7[(5, 1, 10)] = 0.03999603
        pgm_function7[(5, 2, 3)] = 0.0022
        pgm_function7[(5, 2, 4)] = 0.0989
        pgm_function7[(5, 2, 5)] = 0.3133
        pgm_function7[(5, 2, 6)] = 0.38893919
        pgm_function7[(5, 2, 7)] = 0.2256
        pgm_function7[(5, 2, 8)] = 0.0533
        pgm_function7[(5, 2, 9)] = 0.001100111
        pgm_function7[(5, 3, 1)] = 0.00110011
        pgm_function7[(5, 3, 2)] = 0.07559245
        pgm_function7[(5, 3, 3)] = 0.2922
        pgm_function7[(5, 3, 4)] = 0.3922
        pgm_function7[(5, 3, 5)] = 0.25442531
        pgm_function7[(5, 3, 6)] = 0.066693367
        pgm_function7[(5, 3, 7)] = 0.0022
        pgm_function7[(5, 4, 0)] = 0.0744
        pgm_function7[(5, 4, 1)] = 0.2633
        pgm_function7[(5, 4, 2)] = 0.401060285
        pgm_function7[(5, 4, 3)] = 0.2756
        pgm_function7[(5, 4, 4)] = 0.0822
        pgm_function7[(5, 4, 5)] = 0.004399564
        pgm_function7[(5, 5, 0)] = 0.4067
        pgm_function7[(5, 5, 1)] = 0.2978
        pgm_function7[(5, 5, 2)] = 0.100010104
        pgm_function7[(5, 5, 3)] = 0.007800789
        pgm_function7[(5, 6, 0)] = 0.0978
        pgm_function7[(5, 6, 1)] = 0.012198809
        pgm_function7[(6, 0, 8)] = 0.0078
        pgm_function7[(6, 0, 9)] = 0.163316108
        pgm_function7[(6, 0, 10)] = 0.4033
        pgm_function7[(6, 0, 11)] = 0.363336323
        pgm_function7[(6, 0, 12)] = 0.1433
        pgm_function7[(6, 0, 13)] = 0.005599443
        pgm_function7[(6, 1, 6)] = 0.003300331
        pgm_function7[(6, 1, 7)] = 0.1067
        pgm_function7[(6, 1, 8)] = 0.319968227
        pgm_function7[(6, 1, 9)] = 0.3833
        pgm_function7[(6, 1, 10)] = 0.22217816
        pgm_function7[(6, 1, 11)] = 0.0489
        pgm_function7[(6, 1, 12)] = 0.0011
        pgm_function7[(6, 2, 4)] = 0.0011
        pgm_function7[(6, 2, 5)] = 0.0856
        pgm_function7[(6, 2, 6)] = 0.29442915
        pgm_function7[(6, 2, 7)] = 0.3944
        pgm_function7[(6, 2, 8)] = 0.2411
        pgm_function7[(6, 2, 9)] = 0.064406438
        pgm_function7[(6, 2, 10)] = 0.002200221
        pgm_function7[(6, 3, 3)] = 0.0633
        pgm_function7[(6, 3, 4)] = 0.2733
        pgm_function7[(6, 3, 5)] = 0.39333947
        pgm_function7[(6, 3, 6)] = 0.26777327
        pgm_function7[(6, 3, 7)] = 0.08
        pgm_function7[(6, 3, 8)] = 0.0044
        pgm_function7[(6, 4, 1)] = 0.0467
        pgm_function7[(6, 4, 2)] = 0.246675175
        pgm_function7[(6, 4, 3)] = 0.3944
        pgm_function7[(6, 4, 4)] = 0.2956
        pgm_function7[(6, 4, 5)] = 0.09559048
        pgm_function7[(6, 4, 6)] = 0.0067
        pgm_function7[(6, 5, 0)] = 0.2533
        pgm_function7[(6, 5, 1)] = 0.3956
        pgm_function7[(6, 5, 2)] = 0.314431327
        pgm_function7[(6, 5, 3)] = 0.113311127
        pgm_function7[(6, 5, 4)] = 0.0111
        pgm_function7[(6, 6, 0)] = 0.3178
        pgm_function7[(6, 6, 1)] = 0.135586103
        pgm_function7[(6, 6, 2)] = 0.0167
        pgm_function7[(6, 7, 0)] = 0.015598411
        pgm_function7[(7, 0, 9)] = 0.004400443
        pgm_function7[(7, 0, 10)] = 0.14
        pgm_function7[(7, 0, 11)] = 0.39333935
        pgm_function7[(7, 0, 12)] = 0.3722
        pgm_function7[(7, 0, 13)] = 0.157784088
        pgm_function7[(7, 0, 14)] = 0.01220121
        pgm_function7[(7, 1, 7)] = 0.0022
        pgm_function7[(7, 1, 8)] = 0.089991064
        pgm_function7[(7, 1, 9)] = 0.3056
        pgm_function7[(7, 1, 10)] = 0.38556127
        pgm_function7[(7, 1, 11)] = 0.24
        pgm_function7[(7, 1, 12)] = 0.0589
        pgm_function7[(7, 1, 13)] = 0.0022
        pgm_function7[(7, 2, 6)] = 0.07110714
        pgm_function7[(7, 2, 7)] = 0.2789
        pgm_function7[(7, 2, 8)] = 0.3956
        pgm_function7[(7, 2, 9)] = 0.258926153
        pgm_function7[(7, 2, 10)] = 0.073307328
        pgm_function7[(7, 2, 11)] = 0.004400439
        pgm_function7[(7, 3, 4)] = 0.0522
        pgm_function7[(7, 3, 5)] = 0.25442531
        pgm_function7[(7, 3, 6)] = 0.396660401
        pgm_function7[(7, 3, 7)] = 0.28
        pgm_function7[(7, 3, 8)] = 0.0922
        pgm_function7[(7, 3, 9)] = 0.006699332
        pgm_function7[(7, 4, 2)] = 0.036696326
        pgm_function7[(7, 4, 3)] = 0.2278
        pgm_function7[(7, 4, 4)] = 0.3878
        pgm_function7[(7, 4, 5)] = 0.307769259
        pgm_function7[(7, 4, 6)] = 0.11
        pgm_function7[(7, 4, 7)] = 0.01
        pgm_function7[(7, 5, 0)] = 0.0289
        pgm_function7[(7, 5, 1)] = 0.1978
        pgm_function7[(7, 5, 2)] = 0.3844384
        pgm_function7[(7, 5, 3)] = 0.332233372
        pgm_function7[(7, 5, 4)] = 0.1289
        pgm_function7[(7, 5, 5)] = 0.0144
        pgm_function7[(7, 6, 0)] = 0.3922
        pgm_function7[(7, 6, 1)] = 0.347765264
        pgm_function7[(7, 6, 2)] = 0.15
        pgm_function7[(7, 6, 3)] = 0.021102114
        pgm_function7[(7, 7, 0)] = 0.143286102
        pgm_function7[(7, 7, 1)] = 0.02890292
        pgm_function7[(8, 0, 10)] = 0.0022
        pgm_function7[(8, 0, 11)] = 0.12331211
        pgm_function7[(8, 0, 12)] = 0.3856
        pgm_function7[(8, 0, 13)] = 0.386661217
        pgm_function7[(8, 0, 14)] = 0.17001712
        pgm_function7[(8, 0, 15)] = 0.0189
        pgm_function7[(8, 1, 8)] = 0.001099891
        pgm_function7[(8, 1, 9)] = 0.0767
        pgm_function7[(8, 1, 10)] = 0.2855712
        pgm_function7[(8, 1, 11)] = 0.3911
        pgm_function7[(8, 1, 12)] = 0.2544
        pgm_function7[(8, 1, 13)] = 0.0689
        pgm_function7[(8, 1, 14)] = 0.00440044
        pgm_function7[(8, 2, 7)] = 0.0578
        pgm_function7[(8, 2, 8)] = 0.2633
        pgm_function7[(8, 2, 9)] = 0.393339232
        pgm_function7[(8, 2, 10)] = 0.278928106
        pgm_function7[(8, 2, 11)] = 0.08440838
        pgm_function7[(8, 2, 12)] = 0.006699331
        pgm_function7[(8, 3, 5)] = 0.04220425
        pgm_function7[(8, 3, 6)] = 0.235576238
        pgm_function7[(8, 3, 7)] = 0.3944
        pgm_function7[(8, 3, 8)] = 0.2967
        pgm_function7[(8, 3, 9)] = 0.103290038
        pgm_function7[(8, 3, 10)] = 0.01
        pgm_function7[(8, 4, 3)] = 0.0289
        pgm_function7[(8, 4, 4)] = 0.2089
        pgm_function7[(8, 4, 5)] = 0.388861327
        pgm_function7[(8, 4, 6)] = 0.3189
        pgm_function7[(8, 4, 7)] = 0.1256
        pgm_function7[(8, 4, 8)] = 0.0133
        pgm_function7[(8, 5, 1)] = 0.02
        pgm_function7[(8, 5, 2)] = 0.181118188
        pgm_function7[(8, 5, 3)] = 0.374437419
        pgm_function7[(8, 5, 4)] = 0.3433
        pgm_function7[(8, 5, 5)] = 0.1456
        pgm_function7[(8, 5, 6)] = 0.018901917
        pgm_function7[(8, 6, 0)] = 0.1833
        pgm_function7[(8, 6, 1)] = 0.361064274
        pgm_function7[(8, 6, 2)] = 0.3622
        pgm_function7[(8, 6, 3)] = 0.168917115
        pgm_function7[(8, 6, 4)] = 0.026697316
        pgm_function7[(8, 7, 0)] = 0.36556326
        pgm_function7[(8, 7, 1)] = 0.194419134
        pgm_function7[(8, 7, 2)] = 0.03559642
        pgm_function7[(8, 8, 0)] = 0.02889711
        pgm_function7[(9, 0, 11)] = 0.001100111
        pgm_function7[(9, 0, 12)] = 0.0978
        pgm_function7[(9, 0, 13)] = 0.369963207
        pgm_function7[(9, 0, 14)] = 0.40224028
        pgm_function7[(9, 0, 15)] = 0.1878
        pgm_function7[(9, 0, 16)] = 0.02669731
        pgm_function7[(9, 1, 10)] = 0.06669335
        pgm_function7[(9, 1, 11)] = 0.2656
        pgm_function7[(9, 1, 12)] = 0.3967
        pgm_function7[(9, 1, 13)] = 0.2678
        pgm_function7[(9, 1, 14)] = 0.0811081
        pgm_function7[(9, 1, 15)] = 0.006699337
        pgm_function7[(9, 2, 8)] = 0.0467
        pgm_function7[(9, 2, 9)] = 0.243324144
        pgm_function7[(9, 2, 10)] = 0.393339149
        pgm_function7[(9, 2, 11)] = 0.295629929
        pgm_function7[(9, 2, 12)] = 0.096690316
        pgm_function7[(9, 2, 13)] = 0.01
        pgm_function7[(9, 3, 6)] = 0.032196833
        pgm_function7[(9, 3, 7)] = 0.2178
        pgm_function7[(9, 3, 8)] = 0.3889
        pgm_function7[(9, 3, 9)] = 0.315568117
        pgm_function7[(9, 3, 10)] = 0.1167
        pgm_function7[(9, 3, 11)] = 0.0133
        pgm_function7[(9, 4, 4)] = 0.0233
        pgm_function7[(9, 4, 5)] = 0.185581156
        pgm_function7[(9, 4, 6)] = 0.3822
        pgm_function7[(9, 4, 7)] = 0.3333
        pgm_function7[(9, 4, 8)] = 0.1422
        pgm_function7[(9, 4, 9)] = 0.0178
        pgm_function7[(9, 5, 2)] = 0.014401415
        pgm_function7[(9, 5, 3)] = 0.16111618
        pgm_function7[(9, 5, 4)] = 0.3656
        pgm_function7[(9, 5, 5)] = 0.3556
        pgm_function7[(9, 5, 6)] = 0.163316144
        pgm_function7[(9, 5, 7)] = 0.024402412
        pgm_function7[(9, 6, 0)] = 0.0089
        pgm_function7[(9, 6, 1)] = 0.137786105
        pgm_function7[(9, 6, 2)] = 0.3456
        pgm_function7[(9, 6, 3)] = 0.371137252
        pgm_function7[(9, 6, 4)] = 0.185581113
        pgm_function7[(9, 6, 5)] = 0.03440341
        pgm_function7[(9, 7, 0)] = 0.355564252
        pgm_function7[(9, 7, 1)] = 0.380038262
        pgm_function7[(9, 7, 2)] = 0.21327913
        pgm_function7[(9, 7, 3)] = 0.04559091
        pgm_function7[(9, 8, 0)] = 0.2077791
        pgm_function7[(9, 8, 1)] = 0.0578
        pgm_function7[(9, 8, 2)] = 0.0011
        pgm_function7[(10, 0, 12)] = 0.0011
        pgm_function7[(10, 0, 13)] = 0.079992045
        pgm_function7[(10, 0, 14)] = 0.35443525
        pgm_function7[(10, 0, 15)] = 0.4033
        pgm_function7[(10, 0, 16)] = 0.2099791
        pgm_function7[(10, 0, 17)] = 0.03440341
        pgm_function7[(10, 1, 11)] = 0.0544
        pgm_function7[(10, 1, 12)] = 0.2456
        pgm_function7[(10, 1, 13)] = 0.3978
        pgm_function7[(10, 1, 14)] = 0.28222802
        pgm_function7[(10, 1, 15)] = 0.094390701
        pgm_function7[(10, 1, 16)] = 0.01
        pgm_function7[(10, 2, 9)] = 0.038903923
        pgm_function7[(10, 2, 10)] = 0.221122084
        pgm_function7[(10, 2, 11)] = 0.390038906
        pgm_function7[(10, 2, 12)] = 0.307769052
        pgm_function7[(10, 2, 13)] = 0.1133
        pgm_function7[(10, 2, 14)] = 0.0133
        pgm_function7[(10, 3, 7)] = 0.0256
        pgm_function7[(10, 3, 8)] = 0.1978
        pgm_function7[(10, 3, 9)] = 0.379962141
        pgm_function7[(10, 3, 10)] = 0.3311
        pgm_function7[(10, 3, 11)] = 0.1322
        pgm_function7[(10, 3, 12)] = 0.0178
        pgm_function7[(10, 4, 5)] = 0.017798215
        pgm_function7[(10, 4, 6)] = 0.17
        pgm_function7[(10, 4, 7)] = 0.3689
        pgm_function7[(10, 4, 8)] = 0.3456
        pgm_function7[(10, 4, 9)] = 0.1567
        pgm_function7[(10, 4, 10)] = 0.023302311
        pgm_function7[(10, 5, 3)] = 0.011101112
        pgm_function7[(10, 5, 4)] = 0.1433
        pgm_function7[(10, 5, 5)] = 0.3522
        pgm_function7[(10, 5, 6)] = 0.362236319
        pgm_function7[(10, 5, 7)] = 0.18331809
        pgm_function7[(10, 5, 8)] = 0.030003015
        pgm_function7[(10, 6, 1)] = 0.005599444
        pgm_function7[(10, 6, 2)] = 0.1222
        pgm_function7[(10, 6, 3)] = 0.332233226
        pgm_function7[(10, 6, 4)] = 0.379962232
        pgm_function7[(10, 6, 5)] = 0.20222004
        pgm_function7[(10, 6, 6)] = 0.0422
        pgm_function7[(10, 7, 0)] = 0.118888084
        pgm_function7[(10, 7, 1)] = 0.312231215
        pgm_function7[(10, 7, 2)] = 0.38556123
        pgm_function7[(10, 7, 3)] = 0.22555505
        pgm_function7[(10, 7, 4)] = 0.0556
        pgm_function7[(10, 7, 5)] = 0.0011
        pgm_function7[(10, 8, 0)] = 0.3999602
        pgm_function7[(10, 8, 1)] = 0.2533
        pgm_function7[(10, 8, 2)] = 0.0689
        pgm_function7[(10, 8, 3)] = 0.002200221
        pgm_function7[(10, 9, 0)] = 0.0622
        pgm_function7[(10, 9, 1)] = 0.005599444
        pgm_function7[(11, 0, 14)] = 0.06110614
        pgm_function7[(11, 0, 15)] = 0.3389
        pgm_function7[(11, 0, 16)] = 0.4077592
        pgm_function7[(11, 0, 17)] = 0.23112309
        pgm_function7[(11, 0, 18)] = 0.04330431
        pgm_function7[(11, 1, 12)] = 0.0433
        pgm_function7[(11, 1, 13)] = 0.2311
        pgm_function7[(11, 1, 14)] = 0.39113902
        pgm_function7[(11, 1, 15)] = 0.297770319
        pgm_function7[(11, 1, 16)] = 0.1044
        pgm_function7[(11, 1, 17)] = 0.01220121
        pgm_function7[(11, 2, 10)] = 0.031103112
        pgm_function7[(11, 2, 11)] = 0.201119952
        pgm_function7[(11, 2, 12)] = 0.387761066
        pgm_function7[(11, 2, 13)] = 0.3167
        pgm_function7[(11, 2, 14)] = 0.1267
        pgm_function7[(11, 2, 15)] = 0.0178
        pgm_function7[(11, 3, 8)] = 0.02
        pgm_function7[(11, 3, 9)] = 0.177782066
        pgm_function7[(11, 3, 10)] = 0.3722
        pgm_function7[(11, 3, 11)] = 0.34
        pgm_function7[(11, 3, 12)] = 0.15
        pgm_function7[(11, 3, 13)] = 0.023302311
        pgm_function7[(11, 4, 6)] = 0.0122
        pgm_function7[(11, 4, 7)] = 0.1544
        pgm_function7[(11, 4, 8)] = 0.3533
        pgm_function7[(11, 4, 9)] = 0.36
        pgm_function7[(11, 4, 10)] = 0.172217083
        pgm_function7[(11, 4, 11)] = 0.03
        pgm_function7[(11, 5, 4)] = 0.0078
        pgm_function7[(11, 5, 5)] = 0.1278
        pgm_function7[(11, 5, 6)] = 0.3411343
        pgm_function7[(11, 5, 7)] = 0.368937181
        pgm_function7[(11, 5, 8)] = 0.198920097
        pgm_function7[(11, 5, 9)] = 0.03890394
        pgm_function7[(11, 6, 2)] = 0.0033
        pgm_function7[(11, 6, 3)] = 0.104410071
        pgm_function7[(11, 6, 4)] = 0.318868195
        pgm_function7[(11, 6, 5)] = 0.38223808
        pgm_function7[(11, 6, 6)] = 0.2222
        pgm_function7[(11, 6, 7)] = 0.05000503
        pgm_function7[(11, 6, 8)] = 0.001100111
        pgm_function7[(11, 7, 0)] = 0.001099891
        pgm_function7[(11, 7, 1)] = 0.083308357
        pgm_function7[(11, 7, 2)] = 0.29557018
        pgm_function7[(11, 7, 3)] = 0.39552108
        pgm_function7[(11, 7, 4)] = 0.2411
        pgm_function7[(11, 7, 5)] = 0.0656
        pgm_function7[(11, 7, 6)] = 0.0022
        pgm_function7[(11, 8, 0)] = 0.29777015
        pgm_function7[(11, 8, 1)] = 0.3956
        pgm_function7[(11, 8, 2)] = 0.2689
        pgm_function7[(11, 8, 3)] = 0.081108123
        pgm_function7[(11, 8, 4)] = 0.0044
        pgm_function7[(11, 9, 0)] = 0.2678
        pgm_function7[(11, 9, 1)] = 0.094390672
        pgm_function7[(11, 9, 2)] = 0.0078
        pgm_function7[(11, 10, 0)] = 0.005599442
        pgm_function7[(12, 0, 15)] = 0.0511
        pgm_function7[(12, 0, 16)] = 0.31776816
        pgm_function7[(12, 0, 17)] = 0.41114116
        pgm_function7[(12, 0, 18)] = 0.25332508
        pgm_function7[(12, 0, 19)] = 0.0522
        pgm_function7[(12, 1, 13)] = 0.0322
        pgm_function7[(12, 1, 14)] = 0.21672201
        pgm_function7[(12, 1, 15)] = 0.385561413
        pgm_function7[(12, 1, 16)] = 0.3156
        pgm_function7[(12, 1, 17)] = 0.11891207
        pgm_function7[(12, 1, 18)] = 0.015598406
        pgm_function7[(12, 2, 11)] = 0.024402394
        pgm_function7[(12, 2, 12)] = 0.183282031
        pgm_function7[(12, 2, 13)] = 0.38
        pgm_function7[(12, 2, 14)] = 0.3333
        pgm_function7[(12, 2, 15)] = 0.14
        pgm_function7[(12, 2, 16)] = 0.0211
        pgm_function7[(12, 3, 9)] = 0.016698306
        pgm_function7[(12, 3, 10)] = 0.1578
        pgm_function7[(12, 3, 11)] = 0.3656
        pgm_function7[(12, 3, 12)] = 0.35
        pgm_function7[(12, 3, 13)] = 0.163316078
        pgm_function7[(12, 3, 14)] = 0.03
        pgm_function7[(12, 4, 7)] = 0.0078
        pgm_function7[(12, 4, 8)] = 0.1389
        pgm_function7[(12, 4, 9)] = 0.3411
        pgm_function7[(12, 4, 10)] = 0.368937177
        pgm_function7[(12, 4, 11)] = 0.19
        pgm_function7[(12, 4, 12)] = 0.03889612
        pgm_function7[(12, 5, 5)] = 0.0044
        pgm_function7[(12, 5, 6)] = 0.112211099
        pgm_function7[(12, 5, 7)] = 0.321132157
        pgm_function7[(12, 5, 8)] = 0.383338188
        pgm_function7[(12, 5, 9)] = 0.21442124
        pgm_function7[(12, 5, 10)] = 0.04779522
        pgm_function7[(12, 5, 11)] = 0.0011
        pgm_function7[(12, 6, 3)] = 0.002200221
        pgm_function7[(12, 6, 4)] = 0.087791254
        pgm_function7[(12, 6, 5)] = 0.30673106
        pgm_function7[(12, 6, 6)] = 0.3867
        pgm_function7[(12, 6, 7)] = 0.24002414
        pgm_function7[(12, 6, 8)] = 0.06110613
        pgm_function7[(12, 6, 9)] = 0.002200221
        pgm_function7[(12, 7, 1)] = 0.001100111
        pgm_function7[(12, 7, 2)] = 0.06999304
        pgm_function7[(12, 7, 3)] = 0.27774406
        pgm_function7[(12, 7, 4)] = 0.3933
        pgm_function7[(12, 7, 5)] = 0.2611
        pgm_function7[(12, 7, 6)] = 0.0767
        pgm_function7[(12, 7, 7)] = 0.0044
        pgm_function7[(12, 8, 0)] = 0.06559343
        pgm_function7[(12, 8, 1)] = 0.25
        pgm_function7[(12, 8, 2)] = 0.3967
        pgm_function7[(12, 8, 3)] = 0.282228079
        pgm_function7[(12, 8, 4)] = 0.0944
        pgm_function7[(12, 8, 5)] = 0.006698658
        pgm_function7[(12, 9, 0)] = 0.4078
        pgm_function7[(12, 9, 1)] = 0.309969236
        pgm_function7[(12, 9, 2)] = 0.11
        pgm_function7[(12, 9, 3)] = 0.0111
        pgm_function7[(12, 10, 0)] = 0.108889037
        pgm_function7[(12, 10, 1)] = 0.016701714
        pgm_function7[(13, 0, 16)] = 0.03779622
        pgm_function7[(13, 0, 17)] = 0.29112912
        pgm_function7[(13, 0, 18)] = 0.42114213
        pgm_function7[(13, 0, 19)] = 0.2678
        pgm_function7[(13, 0, 20)] = 0.06220623
        pgm_function7[(13, 1, 14)] = 0.0244024
        pgm_function7[(13, 1, 15)] = 0.195580209
        pgm_function7[(13, 1, 16)] = 0.38
        pgm_function7[(13, 1, 17)] = 0.3311332
        pgm_function7[(13, 1, 18)] = 0.135586052
        pgm_function7[(13, 1, 19)] = 0.0189
        pgm_function7[(13, 2, 12)] = 0.017798203
        pgm_function7[(13, 2, 13)] = 0.1678
        pgm_function7[(13, 2, 14)] = 0.3667
        pgm_function7[(13, 2, 15)] = 0.3489
        pgm_function7[(13, 2, 16)] = 0.1567
        pgm_function7[(13, 2, 17)] = 0.026702729
        pgm_function7[(13, 3, 10)] = 0.0122
        pgm_function7[(13, 3, 11)] = 0.1411
        pgm_function7[(13, 3, 12)] = 0.3522
        pgm_function7[(13, 3, 13)] = 0.361136173
        pgm_function7[(13, 3, 14)] = 0.1822
        pgm_function7[(13, 3, 15)] = 0.0356
        pgm_function7[(13, 4, 8)] = 0.0067
        pgm_function7[(13, 4, 9)] = 0.12
        pgm_function7[(13, 4, 10)] = 0.330033158
        pgm_function7[(13, 4, 11)] = 0.3733
        pgm_function7[(13, 4, 12)] = 0.2055791
        pgm_function7[(13, 4, 13)] = 0.04670474
        pgm_function7[(13, 4, 14)] = 0.00110011
        pgm_function7[(13, 5, 6)] = 0.002200222
        pgm_function7[(13, 5, 7)] = 0.10111005
        pgm_function7[(13, 5, 8)] = 0.302230148
        pgm_function7[(13, 5, 9)] = 0.38443842
        pgm_function7[(13, 5, 10)] = 0.23107712
        pgm_function7[(13, 5, 11)] = 0.0589
        pgm_function7[(13, 5, 12)] = 0.0022
        pgm_function7[(13, 6, 4)] = 0.001099891
        pgm_function7[(13, 6, 5)] = 0.07440741
        pgm_function7[(13, 6, 6)] = 0.2822
        pgm_function7[(13, 6, 7)] = 0.39333924
        pgm_function7[(13, 6, 8)] = 0.254425125
        pgm_function7[(13, 6, 9)] = 0.071107134
        pgm_function7[(13, 6, 10)] = 0.0044
        pgm_function7[(13, 7, 3)] = 0.05558891
        pgm_function7[(13, 7, 4)] = 0.2656
        pgm_function7[(13, 7, 5)] = 0.3922
        pgm_function7[(13, 7, 6)] = 0.2778
        pgm_function7[(13, 7, 7)] = 0.0867
        pgm_function7[(13, 7, 8)] = 0.006699332
        pgm_function7[(13, 8, 1)] = 0.0433
        pgm_function7[(13, 8, 2)] = 0.2322
        pgm_function7[(13, 8, 3)] = 0.39223911
        pgm_function7[(13, 8, 4)] = 0.2978
        pgm_function7[(13, 8, 5)] = 0.106678962
        pgm_function7[(13, 8, 6)] = 0.01
        pgm_function7[(13, 9, 0)] = 0.2344
        pgm_function7[(13, 9, 1)] = 0.386661294
        pgm_function7[(13, 9, 2)] = 0.3211
        pgm_function7[(13, 9, 3)] = 0.1267
        pgm_function7[(13, 9, 4)] = 0.0144
        pgm_function7[(13, 10, 0)] = 0.318868108
        pgm_function7[(13, 10, 1)] = 0.144414124
        pgm_function7[(13, 10, 2)] = 0.021102114
        pgm_function7[(13, 11, 0)] = 0.01670172
        pgm_function7[(14, 0, 17)] = 0.03220321
        pgm_function7[(14, 0, 18)] = 0.25782608
        pgm_function7[(14, 0, 19)] = 0.4278
        pgm_function7[(14, 0, 20)] = 0.28782914
        pgm_function7[(14, 0, 21)] = 0.0778
        pgm_function7[(14, 1, 15)] = 0.019998021
        pgm_function7[(14, 1, 16)] = 0.1722
        pgm_function7[(14, 1, 17)] = 0.37113722
        pgm_function7[(14, 1, 18)] = 0.34106613
        pgm_function7[(14, 1, 19)] = 0.1533
        pgm_function7[(14, 1, 20)] = 0.0256
        pgm_function7[(14, 2, 13)] = 0.0122
        pgm_function7[(14, 2, 14)] = 0.1511
        pgm_function7[(14, 2, 15)] = 0.3533
        pgm_function7[(14, 2, 16)] = 0.36
        pgm_function7[(14, 2, 17)] = 0.174417188
        pgm_function7[(14, 2, 18)] = 0.0333
        pgm_function7[(14, 3, 11)] = 0.0078
        pgm_function7[(14, 3, 12)] = 0.1256
        pgm_function7[(14, 3, 13)] = 0.337834162
        pgm_function7[(14, 3, 14)] = 0.37
        pgm_function7[(14, 3, 15)] = 0.1967
        pgm_function7[(14, 3, 16)] = 0.04440444
        pgm_function7[(14, 4, 9)] = 0.0044
        pgm_function7[(14, 4, 10)] = 0.10331005
        pgm_function7[(14, 4, 11)] = 0.3189
        pgm_function7[(14, 4, 12)] = 0.37556219
        pgm_function7[(14, 4, 13)] = 0.2244222
        pgm_function7[(14, 4, 14)] = 0.05330531
        pgm_function7[(14, 4, 15)] = 0.002200221
        pgm_function7[(14, 5, 7)] = 0.001100111
        pgm_function7[(14, 5, 8)] = 0.084408441
        pgm_function7[(14, 5, 9)] = 0.29222932
        pgm_function7[(14, 5, 10)] = 0.38776119
        pgm_function7[(14, 5, 11)] = 0.2444
        pgm_function7[(14, 5, 12)] = 0.0689
        pgm_function7[(14, 5, 13)] = 0.0044
        pgm_function7[(14, 6, 6)] = 0.0667
        pgm_function7[(14, 6, 7)] = 0.26222616
        pgm_function7[(14, 6, 8)] = 0.393339193
        pgm_function7[(14, 6, 9)] = 0.267827129
        pgm_function7[(14, 6, 10)] = 0.0844
        pgm_function7[(14, 6, 11)] = 0.0067
        pgm_function7[(14, 7, 4)] = 0.0444
        pgm_function7[(14, 7, 5)] = 0.2411
        pgm_function7[(14, 7, 6)] = 0.3911
        pgm_function7[(14, 7, 7)] = 0.2956
        pgm_function7[(14, 7, 8)] = 0.098890137
        pgm_function7[(14, 7, 9)] = 0.01
        pgm_function7[(14, 8, 2)] = 0.0322
        pgm_function7[(14, 8, 3)] = 0.217822061
        pgm_function7[(14, 8, 4)] = 0.3878
        pgm_function7[(14, 8, 5)] = 0.315536886
        pgm_function7[(14, 8, 6)] = 0.1189
        pgm_function7[(14, 8, 7)] = 0.0133
        pgm_function7[(14, 9, 0)] = 0.0278
        pgm_function7[(14, 9, 1)] = 0.185581141
        pgm_function7[(14, 9, 2)] = 0.3822
        pgm_function7[(14, 9, 3)] = 0.3322
        pgm_function7[(14, 9, 4)] = 0.1422
        pgm_function7[(14, 9, 5)] = 0.0178
        pgm_function7[(14, 10, 0)] = 0.38326213
        pgm_function7[(14, 10, 1)] = 0.354435305
        pgm_function7[(14, 10, 2)] = 0.16221611
        pgm_function7[(14, 10, 3)] = 0.0267
        pgm_function7[(14, 11, 0)] = 0.161116192
        pgm_function7[(14, 11, 1)] = 0.0356
        pgm_function7[(15, 0, 18)] = 0.02440241
        pgm_function7[(15, 0, 19)] = 0.2344
        pgm_function7[(15, 0, 20)] = 0.42444221
        pgm_function7[(15, 0, 21)] = 0.3089
        pgm_function7[(15, 0, 22)] = 0.09
        pgm_function7[(15, 1, 16)] = 0.0178
        pgm_function7[(15, 1, 17)] = 0.15441509
        pgm_function7[(15, 1, 18)] = 0.358864136
        pgm_function7[(15, 1, 19)] = 0.35
        pgm_function7[(15, 1, 20)] = 0.1689
        pgm_function7[(15, 1, 21)] = 0.0311
        pgm_function7[(15, 2, 14)] = 0.0089
        pgm_function7[(15, 2, 15)] = 0.1322
        pgm_function7[(15, 2, 16)] = 0.3422
        pgm_function7[(15, 2, 17)] = 0.364436394
        pgm_function7[(15, 2, 18)] = 0.1922
        pgm_function7[(15, 2, 19)] = 0.042195838
        pgm_function7[(15, 3, 12)] = 0.0044
        pgm_function7[(15, 3, 13)] = 0.112211054
        pgm_function7[(15, 3, 14)] = 0.3189
        pgm_function7[(15, 3, 15)] = 0.3822
        pgm_function7[(15, 3, 16)] = 0.21332117
        pgm_function7[(15, 3, 17)] = 0.0522
        pgm_function7[(15, 3, 18)] = 0.001099891
        pgm_function7[(15, 4, 10)] = 0.002200221
        pgm_function7[(15, 4, 11)] = 0.0867
        pgm_function7[(15, 4, 12)] = 0.30437015
        pgm_function7[(15, 4, 13)] = 0.38443835
        pgm_function7[(15, 4, 14)] = 0.23892405
        pgm_function7[(15, 4, 15)] = 0.063306318
        pgm_function7[(15, 4, 16)] = 0.00330033
        pgm_function7[(15, 5, 8)] = 0.001100111
        pgm_function7[(15, 5, 9)] = 0.07000708
        pgm_function7[(15, 5, 10)] = 0.27667214
        pgm_function7[(15, 5, 11)] = 0.3889
        pgm_function7[(15, 5, 12)] = 0.2622
        pgm_function7[(15, 5, 13)] = 0.0778
        pgm_function7[(15, 5, 14)] = 0.0067
        pgm_function7[(15, 6, 7)] = 0.05440543
        pgm_function7[(15, 6, 8)] = 0.246725121
        pgm_function7[(15, 6, 9)] = 0.394439189
        pgm_function7[(15, 6, 10)] = 0.2833
        pgm_function7[(15, 6, 11)] = 0.0956
        pgm_function7[(15, 6, 12)] = 0.01
        pgm_function7[(15, 7, 5)] = 0.0389
        pgm_function7[(15, 7, 6)] = 0.2211
        pgm_function7[(15, 7, 7)] = 0.3889
        pgm_function7[(15, 7, 8)] = 0.306669113
        pgm_function7[(15, 7, 9)] = 0.1156
        pgm_function7[(15, 7, 10)] = 0.01330131
        pgm_function7[(15, 8, 3)] = 0.024402407
        pgm_function7[(15, 8, 4)] = 0.1956
        pgm_function7[(15, 8, 5)] = 0.377723864
        pgm_function7[(15, 8, 6)] = 0.3333
        pgm_function7[(15, 8, 7)] = 0.1356
        pgm_function7[(15, 8, 8)] = 0.0178
        pgm_function7[(15, 9, 1)] = 0.017798214
        pgm_function7[(15, 9, 2)] = 0.1667
        pgm_function7[(15, 9, 3)] = 0.37
        pgm_function7[(15, 9, 4)] = 0.3489
        pgm_function7[(15, 9, 5)] = 0.1589
        pgm_function7[(15, 9, 6)] = 0.024402409
        pgm_function7[(15, 10, 0)] = 0.17558206
        pgm_function7[(15, 10, 1)] = 0.354435305
        pgm_function7[(15, 10, 2)] = 0.362236246
        pgm_function7[(15, 10, 3)] = 0.1822
        pgm_function7[(15, 10, 4)] = 0.03220321
        pgm_function7[(15, 11, 0)] = 0.363336432
        pgm_function7[(15, 11, 1)] = 0.2033
        pgm_function7[(15, 11, 2)] = 0.0456
        pgm_function7[(15, 12, 0)] = 0.0378
        pgm_function7[(15, 12, 1)] = 0.0011
        pgm_function7[(16, 0, 19)] = 0.0178
        pgm_function7[(16, 0, 20)] = 0.21222111
        pgm_function7[(16, 0, 21)] = 0.41
        pgm_function7[(16, 0, 22)] = 0.3289
        pgm_function7[(16, 0, 23)] = 0.1122
        pgm_function7[(16, 1, 17)] = 0.01220121
        pgm_function7[(16, 1, 18)] = 0.141086054
        pgm_function7[(16, 1, 19)] = 0.3467
        pgm_function7[(16, 1, 20)] = 0.3611
        pgm_function7[(16, 1, 21)] = 0.1856
        pgm_function7[(16, 1, 22)] = 0.0389
        pgm_function7[(16, 2, 15)] = 0.0078
        pgm_function7[(16, 2, 16)] = 0.1156
        pgm_function7[(16, 2, 17)] = 0.331133358
        pgm_function7[(16, 2, 18)] = 0.3689
        pgm_function7[(16, 2, 19)] = 0.207779189
        pgm_function7[(16, 2, 20)] = 0.05
        pgm_function7[(16, 2, 21)] = 0.0011
        pgm_function7[(16, 3, 13)] = 0.002200221
        pgm_function7[(16, 3, 14)] = 0.0967
        pgm_function7[(16, 3, 15)] = 0.3022
        pgm_function7[(16, 3, 16)] = 0.38333831
        pgm_function7[(16, 3, 17)] = 0.2333
        pgm_function7[(16, 3, 18)] = 0.06329377
        pgm_function7[(16, 3, 19)] = 0.002200221
        pgm_function7[(16, 4, 11)] = 0.0011
        pgm_function7[(16, 4, 12)] = 0.07559244
        pgm_function7[(16, 4, 13)] = 0.28002825
        pgm_function7[(16, 4, 14)] = 0.39443907
        pgm_function7[(16, 4, 15)] = 0.255626072
        pgm_function7[(16, 4, 16)] = 0.0744074
        pgm_function7[(16, 4, 17)] = 0.0044
        pgm_function7[(16, 5, 10)] = 0.05669433
        pgm_function7[(16, 5, 11)] = 0.2611
        pgm_function7[(16, 5, 12)] = 0.3911
        pgm_function7[(16, 5, 13)] = 0.2778
        pgm_function7[(16, 5, 14)] = 0.0889
        pgm_function7[(16, 5, 15)] = 0.01
        pgm_function7[(16, 6, 8)] = 0.043304321
        pgm_function7[(16, 6, 9)] = 0.232223111
        pgm_function7[(16, 6, 10)] = 0.3856
        pgm_function7[(16, 6, 11)] = 0.3
        pgm_function7[(16, 6, 12)] = 0.1089
        pgm_function7[(16, 6, 13)] = 0.01330131
        pgm_function7[(16, 7, 6)] = 0.0311
        pgm_function7[(16, 7, 7)] = 0.2
        pgm_function7[(16, 7, 8)] = 0.385561143
        pgm_function7[(16, 7, 9)] = 0.3178
        pgm_function7[(16, 7, 10)] = 0.13111309
        pgm_function7[(16, 7, 11)] = 0.017798208
        pgm_function7[(16, 8, 4)] = 0.02
        pgm_function7[(16, 8, 5)] = 0.176664936
        pgm_function7[(16, 8, 6)] = 0.3689
        pgm_function7[(16, 8, 7)] = 0.3389
        pgm_function7[(16, 8, 8)] = 0.1533
        pgm_function7[(16, 8, 9)] = 0.023302309
        pgm_function7[(16, 9, 2)] = 0.0122
        pgm_function7[(16, 9, 3)] = 0.1522
        pgm_function7[(16, 9, 4)] = 0.3511
        pgm_function7[(16, 9, 5)] = 0.3622
        pgm_function7[(16, 9, 6)] = 0.174417066
        pgm_function7[(16, 9, 7)] = 0.03000303
        pgm_function7[(16, 10, 0)] = 0.007799223
        pgm_function7[(16, 10, 1)] = 0.125613108
        pgm_function7[(16, 10, 2)] = 0.341134232
        pgm_function7[(16, 10, 3)] = 0.3711
        pgm_function7[(16, 10, 4)] = 0.19892008
        pgm_function7[(16, 10, 5)] = 0.0411
        pgm_function7[(16, 11, 0)] = 0.354435422
        pgm_function7[(16, 11, 1)] = 0.3789
        pgm_function7[(16, 11, 2)] = 0.2211
        pgm_function7[(16, 11, 3)] = 0.05220523
        pgm_function7[(16, 11, 4)] = 0.00110011
        pgm_function7[(16, 12, 0)] = 0.2211
        pgm_function7[(16, 12, 1)] = 0.0689
        pgm_function7[(16, 12, 2)] = 0.0022
        pgm_function7[(17, 0, 20)] = 0.01330131
        pgm_function7[(17, 0, 21)] = 0.1933
        pgm_function7[(17, 0, 22)] = 0.4033
        pgm_function7[(17, 0, 23)] = 0.3389
        pgm_function7[(17, 0, 24)] = 0.1322
        pgm_function7[(17, 0, 25)] = 0.005599444
        pgm_function7[(17, 1, 18)] = 0.007799223
        pgm_function7[(17, 1, 19)] = 0.1267
        pgm_function7[(17, 1, 20)] = 0.3289
        pgm_function7[(17, 1, 21)] = 0.3722
        pgm_function7[(17, 1, 22)] = 0.2022
        pgm_function7[(17, 1, 23)] = 0.04669533
        pgm_function7[(17, 1, 24)] = 0.001099891
        pgm_function7[(17, 2, 16)] = 0.0044
        pgm_function7[(17, 2, 17)] = 0.101110109
        pgm_function7[(17, 2, 18)] = 0.3156
        pgm_function7[(17, 2, 19)] = 0.377762344
        pgm_function7[(17, 2, 20)] = 0.2244
        pgm_function7[(17, 2, 21)] = 0.06
        pgm_function7[(17, 2, 22)] = 0.0022
        pgm_function7[(17, 3, 14)] = 0.0022
        pgm_function7[(17, 3, 15)] = 0.0822
        pgm_function7[(17, 3, 16)] = 0.29112923
        pgm_function7[(17, 3, 17)] = 0.3811
        pgm_function7[(17, 3, 18)] = 0.247775275
        pgm_function7[(17, 3, 19)] = 0.073307343
        pgm_function7[(17, 3, 20)] = 0.00440044
        pgm_function7[(17, 4, 13)] = 0.06440646
        pgm_function7[(17, 4, 14)] = 0.25782605
        pgm_function7[(17, 4, 15)] = 0.39223911
        pgm_function7[(17, 4, 16)] = 0.27112699
        pgm_function7[(17, 4, 17)] = 0.0889
        pgm_function7[(17, 4, 18)] = 0.0078
        pgm_function7[(17, 5, 11)] = 0.0456
        pgm_function7[(17, 5, 12)] = 0.2378
        pgm_function7[(17, 5, 13)] = 0.3933
        pgm_function7[(17, 5, 14)] = 0.2944
        pgm_function7[(17, 5, 15)] = 0.1011
        pgm_function7[(17, 5, 16)] = 0.0122
        pgm_function7[(17, 6, 9)] = 0.032203215
        pgm_function7[(17, 6, 10)] = 0.2167
        pgm_function7[(17, 6, 11)] = 0.3844
        pgm_function7[(17, 6, 12)] = 0.3133
        pgm_function7[(17, 6, 13)] = 0.12001206
        pgm_function7[(17, 6, 14)] = 0.01779821
        pgm_function7[(17, 7, 7)] = 0.0244
        pgm_function7[(17, 7, 8)] = 0.184382068
        pgm_function7[(17, 7, 9)] = 0.3744
        pgm_function7[(17, 7, 10)] = 0.33003323
        pgm_function7[(17, 7, 11)] = 0.145585068
        pgm_function7[(17, 7, 12)] = 0.0222
        pgm_function7[(17, 8, 5)] = 0.016696694
        pgm_function7[(17, 8, 6)] = 0.1567
        pgm_function7[(17, 8, 7)] = 0.3633
        pgm_function7[(17, 8, 8)] = 0.3478
        pgm_function7[(17, 8, 9)] = 0.167817062
        pgm_function7[(17, 8, 10)] = 0.03
        pgm_function7[(17, 9, 3)] = 0.0078
        pgm_function7[(17, 9, 4)] = 0.1367
        pgm_function7[(17, 9, 5)] = 0.3378
        pgm_function7[(17, 9, 6)] = 0.366737139
        pgm_function7[(17, 9, 7)] = 0.193319191
        pgm_function7[(17, 9, 8)] = 0.03889612
        pgm_function7[(17, 10, 1)] = 0.004400444
        pgm_function7[(17, 10, 2)] = 0.111111076
        pgm_function7[(17, 10, 3)] = 0.3211
        pgm_function7[(17, 10, 4)] = 0.38223815
        pgm_function7[(17, 10, 5)] = 0.2144
        pgm_function7[(17, 10, 6)] = 0.04889513
        pgm_function7[(17, 10, 7)] = 0.001099891
        pgm_function7[(17, 11, 0)] = 0.103310123
        pgm_function7[(17, 11, 1)] = 0.3078
        pgm_function7[(17, 11, 2)] = 0.3856
        pgm_function7[(17, 11, 3)] = 0.24002412
        pgm_function7[(17, 11, 4)] = 0.06220622
        pgm_function7[(17, 11, 5)] = 0.002200221
        pgm_function7[(17, 12, 0)] = 0.3967
        pgm_function7[(17, 12, 1)] = 0.26
        pgm_function7[(17, 12, 2)] = 0.0778
        pgm_function7[(17, 12, 3)] = 0.0044
        pgm_function7[(17, 13, 0)] = 0.0722
        pgm_function7[(17, 13, 1)] = 0.007799225
        pgm_function7[(18, 0, 21)] = 0.01
        pgm_function7[(18, 0, 22)] = 0.1711
        pgm_function7[(18, 0, 23)] = 0.3978
        pgm_function7[(18, 0, 24)] = 0.35
        pgm_function7[(18, 0, 25)] = 0.137786092
        pgm_function7[(18, 0, 26)] = 0.0122
        pgm_function7[(18, 1, 19)] = 0.0044
        pgm_function7[(18, 1, 20)] = 0.1111
        pgm_function7[(18, 1, 21)] = 0.3133
        pgm_function7[(18, 1, 22)] = 0.3767
        pgm_function7[(18, 1, 23)] = 0.21887813
        pgm_function7[(18, 1, 24)] = 0.055594439
        pgm_function7[(18, 1, 25)] = 0.002200221
        pgm_function7[(18, 2, 17)] = 0.002200222
        pgm_function7[(18, 2, 18)] = 0.0889
        pgm_function7[(18, 2, 19)] = 0.295570269
        pgm_function7[(18, 2, 20)] = 0.3856
        pgm_function7[(18, 2, 21)] = 0.2389
        pgm_function7[(18, 2, 22)] = 0.0689
        pgm_function7[(18, 2, 23)] = 0.004399564
        pgm_function7[(18, 3, 15)] = 0.0011
        pgm_function7[(18, 3, 16)] = 0.06780685
        pgm_function7[(18, 3, 17)] = 0.2756
        pgm_function7[(18, 3, 18)] = 0.385561428
        pgm_function7[(18, 3, 19)] = 0.261126151
        pgm_function7[(18, 3, 20)] = 0.08440841
        pgm_function7[(18, 3, 21)] = 0.0067
        pgm_function7[(18, 4, 14)] = 0.05440541
        pgm_function7[(18, 4, 15)] = 0.244424068
        pgm_function7[(18, 4, 16)] = 0.38673899
        pgm_function7[(18, 4, 17)] = 0.2867
        pgm_function7[(18, 4, 18)] = 0.0989
        pgm_function7[(18, 4, 19)] = 0.01000101
        pgm_function7[(18, 5, 12)] = 0.0378
        pgm_function7[(18, 5, 13)] = 0.2156
        pgm_function7[(18, 5, 14)] = 0.3878
        pgm_function7[(18, 5, 15)] = 0.3078
        pgm_function7[(18, 5, 16)] = 0.1167
        pgm_function7[(18, 5, 17)] = 0.01559841
        pgm_function7[(18, 6, 10)] = 0.0256
        pgm_function7[(18, 6, 11)] = 0.1922
        pgm_function7[(18, 6, 12)] = 0.3789
        pgm_function7[(18, 6, 13)] = 0.33113317
        pgm_function7[(18, 6, 14)] = 0.135586079
        pgm_function7[(18, 6, 15)] = 0.0211
        pgm_function7[(18, 7, 8)] = 0.017798207
        pgm_function7[(18, 7, 9)] = 0.17
        pgm_function7[(18, 7, 10)] = 0.36443626
        pgm_function7[(18, 7, 11)] = 0.345565162
        pgm_function7[(18, 7, 12)] = 0.1578
        pgm_function7[(18, 7, 13)] = 0.0289
        pgm_function7[(18, 8, 6)] = 0.0122
        pgm_function7[(18, 8, 7)] = 0.1411
        pgm_function7[(18, 8, 8)] = 0.3489
        pgm_function7[(18, 8, 9)] = 0.360036133
        pgm_function7[(18, 8, 10)] = 0.1844
        pgm_function7[(18, 8, 11)] = 0.0367
        pgm_function7[(18, 9, 4)] = 0.0067
        pgm_function7[(18, 9, 5)] = 0.1189
        pgm_function7[(18, 9, 6)] = 0.328933125
        pgm_function7[(18, 9, 7)] = 0.372237369
        pgm_function7[(18, 9, 8)] = 0.20777912
        pgm_function7[(18, 9, 9)] = 0.04779522
        pgm_function7[(18, 9, 10)] = 0.0011
        pgm_function7[(18, 10, 2)] = 0.002200221
        pgm_function7[(18, 10, 3)] = 0.0978
        pgm_function7[(18, 10, 4)] = 0.30223012
        pgm_function7[(18, 10, 5)] = 0.3867
        pgm_function7[(18, 10, 6)] = 0.23327714
        pgm_function7[(18, 10, 7)] = 0.059994049
        pgm_function7[(18, 10, 8)] = 0.0022
        pgm_function7[(18, 11, 0)] = 0.001100111
        pgm_function7[(18, 11, 1)] = 0.0744
        pgm_function7[(18, 11, 2)] = 0.2844
        pgm_function7[(18, 11, 3)] = 0.3911392
        pgm_function7[(18, 11, 4)] = 0.2567261
        pgm_function7[(18, 11, 5)] = 0.073307321
        pgm_function7[(18, 11, 6)] = 0.004400446
        pgm_function7[(18, 12, 0)] = 0.2844
        pgm_function7[(18, 12, 1)] = 0.3911
        pgm_function7[(18, 12, 2)] = 0.2789
        pgm_function7[(18, 12, 3)] = 0.09
        pgm_function7[(18, 12, 4)] = 0.0067
        pgm_function7[(18, 13, 0)] = 0.2711
        pgm_function7[(18, 13, 1)] = 0.106689062
        pgm_function7[(18, 13, 2)] = 0.01110111
        pgm_function7[(18, 14, 0)] = 0.0067
        pgm_function7[(19, 0, 22)] = 0.0067
        pgm_function7[(19, 0, 23)] = 0.1467
        pgm_function7[(19, 0, 24)] = 0.3867
        pgm_function7[(19, 0, 25)] = 0.369963248
        pgm_function7[(19, 0, 26)] = 0.1556
        pgm_function7[(19, 0, 27)] = 0.01890192
        pgm_function7[(19, 1, 20)] = 0.0044
        pgm_function7[(19, 1, 21)] = 0.0956
        pgm_function7[(19, 1, 22)] = 0.3
        pgm_function7[(19, 1, 23)] = 0.37776223
        pgm_function7[(19, 1, 24)] = 0.236676168
        pgm_function7[(19, 1, 25)] = 0.064406437
        pgm_function7[(19, 1, 26)] = 0.0044
        pgm_function7[(19, 2, 18)] = 0.0011
        pgm_function7[(19, 2, 19)] = 0.075592469
        pgm_function7[(19, 2, 20)] = 0.2767
        pgm_function7[(19, 2, 21)] = 0.39
        pgm_function7[(19, 2, 22)] = 0.2556
        pgm_function7[(19, 2, 23)] = 0.078892174
        pgm_function7[(19, 2, 24)] = 0.006699334
        pgm_function7[(19, 3, 17)] = 0.0578
        pgm_function7[(19, 3, 18)] = 0.255574284
        pgm_function7[(19, 3, 19)] = 0.390039226
        pgm_function7[(19, 3, 20)] = 0.27672802
        pgm_function7[(19, 3, 21)] = 0.0956
        pgm_function7[(19, 3, 22)] = 0.01
        pgm_function7[(19, 4, 15)] = 0.042204212
        pgm_function7[(19, 4, 16)] = 0.23112299
        pgm_function7[(19, 4, 17)] = 0.3822
        pgm_function7[(19, 4, 18)] = 0.3033
        pgm_function7[(19, 4, 19)] = 0.11331115
        pgm_function7[(19, 4, 20)] = 0.01330131
        pgm_function7[(19, 5, 13)] = 0.0311
        pgm_function7[(19, 5, 14)] = 0.1978
        pgm_function7[(19, 5, 15)] = 0.3811
        pgm_function7[(19, 5, 16)] = 0.3233
        pgm_function7[(19, 5, 17)] = 0.13108709
        pgm_function7[(19, 5, 18)] = 0.018898111
        pgm_function7[(19, 6, 11)] = 0.0211
        pgm_function7[(19, 6, 12)] = 0.1722
        pgm_function7[(19, 6, 13)] = 0.37003719
        pgm_function7[(19, 6, 14)] = 0.339966197
        pgm_function7[(19, 6, 15)] = 0.1533
        pgm_function7[(19, 6, 16)] = 0.0267
        pgm_function7[(19, 7, 9)] = 0.0122
        pgm_function7[(19, 7, 10)] = 0.15111511
        pgm_function7[(19, 7, 11)] = 0.351065165
        pgm_function7[(19, 7, 12)] = 0.3611
        pgm_function7[(19, 7, 13)] = 0.1767
        pgm_function7[(19, 7, 14)] = 0.0356
        pgm_function7[(19, 8, 7)] = 0.0078
        pgm_function7[(19, 8, 8)] = 0.1278
        pgm_function7[(19, 8, 9)] = 0.333333123
        pgm_function7[(19, 8, 10)] = 0.3711
        pgm_function7[(19, 8, 11)] = 0.2
        pgm_function7[(19, 8, 12)] = 0.0444
        pgm_function7[(19, 8, 13)] = 0.001100111
        pgm_function7[(19, 9, 5)] = 0.0044
        pgm_function7[(19, 9, 6)] = 0.103310039
        pgm_function7[(19, 9, 7)] = 0.314431311
        pgm_function7[(19, 9, 8)] = 0.37776223
        pgm_function7[(19, 9, 9)] = 0.22437809
        pgm_function7[(19, 9, 10)] = 0.0567
        pgm_function7[(19, 9, 11)] = 0.00220022
        pgm_function7[(19, 10, 3)] = 0.0011
        pgm_function7[(19, 10, 4)] = 0.08330833
        pgm_function7[(19, 10, 5)] = 0.2878
        pgm_function7[(19, 10, 6)] = 0.38556123
        pgm_function7[(19, 10, 7)] = 0.247775201
        pgm_function7[(19, 10, 8)] = 0.07
        pgm_function7[(19, 10, 9)] = 0.0044
        pgm_function7[(19, 11, 2)] = 0.0633
        pgm_function7[(19, 11, 3)] = 0.26332613
        pgm_function7[(19, 11, 4)] = 0.39333915
        pgm_function7[(19, 11, 5)] = 0.270027076
        pgm_function7[(19, 11, 6)] = 0.086708809
        pgm_function7[(19, 11, 7)] = 0.0067
        pgm_function7[(19, 12, 0)] = 0.06
        pgm_function7[(19, 12, 1)] = 0.2411
        pgm_function7[(19, 12, 2)] = 0.3911
        pgm_function7[(19, 12, 3)] = 0.2956
        pgm_function7[(19, 12, 4)] = 0.1011
        pgm_function7[(19, 12, 5)] = 0.01
        pgm_function7[(19, 13, 0)] = 0.4067
        pgm_function7[(19, 13, 1)] = 0.316668184
        pgm_function7[(19, 13, 2)] = 0.12001208
        pgm_function7[(19, 13, 3)] = 0.0144
        pgm_function7[(19, 14, 0)] = 0.1156
        pgm_function7[(19, 14, 1)] = 0.02
        pgm_function7[(20, 0, 23)] = 0.0044
        pgm_function7[(20, 0, 24)] = 0.1289
        pgm_function7[(20, 0, 25)] = 0.376662252
        pgm_function7[(20, 0, 26)] = 0.3811
        pgm_function7[(20, 0, 27)] = 0.17331714
        pgm_function7[(20, 0, 28)] = 0.02669731
        pgm_function7[(20, 1, 21)] = 0.0022
        pgm_function7[(20, 1, 22)] = 0.0811
        pgm_function7[(20, 1, 23)] = 0.28777117
        pgm_function7[(20, 1, 24)] = 0.378862269
        pgm_function7[(20, 1, 25)] = 0.252225146
        pgm_function7[(20, 1, 26)] = 0.0756
        pgm_function7[(20, 1, 27)] = 0.006698658
        pgm_function7[(20, 2, 19)] = 0.001099891
        pgm_function7[(20, 2, 20)] = 0.0633
        pgm_function7[(20, 2, 21)] = 0.2567
        pgm_function7[(20, 2, 22)] = 0.3878
        pgm_function7[(20, 2, 23)] = 0.275572259
        pgm_function7[(20, 2, 24)] = 0.091090952
        pgm_function7[(20, 2, 25)] = 0.01
        pgm_function7[(20, 3, 18)] = 0.046695352
        pgm_function7[(20, 3, 19)] = 0.234423136
        pgm_function7[(20, 3, 20)] = 0.38893902
        pgm_function7[(20, 3, 21)] = 0.2933
        pgm_function7[(20, 3, 22)] = 0.1089
        pgm_function7[(20, 3, 23)] = 0.01330271
        pgm_function7[(20, 4, 16)] = 0.0333033
        pgm_function7[(20, 4, 17)] = 0.2111
        pgm_function7[(20, 4, 18)] = 0.3778
        pgm_function7[(20, 4, 19)] = 0.31443141
        pgm_function7[(20, 4, 20)] = 0.12891306
        pgm_function7[(20, 4, 21)] = 0.0178
        pgm_function7[(20, 5, 14)] = 0.0244
        pgm_function7[(20, 5, 15)] = 0.1822
        pgm_function7[(20, 5, 16)] = 0.3678
        pgm_function7[(20, 5, 17)] = 0.33776624
        pgm_function7[(20, 5, 18)] = 0.146685084
        pgm_function7[(20, 5, 19)] = 0.024402404
        pgm_function7[(20, 6, 12)] = 0.0167
        pgm_function7[(20, 6, 13)] = 0.15331508
        pgm_function7[(20, 6, 14)] = 0.361064209
        pgm_function7[(20, 6, 15)] = 0.35
        pgm_function7[(20, 6, 16)] = 0.1689
        pgm_function7[(20, 6, 17)] = 0.03330331
        pgm_function7[(20, 7, 10)] = 0.01000101
        pgm_function7[(20, 7, 11)] = 0.133287063
        pgm_function7[(20, 7, 12)] = 0.3389
        pgm_function7[(20, 7, 13)] = 0.3622
        pgm_function7[(20, 7, 14)] = 0.1922
        pgm_function7[(20, 7, 15)] = 0.0444
        pgm_function7[(20, 8, 8)] = 0.0044
        pgm_function7[(20, 8, 9)] = 0.112211042
        pgm_function7[(20, 8, 10)] = 0.3156
        pgm_function7[(20, 8, 11)] = 0.3789
        pgm_function7[(20, 8, 12)] = 0.2178
        pgm_function7[(20, 8, 13)] = 0.052205246
        pgm_function7[(20, 8, 14)] = 0.002200222
        pgm_function7[(20, 9, 6)] = 0.002200221
        pgm_function7[(20, 9, 7)] = 0.088908988
        pgm_function7[(20, 9, 8)] = 0.29887018
        pgm_function7[(20, 9, 9)] = 0.38556115
        pgm_function7[(20, 9, 10)] = 0.2378
        pgm_function7[(20, 9, 11)] = 0.06440641
        pgm_function7[(20, 9, 12)] = 0.004400439
        pgm_function7[(20, 10, 4)] = 0.00110011
        pgm_function7[(20, 10, 5)] = 0.07
        pgm_function7[(20, 10, 6)] = 0.27557217
        pgm_function7[(20, 10, 7)] = 0.386661313
        pgm_function7[(20, 10, 8)] = 0.2622
        pgm_function7[(20, 10, 9)] = 0.0811
        pgm_function7[(20, 10, 10)] = 0.0067
        pgm_function7[(20, 11, 3)] = 0.05330533
        pgm_function7[(20, 11, 4)] = 0.24332409
        pgm_function7[(20, 11, 5)] = 0.390039109
        pgm_function7[(20, 11, 6)] = 0.284428358
        pgm_function7[(20, 11, 7)] = 0.0978
        pgm_function7[(20, 11, 8)] = 0.01
        pgm_function7[(20, 12, 1)] = 0.0378
        pgm_function7[(20, 12, 2)] = 0.2189
        pgm_function7[(20, 12, 3)] = 0.3878
        pgm_function7[(20, 12, 4)] = 0.3089
        pgm_function7[(20, 12, 5)] = 0.1178
        pgm_function7[(20, 12, 6)] = 0.0133
        pgm_function7[(20, 13, 0)] = 0.2256
        pgm_function7[(20, 13, 1)] = 0.377762219
        pgm_function7[(20, 13, 2)] = 0.33333323
        pgm_function7[(20, 13, 3)] = 0.1356
        pgm_function7[(20, 13, 4)] = 0.0178
        pgm_function7[(20, 14, 0)] = 0.3333
        pgm_function7[(20, 14, 1)] = 0.1567
        pgm_function7[(20, 14, 2)] = 0.0256
        pgm_function7[(20, 15, 0)] = 0.0244024
        pgm_function7[(21, 0, 24)] = 0.0022
        pgm_function7[(21, 0, 25)] = 0.108889073
        pgm_function7[(21, 0, 26)] = 0.3611
        pgm_function7[(21, 0, 27)] = 0.39003931
        pgm_function7[(21, 0, 28)] = 0.18668107
        pgm_function7[(21, 0, 29)] = 0.0344
        pgm_function7[(21, 1, 22)] = 0.0011
        pgm_function7[(21, 1, 23)] = 0.06889314
        pgm_function7[(21, 1, 24)] = 0.26777319
        pgm_function7[(21, 1, 25)] = 0.383338222
        pgm_function7[(21, 1, 26)] = 0.2633
        pgm_function7[(21, 1, 27)] = 0.086682669
        pgm_function7[(21, 1, 28)] = 0.009999003
        pgm_function7[(21, 2, 21)] = 0.0533
        pgm_function7[(21, 2, 22)] = 0.2433
        pgm_function7[(21, 2, 23)] = 0.379962357
        pgm_function7[(21, 2, 24)] = 0.287771164
        pgm_function7[(21, 2, 25)] = 0.1033
        pgm_function7[(21, 2, 26)] = 0.0133
        pgm_function7[(21, 3, 19)] = 0.038903923
        pgm_function7[(21, 3, 20)] = 0.21442101
        pgm_function7[(21, 3, 21)] = 0.3811
        pgm_function7[(21, 3, 22)] = 0.31
        pgm_function7[(21, 3, 23)] = 0.12222405
        pgm_function7[(21, 3, 24)] = 0.0178
        pgm_function7[(21, 4, 17)] = 0.0267
        pgm_function7[(21, 4, 18)] = 0.19
        pgm_function7[(21, 4, 19)] = 0.37443749
        pgm_function7[(21, 4, 20)] = 0.32673316
        pgm_function7[(21, 4, 21)] = 0.1444
        pgm_function7[(21, 4, 22)] = 0.022197817
        pgm_function7[(21, 5, 15)] = 0.0178
        pgm_function7[(21, 5, 16)] = 0.1667
        pgm_function7[(21, 5, 17)] = 0.35666425
        pgm_function7[(21, 5, 18)] = 0.346665198
        pgm_function7[(21, 5, 19)] = 0.164416026
        pgm_function7[(21, 5, 20)] = 0.030003023
        pgm_function7[(21, 6, 13)] = 0.01220121
        pgm_function7[(21, 6, 14)] = 0.13778608
        pgm_function7[(21, 6, 15)] = 0.3456
        pgm_function7[(21, 6, 16)] = 0.3611
        pgm_function7[(21, 6, 17)] = 0.18331803
        pgm_function7[(21, 6, 18)] = 0.042204225
        pgm_function7[(21, 7, 11)] = 0.006699333
        pgm_function7[(21, 7, 12)] = 0.1156
        pgm_function7[(21, 7, 13)] = 0.33
        pgm_function7[(21, 7, 14)] = 0.3689
        pgm_function7[(21, 7, 15)] = 0.2078
        pgm_function7[(21, 7, 16)] = 0.05220523
        pgm_function7[(21, 7, 17)] = 0.0011
        pgm_function7[(21, 8, 9)] = 0.003300331
        pgm_function7[(21, 8, 10)] = 0.0967
        pgm_function7[(21, 8, 11)] = 0.3022
        pgm_function7[(21, 8, 12)] = 0.3822
        pgm_function7[(21, 8, 13)] = 0.233323208
        pgm_function7[(21, 8, 14)] = 0.063306349
        pgm_function7[(21, 8, 15)] = 0.003300332
        pgm_function7[(21, 9, 7)] = 0.001100111
        pgm_function7[(21, 9, 8)] = 0.07669235
        pgm_function7[(21, 9, 9)] = 0.27667211
        pgm_function7[(21, 9, 10)] = 0.3933
        pgm_function7[(21, 9, 11)] = 0.25672605
        pgm_function7[(21, 9, 12)] = 0.07440739
        pgm_function7[(21, 9, 13)] = 0.006699331
        pgm_function7[(21, 10, 6)] = 0.05669433
        pgm_function7[(21, 10, 7)] = 0.257774209
        pgm_function7[(21, 10, 8)] = 0.3911
        pgm_function7[(21, 10, 9)] = 0.2767
        pgm_function7[(21, 10, 10)] = 0.09
        pgm_function7[(21, 10, 11)] = 0.01
        pgm_function7[(21, 11, 4)] = 0.04330432
        pgm_function7[(21, 11, 5)] = 0.232223065
        pgm_function7[(21, 11, 6)] = 0.384438484
        pgm_function7[(21, 11, 7)] = 0.3022
        pgm_function7[(21, 11, 8)] = 0.11
        pgm_function7[(21, 11, 9)] = 0.01330131
        pgm_function7[(21, 12, 2)] = 0.0311
        pgm_function7[(21, 12, 3)] = 0.1978
        pgm_function7[(21, 12, 4)] = 0.3833
        pgm_function7[(21, 12, 5)] = 0.3211
        pgm_function7[(21, 12, 6)] = 0.1311
        pgm_function7[(21, 12, 7)] = 0.0178
        pgm_function7[(21, 13, 0)] = 0.0244
        pgm_function7[(21, 13, 1)] = 0.173283101
        pgm_function7[(21, 13, 2)] = 0.36893726
        pgm_function7[(21, 13, 3)] = 0.3433
        pgm_function7[(21, 13, 4)] = 0.1544
        pgm_function7[(21, 13, 5)] = 0.024402407
        pgm_function7[(21, 14, 0)] = 0.3833
        pgm_function7[(21, 14, 1)] = 0.3644
        pgm_function7[(21, 14, 2)] = 0.1744
        pgm_function7[(21, 14, 3)] = 0.032203229
        pgm_function7[(21, 15, 0)] = 0.17671803
        pgm_function7[(21, 15, 1)] = 0.0433
        pgm_function7[(22, 0, 25)] = 0.001099891
        pgm_function7[(22, 0, 26)] = 0.0889
        pgm_function7[(22, 0, 27)] = 0.34443428
        pgm_function7[(22, 0, 28)] = 0.40326016
        pgm_function7[(22, 0, 29)] = 0.2056
        pgm_function7[(22, 0, 30)] = 0.04329575
        pgm_function7[(22, 1, 24)] = 0.059994043
        pgm_function7[(22, 1, 25)] = 0.250025145
        pgm_function7[(22, 1, 26)] = 0.3867
        pgm_function7[(22, 1, 27)] = 0.275544901
        pgm_function7[(22, 1, 28)] = 0.096690329
        pgm_function7[(22, 1, 29)] = 0.0133
        pgm_function7[(22, 2, 22)] = 0.0422
        pgm_function7[(22, 2, 23)] = 0.225577212
        pgm_function7[(22, 2, 24)] = 0.379962217
        pgm_function7[(22, 2, 25)] = 0.3
        pgm_function7[(22, 2, 26)] = 0.1156
        pgm_function7[(22, 2, 27)] = 0.0178
        pgm_function7[(22, 3, 20)] = 0.0311031
        pgm_function7[(22, 3, 21)] = 0.1989
        pgm_function7[(22, 3, 22)] = 0.3711
        pgm_function7[(22, 3, 23)] = 0.32116413
        pgm_function7[(22, 3, 24)] = 0.1367
        pgm_function7[(22, 3, 25)] = 0.0222
        pgm_function7[(22, 4, 18)] = 0.0222
        pgm_function7[(22, 4, 19)] = 0.17111722
        pgm_function7[(22, 4, 20)] = 0.36443618
        pgm_function7[(22, 4, 21)] = 0.3378
        pgm_function7[(22, 4, 22)] = 0.161084122
        pgm_function7[(22, 4, 23)] = 0.028902919
        pgm_function7[(22, 5, 16)] = 0.0133
        pgm_function7[(22, 5, 17)] = 0.1477851
        pgm_function7[(22, 5, 18)] = 0.3510652
        pgm_function7[(22, 5, 19)] = 0.353335057
        pgm_function7[(22, 5, 20)] = 0.181118141
        pgm_function7[(22, 5, 21)] = 0.0378
        pgm_function7[(22, 6, 14)] = 0.007799225
        pgm_function7[(22, 6, 15)] = 0.1256
        pgm_function7[(22, 6, 16)] = 0.3311
        pgm_function7[(22, 6, 17)] = 0.37003707
        pgm_function7[(22, 6, 18)] = 0.201120119
        pgm_function7[(22, 6, 19)] = 0.04779524
        pgm_function7[(22, 6, 20)] = 0.0011
        pgm_function7[(22, 7, 12)] = 0.0044
        pgm_function7[(22, 7, 13)] = 0.1
        pgm_function7[(22, 7, 14)] = 0.3133
        pgm_function7[(22, 7, 15)] = 0.3778
        pgm_function7[(22, 7, 16)] = 0.22442211
        pgm_function7[(22, 7, 17)] = 0.0622
        pgm_function7[(22, 7, 18)] = 0.002200221
        pgm_function7[(22, 8, 10)] = 0.0022
        pgm_function7[(22, 8, 11)] = 0.0811
        pgm_function7[(22, 8, 12)] = 0.2878
        pgm_function7[(22, 8, 13)] = 0.383338341
        pgm_function7[(22, 8, 14)] = 0.250025195
        pgm_function7[(22, 8, 15)] = 0.073307334
        pgm_function7[(22, 8, 16)] = 0.0044
        pgm_function7[(22, 9, 9)] = 0.06559343
        pgm_function7[(22, 9, 10)] = 0.2578
        pgm_function7[(22, 9, 11)] = 0.39223907
        pgm_function7[(22, 9, 12)] = 0.272226962
        pgm_function7[(22, 9, 13)] = 0.087791215
        pgm_function7[(22, 9, 14)] = 0.01
        pgm_function7[(22, 10, 7)] = 0.046695338
        pgm_function7[(22, 10, 8)] = 0.2367
        pgm_function7[(22, 10, 9)] = 0.3911
        pgm_function7[(22, 10, 10)] = 0.2944
        pgm_function7[(22, 10, 11)] = 0.1044
        pgm_function7[(22, 10, 12)] = 0.0133
        pgm_function7[(22, 11, 5)] = 0.032203209
        pgm_function7[(22, 11, 6)] = 0.21442127
        pgm_function7[(22, 11, 7)] = 0.3789
        pgm_function7[(22, 11, 8)] = 0.3144
        pgm_function7[(22, 11, 9)] = 0.12561306
        pgm_function7[(22, 11, 10)] = 0.01779821
        pgm_function7[(22, 12, 3)] = 0.0244
        pgm_function7[(22, 12, 4)] = 0.1822
        pgm_function7[(22, 12, 5)] = 0.37
        pgm_function7[(22, 12, 6)] = 0.3356
        pgm_function7[(22, 12, 7)] = 0.1478
        pgm_function7[(22, 12, 8)] = 0.0222
        pgm_function7[(22, 13, 1)] = 0.01779821
        pgm_function7[(22, 13, 2)] = 0.15441511
        pgm_function7[(22, 13, 3)] = 0.36
        pgm_function7[(22, 13, 4)] = 0.35
        pgm_function7[(22, 13, 5)] = 0.170017046
        pgm_function7[(22, 13, 6)] = 0.03
        pgm_function7[(22, 14, 0)] = 0.1533
        pgm_function7[(22, 14, 1)] = 0.3378
        pgm_function7[(22, 14, 2)] = 0.3689
        pgm_function7[(22, 14, 3)] = 0.192219171
        pgm_function7[(22, 14, 4)] = 0.04109593
        pgm_function7[(22, 15, 0)] = 0.36223607
        pgm_function7[(22, 15, 1)] = 0.2156
        pgm_function7[(22, 15, 2)] = 0.05109494
        pgm_function7[(22, 15, 3)] = 0.0011
        pgm_function7[(22, 16, 0)] = 0.04559541
        pgm_function7[(22, 16, 1)] = 0.00220022
        pgm_function7[(23, 0, 26)] = 0.0011
        pgm_function7[(23, 0, 27)] = 0.07330736
        pgm_function7[(23, 0, 28)] = 0.32666713
        pgm_function7[(23, 0, 29)] = 0.4033
        pgm_function7[(23, 0, 30)] = 0.22667725
        pgm_function7[(23, 0, 31)] = 0.0522
        pgm_function7[(23, 1, 25)] = 0.047804828
        pgm_function7[(23, 1, 26)] = 0.2311
        pgm_function7[(23, 1, 27)] = 0.385522861
        pgm_function7[(23, 1, 28)] = 0.293271088
        pgm_function7[(23, 1, 29)] = 0.1089
        pgm_function7[(23, 1, 30)] = 0.0167
        pgm_function7[(23, 2, 23)] = 0.035596433
        pgm_function7[(23, 2, 24)] = 0.206679118
        pgm_function7[(23, 2, 25)] = 0.3778
        pgm_function7[(23, 2, 26)] = 0.3111
        pgm_function7[(23, 2, 27)] = 0.1289
        pgm_function7[(23, 2, 28)] = 0.0222
        pgm_function7[(23, 3, 21)] = 0.0244
        pgm_function7[(23, 3, 22)] = 0.1811
        pgm_function7[(23, 3, 23)] = 0.36447315
        pgm_function7[(23, 3, 24)] = 0.3344
        pgm_function7[(23, 3, 25)] = 0.1511
        pgm_function7[(23, 3, 26)] = 0.0289
        pgm_function7[(23, 4, 19)] = 0.01670172
        pgm_function7[(23, 4, 20)] = 0.15441508
        pgm_function7[(23, 4, 21)] = 0.3533
        pgm_function7[(23, 4, 22)] = 0.348865265
        pgm_function7[(23, 4, 23)] = 0.174417115
        pgm_function7[(23, 4, 24)] = 0.036696341
        pgm_function7[(23, 5, 17)] = 0.01109891
        pgm_function7[(23, 5, 18)] = 0.129987074
        pgm_function7[(23, 5, 19)] = 0.335634054
        pgm_function7[(23, 5, 20)] = 0.363336283
        pgm_function7[(23, 5, 21)] = 0.1989
        pgm_function7[(23, 5, 22)] = 0.0467
        pgm_function7[(23, 5, 23)] = 0.001099891
        pgm_function7[(23, 6, 15)] = 0.0044
        pgm_function7[(23, 6, 16)] = 0.1078
        pgm_function7[(23, 6, 17)] = 0.31783206
        pgm_function7[(23, 6, 18)] = 0.37333722
        pgm_function7[(23, 6, 19)] = 0.21997818
        pgm_function7[(23, 6, 20)] = 0.0578
        pgm_function7[(23, 6, 21)] = 0.0022
        pgm_function7[(23, 7, 13)] = 0.0022
        pgm_function7[(23, 7, 14)] = 0.0889
        pgm_function7[(23, 7, 15)] = 0.2956
        pgm_function7[(23, 7, 16)] = 0.38333819
        pgm_function7[(23, 7, 17)] = 0.2378
        pgm_function7[(23, 7, 18)] = 0.071107127
        pgm_function7[(23, 7, 19)] = 0.004400443
        pgm_function7[(23, 8, 11)] = 0.0011
        pgm_function7[(23, 8, 12)] = 0.0678
        pgm_function7[(23, 8, 13)] = 0.272227242
        pgm_function7[(23, 8, 14)] = 0.3844383
        pgm_function7[(23, 8, 15)] = 0.263326124
        pgm_function7[(23, 8, 16)] = 0.0867
        pgm_function7[(23, 8, 17)] = 0.0078
        pgm_function7[(23, 9, 10)] = 0.0533
        pgm_function7[(23, 9, 11)] = 0.24222404
        pgm_function7[(23, 9, 12)] = 0.387838946
        pgm_function7[(23, 9, 13)] = 0.288871049
        pgm_function7[(23, 9, 14)] = 0.0978
        pgm_function7[(23, 9, 15)] = 0.0122
        pgm_function7[(23, 10, 8)] = 0.0378
        pgm_function7[(23, 10, 9)] = 0.2156
        pgm_function7[(23, 10, 10)] = 0.3878
        pgm_function7[(23, 10, 11)] = 0.3067
        pgm_function7[(23, 10, 12)] = 0.1178
        pgm_function7[(23, 10, 13)] = 0.0178
        pgm_function7[(23, 11, 6)] = 0.025602632
        pgm_function7[(23, 11, 7)] = 0.1933
        pgm_function7[(23, 11, 8)] = 0.3778
        pgm_function7[(23, 11, 9)] = 0.32333216
        pgm_function7[(23, 11, 10)] = 0.139986081
        pgm_function7[(23, 11, 11)] = 0.0222
        pgm_function7[(23, 12, 4)] = 0.0178
        pgm_function7[(23, 12, 5)] = 0.1689
        pgm_function7[(23, 12, 6)] = 0.3589
        pgm_function7[(23, 12, 7)] = 0.3444
        pgm_function7[(23, 12, 8)] = 0.1633
        pgm_function7[(23, 12, 9)] = 0.0289
        pgm_function7[(23, 13, 2)] = 0.01220121
        pgm_function7[(23, 13, 3)] = 0.1389
        pgm_function7[(23, 13, 4)] = 0.3467
        pgm_function7[(23, 13, 5)] = 0.360036097
        pgm_function7[(23, 13, 6)] = 0.1867
        pgm_function7[(23, 13, 7)] = 0.0378
        pgm_function7[(23, 14, 0)] = 0.0078
        pgm_function7[(23, 14, 1)] = 0.1167
        pgm_function7[(23, 14, 2)] = 0.3289
        pgm_function7[(23, 14, 3)] = 0.372237331
        pgm_function7[(23, 14, 4)] = 0.20777917
        pgm_function7[(23, 14, 5)] = 0.0489
        pgm_function7[(23, 14, 6)] = 0.0011
        pgm_function7[(23, 15, 0)] = 0.34223407
        pgm_function7[(23, 15, 1)] = 0.3833
        pgm_function7[(23, 15, 2)] = 0.23217716
        pgm_function7[(23, 15, 3)] = 0.0622
        pgm_function7[(23, 15, 4)] = 0.0022
        pgm_function7[(23, 16, 0)] = 0.22327807
        pgm_function7[(23, 16, 1)] = 0.07440741
        pgm_function7[(23, 16, 2)] = 0.0044
        pgm_function7[(24, 0, 28)] = 0.05669432
        pgm_function7[(24, 0, 29)] = 0.3056
        pgm_function7[(24, 0, 30)] = 0.40665945
        pgm_function7[(24, 0, 31)] = 0.2467
        pgm_function7[(24, 1, 26)] = 0.0389
        pgm_function7[(24, 1, 27)] = 0.215556922
        pgm_function7[(24, 1, 28)] = 0.377762113
        pgm_function7[(24, 1, 29)] = 0.3111
        pgm_function7[(24, 1, 30)] = 0.1222
        pgm_function7[(24, 1, 31)] = 0.0211
        pgm_function7[(24, 2, 24)] = 0.027797216
        pgm_function7[(24, 2, 25)] = 0.1867
        pgm_function7[(24, 2, 26)] = 0.3733
        pgm_function7[(24, 2, 27)] = 0.3244
        pgm_function7[(24, 2, 28)] = 0.1444
        pgm_function7[(24, 2, 29)] = 0.027797213
        pgm_function7[(24, 3, 22)] = 0.0189
        pgm_function7[(24, 3, 23)] = 0.16443307
        pgm_function7[(24, 3, 24)] = 0.3556
        pgm_function7[(24, 3, 25)] = 0.34
        pgm_function7[(24, 3, 26)] = 0.1689
        pgm_function7[(24, 3, 27)] = 0.034403409
        pgm_function7[(24, 4, 20)] = 0.01220121
        pgm_function7[(24, 4, 21)] = 0.1389
        pgm_function7[(24, 4, 22)] = 0.335566255
        pgm_function7[(24, 4, 23)] = 0.361136238
        pgm_function7[(24, 4, 24)] = 0.186681209
        pgm_function7[(24, 4, 25)] = 0.0456
        pgm_function7[(24, 4, 26)] = 0.0011
        pgm_function7[(24, 5, 18)] = 0.006699334
        pgm_function7[(24, 5, 19)] = 0.117812019
        pgm_function7[(24, 5, 20)] = 0.32003225
        pgm_function7[(24, 5, 21)] = 0.3678
        pgm_function7[(24, 5, 22)] = 0.2122
        pgm_function7[(24, 5, 23)] = 0.055594451
        pgm_function7[(24, 5, 24)] = 0.00220022
        pgm_function7[(24, 6, 16)] = 0.0044
        pgm_function7[(24, 6, 17)] = 0.09330932
        pgm_function7[(24, 6, 18)] = 0.301130178
        pgm_function7[(24, 6, 19)] = 0.3755623
        pgm_function7[(24, 6, 20)] = 0.2378
        pgm_function7[(24, 6, 21)] = 0.0667
        pgm_function7[(24, 6, 22)] = 0.0044
        pgm_function7[(24, 7, 14)] = 0.0011
        pgm_function7[(24, 7, 15)] = 0.0733
        pgm_function7[(24, 7, 16)] = 0.27672814
        pgm_function7[(24, 7, 17)] = 0.3878
        pgm_function7[(24, 7, 18)] = 0.255626097
        pgm_function7[(24, 7, 19)] = 0.082208254
        pgm_function7[(24, 7, 20)] = 0.0067
        pgm_function7[(24, 8, 13)] = 0.057805851
        pgm_function7[(24, 8, 14)] = 0.253325198
        pgm_function7[(24, 8, 15)] = 0.388939183
        pgm_function7[(24, 8, 16)] = 0.2756
        pgm_function7[(24, 8, 17)] = 0.0967
        pgm_function7[(24, 8, 18)] = 0.01
        pgm_function7[(24, 9, 11)] = 0.04220421
        pgm_function7[(24, 9, 12)] = 0.227822968
        pgm_function7[(24, 9, 13)] = 0.379962065
        pgm_function7[(24, 9, 14)] = 0.3033
        pgm_function7[(24, 9, 15)] = 0.1122
        pgm_function7[(24, 9, 16)] = 0.01559841
        pgm_function7[(24, 10, 9)] = 0.0311
        pgm_function7[(24, 10, 10)] = 0.1967
        pgm_function7[(24, 10, 11)] = 0.38
        pgm_function7[(24, 10, 12)] = 0.3222
        pgm_function7[(24, 10, 13)] = 0.1311
        pgm_function7[(24, 10, 14)] = 0.021097916
        pgm_function7[(24, 11, 7)] = 0.0211
        pgm_function7[(24, 11, 8)] = 0.1711
        pgm_function7[(24, 11, 9)] = 0.37113719
        pgm_function7[(24, 11, 10)] = 0.337766196
        pgm_function7[(24, 11, 11)] = 0.1556
        pgm_function7[(24, 11, 12)] = 0.0289
        pgm_function7[(24, 12, 5)] = 0.0122
        pgm_function7[(24, 12, 6)] = 0.1511
        pgm_function7[(24, 12, 7)] = 0.3511
        pgm_function7[(24, 12, 8)] = 0.3556
        pgm_function7[(24, 12, 9)] = 0.1789
        pgm_function7[(24, 12, 10)] = 0.035596429
        pgm_function7[(24, 13, 3)] = 0.0078
        pgm_function7[(24, 13, 4)] = 0.1267
        pgm_function7[(24, 13, 5)] = 0.330033089
        pgm_function7[(24, 13, 6)] = 0.3711
        pgm_function7[(24, 13, 7)] = 0.2011
        pgm_function7[(24, 13, 8)] = 0.04559542
        pgm_function7[(24, 13, 9)] = 0.0011
        pgm_function7[(24, 14, 1)] = 0.0044
        pgm_function7[(24, 14, 2)] = 0.1
        pgm_function7[(24, 14, 3)] = 0.31443128
        pgm_function7[(24, 14, 4)] = 0.3788623
        pgm_function7[(24, 14, 5)] = 0.2267
        pgm_function7[(24, 14, 6)] = 0.0578
        pgm_function7[(24, 14, 7)] = 0.002200222
        pgm_function7[(24, 15, 0)] = 0.09330932
        pgm_function7[(24, 15, 1)] = 0.29
        pgm_function7[(24, 15, 2)] = 0.38556127
        pgm_function7[(24, 15, 3)] = 0.25
        pgm_function7[(24, 15, 4)] = 0.0722
        pgm_function7[(24, 15, 5)] = 0.004400441
        pgm_function7[(24, 16, 0)] = 0.40555912
        pgm_function7[(24, 16, 1)] = 0.27112705
        pgm_function7[(24, 16, 2)] = 0.0889
        pgm_function7[(24, 16, 3)] = 0.0067
        pgm_function7[(24, 17, 0)] = 0.08220825
        pgm_function7[(24, 17, 1)] = 0.0111
        pgm_function7[(25, 0, 29)] = 0.0511
        pgm_function7[(25, 0, 30)] = 0.28557131
        pgm_function7[(25, 0, 31)] = 0.4111
        pgm_function7[(25, 1, 27)] = 0.029993989
        pgm_function7[(25, 1, 28)] = 0.196680059
        pgm_function7[(25, 1, 29)] = 0.3689
        pgm_function7[(25, 1, 30)] = 0.3244
        pgm_function7[(25, 1, 31)] = 0.1367
        pgm_function7[(25, 2, 25)] = 0.0222
        pgm_function7[(25, 2, 26)] = 0.1711
        pgm_function7[(25, 2, 27)] = 0.3611
        pgm_function7[(25, 2, 28)] = 0.3378
        pgm_function7[(25, 2, 29)] = 0.157784074
        pgm_function7[(25, 2, 30)] = 0.033303309
        pgm_function7[(25, 3, 23)] = 0.01440291
        pgm_function7[(25, 3, 24)] = 0.1444
        pgm_function7[(25, 3, 25)] = 0.3511
        pgm_function7[(25, 3, 26)] = 0.3467
        pgm_function7[(25, 3, 27)] = 0.182218049
        pgm_function7[(25, 3, 28)] = 0.0422
        pgm_function7[(25, 3, 29)] = 0.001100111
        pgm_function7[(25, 4, 21)] = 0.0078
        pgm_function7[(25, 4, 22)] = 0.126687096
        pgm_function7[(25, 4, 23)] = 0.323332213
        pgm_function7[(25, 4, 24)] = 0.365563409
        pgm_function7[(25, 4, 25)] = 0.2033
        pgm_function7[(25, 4, 26)] = 0.0522
        pgm_function7[(25, 4, 27)] = 0.0022
        pgm_function7[(25, 5, 19)] = 0.004400441
        pgm_function7[(25, 5, 20)] = 0.103310081
        pgm_function7[(25, 5, 21)] = 0.3033
        pgm_function7[(25, 5, 22)] = 0.3778
        pgm_function7[(25, 5, 23)] = 0.225577205
        pgm_function7[(25, 5, 24)] = 0.06440641
        pgm_function7[(25, 5, 25)] = 0.004400439
        pgm_function7[(25, 6, 17)] = 0.00220022
        pgm_function7[(25, 6, 18)] = 0.081108148
        pgm_function7[(25, 6, 19)] = 0.28667123
        pgm_function7[(25, 6, 20)] = 0.3778
        pgm_function7[(25, 6, 21)] = 0.2511
        pgm_function7[(25, 6, 22)] = 0.0778
        pgm_function7[(25, 6, 23)] = 0.006700679
        pgm_function7[(25, 7, 15)] = 0.0011
        pgm_function7[(25, 7, 16)] = 0.06330633
        pgm_function7[(25, 7, 17)] = 0.26
        pgm_function7[(25, 7, 18)] = 0.383338146
        pgm_function7[(25, 7, 19)] = 0.274427181
        pgm_function7[(25, 7, 20)] = 0.0922
        pgm_function7[(25, 7, 21)] = 0.01
        pgm_function7[(25, 8, 14)] = 0.046704736
        pgm_function7[(25, 8, 15)] = 0.232223109
        pgm_function7[(25, 8, 16)] = 0.3889
        pgm_function7[(25, 8, 17)] = 0.2933
        pgm_function7[(25, 8, 18)] = 0.1111
        pgm_function7[(25, 8, 19)] = 0.0133
        pgm_function7[(25, 9, 12)] = 0.033303295
        pgm_function7[(25, 9, 13)] = 0.209979036
        pgm_function7[(25, 9, 14)] = 0.38
        pgm_function7[(25, 9, 15)] = 0.3156
        pgm_function7[(25, 9, 16)] = 0.1277871
        pgm_function7[(25, 9, 17)] = 0.0189
        pgm_function7[(25, 10, 10)] = 0.0244
        pgm_function7[(25, 10, 11)] = 0.1811
        pgm_function7[(25, 10, 12)] = 0.3678
        pgm_function7[(25, 10, 13)] = 0.3367
        pgm_function7[(25, 10, 14)] = 0.146685113
        pgm_function7[(25, 10, 15)] = 0.026702723
        pgm_function7[(25, 11, 8)] = 0.0167
        pgm_function7[(25, 11, 9)] = 0.15441508
        pgm_function7[(25, 11, 10)] = 0.356664207
        pgm_function7[(25, 11, 11)] = 0.3489
        pgm_function7[(25, 11, 12)] = 0.1711
        pgm_function7[(25, 11, 13)] = 0.0356
        pgm_function7[(25, 12, 6)] = 0.01
        pgm_function7[(25, 12, 7)] = 0.1322
        pgm_function7[(25, 12, 8)] = 0.3378
        pgm_function7[(25, 12, 9)] = 0.3622
        pgm_function7[(25, 12, 10)] = 0.19778016
        pgm_function7[(25, 12, 11)] = 0.0444044
        pgm_function7[(25, 12, 12)] = 0.001100111
        pgm_function7[(25, 13, 4)] = 0.0044
        pgm_function7[(25, 13, 5)] = 0.11221103
        pgm_function7[(25, 13, 6)] = 0.3144
        pgm_function7[(25, 13, 7)] = 0.3789
        pgm_function7[(25, 13, 8)] = 0.21887811
        pgm_function7[(25, 13, 9)] = 0.0544
        pgm_function7[(25, 13, 10)] = 0.0022
        pgm_function7[(25, 14, 2)] = 0.0022
        pgm_function7[(25, 14, 3)] = 0.087808878
        pgm_function7[(25, 14, 4)] = 0.29557024
        pgm_function7[(25, 14, 5)] = 0.3844
        pgm_function7[(25, 14, 6)] = 0.2389
        pgm_function7[(25, 14, 7)] = 0.067806853
        pgm_function7[(25, 14, 8)] = 0.0044
        pgm_function7[(25, 15, 0)] = 0.00110011
        pgm_function7[(25, 15, 1)] = 0.0678
        pgm_function7[(25, 15, 2)] = 0.27557219
        pgm_function7[(25, 15, 3)] = 0.3833
        pgm_function7[(25, 15, 4)] = 0.2644
        pgm_function7[(25, 15, 5)] = 0.083308313
        pgm_function7[(25, 15, 6)] = 0.006700674
        pgm_function7[(25, 16, 0)] = 0.26887308
        pgm_function7[(25, 16, 1)] = 0.39003907
        pgm_function7[(25, 16, 2)] = 0.2867
        pgm_function7[(25, 16, 3)] = 0.1
        pgm_function7[(25, 16, 4)] = 0.01
        pgm_function7[(25, 17, 0)] = 0.29893018
        pgm_function7[(25, 17, 1)] = 0.1178
        pgm_function7[(25, 17, 2)] = 0.0144
        pgm_function7[(25, 18, 0)] = 0.013301303
        pgm_function7[(26, 0, 30)] = 0.03779624
        pgm_function7[(26, 0, 31)] = 0.2611
        pgm_function7[(26, 1, 28)] = 0.025597408
        pgm_function7[(26, 1, 29)] = 0.1767
        pgm_function7[(26, 1, 30)] = 0.3622
        pgm_function7[(26, 1, 31)] = 0.3333
        pgm_function7[(26, 2, 26)] = 0.0156
        pgm_function7[(26, 2, 27)] = 0.1556
        pgm_function7[(26, 2, 28)] = 0.3478
        pgm_function7[(26, 2, 29)] = 0.349965164
        pgm_function7[(26, 2, 30)] = 0.173317045
        pgm_function7[(26, 2, 31)] = 0.041104124
        pgm_function7[(26, 3, 24)] = 0.0111
        pgm_function7[(26, 3, 25)] = 0.1289
        pgm_function7[(26, 3, 26)] = 0.3344
        pgm_function7[(26, 3, 27)] = 0.361136098
        pgm_function7[(26, 3, 28)] = 0.1978
        pgm_function7[(26, 3, 29)] = 0.050005024
        pgm_function7[(26, 3, 30)] = 0.0011
        pgm_function7[(26, 4, 22)] = 0.005599444
        pgm_function7[(26, 4, 23)] = 0.107811071
        pgm_function7[(26, 4, 24)] = 0.316668355
        pgm_function7[(26, 4, 25)] = 0.37
        pgm_function7[(26, 4, 26)] = 0.22
        pgm_function7[(26, 4, 27)] = 0.0589
        pgm_function7[(26, 4, 28)] = 0.0044
        pgm_function7[(26, 5, 20)] = 0.002200222
        pgm_function7[(26, 5, 21)] = 0.0911
        pgm_function7[(26, 5, 22)] = 0.2878
        pgm_function7[(26, 5, 23)] = 0.379962346
        pgm_function7[(26, 5, 24)] = 0.24112404
        pgm_function7[(26, 5, 25)] = 0.074407382
        pgm_function7[(26, 5, 26)] = 0.006699334
        pgm_function7[(26, 6, 18)] = 0.001100111
        pgm_function7[(26, 6, 19)] = 0.06999306
        pgm_function7[(26, 6, 20)] = 0.2644
        pgm_function7[(26, 6, 21)] = 0.3844
        pgm_function7[(26, 6, 22)] = 0.2656
        pgm_function7[(26, 6, 23)] = 0.09000912
        pgm_function7[(26, 6, 24)] = 0.01000101
        pgm_function7[(26, 7, 17)] = 0.0511
        pgm_function7[(26, 7, 18)] = 0.244424093
        pgm_function7[(26, 7, 19)] = 0.37893825
        pgm_function7[(26, 7, 20)] = 0.2922
        pgm_function7[(26, 7, 21)] = 0.1056
        pgm_function7[(26, 7, 22)] = 0.0133
        pgm_function7[(26, 8, 15)] = 0.038903918
        pgm_function7[(26, 8, 16)] = 0.2144
        pgm_function7[(26, 8, 17)] = 0.3778
        pgm_function7[(26, 8, 18)] = 0.3111
        pgm_function7[(26, 8, 19)] = 0.1233
        pgm_function7[(26, 8, 20)] = 0.01780182
        pgm_function7[(26, 9, 13)] = 0.026697305
        pgm_function7[(26, 9, 14)] = 0.1867
        pgm_function7[(26, 9, 15)] = 0.3744
        pgm_function7[(26, 9, 16)] = 0.32666726
        pgm_function7[(26, 9, 17)] = 0.1444
        pgm_function7[(26, 9, 18)] = 0.0244
        pgm_function7[(26, 10, 11)] = 0.0178
        pgm_function7[(26, 10, 12)] = 0.1656
        pgm_function7[(26, 10, 13)] = 0.3589
        pgm_function7[(26, 10, 14)] = 0.345565266
        pgm_function7[(26, 10, 15)] = 0.164416141
        pgm_function7[(26, 10, 16)] = 0.032203219
        pgm_function7[(26, 11, 9)] = 0.01220121
        pgm_function7[(26, 11, 10)] = 0.139986081
        pgm_function7[(26, 11, 11)] = 0.3422
        pgm_function7[(26, 11, 12)] = 0.36
        pgm_function7[(26, 11, 13)] = 0.1833
        pgm_function7[(26, 11, 14)] = 0.044404426
        pgm_function7[(26, 12, 7)] = 0.0067
        pgm_function7[(26, 12, 8)] = 0.1167
        pgm_function7[(26, 12, 9)] = 0.3256
        pgm_function7[(26, 12, 10)] = 0.365563296
        pgm_function7[(26, 12, 11)] = 0.21222102
        pgm_function7[(26, 12, 12)] = 0.052205226
        pgm_function7[(26, 12, 13)] = 0.0022
        pgm_function7[(26, 13, 5)] = 0.003300331
        pgm_function7[(26, 13, 6)] = 0.0956
        pgm_function7[(26, 13, 7)] = 0.3
        pgm_function7[(26, 13, 8)] = 0.37886219
        pgm_function7[(26, 13, 9)] = 0.2356
        pgm_function7[(26, 13, 10)] = 0.0644
        pgm_function7[(26, 13, 11)] = 0.0044
        pgm_function7[(26, 14, 3)] = 0.001100111
        pgm_function7[(26, 14, 4)] = 0.07669236
        pgm_function7[(26, 14, 5)] = 0.2756
        pgm_function7[(26, 14, 6)] = 0.3922
        pgm_function7[(26, 14, 7)] = 0.254425198
        pgm_function7[(26, 14, 8)] = 0.0778
        pgm_function7[(26, 14, 9)] = 0.006699332
        pgm_function7[(26, 15, 2)] = 0.05559444
        pgm_function7[(26, 15, 3)] = 0.2567
        pgm_function7[(26, 15, 4)] = 0.3867
        pgm_function7[(26, 15, 5)] = 0.276728044
        pgm_function7[(26, 15, 6)] = 0.09440945
        pgm_function7[(26, 15, 7)] = 0.01
        pgm_function7[(26, 16, 0)] = 0.05669432
        pgm_function7[(26, 16, 1)] = 0.23002304
        pgm_function7[(26, 16, 2)] = 0.3822
        pgm_function7[(26, 16, 3)] = 0.3033
        pgm_function7[(26, 16, 4)] = 0.1133
        pgm_function7[(26, 16, 5)] = 0.0133
        pgm_function7[(26, 17, 0)] = 0.38223823
        pgm_function7[(26, 17, 1)] = 0.3222
        pgm_function7[(26, 17, 2)] = 0.1322
        pgm_function7[(26, 17, 3)] = 0.017798208
        pgm_function7[(26, 18, 0)] = 0.131113034
        pgm_function7[(26, 18, 1)] = 0.0256
        pgm_function7[(27, 0, 31)] = 0.0289
        pgm_function7[(27, 1, 29)] = 0.0211
        pgm_function7[(27, 1, 30)] = 0.1589
        pgm_function7[(27, 1, 31)] = 0.3567
        pgm_function7[(27, 2, 27)] = 0.0122
        pgm_function7[(27, 2, 28)] = 0.1378
        pgm_function7[(27, 2, 29)] = 0.336666158
        pgm_function7[(27, 2, 30)] = 0.357836093
        pgm_function7[(27, 2, 31)] = 0.19001911
        pgm_function7[(27, 3, 25)] = 0.0067
        pgm_function7[(27, 3, 26)] = 0.1167
        pgm_function7[(27, 3, 27)] = 0.316732086
        pgm_function7[(27, 3, 28)] = 0.3689
        pgm_function7[(27, 3, 29)] = 0.211121101
        pgm_function7[(27, 3, 30)] = 0.06
        pgm_function7[(27, 3, 31)] = 0.0033
        pgm_function7[(27, 4, 23)] = 0.004400443
        pgm_function7[(27, 4, 24)] = 0.092190903
        pgm_function7[(27, 4, 25)] = 0.2989
        pgm_function7[(27, 4, 26)] = 0.3756
        pgm_function7[(27, 4, 27)] = 0.24
        pgm_function7[(27, 4, 28)] = 0.0689
        pgm_function7[(27, 4, 29)] = 0.006699333
        pgm_function7[(27, 5, 21)] = 0.0011
        pgm_function7[(27, 5, 22)] = 0.0744
        pgm_function7[(27, 5, 23)] = 0.275572251
        pgm_function7[(27, 5, 24)] = 0.38223807
        pgm_function7[(27, 5, 25)] = 0.257825938
        pgm_function7[(27, 5, 26)] = 0.082191855
        pgm_function7[(27, 5, 27)] = 0.01
        pgm_function7[(27, 6, 20)] = 0.0611
        pgm_function7[(27, 6, 21)] = 0.2478
        pgm_function7[(27, 6, 22)] = 0.3833
        pgm_function7[(27, 6, 23)] = 0.274427365
        pgm_function7[(27, 6, 24)] = 0.10221006
        pgm_function7[(27, 6, 25)] = 0.0133
        pgm_function7[(27, 7, 18)] = 0.043304316
        pgm_function7[(27, 7, 19)] = 0.223322147
        pgm_function7[(27, 7, 20)] = 0.3744
        pgm_function7[(27, 7, 21)] = 0.3033
        pgm_function7[(27, 7, 22)] = 0.1189
        pgm_function7[(27, 7, 23)] = 0.0178
        pgm_function7[(27, 8, 16)] = 0.03
        pgm_function7[(27, 8, 17)] = 0.2
        pgm_function7[(27, 8, 18)] = 0.3678
        pgm_function7[(27, 8, 19)] = 0.3256
        pgm_function7[(27, 8, 20)] = 0.13891415
        pgm_function7[(27, 8, 21)] = 0.0222
        pgm_function7[(27, 9, 14)] = 0.0222
        pgm_function7[(27, 9, 15)] = 0.17
        pgm_function7[(27, 9, 16)] = 0.36216429
        pgm_function7[(27, 9, 17)] = 0.34
        pgm_function7[(27, 9, 18)] = 0.1589
        pgm_function7[(27, 9, 19)] = 0.030003017
        pgm_function7[(27, 10, 12)] = 0.0133
        pgm_function7[(27, 10, 13)] = 0.1444
        pgm_function7[(27, 10, 14)] = 0.35106527
        pgm_function7[(27, 10, 15)] = 0.352235303
        pgm_function7[(27, 10, 16)] = 0.181118105
        pgm_function7[(27, 10, 17)] = 0.04
        pgm_function7[(27, 11, 10)] = 0.007799225
        pgm_function7[(27, 11, 11)] = 0.1267
        pgm_function7[(27, 11, 12)] = 0.3278
        pgm_function7[(27, 11, 13)] = 0.37
        pgm_function7[(27, 11, 14)] = 0.200020118
        pgm_function7[(27, 11, 15)] = 0.05000505
        pgm_function7[(27, 11, 16)] = 0.0011
        pgm_function7[(27, 12, 8)] = 0.0044
        pgm_function7[(27, 12, 9)] = 0.1022
        pgm_function7[(27, 12, 10)] = 0.30886925
        pgm_function7[(27, 12, 11)] = 0.37673803
        pgm_function7[(27, 12, 12)] = 0.22442211
        pgm_function7[(27, 12, 13)] = 0.0622
        pgm_function7[(27, 12, 14)] = 0.003300331
        pgm_function7[(27, 13, 6)] = 0.0022
        pgm_function7[(27, 13, 7)] = 0.0811
        pgm_function7[(27, 13, 8)] = 0.28777114
        pgm_function7[(27, 13, 9)] = 0.3811
        pgm_function7[(27, 13, 10)] = 0.2511
        pgm_function7[(27, 13, 11)] = 0.0733
        pgm_function7[(27, 13, 12)] = 0.006699332
        pgm_function7[(27, 14, 5)] = 0.0644
        pgm_function7[(27, 14, 6)] = 0.2567
        pgm_function7[(27, 14, 7)] = 0.390039304
        pgm_function7[(27, 14, 8)] = 0.2744
        pgm_function7[(27, 14, 9)] = 0.087791224
        pgm_function7[(27, 14, 10)] = 0.01
        pgm_function7[(27, 15, 3)] = 0.0467
        pgm_function7[(27, 15, 4)] = 0.2367
        pgm_function7[(27, 15, 5)] = 0.390039062
        pgm_function7[(27, 15, 6)] = 0.293329155
        pgm_function7[(27, 15, 7)] = 0.1067
        pgm_function7[(27, 15, 8)] = 0.0133013
        pgm_function7[(27, 16, 1)] = 0.03220321
        pgm_function7[(27, 16, 2)] = 0.2122
        pgm_function7[(27, 16, 3)] = 0.3778
        pgm_function7[(27, 16, 4)] = 0.3156
        pgm_function7[(27, 16, 5)] = 0.1267
        pgm_function7[(27, 16, 6)] = 0.01779821
        pgm_function7[(27, 17, 0)] = 0.21442113
        pgm_function7[(27, 17, 1)] = 0.3689
        pgm_function7[(27, 17, 2)] = 0.3378
        pgm_function7[(27, 17, 3)] = 0.14888507
        pgm_function7[(27, 17, 4)] = 0.0244
        pgm_function7[(27, 18, 0)] = 0.333333087
        pgm_function7[(27, 18, 1)] = 0.1711
        pgm_function7[(27, 18, 2)] = 0.03220321
        pgm_function7[(27, 19, 0)] = 0.0278
        pgm_function7[(28, 1, 30)] = 0.0156
        pgm_function7[(28, 1, 31)] = 0.1411
        pgm_function7[(28, 2, 28)] = 0.01
        pgm_function7[(28, 2, 29)] = 0.121088057
        pgm_function7[(28, 2, 30)] = 0.326733085
        pgm_function7[(28, 2, 31)] = 0.361136209
        pgm_function7[(28, 3, 26)] = 0.0044
        pgm_function7[(28, 3, 27)] = 0.102210028
        pgm_function7[(28, 3, 28)] = 0.3011
        pgm_function7[(28, 3, 29)] = 0.37443718
        pgm_function7[(28, 3, 30)] = 0.2278
        pgm_function7[(28, 3, 31)] = 0.0689
        pgm_function7[(28, 4, 24)] = 0.002199782
        pgm_function7[(28, 4, 25)] = 0.0811
        pgm_function7[(28, 4, 26)] = 0.28
        pgm_function7[(28, 4, 27)] = 0.3789
        pgm_function7[(28, 4, 28)] = 0.25
        pgm_function7[(28, 4, 29)] = 0.078892137
        pgm_function7[(28, 4, 30)] = 0.008900899
        pgm_function7[(28, 5, 22)] = 0.0011
        pgm_function7[(28, 5, 23)] = 0.062193857
        pgm_function7[(28, 5, 24)] = 0.25782605
        pgm_function7[(28, 5, 25)] = 0.380037909
        pgm_function7[(28, 5, 26)] = 0.276672185
        pgm_function7[(28, 5, 27)] = 0.0922
        pgm_function7[(28, 5, 28)] = 0.01330131
        pgm_function7[(28, 6, 21)] = 0.0478
        pgm_function7[(28, 6, 22)] = 0.23
        pgm_function7[(28, 6, 23)] = 0.384438511
        pgm_function7[(28, 6, 24)] = 0.29112917
        pgm_function7[(28, 6, 25)] = 0.1111
        pgm_function7[(28, 6, 26)] = 0.0178
        pgm_function7[(28, 7, 19)] = 0.036703724
        pgm_function7[(28, 7, 20)] = 0.2056
        pgm_function7[(28, 7, 21)] = 0.3722
        pgm_function7[(28, 7, 22)] = 0.3111
        pgm_function7[(28, 7, 23)] = 0.1344
        pgm_function7[(28, 7, 24)] = 0.022197827
        pgm_function7[(28, 8, 17)] = 0.0244
        pgm_function7[(28, 8, 18)] = 0.18
        pgm_function7[(28, 8, 19)] = 0.36
        pgm_function7[(28, 8, 20)] = 0.33443337
        pgm_function7[(28, 8, 21)] = 0.1544
        pgm_function7[(28, 8, 22)] = 0.0289
        pgm_function7[(28, 9, 15)] = 0.0156
        pgm_function7[(28, 9, 16)] = 0.15558412
        pgm_function7[(28, 9, 17)] = 0.35
        pgm_function7[(28, 9, 18)] = 0.35
        pgm_function7[(28, 9, 19)] = 0.174417098
        pgm_function7[(28, 9, 20)] = 0.037803829
        pgm_function7[(28, 10, 13)] = 0.0111
        pgm_function7[(28, 10, 14)] = 0.128887099
        pgm_function7[(28, 10, 15)] = 0.337834291
        pgm_function7[(28, 10, 16)] = 0.361136209
        pgm_function7[(28, 10, 17)] = 0.1967
        pgm_function7[(28, 10, 18)] = 0.0478
        pgm_function7[(28, 10, 19)] = 0.0011
        pgm_function7[(28, 11, 11)] = 0.0044
        pgm_function7[(28, 11, 12)] = 0.1078
        pgm_function7[(28, 11, 13)] = 0.3156
        pgm_function7[(28, 11, 14)] = 0.374437221
        pgm_function7[(28, 11, 15)] = 0.22112222
        pgm_function7[(28, 11, 16)] = 0.0589
        pgm_function7[(28, 11, 17)] = 0.002200222
        pgm_function7[(28, 12, 9)] = 0.0022
        pgm_function7[(28, 12, 10)] = 0.091090974
        pgm_function7[(28, 12, 11)] = 0.29112903
        pgm_function7[(28, 12, 12)] = 0.384438188
        pgm_function7[(28, 12, 13)] = 0.24
        pgm_function7[(28, 12, 14)] = 0.072207219
        pgm_function7[(28, 12, 15)] = 0.0044
        pgm_function7[(28, 13, 7)] = 0.0011
        pgm_function7[(28, 13, 8)] = 0.06889313
        pgm_function7[(28, 13, 9)] = 0.2678
        pgm_function7[(28, 13, 10)] = 0.3856
        pgm_function7[(28, 13, 11)] = 0.2656
        pgm_function7[(28, 13, 12)] = 0.085591423
        pgm_function7[(28, 13, 13)] = 0.01
        pgm_function7[(28, 14, 6)] = 0.0533
        pgm_function7[(28, 14, 7)] = 0.24332419
        pgm_function7[(28, 14, 8)] = 0.3822
        pgm_function7[(28, 14, 9)] = 0.291071079
        pgm_function7[(28, 14, 10)] = 0.1011
        pgm_function7[(28, 14, 11)] = 0.0133
        pgm_function7[(28, 15, 4)] = 0.0378
        pgm_function7[(28, 15, 5)] = 0.214421034
        pgm_function7[(28, 15, 6)] = 0.382238203
        pgm_function7[(28, 15, 7)] = 0.31
        pgm_function7[(28, 15, 8)] = 0.121112
        pgm_function7[(28, 15, 9)] = 0.0178
        pgm_function7[(28, 16, 2)] = 0.0256
        pgm_function7[(28, 16, 3)] = 0.1911
        pgm_function7[(28, 16, 4)] = 0.3733
        pgm_function7[(28, 16, 5)] = 0.3278
        pgm_function7[(28, 16, 6)] = 0.144386084
        pgm_function7[(28, 16, 7)] = 0.022197817
        pgm_function7[(28, 17, 0)] = 0.02220221
        pgm_function7[(28, 17, 1)] = 0.1678
        pgm_function7[(28, 17, 2)] = 0.3567
        pgm_function7[(28, 17, 3)] = 0.346665163
        pgm_function7[(28, 17, 4)] = 0.1644
        pgm_function7[(28, 17, 5)] = 0.028902925
        pgm_function7[(28, 18, 0)] = 0.365637095
        pgm_function7[(28, 18, 1)] = 0.36
        pgm_function7[(28, 18, 2)] = 0.18561903
        pgm_function7[(28, 18, 3)] = 0.0411
        pgm_function7[(28, 19, 0)] = 0.1844
        pgm_function7[(28, 19, 1)] = 0.0511
        pgm_function7[(28, 19, 2)] = 0.0011
        pgm_function7[(29, 1, 31)] = 0.0111
        pgm_function7[(29, 2, 29)] = 0.006699333
        pgm_function7[(29, 2, 30)] = 0.104410027
        pgm_function7[(29, 2, 31)] = 0.314431182
        pgm_function7[(29, 3, 27)] = 0.003300331
        pgm_function7[(29, 3, 28)] = 0.0878
        pgm_function7[(29, 3, 29)] = 0.288929139
        pgm_function7[(29, 3, 30)] = 0.3744
        pgm_function7[(29, 3, 31)] = 0.2422
        pgm_function7[(29, 4, 25)] = 0.0011
        pgm_function7[(29, 4, 26)] = 0.0711
        pgm_function7[(29, 4, 27)] = 0.2589
        pgm_function7[(29, 4, 28)] = 0.3856
        pgm_function7[(29, 4, 29)] = 0.265573125
        pgm_function7[(29, 4, 30)] = 0.091109192
        pgm_function7[(29, 4, 31)] = 0.01109892
        pgm_function7[(29, 5, 24)] = 0.05220521
        pgm_function7[(29, 5, 25)] = 0.238923943
        pgm_function7[(29, 5, 26)] = 0.381062255
        pgm_function7[(29, 5, 27)] = 0.2889
        pgm_function7[(29, 5, 28)] = 0.10441005
        pgm_function7[(29, 5, 29)] = 0.0167
        pgm_function7[(29, 6, 22)] = 0.0389
        pgm_function7[(29, 6, 23)] = 0.214421285
        pgm_function7[(29, 6, 24)] = 0.37443722
        pgm_function7[(29, 6, 25)] = 0.3111
        pgm_function7[(29, 6, 26)] = 0.1233
        pgm_function7[(29, 6, 27)] = 0.02220222
        pgm_function7[(29, 7, 20)] = 0.0289
        pgm_function7[(29, 7, 21)] = 0.1867
        pgm_function7[(29, 7, 22)] = 0.3711
        pgm_function7[(29, 7, 23)] = 0.3233
        pgm_function7[(29, 7, 24)] = 0.147785177
        pgm_function7[(29, 7, 25)] = 0.027797213
        pgm_function7[(29, 8, 18)] = 0.02
        pgm_function7[(29, 8, 19)] = 0.1622
        pgm_function7[(29, 8, 20)] = 0.35443539
        pgm_function7[(29, 8, 21)] = 0.3422
        pgm_function7[(29, 8, 22)] = 0.17
        pgm_function7[(29, 8, 23)] = 0.035596433
        pgm_function7[(29, 9, 16)] = 0.01219881
        pgm_function7[(29, 9, 17)] = 0.1378
        pgm_function7[(29, 9, 18)] = 0.3367
        pgm_function7[(29, 9, 19)] = 0.361136202
        pgm_function7[(29, 9, 20)] = 0.190019148
        pgm_function7[(29, 9, 21)] = 0.0467
        pgm_function7[(29, 9, 22)] = 0.00110011
        pgm_function7[(29, 10, 14)] = 0.006699335
        pgm_function7[(29, 10, 15)] = 0.114411098
        pgm_function7[(29, 10, 16)] = 0.321132186
        pgm_function7[(29, 10, 17)] = 0.37
        pgm_function7[(29, 10, 18)] = 0.2122
        pgm_function7[(29, 10, 19)] = 0.0578
        pgm_function7[(29, 10, 20)] = 0.0022
        pgm_function7[(29, 11, 12)] = 0.0044
        pgm_function7[(29, 11, 13)] = 0.0933
        pgm_function7[(29, 11, 14)] = 0.301130178
        pgm_function7[(29, 11, 15)] = 0.37443737
        pgm_function7[(29, 11, 16)] = 0.2378
        pgm_function7[(29, 11, 17)] = 0.068906968
        pgm_function7[(29, 11, 18)] = 0.004400443
        pgm_function7[(29, 12, 10)] = 0.001099891
        pgm_function7[(29, 12, 11)] = 0.07440741
        pgm_function7[(29, 12, 12)] = 0.275628135
        pgm_function7[(29, 12, 13)] = 0.3867
        pgm_function7[(29, 12, 14)] = 0.255626069
        pgm_function7[(29, 12, 15)] = 0.0833
        pgm_function7[(29, 12, 16)] = 0.0078
        pgm_function7[(29, 13, 9)] = 0.06
        pgm_function7[(29, 13, 10)] = 0.2489
        pgm_function7[(29, 13, 11)] = 0.3878
        pgm_function7[(29, 13, 12)] = 0.276672075
        pgm_function7[(29, 13, 13)] = 0.0967
        pgm_function7[(29, 13, 14)] = 0.0122
        pgm_function7[(29, 14, 7)] = 0.042204233
        pgm_function7[(29, 14, 8)] = 0.2256
        pgm_function7[(29, 14, 9)] = 0.379962103
        pgm_function7[(29, 14, 10)] = 0.3033
        pgm_function7[(29, 14, 11)] = 0.1133
        pgm_function7[(29, 14, 12)] = 0.0178
        pgm_function7[(29, 15, 5)] = 0.031103105
        pgm_function7[(29, 15, 6)] = 0.198920105
        pgm_function7[(29, 15, 7)] = 0.3744
        pgm_function7[(29, 15, 8)] = 0.3200321
        pgm_function7[(29, 15, 9)] = 0.1344
        pgm_function7[(29, 15, 10)] = 0.0222
        pgm_function7[(29, 16, 3)] = 0.0211
        pgm_function7[(29, 16, 4)] = 0.1722
        pgm_function7[(29, 16, 5)] = 0.3656
        pgm_function7[(29, 16, 6)] = 0.335566195
        pgm_function7[(29, 16, 7)] = 0.158884121
        pgm_function7[(29, 16, 8)] = 0.0289
        pgm_function7[(29, 17, 1)] = 0.0122
        pgm_function7[(29, 17, 2)] = 0.1489
        pgm_function7[(29, 17, 3)] = 0.347765163
        pgm_function7[(29, 17, 4)] = 0.3556
        pgm_function7[(29, 17, 5)] = 0.18221816
        pgm_function7[(29, 17, 6)] = 0.0367
        pgm_function7[(29, 18, 0)] = 0.15221504
        pgm_function7[(29, 18, 1)] = 0.33
        pgm_function7[(29, 18, 2)] = 0.37223707
        pgm_function7[(29, 18, 3)] = 0.2
        pgm_function7[(29, 18, 4)] = 0.04669533
        pgm_function7[(29, 18, 5)] = 0.001099891
        pgm_function7[(29, 19, 0)] = 0.3733
        pgm_function7[(29, 19, 1)] = 0.2256
        pgm_function7[(29, 19, 2)] = 0.0611
        pgm_function7[(29, 19, 3)] = 0.0022
        pgm_function7[(30, 2, 30)] = 0.004400441
        pgm_function7[(30, 2, 31)] = 0.091109153
        pgm_function7[(30, 3, 28)] = 0.0022
        pgm_function7[(30, 3, 29)] = 0.073307335
        pgm_function7[(30, 3, 30)] = 0.2756
        pgm_function7[(30, 3, 31)] = 0.3756
        pgm_function7[(30, 4, 27)] = 0.0611
        pgm_function7[(30, 4, 28)] = 0.2422
        pgm_function7[(30, 4, 29)] = 0.379962179
        pgm_function7[(30, 4, 30)] = 0.281128284
        pgm_function7[(30, 4, 31)] = 0.10558916
        pgm_function7[(30, 5, 25)] = 0.044404389
        pgm_function7[(30, 5, 26)] = 0.215578144
        pgm_function7[(30, 5, 27)] = 0.3811
        pgm_function7[(30, 5, 28)] = 0.30223015
        pgm_function7[(30, 5, 29)] = 0.12
        pgm_function7[(30, 5, 30)] = 0.02110211
        pgm_function7[(30, 6, 23)] = 0.03000304
        pgm_function7[(30, 6, 24)] = 0.19782012
        pgm_function7[(30, 6, 25)] = 0.3678
        pgm_function7[(30, 6, 26)] = 0.3222
        pgm_function7[(30, 6, 27)] = 0.1389141
        pgm_function7[(30, 6, 28)] = 0.027797213
        pgm_function7[(30, 7, 21)] = 0.0222
        pgm_function7[(30, 7, 22)] = 0.17
        pgm_function7[(30, 7, 23)] = 0.3567
        pgm_function7[(30, 7, 24)] = 0.336666404
        pgm_function7[(30, 7, 25)] = 0.163284077
        pgm_function7[(30, 7, 26)] = 0.0344
        pgm_function7[(30, 8, 19)] = 0.0156
        pgm_function7[(30, 8, 20)] = 0.14331416
        pgm_function7[(30, 8, 21)] = 0.3456
        pgm_function7[(30, 8, 22)] = 0.35
        pgm_function7[(30, 8, 23)] = 0.185581173
        pgm_function7[(30, 8, 24)] = 0.0433
        pgm_function7[(30, 8, 25)] = 0.00110011
        pgm_function7[(30, 9, 17)] = 0.0089
        pgm_function7[(30, 9, 18)] = 0.1233
        pgm_function7[(30, 9, 19)] = 0.323332181
        pgm_function7[(30, 9, 20)] = 0.364436284
        pgm_function7[(30, 9, 21)] = 0.2044
        pgm_function7[(30, 9, 22)] = 0.05440542
        pgm_function7[(30, 9, 23)] = 0.0022
        pgm_function7[(30, 10, 15)] = 0.004400444
        pgm_function7[(30, 10, 16)] = 0.102210059
        pgm_function7[(30, 10, 17)] = 0.3022
        pgm_function7[(30, 10, 18)] = 0.3767
        pgm_function7[(30, 10, 19)] = 0.2256
        pgm_function7[(30, 10, 20)] = 0.0667
        pgm_function7[(30, 10, 21)] = 0.0044
        pgm_function7[(30, 11, 13)] = 0.0022
        pgm_function7[(30, 11, 14)] = 0.078907947
        pgm_function7[(30, 11, 15)] = 0.28442828
        pgm_function7[(30, 11, 16)] = 0.3789
        pgm_function7[(30, 11, 17)] = 0.251125246
        pgm_function7[(30, 11, 18)] = 0.080008053
        pgm_function7[(30, 11, 19)] = 0.006699335
        pgm_function7[(30, 12, 11)] = 0.00110011
        pgm_function7[(30, 12, 12)] = 0.06220623
        pgm_function7[(30, 12, 13)] = 0.2578
        pgm_function7[(30, 12, 14)] = 0.383338104
        pgm_function7[(30, 12, 15)] = 0.2767
        pgm_function7[(30, 12, 16)] = 0.0922
        pgm_function7[(30, 12, 17)] = 0.01
        pgm_function7[(30, 13, 10)] = 0.0478
        pgm_function7[(30, 13, 11)] = 0.23
        pgm_function7[(30, 13, 12)] = 0.388861105
        pgm_function7[(30, 13, 13)] = 0.2922
        pgm_function7[(30, 13, 14)] = 0.1089
        pgm_function7[(30, 13, 15)] = 0.0156
        pgm_function7[(30, 14, 8)] = 0.0356
        pgm_function7[(30, 14, 9)] = 0.206679056
        pgm_function7[(30, 14, 10)] = 0.3767
        pgm_function7[(30, 14, 11)] = 0.3133
        pgm_function7[(30, 14, 12)] = 0.1278
        pgm_function7[(30, 14, 13)] = 0.0211
        pgm_function7[(30, 15, 6)] = 0.024402413
        pgm_function7[(30, 15, 7)] = 0.18
        pgm_function7[(30, 15, 8)] = 0.3667371
        pgm_function7[(30, 15, 9)] = 0.3356
        pgm_function7[(30, 15, 10)] = 0.1489
        pgm_function7[(30, 15, 11)] = 0.028902919
        pgm_function7[(30, 16, 4)] = 0.0156
        pgm_function7[(30, 16, 5)] = 0.1544
        pgm_function7[(30, 16, 6)] = 0.355564206
        pgm_function7[(30, 16, 7)] = 0.348865265
        pgm_function7[(30, 16, 8)] = 0.1733
        pgm_function7[(30, 16, 9)] = 0.035596436
        pgm_function7[(30, 17, 2)] = 0.01
        pgm_function7[(30, 17, 3)] = 0.132187062
        pgm_function7[(30, 17, 4)] = 0.3356
        pgm_function7[(30, 17, 5)] = 0.362236319
        pgm_function7[(30, 17, 6)] = 0.1978
        pgm_function7[(30, 17, 7)] = 0.0456
        pgm_function7[(30, 17, 8)] = 0.001100219
        pgm_function7[(30, 18, 0)] = 0.004400441
        pgm_function7[(30, 18, 1)] = 0.11
        pgm_function7[(30, 18, 2)] = 0.31333106
        pgm_function7[(30, 18, 3)] = 0.3789
        pgm_function7[(30, 18, 4)] = 0.22107813
        pgm_function7[(30, 18, 5)] = 0.055594439
        pgm_function7[(30, 18, 6)] = 0.0022
        pgm_function7[(30, 19, 0)] = 0.3256
        pgm_function7[(30, 19, 1)] = 0.3833
        pgm_function7[(30, 19, 2)] = 0.24
        pgm_function7[(30, 19, 3)] = 0.07
        pgm_function7[(30, 19, 4)] = 0.004400444
        pgm_function7[(31, 2, 31)] = 0.002200221
        pgm_function7[(31, 3, 29)] = 0.001100111
        pgm_function7[(31, 3, 30)] = 0.0611
        pgm_function7[(31, 3, 31)] = 0.2567
        pgm_function7[(31, 4, 28)] = 0.0489
        pgm_function7[(31, 4, 29)] = 0.229977108
        pgm_function7[(31, 4, 30)] = 0.374437378
        pgm_function7[(31, 4, 31)] = 0.29557044
        pgm_function7[(31, 5, 26)] = 0.037796225
        pgm_function7[(31, 5, 27)] = 0.1989
        pgm_function7[(31, 5, 28)] = 0.37113719
        pgm_function7[(31, 5, 29)] = 0.3133
        pgm_function7[(31, 5, 30)] = 0.13561409
        pgm_function7[(31, 5, 31)] = 0.0256
        pgm_function7[(31, 6, 24)] = 0.02440241
        pgm_function7[(31, 6, 25)] = 0.1756
        pgm_function7[(31, 6, 26)] = 0.3633
        pgm_function7[(31, 6, 27)] = 0.33003323
        pgm_function7[(31, 6, 28)] = 0.155584073
        pgm_function7[(31, 6, 29)] = 0.033296729
        pgm_function7[(31, 7, 22)] = 0.0156
        pgm_function7[(31, 7, 23)] = 0.1567
        pgm_function7[(31, 7, 24)] = 0.345565415
        pgm_function7[(31, 7, 25)] = 0.345565162
        pgm_function7[(31, 7, 26)] = 0.1756
        pgm_function7[(31, 7, 27)] = 0.042204216
        pgm_function7[(31, 7, 28)] = 0.0011
        pgm_function7[(31, 8, 20)] = 0.01110111
        pgm_function7[(31, 8, 21)] = 0.1289
        pgm_function7[(31, 8, 22)] = 0.3311
        pgm_function7[(31, 8, 23)] = 0.357764333
        pgm_function7[(31, 8, 24)] = 0.2
        pgm_function7[(31, 8, 25)] = 0.05110512
        pgm_function7[(31, 8, 26)] = 0.002200221
        pgm_function7[(31, 9, 18)] = 0.0067
        pgm_function7[(31, 9, 19)] = 0.10671106
        pgm_function7[(31, 9, 20)] = 0.313331244
        pgm_function7[(31, 9, 21)] = 0.37
        pgm_function7[(31, 9, 22)] = 0.22112209
        pgm_function7[(31, 9, 23)] = 0.0622
        pgm_function7[(31, 9, 24)] = 0.004400442
        pgm_function7[(31, 10, 16)] = 0.002200221
        pgm_function7[(31, 10, 17)] = 0.0889
        pgm_function7[(31, 10, 18)] = 0.2889
        pgm_function7[(31, 10, 19)] = 0.3789
        pgm_function7[(31, 10, 20)] = 0.24
        pgm_function7[(31, 10, 21)] = 0.0767
        pgm_function7[(31, 10, 22)] = 0.00669866
        pgm_function7[(31, 11, 14)] = 0.001100111
        pgm_function7[(31, 11, 15)] = 0.07000707
        pgm_function7[(31, 11, 16)] = 0.2633
        pgm_function7[(31, 11, 17)] = 0.384438377
        pgm_function7[(31, 11, 18)] = 0.263326174
        pgm_function7[(31, 11, 19)] = 0.09109097
        pgm_function7[(31, 11, 20)] = 0.01
        pgm_function7[(31, 12, 13)] = 0.0511
        pgm_function7[(31, 12, 14)] = 0.243324066
        pgm_function7[(31, 12, 15)] = 0.3789
        pgm_function7[(31, 12, 16)] = 0.29
        pgm_function7[(31, 12, 17)] = 0.1067
        pgm_function7[(31, 12, 18)] = 0.01330131
        pgm_function7[(31, 13, 11)] = 0.0389
        pgm_function7[(31, 13, 12)] = 0.212179057
        pgm_function7[(31, 13, 13)] = 0.38
        pgm_function7[(31, 13, 14)] = 0.3122
        pgm_function7[(31, 13, 15)] = 0.1233
        pgm_function7[(31, 13, 16)] = 0.0189
        pgm_function7[(31, 14, 9)] = 0.027797208
        pgm_function7[(31, 14, 10)] = 0.1867
        pgm_function7[(31, 14, 11)] = 0.3767
        pgm_function7[(31, 14, 12)] = 0.3256
        pgm_function7[(31, 14, 13)] = 0.1444
        pgm_function7[(31, 14, 14)] = 0.025597407
        pgm_function7[(31, 15, 7)] = 0.0189
        pgm_function7[(31, 15, 8)] = 0.164416
        pgm_function7[(31, 15, 9)] = 0.3567
        pgm_function7[(31, 15, 10)] = 0.3422
        pgm_function7[(31, 15, 11)] = 0.16671711
        pgm_function7[(31, 15, 12)] = 0.033303316
        pgm_function7[(31, 16, 5)] = 0.0122
        pgm_function7[(31, 16, 6)] = 0.138886081
        pgm_function7[(31, 16, 7)] = 0.337766257
        pgm_function7[(31, 16, 8)] = 0.36
        pgm_function7[(31, 16, 9)] = 0.187781192
        pgm_function7[(31, 16, 10)] = 0.044404422
        pgm_function7[(31, 16, 11)] = 0.0011
        pgm_function7[(31, 17, 3)] = 0.006699333
        pgm_function7[(31, 17, 4)] = 0.1156
        pgm_function7[(31, 17, 5)] = 0.322232284
        pgm_function7[(31, 17, 6)] = 0.37
        pgm_function7[(31, 17, 7)] = 0.2133
        pgm_function7[(31, 17, 8)] = 0.054410872
        pgm_function7[(31, 17, 9)] = 0.002200221
        pgm_function7[(31, 18, 1)] = 0.0033
        pgm_function7[(31, 18, 2)] = 0.09440942
        pgm_function7[(31, 18, 3)] = 0.2989
        pgm_function7[(31, 18, 4)] = 0.37776223
        pgm_function7[(31, 18, 5)] = 0.237776169
        pgm_function7[(31, 18, 6)] = 0.0656
        pgm_function7[(31, 18, 7)] = 0.0044
        pgm_function7[(31, 19, 0)] = 0.0878
        pgm_function7[(31, 19, 1)] = 0.2767
        pgm_function7[(31, 19, 2)] = 0.3889
        pgm_function7[(31, 19, 3)] = 0.2556
        pgm_function7[(31, 19, 4)] = 0.08110817
        pgm_function7[(31, 19, 5)] = 0.006699334
        pgm_function7[(32, 3, 31)] = 0.0533
        pgm_function7[(32, 4, 29)] = 0.038896118
        pgm_function7[(32, 4, 30)] = 0.214421217
        pgm_function7[(32, 4, 31)] = 0.36666355
        pgm_function7[(32, 5, 27)] = 0.0289
        pgm_function7[(32, 5, 28)] = 0.18671909
        pgm_function7[(32, 5, 29)] = 0.3633
        pgm_function7[(32, 5, 30)] = 0.32333223
        pgm_function7[(32, 5, 31)] = 0.15
        pgm_function7[(32, 6, 25)] = 0.0211
        pgm_function7[(32, 6, 26)] = 0.1578
        pgm_function7[(32, 6, 27)] = 0.35443525
        pgm_function7[(32, 6, 28)] = 0.337766159
        pgm_function7[(32, 6, 29)] = 0.169983146
        pgm_function7[(32, 6, 30)] = 0.0411
        pgm_function7[(32, 7, 23)] = 0.0111
        pgm_function7[(32, 7, 24)] = 0.137786165
        pgm_function7[(32, 7, 25)] = 0.335566158
        pgm_function7[(32, 7, 26)] = 0.3567
        pgm_function7[(32, 7, 27)] = 0.191119073
        pgm_function7[(32, 7, 28)] = 0.05
        pgm_function7[(32, 7, 29)] = 0.001100111
        pgm_function7[(32, 8, 21)] = 0.0067
        pgm_function7[(32, 8, 22)] = 0.1156
        pgm_function7[(32, 8, 23)] = 0.315568293
        pgm_function7[(32, 8, 24)] = 0.3689
        pgm_function7[(32, 8, 25)] = 0.21332108
        pgm_function7[(32, 8, 26)] = 0.05890594
        pgm_function7[(32, 8, 27)] = 0.004400445
        pgm_function7[(32, 9, 19)] = 0.004400442
        pgm_function7[(32, 9, 20)] = 0.092209272
        pgm_function7[(32, 9, 21)] = 0.2978
        pgm_function7[(32, 9, 22)] = 0.37443715
        pgm_function7[(32, 9, 23)] = 0.2389
        pgm_function7[(32, 9, 24)] = 0.07110714
        pgm_function7[(32, 9, 25)] = 0.006699334
        pgm_function7[(32, 10, 17)] = 0.0022
        pgm_function7[(32, 10, 18)] = 0.0733
        pgm_function7[(32, 10, 19)] = 0.2744
        pgm_function7[(32, 10, 20)] = 0.3811
        pgm_function7[(32, 10, 21)] = 0.2589
        pgm_function7[(32, 10, 22)] = 0.0855829
        pgm_function7[(32, 10, 23)] = 0.009999006
        pgm_function7[(32, 11, 16)] = 0.06
        pgm_function7[(32, 11, 17)] = 0.24442424
        pgm_function7[(32, 11, 18)] = 0.382238252
        pgm_function7[(32, 11, 19)] = 0.279972216
        pgm_function7[(32, 11, 20)] = 0.1044
        pgm_function7[(32, 11, 21)] = 0.0133
        pgm_function7[(32, 12, 14)] = 0.042204211
        pgm_function7[(32, 12, 15)] = 0.22
        pgm_function7[(32, 12, 16)] = 0.3789
        pgm_function7[(32, 12, 17)] = 0.3044
        pgm_function7[(32, 12, 18)] = 0.12111213
        pgm_function7[(32, 12, 19)] = 0.0178
        pgm_function7[(32, 13, 12)] = 0.029997008
        pgm_function7[(32, 13, 13)] = 0.1978
        pgm_function7[(32, 13, 14)] = 0.3689
        pgm_function7[(32, 13, 15)] = 0.3244
        pgm_function7[(32, 13, 16)] = 0.1378
        pgm_function7[(32, 13, 17)] = 0.0244
        pgm_function7[(32, 14, 10)] = 0.0222
        pgm_function7[(32, 14, 11)] = 0.1678
        pgm_function7[(32, 14, 12)] = 0.3633
        pgm_function7[(32, 14, 13)] = 0.3378
        pgm_function7[(32, 14, 14)] = 0.161084043
        pgm_function7[(32, 14, 15)] = 0.032206391
        pgm_function7[(32, 15, 8)] = 0.0144014
        pgm_function7[(32, 15, 9)] = 0.1444
        pgm_function7[(32, 15, 10)] = 0.3511
        pgm_function7[(32, 15, 11)] = 0.351135232
        pgm_function7[(32, 15, 12)] = 0.182218087
        pgm_function7[(32, 15, 13)] = 0.0422
        pgm_function7[(32, 16, 6)] = 0.007799225
        pgm_function7[(32, 16, 7)] = 0.126687096
        pgm_function7[(32, 16, 8)] = 0.3256
        pgm_function7[(32, 16, 9)] = 0.366663374
        pgm_function7[(32, 16, 10)] = 0.2033201
        pgm_function7[(32, 16, 11)] = 0.0511
        pgm_function7[(32, 16, 12)] = 0.0022
        pgm_function7[(32, 17, 4)] = 0.0044
        pgm_function7[(32, 17, 5)] = 0.10221009
        pgm_function7[(32, 17, 6)] = 0.3033
        pgm_function7[(32, 17, 7)] = 0.3767
        pgm_function7[(32, 17, 8)] = 0.224444883
        pgm_function7[(32, 17, 9)] = 0.063306324
        pgm_function7[(32, 17, 10)] = 0.00440044
        pgm_function7[(32, 18, 2)] = 0.00220022
        pgm_function7[(32, 18, 3)] = 0.08
        pgm_function7[(32, 18, 4)] = 0.28557117
        pgm_function7[(32, 18, 5)] = 0.37996227
        pgm_function7[(32, 18, 6)] = 0.2522
        pgm_function7[(32, 18, 7)] = 0.0767
        pgm_function7[(32, 18, 8)] = 0.006699332
        pgm_function7[(32, 19, 0)] = 0.0011
        pgm_function7[(32, 19, 1)] = 0.0633
        pgm_function7[(32, 19, 2)] = 0.2567
        pgm_function7[(32, 19, 3)] = 0.3878
        pgm_function7[(32, 19, 4)] = 0.273327235
        pgm_function7[(32, 19, 5)] = 0.091090952
        pgm_function7[(32, 19, 6)] = 0.01
        pgm_function7[(33, 4, 30)] = 0.03000303
        pgm_function7[(33, 4, 31)] = 0.1966803
        pgm_function7[(33, 5, 28)] = 0.02220221
        pgm_function7[(33, 5, 29)] = 0.17
        pgm_function7[(33, 5, 30)] = 0.35443525
        pgm_function7[(33, 5, 31)] = 0.3378
        pgm_function7[(33, 6, 26)] = 0.0156
        pgm_function7[(33, 6, 27)] = 0.1433141
        pgm_function7[(33, 6, 28)] = 0.343266161
        pgm_function7[(33, 6, 29)] = 0.347765299
        pgm_function7[(33, 6, 30)] = 0.1856
        pgm_function7[(33, 6, 31)] = 0.046695329
        pgm_function7[(33, 7, 24)] = 0.009999012
        pgm_function7[(33, 7, 25)] = 0.121088057
        pgm_function7[(33, 7, 26)] = 0.3233
        pgm_function7[(33, 7, 27)] = 0.358936136
        pgm_function7[(33, 7, 28)] = 0.2056
        pgm_function7[(33, 7, 29)] = 0.060006047
        pgm_function7[(33, 7, 30)] = 0.0033
        pgm_function7[(33, 8, 22)] = 0.0044
        pgm_function7[(33, 8, 23)] = 0.102190095
        pgm_function7[(33, 8, 24)] = 0.2978
        pgm_function7[(33, 8, 25)] = 0.37333714
        pgm_function7[(33, 8, 26)] = 0.231123157
        pgm_function7[(33, 8, 27)] = 0.068906973
        pgm_function7[(33, 8, 28)] = 0.00669933
        pgm_function7[(33, 9, 20)] = 0.002200222
        pgm_function7[(33, 9, 21)] = 0.08
        pgm_function7[(33, 9, 22)] = 0.27782811
        pgm_function7[(33, 9, 23)] = 0.38
        pgm_function7[(33, 9, 24)] = 0.252225141
        pgm_function7[(33, 9, 25)] = 0.081091954
        pgm_function7[(33, 9, 26)] = 0.01000101
        pgm_function7[(33, 10, 18)] = 0.0011
        pgm_function7[(33, 10, 19)] = 0.0622
        pgm_function7[(33, 10, 20)] = 0.2589
        pgm_function7[(33, 10, 21)] = 0.3778
        pgm_function7[(33, 10, 22)] = 0.27554501
        pgm_function7[(33, 10, 23)] = 0.096690358
        pgm_function7[(33, 10, 24)] = 0.0133
        pgm_function7[(33, 11, 17)] = 0.048904948
        pgm_function7[(33, 11, 18)] = 0.231123153
        pgm_function7[(33, 11, 19)] = 0.375562289
        pgm_function7[(33, 11, 20)] = 0.2933
        pgm_function7[(33, 11, 21)] = 0.1156
        pgm_function7[(33, 11, 22)] = 0.01779821
        pgm_function7[(33, 12, 15)] = 0.0367
        pgm_function7[(33, 12, 16)] = 0.2022
        pgm_function7[(33, 12, 17)] = 0.37
        pgm_function7[(33, 12, 18)] = 0.31333134
        pgm_function7[(33, 12, 19)] = 0.1367
        pgm_function7[(33, 12, 20)] = 0.0222
        pgm_function7[(33, 13, 13)] = 0.0233
        pgm_function7[(33, 13, 14)] = 0.1778
        pgm_function7[(33, 13, 15)] = 0.3611
        pgm_function7[(33, 13, 16)] = 0.3367
        pgm_function7[(33, 13, 17)] = 0.1544
        pgm_function7[(33, 13, 18)] = 0.03
        pgm_function7[(33, 14, 11)] = 0.0156
        pgm_function7[(33, 14, 12)] = 0.1544
        pgm_function7[(33, 14, 13)] = 0.3511
        pgm_function7[(33, 14, 14)] = 0.347765094
        pgm_function7[(33, 14, 15)] = 0.173334951
        pgm_function7[(33, 14, 16)] = 0.04
        pgm_function7[(33, 15, 9)] = 0.0111
        pgm_function7[(33, 15, 10)] = 0.1289
        pgm_function7[(33, 15, 11)] = 0.334433221
        pgm_function7[(33, 15, 12)] = 0.360036173
        pgm_function7[(33, 15, 13)] = 0.1978
        pgm_function7[(33, 15, 14)] = 0.05
        pgm_function7[(33, 15, 15)] = 0.001099891
        pgm_function7[(33, 16, 7)] = 0.005599444
        pgm_function7[(33, 16, 8)] = 0.1078
        pgm_function7[(33, 16, 9)] = 0.315568322
        pgm_function7[(33, 16, 10)] = 0.371137182
        pgm_function7[(33, 16, 11)] = 0.22
        pgm_function7[(33, 16, 12)] = 0.0589
        pgm_function7[(33, 16, 13)] = 0.003300333
        pgm_function7[(33, 17, 5)] = 0.002200222
        pgm_function7[(33, 17, 6)] = 0.0911
        pgm_function7[(33, 17, 7)] = 0.2889
        pgm_function7[(33, 17, 8)] = 0.383376801
        pgm_function7[(33, 17, 9)] = 0.240024091
        pgm_function7[(33, 17, 10)] = 0.0722072
        pgm_function7[(33, 17, 11)] = 0.006699334
        pgm_function7[(33, 18, 3)] = 0.0011
        pgm_function7[(33, 18, 4)] = 0.06889314
        pgm_function7[(33, 18, 5)] = 0.265573189
        pgm_function7[(33, 18, 6)] = 0.3833
        pgm_function7[(33, 18, 7)] = 0.2644
        pgm_function7[(33, 18, 8)] = 0.086691323
        pgm_function7[(33, 18, 9)] = 0.01
        pgm_function7[(33, 19, 2)] = 0.0522
        pgm_function7[(33, 19, 3)] = 0.2422
        pgm_function7[(33, 19, 4)] = 0.382238329
        pgm_function7[(33, 19, 5)] = 0.291071166
        pgm_function7[(33, 19, 6)] = 0.1033
        pgm_function7[(33, 19, 7)] = 0.0133
        pgm_function7[(34, 4, 31)] = 0.02439764
        pgm_function7[(34, 5, 29)] = 0.0167
        pgm_function7[(34, 5, 30)] = 0.15331511
        pgm_function7[(34, 5, 31)] = 0.3422
        pgm_function7[(34, 6, 27)] = 0.01110111
        pgm_function7[(34, 6, 28)] = 0.128887061
        pgm_function7[(34, 6, 29)] = 0.326667281
        pgm_function7[(34, 6, 30)] = 0.3589
        pgm_function7[(34, 6, 31)] = 0.201080125
        pgm_function7[(34, 7, 25)] = 0.006699333
        pgm_function7[(34, 7, 26)] = 0.1056
        pgm_function7[(34, 7, 27)] = 0.313331119
        pgm_function7[(34, 7, 28)] = 0.3656
        pgm_function7[(34, 7, 29)] = 0.222222173
        pgm_function7[(34, 7, 30)] = 0.0667
        pgm_function7[(34, 7, 31)] = 0.0044
        pgm_function7[(34, 8, 23)] = 0.003299673
        pgm_function7[(34, 8, 24)] = 0.0878
        pgm_function7[(34, 8, 25)] = 0.28672911
        pgm_function7[(34, 8, 26)] = 0.371137252
        pgm_function7[(34, 8, 27)] = 0.244424259
        pgm_function7[(34, 8, 28)] = 0.07779221
        pgm_function7[(34, 8, 29)] = 0.008899115
        pgm_function7[(34, 9, 21)] = 0.0011
        pgm_function7[(34, 9, 22)] = 0.07110713
        pgm_function7[(34, 9, 23)] = 0.2556
        pgm_function7[(34, 9, 24)] = 0.382238214
        pgm_function7[(34, 9, 25)] = 0.265573178
        pgm_function7[(34, 9, 26)] = 0.09220926
        pgm_function7[(34, 9, 27)] = 0.0133
        pgm_function7[(34, 10, 20)] = 0.0511
        pgm_function7[(34, 10, 21)] = 0.2378
        pgm_function7[(34, 10, 22)] = 0.37882402
        pgm_function7[(34, 10, 23)] = 0.288871173
        pgm_function7[(34, 10, 24)] = 0.1078
        pgm_function7[(34, 10, 25)] = 0.0178
        pgm_function7[(34, 11, 18)] = 0.038903926
        pgm_function7[(34, 11, 19)] = 0.216678167
        pgm_function7[(34, 11, 20)] = 0.37
        pgm_function7[(34, 11, 21)] = 0.31
        pgm_function7[(34, 11, 22)] = 0.12778705
        pgm_function7[(34, 11, 23)] = 0.02220222
        pgm_function7[(34, 12, 16)] = 0.0289
        pgm_function7[(34, 12, 17)] = 0.1867
        pgm_function7[(34, 12, 18)] = 0.3644364
        pgm_function7[(34, 12, 19)] = 0.3233
        pgm_function7[(34, 12, 20)] = 0.1511
        pgm_function7[(34, 12, 21)] = 0.0278
        pgm_function7[(34, 13, 14)] = 0.02
        pgm_function7[(34, 13, 15)] = 0.16
        pgm_function7[(34, 13, 16)] = 0.3533
        pgm_function7[(34, 13, 17)] = 0.34
        pgm_function7[(34, 13, 18)] = 0.1711
        pgm_function7[(34, 13, 19)] = 0.0378
        pgm_function7[(34, 14, 12)] = 0.0111
        pgm_function7[(34, 14, 13)] = 0.1367
        pgm_function7[(34, 14, 14)] = 0.337766091
        pgm_function7[(34, 14, 15)] = 0.361171899
        pgm_function7[(34, 14, 16)] = 0.1889
        pgm_function7[(34, 14, 17)] = 0.047795248
        pgm_function7[(34, 14, 18)] = 0.0011
        pgm_function7[(34, 15, 10)] = 0.0067
        pgm_function7[(34, 15, 11)] = 0.114411076
        pgm_function7[(34, 15, 12)] = 0.321132154
        pgm_function7[(34, 15, 13)] = 0.37
        pgm_function7[(34, 15, 14)] = 0.2122
        pgm_function7[(34, 15, 15)] = 0.058894165
        pgm_function7[(34, 15, 16)] = 0.0022
        pgm_function7[(34, 16, 8)] = 0.0044
        pgm_function7[(34, 16, 9)] = 0.092190894
        pgm_function7[(34, 16, 10)] = 0.300030147
        pgm_function7[(34, 16, 11)] = 0.3756
        pgm_function7[(34, 16, 12)] = 0.24
        pgm_function7[(34, 16, 13)] = 0.06890696
        pgm_function7[(34, 16, 14)] = 0.0044
        pgm_function7[(34, 17, 6)] = 0.0011
        pgm_function7[(34, 17, 7)] = 0.0744
        pgm_function7[(34, 17, 8)] = 0.274454857
        pgm_function7[(34, 17, 9)] = 0.384438146
        pgm_function7[(34, 17, 10)] = 0.25782602
        pgm_function7[(34, 17, 11)] = 0.083291756
        pgm_function7[(34, 17, 12)] = 0.0089
        pgm_function7[(34, 18, 5)] = 0.059994043
        pgm_function7[(34, 18, 6)] = 0.2489
        pgm_function7[(34, 18, 7)] = 0.3856
        pgm_function7[(34, 18, 8)] = 0.277772075
        pgm_function7[(34, 18, 9)] = 0.1
        pgm_function7[(34, 18, 10)] = 0.0133
        pgm_function7[(34, 19, 3)] = 0.0422
        pgm_function7[(34, 19, 4)] = 0.223322192
        pgm_function7[(34, 19, 5)] = 0.377762215
        pgm_function7[(34, 19, 6)] = 0.3033
        pgm_function7[(34, 19, 7)] = 0.1178
        pgm_function7[(34, 19, 8)] = 0.0178
        pgm_function7[(35, 5, 30)] = 0.01220121
        pgm_function7[(35, 5, 31)] = 0.1333
        pgm_function7[(35, 6, 28)] = 0.006699333
        pgm_function7[(35, 6, 29)] = 0.1166881
        pgm_function7[(35, 6, 30)] = 0.3111
        pgm_function7[(35, 6, 31)] = 0.365563227
        pgm_function7[(35, 7, 26)] = 0.0044
        pgm_function7[(35, 7, 27)] = 0.092209235
        pgm_function7[(35, 7, 28)] = 0.2933
        pgm_function7[(35, 7, 29)] = 0.37223729
        pgm_function7[(35, 7, 30)] = 0.2378
        pgm_function7[(35, 7, 31)] = 0.0767
        pgm_function7[(35, 8, 24)] = 0.0022
        pgm_function7[(35, 8, 25)] = 0.07330733
        pgm_function7[(35, 8, 26)] = 0.274427187
        pgm_function7[(35, 8, 27)] = 0.374437397
        pgm_function7[(35, 8, 28)] = 0.25997402
        pgm_function7[(35, 8, 29)] = 0.087791252
        pgm_function7[(35, 8, 30)] = 0.0111
        pgm_function7[(35, 9, 23)] = 0.0611
        pgm_function7[(35, 9, 24)] = 0.241124135
        pgm_function7[(35, 9, 25)] = 0.378862254
        pgm_function7[(35, 9, 26)] = 0.28112817
        pgm_function7[(35, 9, 27)] = 0.1033
        pgm_function7[(35, 9, 28)] = 0.0167
        pgm_function7[(35, 10, 21)] = 0.0444
        pgm_function7[(35, 10, 22)] = 0.21555701
        pgm_function7[(35, 10, 23)] = 0.376662226
        pgm_function7[(35, 10, 24)] = 0.3011
        pgm_function7[(35, 10, 25)] = 0.1222
        pgm_function7[(35, 10, 26)] = 0.02220221
        pgm_function7[(35, 11, 19)] = 0.029997023
        pgm_function7[(35, 11, 20)] = 0.1967
        pgm_function7[(35, 11, 21)] = 0.3644
        pgm_function7[(35, 11, 22)] = 0.32216813
        pgm_function7[(35, 11, 23)] = 0.1433141
        pgm_function7[(35, 11, 24)] = 0.027797213
        pgm_function7[(35, 12, 17)] = 0.0222
        pgm_function7[(35, 12, 18)] = 0.17221719
        pgm_function7[(35, 12, 19)] = 0.3533
        pgm_function7[(35, 12, 20)] = 0.3389
        pgm_function7[(35, 12, 21)] = 0.1644
        pgm_function7[(35, 12, 22)] = 0.0356
        pgm_function7[(35, 13, 15)] = 0.0156
        pgm_function7[(35, 13, 16)] = 0.1422
        pgm_function7[(35, 13, 17)] = 0.3456
        pgm_function7[(35, 13, 18)] = 0.3489
        pgm_function7[(35, 13, 19)] = 0.1867
        pgm_function7[(35, 13, 20)] = 0.0444
        pgm_function7[(35, 13, 21)] = 0.001100219
        pgm_function7[(35, 14, 13)] = 0.0089
        pgm_function7[(35, 14, 14)] = 0.121088033
        pgm_function7[(35, 14, 15)] = 0.324464909
        pgm_function7[(35, 14, 16)] = 0.3622
        pgm_function7[(35, 14, 17)] = 0.206679209
        pgm_function7[(35, 14, 18)] = 0.0578
        pgm_function7[(35, 14, 19)] = 0.002200221
        pgm_function7[(35, 15, 11)] = 0.004400443
        pgm_function7[(35, 15, 12)] = 0.101110049
        pgm_function7[(35, 15, 13)] = 0.3
        pgm_function7[(35, 15, 14)] = 0.3767
        pgm_function7[(35, 15, 15)] = 0.227777253
        pgm_function7[(35, 15, 16)] = 0.0689
        pgm_function7[(35, 15, 17)] = 0.0044
        pgm_function7[(35, 16, 9)] = 0.002199782
        pgm_function7[(35, 16, 10)] = 0.080008039
        pgm_function7[(35, 16, 11)] = 0.2833
        pgm_function7[(35, 16, 12)] = 0.3789
        pgm_function7[(35, 16, 13)] = 0.252225219
        pgm_function7[(35, 16, 14)] = 0.0811
        pgm_function7[(35, 16, 15)] = 0.0078
        pgm_function7[(35, 17, 7)] = 0.0011
        pgm_function7[(35, 17, 8)] = 0.062212368
        pgm_function7[(35, 17, 9)] = 0.258926098
        pgm_function7[(35, 17, 10)] = 0.38113802
        pgm_function7[(35, 17, 11)] = 0.275572185
        pgm_function7[(35, 17, 12)] = 0.0922
        pgm_function7[(35, 17, 13)] = 0.01220121
        pgm_function7[(35, 18, 6)] = 0.0478
        pgm_function7[(35, 18, 7)] = 0.23
        pgm_function7[(35, 18, 8)] = 0.384362104
        pgm_function7[(35, 18, 9)] = 0.2922
        pgm_function7[(35, 18, 10)] = 0.1111
        pgm_function7[(35, 18, 11)] = 0.01779821
        pgm_function7[(35, 19, 4)] = 0.035603631
        pgm_function7[(35, 19, 5)] = 0.205579117
        pgm_function7[(35, 19, 6)] = 0.3756
        pgm_function7[(35, 19, 7)] = 0.31
        pgm_function7[(35, 19, 8)] = 0.1322
        pgm_function7[(35, 19, 9)] = 0.022197827
        pgm_function7[(36, 5, 31)] = 0.0111
        pgm_function7[(36, 6, 29)] = 0.005599445
        pgm_function7[(36, 6, 30)] = 0.0989
        pgm_function7[(36, 6, 31)] = 0.297770185
        pgm_function7[(36, 7, 27)] = 0.002200221
        pgm_function7[(36, 7, 28)] = 0.0833
        pgm_function7[(36, 7, 29)] = 0.273327213
        pgm_function7[(36, 7, 30)] = 0.3789
        pgm_function7[(36, 7, 31)] = 0.2533
        pgm_function7[(36, 8, 25)] = 0.00110011
        pgm_function7[(36, 8, 26)] = 0.062206242
        pgm_function7[(36, 8, 27)] = 0.252225267
        pgm_function7[(36, 8, 28)] = 0.37886203
        pgm_function7[(36, 8, 29)] = 0.275572163
        pgm_function7[(36, 8, 30)] = 0.1
        pgm_function7[(36, 8, 31)] = 0.01440141
        pgm_function7[(36, 9, 24)] = 0.048904927
        pgm_function7[(36, 9, 25)] = 0.228877153
        pgm_function7[(36, 9, 26)] = 0.37333722
        pgm_function7[(36, 9, 27)] = 0.2956
        pgm_function7[(36, 9, 28)] = 0.1167
        pgm_function7[(36, 9, 29)] = 0.02109791
        pgm_function7[(36, 10, 22)] = 0.0377924
        pgm_function7[(36, 10, 23)] = 0.198880119
        pgm_function7[(36, 10, 24)] = 0.37
        pgm_function7[(36, 10, 25)] = 0.3133
        pgm_function7[(36, 10, 26)] = 0.13671407
        pgm_function7[(36, 10, 27)] = 0.02780283
        pgm_function7[(36, 11, 20)] = 0.0256
        pgm_function7[(36, 11, 21)] = 0.1756
        pgm_function7[(36, 11, 22)] = 0.35996414
        pgm_function7[(36, 11, 23)] = 0.32783323
        pgm_function7[(36, 11, 24)] = 0.159984075
        pgm_function7[(36, 11, 25)] = 0.0344
        pgm_function7[(36, 12, 18)] = 0.01560162
        pgm_function7[(36, 12, 19)] = 0.1567
        pgm_function7[(36, 12, 20)] = 0.34
        pgm_function7[(36, 12, 21)] = 0.3489
        pgm_function7[(36, 12, 22)] = 0.1789
        pgm_function7[(36, 12, 23)] = 0.043304312
        pgm_function7[(36, 12, 24)] = 0.001100111
        pgm_function7[(36, 13, 16)] = 0.0111
        pgm_function7[(36, 13, 17)] = 0.1289
        pgm_function7[(36, 13, 18)] = 0.3278
        pgm_function7[(36, 13, 19)] = 0.3589
        pgm_function7[(36, 13, 20)] = 0.2022
        pgm_function7[(36, 13, 21)] = 0.053310655
        pgm_function7[(36, 13, 22)] = 0.002200221
        pgm_function7[(36, 14, 14)] = 0.006699332
        pgm_function7[(36, 14, 15)] = 0.104420971
        pgm_function7[(36, 14, 16)] = 0.3156
        pgm_function7[(36, 14, 17)] = 0.365563369
        pgm_function7[(36, 14, 18)] = 0.22
        pgm_function7[(36, 14, 19)] = 0.064406418
        pgm_function7[(36, 14, 20)] = 0.004400442
        pgm_function7[(36, 15, 12)] = 0.002200221
        pgm_function7[(36, 15, 13)] = 0.0878
        pgm_function7[(36, 15, 14)] = 0.2867
        pgm_function7[(36, 15, 15)] = 0.375562417
        pgm_function7[(36, 15, 16)] = 0.2422
        pgm_function7[(36, 15, 17)] = 0.08
        pgm_function7[(36, 15, 18)] = 0.006699332
        pgm_function7[(36, 16, 10)] = 0.001100111
        pgm_function7[(36, 16, 11)] = 0.0689
        pgm_function7[(36, 16, 12)] = 0.26
        pgm_function7[(36, 16, 13)] = 0.384438334
        pgm_function7[(36, 16, 14)] = 0.2667
        pgm_function7[(36, 16, 15)] = 0.0922
        pgm_function7[(36, 16, 16)] = 0.009999014
        pgm_function7[(36, 17, 9)] = 0.051105119
        pgm_function7[(36, 17, 10)] = 0.24112401
        pgm_function7[(36, 17, 11)] = 0.379962255
        pgm_function7[(36, 17, 12)] = 0.2922
        pgm_function7[(36, 17, 13)] = 0.10441006
        pgm_function7[(36, 17, 14)] = 0.0156
        pgm_function7[(36, 18, 7)] = 0.0389
        pgm_function7[(36, 18, 8)] = 0.215578058
        pgm_function7[(36, 18, 9)] = 0.3756
        pgm_function7[(36, 18, 10)] = 0.3089
        pgm_function7[(36, 18, 11)] = 0.12218805
        pgm_function7[(36, 18, 12)] = 0.0211
        pgm_function7[(36, 19, 5)] = 0.027797216
        pgm_function7[(36, 19, 6)] = 0.1856
        pgm_function7[(36, 19, 7)] = 0.3733
        pgm_function7[(36, 19, 8)] = 0.3233
        pgm_function7[(36, 19, 9)] = 0.145585175
        pgm_function7[(36, 19, 10)] = 0.0278
        pgm_function7[(37, 6, 30)] = 0.0044
        pgm_function7[(37, 6, 31)] = 0.086691354
        pgm_function7[(37, 7, 28)] = 0.0011
        pgm_function7[(37, 7, 29)] = 0.070007055
        pgm_function7[(37, 7, 30)] = 0.2522
        pgm_function7[(37, 7, 31)] = 0.3778
        pgm_function7[(37, 8, 27)] = 0.055605659
        pgm_function7[(37, 8, 28)] = 0.23107702
        pgm_function7[(37, 8, 29)] = 0.377762223
        pgm_function7[(37, 8, 30)] = 0.2911
        pgm_function7[(37, 8, 31)] = 0.11221104
        pgm_function7[(37, 9, 25)] = 0.038896126
        pgm_function7[(37, 9, 26)] = 0.21112113
        pgm_function7[(37, 9, 27)] = 0.37
        pgm_function7[(37, 9, 28)] = 0.3078
        pgm_function7[(37, 9, 29)] = 0.12888709
        pgm_function7[(37, 9, 30)] = 0.02559742
        pgm_function7[(37, 10, 23)] = 0.028897117
        pgm_function7[(37, 10, 24)] = 0.1856
        pgm_function7[(37, 10, 25)] = 0.3611
        pgm_function7[(37, 10, 26)] = 0.32333216
        pgm_function7[(37, 10, 27)] = 0.15001518
        pgm_function7[(37, 10, 28)] = 0.032203236
        pgm_function7[(37, 11, 21)] = 0.0211
        pgm_function7[(37, 11, 22)] = 0.15668406
        pgm_function7[(37, 11, 23)] = 0.35333525
        pgm_function7[(37, 11, 24)] = 0.335566158
        pgm_function7[(37, 11, 25)] = 0.1711
        pgm_function7[(37, 11, 26)] = 0.042204219
        pgm_function7[(37, 11, 27)] = 0.0011
        pgm_function7[(37, 12, 19)] = 0.0122
        pgm_function7[(37, 12, 20)] = 0.1367
        pgm_function7[(37, 12, 21)] = 0.3322
        pgm_function7[(37, 12, 22)] = 0.3533
        pgm_function7[(37, 12, 23)] = 0.193319054
        pgm_function7[(37, 12, 24)] = 0.051105125
        pgm_function7[(37, 12, 25)] = 0.002200222
        pgm_function7[(37, 13, 17)] = 0.0067
        pgm_function7[(37, 13, 18)] = 0.1178
        pgm_function7[(37, 13, 19)] = 0.3111
        pgm_function7[(37, 13, 20)] = 0.3678
        pgm_function7[(37, 13, 21)] = 0.21444282
        pgm_function7[(37, 13, 22)] = 0.061106129
        pgm_function7[(37, 13, 23)] = 0.00440044
        pgm_function7[(37, 14, 15)] = 0.004400879
        pgm_function7[(37, 14, 16)] = 0.0911
        pgm_function7[(37, 14, 17)] = 0.297770301
        pgm_function7[(37, 14, 18)] = 0.3744
        pgm_function7[(37, 14, 19)] = 0.237824067
        pgm_function7[(37, 14, 20)] = 0.073307326
        pgm_function7[(37, 14, 21)] = 0.006699336
        pgm_function7[(37, 15, 13)] = 0.0022
        pgm_function7[(37, 15, 14)] = 0.0733
        pgm_function7[(37, 15, 15)] = 0.275572306
        pgm_function7[(37, 15, 16)] = 0.3767
        pgm_function7[(37, 15, 17)] = 0.2567
        pgm_function7[(37, 15, 18)] = 0.087791232
        pgm_function7[(37, 15, 19)] = 0.01
        pgm_function7[(37, 16, 12)] = 0.06
        pgm_function7[(37, 16, 13)] = 0.242224211
        pgm_function7[(37, 16, 14)] = 0.38
        pgm_function7[(37, 16, 15)] = 0.2789
        pgm_function7[(37, 16, 16)] = 0.106689149
        pgm_function7[(37, 16, 17)] = 0.01330131
        pgm_function7[(37, 17, 10)] = 0.0433043
        pgm_function7[(37, 17, 11)] = 0.217778146
        pgm_function7[(37, 17, 12)] = 0.3789
        pgm_function7[(37, 17, 13)] = 0.30563118
        pgm_function7[(37, 17, 14)] = 0.1211
        pgm_function7[(37, 17, 15)] = 0.0189
        pgm_function7[(37, 18, 8)] = 0.028897108
        pgm_function7[(37, 18, 9)] = 0.1978
        pgm_function7[(37, 18, 10)] = 0.37
        pgm_function7[(37, 18, 11)] = 0.32556713
        pgm_function7[(37, 18, 12)] = 0.1389
        pgm_function7[(37, 18, 13)] = 0.025594886
        pgm_function7[(37, 19, 6)] = 0.0222
        pgm_function7[(37, 19, 7)] = 0.17
        pgm_function7[(37, 19, 8)] = 0.36
        pgm_function7[(37, 19, 9)] = 0.337766405
        pgm_function7[(37, 19, 10)] = 0.1622
        pgm_function7[(37, 19, 11)] = 0.033303309
        pgm_function7[(38, 6, 31)] = 0.002199781
        pgm_function7[(38, 7, 29)] = 0.001100111
        pgm_function7[(38, 7, 30)] = 0.0611
        pgm_function7[(38, 7, 31)] = 0.2389
        pgm_function7[(38, 8, 28)] = 0.0455954
        pgm_function7[(38, 8, 29)] = 0.211079125
        pgm_function7[(38, 8, 30)] = 0.3711
        pgm_function7[(38, 8, 31)] = 0.30443012
        pgm_function7[(38, 9, 26)] = 0.03220322
        pgm_function7[(38, 9, 27)] = 0.1922
        pgm_function7[(38, 9, 28)] = 0.3644
        pgm_function7[(38, 9, 29)] = 0.31996822
        pgm_function7[(38, 9, 30)] = 0.1466851
        pgm_function7[(38, 9, 31)] = 0.029997023
        pgm_function7[(38, 10, 24)] = 0.0222
        pgm_function7[(38, 10, 25)] = 0.1689
        pgm_function7[(38, 10, 26)] = 0.35223518
        pgm_function7[(38, 10, 27)] = 0.3344334
        pgm_function7[(38, 10, 28)] = 0.164416186
        pgm_function7[(38, 10, 29)] = 0.04
        pgm_function7[(38, 11, 22)] = 0.01559841
        pgm_function7[(38, 11, 23)] = 0.1422141
        pgm_function7[(38, 11, 24)] = 0.34106616
        pgm_function7[(38, 11, 25)] = 0.3489
        pgm_function7[(38, 11, 26)] = 0.184418085
        pgm_function7[(38, 11, 27)] = 0.0489
        pgm_function7[(38, 11, 28)] = 0.0011
        pgm_function7[(38, 12, 20)] = 0.0111
        pgm_function7[(38, 12, 21)] = 0.12
        pgm_function7[(38, 12, 22)] = 0.3222
        pgm_function7[(38, 12, 23)] = 0.360036101
        pgm_function7[(38, 12, 24)] = 0.2078211
        pgm_function7[(38, 12, 25)] = 0.058905945
        pgm_function7[(38, 12, 26)] = 0.004399565
        pgm_function7[(38, 13, 18)] = 0.0044
        pgm_function7[(38, 13, 19)] = 0.1011
        pgm_function7[(38, 13, 20)] = 0.2956
        pgm_function7[(38, 13, 21)] = 0.373374686
        pgm_function7[(38, 13, 22)] = 0.232223111
        pgm_function7[(38, 13, 23)] = 0.0711071
        pgm_function7[(38, 13, 24)] = 0.006699332
        pgm_function7[(38, 14, 16)] = 0.0022
        pgm_function7[(38, 14, 17)] = 0.081091982
        pgm_function7[(38, 14, 18)] = 0.2756
        pgm_function7[(38, 14, 19)] = 0.380038106
        pgm_function7[(38, 14, 20)] = 0.253325091
        pgm_function7[(38, 14, 21)] = 0.083291772
        pgm_function7[(38, 14, 22)] = 0.01
        pgm_function7[(38, 15, 14)] = 0.0011
        pgm_function7[(38, 15, 15)] = 0.061093968
        pgm_function7[(38, 15, 16)] = 0.2567
        pgm_function7[(38, 15, 17)] = 0.3789
        pgm_function7[(38, 15, 18)] = 0.275572102
        pgm_function7[(38, 15, 19)] = 0.1
        pgm_function7[(38, 15, 20)] = 0.01330131
        pgm_function7[(38, 16, 13)] = 0.048904943
        pgm_function7[(38, 16, 14)] = 0.2289
        pgm_function7[(38, 16, 15)] = 0.3767
        pgm_function7[(38, 16, 16)] = 0.295570414
        pgm_function7[(38, 16, 17)] = 0.11671206
        pgm_function7[(38, 16, 18)] = 0.01779821
        pgm_function7[(38, 17, 11)] = 0.036696325
        pgm_function7[(38, 17, 12)] = 0.1989
        pgm_function7[(38, 17, 13)] = 0.37113722
        pgm_function7[(38, 17, 14)] = 0.3144
        pgm_function7[(38, 17, 15)] = 0.1367
        pgm_function7[(38, 17, 16)] = 0.02440241
        pgm_function7[(38, 18, 9)] = 0.0244
        pgm_function7[(38, 18, 10)] = 0.1756
        pgm_function7[(38, 18, 11)] = 0.36106414
        pgm_function7[(38, 18, 12)] = 0.3333
        pgm_function7[(38, 18, 13)] = 0.156668912
        pgm_function7[(38, 18, 14)] = 0.0322
        pgm_function7[(38, 19, 7)] = 0.0156
        pgm_function7[(38, 19, 8)] = 0.1556
        pgm_function7[(38, 19, 9)] = 0.346665416
        pgm_function7[(38, 19, 10)] = 0.3489
        pgm_function7[(38, 19, 11)] = 0.175618046
        pgm_function7[(38, 19, 12)] = 0.042204224
        pgm_function7[(39, 7, 31)] = 0.0489
        pgm_function7[(39, 8, 29)] = 0.038896123
        pgm_function7[(39, 8, 30)] = 0.1978
        pgm_function7[(39, 8, 31)] = 0.36113614
        pgm_function7[(39, 9, 27)] = 0.0256
        pgm_function7[(39, 9, 28)] = 0.1733
        pgm_function7[(39, 9, 29)] = 0.35886425
        pgm_function7[(39, 9, 30)] = 0.32776723
        pgm_function7[(39, 9, 31)] = 0.162184127
        pgm_function7[(39, 10, 25)] = 0.0167
        pgm_function7[(39, 10, 26)] = 0.15221508
        pgm_function7[(39, 10, 27)] = 0.34443441
        pgm_function7[(39, 10, 28)] = 0.343334388
        pgm_function7[(39, 10, 29)] = 0.1822
        pgm_function7[(39, 10, 30)] = 0.0467
        pgm_function7[(39, 10, 31)] = 0.0011
        pgm_function7[(39, 11, 23)] = 0.01110111
        pgm_function7[(39, 11, 24)] = 0.128887061
        pgm_function7[(39, 11, 25)] = 0.3244
        pgm_function7[(39, 11, 26)] = 0.360036166
        pgm_function7[(39, 11, 27)] = 0.1989
        pgm_function7[(39, 11, 28)] = 0.0578
        pgm_function7[(39, 11, 29)] = 0.003299672
        pgm_function7[(39, 12, 21)] = 0.0067
        pgm_function7[(39, 12, 22)] = 0.1056
        pgm_function7[(39, 12, 23)] = 0.308931087
        pgm_function7[(39, 12, 24)] = 0.364436175
        pgm_function7[(39, 12, 25)] = 0.223322172
        pgm_function7[(39, 12, 26)] = 0.067793284
        pgm_function7[(39, 12, 27)] = 0.006699337
        pgm_function7[(39, 13, 19)] = 0.0044
        pgm_function7[(39, 13, 20)] = 0.0878
        pgm_function7[(39, 13, 21)] = 0.283356762
        pgm_function7[(39, 13, 22)] = 0.370037178
        pgm_function7[(39, 13, 23)] = 0.24672501
        pgm_function7[(39, 13, 24)] = 0.079992022
        pgm_function7[(39, 13, 25)] = 0.01
        pgm_function7[(39, 14, 17)] = 0.001099891
        pgm_function7[(39, 14, 18)] = 0.07
        pgm_function7[(39, 14, 19)] = 0.254425071
        pgm_function7[(39, 14, 20)] = 0.381138137
        pgm_function7[(39, 14, 21)] = 0.266673232
        pgm_function7[(39, 14, 22)] = 0.0967
        pgm_function7[(39, 14, 23)] = 0.01329871
        pgm_function7[(39, 15, 16)] = 0.0533
        pgm_function7[(39, 15, 17)] = 0.2356
        pgm_function7[(39, 15, 18)] = 0.376662139
        pgm_function7[(39, 15, 19)] = 0.2889
        pgm_function7[(39, 15, 20)] = 0.11111106
        pgm_function7[(39, 15, 21)] = 0.01779821
        pgm_function7[(39, 16, 14)] = 0.0389
        pgm_function7[(39, 16, 15)] = 0.2144
        pgm_function7[(39, 16, 16)] = 0.365563512
        pgm_function7[(39, 16, 17)] = 0.31113116
        pgm_function7[(39, 16, 18)] = 0.13108705
        pgm_function7[(39, 16, 19)] = 0.0222
        pgm_function7[(39, 17, 12)] = 0.0289
        pgm_function7[(39, 17, 13)] = 0.18441811
        pgm_function7[(39, 17, 14)] = 0.3633
        pgm_function7[(39, 17, 15)] = 0.3256
        pgm_function7[(39, 17, 16)] = 0.15001508
        pgm_function7[(39, 17, 17)] = 0.028897116
        pgm_function7[(39, 18, 10)] = 0.0211
        pgm_function7[(39, 18, 11)] = 0.15778406
        pgm_function7[(39, 18, 12)] = 0.3556
        pgm_function7[(39, 18, 13)] = 0.33883181
        pgm_function7[(39, 18, 14)] = 0.17
        pgm_function7[(39, 18, 15)] = 0.040004022
        pgm_function7[(39, 19, 8)] = 0.0111
        pgm_function7[(39, 19, 9)] = 0.137786165
        pgm_function7[(39, 19, 10)] = 0.3333
        pgm_function7[(39, 19, 11)] = 0.358936093
        pgm_function7[(39, 19, 12)] = 0.19001911
        pgm_function7[(39, 19, 13)] = 0.05
        pgm_function7[(39, 19, 14)] = 0.0011
        pgm_function7[(40, 8, 30)] = 0.0289
        pgm_function7[(40, 8, 31)] = 0.18561907
        pgm_function7[(40, 9, 28)] = 0.0211
        pgm_function7[(40, 9, 29)] = 0.15558411
        pgm_function7[(40, 9, 30)] = 0.34666524
        pgm_function7[(40, 9, 31)] = 0.336666263
        pgm_function7[(40, 10, 26)] = 0.01330131
        pgm_function7[(40, 10, 27)] = 0.13331316
        pgm_function7[(40, 10, 28)] = 0.334433378
        pgm_function7[(40, 10, 29)] = 0.3478
        pgm_function7[(40, 10, 30)] = 0.1967
        pgm_function7[(40, 10, 31)] = 0.0567
        pgm_function7[(40, 11, 24)] = 0.006699333
        pgm_function7[(40, 11, 25)] = 0.1156
        pgm_function7[(40, 11, 26)] = 0.310031143
        pgm_function7[(40, 11, 27)] = 0.3644
        pgm_function7[(40, 11, 28)] = 0.2178
        pgm_function7[(40, 11, 29)] = 0.065593435
        pgm_function7[(40, 11, 30)] = 0.004399563
        pgm_function7[(40, 12, 22)] = 0.0044
        pgm_function7[(40, 12, 23)] = 0.092209226
        pgm_function7[(40, 12, 24)] = 0.29222914
        pgm_function7[(40, 12, 25)] = 0.374437288
        pgm_function7[(40, 12, 26)] = 0.235576292
        pgm_function7[(40, 12, 27)] = 0.07439268
        pgm_function7[(40, 12, 28)] = 0.0089
        pgm_function7[(40, 13, 20)] = 0.0022
        pgm_function7[(40, 13, 21)] = 0.073314638
        pgm_function7[(40, 13, 22)] = 0.272227131
        pgm_function7[(40, 13, 23)] = 0.37113702
        pgm_function7[(40, 13, 24)] = 0.25887407
        pgm_function7[(40, 13, 25)] = 0.09
        pgm_function7[(40, 13, 26)] = 0.0133
        pgm_function7[(40, 14, 18)] = 0.0011
        pgm_function7[(40, 14, 19)] = 0.061106117
        pgm_function7[(40, 14, 20)] = 0.238924086
        pgm_function7[(40, 14, 21)] = 0.375562327
        pgm_function7[(40, 14, 22)] = 0.28
        pgm_function7[(40, 14, 23)] = 0.1066891
        pgm_function7[(40, 14, 24)] = 0.0178
        pgm_function7[(40, 15, 17)] = 0.0444
        pgm_function7[(40, 15, 18)] = 0.214379079
        pgm_function7[(40, 15, 19)] = 0.3733
        pgm_function7[(40, 15, 20)] = 0.30223015
        pgm_function7[(40, 15, 21)] = 0.12668706
        pgm_function7[(40, 15, 22)] = 0.02220221
        pgm_function7[(40, 16, 15)] = 0.03
        pgm_function7[(40, 16, 16)] = 0.197780277
        pgm_function7[(40, 16, 17)] = 0.36333618
        pgm_function7[(40, 16, 18)] = 0.31996813
        pgm_function7[(40, 16, 19)] = 0.1456
        pgm_function7[(40, 16, 20)] = 0.027797213
        pgm_function7[(40, 17, 13)] = 0.02220221
        pgm_function7[(40, 17, 14)] = 0.17
        pgm_function7[(40, 17, 15)] = 0.3522
        pgm_function7[(40, 17, 16)] = 0.33783417
        pgm_function7[(40, 17, 17)] = 0.165583094
        pgm_function7[(40, 17, 18)] = 0.0367
        pgm_function7[(40, 18, 11)] = 0.01559841
        pgm_function7[(40, 18, 12)] = 0.14
        pgm_function7[(40, 18, 13)] = 0.345530807
        pgm_function7[(40, 18, 14)] = 0.3489
        pgm_function7[(40, 18, 15)] = 0.184418103
        pgm_function7[(40, 18, 16)] = 0.045595428
        pgm_function7[(40, 18, 17)] = 0.0011
        pgm_function7[(40, 19, 9)] = 0.009999012
        pgm_function7[(40, 19, 10)] = 0.1211
        pgm_function7[(40, 19, 11)] = 0.323332084
        pgm_function7[(40, 19, 12)] = 0.363336211
        pgm_function7[(40, 19, 13)] = 0.2067
        pgm_function7[(40, 19, 14)] = 0.0589
        pgm_function7[(40, 19, 15)] = 0.0022
        pgm_function7[(41, 8, 31)] = 0.02220221
        pgm_function7[(41, 9, 29)] = 0.01559841
        pgm_function7[(41, 9, 30)] = 0.1421861
        pgm_function7[(41, 9, 31)] = 0.335566262
        pgm_function7[(41, 10, 27)] = 0.01000101
        pgm_function7[(41, 10, 28)] = 0.118912134
        pgm_function7[(41, 10, 29)] = 0.32
        pgm_function7[(41, 10, 30)] = 0.3544
        pgm_function7[(41, 10, 31)] = 0.21
        pgm_function7[(41, 11, 25)] = 0.0056
        pgm_function7[(41, 11, 26)] = 0.098909945
        pgm_function7[(41, 11, 27)] = 0.2989
        pgm_function7[(41, 11, 28)] = 0.3633
        pgm_function7[(41, 11, 29)] = 0.232177123
        pgm_function7[(41, 11, 30)] = 0.076692357
        pgm_function7[(41, 11, 31)] = 0.006699329
        pgm_function7[(41, 12, 23)] = 0.002200221
        pgm_function7[(41, 12, 24)] = 0.082208239
        pgm_function7[(41, 12, 25)] = 0.270027208
        pgm_function7[(41, 12, 26)] = 0.376662467
        pgm_function7[(41, 12, 27)] = 0.255574273
        pgm_function7[(41, 12, 28)] = 0.0856
        pgm_function7[(41, 12, 29)] = 0.0111
        pgm_function7[(41, 13, 21)] = 0.001100219
        pgm_function7[(41, 13, 22)] = 0.06220623
        pgm_function7[(41, 13, 23)] = 0.25222502
        pgm_function7[(41, 13, 24)] = 0.378862102
        pgm_function7[(41, 13, 25)] = 0.2733
        pgm_function7[(41, 13, 26)] = 0.0989
        pgm_function7[(41, 13, 27)] = 0.01670172
        pgm_function7[(41, 14, 20)] = 0.048904918
        pgm_function7[(41, 14, 21)] = 0.228877199
        pgm_function7[(41, 14, 22)] = 0.37
        pgm_function7[(41, 14, 23)] = 0.29557027
        pgm_function7[(41, 14, 24)] = 0.1178
        pgm_function7[(41, 14, 25)] = 0.02219782
        pgm_function7[(41, 15, 18)] = 0.038896114
        pgm_function7[(41, 15, 19)] = 0.1989
        pgm_function7[(41, 15, 20)] = 0.36443618
        pgm_function7[(41, 15, 21)] = 0.31326916
        pgm_function7[(41, 15, 22)] = 0.13891407
        pgm_function7[(41, 15, 23)] = 0.02780283
        pgm_function7[(41, 16, 16)] = 0.024397634
        pgm_function7[(41, 16, 17)] = 0.17331709
        pgm_function7[(41, 16, 18)] = 0.35776414
        pgm_function7[(41, 16, 19)] = 0.3311
        pgm_function7[(41, 16, 20)] = 0.161084076
        pgm_function7[(41, 16, 21)] = 0.035596406
        pgm_function7[(41, 17, 14)] = 0.0156
        pgm_function7[(41, 17, 15)] = 0.1544
        pgm_function7[(41, 17, 16)] = 0.34223417
        pgm_function7[(41, 17, 17)] = 0.347765198
        pgm_function7[(41, 17, 18)] = 0.1811
        pgm_function7[(41, 17, 19)] = 0.0444
        pgm_function7[(41, 17, 20)] = 0.0011
        pgm_function7[(41, 18, 12)] = 0.0111
        pgm_function7[(41, 18, 13)] = 0.126674929
        pgm_function7[(41, 18, 14)] = 0.3289
        pgm_function7[(41, 18, 15)] = 0.360036202
        pgm_function7[(41, 18, 16)] = 0.201080125
        pgm_function7[(41, 18, 17)] = 0.0556
        pgm_function7[(41, 18, 18)] = 0.00220022
        pgm_function7[(41, 19, 10)] = 0.0067
        pgm_function7[(41, 19, 11)] = 0.104410027
        pgm_function7[(41, 19, 12)] = 0.312231181
        pgm_function7[(41, 19, 13)] = 0.3644
        pgm_function7[(41, 19, 14)] = 0.2222
        pgm_function7[(41, 19, 15)] = 0.0678
        pgm_function7[(41, 19, 16)] = 0.0044
        pgm_function7[(42, 9, 30)] = 0.01109891
        pgm_function7[(42, 9, 31)] = 0.1277871
        pgm_function7[(42, 10, 28)] = 0.006700678
        pgm_function7[(42, 10, 29)] = 0.1056
        pgm_function7[(42, 10, 30)] = 0.3067
        pgm_function7[(42, 10, 31)] = 0.3633
        pgm_function7[(42, 11, 26)] = 0.004400442
        pgm_function7[(42, 11, 27)] = 0.0856
        pgm_function7[(42, 11, 28)] = 0.2833
        pgm_function7[(42, 11, 29)] = 0.367763195
        pgm_function7[(42, 11, 30)] = 0.248875184
        pgm_function7[(42, 11, 31)] = 0.085591389
        pgm_function7[(42, 12, 24)] = 0.001100111
        pgm_function7[(42, 12, 25)] = 0.070007054
        pgm_function7[(42, 12, 26)] = 0.255574317
        pgm_function7[(42, 12, 27)] = 0.375562402
        pgm_function7[(42, 12, 28)] = 0.27
        pgm_function7[(42, 12, 29)] = 0.0989
        pgm_function7[(42, 12, 30)] = 0.0144
        pgm_function7[(42, 13, 23)] = 0.0544054
        pgm_function7[(42, 13, 24)] = 0.229977062
        pgm_function7[(42, 13, 25)] = 0.3778
        pgm_function7[(42, 13, 26)] = 0.2889
        pgm_function7[(42, 13, 27)] = 0.11331111
        pgm_function7[(42, 13, 28)] = 0.01999802
        pgm_function7[(42, 14, 21)] = 0.038896134
        pgm_function7[(42, 14, 22)] = 0.2111
        pgm_function7[(42, 14, 23)] = 0.36666333
        pgm_function7[(42, 14, 24)] = 0.3089
        pgm_function7[(42, 14, 25)] = 0.1310871
        pgm_function7[(42, 14, 26)] = 0.02779723
        pgm_function7[(42, 15, 19)] = 0.0289
        pgm_function7[(42, 15, 20)] = 0.18671909
        pgm_function7[(42, 15, 21)] = 0.35776418
        pgm_function7[(42, 15, 22)] = 0.32443216
        pgm_function7[(42, 15, 23)] = 0.15441519
        pgm_function7[(42, 15, 24)] = 0.0333
        pgm_function7[(42, 16, 17)] = 0.02220221
        pgm_function7[(42, 16, 18)] = 0.15778406
        pgm_function7[(42, 16, 19)] = 0.3478
        pgm_function7[(42, 16, 20)] = 0.337766159
        pgm_function7[(42, 16, 21)] = 0.174383028
        pgm_function7[(42, 16, 22)] = 0.0433
        pgm_function7[(42, 16, 23)] = 0.0011
        pgm_function7[(42, 17, 15)] = 0.0122
        pgm_function7[(42, 17, 16)] = 0.13441307
        pgm_function7[(42, 17, 17)] = 0.331067189
        pgm_function7[(42, 17, 18)] = 0.3511
        pgm_function7[(42, 17, 19)] = 0.1956
        pgm_function7[(42, 17, 20)] = 0.0533
        pgm_function7[(42, 17, 21)] = 0.002200221
        pgm_function7[(42, 18, 13)] = 0.006698656
        pgm_function7[(42, 18, 14)] = 0.1156
        pgm_function7[(42, 18, 15)] = 0.311131174
        pgm_function7[(42, 18, 16)] = 0.367763228
        pgm_function7[(42, 18, 17)] = 0.2156
        pgm_function7[(42, 18, 18)] = 0.06330631
        pgm_function7[(42, 18, 19)] = 0.0044
        pgm_function7[(42, 19, 11)] = 0.004400441
        pgm_function7[(42, 19, 12)] = 0.090009052
        pgm_function7[(42, 19, 13)] = 0.2978
        pgm_function7[(42, 19, 14)] = 0.3722
        pgm_function7[(42, 19, 15)] = 0.2367
        pgm_function7[(42, 19, 16)] = 0.0756
        pgm_function7[(42, 19, 17)] = 0.006699332
        pgm_function7[(43, 9, 31)] = 0.007799226
        pgm_function7[(43, 10, 29)] = 0.0044
        pgm_function7[(43, 10, 30)] = 0.0933
        pgm_function7[(43, 10, 31)] = 0.2856
        pgm_function7[(43, 11, 27)] = 0.0022
        pgm_function7[(43, 11, 28)] = 0.0756
        pgm_function7[(43, 11, 29)] = 0.265573141
        pgm_function7[(43, 11, 30)] = 0.368863273
        pgm_function7[(43, 11, 31)] = 0.259973966
        pgm_function7[(43, 12, 25)] = 0.001100111
        pgm_function7[(43, 12, 26)] = 0.059994074
        pgm_function7[(43, 12, 27)] = 0.237776254
        pgm_function7[(43, 12, 28)] = 0.3689
        pgm_function7[(43, 12, 29)] = 0.2867
        pgm_function7[(43, 12, 30)] = 0.11
        pgm_function7[(43, 12, 31)] = 0.0189
        pgm_function7[(43, 13, 24)] = 0.045595412
        pgm_function7[(43, 13, 25)] = 0.2111
        pgm_function7[(43, 13, 26)] = 0.3722
        pgm_function7[(43, 13, 27)] = 0.3022303
        pgm_function7[(43, 13, 28)] = 0.12668711
        pgm_function7[(43, 13, 29)] = 0.0256
        pgm_function7[(43, 14, 22)] = 0.0322
        pgm_function7[(43, 14, 23)] = 0.19218117
        pgm_function7[(43, 14, 24)] = 0.3622
        pgm_function7[(43, 14, 25)] = 0.31666825
        pgm_function7[(43, 14, 26)] = 0.14668513
        pgm_function7[(43, 14, 27)] = 0.0322
        pgm_function7[(43, 15, 20)] = 0.02220221
        pgm_function7[(43, 15, 21)] = 0.16778308
        pgm_function7[(43, 15, 22)] = 0.34893517
        pgm_function7[(43, 15, 23)] = 0.3333334
        pgm_function7[(43, 15, 24)] = 0.1678
        pgm_function7[(43, 15, 25)] = 0.0411
        pgm_function7[(43, 15, 26)] = 0.0011
        pgm_function7[(43, 16, 18)] = 0.01559841
        pgm_function7[(43, 16, 19)] = 0.1422
        pgm_function7[(43, 16, 20)] = 0.337766159
        pgm_function7[(43, 16, 21)] = 0.346665055
        pgm_function7[(43, 16, 22)] = 0.1867
        pgm_function7[(43, 16, 23)] = 0.05
        pgm_function7[(43, 16, 24)] = 0.002199781
        pgm_function7[(43, 17, 16)] = 0.01110111
        pgm_function7[(43, 17, 17)] = 0.119988068
        pgm_function7[(43, 17, 18)] = 0.32
        pgm_function7[(43, 17, 19)] = 0.3578
        pgm_function7[(43, 17, 20)] = 0.2089
        pgm_function7[(43, 17, 21)] = 0.061106141
        pgm_function7[(43, 17, 22)] = 0.0044
        pgm_function7[(43, 18, 14)] = 0.0044
        pgm_function7[(43, 18, 15)] = 0.100010056
        pgm_function7[(43, 18, 16)] = 0.295570183
        pgm_function7[(43, 18, 17)] = 0.3689
        pgm_function7[(43, 18, 18)] = 0.23112302
        pgm_function7[(43, 18, 19)] = 0.0733
        pgm_function7[(43, 18, 20)] = 0.006699333
        pgm_function7[(43, 19, 12)] = 0.002200221
        pgm_function7[(43, 19, 13)] = 0.08
        pgm_function7[(43, 19, 14)] = 0.2756
        pgm_function7[(43, 19, 15)] = 0.3789
        pgm_function7[(43, 19, 16)] = 0.2533
        pgm_function7[(43, 19, 17)] = 0.085591423
        pgm_function7[(43, 19, 18)] = 0.01000101
        pgm_function7[(44, 10, 30)] = 0.0022
        pgm_function7[(44, 10, 31)] = 0.0811
        pgm_function7[(44, 11, 28)] = 0.0011
        pgm_function7[(44, 11, 29)] = 0.065593435
        pgm_function7[(44, 11, 30)] = 0.245575182
        pgm_function7[(44, 11, 31)] = 0.374362951
        pgm_function7[(44, 12, 27)] = 0.049995053
        pgm_function7[(44, 12, 28)] = 0.2244
        pgm_function7[(44, 12, 29)] = 0.3622
        pgm_function7[(44, 12, 30)] = 0.2978
        pgm_function7[(44, 12, 31)] = 0.1244
        pgm_function7[(44, 13, 25)] = 0.0378
        pgm_function7[(44, 13, 26)] = 0.1978
        pgm_function7[(44, 13, 27)] = 0.36003636
        pgm_function7[(44, 13, 28)] = 0.31666829
        pgm_function7[(44, 13, 29)] = 0.1422
        pgm_function7[(44, 13, 30)] = 0.03
        pgm_function7[(44, 14, 23)] = 0.02559742
        pgm_function7[(44, 14, 24)] = 0.1722
        pgm_function7[(44, 14, 25)] = 0.35886429
        pgm_function7[(44, 14, 26)] = 0.32556729
        pgm_function7[(44, 14, 27)] = 0.16
        pgm_function7[(44, 14, 28)] = 0.04
        pgm_function7[(44, 15, 21)] = 0.01669831
        pgm_function7[(44, 15, 22)] = 0.15221508
        pgm_function7[(44, 15, 23)] = 0.34223441
        pgm_function7[(44, 15, 24)] = 0.3411
        pgm_function7[(44, 15, 25)] = 0.1822
        pgm_function7[(44, 15, 26)] = 0.0478
        pgm_function7[(44, 15, 27)] = 0.0011
        pgm_function7[(44, 16, 19)] = 0.0111
        pgm_function7[(44, 16, 20)] = 0.128887061
        pgm_function7[(44, 16, 21)] = 0.322168052
        pgm_function7[(44, 16, 22)] = 0.36
        pgm_function7[(44, 16, 23)] = 0.2011
        pgm_function7[(44, 16, 24)] = 0.056694336
        pgm_function7[(44, 16, 25)] = 0.0044
        pgm_function7[(44, 17, 17)] = 0.006699334
        pgm_function7[(44, 17, 18)] = 0.1067
        pgm_function7[(44, 17, 19)] = 0.3056
        pgm_function7[(44, 17, 20)] = 0.3656
        pgm_function7[(44, 17, 21)] = 0.22442215
        pgm_function7[(44, 17, 22)] = 0.0689
        pgm_function7[(44, 17, 23)] = 0.006699333
        pgm_function7[(44, 18, 15)] = 0.004400442
        pgm_function7[(44, 18, 16)] = 0.087791254
        pgm_function7[(44, 18, 17)] = 0.2833
        pgm_function7[(44, 18, 18)] = 0.36893703
        pgm_function7[(44, 18, 19)] = 0.2478
        pgm_function7[(44, 18, 20)] = 0.082191839
        pgm_function7[(44, 18, 21)] = 0.01
        pgm_function7[(44, 19, 13)] = 0.0011
        pgm_function7[(44, 19, 14)] = 0.0689
        pgm_function7[(44, 19, 15)] = 0.2544
        pgm_function7[(44, 19, 16)] = 0.3778
        pgm_function7[(44, 19, 17)] = 0.268873073
        pgm_function7[(44, 19, 18)] = 0.09780989
        pgm_function7[(44, 19, 19)] = 0.01330131
        pgm_function7[(45, 10, 31)] = 0.0022
        pgm_function7[(45, 11, 30)] = 0.055594441
        pgm_function7[(45, 11, 31)] = 0.22777697
        pgm_function7[(45, 12, 28)] = 0.0422
        pgm_function7[(45, 12, 29)] = 0.2067
        pgm_function7[(45, 12, 30)] = 0.3633
        pgm_function7[(45, 12, 31)] = 0.3056
        pgm_function7[(45, 13, 26)] = 0.0289
        pgm_function7[(45, 13, 27)] = 0.18441818
        pgm_function7[(45, 13, 28)] = 0.35216532
        pgm_function7[(45, 13, 29)] = 0.3233
        pgm_function7[(45, 13, 30)] = 0.1567
        pgm_function7[(45, 13, 31)] = 0.037796218
        pgm_function7[(45, 14, 24)] = 0.0211
        pgm_function7[(45, 14, 25)] = 0.15558412
        pgm_function7[(45, 14, 26)] = 0.34556531
        pgm_function7[(45, 14, 27)] = 0.34
        pgm_function7[(45, 14, 28)] = 0.1756
        pgm_function7[(45, 14, 29)] = 0.0467
        pgm_function7[(45, 14, 30)] = 0.0011
        pgm_function7[(45, 15, 22)] = 0.01330131
        pgm_function7[(45, 15, 23)] = 0.13221316
        pgm_function7[(45, 15, 24)] = 0.3322
        pgm_function7[(45, 15, 25)] = 0.3489
        pgm_function7[(45, 15, 26)] = 0.1967
        pgm_function7[(45, 15, 27)] = 0.0578
        pgm_function7[(45, 15, 28)] = 0.0022
        pgm_function7[(45, 16, 20)] = 0.006699333
        pgm_function7[(45, 16, 21)] = 0.115588018
        pgm_function7[(45, 16, 22)] = 0.3078
        pgm_function7[(45, 16, 23)] = 0.3633
        pgm_function7[(45, 16, 24)] = 0.219978139
        pgm_function7[(45, 16, 25)] = 0.0656
        pgm_function7[(45, 16, 26)] = 0.0067
        pgm_function7[(45, 17, 18)] = 0.0044
        pgm_function7[(45, 17, 19)] = 0.0944
        pgm_function7[(45, 17, 20)] = 0.2867
        pgm_function7[(45, 17, 21)] = 0.372237249
        pgm_function7[(45, 17, 22)] = 0.2378
        pgm_function7[(45, 17, 23)] = 0.077792237
        pgm_function7[(45, 17, 24)] = 0.01
        pgm_function7[(45, 18, 16)] = 0.002199781
        pgm_function7[(45, 18, 17)] = 0.0744
        pgm_function7[(45, 18, 18)] = 0.27002702
        pgm_function7[(45, 18, 19)] = 0.3711
        pgm_function7[(45, 18, 20)] = 0.259974122
        pgm_function7[(45, 18, 21)] = 0.0944
        pgm_function7[(45, 18, 22)] = 0.0133
        pgm_function7[(45, 19, 14)] = 0.0011
        pgm_function7[(45, 19, 15)] = 0.06
        pgm_function7[(45, 19, 16)] = 0.24
        pgm_function7[(45, 19, 17)] = 0.3688631
        pgm_function7[(45, 19, 18)] = 0.28442826
        pgm_function7[(45, 19, 19)] = 0.11001111
        pgm_function7[(45, 19, 20)] = 0.0178
        pgm_function7[(46, 11, 31)] = 0.045595394
        pgm_function7[(46, 12, 29)] = 0.0344
        pgm_function7[(46, 12, 30)] = 0.1878
        pgm_function7[(46, 12, 31)] = 0.3578
        pgm_function7[(46, 13, 27)] = 0.02330232
        pgm_function7[(46, 13, 28)] = 0.16558315
        pgm_function7[(46, 13, 29)] = 0.3467
        pgm_function7[(46, 13, 30)] = 0.3333
        pgm_function7[(46, 13, 31)] = 0.17108308
        pgm_function7[(46, 14, 25)] = 0.01559841
        pgm_function7[(46, 14, 26)] = 0.14328613
        pgm_function7[(46, 14, 27)] = 0.3311
        pgm_function7[(46, 14, 28)] = 0.3444
        pgm_function7[(46, 14, 29)] = 0.1889
        pgm_function7[(46, 14, 30)] = 0.0567
        pgm_function7[(46, 14, 31)] = 0.0022
        pgm_function7[(46, 15, 23)] = 0.01000101
        pgm_function7[(46, 15, 24)] = 0.1189
        pgm_function7[(46, 15, 25)] = 0.3167
        pgm_function7[(46, 15, 26)] = 0.3556
        pgm_function7[(46, 15, 27)] = 0.2111
        pgm_function7[(46, 15, 28)] = 0.0667
        pgm_function7[(46, 15, 29)] = 0.0044
        pgm_function7[(46, 16, 21)] = 0.005599441
        pgm_function7[(46, 16, 22)] = 0.0978
        pgm_function7[(46, 16, 23)] = 0.2967
        pgm_function7[(46, 16, 24)] = 0.36556323
        pgm_function7[(46, 16, 25)] = 0.2333
        pgm_function7[(46, 16, 26)] = 0.0744
        pgm_function7[(46, 16, 27)] = 0.0089
        pgm_function7[(46, 17, 19)] = 0.0022
        pgm_function7[(46, 17, 20)] = 0.0833
        pgm_function7[(46, 17, 21)] = 0.270027181
        pgm_function7[(46, 17, 22)] = 0.3767
        pgm_function7[(46, 17, 23)] = 0.253275119
        pgm_function7[(46, 17, 24)] = 0.0867
        pgm_function7[(46, 17, 25)] = 0.0133
        pgm_function7[(46, 18, 17)] = 0.0011
        pgm_function7[(46, 18, 18)] = 0.06440641
        pgm_function7[(46, 18, 19)] = 0.2478
        pgm_function7[(46, 18, 20)] = 0.375562177
        pgm_function7[(46, 18, 21)] = 0.2711
        pgm_function7[(46, 18, 22)] = 0.1033
        pgm_function7[(46, 18, 23)] = 0.01780182
        pgm_function7[(46, 19, 16)] = 0.0489
        pgm_function7[(46, 19, 17)] = 0.229977062
        pgm_function7[(46, 19, 18)] = 0.36443633
        pgm_function7[(46, 19, 19)] = 0.29442929
        pgm_function7[(46, 19, 20)] = 0.1222
        pgm_function7[(46, 19, 21)] = 0.02219782
        pgm_function7[(47, 12, 30)] = 0.0267
        pgm_function7[(47, 12, 31)] = 0.1733
        pgm_function7[(47, 13, 28)] = 0.01889812
        pgm_function7[(47, 13, 29)] = 0.1478
        pgm_function7[(47, 13, 30)] = 0.3378
        pgm_function7[(47, 13, 31)] = 0.337766159
        pgm_function7[(47, 14, 26)] = 0.01109891
        pgm_function7[(47, 14, 27)] = 0.1278
        pgm_function7[(47, 14, 28)] = 0.3222
        pgm_function7[(47, 14, 29)] = 0.3544
        pgm_function7[(47, 14, 30)] = 0.2022
        pgm_function7[(47, 14, 31)] = 0.0622
        pgm_function7[(47, 15, 24)] = 0.0067
        pgm_function7[(47, 15, 25)] = 0.1067
        pgm_function7[(47, 15, 26)] = 0.3011
        pgm_function7[(47, 15, 27)] = 0.3622
        pgm_function7[(47, 15, 28)] = 0.2211
        pgm_function7[(47, 15, 29)] = 0.0767
        pgm_function7[(47, 15, 30)] = 0.006699338
        pgm_function7[(47, 16, 22)] = 0.0044
        pgm_function7[(47, 16, 23)] = 0.0856
        pgm_function7[(47, 16, 24)] = 0.278872176
        pgm_function7[(47, 16, 25)] = 0.3667
        pgm_function7[(47, 16, 26)] = 0.25
        pgm_function7[(47, 16, 27)] = 0.0844
        pgm_function7[(47, 16, 28)] = 0.0111
        pgm_function7[(47, 17, 20)] = 0.0011
        pgm_function7[(47, 17, 21)] = 0.068906946
        pgm_function7[(47, 17, 22)] = 0.2522
        pgm_function7[(47, 17, 23)] = 0.375562177
        pgm_function7[(47, 17, 24)] = 0.2711
        pgm_function7[(47, 17, 25)] = 0.0967
        pgm_function7[(47, 17, 26)] = 0.01669831
        pgm_function7[(47, 18, 19)] = 0.0556
        pgm_function7[(47, 18, 20)] = 0.229977108
        pgm_function7[(47, 18, 21)] = 0.3756
        pgm_function7[(47, 18, 22)] = 0.2878
        pgm_function7[(47, 18, 23)] = 0.1144111
        pgm_function7[(47, 18, 24)] = 0.02220222
        pgm_function7[(47, 19, 17)] = 0.039996011
        pgm_function7[(47, 19, 18)] = 0.21002119
        pgm_function7[(47, 19, 19)] = 0.36443636
        pgm_function7[(47, 19, 20)] = 0.3078
        pgm_function7[(47, 19, 21)] = 0.13438711
        pgm_function7[(47, 19, 22)] = 0.02780283
        pgm_function7[(48, 12, 31)] = 0.02
        pgm_function7[(48, 13, 29)] = 0.0144
        pgm_function7[(48, 13, 30)] = 0.1322
        pgm_function7[(48, 13, 31)] = 0.327767154
        pgm_function7[(48, 14, 27)] = 0.0089
        pgm_function7[(48, 14, 28)] = 0.1111
        pgm_function7[(48, 14, 29)] = 0.3089
        pgm_function7[(48, 14, 30)] = 0.3578
        pgm_function7[(48, 14, 31)] = 0.2211
        pgm_function7[(48, 15, 25)] = 0.0044
        pgm_function7[(48, 15, 26)] = 0.0944
        pgm_function7[(48, 15, 27)] = 0.2856
        pgm_function7[(48, 15, 28)] = 0.37
        pgm_function7[(48, 15, 29)] = 0.2378
        pgm_function7[(48, 15, 30)] = 0.083291797
        pgm_function7[(48, 15, 31)] = 0.01
        pgm_function7[(48, 16, 23)] = 0.0022
        pgm_function7[(48, 16, 24)] = 0.075592448
        pgm_function7[(48, 16, 25)] = 0.2633
        pgm_function7[(48, 16, 26)] = 0.3711
        pgm_function7[(48, 16, 27)] = 0.26
        pgm_function7[(48, 16, 28)] = 0.0978
        pgm_function7[(48, 16, 29)] = 0.0144
        pgm_function7[(48, 17, 21)] = 0.001100111
        pgm_function7[(48, 17, 22)] = 0.06
        pgm_function7[(48, 17, 23)] = 0.236676111
        pgm_function7[(48, 17, 24)] = 0.3689
        pgm_function7[(48, 17, 25)] = 0.2867
        pgm_function7[(48, 17, 26)] = 0.10998904
        pgm_function7[(48, 17, 27)] = 0.02000202
        pgm_function7[(48, 18, 20)] = 0.045595421
        pgm_function7[(48, 18, 21)] = 0.2111
        pgm_function7[(48, 18, 22)] = 0.3689
        pgm_function7[(48, 18, 23)] = 0.30443027
        pgm_function7[(48, 18, 24)] = 0.12781312
        pgm_function7[(48, 18, 25)] = 0.0278
        pgm_function7[(48, 19, 18)] = 0.03330333
        pgm_function7[(48, 19, 19)] = 0.19111919
        pgm_function7[(48, 19, 20)] = 0.36
        pgm_function7[(48, 19, 21)] = 0.31666825
        pgm_function7[(48, 19, 22)] = 0.15111517
        pgm_function7[(48, 19, 23)] = 0.0333
        pgm_function7[(49, 13, 30)] = 0.01
        pgm_function7[(49, 13, 31)] = 0.118888056
        pgm_function7[(49, 14, 28)] = 0.0067
        pgm_function7[(49, 14, 29)] = 0.0967
        pgm_function7[(49, 14, 30)] = 0.2956
        pgm_function7[(49, 14, 31)] = 0.36
        pgm_function7[(49, 15, 26)] = 0.0033
        pgm_function7[(49, 15, 27)] = 0.08
        pgm_function7[(49, 15, 28)] = 0.27
        pgm_function7[(49, 15, 29)] = 0.3678
        pgm_function7[(49, 15, 30)] = 0.255574299
        pgm_function7[(49, 15, 31)] = 0.0956
        pgm_function7[(49, 16, 24)] = 0.001099891
        pgm_function7[(49, 16, 25)] = 0.0667
        pgm_function7[(49, 16, 26)] = 0.2411
        pgm_function7[(49, 16, 27)] = 0.3733
        pgm_function7[(49, 16, 28)] = 0.2733
        pgm_function7[(49, 16, 29)] = 0.1089
        pgm_function7[(49, 16, 30)] = 0.01890191
        pgm_function7[(49, 17, 23)] = 0.049995023
        pgm_function7[(49, 17, 24)] = 0.2211
        pgm_function7[(49, 17, 25)] = 0.3656
        pgm_function7[(49, 17, 26)] = 0.29557012
        pgm_function7[(49, 17, 27)] = 0.12441212
        pgm_function7[(49, 17, 28)] = 0.02559741
        pgm_function7[(49, 18, 21)] = 0.0378
        pgm_function7[(49, 18, 22)] = 0.1978
        pgm_function7[(49, 18, 23)] = 0.35783632
        pgm_function7[(49, 18, 24)] = 0.31443128
        pgm_function7[(49, 18, 25)] = 0.1411
        pgm_function7[(49, 18, 26)] = 0.0322
        pgm_function7[(49, 19, 19)] = 0.02670273
        pgm_function7[(49, 19, 20)] = 0.1711
        pgm_function7[(49, 19, 21)] = 0.35556428
        pgm_function7[(49, 19, 22)] = 0.32443236
        pgm_function7[(49, 19, 23)] = 0.1633
        pgm_function7[(49, 19, 24)] = 0.041095932
        pgm_function7[(49, 19, 25)] = 0.0011
        pgm_function7[(50, 13, 31)] = 0.006699333
        pgm_function7[(50, 14, 29)] = 0.0044
        pgm_function7[(50, 14, 30)] = 0.0844
        pgm_function7[(50, 14, 31)] = 0.2756
        pgm_function7[(50, 15, 27)] = 0.0022
        pgm_function7[(50, 15, 28)] = 0.0689
        pgm_function7[(50, 15, 29)] = 0.2544
        pgm_function7[(50, 15, 30)] = 0.366663429
        pgm_function7[(50, 15, 31)] = 0.27
        pgm_function7[(50, 16, 26)] = 0.0567
        pgm_function7[(50, 16, 27)] = 0.2278
        pgm_function7[(50, 16, 28)] = 0.3667
        pgm_function7[(50, 16, 29)] = 0.2889
        pgm_function7[(50, 16, 30)] = 0.12111208
        pgm_function7[(50, 16, 31)] = 0.02330232
        pgm_function7[(50, 17, 24)] = 0.0422
        pgm_function7[(50, 17, 25)] = 0.2033
        pgm_function7[(50, 17, 26)] = 0.36326415
        pgm_function7[(50, 17, 27)] = 0.3044303
        pgm_function7[(50, 17, 28)] = 0.13888603
        pgm_function7[(50, 17, 29)] = 0.03
        pgm_function7[(50, 18, 22)] = 0.0289
        pgm_function7[(50, 18, 23)] = 0.18221816
        pgm_function7[(50, 18, 24)] = 0.35223532
        pgm_function7[(50, 18, 25)] = 0.3222
        pgm_function7[(50, 18, 26)] = 0.1556
        pgm_function7[(50, 18, 27)] = 0.04
        pgm_function7[(50, 19, 20)] = 0.0211
        pgm_function7[(50, 19, 21)] = 0.15558412
        pgm_function7[(50, 19, 22)] = 0.34333438
        pgm_function7[(50, 19, 23)] = 0.3378
        pgm_function7[(50, 19, 24)] = 0.175582135
        pgm_function7[(50, 19, 25)] = 0.0478
        pgm_function7[(50, 19, 26)] = 0.0011
        pgm_function7[(51, 14, 30)] = 0.0022
        pgm_function7[(51, 14, 31)] = 0.0778
        pgm_function7[(51, 15, 28)] = 0.0011
        pgm_function7[(51, 15, 29)] = 0.0589
        pgm_function7[(51, 15, 30)] = 0.235576276
        pgm_function7[(51, 15, 31)] = 0.3633
        pgm_function7[(51, 16, 27)] = 0.0456
        pgm_function7[(51, 16, 28)] = 0.2144
        pgm_function7[(51, 16, 29)] = 0.36
        pgm_function7[(51, 16, 30)] = 0.30333021
        pgm_function7[(51, 16, 31)] = 0.13441309
        pgm_function7[(51, 17, 25)] = 0.0344
        pgm_function7[(51, 17, 26)] = 0.18778108
        pgm_function7[(51, 17, 27)] = 0.35783636
        pgm_function7[(51, 17, 28)] = 0.31436906
        pgm_function7[(51, 17, 29)] = 0.1544
        pgm_function7[(51, 17, 30)] = 0.036696326
        pgm_function7[(51, 18, 23)] = 0.02330232
        pgm_function7[(51, 18, 24)] = 0.16441615
        pgm_function7[(51, 18, 25)] = 0.3478
        pgm_function7[(51, 18, 26)] = 0.33
        pgm_function7[(51, 18, 27)] = 0.1722
        pgm_function7[(51, 18, 28)] = 0.045595407
        pgm_function7[(51, 18, 29)] = 0.00110022
        pgm_function7[(51, 19, 21)] = 0.01559841
        pgm_function7[(51, 19, 22)] = 0.14221416
        pgm_function7[(51, 19, 23)] = 0.3289
        pgm_function7[(51, 19, 24)] = 0.346665267
        pgm_function7[(51, 19, 25)] = 0.19
        pgm_function7[(51, 19, 26)] = 0.0578
        pgm_function7[(51, 19, 27)] = 0.0022
        pgm_function7[(52, 14, 31)] = 0.0011
        pgm_function7[(52, 15, 30)] = 0.052194861
        pgm_function7[(52, 15, 31)] = 0.2178
        pgm_function7[(52, 16, 28)] = 0.0367
        pgm_function7[(52, 16, 29)] = 0.1989
        pgm_function7[(52, 16, 30)] = 0.35113525
        pgm_function7[(52, 16, 31)] = 0.31443122
        pgm_function7[(52, 17, 26)] = 0.02669731
        pgm_function7[(52, 17, 27)] = 0.17331717
        pgm_function7[(52, 17, 28)] = 0.34666507
        pgm_function7[(52, 17, 29)] = 0.3256
        pgm_function7[(52, 17, 30)] = 0.167783117
        pgm_function7[(52, 17, 31)] = 0.0444
        pgm_function7[(52, 18, 24)] = 0.01890192
        pgm_function7[(52, 18, 25)] = 0.1467
        pgm_function7[(52, 18, 26)] = 0.34
        pgm_function7[(52, 18, 27)] = 0.3344
        pgm_function7[(52, 18, 28)] = 0.18778103
        pgm_function7[(52, 18, 29)] = 0.054410878
        pgm_function7[(52, 18, 30)] = 0.002200221
        pgm_function7[(52, 19, 22)] = 0.01110111
        pgm_function7[(52, 19, 23)] = 0.1278
        pgm_function7[(52, 19, 24)] = 0.318868246
        pgm_function7[(52, 19, 25)] = 0.3511
        pgm_function7[(52, 19, 26)] = 0.2033
        pgm_function7[(52, 19, 27)] = 0.0656
        pgm_function7[(52, 19, 28)] = 0.0044
        pgm_function7[(53, 15, 31)] = 0.0433
        pgm_function7[(53, 16, 29)] = 0.0289
        pgm_function7[(53, 16, 30)] = 0.18111813
        pgm_function7[(53, 16, 31)] = 0.34563524
        pgm_function7[(53, 17, 27)] = 0.02000202
        pgm_function7[(53, 17, 28)] = 0.15888403
        pgm_function7[(53, 17, 29)] = 0.3356
        pgm_function7[(53, 17, 30)] = 0.335566235
        pgm_function7[(53, 17, 31)] = 0.1789
        pgm_function7[(53, 18, 25)] = 0.0144
        pgm_function7[(53, 18, 26)] = 0.1322
        pgm_function7[(53, 18, 27)] = 0.3267
        pgm_function7[(53, 18, 28)] = 0.344366055
        pgm_function7[(53, 18, 29)] = 0.20003992
        pgm_function7[(53, 18, 30)] = 0.062206222
        pgm_function7[(53, 18, 31)] = 0.0044
        pgm_function7[(53, 19, 23)] = 0.0089
        pgm_function7[(53, 19, 24)] = 0.111089086
        pgm_function7[(53, 19, 25)] = 0.3089
        pgm_function7[(53, 19, 26)] = 0.3556
        pgm_function7[(53, 19, 27)] = 0.2189
        pgm_function7[(53, 19, 28)] = 0.0733
        pgm_function7[(53, 19, 29)] = 0.006699334
        pgm_function7[(54, 16, 30)] = 0.02440242
        pgm_function7[(54, 16, 31)] = 0.16221611
        pgm_function7[(54, 17, 28)] = 0.0155984
        pgm_function7[(54, 17, 29)] = 0.1411
        pgm_function7[(54, 17, 30)] = 0.325567228
        pgm_function7[(54, 17, 31)] = 0.3444
        pgm_function7[(54, 18, 26)] = 0.01
        pgm_function7[(54, 18, 27)] = 0.12
        pgm_function7[(54, 18, 28)] = 0.308869049
        pgm_function7[(54, 18, 29)] = 0.354470858
        pgm_function7[(54, 18, 30)] = 0.212221076
        pgm_function7[(54, 18, 31)] = 0.0711
        pgm_function7[(54, 19, 24)] = 0.006699335
        pgm_function7[(54, 19, 25)] = 0.0967
        pgm_function7[(54, 19, 26)] = 0.2933
        pgm_function7[(54, 19, 27)] = 0.3611
        pgm_function7[(54, 19, 28)] = 0.2356
        pgm_function7[(54, 19, 29)] = 0.082191847
        pgm_function7[(54, 19, 30)] = 0.01
        pgm_function7[(55, 16, 31)] = 0.02000201
        pgm_function7[(55, 17, 29)] = 0.0133
        pgm_function7[(55, 17, 30)] = 0.124388087
        pgm_function7[(55, 17, 31)] = 0.3156
        pgm_function7[(55, 18, 27)] = 0.0067
        pgm_function7[(55, 18, 28)] = 0.107789017
        pgm_function7[(55, 18, 29)] = 0.293358883
        pgm_function7[(55, 18, 30)] = 0.36003613
        pgm_function7[(55, 18, 31)] = 0.2278
        pgm_function7[(55, 19, 25)] = 0.0044
        pgm_function7[(55, 19, 26)] = 0.0867
        pgm_function7[(55, 19, 27)] = 0.2722
        pgm_function7[(55, 19, 28)] = 0.3656
        pgm_function7[(55, 19, 29)] = 0.249975142
        pgm_function7[(55, 19, 30)] = 0.0933
        pgm_function7[(55, 19, 31)] = 0.0133
        pgm_function7[(56, 17, 30)] = 0.009999007
        pgm_function7[(56, 17, 31)] = 0.11
        pgm_function7[(56, 18, 28)] = 0.005599441
        pgm_function7[(56, 18, 29)] = 0.092218363
        pgm_function7[(56, 18, 30)] = 0.281128101
        pgm_function7[(56, 18, 31)] = 0.3589
        pgm_function7[(56, 19, 26)] = 0.0022
        pgm_function7[(56, 19, 27)] = 0.0789
        pgm_function7[(56, 19, 28)] = 0.2522
        pgm_function7[(56, 19, 29)] = 0.365563208
        pgm_function7[(56, 19, 30)] = 0.2611
        pgm_function7[(56, 19, 31)] = 0.1044
        pgm_function7[(57, 17, 31)] = 0.0067
        pgm_function7[(57, 18, 29)] = 0.004400878
        pgm_function7[(57, 18, 30)] = 0.080008029
        pgm_function7[(57, 18, 31)] = 0.2678
        pgm_function7[(57, 19, 27)] = 0.0011
        pgm_function7[(57, 19, 28)] = 0.0678
        pgm_function7[(57, 19, 29)] = 0.238876136
        pgm_function7[(57, 19, 30)] = 0.3633
        pgm_function7[(57, 19, 31)] = 0.2733
        pgm_function7[(58, 18, 30)] = 0.002200221
        pgm_function7[(58, 18, 31)] = 0.0689
        pgm_function7[(58, 19, 28)] = 0.0011
        pgm_function7[(58, 19, 29)] = 0.056694332
        pgm_function7[(58, 19, 30)] = 0.2267
        pgm_function7[(58, 19, 31)] = 0.3567
        pgm_function7[(59, 18, 31)] = 0.0011
        pgm_function7[(59, 19, 30)] = 0.0456
        pgm_function7[(59, 19, 31)] = 0.2156
        pgm_function7[(60, 19, 31)] = 0.0367

        pgm_function8 = pgm_factor8.set_sparse()
        pgm_function8[(0, 0, 0, 0)] = 0.5999403
        pgm_function8[(0, 0, 0, 1)] = 0.58835829
        pgm_function8[(0, 0, 0, 2)] = 0.5167
        pgm_function8[(0, 0, 0, 3)] = 0.5
        pgm_function8[(0, 0, 1, 0)] = 0.6
        pgm_function8[(0, 0, 1, 1)] = 0.59
        pgm_function8[(0, 0, 1, 2)] = 0.5187
        pgm_function8[(0, 0, 1, 3)] = 0.5
        pgm_function8[(0, 0, 2, 0)] = 0.6
        pgm_function8[(0, 0, 2, 1)] = 0.59
        pgm_function8[(0, 0, 2, 2)] = 0.5223
        pgm_function8[(0, 0, 2, 3)] = 0.4999501
        pgm_function8[(0, 0, 3, 0)] = 0.6
        pgm_function8[(0, 0, 3, 1)] = 0.59
        pgm_function8[(0, 0, 3, 2)] = 0.52324748
        pgm_function8[(0, 0, 3, 3)] = 0.5
        pgm_function8[(1, 0, 0, 0)] = 0.17668209
        pgm_function8[(1, 0, 0, 1)] = 0.10931087
        pgm_function8[(1, 0, 0, 2)] = 0.1247
        pgm_function8[(1, 0, 0, 3)] = 0.1
        pgm_function8[(1, 0, 1, 0)] = 0.1843
        pgm_function8[(1, 0, 1, 1)] = 0.1133
        pgm_function8[(1, 0, 1, 2)] = 0.1303
        pgm_function8[(1, 0, 1, 3)] = 0.1007
        pgm_function8[(1, 0, 2, 0)] = 0.1897
        pgm_function8[(1, 0, 2, 1)] = 0.1157
        pgm_function8[(1, 0, 2, 2)] = 0.133
        pgm_function8[(1, 0, 2, 3)] = 0.10469
        pgm_function8[(1, 0, 3, 0)] = 0.1997
        pgm_function8[(1, 0, 3, 1)] = 0.1183
        pgm_function8[(1, 0, 3, 2)] = 0.13868586
        pgm_function8[(1, 0, 3, 3)] = 0.109
        pgm_function8[(2, 0, 0, 0)] = 0.1986801
        pgm_function8[(2, 0, 0, 1)] = 0.15531581
        pgm_function8[(2, 0, 0, 2)] = 0.124
        pgm_function8[(2, 0, 0, 3)] = 0.1107
        pgm_function8[(2, 0, 1, 0)] = 0.197
        pgm_function8[(2, 0, 1, 1)] = 0.1653
        pgm_function8[(2, 0, 1, 2)] = 0.13
        pgm_function8[(2, 0, 1, 3)] = 0.1187
        pgm_function8[(2, 0, 2, 0)] = 0.1983
        pgm_function8[(2, 0, 2, 1)] = 0.1767
        pgm_function8[(2, 0, 2, 2)] = 0.1387
        pgm_function8[(2, 0, 2, 3)] = 0.126687
        pgm_function8[(2, 0, 3, 0)] = 0.1923
        pgm_function8[(2, 0, 3, 1)] = 0.192
        pgm_function8[(2, 0, 3, 2)] = 0.14468586
        pgm_function8[(2, 0, 3, 3)] = 0.1353
        pgm_function8[(2, 1, 0, 0)] = 0.044
        pgm_function8[(2, 1, 1, 0)] = 0.062
        pgm_function8[(2, 1, 2, 0)] = 0.079691982
        pgm_function8[(2, 1, 3, 0)] = 0.10099
        pgm_function8[(3, 0, 0, 0)] = 0.02469751
        pgm_function8[(3, 0, 0, 1)] = 0.13531384
        pgm_function8[(3, 0, 0, 2)] = 0.1443
        pgm_function8[(3, 0, 0, 3)] = 0.12
        pgm_function8[(3, 0, 1, 0)] = 0.0187
        pgm_function8[(3, 0, 1, 1)] = 0.1257
        pgm_function8[(3, 0, 1, 2)] = 0.1547
        pgm_function8[(3, 0, 1, 3)] = 0.1283
        pgm_function8[(3, 0, 2, 0)] = 0.012
        pgm_function8[(3, 0, 2, 1)] = 0.1173
        pgm_function8[(3, 0, 2, 2)] = 0.1593
        pgm_function8[(3, 0, 2, 3)] = 0.138286
        pgm_function8[(3, 0, 3, 0)] = 0.008
        pgm_function8[(3, 0, 3, 1)] = 0.0997
        pgm_function8[(3, 0, 3, 2)] = 0.16368384
        pgm_function8[(3, 0, 3, 3)] = 0.1557
        pgm_function8[(3, 1, 0, 0)] = 0.288
        pgm_function8[(3, 1, 0, 1)] = 0.058
        pgm_function8[(3, 1, 1, 0)] = 0.323
        pgm_function8[(3, 1, 1, 1)] = 0.08999106
        pgm_function8[(3, 1, 1, 2)] = 0.004
        pgm_function8[(3, 1, 2, 0)] = 0.365662916
        pgm_function8[(3, 1, 2, 1)] = 0.123
        pgm_function8[(3, 1, 2, 2)] = 0.0133
        pgm_function8[(3, 1, 3, 0)] = 0.40965899
        pgm_function8[(3, 1, 3, 1)] = 0.1653
        pgm_function8[(3, 1, 3, 2)] = 0.028
        pgm_function8[(3, 2, 3, 0)] = 0.001000099
        pgm_function8[(4, 0, 0, 1)] = 0.01170119
        pgm_function8[(4, 0, 0, 2)] = 0.0873
        pgm_function8[(4, 0, 0, 3)] = 0.121
        pgm_function8[(4, 0, 1, 1)] = 0.0057
        pgm_function8[(4, 0, 1, 2)] = 0.0663
        pgm_function8[(4, 0, 1, 3)] = 0.1253
        pgm_function8[(4, 0, 2, 1)] = 0.0003
        pgm_function8[(4, 0, 2, 2)] = 0.0467
        pgm_function8[(4, 0, 2, 3)] = 0.118688
        pgm_function8[(4, 0, 3, 2)] = 0.02969697
        pgm_function8[(4, 0, 3, 3)] = 0.0993
        pgm_function8[(4, 1, 0, 0)] = 0.3743
        pgm_function8[(4, 1, 0, 1)] = 0.2317
        pgm_function8[(4, 1, 0, 2)] = 0.0827
        pgm_function8[(4, 1, 0, 3)] = 0.01030101
        pgm_function8[(4, 1, 1, 0)] = 0.397
        pgm_function8[(4, 1, 1, 1)] = 0.265673178
        pgm_function8[(4, 1, 1, 2)] = 0.1303
        pgm_function8[(4, 1, 1, 3)] = 0.0277
        pgm_function8[(4, 1, 2, 0)] = 0.402259907
        pgm_function8[(4, 1, 2, 1)] = 0.3117
        pgm_function8[(4, 1, 2, 2)] = 0.1737
        pgm_function8[(4, 1, 2, 3)] = 0.06000596
        pgm_function8[(4, 1, 3, 0)] = 0.38996099
        pgm_function8[(4, 1, 3, 1)] = 0.3517
        pgm_function8[(4, 1, 3, 2)] = 0.2263
        pgm_function8[(4, 1, 3, 3)] = 0.1023
        pgm_function8[(4, 2, 0, 0)] = 0.0347
        pgm_function8[(4, 2, 1, 0)] = 0.0743
        pgm_function8[(4, 2, 2, 0)] = 0.13
        pgm_function8[(4, 2, 3, 0)] = 0.205320815
        pgm_function8[(4, 3, 3, 0)] = 0.004999503
        pgm_function8[(5, 0, 0, 2)] = 0.003
        pgm_function8[(5, 0, 0, 3)] = 0.0483
        pgm_function8[(5, 0, 1, 3)] = 0.027
        pgm_function8[(5, 0, 2, 3)] = 0.0116988
        pgm_function8[(5, 0, 3, 3)] = 0.0007
        pgm_function8[(5, 1, 0, 0)] = 0.2397
        pgm_function8[(5, 1, 0, 1)] = 0.296
        pgm_function8[(5, 1, 0, 2)] = 0.2033
        pgm_function8[(5, 1, 0, 3)] = 0.11171115
        pgm_function8[(5, 1, 1, 0)] = 0.195
        pgm_function8[(5, 1, 1, 1)] = 0.335666225
        pgm_function8[(5, 1, 1, 2)] = 0.24
        pgm_function8[(5, 1, 1, 3)] = 0.159
        pgm_function8[(5, 1, 2, 0)] = 0.144685967
        pgm_function8[(5, 1, 2, 1)] = 0.356
        pgm_function8[(5, 1, 2, 2)] = 0.2837
        pgm_function8[(5, 1, 2, 3)] = 0.20632088
        pgm_function8[(5, 1, 3, 0)] = 0.0986901
        pgm_function8[(5, 1, 3, 1)] = 0.352
        pgm_function8[(5, 1, 3, 2)] = 0.322
        pgm_function8[(5, 1, 3, 3)] = 0.253
        pgm_function8[(5, 2, 0, 0)] = 0.3023
        pgm_function8[(5, 2, 0, 1)] = 0.00130013
        pgm_function8[(5, 2, 1, 0)] = 0.3957
        pgm_function8[(5, 2, 1, 1)] = 0.0157
        pgm_function8[(5, 2, 2, 0)] = 0.472
        pgm_function8[(5, 2, 2, 1)] = 0.0487
        pgm_function8[(5, 2, 3, 0)] = 0.516051536
        pgm_function8[(5, 2, 3, 1)] = 0.112310974
        pgm_function8[(5, 3, 0, 0)] = 0.03899609
        pgm_function8[(5, 3, 1, 0)] = 0.09230926
        pgm_function8[(5, 3, 2, 0)] = 0.1613
        pgm_function8[(5, 3, 3, 0)] = 0.245675147
        pgm_function8[(5, 4, 1, 0)] = 0.0093
        pgm_function8[(5, 4, 2, 0)] = 0.04129594
        pgm_function8[(5, 4, 3, 0)] = 0.08
        pgm_function8[(5, 5, 2, 0)] = 0.002
        pgm_function8[(5, 5, 3, 0)] = 0.02669731
        pgm_function8[(5, 6, 3, 0)] = 0.001
        pgm_function8[(6, 1, 0, 0)] = 0.0537
        pgm_function8[(6, 1, 0, 1)] = 0.276
        pgm_function8[(6, 1, 0, 2)] = 0.2493
        pgm_function8[(6, 1, 0, 3)] = 0.18331824
        pgm_function8[(6, 1, 1, 0)] = 0.023
        pgm_function8[(6, 1, 1, 1)] = 0.241976162
        pgm_function8[(6, 1, 1, 2)] = 0.292
        pgm_function8[(6, 1, 1, 3)] = 0.2263
        pgm_function8[(6, 1, 2, 0)] = 0.007699228
        pgm_function8[(6, 1, 2, 1)] = 0.1843
        pgm_function8[(6, 1, 2, 2)] = 0.3133
        pgm_function8[(6, 1, 2, 3)] = 0.26802684
        pgm_function8[(6, 1, 3, 0)] = 0.00069993
        pgm_function8[(6, 1, 3, 1)] = 0.1257
        pgm_function8[(6, 1, 3, 2)] = 0.2987
        pgm_function8[(6, 1, 3, 3)] = 0.306
        pgm_function8[(6, 2, 0, 0)] = 0.42
        pgm_function8[(6, 2, 0, 1)] = 0.105011
        pgm_function8[(6, 2, 1, 0)] = 0.3927
        pgm_function8[(6, 2, 1, 1)] = 0.2127
        pgm_function8[(6, 2, 1, 2)] = 0.0057
        pgm_function8[(6, 2, 2, 0)] = 0.33
        pgm_function8[(6, 2, 2, 1)] = 0.3303
        pgm_function8[(6, 2, 2, 2)] = 0.0367
        pgm_function8[(6, 2, 3, 0)] = 0.249324776
        pgm_function8[(6, 2, 3, 1)] = 0.427742902
        pgm_function8[(6, 2, 3, 2)] = 0.1053
        pgm_function8[(6, 2, 3, 3)] = 0.002
        pgm_function8[(6, 3, 0, 0)] = 0.27497295
        pgm_function8[(6, 3, 1, 0)] = 0.37233722
        pgm_function8[(6, 3, 1, 1)] = 0.00170017
        pgm_function8[(6, 3, 2, 0)] = 0.4457
        pgm_function8[(6, 3, 2, 1)] = 0.0217
        pgm_function8[(6, 3, 3, 0)] = 0.475652285
        pgm_function8[(6, 3, 3, 1)] = 0.071
        pgm_function8[(6, 4, 0, 0)] = 0.12998703
        pgm_function8[(6, 4, 1, 0)] = 0.212
        pgm_function8[(6, 4, 2, 0)] = 0.28567129
        pgm_function8[(6, 4, 3, 0)] = 0.3733
        pgm_function8[(6, 5, 0, 0)] = 0.0653
        pgm_function8[(6, 5, 1, 0)] = 0.122
        pgm_function8[(6, 5, 2, 0)] = 0.2003
        pgm_function8[(6, 5, 3, 0)] = 0.2556741
        pgm_function8[(6, 6, 0, 0)] = 0.041
        pgm_function8[(6, 6, 1, 0)] = 0.0797
        pgm_function8[(6, 6, 2, 0)] = 0.13798607
        pgm_function8[(6, 6, 3, 0)] = 0.206
        pgm_function8[(6, 7, 0, 0)] = 0.02399759
        pgm_function8[(6, 7, 1, 0)] = 0.0603
        pgm_function8[(6, 7, 2, 0)] = 0.0987
        pgm_function8[(6, 7, 3, 0)] = 0.1623
        pgm_function8[(7, 1, 0, 0)] = 0.0003
        pgm_function8[(7, 1, 0, 1)] = 0.121
        pgm_function8[(7, 1, 0, 2)] = 0.2597
        pgm_function8[(7, 1, 0, 3)] = 0.22232229
        pgm_function8[(7, 1, 1, 1)] = 0.064993544
        pgm_function8[(7, 1, 1, 2)] = 0.2327
        pgm_function8[(7, 1, 1, 3)] = 0.2643
        pgm_function8[(7, 1, 2, 1)] = 0.025
        pgm_function8[(7, 1, 2, 2)] = 0.181
        pgm_function8[(7, 1, 2, 3)] = 0.27502783
        pgm_function8[(7, 1, 3, 1)] = 0.0053
        pgm_function8[(7, 1, 3, 2)] = 0.1187
        pgm_function8[(7, 1, 3, 3)] = 0.2387
        pgm_function8[(7, 2, 0, 0)] = 0.2043
        pgm_function8[(7, 2, 0, 1)] = 0.33403301
        pgm_function8[(7, 2, 0, 2)] = 0.043
        pgm_function8[(7, 2, 1, 0)] = 0.129
        pgm_function8[(7, 2, 1, 1)] = 0.408
        pgm_function8[(7, 2, 1, 2)] = 0.1343
        pgm_function8[(7, 2, 1, 3)] = 0.005
        pgm_function8[(7, 2, 2, 0)] = 0.068
        pgm_function8[(7, 2, 2, 1)] = 0.411
        pgm_function8[(7, 2, 2, 2)] = 0.2543
        pgm_function8[(7, 2, 2, 3)] = 0.0447
        pgm_function8[(7, 2, 3, 0)] = 0.028302775
        pgm_function8[(7, 2, 3, 1)] = 0.356335918
        pgm_function8[(7, 2, 3, 2)] = 0.359
        pgm_function8[(7, 2, 3, 3)] = 0.1247
        pgm_function8[(7, 3, 0, 0)] = 0.39865992
        pgm_function8[(7, 3, 0, 1)] = 0.0463
        pgm_function8[(7, 3, 1, 0)] = 0.36973722
        pgm_function8[(7, 3, 1, 1)] = 0.141314
        pgm_function8[(7, 3, 2, 0)] = 0.3133
        pgm_function8[(7, 3, 2, 1)] = 0.2547
        pgm_function8[(7, 3, 2, 2)] = 0.001
        pgm_function8[(7, 3, 3, 0)] = 0.242976146
        pgm_function8[(7, 3, 3, 1)] = 0.3593
        pgm_function8[(7, 3, 3, 2)] = 0.024
        pgm_function8[(7, 4, 0, 0)] = 0.33866607
        pgm_function8[(7, 4, 1, 0)] = 0.4043
        pgm_function8[(7, 4, 1, 1)] = 0.01170122
        pgm_function8[(7, 4, 2, 0)] = 0.41565842
        pgm_function8[(7, 4, 2, 1)] = 0.06669323
        pgm_function8[(7, 4, 3, 0)] = 0.3843
        pgm_function8[(7, 4, 3, 1)] = 0.140014052
        pgm_function8[(7, 5, 0, 0)] = 0.2553
        pgm_function8[(7, 5, 1, 0)] = 0.3437
        pgm_function8[(7, 5, 2, 0)] = 0.4037
        pgm_function8[(7, 5, 2, 1)] = 0.004
        pgm_function8[(7, 5, 3, 0)] = 0.42265817
        pgm_function8[(7, 5, 3, 1)] = 0.04330428
        pgm_function8[(7, 6, 0, 0)] = 0.207
        pgm_function8[(7, 6, 1, 0)] = 0.2883
        pgm_function8[(7, 6, 2, 0)] = 0.35666418
        pgm_function8[(7, 6, 3, 0)] = 0.408
        pgm_function8[(7, 6, 3, 1)] = 0.0033
        pgm_function8[(7, 7, 0, 0)] = 0.18398193
        pgm_function8[(7, 7, 1, 0)] = 0.247
        pgm_function8[(7, 7, 2, 0)] = 0.3263
        pgm_function8[(7, 7, 3, 0)] = 0.372
        pgm_function8[(8, 1, 0, 1)] = 0.0173
        pgm_function8[(8, 1, 0, 2)] = 0.1563
        pgm_function8[(8, 1, 0, 3)] = 0.2343233
        pgm_function8[(8, 1, 1, 1)] = 0.001699831
        pgm_function8[(8, 1, 1, 2)] = 0.093
        pgm_function8[(8, 1, 1, 3)] = 0.21
        pgm_function8[(8, 1, 2, 2)] = 0.035
        pgm_function8[(8, 1, 2, 3)] = 0.15431491
        pgm_function8[(8, 1, 3, 2)] = 0.0063
        pgm_function8[(8, 1, 3, 3)] = 0.0963
        pgm_function8[(8, 2, 0, 0)] = 0.0387
        pgm_function8[(8, 2, 0, 1)] = 0.35133501
        pgm_function8[(8, 2, 0, 2)] = 0.2133
        pgm_function8[(8, 2, 0, 3)] = 0.026
        pgm_function8[(8, 2, 1, 0)] = 0.0083
        pgm_function8[(8, 2, 1, 1)] = 0.2773
        pgm_function8[(8, 2, 1, 2)] = 0.332
        pgm_function8[(8, 2, 1, 3)] = 0.1117
        pgm_function8[(8, 2, 2, 1)] = 0.185
        pgm_function8[(8, 2, 2, 2)] = 0.3847
        pgm_function8[(8, 2, 2, 3)] = 0.2217
        pgm_function8[(8, 2, 3, 1)] = 0.101309977
        pgm_function8[(8, 2, 3, 2)] = 0.354
        pgm_function8[(8, 2, 3, 3)] = 0.3263
        pgm_function8[(8, 3, 0, 0)] = 0.22867695
        pgm_function8[(8, 3, 0, 1)] = 0.2507
        pgm_function8[(8, 3, 0, 2)] = 0.0017
        pgm_function8[(8, 3, 1, 0)] = 0.15331509
        pgm_function8[(8, 3, 1, 1)] = 0.35733601
        pgm_function8[(8, 3, 1, 2)] = 0.0360036
        pgm_function8[(8, 3, 2, 0)] = 0.0797
        pgm_function8[(8, 3, 2, 1)] = 0.405
        pgm_function8[(8, 3, 2, 2)] = 0.132
        pgm_function8[(8, 3, 3, 0)] = 0.030696918
        pgm_function8[(8, 3, 3, 1)] = 0.3877
        pgm_function8[(8, 3, 3, 2)] = 0.2503
        pgm_function8[(8, 3, 3, 3)] = 0.0113011
        pgm_function8[(8, 4, 0, 0)] = 0.32666707
        pgm_function8[(8, 4, 0, 1)] = 0.089991015
        pgm_function8[(8, 4, 1, 0)] = 0.2747
        pgm_function8[(8, 4, 1, 1)] = 0.19431931
        pgm_function8[(8, 4, 2, 0)] = 0.21867822
        pgm_function8[(8, 4, 2, 1)] = 0.29467071
        pgm_function8[(8, 4, 2, 2)] = 0.001300129
        pgm_function8[(8, 4, 3, 0)] = 0.1577
        pgm_function8[(8, 4, 3, 1)] = 0.374037138
        pgm_function8[(8, 4, 3, 2)] = 0.0286971
        pgm_function8[(8, 5, 0, 0)] = 0.3647
        pgm_function8[(8, 5, 0, 1)] = 0.02170218
        pgm_function8[(8, 5, 1, 0)] = 0.3327
        pgm_function8[(8, 5, 1, 1)] = 0.0937
        pgm_function8[(8, 5, 2, 0)] = 0.286
        pgm_function8[(8, 5, 2, 1)] = 0.1797
        pgm_function8[(8, 5, 3, 0)] = 0.2382761
        pgm_function8[(8, 5, 3, 1)] = 0.26302589
        pgm_function8[(8, 6, 0, 0)] = 0.3557
        pgm_function8[(8, 6, 0, 1)] = 0.00129987
        pgm_function8[(8, 6, 1, 0)] = 0.358
        pgm_function8[(8, 6, 1, 1)] = 0.0457
        pgm_function8[(8, 6, 2, 0)] = 0.32596716
        pgm_function8[(8, 6, 2, 1)] = 0.108
        pgm_function8[(8, 6, 3, 0)] = 0.2823
        pgm_function8[(8, 6, 3, 1)] = 0.1827
        pgm_function8[(8, 7, 0, 0)] = 0.33766586
        pgm_function8[(8, 7, 1, 0)] = 0.3697
        pgm_function8[(8, 7, 1, 1)] = 0.0163
        pgm_function8[(8, 7, 2, 0)] = 0.343
        pgm_function8[(8, 7, 2, 1)] = 0.072992727
        pgm_function8[(8, 7, 3, 0)] = 0.318
        pgm_function8[(8, 7, 3, 1)] = 0.1267
        pgm_function8[(9, 1, 0, 2)] = 0.047
        pgm_function8[(9, 1, 0, 3)] = 0.16071621
        pgm_function8[(9, 1, 1, 2)] = 0.008
        pgm_function8[(9, 1, 1, 3)] = 0.099
        pgm_function8[(9, 1, 2, 3)] = 0.03630358
        pgm_function8[(9, 1, 3, 3)] = 0.0037
        pgm_function8[(9, 2, 0, 1)] = 0.17031701
        pgm_function8[(9, 2, 0, 2)] = 0.3357
        pgm_function8[(9, 2, 0, 3)] = 0.15
        pgm_function8[(9, 2, 1, 1)] = 0.0833
        pgm_function8[(9, 2, 1, 2)] = 0.3237
        pgm_function8[(9, 2, 1, 3)] = 0.2773
        pgm_function8[(9, 2, 2, 1)] = 0.025
        pgm_function8[(9, 2, 2, 2)] = 0.2483
        pgm_function8[(9, 2, 2, 3)] = 0.3493
        pgm_function8[(9, 2, 3, 1)] = 0.002300229
        pgm_function8[(9, 2, 3, 2)] = 0.162
        pgm_function8[(9, 2, 3, 3)] = 0.3277
        pgm_function8[(9, 3, 0, 0)] = 0.05869409
        pgm_function8[(9, 3, 0, 1)] = 0.3583
        pgm_function8[(9, 3, 0, 2)] = 0.0937
        pgm_function8[(9, 3, 1, 0)] = 0.01230121
        pgm_function8[(9, 3, 1, 1)] = 0.33033301
        pgm_function8[(9, 3, 1, 2)] = 0.232723
        pgm_function8[(9, 3, 1, 3)] = 0.008
        pgm_function8[(9, 3, 2, 1)] = 0.2573
        pgm_function8[(9, 3, 2, 2)] = 0.3307
        pgm_function8[(9, 3, 2, 3)] = 0.070692822
        pgm_function8[(9, 3, 3, 1)] = 0.1687
        pgm_function8[(9, 3, 3, 2)] = 0.3617
        pgm_function8[(9, 3, 3, 3)] = 0.18431804
        pgm_function8[(9, 4, 0, 0)] = 0.17268303
        pgm_function8[(9, 4, 0, 1)] = 0.267673046
        pgm_function8[(9, 4, 0, 2)] = 0.001
        pgm_function8[(9, 4, 1, 0)] = 0.0987
        pgm_function8[(9, 4, 1, 1)] = 0.35433557
        pgm_function8[(9, 4, 1, 2)] = 0.0417
        pgm_function8[(9, 4, 2, 0)] = 0.03869614
        pgm_function8[(9, 4, 2, 1)] = 0.36366364
        pgm_function8[(9, 4, 2, 2)] = 0.14271391
        pgm_function8[(9, 4, 3, 0)] = 0.0047
        pgm_function8[(9, 4, 3, 1)] = 0.335334124
        pgm_function8[(9, 4, 3, 2)] = 0.25097504
        pgm_function8[(9, 4, 3, 3)] = 0.002
        pgm_function8[(9, 5, 0, 0)] = 0.2247
        pgm_function8[(9, 5, 0, 1)] = 0.17901787
        pgm_function8[(9, 5, 1, 0)] = 0.1733
        pgm_function8[(9, 5, 1, 1)] = 0.274
        pgm_function8[(9, 5, 2, 0)] = 0.108
        pgm_function8[(9, 5, 2, 1)] = 0.3537
        pgm_function8[(9, 5, 2, 2)] = 0.0269973
        pgm_function8[(9, 5, 3, 0)] = 0.05669432
        pgm_function8[(9, 5, 3, 1)] = 0.36633685
        pgm_function8[(9, 5, 3, 2)] = 0.10199
        pgm_function8[(9, 6, 0, 0)] = 0.2583
        pgm_function8[(9, 6, 0, 1)] = 0.12668699
        pgm_function8[(9, 6, 1, 0)] = 0.207
        pgm_function8[(9, 6, 1, 1)] = 0.2137
        pgm_function8[(9, 6, 2, 0)] = 0.16468408
        pgm_function8[(9, 6, 2, 1)] = 0.2937
        pgm_function8[(9, 6, 3, 0)] = 0.1027
        pgm_function8[(9, 6, 3, 1)] = 0.3597
        pgm_function8[(9, 6, 3, 2)] = 0.02330227
        pgm_function8[(9, 7, 0, 0)] = 0.27067289
        pgm_function8[(9, 7, 0, 1)] = 0.096
        pgm_function8[(9, 7, 1, 0)] = 0.2317
        pgm_function8[(9, 7, 1, 1)] = 0.1747
        pgm_function8[(9, 7, 2, 0)] = 0.1883
        pgm_function8[(9, 7, 2, 1)] = 0.2456750909
        pgm_function8[(9, 7, 3, 0)] = 0.144
        pgm_function8[(9, 7, 3, 1)] = 0.317
        pgm_function8[(9, 7, 3, 2)] = 0.0003000297
        pgm_function8[(10, 1, 0, 2)] = 0.0017
        pgm_function8[(10, 1, 0, 3)] = 0.06930699
        pgm_function8[(10, 1, 1, 3)] = 0.0137
        pgm_function8[(10, 2, 0, 1)] = 0.0377038
        pgm_function8[(10, 2, 0, 2)] = 0.2627
        pgm_function8[(10, 2, 0, 3)] = 0.2803
        pgm_function8[(10, 2, 1, 1)] = 0.003
        pgm_function8[(10, 2, 1, 2)] = 0.1683
        pgm_function8[(10, 2, 1, 3)] = 0.312
        pgm_function8[(10, 2, 2, 2)] = 0.0737
        pgm_function8[(10, 2, 2, 3)] = 0.2557
        pgm_function8[(10, 2, 3, 2)] = 0.0197
        pgm_function8[(10, 2, 3, 3)] = 0.179
        pgm_function8[(10, 3, 0, 1)] = 0.247
        pgm_function8[(10, 3, 0, 2)] = 0.2663
        pgm_function8[(10, 3, 0, 3)] = 0.0257
        pgm_function8[(10, 3, 1, 1)] = 0.151015
        pgm_function8[(10, 3, 1, 2)] = 0.328333
        pgm_function8[(10, 3, 1, 3)] = 0.1427
        pgm_function8[(10, 3, 2, 1)] = 0.0613
        pgm_function8[(10, 3, 2, 2)] = 0.3243
        pgm_function8[(10, 3, 2, 3)] = 0.26397371
        pgm_function8[(10, 3, 3, 1)] = 0.0133
        pgm_function8[(10, 3, 3, 2)] = 0.279
        pgm_function8[(10, 3, 3, 3)] = 0.31803206
        pgm_function8[(10, 4, 0, 0)] = 0.03199681
        pgm_function8[(10, 4, 0, 1)] = 0.327967056
        pgm_function8[(10, 4, 0, 2)] = 0.1017
        pgm_function8[(10, 4, 1, 0)] = 0.001
        pgm_function8[(10, 4, 1, 1)] = 0.29302947
        pgm_function8[(10, 4, 1, 2)] = 0.2263
        pgm_function8[(10, 4, 1, 3)] = 0.0013
        pgm_function8[(10, 4, 2, 1)] = 0.22167778
        pgm_function8[(10, 4, 2, 2)] = 0.310330804
        pgm_function8[(10, 4, 2, 3)] = 0.0436956
        pgm_function8[(10, 4, 3, 1)] = 0.144314053
        pgm_function8[(10, 4, 3, 2)] = 0.32796706
        pgm_function8[(10, 4, 3, 3)] = 0.1477
        pgm_function8[(10, 5, 0, 0)] = 0.0893
        pgm_function8[(10, 5, 0, 1)] = 0.31633178
        pgm_function8[(10, 5, 0, 2)] = 0.016
        pgm_function8[(10, 5, 1, 0)] = 0.0283
        pgm_function8[(10, 5, 1, 1)] = 0.3307
        pgm_function8[(10, 5, 1, 2)] = 0.112311146
        pgm_function8[(10, 5, 2, 1)] = 0.3023
        pgm_function8[(10, 5, 2, 2)] = 0.208679
        pgm_function8[(10, 5, 3, 1)] = 0.2460249
        pgm_function8[(10, 5, 3, 2)] = 0.291671
        pgm_function8[(10, 5, 3, 3)] = 0.0093
        pgm_function8[(10, 6, 0, 0)] = 0.125
        pgm_function8[(10, 6, 0, 1)] = 0.27167297
        pgm_function8[(10, 6, 1, 0)] = 0.067
        pgm_function8[(10, 6, 1, 1)] = 0.33
        pgm_function8[(10, 6, 1, 2)] = 0.0413
        pgm_function8[(10, 6, 2, 0)] = 0.01469851
        pgm_function8[(10, 6, 2, 1)] = 0.3293
        pgm_function8[(10, 6, 2, 2)] = 0.1306868785
        pgm_function8[(10, 6, 3, 1)] = 0.3003
        pgm_function8[(10, 6, 3, 2)] = 0.20702073
        pgm_function8[(10, 7, 0, 0)] = 0.15168494
        pgm_function8[(10, 7, 0, 1)] = 0.2337
        pgm_function8[(10, 7, 1, 0)] = 0.0913
        pgm_function8[(10, 7, 1, 1)] = 0.319
        pgm_function8[(10, 7, 1, 2)] = 0.008699123
        pgm_function8[(10, 7, 2, 0)] = 0.0437
        pgm_function8[(10, 7, 2, 1)] = 0.3316671227
        pgm_function8[(10, 7, 2, 2)] = 0.0777
        pgm_function8[(10, 7, 3, 0)] = 0.0037
        pgm_function8[(10, 7, 3, 1)] = 0.3253
        pgm_function8[(10, 7, 3, 2)] = 0.1500148305
        pgm_function8[(11, 1, 0, 3)] = 0.00800081
        pgm_function8[(11, 2, 0, 1)] = 0.00030003
        pgm_function8[(11, 2, 0, 2)] = 0.1203
        pgm_function8[(11, 2, 0, 3)] = 0.2767
        pgm_function8[(11, 2, 1, 2)] = 0.036
        pgm_function8[(11, 2, 1, 3)] = 0.2053
        pgm_function8[(11, 2, 2, 2)] = 0.0023
        pgm_function8[(11, 2, 2, 3)] = 0.1143
        pgm_function8[(11, 2, 3, 3)] = 0.0403
        pgm_function8[(11, 3, 0, 1)] = 0.092
        pgm_function8[(11, 3, 0, 2)] = 0.3007
        pgm_function8[(11, 3, 0, 3)] = 0.1687
        pgm_function8[(11, 3, 1, 1)] = 0.0183018
        pgm_function8[(11, 3, 1, 2)] = 0.272327
        pgm_function8[(11, 3, 1, 3)] = 0.2757
        pgm_function8[(11, 3, 2, 2)] = 0.18
        pgm_function8[(11, 3, 2, 3)] = 0.303669666
        pgm_function8[(11, 3, 3, 2)] = 0.0837
        pgm_function8[(11, 3, 3, 3)] = 0.29833006
        pgm_function8[(11, 4, 0, 1)] = 0.222978038
        pgm_function8[(11, 4, 0, 2)] = 0.2523
        pgm_function8[(11, 4, 0, 3)] = 0.01
        pgm_function8[(11, 4, 1, 1)] = 0.13431321
        pgm_function8[(11, 4, 1, 2)] = 0.2987
        pgm_function8[(11, 4, 1, 3)] = 0.112
        pgm_function8[(11, 4, 2, 1)] = 0.05329465
        pgm_function8[(11, 4, 2, 2)] = 0.305330808
        pgm_function8[(11, 4, 2, 3)] = 0.233677
        pgm_function8[(11, 4, 3, 1)] = 0.006300632
        pgm_function8[(11, 4, 3, 2)] = 0.28067205
        pgm_function8[(11, 4, 3, 3)] = 0.286
        pgm_function8[(11, 5, 0, 0)] = 0.0007
        pgm_function8[(11, 5, 0, 1)] = 0.27832781
        pgm_function8[(11, 5, 0, 2)] = 0.1597
        pgm_function8[(11, 5, 1, 1)] = 0.2173
        pgm_function8[(11, 5, 1, 2)] = 0.263326342
        pgm_function8[(11, 5, 1, 3)] = 0.007001399
        pgm_function8[(11, 5, 2, 1)] = 0.149
        pgm_function8[(11, 5, 2, 2)] = 0.29867
        pgm_function8[(11, 5, 2, 3)] = 0.0847
        pgm_function8[(11, 5, 3, 1)] = 0.08130807
        pgm_function8[(11, 5, 3, 2)] = 0.29997
        pgm_function8[(11, 5, 3, 3)] = 0.1873
        pgm_function8[(11, 6, 0, 0)] = 0.013
        pgm_function8[(11, 6, 0, 1)] = 0.29866997
        pgm_function8[(11, 6, 0, 2)] = 0.10069003
        pgm_function8[(11, 6, 1, 1)] = 0.263
        pgm_function8[(11, 6, 1, 2)] = 0.194
        pgm_function8[(11, 6, 2, 1)] = 0.202
        pgm_function8[(11, 6, 2, 2)] = 0.281671738
        pgm_function8[(11, 6, 2, 3)] = 0.008
        pgm_function8[(11, 6, 3, 1)] = 0.1457
        pgm_function8[(11, 6, 3, 2)] = 0.29702961
        pgm_function8[(11, 6, 3, 3)] = 0.07900787
        pgm_function8[(11, 7, 0, 0)] = 0.03199679
        pgm_function8[(11, 7, 0, 1)] = 0.305
        pgm_function8[(11, 7, 0, 2)] = 0.058305812
        pgm_function8[(11, 7, 1, 1)] = 0.2827
        pgm_function8[(11, 7, 1, 2)] = 0.153684883
        pgm_function8[(11, 7, 2, 1)] = 0.2392760885
        pgm_function8[(11, 7, 2, 2)] = 0.2273
        pgm_function8[(11, 7, 3, 1)] = 0.1833
        pgm_function8[(11, 7, 3, 2)] = 0.2960296655
        pgm_function8[(11, 7, 3, 3)] = 0.0133013089
        pgm_function8[(12, 2, 0, 2)] = 0.025
        pgm_function8[(12, 2, 0, 3)] = 0.1823
        pgm_function8[(12, 2, 1, 3)] = 0.081
        pgm_function8[(12, 2, 2, 3)] = 0.0143
        pgm_function8[(12, 3, 0, 1)] = 0.0057
        pgm_function8[(12, 3, 0, 2)] = 0.2333
        pgm_function8[(12, 3, 0, 3)] = 0.2603
        pgm_function8[(12, 3, 1, 2)] = 0.117312
        pgm_function8[(12, 3, 1, 3)] = 0.2783
        pgm_function8[(12, 3, 2, 2)] = 0.032
        pgm_function8[(12, 3, 2, 3)] = 0.251674723
        pgm_function8[(12, 3, 3, 2)] = 0.0013
        pgm_function8[(12, 3, 3, 3)] = 0.16131603
        pgm_function8[(12, 4, 0, 1)] = 0.087691215
        pgm_function8[(12, 4, 0, 2)] = 0.274
        pgm_function8[(12, 4, 0, 3)] = 0.1397
        pgm_function8[(12, 4, 1, 1)] = 0.01230122
        pgm_function8[(12, 4, 1, 2)] = 0.273
        pgm_function8[(12, 4, 1, 3)] = 0.2493
        pgm_function8[(12, 4, 2, 2)] = 0.195019877
        pgm_function8[(12, 4, 2, 3)] = 0.270973
        pgm_function8[(12, 4, 3, 2)] = 0.10898902
        pgm_function8[(12, 4, 3, 3)] = 0.2827
        pgm_function8[(12, 5, 0, 1)] = 0.15931589
        pgm_function8[(12, 5, 0, 2)] = 0.2687
        pgm_function8[(12, 5, 0, 3)] = 0.0277
        pgm_function8[(12, 5, 1, 1)] = 0.084
        pgm_function8[(12, 5, 1, 2)] = 0.271327353
        pgm_function8[(12, 5, 1, 3)] = 0.153330985
        pgm_function8[(12, 5, 2, 1)] = 0.0113
        pgm_function8[(12, 5, 2, 2)] = 0.287971
        pgm_function8[(12, 5, 2, 3)] = 0.2433
        pgm_function8[(12, 5, 3, 2)] = 0.226677
        pgm_function8[(12, 5, 3, 3)] = 0.2757
        pgm_function8[(12, 6, 0, 1)] = 0.20367998
        pgm_function8[(12, 6, 0, 2)] = 0.22427807
        pgm_function8[(12, 6, 0, 3)] = 0.0003000302
        pgm_function8[(12, 6, 1, 1)] = 0.1323
        pgm_function8[(12, 6, 1, 2)] = 0.2767
        pgm_function8[(12, 6, 1, 3)] = 0.062
        pgm_function8[(12, 6, 2, 1)] = 0.067
        pgm_function8[(12, 6, 2, 2)] = 0.2712727477
        pgm_function8[(12, 6, 2, 3)] = 0.172
        pgm_function8[(12, 6, 3, 1)] = 0.0083
        pgm_function8[(12, 6, 3, 2)] = 0.29532962
        pgm_function8[(12, 6, 3, 3)] = 0.23432291
        pgm_function8[(12, 7, 0, 1)] = 0.2287
        pgm_function8[(12, 7, 0, 2)] = 0.182018036
        pgm_function8[(12, 7, 1, 1)] = 0.159
        pgm_function8[(12, 7, 1, 2)] = 0.273972792
        pgm_function8[(12, 7, 1, 3)] = 0.0143
        pgm_function8[(12, 7, 2, 1)] = 0.1096890406
        pgm_function8[(12, 7, 2, 2)] = 0.268
        pgm_function8[(12, 7, 2, 3)] = 0.1033
        pgm_function8[(12, 7, 3, 1)] = 0.0477
        pgm_function8[(12, 7, 3, 2)] = 0.2763276877
        pgm_function8[(12, 7, 3, 3)] = 0.1830181226
        pgm_function8[(13, 2, 0, 3)] = 0.0747
        pgm_function8[(13, 2, 1, 3)] = 0.0077
        pgm_function8[(13, 3, 0, 2)] = 0.094
        pgm_function8[(13, 3, 0, 3)] = 0.2573
        pgm_function8[(13, 3, 1, 2)] = 0.0133013
        pgm_function8[(13, 3, 1, 3)] = 0.2133
        pgm_function8[(13, 3, 2, 3)] = 0.101989888
        pgm_function8[(13, 3, 3, 3)] = 0.02670271
        pgm_function8[(13, 4, 0, 1)] = 0.003699631
        pgm_function8[(13, 4, 0, 2)] = 0.234
        pgm_function8[(13, 4, 0, 3)] = 0.2393
        pgm_function8[(13, 4, 1, 2)] = 0.141
        pgm_function8[(13, 4, 1, 3)] = 0.2527
        pgm_function8[(13, 4, 2, 2)] = 0.045304471
        pgm_function8[(13, 4, 2, 3)] = 0.267673
        pgm_function8[(13, 4, 3, 2)] = 0.00269973
        pgm_function8[(13, 4, 3, 3)] = 0.2163
        pgm_function8[(13, 5, 0, 1)] = 0.04530447
        pgm_function8[(13, 5, 0, 2)] = 0.2593
        pgm_function8[(13, 5, 0, 3)] = 0.1683
        pgm_function8[(13, 5, 1, 1)] = 0.0003
        pgm_function8[(13, 5, 1, 2)] = 0.232323302
        pgm_function8[(13, 5, 1, 3)] = 0.251349975
        pgm_function8[(13, 5, 2, 2)] = 0.153985
        pgm_function8[(13, 5, 2, 3)] = 0.2417
        pgm_function8[(13, 5, 3, 2)] = 0.079692
        pgm_function8[(13, 5, 3, 3)] = 0.2687
        pgm_function8[(13, 6, 0, 1)] = 0.09429059
        pgm_function8[(13, 6, 0, 2)] = 0.24667507
        pgm_function8[(13, 6, 0, 3)] = 0.0990099792
        pgm_function8[(13, 6, 1, 1)] = 0.0153
        pgm_function8[(13, 6, 1, 2)] = 0.272
        pgm_function8[(13, 6, 1, 3)] = 0.1993
        pgm_function8[(13, 6, 2, 2)] = 0.2146788003
        pgm_function8[(13, 6, 2, 3)] = 0.259
        pgm_function8[(13, 6, 3, 2)] = 0.1570158
        pgm_function8[(13, 6, 3, 3)] = 0.23732391
        pgm_function8[(13, 7, 0, 1)] = 0.1183
        pgm_function8[(13, 7, 0, 2)] = 0.257026051
        pgm_function8[(13, 7, 0, 3)] = 0.045
        pgm_function8[(13, 7, 1, 1)] = 0.0483
        pgm_function8[(13, 7, 1, 2)] = 0.253274808
        pgm_function8[(13, 7, 1, 3)] = 0.1593
        pgm_function8[(13, 7, 2, 1)] = 0.0006999303
        pgm_function8[(13, 7, 2, 2)] = 0.2653
        pgm_function8[(13, 7, 2, 3)] = 0.2253
        pgm_function8[(13, 7, 3, 2)] = 0.1963197782
        pgm_function8[(13, 7, 3, 3)] = 0.2643261771
        pgm_function8[(14, 2, 0, 3)] = 0.01
        pgm_function8[(14, 3, 0, 2)] = 0.0103
        pgm_function8[(14, 3, 0, 3)] = 0.1983
        pgm_function8[(14, 3, 1, 3)] = 0.077
        pgm_function8[(14, 3, 2, 3)] = 0.007999191
        pgm_function8[(14, 4, 0, 2)] = 0.1203
        pgm_function8[(14, 4, 0, 3)] = 0.2363
        pgm_function8[(14, 4, 1, 2)] = 0.0193
        pgm_function8[(14, 4, 1, 3)] = 0.2403
        pgm_function8[(14, 4, 2, 3)] = 0.156684
        pgm_function8[(14, 4, 3, 3)] = 0.0653
        pgm_function8[(14, 5, 0, 2)] = 0.1953
        pgm_function8[(14, 5, 0, 3)] = 0.2343
        pgm_function8[(14, 5, 1, 2)] = 0.113711148
        pgm_function8[(14, 5, 1, 3)] = 0.229345977
        pgm_function8[(14, 5, 2, 2)] = 0.0236976
        pgm_function8[(14, 5, 2, 3)] = 0.2573
        pgm_function8[(14, 5, 3, 3)] = 0.1963
        pgm_function8[(14, 6, 0, 1)] = 0.00369963
        pgm_function8[(14, 6, 0, 2)] = 0.24567507
        pgm_function8[(14, 6, 0, 3)] = 0.2023201619
        pgm_function8[(14, 6, 1, 2)] = 0.161
        pgm_function8[(14, 6, 1, 3)] = 0.235
        pgm_function8[(14, 6, 2, 2)] = 0.1009899061
        pgm_function8[(14, 6, 2, 3)] = 0.233
        pgm_function8[(14, 6, 3, 2)] = 0.02030197
        pgm_function8[(14, 6, 3, 3)] = 0.26602689
        pgm_function8[(14, 7, 0, 1)] = 0.0183
        pgm_function8[(14, 7, 0, 2)] = 0.24832505
        pgm_function8[(14, 7, 0, 3)] = 0.1673
        pgm_function8[(14, 7, 1, 2)] = 0.199979848
        pgm_function8[(14, 7, 1, 3)] = 0.245
        pgm_function8[(14, 7, 2, 2)] = 0.142
        pgm_function8[(14, 7, 2, 3)] = 0.2173
        pgm_function8[(14, 7, 3, 2)] = 0.0810080085
        pgm_function8[(14, 7, 3, 3)] = 0.2453251644
        pgm_function8[(15, 3, 0, 3)] = 0.0797
        pgm_function8[(15, 3, 1, 3)] = 0.005
        pgm_function8[(15, 4, 0, 2)] = 0.0167
        pgm_function8[(15, 4, 0, 3)] = 0.2217
        pgm_function8[(15, 4, 1, 3)] = 0.1277
        pgm_function8[(15, 4, 2, 3)] = 0.0272973
        pgm_function8[(15, 5, 0, 2)] = 0.0943
        pgm_function8[(15, 5, 0, 3)] = 0.219
        pgm_function8[(15, 5, 1, 2)] = 0.007000709
        pgm_function8[(15, 5, 1, 3)] = 0.222343978
        pgm_function8[(15, 5, 2, 3)] = 0.1507
        pgm_function8[(15, 5, 3, 3)] = 0.0627
        pgm_function8[(15, 6, 0, 2)] = 0.13998604
        pgm_function8[(15, 6, 0, 3)] = 0.2133211707
        pgm_function8[(15, 6, 1, 2)] = 0.055
        pgm_function8[(15, 6, 1, 3)] = 0.2437
        pgm_function8[(15, 6, 2, 2)] = 0.0006999293
        pgm_function8[(15, 6, 2, 3)] = 0.209
        pgm_function8[(15, 6, 3, 3)] = 0.15831594
        pgm_function8[(15, 7, 0, 2)] = 0.164316033
        pgm_function8[(15, 7, 0, 3)] = 0.229
        pgm_function8[(15, 7, 1, 2)] = 0.106688919
        pgm_function8[(15, 7, 1, 3)] = 0.203
        pgm_function8[(15, 7, 2, 2)] = 0.0197
        pgm_function8[(15, 7, 2, 3)] = 0.2557
        pgm_function8[(15, 7, 3, 3)] = 0.1917191285
        pgm_function8[(16, 3, 0, 3)] = 0.01
        pgm_function8[(16, 4, 0, 3)] = 0.126
        pgm_function8[(16, 4, 1, 3)] = 0.0167
        pgm_function8[(16, 5, 0, 2)] = 0.0067
        pgm_function8[(16, 5, 0, 3)] = 0.208
        pgm_function8[(16, 5, 1, 3)] = 0.123324988
        pgm_function8[(16, 5, 2, 3)] = 0.0223
        pgm_function8[(16, 6, 0, 2)] = 0.04269571
        pgm_function8[(16, 6, 0, 3)] = 0.2280231824
        pgm_function8[(16, 6, 1, 3)] = 0.173
        pgm_function8[(16, 6, 2, 3)] = 0.115
        pgm_function8[(16, 6, 3, 3)] = 0.02500249
        pgm_function8[(16, 7, 0, 2)] = 0.087008717
        pgm_function8[(16, 7, 0, 3)] = 0.2007
        pgm_function8[(16, 7, 1, 2)] = 0.003699627
        pgm_function8[(16, 7, 1, 3)] = 0.2187
        pgm_function8[(16, 7, 2, 3)] = 0.1537
        pgm_function8[(16, 7, 3, 3)] = 0.1020100683
        pgm_function8[(17, 4, 0, 3)] = 0.027
        pgm_function8[(17, 5, 0, 3)] = 0.119
        pgm_function8[(17, 5, 1, 3)] = 0.013302699
        pgm_function8[(17, 6, 0, 3)] = 0.1643161315
        pgm_function8[(17, 6, 1, 3)] = 0.0857
        pgm_function8[(17, 6, 2, 3)] = 0.004
        pgm_function8[(17, 7, 0, 2)] = 0.003000301
        pgm_function8[(17, 7, 0, 3)] = 0.2013
        pgm_function8[(17, 7, 1, 3)] = 0.1357
        pgm_function8[(17, 7, 2, 3)] = 0.0447
        pgm_function8[(17, 7, 3, 3)] = 0.0003000302
        pgm_function8[(18, 5, 0, 3)] = 0.0237
        pgm_function8[(18, 6, 0, 3)] = 0.0870087696
        pgm_function8[(18, 6, 1, 3)] = 0.0013
        pgm_function8[(18, 7, 0, 3)] = 0.124
        pgm_function8[(18, 7, 1, 3)] = 0.024
        pgm_function8[(19, 6, 0, 3)] = 0.0057005746
        pgm_function8[(19, 7, 0, 3)] = 0.0327

        pgm_function9 = pgm_factor9.set_dense()
        pgm_function9.set_flat(0.033, 0.433, 0.467, 0.067)

        pgm_function10 = pgm_factor10.set_dense()
        pgm_function10.set_flat(0.133, 0.433, 0.3, 0.134)

        pgm_function11 = pgm_factor11.set_sparse()
        pgm_function11[(0, 0, 0)] = 1.0
        pgm_function11[(0, 0, 1)] = 1.0
        pgm_function11[(0, 0, 2)] = 1.0
        pgm_function11[(0, 0, 3)] = 1.0
        pgm_function11[(0, 0, 4)] = 1.0
        pgm_function11[(0, 0, 5)] = 1.0
        pgm_function11[(0, 0, 6)] = 1.0
        pgm_function11[(0, 0, 7)] = 1.0
        pgm_function11[(0, 0, 8)] = 1.0
        pgm_function11[(0, 1, 0)] = 0.03330331
        pgm_function11[(0, 1, 1)] = 0.03330331
        pgm_function11[(0, 1, 2)] = 0.03330331
        pgm_function11[(0, 1, 3)] = 0.03330331
        pgm_function11[(0, 1, 4)] = 0.0333
        pgm_function11[(0, 1, 5)] = 0.0633
        pgm_function11[(0, 1, 6)] = 0.1333
        pgm_function11[(0, 1, 7)] = 0.34
        pgm_function11[(0, 1, 8)] = 0.9133
        pgm_function11[(0, 2, 8)] = 0.5333
        pgm_function11[(0, 3, 8)] = 0.3467
        pgm_function11[(0, 4, 8)] = 0.26
        pgm_function11[(0, 5, 8)] = 0.20332014
        pgm_function11[(0, 6, 8)] = 0.19
        pgm_function11[(0, 7, 8)] = 0.14668515
        pgm_function11[(1, 1, 0)] = 0.93339337
        pgm_function11[(1, 1, 1)] = 0.93339337
        pgm_function11[(1, 1, 2)] = 0.93339337
        pgm_function11[(1, 1, 3)] = 0.93339337
        pgm_function11[(1, 1, 4)] = 0.9567
        pgm_function11[(1, 1, 5)] = 0.9367
        pgm_function11[(1, 1, 6)] = 0.8667
        pgm_function11[(1, 1, 7)] = 0.66
        pgm_function11[(1, 1, 8)] = 0.0867
        pgm_function11[(1, 2, 0)] = 0.06669333
        pgm_function11[(1, 2, 1)] = 0.06669333
        pgm_function11[(1, 2, 2)] = 0.0967
        pgm_function11[(1, 2, 3)] = 0.1
        pgm_function11[(1, 2, 4)] = 0.13331309
        pgm_function11[(1, 2, 5)] = 0.1867
        pgm_function11[(1, 2, 6)] = 0.3933
        pgm_function11[(1, 2, 7)] = 0.86
        pgm_function11[(1, 2, 8)] = 0.4667
        pgm_function11[(1, 3, 7)] = 0.15
        pgm_function11[(1, 3, 8)] = 0.62
        pgm_function11[(1, 4, 8)] = 0.5167
        pgm_function11[(1, 5, 8)] = 0.42004229
        pgm_function11[(1, 6, 8)] = 0.3267
        pgm_function11[(1, 7, 8)] = 0.2999703
        pgm_function11[(2, 1, 0)] = 0.03330331
        pgm_function11[(2, 1, 1)] = 0.03330331
        pgm_function11[(2, 1, 2)] = 0.03330331
        pgm_function11[(2, 1, 3)] = 0.03330331
        pgm_function11[(2, 1, 4)] = 0.01
        pgm_function11[(2, 2, 0)] = 0.86661335
        pgm_function11[(2, 2, 1)] = 0.86661335
        pgm_function11[(2, 2, 2)] = 0.8633
        pgm_function11[(2, 2, 3)] = 0.8667
        pgm_function11[(2, 2, 4)] = 0.84338459
        pgm_function11[(2, 2, 5)] = 0.8133
        pgm_function11[(2, 2, 6)] = 0.6067
        pgm_function11[(2, 2, 7)] = 0.14
        pgm_function11[(2, 3, 0)] = 0.16668312
        pgm_function11[(2, 3, 1)] = 0.16668312
        pgm_function11[(2, 3, 2)] = 0.16668312
        pgm_function11[(2, 3, 3)] = 0.16668312
        pgm_function11[(2, 3, 4)] = 0.2133
        pgm_function11[(2, 3, 5)] = 0.3133
        pgm_function11[(2, 3, 6)] = 0.6267
        pgm_function11[(2, 3, 7)] = 0.83
        pgm_function11[(2, 3, 8)] = 0.0333
        pgm_function11[(2, 4, 6)] = 0.02330232
        pgm_function11[(2, 4, 7)] = 0.59
        pgm_function11[(2, 4, 8)] = 0.2233
        pgm_function11[(2, 5, 7)] = 0.1333
        pgm_function11[(2, 5, 8)] = 0.35333525
        pgm_function11[(2, 6, 7)] = 0.0033
        pgm_function11[(2, 6, 8)] = 0.34
        pgm_function11[(2, 7, 8)] = 0.2966703
        pgm_function11[(3, 2, 0)] = 0.06669333
        pgm_function11[(3, 2, 1)] = 0.06669333
        pgm_function11[(3, 2, 2)] = 0.04
        pgm_function11[(3, 2, 3)] = 0.0333
        pgm_function11[(3, 2, 4)] = 0.02330232
        pgm_function11[(3, 3, 0)] = 0.76662354
        pgm_function11[(3, 3, 1)] = 0.76662354
        pgm_function11[(3, 3, 2)] = 0.76662354
        pgm_function11[(3, 3, 3)] = 0.76662354
        pgm_function11[(3, 3, 4)] = 0.7567
        pgm_function11[(3, 3, 5)] = 0.6867
        pgm_function11[(3, 3, 6)] = 0.3733
        pgm_function11[(3, 3, 7)] = 0.02
        pgm_function11[(3, 4, 0)] = 0.2
        pgm_function11[(3, 4, 1)] = 0.2
        pgm_function11[(3, 4, 2)] = 0.2
        pgm_function11[(3, 4, 3)] = 0.2433
        pgm_function11[(3, 4, 4)] = 0.3033
        pgm_function11[(3, 4, 5)] = 0.44
        pgm_function11[(3, 4, 6)] = 0.74337452
        pgm_function11[(3, 4, 7)] = 0.4067
        pgm_function11[(3, 5, 6)] = 0.14
        pgm_function11[(3, 5, 7)] = 0.6867
        pgm_function11[(3, 5, 8)] = 0.02330232
        pgm_function11[(3, 6, 7)] = 0.4167
        pgm_function11[(3, 6, 8)] = 0.1433
        pgm_function11[(3, 7, 7)] = 0.11668808
        pgm_function11[(3, 7, 8)] = 0.23667624
        pgm_function11[(4, 3, 0)] = 0.06669335
        pgm_function11[(4, 3, 1)] = 0.06669335
        pgm_function11[(4, 3, 2)] = 0.06669335
        pgm_function11[(4, 3, 3)] = 0.06669335
        pgm_function11[(4, 3, 4)] = 0.03
        pgm_function11[(4, 4, 0)] = 0.7
        pgm_function11[(4, 4, 1)] = 0.7
        pgm_function11[(4, 4, 2)] = 0.7
        pgm_function11[(4, 4, 3)] = 0.6867
        pgm_function11[(4, 4, 4)] = 0.6567
        pgm_function11[(4, 4, 5)] = 0.56
        pgm_function11[(4, 4, 6)] = 0.23332316
        pgm_function11[(4, 4, 7)] = 0.0033
        pgm_function11[(4, 5, 0)] = 0.2333232
        pgm_function11[(4, 5, 1)] = 0.2533253
        pgm_function11[(4, 5, 2)] = 0.2967
        pgm_function11[(4, 5, 3)] = 0.3
        pgm_function11[(4, 5, 4)] = 0.39
        pgm_function11[(4, 5, 5)] = 0.5333
        pgm_function11[(4, 5, 6)] = 0.7067
        pgm_function11[(4, 5, 7)] = 0.18
        pgm_function11[(4, 6, 5)] = 0.0267
        pgm_function11[(4, 6, 6)] = 0.3133313
        pgm_function11[(4, 6, 7)] = 0.5067
        pgm_function11[(4, 7, 6)] = 0.0167
        pgm_function11[(4, 7, 7)] = 0.54664538
        pgm_function11[(4, 7, 8)] = 0.01999802
        pgm_function11[(5, 4, 0)] = 0.1
        pgm_function11[(5, 4, 1)] = 0.1
        pgm_function11[(5, 4, 2)] = 0.1
        pgm_function11[(5, 4, 3)] = 0.07
        pgm_function11[(5, 4, 4)] = 0.04
        pgm_function11[(5, 5, 0)] = 0.6333636
        pgm_function11[(5, 5, 1)] = 0.6333636
        pgm_function11[(5, 5, 2)] = 0.6033
        pgm_function11[(5, 5, 3)] = 0.6
        pgm_function11[(5, 5, 4)] = 0.5633
        pgm_function11[(5, 5, 5)] = 0.4667
        pgm_function11[(5, 5, 6)] = 0.1533
        pgm_function11[(5, 6, 0)] = 0.3333333
        pgm_function11[(5, 6, 1)] = 0.3333333
        pgm_function11[(5, 6, 2)] = 0.3333333
        pgm_function11[(5, 6, 3)] = 0.3733
        pgm_function11[(5, 6, 4)] = 0.46
        pgm_function11[(5, 6, 5)] = 0.55
        pgm_function11[(5, 6, 6)] = 0.5833586
        pgm_function11[(5, 6, 7)] = 0.0733
        pgm_function11[(5, 7, 4)] = 0.02
        pgm_function11[(5, 7, 5)] = 0.11
        pgm_function11[(5, 7, 6)] = 0.43
        pgm_function11[(5, 7, 7)] = 0.30996922
        pgm_function11[(6, 5, 0)] = 0.1333131
        pgm_function11[(6, 5, 1)] = 0.1133111
        pgm_function11[(6, 5, 2)] = 0.1
        pgm_function11[(6, 5, 3)] = 0.1
        pgm_function11[(6, 5, 4)] = 0.0467
        pgm_function11[(6, 6, 0)] = 0.5333535
        pgm_function11[(6, 6, 1)] = 0.5333535
        pgm_function11[(6, 6, 2)] = 0.5333535
        pgm_function11[(6, 6, 3)] = 0.5167
        pgm_function11[(6, 6, 4)] = 0.48
        pgm_function11[(6, 6, 5)] = 0.4233
        pgm_function11[(6, 6, 6)] = 0.1033101
        pgm_function11[(6, 7, 0)] = 0.3667
        pgm_function11[(6, 7, 1)] = 0.3767
        pgm_function11[(6, 7, 2)] = 0.4
        pgm_function11[(6, 7, 3)] = 0.4333
        pgm_function11[(6, 7, 4)] = 0.4667
        pgm_function11[(6, 7, 5)] = 0.51
        pgm_function11[(6, 7, 6)] = 0.4733
        pgm_function11[(6, 7, 7)] = 0.02669732
        pgm_function11[(7, 6, 0)] = 0.1333131
        pgm_function11[(7, 6, 1)] = 0.1333131
        pgm_function11[(7, 6, 2)] = 0.1333131
        pgm_function11[(7, 6, 3)] = 0.11
        pgm_function11[(7, 6, 4)] = 0.06
        pgm_function11[(7, 7, 0)] = 0.6333
        pgm_function11[(7, 7, 1)] = 0.6233
        pgm_function11[(7, 7, 2)] = 0.6
        pgm_function11[(7, 7, 3)] = 0.5667
        pgm_function11[(7, 7, 4)] = 0.5133
        pgm_function11[(7, 7, 5)] = 0.38
        pgm_function11[(7, 7, 6)] = 0.08

        pgm_function12 = pgm_factor12.set_sparse()
        pgm_function12[(0, 0, 0, 0)] = 1.0
        pgm_function12[(0, 0, 0, 1)] = 0.3
        pgm_function12[(0, 0, 0, 2)] = 0.1
        pgm_function12[(0, 0, 0, 3)] = 0.1
        pgm_function12[(0, 0, 1, 0)] = 1.0
        pgm_function12[(0, 0, 1, 1)] = 0.2
        pgm_function12[(0, 0, 1, 2)] = 0.1
        pgm_function12[(0, 0, 2, 0)] = 0.9
        pgm_function12[(0, 0, 2, 1)] = 0.05
        pgm_function12[(0, 0, 3, 0)] = 0.75
        pgm_function12[(0, 1, 0, 0)] = 1.0
        pgm_function12[(0, 1, 0, 1)] = 1.0
        pgm_function12[(0, 1, 0, 2)] = 0.95
        pgm_function12[(0, 1, 0, 3)] = 0.95
        pgm_function12[(0, 1, 0, 4)] = 0.8
        pgm_function12[(0, 1, 0, 5)] = 0.5
        pgm_function12[(0, 1, 0, 6)] = 0.2
        pgm_function12[(0, 1, 0, 7)] = 0.05
        pgm_function12[(0, 1, 1, 0)] = 1.0
        pgm_function12[(0, 1, 1, 1)] = 1.0
        pgm_function12[(0, 1, 1, 2)] = 0.95
        pgm_function12[(0, 1, 1, 3)] = 0.9
        pgm_function12[(0, 1, 1, 4)] = 0.75
        pgm_function12[(0, 1, 1, 5)] = 0.4
        pgm_function12[(0, 1, 1, 6)] = 0.1
        pgm_function12[(0, 1, 2, 0)] = 1.0
        pgm_function12[(0, 1, 2, 1)] = 1.0
        pgm_function12[(0, 1, 2, 2)] = 0.95
        pgm_function12[(0, 1, 2, 3)] = 0.7
        pgm_function12[(0, 1, 2, 4)] = 0.4
        pgm_function12[(0, 1, 2, 5)] = 0.1
        pgm_function12[(0, 1, 3, 0)] = 1.0
        pgm_function12[(0, 1, 3, 1)] = 1.0
        pgm_function12[(0, 1, 3, 2)] = 0.85
        pgm_function12[(0, 1, 3, 3)] = 0.6
        pgm_function12[(0, 1, 3, 4)] = 0.25
        pgm_function12[(0, 1, 3, 5)] = 0.05
        pgm_function12[(0, 2, 0, 0)] = 1.0
        pgm_function12[(0, 2, 0, 1)] = 1.0
        pgm_function12[(0, 2, 0, 2)] = 1.0
        pgm_function12[(0, 2, 0, 3)] = 0.95
        pgm_function12[(0, 2, 0, 4)] = 0.9
        pgm_function12[(0, 2, 0, 5)] = 0.65
        pgm_function12[(0, 2, 0, 6)] = 0.4
        pgm_function12[(0, 2, 0, 7)] = 0.2
        pgm_function12[(0, 2, 0, 8)] = 0.05
        pgm_function12[(0, 2, 1, 0)] = 1.0
        pgm_function12[(0, 2, 1, 1)] = 1.0
        pgm_function12[(0, 2, 1, 2)] = 1.0
        pgm_function12[(0, 2, 1, 3)] = 0.95
        pgm_function12[(0, 2, 1, 4)] = 0.85
        pgm_function12[(0, 2, 1, 5)] = 0.5
        pgm_function12[(0, 2, 1, 6)] = 0.3
        pgm_function12[(0, 2, 1, 7)] = 0.1
        pgm_function12[(0, 2, 2, 0)] = 1.0
        pgm_function12[(0, 2, 2, 1)] = 1.0
        pgm_function12[(0, 2, 2, 2)] = 1.0
        pgm_function12[(0, 2, 2, 3)] = 0.9
        pgm_function12[(0, 2, 2, 4)] = 0.75
        pgm_function12[(0, 2, 2, 5)] = 0.3
        pgm_function12[(0, 2, 2, 6)] = 0.1
        pgm_function12[(0, 2, 3, 0)] = 1.0
        pgm_function12[(0, 2, 3, 1)] = 1.0
        pgm_function12[(0, 2, 3, 2)] = 0.95
        pgm_function12[(0, 2, 3, 3)] = 0.85
        pgm_function12[(0, 2, 3, 4)] = 0.65
        pgm_function12[(0, 2, 3, 5)] = 0.2
        pgm_function12[(0, 2, 3, 6)] = 0.05
        pgm_function12[(0, 3, 0, 0)] = 1.0
        pgm_function12[(0, 3, 0, 1)] = 1.0
        pgm_function12[(0, 3, 0, 2)] = 1.0
        pgm_function12[(0, 3, 0, 3)] = 1.0
        pgm_function12[(0, 3, 0, 4)] = 0.95
        pgm_function12[(0, 3, 0, 5)] = 0.85
        pgm_function12[(0, 3, 0, 6)] = 0.7
        pgm_function12[(0, 3, 0, 7)] = 0.4
        pgm_function12[(0, 3, 0, 8)] = 0.2
        pgm_function12[(0, 3, 1, 0)] = 1.0
        pgm_function12[(0, 3, 1, 1)] = 1.0
        pgm_function12[(0, 3, 1, 2)] = 1.0
        pgm_function12[(0, 3, 1, 3)] = 1.0
        pgm_function12[(0, 3, 1, 4)] = 0.9
        pgm_function12[(0, 3, 1, 5)] = 0.8
        pgm_function12[(0, 3, 1, 6)] = 0.6
        pgm_function12[(0, 3, 1, 7)] = 0.2
        pgm_function12[(0, 3, 1, 8)] = 0.1
        pgm_function12[(0, 3, 2, 0)] = 1.0
        pgm_function12[(0, 3, 2, 1)] = 1.0
        pgm_function12[(0, 3, 2, 2)] = 1.0
        pgm_function12[(0, 3, 2, 3)] = 0.95
        pgm_function12[(0, 3, 2, 4)] = 0.8
        pgm_function12[(0, 3, 2, 5)] = 0.5
        pgm_function12[(0, 3, 2, 6)] = 0.3
        pgm_function12[(0, 3, 2, 7)] = 0.1
        pgm_function12[(0, 3, 2, 8)] = 0.05
        pgm_function12[(0, 3, 3, 0)] = 1.0
        pgm_function12[(0, 3, 3, 1)] = 1.0
        pgm_function12[(0, 3, 3, 2)] = 1.0
        pgm_function12[(0, 3, 3, 3)] = 0.9
        pgm_function12[(0, 3, 3, 4)] = 0.7
        pgm_function12[(0, 3, 3, 5)] = 0.4
        pgm_function12[(0, 3, 3, 6)] = 0.1
        pgm_function12[(0, 3, 3, 7)] = 0.05
        pgm_function12[(1, 0, 0, 1)] = 0.6
        pgm_function12[(1, 0, 0, 2)] = 0.3
        pgm_function12[(1, 0, 0, 3)] = 0.1
        pgm_function12[(1, 0, 0, 4)] = 0.1
        pgm_function12[(1, 0, 1, 1)] = 0.4
        pgm_function12[(1, 0, 1, 2)] = 0.1
        pgm_function12[(1, 0, 1, 3)] = 0.05
        pgm_function12[(1, 0, 2, 0)] = 0.1
        pgm_function12[(1, 0, 2, 1)] = 0.1
        pgm_function12[(1, 0, 2, 2)] = 0.05
        pgm_function12[(1, 0, 3, 0)] = 0.2
        pgm_function12[(1, 0, 3, 1)] = 0.1
        pgm_function12[(1, 1, 0, 2)] = 0.05
        pgm_function12[(1, 1, 0, 3)] = 0.05
        pgm_function12[(1, 1, 0, 4)] = 0.15
        pgm_function12[(1, 1, 0, 5)] = 0.3
        pgm_function12[(1, 1, 0, 6)] = 0.3
        pgm_function12[(1, 1, 0, 7)] = 0.1
        pgm_function12[(1, 1, 0, 8)] = 0.05
        pgm_function12[(1, 1, 1, 2)] = 0.05
        pgm_function12[(1, 1, 1, 3)] = 0.1
        pgm_function12[(1, 1, 1, 4)] = 0.15
        pgm_function12[(1, 1, 1, 5)] = 0.3
        pgm_function12[(1, 1, 1, 6)] = 0.25
        pgm_function12[(1, 1, 1, 7)] = 0.05
        pgm_function12[(1, 1, 2, 2)] = 0.05
        pgm_function12[(1, 1, 2, 3)] = 0.2
        pgm_function12[(1, 1, 2, 4)] = 0.3
        pgm_function12[(1, 1, 2, 5)] = 0.35
        pgm_function12[(1, 1, 2, 6)] = 0.15
        pgm_function12[(1, 1, 3, 2)] = 0.1
        pgm_function12[(1, 1, 3, 3)] = 0.25
        pgm_function12[(1, 1, 3, 4)] = 0.35
        pgm_function12[(1, 1, 3, 5)] = 0.3
        pgm_function12[(1, 1, 3, 6)] = 0.05
        pgm_function12[(1, 2, 0, 3)] = 0.05
        pgm_function12[(1, 2, 0, 4)] = 0.075
        pgm_function12[(1, 2, 0, 5)] = 0.225
        pgm_function12[(1, 2, 0, 6)] = 0.3
        pgm_function12[(1, 2, 0, 7)] = 0.3
        pgm_function12[(1, 2, 0, 8)] = 0.1
        pgm_function12[(1, 2, 1, 3)] = 0.05
        pgm_function12[(1, 2, 1, 4)] = 0.1
        pgm_function12[(1, 2, 1, 5)] = 0.3
        pgm_function12[(1, 2, 1, 6)] = 0.3
        pgm_function12[(1, 2, 1, 7)] = 0.3
        pgm_function12[(1, 2, 1, 8)] = 0.1
        pgm_function12[(1, 2, 2, 3)] = 0.075
        pgm_function12[(1, 2, 2, 4)] = 0.15
        pgm_function12[(1, 2, 2, 5)] = 0.35
        pgm_function12[(1, 2, 2, 6)] = 0.25
        pgm_function12[(1, 2, 2, 7)] = 0.1
        pgm_function12[(1, 2, 3, 2)] = 0.05
        pgm_function12[(1, 2, 3, 3)] = 0.1
        pgm_function12[(1, 2, 3, 4)] = 0.2
        pgm_function12[(1, 2, 3, 5)] = 0.3
        pgm_function12[(1, 2, 3, 6)] = 0.15
        pgm_function12[(1, 2, 3, 7)] = 0.05
        pgm_function12[(1, 3, 0, 4)] = 0.05
        pgm_function12[(1, 3, 0, 5)] = 0.1
        pgm_function12[(1, 3, 0, 6)] = 0.15
        pgm_function12[(1, 3, 0, 7)] = 0.35
        pgm_function12[(1, 3, 0, 8)] = 0.4
        pgm_function12[(1, 3, 1, 4)] = 0.075
        pgm_function12[(1, 3, 1, 5)] = 0.125
        pgm_function12[(1, 3, 1, 6)] = 0.2
        pgm_function12[(1, 3, 1, 7)] = 0.35
        pgm_function12[(1, 3, 1, 8)] = 0.3
        pgm_function12[(1, 3, 2, 3)] = 0.05
        pgm_function12[(1, 3, 2, 4)] = 0.15
        pgm_function12[(1, 3, 2, 5)] = 0.3
        pgm_function12[(1, 3, 2, 6)] = 0.35
        pgm_function12[(1, 3, 2, 7)] = 0.325
        pgm_function12[(1, 3, 2, 8)] = 0.15
        pgm_function12[(1, 3, 3, 3)] = 0.075
        pgm_function12[(1, 3, 3, 4)] = 0.2
        pgm_function12[(1, 3, 3, 5)] = 0.3
        pgm_function12[(1, 3, 3, 6)] = 0.4
        pgm_function12[(1, 3, 3, 7)] = 0.2
        pgm_function12[(1, 3, 3, 8)] = 0.1
        pgm_function12[(2, 0, 0, 1)] = 0.1
        pgm_function12[(2, 0, 0, 2)] = 0.5
        pgm_function12[(2, 0, 0, 3)] = 0.4
        pgm_function12[(2, 0, 0, 4)] = 0.1
        pgm_function12[(2, 0, 0, 5)] = 0.1
        pgm_function12[(2, 0, 1, 1)] = 0.3
        pgm_function12[(2, 0, 1, 2)] = 0.4
        pgm_function12[(2, 0, 1, 3)] = 0.15
        pgm_function12[(2, 0, 1, 4)] = 0.05
        pgm_function12[(2, 0, 2, 1)] = 0.25
        pgm_function12[(2, 0, 2, 2)] = 0.1
        pgm_function12[(2, 0, 2, 3)] = 0.05
        pgm_function12[(2, 0, 3, 0)] = 0.05
        pgm_function12[(2, 0, 3, 1)] = 0.2
        pgm_function12[(2, 0, 3, 2)] = 0.1
        pgm_function12[(2, 1, 0, 4)] = 0.05
        pgm_function12[(2, 1, 0, 5)] = 0.15
        pgm_function12[(2, 1, 0, 6)] = 0.3
        pgm_function12[(2, 1, 0, 7)] = 0.25
        pgm_function12[(2, 1, 0, 8)] = 0.1
        pgm_function12[(2, 1, 1, 4)] = 0.1
        pgm_function12[(2, 1, 1, 5)] = 0.2
        pgm_function12[(2, 1, 1, 6)] = 0.35
        pgm_function12[(2, 1, 1, 7)] = 0.25
        pgm_function12[(2, 1, 1, 8)] = 0.05
        pgm_function12[(2, 1, 2, 3)] = 0.1
        pgm_function12[(2, 1, 2, 4)] = 0.2
        pgm_function12[(2, 1, 2, 5)] = 0.3
        pgm_function12[(2, 1, 2, 6)] = 0.35
        pgm_function12[(2, 1, 2, 7)] = 0.15
        pgm_function12[(2, 1, 3, 2)] = 0.05
        pgm_function12[(2, 1, 3, 3)] = 0.1
        pgm_function12[(2, 1, 3, 4)] = 0.25
        pgm_function12[(2, 1, 3, 5)] = 0.3
        pgm_function12[(2, 1, 3, 6)] = 0.2
        pgm_function12[(2, 1, 3, 7)] = 0.05
        pgm_function12[(2, 2, 0, 4)] = 0.025
        pgm_function12[(2, 2, 0, 5)] = 0.1
        pgm_function12[(2, 2, 0, 6)] = 0.2
        pgm_function12[(2, 2, 0, 7)] = 0.25
        pgm_function12[(2, 2, 0, 8)] = 0.25
        pgm_function12[(2, 2, 1, 4)] = 0.05
        pgm_function12[(2, 2, 1, 5)] = 0.15
        pgm_function12[(2, 2, 1, 6)] = 0.25
        pgm_function12[(2, 2, 1, 7)] = 0.3
        pgm_function12[(2, 2, 1, 8)] = 0.2
        pgm_function12[(2, 2, 2, 3)] = 0.025
        pgm_function12[(2, 2, 2, 4)] = 0.075
        pgm_function12[(2, 2, 2, 5)] = 0.2
        pgm_function12[(2, 2, 2, 6)] = 0.3
        pgm_function12[(2, 2, 2, 7)] = 0.3
        pgm_function12[(2, 2, 2, 8)] = 0.1
        pgm_function12[(2, 2, 3, 3)] = 0.05
        pgm_function12[(2, 2, 3, 4)] = 0.1
        pgm_function12[(2, 2, 3, 5)] = 0.3
        pgm_function12[(2, 2, 3, 6)] = 0.3
        pgm_function12[(2, 2, 3, 7)] = 0.15
        pgm_function12[(2, 2, 3, 8)] = 0.05
        pgm_function12[(2, 3, 0, 5)] = 0.05
        pgm_function12[(2, 3, 0, 6)] = 0.1
        pgm_function12[(2, 3, 0, 7)] = 0.15
        pgm_function12[(2, 3, 0, 8)] = 0.2
        pgm_function12[(2, 3, 1, 4)] = 0.025
        pgm_function12[(2, 3, 1, 5)] = 0.05
        pgm_function12[(2, 3, 1, 6)] = 0.125
        pgm_function12[(2, 3, 1, 7)] = 0.25
        pgm_function12[(2, 3, 1, 8)] = 0.25
        pgm_function12[(2, 3, 2, 4)] = 0.05
        pgm_function12[(2, 3, 2, 5)] = 0.15
        pgm_function12[(2, 3, 2, 6)] = 0.2
        pgm_function12[(2, 3, 2, 7)] = 0.325
        pgm_function12[(2, 3, 2, 8)] = 0.3
        pgm_function12[(2, 3, 3, 3)] = 0.025
        pgm_function12[(2, 3, 3, 4)] = 0.075
        pgm_function12[(2, 3, 3, 5)] = 0.2
        pgm_function12[(2, 3, 3, 6)] = 0.25
        pgm_function12[(2, 3, 3, 7)] = 0.35
        pgm_function12[(2, 3, 3, 8)] = 0.25
        pgm_function12[(3, 0, 0, 2)] = 0.1
        pgm_function12[(3, 0, 0, 3)] = 0.3
        pgm_function12[(3, 0, 0, 4)] = 0.4
        pgm_function12[(3, 0, 0, 5)] = 0.1
        pgm_function12[(3, 0, 0, 6)] = 0.1
        pgm_function12[(3, 0, 1, 1)] = 0.1
        pgm_function12[(3, 0, 1, 2)] = 0.3
        pgm_function12[(3, 0, 1, 3)] = 0.4
        pgm_function12[(3, 0, 1, 4)] = 0.15
        pgm_function12[(3, 0, 1, 5)] = 0.05
        pgm_function12[(3, 0, 2, 1)] = 0.3
        pgm_function12[(3, 0, 2, 2)] = 0.25
        pgm_function12[(3, 0, 2, 3)] = 0.1
        pgm_function12[(3, 0, 2, 4)] = 0.05
        pgm_function12[(3, 0, 3, 1)] = 0.35
        pgm_function12[(3, 0, 3, 2)] = 0.2
        pgm_function12[(3, 0, 3, 3)] = 0.1
        pgm_function12[(3, 1, 0, 5)] = 0.05
        pgm_function12[(3, 1, 0, 6)] = 0.15
        pgm_function12[(3, 1, 0, 7)] = 0.25
        pgm_function12[(3, 1, 0, 8)] = 0.15
        pgm_function12[(3, 1, 1, 5)] = 0.1
        pgm_function12[(3, 1, 1, 6)] = 0.25
        pgm_function12[(3, 1, 1, 7)] = 0.3
        pgm_function12[(3, 1, 1, 8)] = 0.1
        pgm_function12[(3, 1, 2, 4)] = 0.1
        pgm_function12[(3, 1, 2, 5)] = 0.2
        pgm_function12[(3, 1, 2, 6)] = 0.3
        pgm_function12[(3, 1, 2, 7)] = 0.35
        pgm_function12[(3, 1, 2, 8)] = 0.05
        pgm_function12[(3, 1, 3, 3)] = 0.05
        pgm_function12[(3, 1, 3, 4)] = 0.1
        pgm_function12[(3, 1, 3, 5)] = 0.2
        pgm_function12[(3, 1, 3, 6)] = 0.35
        pgm_function12[(3, 1, 3, 7)] = 0.2
        pgm_function12[(3, 1, 3, 8)] = 0.05
        pgm_function12[(3, 2, 0, 5)] = 0.025
        pgm_function12[(3, 2, 0, 6)] = 0.075
        pgm_function12[(3, 2, 0, 7)] = 0.15
        pgm_function12[(3, 2, 0, 8)] = 0.25
        pgm_function12[(3, 2, 1, 5)] = 0.05
        pgm_function12[(3, 2, 1, 6)] = 0.1
        pgm_function12[(3, 2, 1, 7)] = 0.15
        pgm_function12[(3, 2, 1, 8)] = 0.25
        pgm_function12[(3, 2, 2, 4)] = 0.025
        pgm_function12[(3, 2, 2, 5)] = 0.1
        pgm_function12[(3, 2, 2, 6)] = 0.2
        pgm_function12[(3, 2, 2, 7)] = 0.3
        pgm_function12[(3, 2, 2, 8)] = 0.25
        pgm_function12[(3, 2, 3, 4)] = 0.05
        pgm_function12[(3, 2, 3, 5)] = 0.15
        pgm_function12[(3, 2, 3, 6)] = 0.3
        pgm_function12[(3, 2, 3, 7)] = 0.3
        pgm_function12[(3, 2, 3, 8)] = 0.15
        pgm_function12[(3, 3, 0, 6)] = 0.05
        pgm_function12[(3, 3, 0, 7)] = 0.075
        pgm_function12[(3, 3, 0, 8)] = 0.1
        pgm_function12[(3, 3, 1, 5)] = 0.025
        pgm_function12[(3, 3, 1, 6)] = 0.05
        pgm_function12[(3, 3, 1, 7)] = 0.125
        pgm_function12[(3, 3, 1, 8)] = 0.175
        pgm_function12[(3, 3, 2, 5)] = 0.05
        pgm_function12[(3, 3, 2, 6)] = 0.1
        pgm_function12[(3, 3, 2, 7)] = 0.15
        pgm_function12[(3, 3, 2, 8)] = 0.25
        pgm_function12[(3, 3, 3, 4)] = 0.025
        pgm_function12[(3, 3, 3, 5)] = 0.075
        pgm_function12[(3, 3, 3, 6)] = 0.15
        pgm_function12[(3, 3, 3, 7)] = 0.2
        pgm_function12[(3, 3, 3, 8)] = 0.3
        pgm_function12[(4, 0, 0, 3)] = 0.1
        pgm_function12[(4, 0, 0, 4)] = 0.3
        pgm_function12[(4, 0, 0, 5)] = 0.4
        pgm_function12[(4, 0, 0, 6)] = 0.1
        pgm_function12[(4, 0, 0, 7)] = 0.1
        pgm_function12[(4, 0, 1, 2)] = 0.1
        pgm_function12[(4, 0, 1, 3)] = 0.3
        pgm_function12[(4, 0, 1, 4)] = 0.4
        pgm_function12[(4, 0, 1, 5)] = 0.15
        pgm_function12[(4, 0, 1, 6)] = 0.05
        pgm_function12[(4, 0, 1, 7)] = 0.05
        pgm_function12[(4, 0, 2, 1)] = 0.25
        pgm_function12[(4, 0, 2, 2)] = 0.3
        pgm_function12[(4, 0, 2, 3)] = 0.25
        pgm_function12[(4, 0, 2, 4)] = 0.1
        pgm_function12[(4, 0, 2, 5)] = 0.05
        pgm_function12[(4, 0, 3, 1)] = 0.25
        pgm_function12[(4, 0, 3, 2)] = 0.35
        pgm_function12[(4, 0, 3, 3)] = 0.2
        pgm_function12[(4, 0, 3, 4)] = 0.1
        pgm_function12[(4, 1, 0, 6)] = 0.05
        pgm_function12[(4, 1, 0, 7)] = 0.25
        pgm_function12[(4, 1, 0, 8)] = 0.25
        pgm_function12[(4, 1, 1, 6)] = 0.05
        pgm_function12[(4, 1, 1, 7)] = 0.3
        pgm_function12[(4, 1, 1, 8)] = 0.3
        pgm_function12[(4, 1, 2, 5)] = 0.05
        pgm_function12[(4, 1, 2, 6)] = 0.15
        pgm_function12[(4, 1, 2, 7)] = 0.35
        pgm_function12[(4, 1, 2, 8)] = 0.25
        pgm_function12[(4, 1, 3, 4)] = 0.05
        pgm_function12[(4, 1, 3, 5)] = 0.1
        pgm_function12[(4, 1, 3, 6)] = 0.25
        pgm_function12[(4, 1, 3, 7)] = 0.3
        pgm_function12[(4, 1, 3, 8)] = 0.1
        pgm_function12[(4, 2, 0, 6)] = 0.025
        pgm_function12[(4, 2, 0, 7)] = 0.075
        pgm_function12[(4, 2, 0, 8)] = 0.25
        pgm_function12[(4, 2, 1, 6)] = 0.05
        pgm_function12[(4, 2, 1, 7)] = 0.1
        pgm_function12[(4, 2, 1, 8)] = 0.3
        pgm_function12[(4, 2, 2, 5)] = 0.05
        pgm_function12[(4, 2, 2, 6)] = 0.1
        pgm_function12[(4, 2, 2, 7)] = 0.15
        pgm_function12[(4, 2, 2, 8)] = 0.3
        pgm_function12[(4, 2, 3, 5)] = 0.05
        pgm_function12[(4, 2, 3, 6)] = 0.15
        pgm_function12[(4, 2, 3, 7)] = 0.3
        pgm_function12[(4, 2, 3, 8)] = 0.3
        pgm_function12[(4, 3, 0, 7)] = 0.025
        pgm_function12[(4, 3, 0, 8)] = 0.075
        pgm_function12[(4, 3, 1, 6)] = 0.025
        pgm_function12[(4, 3, 1, 7)] = 0.05
        pgm_function12[(4, 3, 1, 8)] = 0.1
        pgm_function12[(4, 3, 2, 6)] = 0.05
        pgm_function12[(4, 3, 2, 7)] = 0.075
        pgm_function12[(4, 3, 2, 8)] = 0.15
        pgm_function12[(4, 3, 3, 5)] = 0.025
        pgm_function12[(4, 3, 3, 6)] = 0.075
        pgm_function12[(4, 3, 3, 7)] = 0.1
        pgm_function12[(4, 3, 3, 8)] = 0.175
        pgm_function12[(5, 0, 0, 4)] = 0.1
        pgm_function12[(5, 0, 0, 5)] = 0.3
        pgm_function12[(5, 0, 0, 6)] = 0.4
        pgm_function12[(5, 0, 0, 7)] = 0.2
        pgm_function12[(5, 0, 0, 8)] = 0.1
        pgm_function12[(5, 0, 1, 3)] = 0.1
        pgm_function12[(5, 0, 1, 4)] = 0.3
        pgm_function12[(5, 0, 1, 5)] = 0.4
        pgm_function12[(5, 0, 1, 6)] = 0.15
        pgm_function12[(5, 0, 1, 7)] = 0.15
        pgm_function12[(5, 0, 1, 8)] = 0.1
        pgm_function12[(5, 0, 2, 1)] = 0.05
        pgm_function12[(5, 0, 2, 2)] = 0.25
        pgm_function12[(5, 0, 2, 3)] = 0.3
        pgm_function12[(5, 0, 2, 4)] = 0.25
        pgm_function12[(5, 0, 2, 5)] = 0.1
        pgm_function12[(5, 0, 2, 6)] = 0.05
        pgm_function12[(5, 0, 3, 1)] = 0.1
        pgm_function12[(5, 0, 3, 2)] = 0.25
        pgm_function12[(5, 0, 3, 3)] = 0.35
        pgm_function12[(5, 0, 3, 4)] = 0.2
        pgm_function12[(5, 0, 3, 5)] = 0.1
        pgm_function12[(5, 1, 0, 7)] = 0.1
        pgm_function12[(5, 1, 0, 8)] = 0.25
        pgm_function12[(5, 1, 1, 7)] = 0.1
        pgm_function12[(5, 1, 1, 8)] = 0.35
        pgm_function12[(5, 1, 2, 6)] = 0.05
        pgm_function12[(5, 1, 2, 7)] = 0.1
        pgm_function12[(5, 1, 2, 8)] = 0.35
        pgm_function12[(5, 1, 3, 5)] = 0.05
        pgm_function12[(5, 1, 3, 6)] = 0.1
        pgm_function12[(5, 1, 3, 7)] = 0.3
        pgm_function12[(5, 1, 3, 8)] = 0.25
        pgm_function12[(5, 2, 0, 7)] = 0.025
        pgm_function12[(5, 2, 0, 8)] = 0.075
        pgm_function12[(5, 2, 1, 7)] = 0.05
        pgm_function12[(5, 2, 1, 8)] = 0.1
        pgm_function12[(5, 2, 2, 6)] = 0.05
        pgm_function12[(5, 2, 2, 7)] = 0.1
        pgm_function12[(5, 2, 2, 8)] = 0.2
        pgm_function12[(5, 2, 3, 6)] = 0.05
        pgm_function12[(5, 2, 3, 7)] = 0.15
        pgm_function12[(5, 2, 3, 8)] = 0.3
        pgm_function12[(5, 3, 0, 8)] = 0.025
        pgm_function12[(5, 3, 1, 7)] = 0.025
        pgm_function12[(5, 3, 1, 8)] = 0.05
        pgm_function12[(5, 3, 2, 7)] = 0.025
        pgm_function12[(5, 3, 2, 8)] = 0.075
        pgm_function12[(5, 3, 3, 6)] = 0.025
        pgm_function12[(5, 3, 3, 7)] = 0.075
        pgm_function12[(5, 3, 3, 8)] = 0.1
        pgm_function12[(6, 0, 0, 5)] = 0.1
        pgm_function12[(6, 0, 0, 6)] = 0.3
        pgm_function12[(6, 0, 0, 7)] = 0.4
        pgm_function12[(6, 0, 0, 8)] = 0.1
        pgm_function12[(6, 0, 1, 4)] = 0.1
        pgm_function12[(6, 0, 1, 5)] = 0.3
        pgm_function12[(6, 0, 1, 6)] = 0.4
        pgm_function12[(6, 0, 1, 7)] = 0.2
        pgm_function12[(6, 0, 1, 8)] = 0.1
        pgm_function12[(6, 0, 2, 2)] = 0.05
        pgm_function12[(6, 0, 2, 3)] = 0.25
        pgm_function12[(6, 0, 2, 4)] = 0.3
        pgm_function12[(6, 0, 2, 5)] = 0.25
        pgm_function12[(6, 0, 2, 6)] = 0.1
        pgm_function12[(6, 0, 2, 7)] = 0.05
        pgm_function12[(6, 0, 3, 2)] = 0.1
        pgm_function12[(6, 0, 3, 3)] = 0.25
        pgm_function12[(6, 0, 3, 4)] = 0.35
        pgm_function12[(6, 0, 3, 5)] = 0.2
        pgm_function12[(6, 0, 3, 6)] = 0.1
        pgm_function12[(6, 1, 0, 8)] = 0.15
        pgm_function12[(6, 1, 1, 8)] = 0.15
        pgm_function12[(6, 1, 2, 7)] = 0.05
        pgm_function12[(6, 1, 2, 8)] = 0.25
        pgm_function12[(6, 1, 3, 6)] = 0.05
        pgm_function12[(6, 1, 3, 7)] = 0.1
        pgm_function12[(6, 1, 3, 8)] = 0.35
        pgm_function12[(6, 2, 0, 8)] = 0.025
        pgm_function12[(6, 2, 1, 8)] = 0.05
        pgm_function12[(6, 2, 2, 7)] = 0.05
        pgm_function12[(6, 2, 2, 8)] = 0.1
        pgm_function12[(6, 2, 3, 7)] = 0.05
        pgm_function12[(6, 2, 3, 8)] = 0.15
        pgm_function12[(6, 3, 1, 8)] = 0.025
        pgm_function12[(6, 3, 2, 8)] = 0.025
        pgm_function12[(6, 3, 3, 7)] = 0.025
        pgm_function12[(6, 3, 3, 8)] = 0.05
        pgm_function12[(7, 0, 0, 6)] = 0.1
        pgm_function12[(7, 0, 0, 7)] = 0.2
        pgm_function12[(7, 0, 0, 8)] = 0.5
        pgm_function12[(7, 0, 1, 5)] = 0.1
        pgm_function12[(7, 0, 1, 6)] = 0.3
        pgm_function12[(7, 0, 1, 7)] = 0.4
        pgm_function12[(7, 0, 1, 8)] = 0.3
        pgm_function12[(7, 0, 2, 3)] = 0.05
        pgm_function12[(7, 0, 2, 4)] = 0.25
        pgm_function12[(7, 0, 2, 5)] = 0.35
        pgm_function12[(7, 0, 2, 6)] = 0.25
        pgm_function12[(7, 0, 2, 7)] = 0.15
        pgm_function12[(7, 0, 2, 8)] = 0.05
        pgm_function12[(7, 0, 3, 3)] = 0.1
        pgm_function12[(7, 0, 3, 4)] = 0.25
        pgm_function12[(7, 0, 3, 5)] = 0.4
        pgm_function12[(7, 0, 3, 6)] = 0.25
        pgm_function12[(7, 0, 3, 7)] = 0.1
        pgm_function12[(7, 0, 3, 8)] = 0.05
        pgm_function12[(7, 1, 0, 8)] = 0.05
        pgm_function12[(7, 1, 1, 8)] = 0.05
        pgm_function12[(7, 1, 2, 8)] = 0.1
        pgm_function12[(7, 1, 3, 7)] = 0.05
        pgm_function12[(7, 1, 3, 8)] = 0.2
        pgm_function12[(7, 2, 2, 8)] = 0.05
        pgm_function12[(7, 2, 3, 8)] = 0.05
        pgm_function12[(7, 3, 3, 8)] = 0.025
        pgm_function12[(8, 0, 0, 7)] = 0.1
        pgm_function12[(8, 0, 0, 8)] = 0.3
        pgm_function12[(8, 0, 1, 6)] = 0.1
        pgm_function12[(8, 0, 1, 7)] = 0.2
        pgm_function12[(8, 0, 1, 8)] = 0.5
        pgm_function12[(8, 0, 2, 4)] = 0.05
        pgm_function12[(8, 0, 2, 5)] = 0.25
        pgm_function12[(8, 0, 2, 6)] = 0.6
        pgm_function12[(8, 0, 2, 7)] = 0.8
        pgm_function12[(8, 0, 2, 8)] = 0.95
        pgm_function12[(8, 0, 3, 4)] = 0.1
        pgm_function12[(8, 0, 3, 5)] = 0.3
        pgm_function12[(8, 0, 3, 6)] = 0.65
        pgm_function12[(8, 0, 3, 7)] = 0.9
        pgm_function12[(8, 0, 3, 8)] = 0.95
        pgm_function12[(8, 1, 3, 8)] = 0.05

        pgm_function13 = pgm_factor13.set_sparse()
        pgm_function13[(0, 0, 0)] = 1.0
        pgm_function13[(0, 0, 1)] = 1.0
        pgm_function13[(0, 0, 2)] = 1.0
        pgm_function13[(0, 0, 3)] = 0.9922
        pgm_function13[(0, 0, 4)] = 0.8378
        pgm_function13[(0, 0, 5)] = 0.492249384
        pgm_function13[(0, 0, 6)] = 0.165583184
        pgm_function13[(0, 0, 7)] = 0.01890191
        pgm_function13[(0, 1, 0)] = 1.0
        pgm_function13[(0, 1, 1)] = 0.9956
        pgm_function13[(0, 1, 2)] = 0.894489698
        pgm_function13[(0, 1, 3)] = 0.616638499
        pgm_function13[(0, 1, 4)] = 0.2767
        pgm_function13[(0, 1, 5)] = 0.0644
        pgm_function13[(0, 1, 6)] = 0.002199781
        pgm_function13[(0, 2, 0)] = 0.8967
        pgm_function13[(0, 2, 1)] = 0.6567
        pgm_function13[(0, 2, 2)] = 0.3089
        pgm_function13[(0, 2, 3)] = 0.08110816
        pgm_function13[(0, 2, 4)] = 0.004400441
        pgm_function13[(0, 3, 0)] = 0.29777033
        pgm_function13[(0, 3, 1)] = 0.0967
        pgm_function13[(0, 3, 2)] = 0.0067
        pgm_function13[(0, 4, 0)] = 0.0056
        pgm_function13[(1, 0, 3)] = 0.0078
        pgm_function13[(1, 0, 4)] = 0.1578
        pgm_function13[(1, 0, 5)] = 0.371137289
        pgm_function13[(1, 0, 6)] = 0.355564395
        pgm_function13[(1, 0, 7)] = 0.17221712
        pgm_function13[(1, 0, 8)] = 0.0267
        pgm_function13[(1, 1, 1)] = 0.0044
        pgm_function13[(1, 1, 2)] = 0.103310081
        pgm_function13[(1, 1, 3)] = 0.295570239
        pgm_function13[(1, 1, 4)] = 0.3678
        pgm_function13[(1, 1, 5)] = 0.2411
        pgm_function13[(1, 1, 6)] = 0.075592439
        pgm_function13[(1, 1, 7)] = 0.004399564
        pgm_function13[(1, 2, 0)] = 0.1033
        pgm_function13[(1, 2, 1)] = 0.2744
        pgm_function13[(1, 2, 2)] = 0.3744
        pgm_function13[(1, 2, 3)] = 0.25782618
        pgm_function13[(1, 2, 4)] = 0.091109124
        pgm_function13[(1, 2, 5)] = 0.006700676
        pgm_function13[(1, 3, 0)] = 0.38556142
        pgm_function13[(1, 3, 1)] = 0.2789
        pgm_function13[(1, 3, 2)] = 0.1078
        pgm_function13[(1, 3, 3)] = 0.0111
        pgm_function13[(1, 4, 0)] = 0.0967
        pgm_function13[(1, 4, 1)] = 0.0156
        pgm_function13[(2, 0, 4)] = 0.0044
        pgm_function13[(2, 0, 5)] = 0.134413105
        pgm_function13[(2, 0, 6)] = 0.362164402
        pgm_function13[(2, 0, 7)] = 0.36223625
        pgm_function13[(2, 0, 8)] = 0.1933
        pgm_function13[(2, 0, 9)] = 0.0344
        pgm_function13[(2, 1, 2)] = 0.002200222
        pgm_function13[(2, 1, 3)] = 0.08669137
        pgm_function13[(2, 1, 4)] = 0.2833
        pgm_function13[(2, 1, 5)] = 0.37
        pgm_function13[(2, 1, 6)] = 0.258874135
        pgm_function13[(2, 1, 7)] = 0.086691373
        pgm_function13[(2, 1, 8)] = 0.0067
        pgm_function13[(2, 2, 1)] = 0.0689
        pgm_function13[(2, 2, 2)] = 0.2611
        pgm_function13[(2, 2, 3)] = 0.37443726
        pgm_function13[(2, 2, 4)] = 0.274427071
        pgm_function13[(2, 2, 5)] = 0.104410097
        pgm_function13[(2, 2, 6)] = 0.01109891
        pgm_function13[(2, 3, 0)] = 0.26557329
        pgm_function13[(2, 3, 1)] = 0.3722
        pgm_function13[(2, 3, 2)] = 0.2944
        pgm_function13[(2, 3, 3)] = 0.1211
        pgm_function13[(2, 3, 4)] = 0.0156
        pgm_function13[(2, 4, 0)] = 0.3
        pgm_function13[(2, 4, 1)] = 0.1378
        pgm_function13[(2, 4, 2)] = 0.0211
        pgm_function13[(2, 5, 0)] = 0.016698319
        pgm_function13[(3, 0, 5)] = 0.002200222
        pgm_function13[(3, 0, 6)] = 0.115588128
        pgm_function13[(3, 0, 7)] = 0.35223525
        pgm_function13[(3, 0, 8)] = 0.3667
        pgm_function13[(3, 0, 9)] = 0.21
        pgm_function13[(3, 0, 10)] = 0.0433
        pgm_function13[(3, 1, 3)] = 0.001099891
        pgm_function13[(3, 1, 4)] = 0.0722
        pgm_function13[(3, 1, 5)] = 0.2667
        pgm_function13[(3, 1, 6)] = 0.368863192
        pgm_function13[(3, 1, 7)] = 0.275572231
        pgm_function13[(3, 1, 8)] = 0.1011
        pgm_function13[(3, 1, 9)] = 0.01000101
        pgm_function13[(3, 2, 2)] = 0.0556
        pgm_function13[(3, 2, 3)] = 0.24442417
        pgm_function13[(3, 2, 4)] = 0.368937096
        pgm_function13[(3, 2, 5)] = 0.293329273
        pgm_function13[(3, 2, 6)] = 0.11668812
        pgm_function13[(3, 2, 7)] = 0.0156
        pgm_function13[(3, 3, 0)] = 0.05109496
        pgm_function13[(3, 3, 1)] = 0.22
        pgm_function13[(3, 3, 2)] = 0.3678
        pgm_function13[(3, 3, 3)] = 0.3056
        pgm_function13[(3, 3, 4)] = 0.1378
        pgm_function13[(3, 3, 5)] = 0.019998016
        pgm_function13[(3, 4, 0)] = 0.3722
        pgm_function13[(3, 4, 1)] = 0.3278
        pgm_function13[(3, 4, 2)] = 0.1544
        pgm_function13[(3, 4, 3)] = 0.028902919
        pgm_function13[(3, 5, 0)] = 0.15778418
        pgm_function13[(3, 5, 1)] = 0.03669633
        pgm_function13[(4, 0, 6)] = 0.001099891
        pgm_function13[(4, 0, 7)] = 0.09440947
        pgm_function13[(4, 0, 8)] = 0.3389
        pgm_function13[(4, 0, 9)] = 0.3811
        pgm_function13[(4, 0, 10)] = 0.2256
        pgm_function13[(4, 0, 11)] = 0.05220523
        pgm_function13[(4, 1, 5)] = 0.0578
        pgm_function13[(4, 1, 6)] = 0.247775129
        pgm_function13[(4, 1, 7)] = 0.367763309
        pgm_function13[(4, 1, 8)] = 0.29
        pgm_function13[(4, 1, 9)] = 0.11441107
        pgm_function13[(4, 1, 10)] = 0.0155969
        pgm_function13[(4, 2, 3)] = 0.04220423
        pgm_function13[(4, 2, 4)] = 0.22892306
        pgm_function13[(4, 2, 5)] = 0.362236337
        pgm_function13[(4, 2, 6)] = 0.30776931
        pgm_function13[(4, 2, 7)] = 0.1322
        pgm_function13[(4, 2, 8)] = 0.02
        pgm_function13[(4, 3, 1)] = 0.0322
        pgm_function13[(4, 3, 2)] = 0.1989
        pgm_function13[(4, 3, 3)] = 0.3622
        pgm_function13[(4, 3, 4)] = 0.3189
        pgm_function13[(4, 3, 5)] = 0.151085118
        pgm_function13[(4, 3, 6)] = 0.027802821
        pgm_function13[(4, 4, 0)] = 0.2033
        pgm_function13[(4, 4, 1)] = 0.3522
        pgm_function13[(4, 4, 2)] = 0.3367
        pgm_function13[(4, 4, 3)] = 0.171117113
        pgm_function13[(4, 4, 4)] = 0.035596429
        pgm_function13[(4, 5, 0)] = 0.335566383
        pgm_function13[(4, 5, 1)] = 0.191081157
        pgm_function13[(4, 5, 2)] = 0.0456
        pgm_function13[(4, 5, 3)] = 0.001099891
        pgm_function13[(4, 6, 0)] = 0.0378
        pgm_function13[(4, 6, 1)] = 0.0022
        pgm_function13[(5, 0, 8)] = 0.0744
        pgm_function13[(5, 0, 9)] = 0.3167
        pgm_function13[(5, 0, 10)] = 0.39
        pgm_function13[(5, 0, 11)] = 0.25002515
        pgm_function13[(5, 0, 12)] = 0.06220622
        pgm_function13[(5, 1, 6)] = 0.046695324
        pgm_function13[(5, 1, 7)] = 0.228877192
        pgm_function13[(5, 1, 8)] = 0.3644
        pgm_function13[(5, 1, 9)] = 0.30563118
        pgm_function13[(5, 1, 10)] = 0.12887396
        pgm_function13[(5, 1, 11)] = 0.02
        pgm_function13[(5, 2, 4)] = 0.032203208
        pgm_function13[(5, 2, 5)] = 0.208921194
        pgm_function13[(5, 2, 6)] = 0.35776436
        pgm_function13[(5, 2, 7)] = 0.3211
        pgm_function13[(5, 2, 8)] = 0.1467
        pgm_function13[(5, 2, 9)] = 0.0278
        pgm_function13[(5, 3, 2)] = 0.0244
        pgm_function13[(5, 3, 3)] = 0.1822
        pgm_function13[(5, 3, 4)] = 0.3522
        pgm_function13[(5, 3, 5)] = 0.335566262
        pgm_function13[(5, 3, 6)] = 0.168917128
        pgm_function13[(5, 3, 7)] = 0.034406881
        pgm_function13[(5, 4, 0)] = 0.0222
        pgm_function13[(5, 4, 1)] = 0.1544
        pgm_function13[(5, 4, 2)] = 0.3422
        pgm_function13[(5, 4, 3)] = 0.343334227
        pgm_function13[(5, 4, 4)] = 0.188881155
        pgm_function13[(5, 4, 5)] = 0.0444
        pgm_function13[(5, 5, 0)] = 0.347765396
        pgm_function13[(5, 5, 1)] = 0.355564292
        pgm_function13[(5, 5, 2)] = 0.2089
        pgm_function13[(5, 5, 3)] = 0.055594439
        pgm_function13[(5, 5, 4)] = 0.0022
        pgm_function13[(5, 6, 0)] = 0.2078
        pgm_function13[(5, 6, 1)] = 0.0656
        pgm_function13[(5, 6, 2)] = 0.004400442
        pgm_function13[(6, 0, 9)] = 0.0578
        pgm_function13[(6, 0, 10)] = 0.3
        pgm_function13[(6, 0, 11)] = 0.38333823
        pgm_function13[(6, 0, 12)] = 0.27222711
        pgm_function13[(6, 0, 13)] = 0.07779225
        pgm_function13[(6, 1, 7)] = 0.036696331
        pgm_function13[(6, 1, 8)] = 0.2078
        pgm_function13[(6, 1, 9)] = 0.36223622
        pgm_function13[(6, 1, 10)] = 0.31553691
        pgm_function13[(6, 1, 11)] = 0.1444
        pgm_function13[(6, 1, 12)] = 0.0267
        pgm_function13[(6, 2, 5)] = 0.024402423
        pgm_function13[(6, 2, 6)] = 0.18778119
        pgm_function13[(6, 2, 7)] = 0.3489
        pgm_function13[(6, 2, 8)] = 0.3344
        pgm_function13[(6, 2, 9)] = 0.1644
        pgm_function13[(6, 2, 10)] = 0.034403406
        pgm_function13[(6, 3, 3)] = 0.0178
        pgm_function13[(6, 3, 4)] = 0.1633
        pgm_function13[(6, 3, 5)] = 0.339966265
        pgm_function13[(6, 3, 6)] = 0.344434262
        pgm_function13[(6, 3, 7)] = 0.184436897
        pgm_function13[(6, 3, 8)] = 0.04330431
        pgm_function13[(6, 4, 1)] = 0.0122
        pgm_function13[(6, 4, 2)] = 0.1378
        pgm_function13[(6, 4, 3)] = 0.331133219
        pgm_function13[(6, 4, 4)] = 0.351065288
        pgm_function13[(6, 4, 5)] = 0.2067
        pgm_function13[(6, 4, 6)] = 0.0533
        pgm_function13[(6, 4, 7)] = 0.002200221
        pgm_function13[(6, 5, 0)] = 0.137786157
        pgm_function13[(6, 5, 1)] = 0.315568259
        pgm_function13[(6, 5, 2)] = 0.3611
        pgm_function13[(6, 5, 3)] = 0.226677161
        pgm_function13[(6, 5, 4)] = 0.0633
        pgm_function13[(6, 5, 5)] = 0.004400442
        pgm_function13[(6, 6, 0)] = 0.3722
        pgm_function13[(6, 6, 1)] = 0.2478
        pgm_function13[(6, 6, 2)] = 0.077807844
        pgm_function13[(6, 6, 3)] = 0.006699336
        pgm_function13[(6, 7, 0)] = 0.0722
        pgm_function13[(6, 7, 1)] = 0.009999014
        pgm_function13[(7, 0, 10)] = 0.0411
        pgm_function13[(7, 0, 11)] = 0.28222817
        pgm_function13[(7, 0, 12)] = 0.39113916
        pgm_function13[(7, 0, 13)] = 0.28887117
        pgm_function13[(7, 0, 14)] = 0.0956
        pgm_function13[(7, 1, 8)] = 0.03
        pgm_function13[(7, 1, 9)] = 0.18331811
        pgm_function13[(7, 1, 10)] = 0.35662889
        pgm_function13[(7, 1, 11)] = 0.3278
        pgm_function13[(7, 1, 12)] = 0.1622
        pgm_function13[(7, 1, 13)] = 0.034403406
        pgm_function13[(7, 2, 6)] = 0.01889812
        pgm_function13[(7, 2, 7)] = 0.1678
        pgm_function13[(7, 2, 8)] = 0.3411
        pgm_function13[(7, 2, 9)] = 0.3422
        pgm_function13[(7, 2, 10)] = 0.181118029
        pgm_function13[(7, 2, 11)] = 0.0433043
        pgm_function13[(7, 3, 4)] = 0.0122
        pgm_function13[(7, 3, 5)] = 0.145585114
        pgm_function13[(7, 3, 6)] = 0.324432247
        pgm_function13[(7, 3, 7)] = 0.353370802
        pgm_function13[(7, 3, 8)] = 0.20222004
        pgm_function13[(7, 3, 9)] = 0.052205236
        pgm_function13[(7, 3, 10)] = 0.0022
        pgm_function13[(7, 4, 2)] = 0.0078
        pgm_function13[(7, 4, 3)] = 0.12111208
        pgm_function13[(7, 4, 4)] = 0.31666826
        pgm_function13[(7, 4, 5)] = 0.36
        pgm_function13[(7, 4, 6)] = 0.2256
        pgm_function13[(7, 4, 7)] = 0.061106123
        pgm_function13[(7, 4, 8)] = 0.004400441
        pgm_function13[(7, 5, 0)] = 0.004399565
        pgm_function13[(7, 5, 1)] = 0.098890181
        pgm_function13[(7, 5, 2)] = 0.3011
        pgm_function13[(7, 5, 3)] = 0.361064256
        pgm_function13[(7, 5, 4)] = 0.2467
        pgm_function13[(7, 5, 5)] = 0.074407434
        pgm_function13[(7, 5, 6)] = 0.00669933
        pgm_function13[(7, 6, 0)] = 0.3033
        pgm_function13[(7, 6, 1)] = 0.3689
        pgm_function13[(7, 6, 2)] = 0.264426148
        pgm_function13[(7, 6, 3)] = 0.089991078
        pgm_function13[(7, 6, 4)] = 0.01000101
        pgm_function13[(7, 7, 0)] = 0.2711
        pgm_function13[(7, 7, 1)] = 0.106689149
        pgm_function13[(7, 7, 2)] = 0.01330131
        pgm_function13[(7, 8, 0)] = 0.007799228
        pgm_function13[(8, 0, 11)] = 0.03220322
        pgm_function13[(8, 0, 12)] = 0.2500251
        pgm_function13[(8, 0, 13)] = 0.39666024
        pgm_function13[(8, 0, 14)] = 0.3033
        pgm_function13[(8, 0, 15)] = 0.1133
        pgm_function13[(8, 0, 16)] = 0.005598881
        pgm_function13[(8, 1, 9)] = 0.02440241
        pgm_function13[(8, 1, 10)] = 0.16556695
        pgm_function13[(8, 1, 11)] = 0.3456
        pgm_function13[(8, 1, 12)] = 0.3344
        pgm_function13[(8, 1, 13)] = 0.177818028
        pgm_function13[(8, 1, 14)] = 0.043304321
        pgm_function13[(8, 2, 7)] = 0.0144
        pgm_function13[(8, 2, 8)] = 0.1467
        pgm_function13[(8, 2, 9)] = 0.33
        pgm_function13[(8, 2, 10)] = 0.347835056
        pgm_function13[(8, 2, 11)] = 0.19892002
        pgm_function13[(8, 2, 12)] = 0.052205226
        pgm_function13[(8, 2, 13)] = 0.002199782
        pgm_function13[(8, 3, 5)] = 0.007799226
        pgm_function13[(8, 3, 6)] = 0.130013099
        pgm_function13[(8, 3, 7)] = 0.313362825
        pgm_function13[(8, 3, 8)] = 0.36113607
        pgm_function13[(8, 3, 9)] = 0.220022152
        pgm_function13[(8, 3, 10)] = 0.0611
        pgm_function13[(8, 3, 11)] = 0.004400881
        pgm_function13[(8, 4, 3)] = 0.004400443
        pgm_function13[(8, 4, 4)] = 0.105589087
        pgm_function13[(8, 4, 5)] = 0.2978
        pgm_function13[(8, 4, 6)] = 0.3633
        pgm_function13[(8, 4, 7)] = 0.243324092
        pgm_function13[(8, 4, 8)] = 0.072207212
        pgm_function13[(8, 4, 9)] = 0.006700676
        pgm_function13[(8, 5, 1)] = 0.002199782
        pgm_function13[(8, 5, 2)] = 0.0822
        pgm_function13[(8, 5, 3)] = 0.285571203
        pgm_function13[(8, 5, 4)] = 0.3644
        pgm_function13[(8, 5, 5)] = 0.262226121
        pgm_function13[(8, 5, 6)] = 0.08669131
        pgm_function13[(8, 5, 7)] = 0.01
        pgm_function13[(8, 6, 0)] = 0.0789
        pgm_function13[(8, 6, 1)] = 0.2611
        pgm_function13[(8, 6, 2)] = 0.366737205
        pgm_function13[(8, 6, 3)] = 0.277772242
        pgm_function13[(8, 6, 4)] = 0.10331014
        pgm_function13[(8, 6, 5)] = 0.0133
        pgm_function13[(8, 7, 0)] = 0.3722
        pgm_function13[(8, 7, 1)] = 0.295570414
        pgm_function13[(8, 7, 2)] = 0.12331211
        pgm_function13[(8, 7, 3)] = 0.0178
        pgm_function13[(8, 8, 0)] = 0.119988118
        pgm_function13[(8, 8, 1)] = 0.0233
        pgm_function13[(9, 0, 12)] = 0.02440241
        pgm_function13[(9, 0, 13)] = 0.21887813
        pgm_function13[(9, 0, 14)] = 0.3878
        pgm_function13[(9, 0, 15)] = 0.3222
        pgm_function13[(9, 0, 16)] = 0.12667503
        pgm_function13[(9, 0, 17)] = 0.0122
        pgm_function13[(9, 1, 10)] = 0.01779639
        pgm_function13[(9, 1, 11)] = 0.15
        pgm_function13[(9, 1, 12)] = 0.3356
        pgm_function13[(9, 1, 13)] = 0.343334055
        pgm_function13[(9, 1, 14)] = 0.193319093
        pgm_function13[(9, 1, 15)] = 0.0522
        pgm_function13[(9, 1, 16)] = 0.001100111
        pgm_function13[(9, 2, 8)] = 0.0111
        pgm_function13[(9, 2, 9)] = 0.1278
        pgm_function13[(9, 2, 10)] = 0.321132051
        pgm_function13[(9, 2, 11)] = 0.35223503
        pgm_function13[(9, 2, 12)] = 0.217822107
        pgm_function13[(9, 2, 13)] = 0.059994067
        pgm_function13[(9, 2, 14)] = 0.0044
        pgm_function13[(9, 3, 6)] = 0.004400443
        pgm_function13[(9, 3, 7)] = 0.111121938
        pgm_function13[(9, 3, 8)] = 0.29783005
        pgm_function13[(9, 3, 9)] = 0.363336251
        pgm_function13[(9, 3, 10)] = 0.2389
        pgm_function13[(9, 3, 11)] = 0.071114216
        pgm_function13[(9, 3, 12)] = 0.0067
        pgm_function13[(9, 4, 4)] = 0.002199782
        pgm_function13[(9, 4, 5)] = 0.09
        pgm_function13[(9, 4, 6)] = 0.2811
        pgm_function13[(9, 4, 7)] = 0.36893714
        pgm_function13[(9, 4, 8)] = 0.256726041
        pgm_function13[(9, 4, 9)] = 0.083308377
        pgm_function13[(9, 4, 10)] = 0.01
        pgm_function13[(9, 5, 2)] = 0.0011
        pgm_function13[(9, 5, 3)] = 0.06999305
        pgm_function13[(9, 5, 4)] = 0.2656
        pgm_function13[(9, 5, 5)] = 0.367837169
        pgm_function13[(9, 5, 6)] = 0.27557202
        pgm_function13[(9, 5, 7)] = 0.1
        pgm_function13[(9, 5, 8)] = 0.0133
        pgm_function13[(9, 6, 1)] = 0.0544
        pgm_function13[(9, 6, 2)] = 0.244424137
        pgm_function13[(9, 6, 3)] = 0.36776332
        pgm_function13[(9, 6, 4)] = 0.29442941
        pgm_function13[(9, 6, 5)] = 0.1178
        pgm_function13[(9, 6, 6)] = 0.01780181
        pgm_function13[(9, 7, 0)] = 0.2456
        pgm_function13[(9, 7, 1)] = 0.366663513
        pgm_function13[(9, 7, 2)] = 0.30443027
        pgm_function13[(9, 7, 3)] = 0.1411
        pgm_function13[(9, 7, 4)] = 0.023297725
        pgm_function13[(9, 8, 0)] = 0.306669301
        pgm_function13[(9, 8, 1)] = 0.16
        pgm_function13[(9, 8, 2)] = 0.03
        pgm_function13[(9, 9, 0)] = 0.026697325
        pgm_function13[(10, 0, 13)] = 0.01779821
        pgm_function13[(10, 0, 14)] = 0.2011
        pgm_function13[(10, 0, 15)] = 0.3778
        pgm_function13[(10, 0, 16)] = 0.337732081
        pgm_function13[(10, 0, 17)] = 0.1389
        pgm_function13[(10, 0, 18)] = 0.0189
        pgm_function13[(10, 1, 11)] = 0.0122
        pgm_function13[(10, 1, 12)] = 0.1333
        pgm_function13[(10, 1, 13)] = 0.323332052
        pgm_function13[(10, 1, 14)] = 0.352235169
        pgm_function13[(10, 1, 15)] = 0.21
        pgm_function13[(10, 1, 16)] = 0.061106129
        pgm_function13[(10, 1, 17)] = 0.0044
        pgm_function13[(10, 2, 9)] = 0.0078
        pgm_function13[(10, 2, 10)] = 0.111111018
        pgm_function13[(10, 2, 11)] = 0.30893102
        pgm_function13[(10, 2, 12)] = 0.353335173
        pgm_function13[(10, 2, 13)] = 0.236676265
        pgm_function13[(10, 2, 14)] = 0.07
        pgm_function13[(10, 2, 15)] = 0.006699332
        pgm_function13[(10, 3, 7)] = 0.003300658
        pgm_function13[(10, 3, 8)] = 0.09330932
        pgm_function13[(10, 3, 9)] = 0.283328195
        pgm_function13[(10, 3, 10)] = 0.3633
        pgm_function13[(10, 3, 11)] = 0.254451056
        pgm_function13[(10, 3, 12)] = 0.0833
        pgm_function13[(10, 3, 13)] = 0.01
        pgm_function13[(10, 4, 5)] = 0.0011
        pgm_function13[(10, 4, 6)] = 0.0767
        pgm_function13[(10, 4, 7)] = 0.261126099
        pgm_function13[(10, 4, 8)] = 0.37223706
        pgm_function13[(10, 4, 9)] = 0.274427255
        pgm_function13[(10, 4, 10)] = 0.0978
        pgm_function13[(10, 4, 11)] = 0.0133013
        pgm_function13[(10, 5, 4)] = 0.0578
        pgm_function13[(10, 5, 5)] = 0.244424112
        pgm_function13[(10, 5, 6)] = 0.36996303
        pgm_function13[(10, 5, 7)] = 0.29
        pgm_function13[(10, 5, 8)] = 0.1156
        pgm_function13[(10, 5, 9)] = 0.0178
        pgm_function13[(10, 6, 2)] = 0.042204224
        pgm_function13[(10, 6, 3)] = 0.225577196
        pgm_function13[(10, 6, 4)] = 0.36223651
        pgm_function13[(10, 6, 5)] = 0.3056
        pgm_function13[(10, 6, 6)] = 0.13671411
        pgm_function13[(10, 6, 7)] = 0.0222
        pgm_function13[(10, 7, 0)] = 0.0389
        pgm_function13[(10, 7, 1)] = 0.196680275
        pgm_function13[(10, 7, 2)] = 0.36223633
        pgm_function13[(10, 7, 3)] = 0.3156
        pgm_function13[(10, 7, 4)] = 0.155584168
        pgm_function13[(10, 7, 5)] = 0.0289
        pgm_function13[(10, 8, 0)] = 0.36776336
        pgm_function13[(10, 8, 1)] = 0.3289
        pgm_function13[(10, 8, 2)] = 0.1767
        pgm_function13[(10, 8, 3)] = 0.0378
        pgm_function13[(10, 9, 0)] = 0.171083157
        pgm_function13[(10, 9, 1)] = 0.0467
        pgm_function13[(10, 9, 2)] = 0.001099891
        pgm_function13[(11, 0, 14)] = 0.0122
        pgm_function13[(11, 0, 15)] = 0.1778
        pgm_function13[(11, 0, 16)] = 0.365527088
        pgm_function13[(11, 0, 17)] = 0.3511
        pgm_function13[(11, 0, 18)] = 0.1578
        pgm_function13[(11, 0, 19)] = 0.026697319
        pgm_function13[(11, 1, 12)] = 0.0078
        pgm_function13[(11, 1, 13)] = 0.116712019
        pgm_function13[(11, 1, 14)] = 0.306731147
        pgm_function13[(11, 1, 15)] = 0.3578
        pgm_function13[(11, 1, 16)] = 0.227823109
        pgm_function13[(11, 1, 17)] = 0.07
        pgm_function13[(11, 1, 18)] = 0.006699334
        pgm_function13[(11, 2, 10)] = 0.004400441
        pgm_function13[(11, 2, 11)] = 0.09440941
        pgm_function13[(11, 2, 12)] = 0.293329144
        pgm_function13[(11, 2, 13)] = 0.356664399
        pgm_function13[(11, 2, 14)] = 0.2511
        pgm_function13[(11, 2, 15)] = 0.08109193
        pgm_function13[(11, 2, 16)] = 0.009999011
        pgm_function13[(11, 3, 8)] = 0.00220022
        pgm_function13[(11, 3, 9)] = 0.080008055
        pgm_function13[(11, 3, 10)] = 0.2689
        pgm_function13[(11, 3, 11)] = 0.36227208
        pgm_function13[(11, 3, 12)] = 0.2711
        pgm_function13[(11, 3, 13)] = 0.0944
        pgm_function13[(11, 3, 14)] = 0.01329871
        pgm_function13[(11, 4, 7)] = 0.063306324
        pgm_function13[(11, 4, 8)] = 0.242224039
        pgm_function13[(11, 4, 9)] = 0.371137345
        pgm_function13[(11, 4, 10)] = 0.2867
        pgm_function13[(11, 4, 11)] = 0.11331103
        pgm_function13[(11, 4, 12)] = 0.0178
        pgm_function13[(11, 5, 5)] = 0.046704721
        pgm_function13[(11, 5, 6)] = 0.22437802
        pgm_function13[(11, 5, 7)] = 0.3678
        pgm_function13[(11, 5, 8)] = 0.3
        pgm_function13[(11, 5, 9)] = 0.1333
        pgm_function13[(11, 5, 10)] = 0.0222
        pgm_function13[(11, 6, 3)] = 0.032196828
        pgm_function13[(11, 6, 4)] = 0.20442029
        pgm_function13[(11, 6, 5)] = 0.3589
        pgm_function13[(11, 6, 6)] = 0.31443125
        pgm_function13[(11, 6, 7)] = 0.1533
        pgm_function13[(11, 6, 8)] = 0.028897116
        pgm_function13[(11, 7, 1)] = 0.024397634
        pgm_function13[(11, 7, 2)] = 0.17891816
        pgm_function13[(11, 7, 3)] = 0.3522
        pgm_function13[(11, 7, 4)] = 0.328867355
        pgm_function13[(11, 7, 5)] = 0.1744
        pgm_function13[(11, 7, 6)] = 0.0356
        pgm_function13[(11, 8, 0)] = 0.185581182
        pgm_function13[(11, 8, 1)] = 0.3422
        pgm_function13[(11, 8, 2)] = 0.3411
        pgm_function13[(11, 8, 3)] = 0.1944
        pgm_function13[(11, 8, 4)] = 0.0467
        pgm_function13[(11, 8, 5)] = 0.0011
        pgm_function13[(11, 9, 0)] = 0.345565318
        pgm_function13[(11, 9, 1)] = 0.2144
        pgm_function13[(11, 9, 2)] = 0.056694352
        pgm_function13[(11, 9, 3)] = 0.0022
        pgm_function13[(11, 10, 0)] = 0.05220522
        pgm_function13[(11, 10, 1)] = 0.00440044
        pgm_function13[(12, 0, 15)] = 0.0089
        pgm_function13[(12, 0, 16)] = 0.158868038
        pgm_function13[(12, 0, 17)] = 0.3578
        pgm_function13[(12, 0, 18)] = 0.3589
        pgm_function13[(12, 0, 19)] = 0.176682125
        pgm_function13[(12, 0, 20)] = 0.0344
        pgm_function13[(12, 1, 13)] = 0.004400441
        pgm_function13[(12, 1, 14)] = 0.102210049
        pgm_function13[(12, 1, 15)] = 0.2922
        pgm_function13[(12, 1, 16)] = 0.362236174
        pgm_function13[(12, 1, 17)] = 0.2422
        pgm_function13[(12, 1, 18)] = 0.079992046
        pgm_function13[(12, 1, 19)] = 0.01000101
        pgm_function13[(12, 2, 11)] = 0.00220022
        pgm_function13[(12, 2, 12)] = 0.08220824
        pgm_function13[(12, 2, 13)] = 0.275572309
        pgm_function13[(12, 2, 14)] = 0.3611
        pgm_function13[(12, 2, 15)] = 0.266673099
        pgm_function13[(12, 2, 16)] = 0.094390704
        pgm_function13[(12, 2, 17)] = 0.0133
        pgm_function13[(12, 3, 9)] = 0.001100111
        pgm_function13[(12, 3, 10)] = 0.0656
        pgm_function13[(12, 3, 11)] = 0.254451056
        pgm_function13[(12, 3, 12)] = 0.3622
        pgm_function13[(12, 3, 13)] = 0.2867
        pgm_function13[(12, 3, 14)] = 0.10998911
        pgm_function13[(12, 3, 15)] = 0.0178
        pgm_function13[(12, 4, 8)] = 0.052205208
        pgm_function13[(12, 4, 9)] = 0.223322208
        pgm_function13[(12, 4, 10)] = 0.3644
        pgm_function13[(12, 4, 11)] = 0.29783009
        pgm_function13[(12, 4, 12)] = 0.1289
        pgm_function13[(12, 4, 13)] = 0.0222
        pgm_function13[(12, 5, 6)] = 0.0366963
        pgm_function13[(12, 5, 7)] = 0.2022
        pgm_function13[(12, 5, 8)] = 0.3656
        pgm_function13[(12, 5, 9)] = 0.3089
        pgm_function13[(12, 5, 10)] = 0.1511
        pgm_function13[(12, 5, 11)] = 0.0289
        pgm_function13[(12, 6, 4)] = 0.02560264
        pgm_function13[(12, 6, 5)] = 0.1844
        pgm_function13[(12, 6, 6)] = 0.35333528
        pgm_function13[(12, 6, 7)] = 0.3256
        pgm_function13[(12, 6, 8)] = 0.169983097
        pgm_function13[(12, 6, 9)] = 0.0356
        pgm_function13[(12, 7, 2)] = 0.01780182
        pgm_function13[(12, 7, 3)] = 0.1611
        pgm_function13[(12, 7, 4)] = 0.338866366
        pgm_function13[(12, 7, 5)] = 0.3422
        pgm_function13[(12, 7, 6)] = 0.1911
        pgm_function13[(12, 7, 7)] = 0.0444
        pgm_function13[(12, 7, 8)] = 0.001100111
        pgm_function13[(12, 8, 0)] = 0.012198812
        pgm_function13[(12, 8, 1)] = 0.1378
        pgm_function13[(12, 8, 2)] = 0.3267
        pgm_function13[(12, 8, 3)] = 0.3489
        pgm_function13[(12, 8, 4)] = 0.21
        pgm_function13[(12, 8, 5)] = 0.0556
        pgm_function13[(12, 8, 6)] = 0.0022
        pgm_function13[(12, 9, 0)] = 0.338866312
        pgm_function13[(12, 9, 1)] = 0.3567
        pgm_function13[(12, 9, 2)] = 0.228877208
        pgm_function13[(12, 9, 3)] = 0.0689
        pgm_function13[(12, 9, 4)] = 0.0044
        pgm_function13[(12, 10, 0)] = 0.23112309
        pgm_function13[(12, 10, 1)] = 0.0833083
        pgm_function13[(12, 10, 2)] = 0.0067
        pgm_function13[(12, 11, 0)] = 0.005599445
        pgm_function13[(13, 0, 16)] = 0.005598881
        pgm_function13[(13, 0, 17)] = 0.1356
        pgm_function13[(13, 0, 18)] = 0.35
        pgm_function13[(13, 0, 19)] = 0.361064256
        pgm_function13[(13, 0, 20)] = 0.1978
        pgm_function13[(13, 0, 21)] = 0.0433
        pgm_function13[(13, 1, 14)] = 0.002200221
        pgm_function13[(13, 1, 15)] = 0.0867
        pgm_function13[(13, 1, 16)] = 0.274427132
        pgm_function13[(13, 1, 17)] = 0.3667
        pgm_function13[(13, 1, 18)] = 0.258874148
        pgm_function13[(13, 1, 19)] = 0.0911092
        pgm_function13[(13, 1, 20)] = 0.01330131
        pgm_function13[(13, 2, 12)] = 0.001100111
        pgm_function13[(13, 2, 13)] = 0.068893177
        pgm_function13[(13, 2, 14)] = 0.2556
        pgm_function13[(13, 2, 15)] = 0.364364135
        pgm_function13[(13, 2, 16)] = 0.276672304
        pgm_function13[(13, 2, 17)] = 0.11
        pgm_function13[(13, 2, 18)] = 0.0178
        pgm_function13[(13, 3, 11)] = 0.053310712
        pgm_function13[(13, 3, 12)] = 0.2356
        pgm_function13[(13, 3, 13)] = 0.3578
        pgm_function13[(13, 3, 14)] = 0.2977703
        pgm_function13[(13, 3, 15)] = 0.1256
        pgm_function13[(13, 3, 16)] = 0.02219782
        pgm_function13[(13, 4, 9)] = 0.041104138
        pgm_function13[(13, 4, 10)] = 0.2089
        pgm_function13[(13, 4, 11)] = 0.36113611
        pgm_function13[(13, 4, 12)] = 0.3089
        pgm_function13[(13, 4, 13)] = 0.1478
        pgm_function13[(13, 4, 14)] = 0.0289
        pgm_function13[(13, 5, 7)] = 0.03
        pgm_function13[(13, 5, 8)] = 0.1822
        pgm_function13[(13, 5, 9)] = 0.3589
        pgm_function13[(13, 5, 10)] = 0.3189
        pgm_function13[(13, 5, 11)] = 0.1678
        pgm_function13[(13, 5, 12)] = 0.0356
        pgm_function13[(13, 6, 5)] = 0.02
        pgm_function13[(13, 6, 6)] = 0.16331613
        pgm_function13[(13, 6, 7)] = 0.3422
        pgm_function13[(13, 6, 8)] = 0.335566191
        pgm_function13[(13, 6, 9)] = 0.1889
        pgm_function13[(13, 6, 10)] = 0.04440443
        pgm_function13[(13, 6, 11)] = 0.0011
        pgm_function13[(13, 7, 3)] = 0.0122
        pgm_function13[(13, 7, 4)] = 0.145585157
        pgm_function13[(13, 7, 5)] = 0.3222
        pgm_function13[(13, 7, 6)] = 0.35
        pgm_function13[(13, 7, 7)] = 0.2078
        pgm_function13[(13, 7, 8)] = 0.053305331
        pgm_function13[(13, 7, 9)] = 0.002200222
        pgm_function13[(13, 8, 1)] = 0.0078
        pgm_function13[(13, 8, 2)] = 0.1211
        pgm_function13[(13, 8, 3)] = 0.31
        pgm_function13[(13, 8, 4)] = 0.3589
        pgm_function13[(13, 8, 5)] = 0.2233
        pgm_function13[(13, 8, 6)] = 0.0656
        pgm_function13[(13, 8, 7)] = 0.004400442
        pgm_function13[(13, 9, 0)] = 0.115588106
        pgm_function13[(13, 9, 1)] = 0.2978
        pgm_function13[(13, 9, 2)] = 0.365563333
        pgm_function13[(13, 9, 3)] = 0.2433
        pgm_function13[(13, 9, 4)] = 0.08
        pgm_function13[(13, 9, 5)] = 0.0067
        pgm_function13[(13, 10, 0)] = 0.36893715
        pgm_function13[(13, 10, 1)] = 0.26222602
        pgm_function13[(13, 10, 2)] = 0.0956
        pgm_function13[(13, 10, 3)] = 0.01
        pgm_function13[(13, 11, 0)] = 0.081091978
        pgm_function13[(13, 11, 1)] = 0.0133
        pgm_function13[(14, 0, 17)] = 0.0044
        pgm_function13[(14, 0, 18)] = 0.1122
        pgm_function13[(14, 0, 19)] = 0.345565245
        pgm_function13[(14, 0, 20)] = 0.36
        pgm_function13[(14, 0, 21)] = 0.2178
        pgm_function13[(14, 0, 22)] = 0.0522
        pgm_function13[(14, 1, 15)] = 0.0011
        pgm_function13[(14, 1, 16)] = 0.072207235
        pgm_function13[(14, 1, 17)] = 0.2567
        pgm_function13[(14, 1, 18)] = 0.366663209
        pgm_function13[(14, 1, 19)] = 0.2733273
        pgm_function13[(14, 1, 20)] = 0.10781108
        pgm_function13[(14, 1, 21)] = 0.01779822
        pgm_function13[(14, 2, 14)] = 0.0578
        pgm_function13[(14, 2, 15)] = 0.235576087
        pgm_function13[(14, 2, 16)] = 0.365563402
        pgm_function13[(14, 2, 17)] = 0.2867
        pgm_function13[(14, 2, 18)] = 0.1244
        pgm_function13[(14, 2, 19)] = 0.0222
        pgm_function13[(14, 3, 12)] = 0.0411
        pgm_function13[(14, 3, 13)] = 0.2167
        pgm_function13[(14, 3, 14)] = 0.35666436
        pgm_function13[(14, 3, 15)] = 0.3044
        pgm_function13[(14, 3, 16)] = 0.14328611
        pgm_function13[(14, 3, 17)] = 0.0289
        pgm_function13[(14, 4, 10)] = 0.0322
        pgm_function13[(14, 4, 11)] = 0.19001906
        pgm_function13[(14, 4, 12)] = 0.3544
        pgm_function13[(14, 4, 13)] = 0.32
        pgm_function13[(14, 4, 14)] = 0.1611
        pgm_function13[(14, 4, 15)] = 0.03559641
        pgm_function13[(14, 5, 8)] = 0.0233
        pgm_function13[(14, 5, 9)] = 0.1633
        pgm_function13[(14, 5, 10)] = 0.3478
        pgm_function13[(14, 5, 11)] = 0.33
        pgm_function13[(14, 5, 12)] = 0.1833
        pgm_function13[(14, 5, 13)] = 0.044404417
        pgm_function13[(14, 5, 14)] = 0.001100111
        pgm_function13[(14, 6, 6)] = 0.01440141
        pgm_function13[(14, 6, 7)] = 0.1456
        pgm_function13[(14, 6, 8)] = 0.331067189
        pgm_function13[(14, 6, 9)] = 0.3422
        pgm_function13[(14, 6, 10)] = 0.204420139
        pgm_function13[(14, 6, 11)] = 0.0533
        pgm_function13[(14, 6, 12)] = 0.0022
        pgm_function13[(14, 7, 4)] = 0.007799228
        pgm_function13[(14, 7, 5)] = 0.1267
        pgm_function13[(14, 7, 6)] = 0.3089
        pgm_function13[(14, 7, 7)] = 0.3578
        pgm_function13[(14, 7, 8)] = 0.222222129
        pgm_function13[(14, 7, 9)] = 0.06440645
        pgm_function13[(14, 7, 10)] = 0.004400442
        pgm_function13[(14, 8, 2)] = 0.0044
        pgm_function13[(14, 8, 3)] = 0.1067
        pgm_function13[(14, 8, 4)] = 0.2933
        pgm_function13[(14, 8, 5)] = 0.3689
        pgm_function13[(14, 8, 6)] = 0.2389
        pgm_function13[(14, 8, 7)] = 0.078907944
        pgm_function13[(14, 8, 8)] = 0.0067
        pgm_function13[(14, 9, 0)] = 0.002199782
        pgm_function13[(14, 9, 1)] = 0.0833
        pgm_function13[(14, 9, 2)] = 0.276672252
        pgm_function13[(14, 9, 3)] = 0.3678
        pgm_function13[(14, 9, 4)] = 0.2578
        pgm_function13[(14, 9, 5)] = 0.0933
        pgm_function13[(14, 9, 6)] = 0.01
        pgm_function13[(14, 10, 0)] = 0.28332811
        pgm_function13[(14, 10, 1)] = 0.36563702
        pgm_function13[(14, 10, 2)] = 0.2778
        pgm_function13[(14, 10, 3)] = 0.11
        pgm_function13[(14, 10, 4)] = 0.01330131
        pgm_function13[(14, 11, 0)] = 0.277772267
        pgm_function13[(14, 11, 1)] = 0.1278
        pgm_function13[(14, 11, 2)] = 0.01780182
        pgm_function13[(14, 12, 0)] = 0.0156
        pgm_function13[(15, 0, 18)] = 0.0022
        pgm_function13[(15, 0, 19)] = 0.088891163
        pgm_function13[(15, 0, 20)] = 0.3356
        pgm_function13[(15, 0, 21)] = 0.3678
        pgm_function13[(15, 0, 22)] = 0.2389
        pgm_function13[(15, 0, 23)] = 0.06219385
        pgm_function13[(15, 1, 16)] = 0.001100111
        pgm_function13[(15, 1, 17)] = 0.06
        pgm_function13[(15, 1, 18)] = 0.238876136
        pgm_function13[(15, 1, 19)] = 0.3644364
        pgm_function13[(15, 1, 20)] = 0.2844282
        pgm_function13[(15, 1, 21)] = 0.12108813
        pgm_function13[(15, 1, 22)] = 0.0222
        pgm_function13[(15, 2, 15)] = 0.045595417
        pgm_function13[(15, 2, 16)] = 0.216678238
        pgm_function13[(15, 2, 17)] = 0.3644
        pgm_function13[(15, 2, 18)] = 0.2967
        pgm_function13[(15, 2, 19)] = 0.1422
        pgm_function13[(15, 2, 20)] = 0.02779723
        pgm_function13[(15, 3, 13)] = 0.0344
        pgm_function13[(15, 3, 14)] = 0.1955802
        pgm_function13[(15, 3, 15)] = 0.3567
        pgm_function13[(15, 3, 16)] = 0.31666825
        pgm_function13[(15, 3, 17)] = 0.16
        pgm_function13[(15, 3, 18)] = 0.0344
        pgm_function13[(15, 4, 11)] = 0.02440241
        pgm_function13[(15, 4, 12)] = 0.1722
        pgm_function13[(15, 4, 13)] = 0.3411
        pgm_function13[(15, 4, 14)] = 0.3322
        pgm_function13[(15, 4, 15)] = 0.177782048
        pgm_function13[(15, 4, 16)] = 0.043308675
        pgm_function13[(15, 4, 17)] = 0.0011
        pgm_function13[(15, 5, 9)] = 0.0178
        pgm_function13[(15, 5, 10)] = 0.1478
        pgm_function13[(15, 5, 11)] = 0.3322
        pgm_function13[(15, 5, 12)] = 0.3411
        pgm_function13[(15, 5, 13)] = 0.200020076
        pgm_function13[(15, 5, 14)] = 0.053305336
        pgm_function13[(15, 5, 15)] = 0.0022
        pgm_function13[(15, 6, 7)] = 0.0111
        pgm_function13[(15, 6, 8)] = 0.127787073
        pgm_function13[(15, 6, 9)] = 0.3167
        pgm_function13[(15, 6, 10)] = 0.348935237
        pgm_function13[(15, 6, 11)] = 0.2189
        pgm_function13[(15, 6, 12)] = 0.0633
        pgm_function13[(15, 6, 13)] = 0.0044
        pgm_function13[(15, 7, 5)] = 0.0056
        pgm_function13[(15, 7, 6)] = 0.11
        pgm_function13[(15, 7, 7)] = 0.2956
        pgm_function13[(15, 7, 8)] = 0.363336211
        pgm_function13[(15, 7, 9)] = 0.238924186
        pgm_function13[(15, 7, 10)] = 0.076707735
        pgm_function13[(15, 7, 11)] = 0.0067
        pgm_function13[(15, 8, 3)] = 0.0022
        pgm_function13[(15, 8, 4)] = 0.09
        pgm_function13[(15, 8, 5)] = 0.2744
        pgm_function13[(15, 8, 6)] = 0.3756
        pgm_function13[(15, 8, 7)] = 0.251125141
        pgm_function13[(15, 8, 8)] = 0.0911
        pgm_function13[(15, 8, 9)] = 0.01000101
        pgm_function13[(15, 9, 1)] = 0.0011
        pgm_function13[(15, 9, 2)] = 0.071092965
        pgm_function13[(15, 9, 3)] = 0.2589
        pgm_function13[(15, 9, 4)] = 0.37
        pgm_function13[(15, 9, 5)] = 0.2711
        pgm_function13[(15, 9, 6)] = 0.1078
        pgm_function13[(15, 9, 7)] = 0.01330131
        pgm_function13[(15, 10, 0)] = 0.06440643
        pgm_function13[(15, 10, 1)] = 0.24222401
        pgm_function13[(15, 10, 2)] = 0.3622
        pgm_function13[(15, 10, 3)] = 0.2922
        pgm_function13[(15, 10, 4)] = 0.12441207
        pgm_function13[(15, 10, 5)] = 0.01779821
        pgm_function13[(15, 11, 0)] = 0.376662362
        pgm_function13[(15, 11, 1)] = 0.3089
        pgm_function13[(15, 11, 2)] = 0.14331414
        pgm_function13[(15, 11, 3)] = 0.0256
        pgm_function13[(15, 12, 0)] = 0.1422
        pgm_function13[(15, 12, 1)] = 0.0322
        pgm_function13[(16, 0, 19)] = 0.001099891
        pgm_function13[(16, 0, 20)] = 0.0722
        pgm_function13[(16, 0, 21)] = 0.3089
        pgm_function13[(16, 0, 22)] = 0.3722
        pgm_function13[(16, 0, 23)] = 0.25887421
        pgm_function13[(16, 0, 24)] = 0.08
        pgm_function13[(16, 1, 18)] = 0.048895128
        pgm_function13[(16, 1, 19)] = 0.22332225
        pgm_function13[(16, 1, 20)] = 0.36003625
        pgm_function13[(16, 1, 21)] = 0.29667033
        pgm_function13[(16, 1, 22)] = 0.1367
        pgm_function13[(16, 1, 23)] = 0.0278
        pgm_function13[(16, 2, 16)] = 0.03669634
        pgm_function13[(16, 2, 17)] = 0.1967
        pgm_function13[(16, 2, 18)] = 0.36
        pgm_function13[(16, 2, 19)] = 0.3089
        pgm_function13[(16, 2, 20)] = 0.15888414
        pgm_function13[(16, 2, 21)] = 0.034403432
        pgm_function13[(16, 3, 14)] = 0.02669733
        pgm_function13[(16, 3, 15)] = 0.1744
        pgm_function13[(16, 3, 16)] = 0.34666528
        pgm_function13[(16, 3, 17)] = 0.3222
        pgm_function13[(16, 3, 18)] = 0.1778
        pgm_function13[(16, 3, 19)] = 0.042204215
        pgm_function13[(16, 3, 20)] = 0.00110011
        pgm_function13[(16, 4, 12)] = 0.0178
        pgm_function13[(16, 4, 13)] = 0.1567
        pgm_function13[(16, 4, 14)] = 0.33
        pgm_function13[(16, 4, 15)] = 0.341066092
        pgm_function13[(16, 4, 16)] = 0.194438887
        pgm_function13[(16, 4, 17)] = 0.0533
        pgm_function13[(16, 4, 18)] = 0.0022
        pgm_function13[(16, 5, 10)] = 0.0122
        pgm_function13[(16, 5, 11)] = 0.1333
        pgm_function13[(16, 5, 12)] = 0.3178
        pgm_function13[(16, 5, 13)] = 0.350035133
        pgm_function13[(16, 5, 14)] = 0.212221144
        pgm_function13[(16, 5, 15)] = 0.0633
        pgm_function13[(16, 5, 16)] = 0.0044
        pgm_function13[(16, 6, 8)] = 0.006699334
        pgm_function13[(16, 6, 9)] = 0.1122
        pgm_function13[(16, 6, 10)] = 0.303330206
        pgm_function13[(16, 6, 11)] = 0.3567
        pgm_function13[(16, 6, 12)] = 0.2356
        pgm_function13[(16, 6, 13)] = 0.0756
        pgm_function13[(16, 6, 14)] = 0.006699331
        pgm_function13[(16, 7, 6)] = 0.0044
        pgm_function13[(16, 7, 7)] = 0.0922
        pgm_function13[(16, 7, 8)] = 0.280028162
        pgm_function13[(16, 7, 9)] = 0.364436284
        pgm_function13[(16, 7, 10)] = 0.252225116
        pgm_function13[(16, 7, 11)] = 0.0889
        pgm_function13[(16, 7, 12)] = 0.01000101
        pgm_function13[(16, 8, 4)] = 0.0011
        pgm_function13[(16, 8, 5)] = 0.0756
        pgm_function13[(16, 8, 6)] = 0.2544
        pgm_function13[(16, 8, 7)] = 0.373337209
        pgm_function13[(16, 8, 8)] = 0.2678
        pgm_function13[(16, 8, 9)] = 0.10441008
        pgm_function13[(16, 8, 10)] = 0.0133013
        pgm_function13[(16, 9, 3)] = 0.0589
        pgm_function13[(16, 9, 4)] = 0.2411
        pgm_function13[(16, 9, 5)] = 0.37
        pgm_function13[(16, 9, 6)] = 0.2856
        pgm_function13[(16, 9, 7)] = 0.12221205
        pgm_function13[(16, 9, 8)] = 0.01779821
        pgm_function13[(16, 10, 1)] = 0.0422042
        pgm_function13[(16, 10, 2)] = 0.2244
        pgm_function13[(16, 10, 3)] = 0.3589
        pgm_function13[(16, 10, 4)] = 0.30563118
        pgm_function13[(16, 10, 5)] = 0.14108606
        pgm_function13[(16, 10, 6)] = 0.0233
        pgm_function13[(16, 11, 0)] = 0.225577217
        pgm_function13[(16, 11, 1)] = 0.3522
        pgm_function13[(16, 11, 2)] = 0.32443232
        pgm_function13[(16, 11, 3)] = 0.1567
        pgm_function13[(16, 11, 4)] = 0.0322
        pgm_function13[(16, 12, 0)] = 0.3222
        pgm_function13[(16, 12, 1)] = 0.1756
        pgm_function13[(16, 12, 2)] = 0.0411
        pgm_function13[(16, 13, 0)] = 0.0367
        pgm_function13[(16, 13, 1)] = 0.0011
        pgm_function13[(17, 0, 21)] = 0.0622
        pgm_function13[(17, 0, 22)] = 0.2889
        pgm_function13[(17, 0, 23)] = 0.3766623
        pgm_function13[(17, 0, 24)] = 0.2667
        pgm_function13[(17, 0, 25)] = 0.0911
        pgm_function13[(17, 1, 19)] = 0.03780384
        pgm_function13[(17, 1, 20)] = 0.20442014
        pgm_function13[(17, 1, 21)] = 0.35556439
        pgm_function13[(17, 1, 22)] = 0.3111
        pgm_function13[(17, 1, 23)] = 0.1533
        pgm_function13[(17, 1, 24)] = 0.0344
        pgm_function13[(17, 2, 17)] = 0.0289
        pgm_function13[(17, 2, 18)] = 0.1789
        pgm_function13[(17, 2, 19)] = 0.3489
        pgm_function13[(17, 2, 20)] = 0.31886829
        pgm_function13[(17, 2, 21)] = 0.174417162
        pgm_function13[(17, 2, 22)] = 0.041104119
        pgm_function13[(17, 2, 23)] = 0.001100111
        pgm_function13[(17, 3, 15)] = 0.0211
        pgm_function13[(17, 3, 16)] = 0.15558412
        pgm_function13[(17, 3, 17)] = 0.3378
        pgm_function13[(17, 3, 18)] = 0.3322
        pgm_function13[(17, 3, 19)] = 0.19441907
        pgm_function13[(17, 3, 20)] = 0.050005014
        pgm_function13[(17, 3, 21)] = 0.002200221
        pgm_function13[(17, 4, 13)] = 0.0122
        pgm_function13[(17, 4, 14)] = 0.1378
        pgm_function13[(17, 4, 15)] = 0.319968086
        pgm_function13[(17, 4, 16)] = 0.350069797
        pgm_function13[(17, 4, 17)] = 0.2078
        pgm_function13[(17, 4, 18)] = 0.0622
        pgm_function13[(17, 4, 19)] = 0.00440044
        pgm_function13[(17, 5, 11)] = 0.0078
        pgm_function13[(17, 5, 12)] = 0.1178
        pgm_function13[(17, 5, 13)] = 0.300030114
        pgm_function13[(17, 5, 14)] = 0.360036245
        pgm_function13[(17, 5, 15)] = 0.2267
        pgm_function13[(17, 5, 16)] = 0.0744
        pgm_function13[(17, 5, 17)] = 0.006699332
        pgm_function13[(17, 6, 9)] = 0.0044
        pgm_function13[(17, 6, 10)] = 0.096709766
        pgm_function13[(17, 6, 11)] = 0.2856
        pgm_function13[(17, 6, 12)] = 0.3622
        pgm_function13[(17, 6, 13)] = 0.2478
        pgm_function13[(17, 6, 14)] = 0.087791215
        pgm_function13[(17, 6, 15)] = 0.01000101
        pgm_function13[(17, 7, 7)] = 0.0022
        pgm_function13[(17, 7, 8)] = 0.078907946
        pgm_function13[(17, 7, 9)] = 0.264426206
        pgm_function13[(17, 7, 10)] = 0.363336167
        pgm_function13[(17, 7, 11)] = 0.2678
        pgm_function13[(17, 7, 12)] = 0.10111006
        pgm_function13[(17, 7, 13)] = 0.0133
        pgm_function13[(17, 8, 5)] = 0.0011
        pgm_function13[(17, 8, 6)] = 0.0633
        pgm_function13[(17, 8, 7)] = 0.241124135
        pgm_function13[(17, 8, 8)] = 0.37
        pgm_function13[(17, 8, 9)] = 0.28442823
        pgm_function13[(17, 8, 10)] = 0.11891204
        pgm_function13[(17, 8, 11)] = 0.01780182
        pgm_function13[(17, 9, 4)] = 0.0467
        pgm_function13[(17, 9, 5)] = 0.2222
        pgm_function13[(17, 9, 6)] = 0.3644
        pgm_function13[(17, 9, 7)] = 0.29893012
        pgm_function13[(17, 9, 8)] = 0.13888607
        pgm_function13[(17, 9, 9)] = 0.02330231
        pgm_function13[(17, 10, 2)] = 0.0333
        pgm_function13[(17, 10, 3)] = 0.2022
        pgm_function13[(17, 10, 4)] = 0.35333521
        pgm_function13[(17, 10, 5)] = 0.31666813
        pgm_function13[(17, 10, 6)] = 0.1567
        pgm_function13[(17, 10, 7)] = 0.031096924
        pgm_function13[(17, 11, 0)] = 0.033296732
        pgm_function13[(17, 11, 1)] = 0.18
        pgm_function13[(17, 11, 2)] = 0.34003434
        pgm_function13[(17, 11, 3)] = 0.3344
        pgm_function13[(17, 11, 4)] = 0.1711
        pgm_function13[(17, 11, 5)] = 0.04
        pgm_function13[(17, 12, 0)] = 0.35
        pgm_function13[(17, 12, 1)] = 0.3478
        pgm_function13[(17, 12, 2)] = 0.1911
        pgm_function13[(17, 12, 3)] = 0.0511
        pgm_function13[(17, 12, 4)] = 0.00110011
        pgm_function13[(17, 13, 0)] = 0.1944
        pgm_function13[(17, 13, 1)] = 0.0611
        pgm_function13[(17, 13, 2)] = 0.002200221
        pgm_function13[(18, 0, 22)] = 0.0478
        pgm_function13[(18, 0, 23)] = 0.26667321
        pgm_function13[(18, 0, 24)] = 0.3844
        pgm_function13[(18, 0, 25)] = 0.2867
        pgm_function13[(18, 0, 26)] = 0.1089
        pgm_function13[(18, 0, 27)] = 0.0056
        pgm_function13[(18, 1, 20)] = 0.03000302
        pgm_function13[(18, 1, 21)] = 0.1855812
        pgm_function13[(18, 1, 22)] = 0.3444
        pgm_function13[(18, 1, 23)] = 0.32
        pgm_function13[(18, 1, 24)] = 0.17
        pgm_function13[(18, 1, 25)] = 0.0411
        pgm_function13[(18, 1, 26)] = 0.001100111
        pgm_function13[(18, 2, 18)] = 0.0222
        pgm_function13[(18, 2, 19)] = 0.1622
        pgm_function13[(18, 2, 20)] = 0.3366663
        pgm_function13[(18, 2, 21)] = 0.331133308
        pgm_function13[(18, 2, 22)] = 0.190019087
        pgm_function13[(18, 2, 23)] = 0.050005028
        pgm_function13[(18, 2, 24)] = 0.0022
        pgm_function13[(18, 3, 16)] = 0.01559841
        pgm_function13[(18, 3, 17)] = 0.14
        pgm_function13[(18, 3, 18)] = 0.3267
        pgm_function13[(18, 3, 19)] = 0.340034122
        pgm_function13[(18, 3, 20)] = 0.208921056
        pgm_function13[(18, 3, 21)] = 0.060006028
        pgm_function13[(18, 3, 22)] = 0.0044
        pgm_function13[(18, 4, 14)] = 0.01
        pgm_function13[(18, 4, 15)] = 0.118888032
        pgm_function13[(18, 4, 16)] = 0.304460823
        pgm_function13[(18, 4, 17)] = 0.3556
        pgm_function13[(18, 4, 18)] = 0.2244
        pgm_function13[(18, 4, 19)] = 0.0733073
        pgm_function13[(18, 4, 20)] = 0.006700674
        pgm_function13[(18, 5, 12)] = 0.0044
        pgm_function13[(18, 5, 13)] = 0.103310039
        pgm_function13[(18, 5, 14)] = 0.284428193
        pgm_function13[(18, 5, 15)] = 0.3656
        pgm_function13[(18, 5, 16)] = 0.24
        pgm_function13[(18, 5, 17)] = 0.087791224
        pgm_function13[(18, 5, 18)] = 0.01
        pgm_function13[(18, 6, 10)] = 0.002200221
        pgm_function13[(18, 6, 11)] = 0.0833
        pgm_function13[(18, 6, 12)] = 0.2656
        pgm_function13[(18, 6, 13)] = 0.3633
        pgm_function13[(18, 6, 14)] = 0.261074044
        pgm_function13[(18, 6, 15)] = 0.10111012
        pgm_function13[(18, 6, 16)] = 0.01329872
        pgm_function13[(18, 7, 8)] = 0.001100111
        pgm_function13[(18, 7, 9)] = 0.065606651
        pgm_function13[(18, 7, 10)] = 0.248925115
        pgm_function13[(18, 7, 11)] = 0.3633
        pgm_function13[(18, 7, 12)] = 0.28442817
        pgm_function13[(18, 7, 13)] = 0.1167
        pgm_function13[(18, 7, 14)] = 0.0178
        pgm_function13[(18, 8, 7)] = 0.051105129
        pgm_function13[(18, 8, 8)] = 0.2244
        pgm_function13[(18, 8, 9)] = 0.36113629
        pgm_function13[(18, 8, 10)] = 0.30003009
        pgm_function13[(18, 8, 11)] = 0.13441317
        pgm_function13[(18, 8, 12)] = 0.02330231
        pgm_function13[(18, 9, 5)] = 0.0367
        pgm_function13[(18, 9, 6)] = 0.2022
        pgm_function13[(18, 9, 7)] = 0.35893614
        pgm_function13[(18, 9, 8)] = 0.30996915
        pgm_function13[(18, 9, 9)] = 0.15331508
        pgm_function13[(18, 9, 10)] = 0.0311
        pgm_function13[(18, 10, 3)] = 0.0267
        pgm_function13[(18, 10, 4)] = 0.18221811
        pgm_function13[(18, 10, 5)] = 0.34666514
        pgm_function13[(18, 10, 6)] = 0.3289
        pgm_function13[(18, 10, 7)] = 0.171083132
        pgm_function13[(18, 10, 8)] = 0.038903926
        pgm_function13[(18, 11, 1)] = 0.0178
        pgm_function13[(18, 11, 2)] = 0.16221616
        pgm_function13[(18, 11, 3)] = 0.3311
        pgm_function13[(18, 11, 4)] = 0.3478
        pgm_function13[(18, 11, 5)] = 0.1878
        pgm_function13[(18, 11, 6)] = 0.04889515
        pgm_function13[(18, 11, 7)] = 0.0011
        pgm_function13[(18, 12, 0)] = 0.1622
        pgm_function13[(18, 12, 1)] = 0.3189
        pgm_function13[(18, 12, 2)] = 0.3544
        pgm_function13[(18, 12, 3)] = 0.2078
        pgm_function13[(18, 12, 4)] = 0.06110612
        pgm_function13[(18, 12, 5)] = 0.0022
        pgm_function13[(18, 13, 0)] = 0.36
        pgm_function13[(18, 13, 1)] = 0.23
        pgm_function13[(18, 13, 2)] = 0.072207249
        pgm_function13[(18, 13, 3)] = 0.0044
        pgm_function13[(18, 14, 0)] = 0.05889414
        pgm_function13[(18, 14, 1)] = 0.008900893
        pgm_function13[(19, 0, 23)] = 0.03559643
        pgm_function13[(19, 0, 24)] = 0.2411
        pgm_function13[(19, 0, 25)] = 0.3856
        pgm_function13[(19, 0, 26)] = 0.2989
        pgm_function13[(19, 0, 27)] = 0.1222
        pgm_function13[(19, 0, 28)] = 0.012201214
        pgm_function13[(19, 1, 21)] = 0.02329773
        pgm_function13[(19, 1, 22)] = 0.1667
        pgm_function13[(19, 1, 23)] = 0.3367
        pgm_function13[(19, 1, 24)] = 0.3289
        pgm_function13[(19, 1, 25)] = 0.1856
        pgm_function13[(19, 1, 26)] = 0.048904927
        pgm_function13[(19, 1, 27)] = 0.0022
        pgm_function13[(19, 2, 19)] = 0.0156
        pgm_function13[(19, 2, 20)] = 0.14668513
        pgm_function13[(19, 2, 21)] = 0.3222323
        pgm_function13[(19, 2, 22)] = 0.343334158
        pgm_function13[(19, 2, 23)] = 0.204420114
        pgm_function13[(19, 2, 24)] = 0.06
        pgm_function13[(19, 2, 25)] = 0.004400442
        pgm_function13[(19, 3, 17)] = 0.0111
        pgm_function13[(19, 3, 18)] = 0.1222
        pgm_function13[(19, 3, 19)] = 0.310031112
        pgm_function13[(19, 3, 20)] = 0.351135095
        pgm_function13[(19, 3, 21)] = 0.223322105
        pgm_function13[(19, 3, 22)] = 0.07
        pgm_function13[(19, 3, 23)] = 0.006699334
        pgm_function13[(19, 4, 15)] = 0.006699332
        pgm_function13[(19, 4, 16)] = 0.10332094
        pgm_function13[(19, 4, 17)] = 0.2922
        pgm_function13[(19, 4, 18)] = 0.3567
        pgm_function13[(19, 4, 19)] = 0.23782401
        pgm_function13[(19, 4, 20)] = 0.084408453
        pgm_function13[(19, 4, 21)] = 0.01
        pgm_function13[(19, 5, 13)] = 0.002200221
        pgm_function13[(19, 5, 14)] = 0.08780886
        pgm_function13[(19, 5, 15)] = 0.2689
        pgm_function13[(19, 5, 16)] = 0.3656
        pgm_function13[(19, 5, 17)] = 0.253275068
        pgm_function13[(19, 5, 18)] = 0.1
        pgm_function13[(19, 5, 19)] = 0.0133
        pgm_function13[(19, 6, 11)] = 0.0011
        pgm_function13[(19, 6, 12)] = 0.0711
        pgm_function13[(19, 6, 13)] = 0.25
        pgm_function13[(19, 6, 14)] = 0.366663062
        pgm_function13[(19, 6, 15)] = 0.27442733
        pgm_function13[(19, 6, 16)] = 0.11668814
        pgm_function13[(19, 6, 17)] = 0.0178
        pgm_function13[(19, 7, 10)] = 0.054405425
        pgm_function13[(19, 7, 11)] = 0.23
        pgm_function13[(19, 7, 12)] = 0.35673621
        pgm_function13[(19, 7, 13)] = 0.2967
        pgm_function13[(19, 7, 14)] = 0.1322
        pgm_function13[(19, 7, 15)] = 0.0233
        pgm_function13[(19, 8, 8)] = 0.04
        pgm_function13[(19, 8, 9)] = 0.20782117
        pgm_function13[(19, 8, 10)] = 0.35223511
        pgm_function13[(19, 8, 11)] = 0.31223141
        pgm_function13[(19, 8, 12)] = 0.14891506
        pgm_function13[(19, 8, 13)] = 0.03
        pgm_function13[(19, 9, 6)] = 0.03
        pgm_function13[(19, 9, 7)] = 0.18331807
        pgm_function13[(19, 9, 8)] = 0.34996517
        pgm_function13[(19, 9, 9)] = 0.32443216
        pgm_function13[(19, 9, 10)] = 0.1667
        pgm_function13[(19, 9, 11)] = 0.0389
        pgm_function13[(19, 10, 4)] = 0.02110211
        pgm_function13[(19, 10, 5)] = 0.16218406
        pgm_function13[(19, 10, 6)] = 0.3356
        pgm_function13[(19, 10, 7)] = 0.338866261
        pgm_function13[(19, 10, 8)] = 0.187819124
        pgm_function13[(19, 10, 9)] = 0.0478
        pgm_function13[(19, 10, 10)] = 0.0011
        pgm_function13[(19, 11, 2)] = 0.01220121
        pgm_function13[(19, 11, 3)] = 0.1433
        pgm_function13[(19, 11, 4)] = 0.3189
        pgm_function13[(19, 11, 5)] = 0.3533
        pgm_function13[(19, 11, 6)] = 0.206679211
        pgm_function13[(19, 11, 7)] = 0.0589
        pgm_function13[(19, 11, 8)] = 0.0022
        pgm_function13[(19, 12, 0)] = 0.0078
        pgm_function13[(19, 12, 1)] = 0.1211
        pgm_function13[(19, 12, 2)] = 0.3056
        pgm_function13[(19, 12, 3)] = 0.36
        pgm_function13[(19, 12, 4)] = 0.22222208
        pgm_function13[(19, 12, 5)] = 0.0711
        pgm_function13[(19, 12, 6)] = 0.0044
        pgm_function13[(19, 13, 0)] = 0.3078
        pgm_function13[(19, 13, 1)] = 0.36
        pgm_function13[(19, 13, 2)] = 0.244424166
        pgm_function13[(19, 13, 3)] = 0.0833
        pgm_function13[(19, 13, 4)] = 0.0089
        pgm_function13[(19, 14, 0)] = 0.24667517
        pgm_function13[(19, 14, 1)] = 0.094409429
        pgm_function13[(19, 14, 2)] = 0.01219881
        pgm_function13[(19, 15, 0)] = 0.0078
        pgm_function13[(20, 0, 24)] = 0.0278
        pgm_function13[(20, 0, 25)] = 0.2144
        pgm_function13[(20, 0, 26)] = 0.3833
        pgm_function13[(20, 0, 27)] = 0.3111
        pgm_function13[(20, 0, 28)] = 0.134413152
        pgm_function13[(20, 0, 29)] = 0.0189
        pgm_function13[(20, 1, 22)] = 0.0189
        pgm_function13[(20, 1, 23)] = 0.1489
        pgm_function13[(20, 1, 24)] = 0.3256
        pgm_function13[(20, 1, 25)] = 0.3378
        pgm_function13[(20, 1, 26)] = 0.202220111
        pgm_function13[(20, 1, 27)] = 0.06
        pgm_function13[(20, 1, 28)] = 0.004400441
        pgm_function13[(20, 2, 20)] = 0.01109891
        pgm_function13[(20, 2, 21)] = 0.131113122
        pgm_function13[(20, 2, 22)] = 0.30443014
        pgm_function13[(20, 2, 23)] = 0.352235197
        pgm_function13[(20, 2, 24)] = 0.2167
        pgm_function13[(20, 2, 25)] = 0.070007025
        pgm_function13[(20, 2, 26)] = 0.006699334
        pgm_function13[(20, 3, 18)] = 0.0067
        pgm_function13[(20, 3, 19)] = 0.108911039
        pgm_function13[(20, 3, 20)] = 0.292229079
        pgm_function13[(20, 3, 21)] = 0.356736168
        pgm_function13[(20, 3, 22)] = 0.2378
        pgm_function13[(20, 3, 23)] = 0.081091954
        pgm_function13[(20, 3, 24)] = 0.01000101
        pgm_function13[(20, 4, 16)] = 0.004400877
        pgm_function13[(20, 4, 17)] = 0.0878
        pgm_function13[(20, 4, 18)] = 0.2778
        pgm_function13[(20, 4, 19)] = 0.36223602
        pgm_function13[(20, 4, 20)] = 0.25442516
        pgm_function13[(20, 4, 21)] = 0.0956
        pgm_function13[(20, 4, 22)] = 0.0133
        pgm_function13[(20, 5, 14)] = 0.001100111
        pgm_function13[(20, 5, 15)] = 0.0722
        pgm_function13[(20, 5, 16)] = 0.2556
        pgm_function13[(20, 5, 17)] = 0.365563099
        pgm_function13[(20, 5, 18)] = 0.2689
        pgm_function13[(20, 5, 19)] = 0.1133
        pgm_function13[(20, 5, 20)] = 0.01779822
        pgm_function13[(20, 6, 13)] = 0.0589
        pgm_function13[(20, 6, 14)] = 0.231077039
        pgm_function13[(20, 6, 15)] = 0.36223643
        pgm_function13[(20, 6, 16)] = 0.28667134
        pgm_function13[(20, 6, 17)] = 0.1311
        pgm_function13[(20, 6, 18)] = 0.0233
        pgm_function13[(20, 7, 11)] = 0.0433
        pgm_function13[(20, 7, 12)] = 0.21332113
        pgm_function13[(20, 7, 13)] = 0.3522
        pgm_function13[(20, 7, 14)] = 0.3056
        pgm_function13[(20, 7, 15)] = 0.1467
        pgm_function13[(20, 7, 16)] = 0.03
        pgm_function13[(20, 8, 9)] = 0.03220323
        pgm_function13[(20, 8, 10)] = 0.19111906
        pgm_function13[(20, 8, 11)] = 0.34443445
        pgm_function13[(20, 8, 12)] = 0.32333213
        pgm_function13[(20, 8, 13)] = 0.1633
        pgm_function13[(20, 8, 14)] = 0.038896122
        pgm_function13[(20, 9, 7)] = 0.02330231
        pgm_function13[(20, 9, 8)] = 0.16668308
        pgm_function13[(20, 9, 9)] = 0.33783417
        pgm_function13[(20, 9, 10)] = 0.3389
        pgm_function13[(20, 9, 11)] = 0.1822
        pgm_function13[(20, 9, 12)] = 0.0478
        pgm_function13[(20, 9, 13)] = 0.0011
        pgm_function13[(20, 10, 5)] = 0.01559841
        pgm_function13[(20, 10, 6)] = 0.1444
        pgm_function13[(20, 10, 7)] = 0.325567251
        pgm_function13[(20, 10, 8)] = 0.343334227
        pgm_function13[(20, 10, 9)] = 0.2044
        pgm_function13[(20, 10, 10)] = 0.0578
        pgm_function13[(20, 10, 11)] = 0.0022
        pgm_function13[(20, 11, 3)] = 0.0089
        pgm_function13[(20, 11, 4)] = 0.1233
        pgm_function13[(20, 11, 5)] = 0.3078
        pgm_function13[(20, 11, 6)] = 0.355564363
        pgm_function13[(20, 11, 7)] = 0.2222
        pgm_function13[(20, 11, 8)] = 0.0689
        pgm_function13[(20, 11, 9)] = 0.0044
        pgm_function13[(20, 12, 1)] = 0.0044
        pgm_function13[(20, 12, 2)] = 0.1056
        pgm_function13[(20, 12, 3)] = 0.2911
        pgm_function13[(20, 12, 4)] = 0.36443614
        pgm_function13[(20, 12, 5)] = 0.2378
        pgm_function13[(20, 12, 6)] = 0.0811
        pgm_function13[(20, 12, 7)] = 0.0089
        pgm_function13[(20, 13, 0)] = 0.1
        pgm_function13[(20, 13, 1)] = 0.2778
        pgm_function13[(20, 13, 2)] = 0.364436248
        pgm_function13[(20, 13, 3)] = 0.2611
        pgm_function13[(20, 13, 4)] = 0.0944
        pgm_function13[(20, 13, 5)] = 0.0122
        pgm_function13[(20, 14, 0)] = 0.37556226
        pgm_function13[(20, 14, 1)] = 0.283328088
        pgm_function13[(20, 14, 2)] = 0.1077891
        pgm_function13[(20, 14, 3)] = 0.01779822
        pgm_function13[(20, 15, 0)] = 0.1089
        pgm_function13[(20, 15, 1)] = 0.02220221
        pgm_function13[(21, 0, 25)] = 0.0222
        pgm_function13[(21, 0, 26)] = 0.1933
        pgm_function13[(21, 0, 27)] = 0.3778
        pgm_function13[(21, 0, 28)] = 0.331133374
        pgm_function13[(21, 0, 29)] = 0.1467
        pgm_function13[(21, 0, 30)] = 0.0267
        pgm_function13[(21, 1, 23)] = 0.0133
        pgm_function13[(21, 1, 24)] = 0.13
        pgm_function13[(21, 1, 25)] = 0.3144
        pgm_function13[(21, 1, 26)] = 0.344434189
        pgm_function13[(21, 1, 27)] = 0.2144
        pgm_function13[(21, 1, 28)] = 0.070007011
        pgm_function13[(21, 1, 29)] = 0.0067
        pgm_function13[(21, 2, 21)] = 0.006700676
        pgm_function13[(21, 2, 22)] = 0.116712054
        pgm_function13[(21, 2, 23)] = 0.288929162
        pgm_function13[(21, 2, 24)] = 0.3578
        pgm_function13[(21, 2, 25)] = 0.231123081
        pgm_function13[(21, 2, 26)] = 0.081091954
        pgm_function13[(21, 2, 27)] = 0.01000101
        pgm_function13[(21, 3, 19)] = 0.004400442
        pgm_function13[(21, 3, 20)] = 0.094409425
        pgm_function13[(21, 3, 21)] = 0.274427129
        pgm_function13[(21, 3, 22)] = 0.3622
        pgm_function13[(21, 3, 23)] = 0.249975167
        pgm_function13[(21, 3, 24)] = 0.09440948
        pgm_function13[(21, 3, 25)] = 0.01329871
        pgm_function13[(21, 4, 17)] = 0.0022
        pgm_function13[(21, 4, 18)] = 0.0756
        pgm_function13[(21, 4, 19)] = 0.26002602
        pgm_function13[(21, 4, 20)] = 0.361136228
        pgm_function13[(21, 4, 21)] = 0.2689
        pgm_function13[(21, 4, 22)] = 0.11
        pgm_function13[(21, 4, 23)] = 0.0178
        pgm_function13[(21, 5, 15)] = 0.0011
        pgm_function13[(21, 5, 16)] = 0.06
        pgm_function13[(21, 5, 17)] = 0.238876064
        pgm_function13[(21, 5, 18)] = 0.3589
        pgm_function13[(21, 5, 19)] = 0.2856
        pgm_function13[(21, 5, 20)] = 0.12668714
        pgm_function13[(21, 5, 21)] = 0.0233
        pgm_function13[(21, 6, 14)] = 0.046695308
        pgm_function13[(21, 6, 15)] = 0.21442126
        pgm_function13[(21, 6, 16)] = 0.35666443
        pgm_function13[(21, 6, 17)] = 0.2978
        pgm_function13[(21, 6, 18)] = 0.1467
        pgm_function13[(21, 6, 19)] = 0.02889713
        pgm_function13[(21, 7, 12)] = 0.03440342
        pgm_function13[(21, 7, 13)] = 0.1933
        pgm_function13[(21, 7, 14)] = 0.3489
        pgm_function13[(21, 7, 15)] = 0.3178
        pgm_function13[(21, 7, 16)] = 0.1611
        pgm_function13[(21, 7, 17)] = 0.038896122
        pgm_function13[(21, 8, 10)] = 0.02440241
        pgm_function13[(21, 8, 11)] = 0.17221722
        pgm_function13[(21, 8, 12)] = 0.33673413
        pgm_function13[(21, 8, 13)] = 0.3367
        pgm_function13[(21, 8, 14)] = 0.177782101
        pgm_function13[(21, 8, 15)] = 0.0478
        pgm_function13[(21, 8, 16)] = 0.0011
        pgm_function13[(21, 9, 8)] = 0.01669831
        pgm_function13[(21, 9, 9)] = 0.14891507
        pgm_function13[(21, 9, 10)] = 0.3233
        pgm_function13[(21, 9, 11)] = 0.3456
        pgm_function13[(21, 9, 12)] = 0.1978
        pgm_function13[(21, 9, 13)] = 0.0578
        pgm_function13[(21, 9, 14)] = 0.0022
        pgm_function13[(21, 10, 6)] = 0.0111
        pgm_function13[(21, 10, 7)] = 0.126687098
        pgm_function13[(21, 10, 8)] = 0.313331207
        pgm_function13[(21, 10, 9)] = 0.3511
        pgm_function13[(21, 10, 10)] = 0.2189
        pgm_function13[(21, 10, 11)] = 0.0678
        pgm_function13[(21, 10, 12)] = 0.0044
        pgm_function13[(21, 11, 4)] = 0.0067
        pgm_function13[(21, 11, 5)] = 0.1067
        pgm_function13[(21, 11, 6)] = 0.297770304
        pgm_function13[(21, 11, 7)] = 0.3567
        pgm_function13[(21, 11, 8)] = 0.24
        pgm_function13[(21, 11, 9)] = 0.0778
        pgm_function13[(21, 11, 10)] = 0.0089
        pgm_function13[(21, 12, 2)] = 0.0022
        pgm_function13[(21, 12, 3)] = 0.0889
        pgm_function13[(21, 12, 4)] = 0.27672811
        pgm_function13[(21, 12, 5)] = 0.3678
        pgm_function13[(21, 12, 6)] = 0.2567
        pgm_function13[(21, 12, 7)] = 0.0922
        pgm_function13[(21, 12, 8)] = 0.0122
        pgm_function13[(21, 13, 0)] = 0.0011
        pgm_function13[(21, 13, 1)] = 0.07
        pgm_function13[(21, 13, 2)] = 0.257826175
        pgm_function13[(21, 13, 3)] = 0.3667
        pgm_function13[(21, 13, 4)] = 0.2733
        pgm_function13[(21, 13, 5)] = 0.1067
        pgm_function13[(21, 13, 6)] = 0.0167
        pgm_function13[(21, 14, 0)] = 0.26107418
        pgm_function13[(21, 14, 1)] = 0.358936111
        pgm_function13[(21, 14, 2)] = 0.29667027
        pgm_function13[(21, 14, 3)] = 0.12218812
        pgm_function13[(21, 14, 4)] = 0.0222
        pgm_function13[(21, 15, 0)] = 0.29
        pgm_function13[(21, 15, 1)] = 0.14111407
        pgm_function13[(21, 15, 2)] = 0.0289
        pgm_function13[(21, 16, 0)] = 0.0267
        pgm_function13[(22, 0, 26)] = 0.0156
        pgm_function13[(22, 0, 27)] = 0.1722
        pgm_function13[(22, 0, 28)] = 0.364436412
        pgm_function13[(22, 0, 29)] = 0.3456
        pgm_function13[(22, 0, 30)] = 0.1633
        pgm_function13[(22, 0, 31)] = 0.0367
        pgm_function13[(22, 1, 24)] = 0.0111
        pgm_function13[(22, 1, 25)] = 0.1144
        pgm_function13[(22, 1, 26)] = 0.298930164
        pgm_function13[(22, 1, 27)] = 0.3478
        pgm_function13[(22, 1, 28)] = 0.227823034
        pgm_function13[(22, 1, 29)] = 0.08
        pgm_function13[(22, 1, 30)] = 0.01000101
        pgm_function13[(22, 2, 22)] = 0.004400442
        pgm_function13[(22, 2, 23)] = 0.100010056
        pgm_function13[(22, 2, 24)] = 0.2767
        pgm_function13[(22, 2, 25)] = 0.361136126
        pgm_function13[(22, 2, 26)] = 0.245575165
        pgm_function13[(22, 2, 27)] = 0.09440948
        pgm_function13[(22, 2, 28)] = 0.0133
        pgm_function13[(22, 3, 20)] = 0.002200221
        pgm_function13[(22, 3, 21)] = 0.082208239
        pgm_function13[(22, 3, 22)] = 0.2556
        pgm_function13[(22, 3, 23)] = 0.366663246
        pgm_function13[(22, 3, 24)] = 0.26442621
        pgm_function13[(22, 3, 25)] = 0.10778912
        pgm_function13[(22, 3, 26)] = 0.0178
        pgm_function13[(22, 4, 18)] = 0.0011
        pgm_function13[(22, 4, 19)] = 0.0622062
        pgm_function13[(22, 4, 20)] = 0.240024151
        pgm_function13[(22, 4, 21)] = 0.36
        pgm_function13[(22, 4, 22)] = 0.2822
        pgm_function13[(22, 4, 23)] = 0.1233
        pgm_function13[(22, 4, 24)] = 0.0233
        pgm_function13[(22, 5, 17)] = 0.047795213
        pgm_function13[(22, 5, 18)] = 0.2244
        pgm_function13[(22, 5, 19)] = 0.3511
        pgm_function13[(22, 5, 20)] = 0.29997033
        pgm_function13[(22, 5, 21)] = 0.1411
        pgm_function13[(22, 5, 22)] = 0.02890292
        pgm_function13[(22, 6, 15)] = 0.03780385
        pgm_function13[(22, 6, 16)] = 0.19778024
        pgm_function13[(22, 6, 17)] = 0.35
        pgm_function13[(22, 6, 18)] = 0.31
        pgm_function13[(22, 6, 19)] = 0.15888416
        pgm_function13[(22, 6, 20)] = 0.0378
        pgm_function13[(22, 7, 13)] = 0.0278
        pgm_function13[(22, 7, 14)] = 0.1733
        pgm_function13[(22, 7, 15)] = 0.3422
        pgm_function13[(22, 7, 16)] = 0.3278
        pgm_function13[(22, 7, 17)] = 0.1755821
        pgm_function13[(22, 7, 18)] = 0.0478
        pgm_function13[(22, 7, 19)] = 0.0011
        pgm_function13[(22, 8, 11)] = 0.01890192
        pgm_function13[(22, 8, 12)] = 0.15441506
        pgm_function13[(22, 8, 13)] = 0.3244
        pgm_function13[(22, 8, 14)] = 0.343266196
        pgm_function13[(22, 8, 15)] = 0.1933
        pgm_function13[(22, 8, 16)] = 0.0567
        pgm_function13[(22, 8, 17)] = 0.0022
        pgm_function13[(22, 9, 9)] = 0.01220121
        pgm_function13[(22, 9, 10)] = 0.1322
        pgm_function13[(22, 9, 11)] = 0.31
        pgm_function13[(22, 9, 12)] = 0.3522
        pgm_function13[(22, 9, 13)] = 0.2133
        pgm_function13[(22, 9, 14)] = 0.0678
        pgm_function13[(22, 9, 15)] = 0.0044
        pgm_function13[(22, 10, 7)] = 0.006699335
        pgm_function13[(22, 10, 8)] = 0.112211074
        pgm_function13[(22, 10, 9)] = 0.2989
        pgm_function13[(22, 10, 10)] = 0.3556
        pgm_function13[(22, 10, 11)] = 0.2356
        pgm_function13[(22, 10, 12)] = 0.0778
        pgm_function13[(22, 10, 13)] = 0.007799224
        pgm_function13[(22, 11, 5)] = 0.0044
        pgm_function13[(22, 11, 6)] = 0.088891191
        pgm_function13[(22, 11, 7)] = 0.2833
        pgm_function13[(22, 11, 8)] = 0.3589
        pgm_function13[(22, 11, 9)] = 0.2589
        pgm_function13[(22, 11, 10)] = 0.0878
        pgm_function13[(22, 11, 11)] = 0.01219881
        pgm_function13[(22, 12, 3)] = 0.0011
        pgm_function13[(22, 12, 4)] = 0.07330733
        pgm_function13[(22, 12, 5)] = 0.26
        pgm_function13[(22, 12, 6)] = 0.3656
        pgm_function13[(22, 12, 7)] = 0.2711
        pgm_function13[(22, 12, 8)] = 0.1033
        pgm_function13[(22, 12, 9)] = 0.01669831
        pgm_function13[(22, 13, 2)] = 0.05890594
        pgm_function13[(22, 13, 3)] = 0.2378
        pgm_function13[(22, 13, 4)] = 0.3667
        pgm_function13[(22, 13, 5)] = 0.2889
        pgm_function13[(22, 13, 6)] = 0.12
        pgm_function13[(22, 13, 7)] = 0.02219782
        pgm_function13[(22, 14, 0)] = 0.05779424
        pgm_function13[(22, 14, 1)] = 0.220022068
        pgm_function13[(22, 14, 2)] = 0.35996432
        pgm_function13[(22, 14, 3)] = 0.30556931
        pgm_function13[(22, 14, 4)] = 0.14
        pgm_function13[(22, 14, 5)] = 0.0278
        pgm_function13[(22, 15, 0)] = 0.3733
        pgm_function13[(22, 15, 1)] = 0.32333216
        pgm_function13[(22, 15, 2)] = 0.1567
        pgm_function13[(22, 15, 3)] = 0.0356
        pgm_function13[(22, 16, 0)] = 0.1533
        pgm_function13[(22, 16, 1)] = 0.043304316
        pgm_function13[(22, 16, 2)] = 0.0011
        pgm_function13[(23, 0, 27)] = 0.0111
        pgm_function13[(23, 0, 28)] = 0.151115171
        pgm_function13[(23, 0, 29)] = 0.35
        pgm_function13[(23, 0, 30)] = 0.3556
        pgm_function13[(23, 0, 31)] = 0.18
        pgm_function13[(23, 0, 32)] = 0.0456
        pgm_function13[(23, 1, 25)] = 0.0067
        pgm_function13[(23, 1, 26)] = 0.100010055
        pgm_function13[(23, 1, 27)] = 0.2878
        pgm_function13[(23, 1, 28)] = 0.353335053
        pgm_function13[(23, 1, 29)] = 0.2411
        pgm_function13[(23, 1, 30)] = 0.09330935
        pgm_function13[(23, 1, 31)] = 0.0133
        pgm_function13[(23, 2, 23)] = 0.003300332
        pgm_function13[(23, 2, 24)] = 0.0844
        pgm_function13[(23, 2, 25)] = 0.261126091
        pgm_function13[(23, 2, 26)] = 0.35886424
        pgm_function13[(23, 2, 27)] = 0.26112621
        pgm_function13[(23, 2, 28)] = 0.1067
        pgm_function13[(23, 2, 29)] = 0.0178
        pgm_function13[(23, 3, 21)] = 0.001100111
        pgm_function13[(23, 3, 22)] = 0.07
        pgm_function13[(23, 3, 23)] = 0.236676159
        pgm_function13[(23, 3, 24)] = 0.36223629
        pgm_function13[(23, 3, 25)] = 0.2766723
        pgm_function13[(23, 3, 26)] = 0.1222
        pgm_function13[(23, 3, 27)] = 0.0222
        pgm_function13[(23, 4, 20)] = 0.053305334
        pgm_function13[(23, 4, 21)] = 0.2222
        pgm_function13[(23, 4, 22)] = 0.3556
        pgm_function13[(23, 4, 23)] = 0.2967
        pgm_function13[(23, 4, 24)] = 0.1389
        pgm_function13[(23, 4, 25)] = 0.0289
        pgm_function13[(23, 5, 18)] = 0.0378
        pgm_function13[(23, 5, 19)] = 0.2067
        pgm_function13[(23, 5, 20)] = 0.34556538
        pgm_function13[(23, 5, 21)] = 0.3133
        pgm_function13[(23, 5, 22)] = 0.15441512
        pgm_function13[(23, 5, 23)] = 0.0367
        pgm_function13[(23, 6, 16)] = 0.02889713
        pgm_function13[(23, 6, 17)] = 0.1811
        pgm_function13[(23, 6, 18)] = 0.3411
        pgm_function13[(23, 6, 19)] = 0.32666733
        pgm_function13[(23, 6, 20)] = 0.1733
        pgm_function13[(23, 6, 21)] = 0.0456
        pgm_function13[(23, 6, 22)] = 0.00110011
        pgm_function13[(23, 7, 14)] = 0.0222
        pgm_function13[(23, 7, 15)] = 0.1544
        pgm_function13[(23, 7, 16)] = 0.3311
        pgm_function13[(23, 7, 17)] = 0.335566191
        pgm_function13[(23, 7, 18)] = 0.19
        pgm_function13[(23, 7, 19)] = 0.0556
        pgm_function13[(23, 7, 20)] = 0.002200222
        pgm_function13[(23, 8, 12)] = 0.01330131
        pgm_function13[(23, 8, 13)] = 0.1356
        pgm_function13[(23, 8, 14)] = 0.31556818
        pgm_function13[(23, 8, 15)] = 0.3467
        pgm_function13[(23, 8, 16)] = 0.2089
        pgm_function13[(23, 8, 17)] = 0.0678
        pgm_function13[(23, 8, 18)] = 0.0044
        pgm_function13[(23, 9, 10)] = 0.0078
        pgm_function13[(23, 9, 11)] = 0.1189
        pgm_function13[(23, 9, 12)] = 0.2989
        pgm_function13[(23, 9, 13)] = 0.3556
        pgm_function13[(23, 9, 14)] = 0.2289
        pgm_function13[(23, 9, 15)] = 0.0778
        pgm_function13[(23, 9, 16)] = 0.007799224
        pgm_function13[(23, 10, 8)] = 0.004400443
        pgm_function13[(23, 10, 9)] = 0.0956
        pgm_function13[(23, 10, 10)] = 0.2822
        pgm_function13[(23, 10, 11)] = 0.36
        pgm_function13[(23, 10, 12)] = 0.2511
        pgm_function13[(23, 10, 13)] = 0.088891143
        pgm_function13[(23, 10, 14)] = 0.0122
        pgm_function13[(23, 11, 6)] = 0.002199782
        pgm_function13[(23, 11, 7)] = 0.0767
        pgm_function13[(23, 11, 8)] = 0.2656
        pgm_function13[(23, 11, 9)] = 0.3589
        pgm_function13[(23, 11, 10)] = 0.2744
        pgm_function13[(23, 11, 11)] = 0.09999008
        pgm_function13[(23, 11, 12)] = 0.01669831
        pgm_function13[(23, 12, 4)] = 0.00110011
        pgm_function13[(23, 12, 5)] = 0.0611
        pgm_function13[(23, 12, 6)] = 0.2422
        pgm_function13[(23, 12, 7)] = 0.3622
        pgm_function13[(23, 12, 8)] = 0.2889
        pgm_function13[(23, 12, 9)] = 0.11558803
        pgm_function13[(23, 12, 10)] = 0.0222
        pgm_function13[(23, 13, 3)] = 0.0467
        pgm_function13[(23, 13, 4)] = 0.2189
        pgm_function13[(23, 13, 5)] = 0.3622
        pgm_function13[(23, 13, 6)] = 0.3011
        pgm_function13[(23, 13, 7)] = 0.13778611
        pgm_function13[(23, 13, 8)] = 0.0278
        pgm_function13[(23, 14, 1)] = 0.034403411
        pgm_function13[(23, 14, 2)] = 0.19668018
        pgm_function13[(23, 14, 3)] = 0.35666436
        pgm_function13[(23, 14, 4)] = 0.3144
        pgm_function13[(23, 14, 5)] = 0.1567
        pgm_function13[(23, 14, 6)] = 0.0344
        pgm_function13[(23, 15, 0)] = 0.1967
        pgm_function13[(23, 15, 1)] = 0.34333417
        pgm_function13[(23, 15, 2)] = 0.3311
        pgm_function13[(23, 15, 3)] = 0.1733
        pgm_function13[(23, 15, 4)] = 0.043304311
        pgm_function13[(23, 15, 5)] = 0.0011
        pgm_function13[(23, 16, 0)] = 0.3389
        pgm_function13[(23, 16, 1)] = 0.195620072
        pgm_function13[(23, 16, 2)] = 0.0511
        pgm_function13[(23, 16, 3)] = 0.0022
        pgm_function13[(23, 17, 0)] = 0.04559541
        pgm_function13[(23, 17, 1)] = 0.004400442
        pgm_function13[(24, 0, 28)] = 0.006700678
        pgm_function13[(24, 0, 29)] = 0.1344
        pgm_function13[(24, 0, 30)] = 0.3344
        pgm_function13[(24, 0, 31)] = 0.3633
        pgm_function13[(24, 0, 32)] = 0.1922
        pgm_function13[(24, 0, 33)] = 0.05559441
        pgm_function13[(24, 1, 26)] = 0.004400442
        pgm_function13[(24, 1, 27)] = 0.0856
        pgm_function13[(24, 1, 28)] = 0.270027041
        pgm_function13[(24, 1, 29)] = 0.3567
        pgm_function13[(24, 1, 30)] = 0.25562613
        pgm_function13[(24, 1, 31)] = 0.1056
        pgm_function13[(24, 1, 32)] = 0.0178
        pgm_function13[(24, 2, 24)] = 0.0022
        pgm_function13[(24, 2, 25)] = 0.071107125
        pgm_function13[(24, 2, 26)] = 0.248875167
        pgm_function13[(24, 2, 27)] = 0.35223528
        pgm_function13[(24, 2, 28)] = 0.2744
        pgm_function13[(24, 2, 29)] = 0.12
        pgm_function13[(24, 2, 30)] = 0.02220221
        pgm_function13[(24, 3, 23)] = 0.058894139
        pgm_function13[(24, 3, 24)] = 0.22112218
        pgm_function13[(24, 3, 25)] = 0.35556439
        pgm_function13[(24, 3, 26)] = 0.29
        pgm_function13[(24, 3, 27)] = 0.1389
        pgm_function13[(24, 3, 28)] = 0.02889711
        pgm_function13[(24, 4, 21)] = 0.0433
        pgm_function13[(24, 4, 22)] = 0.2033
        pgm_function13[(24, 4, 23)] = 0.3511
        pgm_function13[(24, 4, 24)] = 0.3056
        pgm_function13[(24, 4, 25)] = 0.1533
        pgm_function13[(24, 4, 26)] = 0.0367
        pgm_function13[(24, 5, 19)] = 0.03
        pgm_function13[(24, 5, 20)] = 0.18668121
        pgm_function13[(24, 5, 21)] = 0.3367
        pgm_function13[(24, 5, 22)] = 0.32333226
        pgm_function13[(24, 5, 23)] = 0.1711
        pgm_function13[(24, 5, 24)] = 0.0456
        pgm_function13[(24, 5, 25)] = 0.00110011
        pgm_function13[(24, 6, 17)] = 0.0222
        pgm_function13[(24, 6, 18)] = 0.1633
        pgm_function13[(24, 6, 19)] = 0.32776733
        pgm_function13[(24, 6, 20)] = 0.3356
        pgm_function13[(24, 6, 21)] = 0.1878
        pgm_function13[(24, 6, 22)] = 0.054405424
        pgm_function13[(24, 6, 23)] = 0.00220022
        pgm_function13[(24, 7, 15)] = 0.0156
        pgm_function13[(24, 7, 16)] = 0.1389
        pgm_function13[(24, 7, 17)] = 0.319968182
        pgm_function13[(24, 7, 18)] = 0.3433
        pgm_function13[(24, 7, 19)] = 0.2067
        pgm_function13[(24, 7, 20)] = 0.065606664
        pgm_function13[(24, 7, 21)] = 0.0044
        pgm_function13[(24, 8, 13)] = 0.01
        pgm_function13[(24, 8, 14)] = 0.117788067
        pgm_function13[(24, 8, 15)] = 0.3067
        pgm_function13[(24, 8, 16)] = 0.3511
        pgm_function13[(24, 8, 17)] = 0.2256
        pgm_function13[(24, 8, 18)] = 0.0756
        pgm_function13[(24, 8, 19)] = 0.007799226
        pgm_function13[(24, 9, 11)] = 0.0044
        pgm_function13[(24, 9, 12)] = 0.1
        pgm_function13[(24, 9, 13)] = 0.2856
        pgm_function13[(24, 9, 14)] = 0.3578
        pgm_function13[(24, 9, 15)] = 0.2444
        pgm_function13[(24, 9, 16)] = 0.088891143
        pgm_function13[(24, 9, 17)] = 0.01220121
        pgm_function13[(24, 10, 9)] = 0.0022
        pgm_function13[(24, 10, 10)] = 0.0833
        pgm_function13[(24, 10, 11)] = 0.2633
        pgm_function13[(24, 10, 12)] = 0.3611
        pgm_function13[(24, 10, 13)] = 0.265573127
        pgm_function13[(24, 10, 14)] = 0.1
        pgm_function13[(24, 10, 15)] = 0.0167
        pgm_function13[(24, 11, 7)] = 0.0011
        pgm_function13[(24, 11, 8)] = 0.0644
        pgm_function13[(24, 11, 9)] = 0.2456
        pgm_function13[(24, 11, 10)] = 0.3578
        pgm_function13[(24, 11, 11)] = 0.28667123
        pgm_function13[(24, 11, 12)] = 0.11328907
        pgm_function13[(24, 11, 13)] = 0.0211
        pgm_function13[(24, 12, 6)] = 0.05
        pgm_function13[(24, 12, 7)] = 0.2267
        pgm_function13[(24, 12, 8)] = 0.3578
        pgm_function13[(24, 12, 9)] = 0.30327009
        pgm_function13[(24, 12, 10)] = 0.1322
        pgm_function13[(24, 12, 11)] = 0.0278
        pgm_function13[(24, 13, 4)] = 0.0378
        pgm_function13[(24, 13, 5)] = 0.2011
        pgm_function13[(24, 13, 6)] = 0.3567
        pgm_function13[(24, 13, 7)] = 0.31106925
        pgm_function13[(24, 13, 8)] = 0.1533
        pgm_function13[(24, 13, 9)] = 0.034403424
        pgm_function13[(24, 14, 2)] = 0.02669732
        pgm_function13[(24, 14, 3)] = 0.17558218
        pgm_function13[(24, 14, 4)] = 0.3511
        pgm_function13[(24, 14, 5)] = 0.3222
        pgm_function13[(24, 14, 6)] = 0.1744
        pgm_function13[(24, 14, 7)] = 0.041104119
        pgm_function13[(24, 14, 8)] = 0.0011
        pgm_function13[(24, 15, 0)] = 0.0233
        pgm_function13[(24, 15, 1)] = 0.15671608
        pgm_function13[(24, 15, 2)] = 0.3344
        pgm_function13[(24, 15, 3)] = 0.3411
        pgm_function13[(24, 15, 4)] = 0.19111905
        pgm_function13[(24, 15, 5)] = 0.05
        pgm_function13[(24, 15, 6)] = 0.0022
        pgm_function13[(24, 16, 0)] = 0.3311
        pgm_function13[(24, 16, 1)] = 0.35113513
        pgm_function13[(24, 16, 2)] = 0.2122
        pgm_function13[(24, 16, 3)] = 0.0611
        pgm_function13[(24, 16, 4)] = 0.004400442
        pgm_function13[(24, 17, 0)] = 0.21217906
        pgm_function13[(24, 17, 1)] = 0.072207233
        pgm_function13[(24, 17, 2)] = 0.0067
        pgm_function13[(25, 0, 29)] = 0.0044
        pgm_function13[(25, 0, 30)] = 0.1178
        pgm_function13[(25, 0, 31)] = 0.3211
        pgm_function13[(25, 0, 32)] = 0.3767
        pgm_function13[(25, 0, 33)] = 0.20997904
        pgm_function13[(25, 0, 34)] = 0.06670678
        pgm_function13[(25, 1, 27)] = 0.0022
        pgm_function13[(25, 1, 28)] = 0.073307311
        pgm_function13[(25, 1, 29)] = 0.2522
        pgm_function13[(25, 1, 30)] = 0.35443518
        pgm_function13[(25, 1, 31)] = 0.2667
        pgm_function13[(25, 1, 32)] = 0.1189
        pgm_function13[(25, 1, 33)] = 0.02220222
        pgm_function13[(25, 2, 25)] = 0.00110011
        pgm_function13[(25, 2, 26)] = 0.058894139
        pgm_function13[(25, 2, 27)] = 0.23442319
        pgm_function13[(25, 2, 28)] = 0.3489
        pgm_function13[(25, 2, 29)] = 0.2889
        pgm_function13[(25, 2, 30)] = 0.13441305
        pgm_function13[(25, 2, 31)] = 0.0289
        pgm_function13[(25, 3, 24)] = 0.04780484
        pgm_function13[(25, 3, 25)] = 0.20887923
        pgm_function13[(25, 3, 26)] = 0.35
        pgm_function13[(25, 3, 27)] = 0.3022
        pgm_function13[(25, 3, 28)] = 0.14888507
        pgm_function13[(25, 3, 29)] = 0.0367
        pgm_function13[(25, 4, 22)] = 0.0356
        pgm_function13[(25, 4, 23)] = 0.1822
        pgm_function13[(25, 4, 24)] = 0.3444
        pgm_function13[(25, 4, 25)] = 0.3167
        pgm_function13[(25, 4, 26)] = 0.1678
        pgm_function13[(25, 4, 27)] = 0.0456
        pgm_function13[(25, 4, 28)] = 0.00110011
        pgm_function13[(25, 5, 20)] = 0.02329773
        pgm_function13[(25, 5, 21)] = 0.1667
        pgm_function13[(25, 5, 22)] = 0.33113326
        pgm_function13[(25, 5, 23)] = 0.3322
        pgm_function13[(25, 5, 24)] = 0.1844
        pgm_function13[(25, 5, 25)] = 0.054405408
        pgm_function13[(25, 5, 26)] = 0.0022
        pgm_function13[(25, 6, 18)] = 0.0156
        pgm_function13[(25, 6, 19)] = 0.14668515
        pgm_function13[(25, 6, 20)] = 0.3144
        pgm_function13[(25, 6, 21)] = 0.3444
        pgm_function13[(25, 6, 22)] = 0.202220091
        pgm_function13[(25, 6, 23)] = 0.06440639
        pgm_function13[(25, 6, 24)] = 0.004400441
        pgm_function13[(25, 7, 16)] = 0.0111
        pgm_function13[(25, 7, 17)] = 0.12328807
        pgm_function13[(25, 7, 18)] = 0.3056
        pgm_function13[(25, 7, 19)] = 0.3511
        pgm_function13[(25, 7, 20)] = 0.222222216
        pgm_function13[(25, 7, 21)] = 0.0744
        pgm_function13[(25, 7, 22)] = 0.0078
        pgm_function13[(25, 8, 14)] = 0.006699334
        pgm_function13[(25, 8, 15)] = 0.1011
        pgm_function13[(25, 8, 16)] = 0.2956
        pgm_function13[(25, 8, 17)] = 0.35
        pgm_function13[(25, 8, 18)] = 0.2422
        pgm_function13[(25, 8, 19)] = 0.086691368
        pgm_function13[(25, 8, 20)] = 0.0111
        pgm_function13[(25, 9, 12)] = 0.0033
        pgm_function13[(25, 9, 13)] = 0.0844
        pgm_function13[(25, 9, 14)] = 0.2711
        pgm_function13[(25, 9, 15)] = 0.3578
        pgm_function13[(25, 9, 16)] = 0.259974125
        pgm_function13[(25, 9, 17)] = 0.09891001
        pgm_function13[(25, 9, 18)] = 0.0167
        pgm_function13[(25, 10, 10)] = 0.0011
        pgm_function13[(25, 10, 11)] = 0.0711
        pgm_function13[(25, 10, 12)] = 0.2467
        pgm_function13[(25, 10, 13)] = 0.361064173
        pgm_function13[(25, 10, 14)] = 0.2789
        pgm_function13[(25, 10, 15)] = 0.1133
        pgm_function13[(25, 10, 16)] = 0.0211
        pgm_function13[(25, 11, 9)] = 0.0544
        pgm_function13[(25, 11, 10)] = 0.2267
        pgm_function13[(25, 11, 11)] = 0.35886429
        pgm_function13[(25, 11, 12)] = 0.29887018
        pgm_function13[(25, 11, 13)] = 0.1311
        pgm_function13[(25, 11, 14)] = 0.02779721
        pgm_function13[(25, 12, 7)] = 0.0389
        pgm_function13[(25, 12, 8)] = 0.2056
        pgm_function13[(25, 12, 9)] = 0.35326511
        pgm_function13[(25, 12, 10)] = 0.3133
        pgm_function13[(25, 12, 11)] = 0.1478
        pgm_function13[(25, 12, 12)] = 0.03440342
        pgm_function13[(25, 13, 5)] = 0.0289
        pgm_function13[(25, 13, 6)] = 0.1833
        pgm_function13[(25, 13, 7)] = 0.34776528
        pgm_function13[(25, 13, 8)] = 0.3211
        pgm_function13[(25, 13, 9)] = 0.167817119
        pgm_function13[(25, 13, 10)] = 0.041095927
        pgm_function13[(25, 13, 11)] = 0.0011
        pgm_function13[(25, 14, 3)] = 0.02219782
        pgm_function13[(25, 14, 4)] = 0.1567
        pgm_function13[(25, 14, 5)] = 0.3411
        pgm_function13[(25, 14, 6)] = 0.3322
        pgm_function13[(25, 14, 7)] = 0.191119088
        pgm_function13[(25, 14, 8)] = 0.0489
        pgm_function13[(25, 14, 9)] = 0.0022
        pgm_function13[(25, 15, 1)] = 0.01330131
        pgm_function13[(25, 15, 2)] = 0.1389
        pgm_function13[(25, 15, 3)] = 0.3233
        pgm_function13[(25, 15, 4)] = 0.34673509
        pgm_function13[(25, 15, 5)] = 0.21
        pgm_function13[(25, 15, 6)] = 0.0589
        pgm_function13[(25, 15, 7)] = 0.0044
        pgm_function13[(25, 16, 0)] = 0.1456
        pgm_function13[(25, 16, 1)] = 0.303330112
        pgm_function13[(25, 16, 2)] = 0.3578
        pgm_function13[(25, 16, 3)] = 0.2267
        pgm_function13[(25, 16, 4)] = 0.072207226
        pgm_function13[(25, 16, 5)] = 0.006700678
        pgm_function13[(25, 17, 0)] = 0.35776411
        pgm_function13[(25, 17, 1)] = 0.246725113
        pgm_function13[(25, 17, 2)] = 0.0844
        pgm_function13[(25, 17, 3)] = 0.009999007
        pgm_function13[(25, 18, 0)] = 0.0822
        pgm_function13[(25, 18, 1)] = 0.01330131
        pgm_function13[(26, 0, 30)] = 0.0022
        pgm_function13[(26, 0, 31)] = 0.0978
        pgm_function13[(26, 0, 32)] = 0.3033
        pgm_function13[(26, 0, 33)] = 0.38216208
        pgm_function13[(26, 0, 34)] = 0.23442328
        pgm_function13[(26, 0, 35)] = 0.0833
        pgm_function13[(26, 1, 28)] = 0.00110011
        pgm_function13[(26, 1, 29)] = 0.0633
        pgm_function13[(26, 1, 30)] = 0.23442312
        pgm_function13[(26, 1, 31)] = 0.3544
        pgm_function13[(26, 1, 32)] = 0.28
        pgm_function13[(26, 1, 33)] = 0.13221315
        pgm_function13[(26, 1, 34)] = 0.0289
        pgm_function13[(26, 2, 27)] = 0.04780484
        pgm_function13[(26, 2, 28)] = 0.2178
        pgm_function13[(26, 2, 29)] = 0.3444
        pgm_function13[(26, 2, 30)] = 0.30113012
        pgm_function13[(26, 2, 31)] = 0.1478
        pgm_function13[(26, 2, 32)] = 0.0356
        pgm_function13[(26, 3, 25)] = 0.03779624
        pgm_function13[(26, 3, 26)] = 0.1911
        pgm_function13[(26, 3, 27)] = 0.3378
        pgm_function13[(26, 3, 28)] = 0.31776816
        pgm_function13[(26, 3, 29)] = 0.1622
        pgm_function13[(26, 3, 30)] = 0.0444
        pgm_function13[(26, 3, 31)] = 0.0011
        pgm_function13[(26, 4, 23)] = 0.0289
        pgm_function13[(26, 4, 24)] = 0.1656
        pgm_function13[(26, 4, 25)] = 0.3344
        pgm_function13[(26, 4, 26)] = 0.3256
        pgm_function13[(26, 4, 27)] = 0.1811
        pgm_function13[(26, 4, 28)] = 0.0544054
        pgm_function13[(26, 4, 29)] = 0.00220022
        pgm_function13[(26, 5, 21)] = 0.0189
        pgm_function13[(26, 5, 22)] = 0.14891512
        pgm_function13[(26, 5, 23)] = 0.32
        pgm_function13[(26, 5, 24)] = 0.3378
        pgm_function13[(26, 5, 25)] = 0.20002003
        pgm_function13[(26, 5, 26)] = 0.0633
        pgm_function13[(26, 5, 27)] = 0.004400439
        pgm_function13[(26, 6, 19)] = 0.01109891
        pgm_function13[(26, 6, 20)] = 0.1311
        pgm_function13[(26, 6, 21)] = 0.3033
        pgm_function13[(26, 6, 22)] = 0.352235159
        pgm_function13[(26, 6, 23)] = 0.21892197
        pgm_function13[(26, 6, 24)] = 0.073307311
        pgm_function13[(26, 6, 25)] = 0.0078
        pgm_function13[(26, 7, 17)] = 0.006699334
        pgm_function13[(26, 7, 18)] = 0.1089
        pgm_function13[(26, 7, 19)] = 0.29
        pgm_function13[(26, 7, 20)] = 0.354435344
        pgm_function13[(26, 7, 21)] = 0.2378
        pgm_function13[(26, 7, 22)] = 0.0844
        pgm_function13[(26, 7, 23)] = 0.0111
        pgm_function13[(26, 8, 15)] = 0.0044
        pgm_function13[(26, 8, 16)] = 0.0844
        pgm_function13[(26, 8, 17)] = 0.2789
        pgm_function13[(26, 8, 18)] = 0.3556
        pgm_function13[(26, 8, 19)] = 0.2566742
        pgm_function13[(26, 8, 20)] = 0.0967
        pgm_function13[(26, 8, 21)] = 0.01669671
        pgm_function13[(26, 9, 13)] = 0.0022
        pgm_function13[(26, 9, 14)] = 0.0711
        pgm_function13[(26, 9, 15)] = 0.2567
        pgm_function13[(26, 9, 16)] = 0.355564171
        pgm_function13[(26, 9, 17)] = 0.2744273
        pgm_function13[(26, 9, 18)] = 0.11
        pgm_function13[(26, 9, 19)] = 0.02110211
        pgm_function13[(26, 10, 12)] = 0.0589
        pgm_function13[(26, 10, 13)] = 0.22887711
        pgm_function13[(26, 10, 14)] = 0.3589
        pgm_function13[(26, 10, 15)] = 0.2922
        pgm_function13[(26, 10, 16)] = 0.1289
        pgm_function13[(26, 10, 17)] = 0.0278
        pgm_function13[(26, 11, 10)] = 0.0444
        pgm_function13[(26, 11, 11)] = 0.20667917
        pgm_function13[(26, 11, 12)] = 0.35666421
        pgm_function13[(26, 11, 13)] = 0.3067
        pgm_function13[(26, 11, 14)] = 0.14668506
        pgm_function13[(26, 11, 15)] = 0.03440342
        pgm_function13[(26, 12, 8)] = 0.0322
        pgm_function13[(26, 12, 9)] = 0.18558106
        pgm_function13[(26, 12, 10)] = 0.3456
        pgm_function13[(26, 12, 11)] = 0.3211
        pgm_function13[(26, 12, 12)] = 0.16441608
        pgm_function13[(26, 12, 13)] = 0.041095932
        pgm_function13[(26, 12, 14)] = 0.001100111
        pgm_function13[(26, 13, 6)] = 0.0222
        pgm_function13[(26, 13, 7)] = 0.16558313
        pgm_function13[(26, 13, 8)] = 0.3378
        pgm_function13[(26, 13, 9)] = 0.334433237
        pgm_function13[(26, 13, 10)] = 0.185581122
        pgm_function13[(26, 13, 11)] = 0.0489
        pgm_function13[(26, 13, 12)] = 0.002200221
        pgm_function13[(26, 14, 4)] = 0.0156
        pgm_function13[(26, 14, 5)] = 0.1411
        pgm_function13[(26, 14, 6)] = 0.3267
        pgm_function13[(26, 14, 7)] = 0.341134157
        pgm_function13[(26, 14, 8)] = 0.2089
        pgm_function13[(26, 14, 9)] = 0.0567
        pgm_function13[(26, 14, 10)] = 0.0044
        pgm_function13[(26, 15, 2)] = 0.01
        pgm_function13[(26, 15, 3)] = 0.12
        pgm_function13[(26, 15, 4)] = 0.310031081
        pgm_function13[(26, 15, 5)] = 0.35
        pgm_function13[(26, 15, 6)] = 0.2267
        pgm_function13[(26, 15, 7)] = 0.0678
        pgm_function13[(26, 15, 8)] = 0.006699332
        pgm_function13[(26, 16, 0)] = 0.0044
        pgm_function13[(26, 16, 1)] = 0.103310038
        pgm_function13[(26, 16, 2)] = 0.2889
        pgm_function13[(26, 16, 3)] = 0.3611
        pgm_function13[(26, 16, 4)] = 0.240024086
        pgm_function13[(26, 16, 5)] = 0.083308394
        pgm_function13[(26, 16, 6)] = 0.009999006
        pgm_function13[(26, 17, 0)] = 0.29777009
        pgm_function13[(26, 17, 1)] = 0.364436168
        pgm_function13[(26, 17, 2)] = 0.26
        pgm_function13[(26, 17, 3)] = 0.098890169
        pgm_function13[(26, 17, 4)] = 0.01330131
        pgm_function13[(26, 18, 0)] = 0.2656
        pgm_function13[(26, 18, 1)] = 0.1144111
        pgm_function13[(26, 18, 2)] = 0.0178
        pgm_function13[(26, 19, 0)] = 0.01559841
        pgm_function13[(27, 0, 31)] = 0.0011
        pgm_function13[(27, 0, 32)] = 0.0811
        pgm_function13[(27, 0, 33)] = 0.28667106
        pgm_function13[(27, 0, 34)] = 0.37333745
        pgm_function13[(27, 0, 35)] = 0.2422
        pgm_function13[(27, 0, 36)] = 0.09440947
        pgm_function13[(27, 0, 37)] = 0.005599444
        pgm_function13[(27, 1, 30)] = 0.05220523
        pgm_function13[(27, 1, 31)] = 0.2178
        pgm_function13[(27, 1, 32)] = 0.3522
        pgm_function13[(27, 1, 33)] = 0.29332932
        pgm_function13[(27, 1, 34)] = 0.1467
        pgm_function13[(27, 1, 35)] = 0.03559644
        pgm_function13[(27, 2, 28)] = 0.0389
        pgm_function13[(27, 2, 29)] = 0.1978
        pgm_function13[(27, 2, 30)] = 0.33783414
        pgm_function13[(27, 2, 31)] = 0.3111
        pgm_function13[(27, 2, 32)] = 0.1611
        pgm_function13[(27, 2, 33)] = 0.043295756
        pgm_function13[(27, 2, 34)] = 0.001100111
        pgm_function13[(27, 3, 26)] = 0.0289
        pgm_function13[(27, 3, 27)] = 0.1767
        pgm_function13[(27, 3, 28)] = 0.32996716
        pgm_function13[(27, 3, 29)] = 0.3278
        pgm_function13[(27, 3, 30)] = 0.1756
        pgm_function13[(27, 3, 31)] = 0.0544
        pgm_function13[(27, 3, 32)] = 0.0022
        pgm_function13[(27, 4, 24)] = 0.0222
        pgm_function13[(27, 4, 25)] = 0.1511
        pgm_function13[(27, 4, 26)] = 0.3244
        pgm_function13[(27, 4, 27)] = 0.3344
        pgm_function13[(27, 4, 28)] = 0.19441901
        pgm_function13[(27, 4, 29)] = 0.06330631
        pgm_function13[(27, 4, 30)] = 0.004400441
        pgm_function13[(27, 5, 22)] = 0.01330131
        pgm_function13[(27, 5, 23)] = 0.1289
        pgm_function13[(27, 5, 24)] = 0.3122
        pgm_function13[(27, 5, 25)] = 0.342234051
        pgm_function13[(27, 5, 26)] = 0.2156
        pgm_function13[(27, 5, 27)] = 0.073307282
        pgm_function13[(27, 5, 28)] = 0.0078
        pgm_function13[(27, 6, 20)] = 0.0078
        pgm_function13[(27, 6, 21)] = 0.1133
        pgm_function13[(27, 6, 22)] = 0.290029131
        pgm_function13[(27, 6, 23)] = 0.35113495
        pgm_function13[(27, 6, 24)] = 0.235624035
        pgm_function13[(27, 6, 25)] = 0.0833
        pgm_function13[(27, 6, 26)] = 0.0111
        pgm_function13[(27, 7, 18)] = 0.0044
        pgm_function13[(27, 7, 19)] = 0.0933
        pgm_function13[(27, 7, 20)] = 0.273327265
        pgm_function13[(27, 7, 21)] = 0.3589
        pgm_function13[(27, 7, 22)] = 0.2522
        pgm_function13[(27, 7, 23)] = 0.0944
        pgm_function13[(27, 7, 24)] = 0.01669831
        pgm_function13[(27, 8, 16)] = 0.0022
        pgm_function13[(27, 8, 17)] = 0.0744
        pgm_function13[(27, 8, 18)] = 0.26
        pgm_function13[(27, 8, 19)] = 0.356664278
        pgm_function13[(27, 8, 20)] = 0.2722
        pgm_function13[(27, 8, 21)] = 0.10777804
        pgm_function13[(27, 8, 22)] = 0.0211
        pgm_function13[(27, 9, 14)] = 0.0011
        pgm_function13[(27, 9, 15)] = 0.0589
        pgm_function13[(27, 9, 16)] = 0.239976115
        pgm_function13[(27, 9, 17)] = 0.35443539
        pgm_function13[(27, 9, 18)] = 0.2911
        pgm_function13[(27, 9, 19)] = 0.12441206
        pgm_function13[(27, 9, 20)] = 0.0278
        pgm_function13[(27, 10, 13)] = 0.047795223
        pgm_function13[(27, 10, 14)] = 0.2122
        pgm_function13[(27, 10, 15)] = 0.3522
        pgm_function13[(27, 10, 16)] = 0.3022
        pgm_function13[(27, 10, 17)] = 0.1433
        pgm_function13[(27, 10, 18)] = 0.0344
        pgm_function13[(27, 11, 11)] = 0.03559643
        pgm_function13[(27, 11, 12)] = 0.18558111
        pgm_function13[(27, 11, 13)] = 0.35
        pgm_function13[(27, 11, 14)] = 0.31326913
        pgm_function13[(27, 11, 15)] = 0.16221608
        pgm_function13[(27, 11, 16)] = 0.0411
        pgm_function13[(27, 11, 17)] = 0.001100111
        pgm_function13[(27, 12, 9)] = 0.02559741
        pgm_function13[(27, 12, 10)] = 0.1667
        pgm_function13[(27, 12, 11)] = 0.3411
        pgm_function13[(27, 12, 12)] = 0.32893316
        pgm_function13[(27, 12, 13)] = 0.181082139
        pgm_function13[(27, 12, 14)] = 0.048904927
        pgm_function13[(27, 12, 15)] = 0.0022
        pgm_function13[(27, 13, 7)] = 0.01559841
        pgm_function13[(27, 13, 8)] = 0.1489
        pgm_function13[(27, 13, 9)] = 0.32333223
        pgm_function13[(27, 13, 10)] = 0.344366227
        pgm_function13[(27, 13, 11)] = 0.2022
        pgm_function13[(27, 13, 12)] = 0.056705726
        pgm_function13[(27, 13, 13)] = 0.0044
        pgm_function13[(27, 14, 5)] = 0.0111
        pgm_function13[(27, 14, 6)] = 0.1256
        pgm_function13[(27, 14, 7)] = 0.311131143
        pgm_function13[(27, 14, 8)] = 0.3478
        pgm_function13[(27, 14, 9)] = 0.2256
        pgm_function13[(27, 14, 10)] = 0.0667
        pgm_function13[(27, 14, 11)] = 0.0067
        pgm_function13[(27, 15, 3)] = 0.0067
        pgm_function13[(27, 15, 4)] = 0.104410027
        pgm_function13[(27, 15, 5)] = 0.2978
        pgm_function13[(27, 15, 6)] = 0.3533
        pgm_function13[(27, 15, 7)] = 0.2422
        pgm_function13[(27, 15, 8)] = 0.079992022
        pgm_function13[(27, 15, 9)] = 0.01000101
        pgm_function13[(27, 16, 1)] = 0.003300331
        pgm_function13[(27, 16, 2)] = 0.0867
        pgm_function13[(27, 16, 3)] = 0.2756
        pgm_function13[(27, 16, 4)] = 0.363336131
        pgm_function13[(27, 16, 5)] = 0.254425288
        pgm_function13[(27, 16, 6)] = 0.096690358
        pgm_function13[(27, 16, 7)] = 0.01330131
        pgm_function13[(27, 17, 0)] = 0.08669133
        pgm_function13[(27, 17, 1)] = 0.253325117
        pgm_function13[(27, 17, 2)] = 0.3678
        pgm_function13[(27, 17, 3)] = 0.27107319
        pgm_function13[(27, 17, 4)] = 0.11441109
        pgm_function13[(27, 17, 5)] = 0.01780182
        pgm_function13[(27, 18, 0)] = 0.3744
        pgm_function13[(27, 18, 1)] = 0.29112926
        pgm_function13[(27, 18, 2)] = 0.13
        pgm_function13[(27, 18, 3)] = 0.0222
        pgm_function13[(27, 19, 0)] = 0.12558708
        pgm_function13[(27, 19, 1)] = 0.0289
        pgm_function13[(28, 0, 32)] = 0.0011
        pgm_function13[(28, 0, 33)] = 0.06559341
        pgm_function13[(28, 0, 34)] = 0.27442733
        pgm_function13[(28, 0, 35)] = 0.3756
        pgm_function13[(28, 0, 36)] = 0.26222618
        pgm_function13[(28, 0, 37)] = 0.10558908
        pgm_function13[(28, 0, 38)] = 0.0122
        pgm_function13[(28, 1, 31)] = 0.0422
        pgm_function13[(28, 1, 32)] = 0.1967
        pgm_function13[(28, 1, 33)] = 0.34333438
        pgm_function13[(28, 1, 34)] = 0.3056
        pgm_function13[(28, 1, 35)] = 0.15888416
        pgm_function13[(28, 1, 36)] = 0.04330433
        pgm_function13[(28, 1, 37)] = 0.0011
        pgm_function13[(28, 2, 29)] = 0.0311
        pgm_function13[(28, 2, 30)] = 0.18001807
        pgm_function13[(28, 2, 31)] = 0.3333
        pgm_function13[(28, 2, 32)] = 0.32
        pgm_function13[(28, 2, 33)] = 0.17668223
        pgm_function13[(28, 2, 34)] = 0.052205253
        pgm_function13[(28, 2, 35)] = 0.0022
        pgm_function13[(28, 3, 27)] = 0.0222
        pgm_function13[(28, 3, 28)] = 0.15888408
        pgm_function13[(28, 3, 29)] = 0.3189
        pgm_function13[(28, 3, 30)] = 0.3378
        pgm_function13[(28, 3, 31)] = 0.1889
        pgm_function13[(28, 3, 32)] = 0.0622
        pgm_function13[(28, 3, 33)] = 0.0044
        pgm_function13[(28, 4, 25)] = 0.0156
        pgm_function13[(28, 4, 26)] = 0.1344
        pgm_function13[(28, 4, 27)] = 0.3122
        pgm_function13[(28, 4, 28)] = 0.34333402
        pgm_function13[(28, 4, 29)] = 0.20892103
        pgm_function13[(28, 4, 30)] = 0.073307325
        pgm_function13[(28, 4, 31)] = 0.007799225
        pgm_function13[(28, 5, 23)] = 0.0111
        pgm_function13[(28, 5, 24)] = 0.1133
        pgm_function13[(28, 5, 25)] = 0.298930045
        pgm_function13[(28, 5, 26)] = 0.3444
        pgm_function13[(28, 5, 27)] = 0.232222942
        pgm_function13[(28, 5, 28)] = 0.0822
        pgm_function13[(28, 5, 29)] = 0.0111011
        pgm_function13[(28, 6, 21)] = 0.0056
        pgm_function13[(28, 6, 22)] = 0.095609643
        pgm_function13[(28, 6, 23)] = 0.27782796
        pgm_function13[(28, 6, 24)] = 0.352235053
        pgm_function13[(28, 6, 25)] = 0.25
        pgm_function13[(28, 6, 26)] = 0.0944
        pgm_function13[(28, 6, 27)] = 0.0156
        pgm_function13[(28, 7, 19)] = 0.0022
        pgm_function13[(28, 7, 20)] = 0.081108179
        pgm_function13[(28, 7, 21)] = 0.2556
        pgm_function13[(28, 7, 22)] = 0.3611
        pgm_function13[(28, 7, 23)] = 0.2689
        pgm_function13[(28, 7, 24)] = 0.10558905
        pgm_function13[(28, 7, 25)] = 0.0211
        pgm_function13[(28, 8, 17)] = 0.0011
        pgm_function13[(28, 8, 18)] = 0.0622
        pgm_function13[(28, 8, 19)] = 0.238876186
        pgm_function13[(28, 8, 20)] = 0.3578
        pgm_function13[(28, 8, 21)] = 0.28554311
        pgm_function13[(28, 8, 22)] = 0.1222
        pgm_function13[(28, 8, 23)] = 0.02669732
        pgm_function13[(28, 9, 16)] = 0.047795223
        pgm_function13[(28, 9, 17)] = 0.22222224
        pgm_function13[(28, 9, 18)] = 0.3489
        pgm_function13[(28, 9, 19)] = 0.30113015
        pgm_function13[(28, 9, 20)] = 0.14
        pgm_function13[(28, 9, 21)] = 0.03330331
        pgm_function13[(28, 10, 14)] = 0.0378
        pgm_function13[(28, 10, 15)] = 0.1967
        pgm_function13[(28, 10, 16)] = 0.3478
        pgm_function13[(28, 10, 17)] = 0.3122
        pgm_function13[(28, 10, 18)] = 0.1578
        pgm_function13[(28, 10, 19)] = 0.04
        pgm_function13[(28, 10, 20)] = 0.0011
        pgm_function13[(28, 11, 12)] = 0.02889712
        pgm_function13[(28, 11, 13)] = 0.1689
        pgm_function13[(28, 11, 14)] = 0.34556514
        pgm_function13[(28, 11, 15)] = 0.32333216
        pgm_function13[(28, 11, 16)] = 0.1778
        pgm_function13[(28, 11, 17)] = 0.048904927
        pgm_function13[(28, 11, 18)] = 0.0022
        pgm_function13[(28, 12, 10)] = 0.02
        pgm_function13[(28, 12, 11)] = 0.1478
        pgm_function13[(28, 12, 12)] = 0.33003317
        pgm_function13[(28, 12, 13)] = 0.33776626
        pgm_function13[(28, 12, 14)] = 0.20002011
        pgm_function13[(28, 12, 15)] = 0.0567
        pgm_function13[(28, 12, 16)] = 0.0044
        pgm_function13[(28, 13, 8)] = 0.0111
        pgm_function13[(28, 13, 9)] = 0.131113093
        pgm_function13[(28, 13, 10)] = 0.307769203
        pgm_function13[(28, 13, 11)] = 0.3489
        pgm_function13[(28, 13, 12)] = 0.218922101
        pgm_function13[(28, 13, 13)] = 0.0656
        pgm_function13[(28, 13, 14)] = 0.0067
        pgm_function13[(28, 14, 6)] = 0.0067
        pgm_function13[(28, 14, 7)] = 0.111111051
        pgm_function13[(28, 14, 8)] = 0.2933
        pgm_function13[(28, 14, 9)] = 0.3544
        pgm_function13[(28, 14, 10)] = 0.2378
        pgm_function13[(28, 14, 11)] = 0.0789
        pgm_function13[(28, 14, 12)] = 0.01
        pgm_function13[(28, 15, 4)] = 0.004400441
        pgm_function13[(28, 15, 5)] = 0.0889
        pgm_function13[(28, 15, 6)] = 0.2822
        pgm_function13[(28, 15, 7)] = 0.36
        pgm_function13[(28, 15, 8)] = 0.255574069
        pgm_function13[(28, 15, 9)] = 0.09110915
        pgm_function13[(28, 15, 10)] = 0.0133
        pgm_function13[(28, 16, 2)] = 0.0022
        pgm_function13[(28, 16, 3)] = 0.0722
        pgm_function13[(28, 16, 4)] = 0.260026094
        pgm_function13[(28, 16, 5)] = 0.364436412
        pgm_function13[(28, 16, 6)] = 0.268873161
        pgm_function13[(28, 16, 7)] = 0.11001107
        pgm_function13[(28, 16, 8)] = 0.01779821
        pgm_function13[(28, 17, 1)] = 0.058905927
        pgm_function13[(28, 17, 2)] = 0.2333
        pgm_function13[(28, 17, 3)] = 0.365563256
        pgm_function13[(28, 17, 4)] = 0.28222823
        pgm_function13[(28, 17, 5)] = 0.12891313
        pgm_function13[(28, 17, 6)] = 0.0222
        pgm_function13[(28, 18, 0)] = 0.2356
        pgm_function13[(28, 18, 1)] = 0.35893632
        pgm_function13[(28, 18, 2)] = 0.3
        pgm_function13[(28, 18, 3)] = 0.1478
        pgm_function13[(28, 18, 4)] = 0.02890293
        pgm_function13[(28, 19, 0)] = 0.29777018
        pgm_function13[(28, 19, 1)] = 0.1633
        pgm_function13[(28, 19, 2)] = 0.036696314
        pgm_function13[(28, 20, 0)] = 0.0344
        pgm_function13[(28, 20, 1)] = 0.001099891
        pgm_function13[(29, 0, 34)] = 0.05110516
        pgm_function13[(29, 0, 35)] = 0.2622
        pgm_function13[(29, 0, 36)] = 0.37003726
        pgm_function13[(29, 0, 37)] = 0.277772211
        pgm_function13[(29, 0, 38)] = 0.1111
        pgm_function13[(29, 0, 39)] = 0.0189
        pgm_function13[(29, 1, 32)] = 0.0344
        pgm_function13[(29, 1, 33)] = 0.1822182
        pgm_function13[(29, 1, 34)] = 0.3344
        pgm_function13[(29, 1, 35)] = 0.31556832
        pgm_function13[(29, 1, 36)] = 0.1722171
        pgm_function13[(29, 1, 37)] = 0.0522
        pgm_function13[(29, 1, 38)] = 0.002200221
        pgm_function13[(29, 2, 30)] = 0.02440241
        pgm_function13[(29, 2, 31)] = 0.16
        pgm_function13[(29, 2, 32)] = 0.3267
        pgm_function13[(29, 2, 33)] = 0.328867428
        pgm_function13[(29, 2, 34)] = 0.190019194
        pgm_function13[(29, 2, 35)] = 0.0611
        pgm_function13[(29, 2, 36)] = 0.004400443
        pgm_function13[(29, 3, 28)] = 0.01559841
        pgm_function13[(29, 3, 29)] = 0.1422
        pgm_function13[(29, 3, 30)] = 0.31
        pgm_function13[(29, 3, 31)] = 0.3422
        pgm_function13[(29, 3, 32)] = 0.2056
        pgm_function13[(29, 3, 33)] = 0.0722
        pgm_function13[(29, 3, 34)] = 0.006699335
        pgm_function13[(29, 4, 26)] = 0.0111
        pgm_function13[(29, 4, 27)] = 0.12
        pgm_function13[(29, 4, 28)] = 0.29563001
        pgm_function13[(29, 4, 29)] = 0.34893506
        pgm_function13[(29, 4, 30)] = 0.223322076
        pgm_function13[(29, 4, 31)] = 0.082191857
        pgm_function13[(29, 4, 32)] = 0.01110111
        pgm_function13[(29, 5, 24)] = 0.0067
        pgm_function13[(29, 5, 25)] = 0.098909915
        pgm_function13[(29, 5, 26)] = 0.2856
        pgm_function13[(29, 5, 27)] = 0.346734913
        pgm_function13[(29, 5, 28)] = 0.2456
        pgm_function13[(29, 5, 29)] = 0.09330933
        pgm_function13[(29, 5, 30)] = 0.01560162
        pgm_function13[(29, 6, 22)] = 0.004400442
        pgm_function13[(29, 6, 23)] = 0.08330829
        pgm_function13[(29, 6, 24)] = 0.263326039
        pgm_function13[(29, 6, 25)] = 0.3522
        pgm_function13[(29, 6, 26)] = 0.2678
        pgm_function13[(29, 6, 27)] = 0.1044
        pgm_function13[(29, 6, 28)] = 0.02110211
        pgm_function13[(29, 7, 20)] = 0.001100111
        pgm_function13[(29, 7, 21)] = 0.0678
        pgm_function13[(29, 7, 22)] = 0.2367
        pgm_function13[(29, 7, 23)] = 0.3589
        pgm_function13[(29, 7, 24)] = 0.28327214
        pgm_function13[(29, 7, 25)] = 0.12
        pgm_function13[(29, 7, 26)] = 0.02670273
        pgm_function13[(29, 8, 19)] = 0.053294742
        pgm_function13[(29, 8, 20)] = 0.2189
        pgm_function13[(29, 8, 21)] = 0.35552914
        pgm_function13[(29, 8, 22)] = 0.2956
        pgm_function13[(29, 8, 23)] = 0.13778612
        pgm_function13[(29, 8, 24)] = 0.0333
        pgm_function13[(29, 9, 17)] = 0.03780384
        pgm_function13[(29, 9, 18)] = 0.2022
        pgm_function13[(29, 9, 19)] = 0.34673517
        pgm_function13[(29, 9, 20)] = 0.31
        pgm_function13[(29, 9, 21)] = 0.15561605
        pgm_function13[(29, 9, 22)] = 0.04
        pgm_function13[(29, 9, 23)] = 0.0011
        pgm_function13[(29, 10, 15)] = 0.0289
        pgm_function13[(29, 10, 16)] = 0.1778
        pgm_function13[(29, 10, 17)] = 0.3411
        pgm_function13[(29, 10, 18)] = 0.3233
        pgm_function13[(29, 10, 19)] = 0.1744
        pgm_function13[(29, 10, 20)] = 0.0467
        pgm_function13[(29, 10, 21)] = 0.002200219
        pgm_function13[(29, 11, 13)] = 0.0222
        pgm_function13[(29, 11, 14)] = 0.15108506
        pgm_function13[(29, 11, 15)] = 0.33223317
        pgm_function13[(29, 11, 16)] = 0.3344
        pgm_function13[(29, 11, 17)] = 0.194419107
        pgm_function13[(29, 11, 18)] = 0.0567
        pgm_function13[(29, 11, 19)] = 0.00440044
        pgm_function13[(29, 12, 11)] = 0.0144
        pgm_function13[(29, 12, 12)] = 0.13111307
        pgm_function13[(29, 12, 13)] = 0.317768245
        pgm_function13[(29, 12, 14)] = 0.340034187
        pgm_function13[(29, 12, 15)] = 0.2144
        pgm_function13[(29, 12, 16)] = 0.0656
        pgm_function13[(29, 12, 17)] = 0.0067
        pgm_function13[(29, 13, 9)] = 0.008900896
        pgm_function13[(29, 13, 10)] = 0.115588076
        pgm_function13[(29, 13, 11)] = 0.2956
        pgm_function13[(29, 13, 12)] = 0.352235162
        pgm_function13[(29, 13, 13)] = 0.2344
        pgm_function13[(29, 13, 14)] = 0.0789
        pgm_function13[(29, 13, 15)] = 0.00999901
        pgm_function13[(29, 14, 7)] = 0.004400442
        pgm_function13[(29, 14, 8)] = 0.0978
        pgm_function13[(29, 14, 9)] = 0.2767
        pgm_function13[(29, 14, 10)] = 0.3633
        pgm_function13[(29, 14, 11)] = 0.25
        pgm_function13[(29, 14, 12)] = 0.0911
        pgm_function13[(29, 14, 13)] = 0.0133
        pgm_function13[(29, 15, 5)] = 0.0022
        pgm_function13[(29, 15, 6)] = 0.0756
        pgm_function13[(29, 15, 7)] = 0.26
        pgm_function13[(29, 15, 8)] = 0.362164098
        pgm_function13[(29, 15, 9)] = 0.26892713
        pgm_function13[(29, 15, 10)] = 0.1067
        pgm_function13[(29, 15, 11)] = 0.0178
        pgm_function13[(29, 16, 3)] = 0.0011
        pgm_function13[(29, 16, 4)] = 0.060006022
        pgm_function13[(29, 16, 5)] = 0.242224274
        pgm_function13[(29, 16, 6)] = 0.359964216
        pgm_function13[(29, 16, 7)] = 0.28442817
        pgm_function13[(29, 16, 8)] = 0.12328805
        pgm_function13[(29, 16, 9)] = 0.02220222
        pgm_function13[(29, 17, 2)] = 0.0478
        pgm_function13[(29, 17, 3)] = 0.216678152
        pgm_function13[(29, 17, 4)] = 0.36003629
        pgm_function13[(29, 17, 5)] = 0.29442929
        pgm_function13[(29, 17, 6)] = 0.1444
        pgm_function13[(29, 17, 7)] = 0.0278
        pgm_function13[(29, 18, 0)] = 0.0422
        pgm_function13[(29, 18, 1)] = 0.19441917
        pgm_function13[(29, 18, 2)] = 0.3556
        pgm_function13[(29, 18, 3)] = 0.3133
        pgm_function13[(29, 18, 4)] = 0.16221616
        pgm_function13[(29, 18, 5)] = 0.03559641
        pgm_function13[(29, 19, 0)] = 0.36216422
        pgm_function13[(29, 19, 1)] = 0.3311
        pgm_function13[(29, 19, 2)] = 0.177782066
        pgm_function13[(29, 19, 3)] = 0.0456
        pgm_function13[(29, 19, 4)] = 0.0011
        pgm_function13[(29, 20, 0)] = 0.1767
        pgm_function13[(29, 20, 1)] = 0.055594435
        pgm_function13[(29, 20, 2)] = 0.0022
        pgm_function13[(30, 0, 35)] = 0.0367
        pgm_function13[(30, 0, 36)] = 0.24442417
        pgm_function13[(30, 0, 37)] = 0.363264276
        pgm_function13[(30, 0, 38)] = 0.2978
        pgm_function13[(30, 0, 39)] = 0.1211
        pgm_function13[(30, 0, 40)] = 0.0267
        pgm_function13[(30, 1, 33)] = 0.02670273
        pgm_function13[(30, 1, 34)] = 0.1644
        pgm_function13[(30, 1, 35)] = 0.32556733
        pgm_function13[(30, 1, 36)] = 0.3278332
        pgm_function13[(30, 1, 37)] = 0.1867
        pgm_function13[(30, 1, 38)] = 0.061106115
        pgm_function13[(30, 1, 39)] = 0.004400441
        pgm_function13[(30, 2, 31)] = 0.0189
        pgm_function13[(30, 2, 32)] = 0.1422
        pgm_function13[(30, 2, 33)] = 0.31556841
        pgm_function13[(30, 2, 34)] = 0.33333334
        pgm_function13[(30, 2, 35)] = 0.2056
        pgm_function13[(30, 2, 36)] = 0.070007045
        pgm_function13[(30, 2, 37)] = 0.006699333
        pgm_function13[(30, 3, 29)] = 0.0122
        pgm_function13[(30, 3, 30)] = 0.1233
        pgm_function13[(30, 3, 31)] = 0.2989
        pgm_function13[(30, 3, 32)] = 0.3467
        pgm_function13[(30, 3, 33)] = 0.22
        pgm_function13[(30, 3, 34)] = 0.081091963
        pgm_function13[(30, 3, 35)] = 0.0111
        pgm_function13[(30, 4, 27)] = 0.0067
        pgm_function13[(30, 4, 28)] = 0.10671101
        pgm_function13[(30, 4, 29)] = 0.28332805
        pgm_function13[(30, 4, 30)] = 0.35223512
        pgm_function13[(30, 4, 31)] = 0.236676163
        pgm_function13[(30, 4, 32)] = 0.0922093
        pgm_function13[(30, 4, 33)] = 0.0156
        pgm_function13[(30, 5, 25)] = 0.004400441
        pgm_function13[(30, 5, 26)] = 0.0867
        pgm_function13[(30, 5, 27)] = 0.267826933
        pgm_function13[(30, 5, 28)] = 0.3511
        pgm_function13[(30, 5, 29)] = 0.26112608
        pgm_function13[(30, 5, 30)] = 0.10441011
        pgm_function13[(30, 5, 31)] = 0.02110211
        pgm_function13[(30, 6, 23)] = 0.00220022
        pgm_function13[(30, 6, 24)] = 0.070007011
        pgm_function13[(30, 6, 25)] = 0.2478
        pgm_function13[(30, 6, 26)] = 0.3478
        pgm_function13[(30, 6, 27)] = 0.2811
        pgm_function13[(30, 6, 28)] = 0.11781208
        pgm_function13[(30, 6, 29)] = 0.0267
        pgm_function13[(30, 7, 21)] = 0.0011
        pgm_function13[(30, 7, 22)] = 0.0578
        pgm_function13[(30, 7, 23)] = 0.2189
        pgm_function13[(30, 7, 24)] = 0.34996517
        pgm_function13[(30, 7, 25)] = 0.2944
        pgm_function13[(30, 7, 26)] = 0.13441315
        pgm_function13[(30, 7, 27)] = 0.03329673
        pgm_function13[(30, 8, 20)] = 0.0433
        pgm_function13[(30, 8, 21)] = 0.19886008
        pgm_function13[(30, 8, 22)] = 0.3511
        pgm_function13[(30, 8, 23)] = 0.30556928
        pgm_function13[(30, 8, 24)] = 0.1533
        pgm_function13[(30, 8, 25)] = 0.04000404
        pgm_function13[(30, 8, 26)] = 0.0011
        pgm_function13[(30, 9, 18)] = 0.0311
        pgm_function13[(30, 9, 19)] = 0.18221809
        pgm_function13[(30, 9, 20)] = 0.3422
        pgm_function13[(30, 9, 21)] = 0.3178321
        pgm_function13[(30, 9, 22)] = 0.1733
        pgm_function13[(30, 9, 23)] = 0.0467
        pgm_function13[(30, 9, 24)] = 0.00220022
        pgm_function13[(30, 10, 16)] = 0.0222
        pgm_function13[(30, 10, 17)] = 0.16
        pgm_function13[(30, 10, 18)] = 0.3278
        pgm_function13[(30, 10, 19)] = 0.3344
        pgm_function13[(30, 10, 20)] = 0.1911
        pgm_function13[(30, 10, 21)] = 0.054405375
        pgm_function13[(30, 10, 22)] = 0.00440044
        pgm_function13[(30, 11, 14)] = 0.01559841
        pgm_function13[(30, 11, 15)] = 0.13671407
        pgm_function13[(30, 11, 16)] = 0.3178
        pgm_function13[(30, 11, 17)] = 0.340034187
        pgm_function13[(30, 11, 18)] = 0.21
        pgm_function13[(30, 11, 19)] = 0.0644064
        pgm_function13[(30, 11, 20)] = 0.0067
        pgm_function13[(30, 12, 12)] = 0.01110111
        pgm_function13[(30, 12, 13)] = 0.115588089
        pgm_function13[(30, 12, 14)] = 0.304430167
        pgm_function13[(30, 12, 15)] = 0.3456
        pgm_function13[(30, 12, 16)] = 0.2289
        pgm_function13[(30, 12, 17)] = 0.0767
        pgm_function13[(30, 12, 18)] = 0.01000101
        pgm_function13[(30, 13, 10)] = 0.005599444
        pgm_function13[(30, 13, 11)] = 0.0989
        pgm_function13[(30, 13, 12)] = 0.28332813
        pgm_function13[(30, 13, 13)] = 0.3556
        pgm_function13[(30, 13, 14)] = 0.2467
        pgm_function13[(30, 13, 15)] = 0.09109099
        pgm_function13[(30, 13, 16)] = 0.0133
        pgm_function13[(30, 14, 8)] = 0.0022
        pgm_function13[(30, 14, 9)] = 0.0833
        pgm_function13[(30, 14, 10)] = 0.2567
        pgm_function13[(30, 14, 11)] = 0.3644
        pgm_function13[(30, 14, 12)] = 0.2622
        pgm_function13[(30, 14, 13)] = 0.1056
        pgm_function13[(30, 14, 14)] = 0.01779821
        pgm_function13[(30, 15, 6)] = 0.0011
        pgm_function13[(30, 15, 7)] = 0.0656
        pgm_function13[(30, 15, 8)] = 0.239976065
        pgm_function13[(30, 15, 9)] = 0.36333618
        pgm_function13[(30, 15, 10)] = 0.2811
        pgm_function13[(30, 15, 11)] = 0.1211
        pgm_function13[(30, 15, 12)] = 0.0222
        pgm_function13[(30, 16, 5)] = 0.048904955
        pgm_function13[(30, 16, 6)] = 0.225577135
        pgm_function13[(30, 16, 7)] = 0.35443521
        pgm_function13[(30, 16, 8)] = 0.29667012
        pgm_function13[(30, 16, 9)] = 0.1400141
        pgm_function13[(30, 16, 10)] = 0.02779439
        pgm_function13[(30, 17, 3)] = 0.037796226
        pgm_function13[(30, 17, 4)] = 0.20112016
        pgm_function13[(30, 17, 5)] = 0.35333535
        pgm_function13[(30, 17, 6)] = 0.31
        pgm_function13[(30, 17, 7)] = 0.16
        pgm_function13[(30, 17, 8)] = 0.035596414
        pgm_function13[(30, 18, 1)] = 0.02780283
        pgm_function13[(30, 18, 2)] = 0.1744
        pgm_function13[(30, 18, 3)] = 0.3433
        pgm_function13[(30, 18, 4)] = 0.32223232
        pgm_function13[(30, 18, 5)] = 0.176682048
        pgm_function13[(30, 18, 6)] = 0.044404407
        pgm_function13[(30, 18, 7)] = 0.0011
        pgm_function13[(30, 19, 0)] = 0.17888211
        pgm_function13[(30, 19, 1)] = 0.3289
        pgm_function13[(30, 19, 2)] = 0.339966126
        pgm_function13[(30, 19, 3)] = 0.1922
        pgm_function13[(30, 19, 4)] = 0.0556
        pgm_function13[(30, 19, 5)] = 0.0022
        pgm_function13[(30, 20, 0)] = 0.3411
        pgm_function13[(30, 20, 1)] = 0.208879132
        pgm_function13[(30, 20, 2)] = 0.0656
        pgm_function13[(30, 20, 3)] = 0.0044
        pgm_function13[(30, 21, 0)] = 0.05779423
        pgm_function13[(30, 21, 1)] = 0.0067
        pgm_function13[(31, 0, 36)] = 0.02890292
        pgm_function13[(31, 0, 37)] = 0.225577171
        pgm_function13[(31, 0, 38)] = 0.3633
        pgm_function13[(31, 0, 39)] = 0.3078
        pgm_function13[(31, 0, 40)] = 0.1322
        pgm_function13[(31, 0, 41)] = 0.034403432
        pgm_function13[(31, 1, 34)] = 0.02
        pgm_function13[(31, 1, 35)] = 0.14998515
        pgm_function13[(31, 1, 36)] = 0.31333119
        pgm_function13[(31, 1, 37)] = 0.3333
        pgm_function13[(31, 1, 38)] = 0.201120048
        pgm_function13[(31, 1, 39)] = 0.070007015
        pgm_function13[(31, 1, 40)] = 0.006699334
        pgm_function13[(31, 2, 32)] = 0.0144
        pgm_function13[(31, 2, 33)] = 0.125587163
        pgm_function13[(31, 2, 34)] = 0.304430311
        pgm_function13[(31, 2, 35)] = 0.3389
        pgm_function13[(31, 2, 36)] = 0.21892214
        pgm_function13[(31, 2, 37)] = 0.079992038
        pgm_function13[(31, 2, 38)] = 0.01109891
        pgm_function13[(31, 3, 30)] = 0.0089
        pgm_function13[(31, 3, 31)] = 0.1078
        pgm_function13[(31, 3, 32)] = 0.2867
        pgm_function13[(31, 3, 33)] = 0.3456
        pgm_function13[(31, 3, 34)] = 0.237776185
        pgm_function13[(31, 3, 35)] = 0.09
        pgm_function13[(31, 3, 36)] = 0.01559841
        pgm_function13[(31, 4, 28)] = 0.00440044
        pgm_function13[(31, 4, 29)] = 0.09110911
        pgm_function13[(31, 4, 30)] = 0.267827091
        pgm_function13[(31, 4, 31)] = 0.355564245
        pgm_function13[(31, 4, 32)] = 0.25332528
        pgm_function13[(31, 4, 33)] = 0.1033
        pgm_function13[(31, 4, 34)] = 0.0211
        pgm_function13[(31, 5, 26)] = 0.0022
        pgm_function13[(31, 5, 27)] = 0.074407381
        pgm_function13[(31, 5, 28)] = 0.2489
        pgm_function13[(31, 5, 29)] = 0.35113511
        pgm_function13[(31, 5, 30)] = 0.2711273
        pgm_function13[(31, 5, 31)] = 0.11781206
        pgm_function13[(31, 5, 32)] = 0.0267
        pgm_function13[(31, 6, 24)] = 0.00110011
        pgm_function13[(31, 6, 25)] = 0.0589
        pgm_function13[(31, 6, 26)] = 0.23
        pgm_function13[(31, 6, 27)] = 0.3456
        pgm_function13[(31, 6, 28)] = 0.29332921
        pgm_function13[(31, 6, 29)] = 0.1311
        pgm_function13[(31, 6, 30)] = 0.0322
        pgm_function13[(31, 7, 23)] = 0.0478
        pgm_function13[(31, 7, 24)] = 0.2066791
        pgm_function13[(31, 7, 25)] = 0.3456
        pgm_function13[(31, 7, 26)] = 0.30443033
        pgm_function13[(31, 7, 27)] = 0.14888515
        pgm_function13[(31, 7, 28)] = 0.04000403
        pgm_function13[(31, 7, 29)] = 0.0011
        pgm_function13[(31, 8, 21)] = 0.03559291
        pgm_function13[(31, 8, 22)] = 0.1822
        pgm_function13[(31, 8, 23)] = 0.34556531
        pgm_function13[(31, 8, 24)] = 0.3133
        pgm_function13[(31, 8, 25)] = 0.17001715
        pgm_function13[(31, 8, 26)] = 0.0467
        pgm_function13[(31, 8, 27)] = 0.00220022
        pgm_function13[(31, 9, 19)] = 0.02440241
        pgm_function13[(31, 9, 20)] = 0.1611
        pgm_function13[(31, 9, 21)] = 0.3344331
        pgm_function13[(31, 9, 22)] = 0.3256
        pgm_function13[(31, 9, 23)] = 0.1889
        pgm_function13[(31, 9, 24)] = 0.0544054
        pgm_function13[(31, 9, 25)] = 0.0044
        pgm_function13[(31, 10, 17)] = 0.0156
        pgm_function13[(31, 10, 18)] = 0.1456
        pgm_function13[(31, 10, 19)] = 0.3156
        pgm_function13[(31, 10, 20)] = 0.34
        pgm_function13[(31, 10, 21)] = 0.208920904
        pgm_function13[(31, 10, 22)] = 0.0622062
        pgm_function13[(31, 10, 23)] = 0.0067
        pgm_function13[(31, 11, 15)] = 0.01110111
        pgm_function13[(31, 11, 16)] = 0.1222
        pgm_function13[(31, 11, 17)] = 0.302230166
        pgm_function13[(31, 11, 18)] = 0.3489
        pgm_function13[(31, 11, 19)] = 0.22332199
        pgm_function13[(31, 11, 20)] = 0.0744
        pgm_function13[(31, 11, 21)] = 0.009999005
        pgm_function13[(31, 12, 13)] = 0.006699335
        pgm_function13[(31, 12, 14)] = 0.101110056
        pgm_function13[(31, 12, 15)] = 0.2922
        pgm_function13[(31, 12, 16)] = 0.3533
        pgm_function13[(31, 12, 17)] = 0.2422
        pgm_function13[(31, 12, 18)] = 0.09000906
        pgm_function13[(31, 12, 19)] = 0.01330131
        pgm_function13[(31, 13, 11)] = 0.0044
        pgm_function13[(31, 13, 12)] = 0.084408439
        pgm_function13[(31, 13, 13)] = 0.2678
        pgm_function13[(31, 13, 14)] = 0.3544
        pgm_function13[(31, 13, 15)] = 0.25887426
        pgm_function13[(31, 13, 16)] = 0.1033
        pgm_function13[(31, 13, 17)] = 0.0178
        pgm_function13[(31, 14, 9)] = 0.0011
        pgm_function13[(31, 14, 10)] = 0.07
        pgm_function13[(31, 14, 11)] = 0.2411
        pgm_function13[(31, 14, 12)] = 0.3633
        pgm_function13[(31, 14, 13)] = 0.2744
        pgm_function13[(31, 14, 14)] = 0.12108808
        pgm_function13[(31, 14, 15)] = 0.0222
        pgm_function13[(31, 15, 8)] = 0.055594415
        pgm_function13[(31, 15, 9)] = 0.22222211
        pgm_function13[(31, 15, 10)] = 0.3589
        pgm_function13[(31, 15, 11)] = 0.2911
        pgm_function13[(31, 15, 12)] = 0.1378
        pgm_function13[(31, 15, 13)] = 0.0278
        pgm_function13[(31, 16, 6)] = 0.038896123
        pgm_function13[(31, 16, 7)] = 0.20672112
        pgm_function13[(31, 16, 8)] = 0.35106514
        pgm_function13[(31, 16, 9)] = 0.30893122
        pgm_function13[(31, 16, 10)] = 0.15556895
        pgm_function13[(31, 16, 11)] = 0.0356
        pgm_function13[(31, 17, 4)] = 0.02890292
        pgm_function13[(31, 17, 5)] = 0.18331818
        pgm_function13[(31, 17, 6)] = 0.3422
        pgm_function13[(31, 17, 7)] = 0.3222
        pgm_function13[(31, 17, 8)] = 0.172183065
        pgm_function13[(31, 17, 9)] = 0.0433
        pgm_function13[(31, 17, 10)] = 0.00110011
        pgm_function13[(31, 18, 2)] = 0.0222
        pgm_function13[(31, 18, 3)] = 0.1578
        pgm_function13[(31, 18, 4)] = 0.33333333
        pgm_function13[(31, 18, 5)] = 0.33436709
        pgm_function13[(31, 18, 6)] = 0.19001903
        pgm_function13[(31, 18, 7)] = 0.0533
        pgm_function13[(31, 18, 8)] = 0.00220022
        pgm_function13[(31, 19, 0)] = 0.01999801
        pgm_function13[(31, 19, 1)] = 0.1367
        pgm_function13[(31, 19, 2)] = 0.318868118
        pgm_function13[(31, 19, 3)] = 0.3478
        pgm_function13[(31, 19, 4)] = 0.2067
        pgm_function13[(31, 19, 5)] = 0.0644
        pgm_function13[(31, 19, 6)] = 0.004400439
        pgm_function13[(31, 20, 0)] = 0.3278
        pgm_function13[(31, 20, 1)] = 0.359964227
        pgm_function13[(31, 20, 2)] = 0.2267
        pgm_function13[(31, 20, 3)] = 0.0767
        pgm_function13[(31, 20, 4)] = 0.006699334
        pgm_function13[(31, 21, 0)] = 0.22887711
        pgm_function13[(31, 21, 1)] = 0.09
        pgm_function13[(31, 21, 2)] = 0.01
        pgm_function13[(31, 22, 0)] = 0.006699332
        pgm_function13[(32, 0, 37)] = 0.022197817
        pgm_function13[(32, 0, 38)] = 0.1978
        pgm_function13[(32, 0, 39)] = 0.3622
        pgm_function13[(32, 0, 40)] = 0.3256
        pgm_function13[(32, 0, 41)] = 0.144414134
        pgm_function13[(32, 0, 42)] = 0.043304311
        pgm_function13[(32, 1, 35)] = 0.01439861
        pgm_function13[(32, 1, 36)] = 0.13221308
        pgm_function13[(32, 1, 37)] = 0.3
        pgm_function13[(32, 1, 38)] = 0.340034082
        pgm_function13[(32, 1, 39)] = 0.212221047
        pgm_function13[(32, 1, 40)] = 0.079992047
        pgm_function13[(32, 1, 41)] = 0.01
        pgm_function13[(32, 2, 33)] = 0.009999013
        pgm_function13[(32, 2, 34)] = 0.112211114
        pgm_function13[(32, 2, 35)] = 0.2911
        pgm_function13[(32, 2, 36)] = 0.34333422
        pgm_function13[(32, 2, 37)] = 0.235576113
        pgm_function13[(32, 2, 38)] = 0.08779124
        pgm_function13[(32, 2, 39)] = 0.0156
        pgm_function13[(32, 3, 31)] = 0.0067
        pgm_function13[(32, 3, 32)] = 0.0922
        pgm_function13[(32, 3, 33)] = 0.2767
        pgm_function13[(32, 3, 34)] = 0.347765271
        pgm_function13[(32, 3, 35)] = 0.2522
        pgm_function13[(32, 3, 36)] = 0.09999006
        pgm_function13[(32, 3, 37)] = 0.02000202
        pgm_function13[(32, 4, 29)] = 0.00220022
        pgm_function13[(32, 4, 30)] = 0.076707726
        pgm_function13[(32, 4, 31)] = 0.251075173
        pgm_function13[(32, 4, 32)] = 0.35333539
        pgm_function13[(32, 4, 33)] = 0.2667
        pgm_function13[(32, 4, 34)] = 0.1156
        pgm_function13[(32, 4, 35)] = 0.02669732
        pgm_function13[(32, 5, 27)] = 0.00110011
        pgm_function13[(32, 5, 28)] = 0.0644
        pgm_function13[(32, 5, 29)] = 0.23002307
        pgm_function13[(32, 5, 30)] = 0.35333539
        pgm_function13[(32, 5, 31)] = 0.28222814
        pgm_function13[(32, 5, 32)] = 0.13
        pgm_function13[(32, 5, 33)] = 0.03220323
        pgm_function13[(32, 6, 26)] = 0.0489
        pgm_function13[(32, 6, 27)] = 0.2122
        pgm_function13[(32, 6, 28)] = 0.34223424
        pgm_function13[(32, 6, 29)] = 0.3
        pgm_function13[(32, 6, 30)] = 0.1478
        pgm_function13[(32, 6, 31)] = 0.04000402
        pgm_function13[(32, 6, 32)] = 0.0011
        pgm_function13[(32, 7, 24)] = 0.03779622
        pgm_function13[(32, 7, 25)] = 0.19
        pgm_function13[(32, 7, 26)] = 0.34003437
        pgm_function13[(32, 7, 27)] = 0.31556832
        pgm_function13[(32, 7, 28)] = 0.16441612
        pgm_function13[(32, 7, 29)] = 0.0467
        pgm_function13[(32, 7, 30)] = 0.0022
        pgm_function13[(32, 8, 22)] = 0.0278
        pgm_function13[(32, 8, 23)] = 0.16218415
        pgm_function13[(32, 8, 24)] = 0.3367
        pgm_function13[(32, 8, 25)] = 0.32223229
        pgm_function13[(32, 8, 26)] = 0.1833
        pgm_function13[(32, 8, 27)] = 0.0544054
        pgm_function13[(32, 8, 28)] = 0.00440044
        pgm_function13[(32, 9, 20)] = 0.0189
        pgm_function13[(32, 9, 21)] = 0.14441404
        pgm_function13[(32, 9, 22)] = 0.3222
        pgm_function13[(32, 9, 23)] = 0.3333
        pgm_function13[(32, 9, 24)] = 0.20672099
        pgm_function13[(32, 9, 25)] = 0.0622
        pgm_function13[(32, 9, 26)] = 0.0067
        pgm_function13[(32, 10, 18)] = 0.0111
        pgm_function13[(32, 10, 19)] = 0.1267
        pgm_function13[(32, 10, 20)] = 0.3044
        pgm_function13[(32, 10, 21)] = 0.345634841
        pgm_function13[(32, 10, 22)] = 0.22332199
        pgm_function13[(32, 10, 23)] = 0.0722
        pgm_function13[(32, 10, 24)] = 0.01000101
        pgm_function13[(32, 11, 16)] = 0.0067
        pgm_function13[(32, 11, 17)] = 0.10891106
        pgm_function13[(32, 11, 18)] = 0.2867
        pgm_function13[(32, 11, 19)] = 0.35783598
        pgm_function13[(32, 11, 20)] = 0.2367
        pgm_function13[(32, 11, 21)] = 0.087791244
        pgm_function13[(32, 11, 22)] = 0.0133
        pgm_function13[(32, 12, 14)] = 0.004400442
        pgm_function13[(32, 12, 15)] = 0.0867
        pgm_function13[(32, 12, 16)] = 0.2711
        pgm_function13[(32, 12, 17)] = 0.3567
        pgm_function13[(32, 12, 18)] = 0.25222518
        pgm_function13[(32, 12, 19)] = 0.10111004
        pgm_function13[(32, 12, 20)] = 0.01779641
        pgm_function13[(32, 13, 12)] = 0.002200221
        pgm_function13[(32, 13, 13)] = 0.0711
        pgm_function13[(32, 13, 14)] = 0.2544
        pgm_function13[(32, 13, 15)] = 0.35556436
        pgm_function13[(32, 13, 16)] = 0.27
        pgm_function13[(32, 13, 17)] = 0.1189
        pgm_function13[(32, 13, 18)] = 0.0222
        pgm_function13[(32, 14, 10)] = 0.0011
        pgm_function13[(32, 14, 11)] = 0.0589
        pgm_function13[(32, 14, 12)] = 0.2256
        pgm_function13[(32, 14, 13)] = 0.3578
        pgm_function13[(32, 14, 14)] = 0.2866712
        pgm_function13[(32, 14, 15)] = 0.1356
        pgm_function13[(32, 14, 16)] = 0.0278
        pgm_function13[(32, 15, 9)] = 0.04440442
        pgm_function13[(32, 15, 10)] = 0.2033
        pgm_function13[(32, 15, 11)] = 0.3567
        pgm_function13[(32, 15, 12)] = 0.3022
        pgm_function13[(32, 15, 13)] = 0.1533
        pgm_function13[(32, 15, 14)] = 0.0344
        pgm_function13[(32, 16, 7)] = 0.03110312
        pgm_function13[(32, 16, 8)] = 0.18558107
        pgm_function13[(32, 16, 9)] = 0.34333424
        pgm_function13[(32, 16, 10)] = 0.3188359
        pgm_function13[(32, 16, 11)] = 0.17
        pgm_function13[(32, 16, 12)] = 0.0433
        pgm_function13[(32, 16, 13)] = 0.00110011
        pgm_function13[(32, 17, 5)] = 0.02220222
        pgm_function13[(32, 17, 6)] = 0.1656
        pgm_function13[(32, 17, 7)] = 0.3278
        pgm_function13[(32, 17, 8)] = 0.335566128
        pgm_function13[(32, 17, 9)] = 0.1856
        pgm_function13[(32, 17, 10)] = 0.052205218
        pgm_function13[(32, 17, 11)] = 0.00220022
        pgm_function13[(32, 18, 3)] = 0.0156
        pgm_function13[(32, 18, 4)] = 0.14221414
        pgm_function13[(32, 18, 5)] = 0.321068087
        pgm_function13[(32, 18, 6)] = 0.345635055
        pgm_function13[(32, 18, 7)] = 0.2056
        pgm_function13[(32, 18, 8)] = 0.0622062
        pgm_function13[(32, 18, 9)] = 0.004400442
        pgm_function13[(32, 19, 1)] = 0.0111
        pgm_function13[(32, 19, 2)] = 0.119988044
        pgm_function13[(32, 19, 3)] = 0.3056
        pgm_function13[(32, 19, 4)] = 0.3522
        pgm_function13[(32, 19, 5)] = 0.2233
        pgm_function13[(32, 19, 6)] = 0.074407382
        pgm_function13[(32, 19, 7)] = 0.00669933
        pgm_function13[(32, 20, 0)] = 0.1156
        pgm_function13[(32, 20, 1)] = 0.28557118
        pgm_function13[(32, 20, 2)] = 0.36
        pgm_function13[(32, 20, 3)] = 0.2411
        pgm_function13[(32, 20, 4)] = 0.089991051
        pgm_function13[(32, 20, 5)] = 0.01000101
        pgm_function13[(32, 21, 0)] = 0.36996318
        pgm_function13[(32, 21, 1)] = 0.26
        pgm_function13[(32, 21, 2)] = 0.1022
        pgm_function13[(32, 21, 3)] = 0.0144
        pgm_function13[(32, 22, 0)] = 0.101090027
        pgm_function13[(32, 22, 1)] = 0.02
        pgm_function13[(33, 0, 38)] = 0.0178
        pgm_function13[(33, 0, 39)] = 0.1767
        pgm_function13[(33, 0, 40)] = 0.3511
        pgm_function13[(33, 0, 41)] = 0.34443432
        pgm_function13[(33, 0, 42)] = 0.15441504
        pgm_function13[(33, 0, 43)] = 0.05220521
        pgm_function13[(33, 1, 36)] = 0.01110111
        pgm_function13[(33, 1, 37)] = 0.12
        pgm_function13[(33, 1, 38)] = 0.286729069
        pgm_function13[(33, 1, 39)] = 0.345635076
        pgm_function13[(33, 1, 40)] = 0.228877135
        pgm_function13[(33, 1, 41)] = 0.0889
        pgm_function13[(33, 1, 42)] = 0.0156
        pgm_function13[(33, 2, 34)] = 0.006700677
        pgm_function13[(33, 2, 35)] = 0.0967
        pgm_function13[(33, 2, 36)] = 0.274427176
        pgm_function13[(33, 2, 37)] = 0.347765167
        pgm_function13[(33, 2, 38)] = 0.24997512
        pgm_function13[(33, 2, 39)] = 0.0989
        pgm_function13[(33, 2, 40)] = 0.02000201
        pgm_function13[(33, 3, 32)] = 0.0044
        pgm_function13[(33, 3, 33)] = 0.0789
        pgm_function13[(33, 3, 34)] = 0.2566742
        pgm_function13[(33, 3, 35)] = 0.3478
        pgm_function13[(33, 3, 36)] = 0.26777316
        pgm_function13[(33, 3, 37)] = 0.11111109
        pgm_function13[(33, 3, 38)] = 0.02670273
        pgm_function13[(33, 4, 30)] = 0.002200221
        pgm_function13[(33, 4, 31)] = 0.065593445
        pgm_function13[(33, 4, 32)] = 0.23442326
        pgm_function13[(33, 4, 33)] = 0.35
        pgm_function13[(33, 4, 34)] = 0.2811
        pgm_function13[(33, 4, 35)] = 0.12668708
        pgm_function13[(33, 4, 36)] = 0.0322
        pgm_function13[(33, 5, 29)] = 0.05330532
        pgm_function13[(33, 5, 30)] = 0.21222123
        pgm_function13[(33, 5, 31)] = 0.35113518
        pgm_function13[(33, 5, 32)] = 0.2922
        pgm_function13[(33, 5, 33)] = 0.14561512
        pgm_function13[(33, 5, 34)] = 0.0389
        pgm_function13[(33, 5, 35)] = 0.0011
        pgm_function13[(33, 6, 27)] = 0.0411
        pgm_function13[(33, 6, 28)] = 0.19331914
        pgm_function13[(33, 6, 29)] = 0.3433
        pgm_function13[(33, 6, 30)] = 0.31
        pgm_function13[(33, 6, 31)] = 0.1622161
        pgm_function13[(33, 6, 32)] = 0.0467
        pgm_function13[(33, 6, 33)] = 0.002200222
        pgm_function13[(33, 7, 25)] = 0.0289
        pgm_function13[(33, 7, 26)] = 0.17221719
        pgm_function13[(33, 7, 27)] = 0.32996733
        pgm_function13[(33, 7, 28)] = 0.32223223
        pgm_function13[(33, 7, 29)] = 0.1789
        pgm_function13[(33, 7, 30)] = 0.0544
        pgm_function13[(33, 7, 31)] = 0.004400439
        pgm_function13[(33, 8, 23)] = 0.02219782
        pgm_function13[(33, 8, 24)] = 0.1478
        pgm_function13[(33, 8, 25)] = 0.32223229
        pgm_function13[(33, 8, 26)] = 0.3322
        pgm_function13[(33, 8, 27)] = 0.20111999
        pgm_function13[(33, 8, 28)] = 0.0622062
        pgm_function13[(33, 8, 29)] = 0.0067
        pgm_function13[(33, 9, 21)] = 0.0144014
        pgm_function13[(33, 9, 22)] = 0.1289
        pgm_function13[(33, 9, 23)] = 0.3089
        pgm_function13[(33, 9, 24)] = 0.33783398
        pgm_function13[(33, 9, 25)] = 0.2189
        pgm_function13[(33, 9, 26)] = 0.0722
        pgm_function13[(33, 9, 27)] = 0.01000101
        pgm_function13[(33, 10, 19)] = 0.0089
        pgm_function13[(33, 10, 20)] = 0.11
        pgm_function13[(33, 10, 21)] = 0.290028867
        pgm_function13[(33, 10, 22)] = 0.34893498
        pgm_function13[(33, 10, 23)] = 0.2389
        pgm_function13[(33, 10, 24)] = 0.08440844
        pgm_function13[(33, 10, 25)] = 0.01330131
        pgm_function13[(33, 11, 17)] = 0.004400442
        pgm_function13[(33, 11, 18)] = 0.0933
        pgm_function13[(33, 11, 19)] = 0.26782699
        pgm_function13[(33, 11, 20)] = 0.3633
        pgm_function13[(33, 11, 21)] = 0.247775124
        pgm_function13[(33, 11, 22)] = 0.0989
        pgm_function13[(33, 11, 23)] = 0.0178
        pgm_function13[(33, 12, 15)] = 0.0022
        pgm_function13[(33, 12, 16)] = 0.0756
        pgm_function13[(33, 12, 17)] = 0.2533
        pgm_function13[(33, 12, 18)] = 0.36003625
        pgm_function13[(33, 12, 19)] = 0.26442611
        pgm_function13[(33, 12, 20)] = 0.11557708
        pgm_function13[(33, 12, 21)] = 0.0222
        pgm_function13[(33, 13, 13)] = 0.0011
        pgm_function13[(33, 13, 14)] = 0.0589
        pgm_function13[(33, 13, 15)] = 0.23557624
        pgm_function13[(33, 13, 16)] = 0.3556
        pgm_function13[(33, 13, 17)] = 0.2844
        pgm_function13[(33, 13, 18)] = 0.1322
        pgm_function13[(33, 13, 19)] = 0.0278
        pgm_function13[(33, 14, 12)] = 0.0478
        pgm_function13[(33, 14, 13)] = 0.2111
        pgm_function13[(33, 14, 14)] = 0.34996524
        pgm_function13[(33, 14, 15)] = 0.3
        pgm_function13[(33, 14, 16)] = 0.15
        pgm_function13[(33, 14, 17)] = 0.03440689
        pgm_function13[(33, 15, 10)] = 0.0367
        pgm_function13[(33, 15, 11)] = 0.1844
        pgm_function13[(33, 15, 12)] = 0.3467
        pgm_function13[(33, 15, 13)] = 0.3122
        pgm_function13[(33, 15, 14)] = 0.1678
        pgm_function13[(33, 15, 15)] = 0.0433
        pgm_function13[(33, 15, 16)] = 0.00110011
        pgm_function13[(33, 16, 8)] = 0.02559741
        pgm_function13[(33, 16, 9)] = 0.16441612
        pgm_function13[(33, 16, 10)] = 0.3355329
        pgm_function13[(33, 16, 11)] = 0.3278
        pgm_function13[(33, 16, 12)] = 0.1833
        pgm_function13[(33, 16, 13)] = 0.052205213
        pgm_function13[(33, 16, 14)] = 0.002200221
        pgm_function13[(33, 17, 6)] = 0.0156
        pgm_function13[(33, 17, 7)] = 0.1511
        pgm_function13[(33, 17, 8)] = 0.31666812
        pgm_function13[(33, 17, 9)] = 0.3467
        pgm_function13[(33, 17, 10)] = 0.20112007
        pgm_function13[(33, 17, 11)] = 0.0622062
        pgm_function13[(33, 17, 12)] = 0.00440044
        pgm_function13[(33, 18, 4)] = 0.01110111
        pgm_function13[(33, 18, 5)] = 0.125587034
        pgm_function13[(33, 18, 6)] = 0.303330049
        pgm_function13[(33, 18, 7)] = 0.3533
        pgm_function13[(33, 18, 8)] = 0.22112202
        pgm_function13[(33, 18, 9)] = 0.072207225
        pgm_function13[(33, 18, 10)] = 0.0067
        pgm_function13[(33, 19, 2)] = 0.006699332
        pgm_function13[(33, 19, 3)] = 0.1044
        pgm_function13[(33, 19, 4)] = 0.2922
        pgm_function13[(33, 19, 5)] = 0.3556
        pgm_function13[(33, 19, 6)] = 0.238923943
        pgm_function13[(33, 19, 7)] = 0.0866913
        pgm_function13[(33, 19, 8)] = 0.009999003
        pgm_function13[(33, 20, 0)] = 0.0044
        pgm_function13[(33, 20, 1)] = 0.086691355
        pgm_function13[(33, 20, 2)] = 0.2733
        pgm_function13[(33, 20, 3)] = 0.3567
        pgm_function13[(33, 20, 4)] = 0.255574146
        pgm_function13[(33, 20, 5)] = 0.1000101
        pgm_function13[(33, 20, 6)] = 0.0144
        pgm_function13[(33, 21, 0)] = 0.27667214
        pgm_function13[(33, 21, 1)] = 0.3622
        pgm_function13[(33, 21, 2)] = 0.2744
        pgm_function13[(33, 21, 3)] = 0.1156
        pgm_function13[(33, 21, 4)] = 0.02000202
        pgm_function13[(33, 22, 0)] = 0.267773072
        pgm_function13[(33, 22, 1)] = 0.13
        pgm_function13[(33, 22, 2)] = 0.02559741
        pgm_function13[(33, 23, 0)] = 0.0256
        pgm_function13[(34, 0, 39)] = 0.0133
        pgm_function13[(34, 0, 40)] = 0.1544
        pgm_function13[(34, 0, 41)] = 0.337834314
        pgm_function13[(34, 0, 42)] = 0.351135091
        pgm_function13[(34, 0, 43)] = 0.17221703
        pgm_function13[(34, 0, 44)] = 0.0622
        pgm_function13[(34, 1, 37)] = 0.0067
        pgm_function13[(34, 1, 38)] = 0.104410025
        pgm_function13[(34, 1, 39)] = 0.27442706
        pgm_function13[(34, 1, 40)] = 0.346665205
        pgm_function13[(34, 1, 41)] = 0.2444
        pgm_function13[(34, 1, 42)] = 0.0989
        pgm_function13[(34, 1, 43)] = 0.02
        pgm_function13[(34, 2, 35)] = 0.0044
        pgm_function13[(34, 2, 36)] = 0.086708755
        pgm_function13[(34, 2, 37)] = 0.252175121
        pgm_function13[(34, 2, 38)] = 0.34886517
        pgm_function13[(34, 2, 39)] = 0.2633
        pgm_function13[(34, 2, 40)] = 0.11001107
        pgm_function13[(34, 2, 41)] = 0.0267
        pgm_function13[(34, 3, 33)] = 0.0022
        pgm_function13[(34, 3, 34)] = 0.068893154
        pgm_function13[(34, 3, 35)] = 0.2389
        pgm_function13[(34, 3, 36)] = 0.34556521
        pgm_function13[(34, 3, 37)] = 0.28332823
        pgm_function13[(34, 3, 38)] = 0.12331212
        pgm_function13[(34, 3, 39)] = 0.03219683
        pgm_function13[(34, 4, 31)] = 0.001099891
        pgm_function13[(34, 4, 32)] = 0.05560566
        pgm_function13[(34, 4, 33)] = 0.22
        pgm_function13[(34, 4, 34)] = 0.3433
        pgm_function13[(34, 4, 35)] = 0.29437118
        pgm_function13[(34, 4, 36)] = 0.1411
        pgm_function13[(34, 4, 37)] = 0.03889613
        pgm_function13[(34, 4, 38)] = 0.0011
        pgm_function13[(34, 5, 30)] = 0.04330435
        pgm_function13[(34, 5, 31)] = 0.1933191
        pgm_function13[(34, 5, 32)] = 0.3444
        pgm_function13[(34, 5, 33)] = 0.30443024
        pgm_function13[(34, 5, 34)] = 0.16
        pgm_function13[(34, 5, 35)] = 0.0456
        pgm_function13[(34, 5, 36)] = 0.0022
        pgm_function13[(34, 6, 28)] = 0.03220322
        pgm_function13[(34, 6, 29)] = 0.1733
        pgm_function13[(34, 6, 30)] = 0.3344
        pgm_function13[(34, 6, 31)] = 0.31443119
        pgm_function13[(34, 6, 32)] = 0.1778
        pgm_function13[(34, 6, 33)] = 0.053305343
        pgm_function13[(34, 6, 34)] = 0.004400441
        pgm_function13[(34, 7, 26)] = 0.02220222
        pgm_function13[(34, 7, 27)] = 0.15558416
        pgm_function13[(34, 7, 28)] = 0.32223223
        pgm_function13[(34, 7, 29)] = 0.3311
        pgm_function13[(34, 7, 30)] = 0.1944
        pgm_function13[(34, 7, 31)] = 0.062206183
        pgm_function13[(34, 7, 32)] = 0.006700677
        pgm_function13[(34, 8, 24)] = 0.0156
        pgm_function13[(34, 8, 25)] = 0.13441312
        pgm_function13[(34, 8, 26)] = 0.31
        pgm_function13[(34, 8, 27)] = 0.34003398
        pgm_function13[(34, 8, 28)] = 0.21332099
        pgm_function13[(34, 8, 29)] = 0.0722
        pgm_function13[(34, 8, 30)] = 0.01
        pgm_function13[(34, 9, 22)] = 0.01
        pgm_function13[(34, 9, 23)] = 0.1144
        pgm_function13[(34, 9, 24)] = 0.29442898
        pgm_function13[(34, 9, 25)] = 0.3456
        pgm_function13[(34, 9, 26)] = 0.2344
        pgm_function13[(34, 9, 27)] = 0.08330839
        pgm_function13[(34, 9, 28)] = 0.01330131
        pgm_function13[(34, 10, 20)] = 0.0067
        pgm_function13[(34, 10, 21)] = 0.094409357
        pgm_function13[(34, 10, 22)] = 0.27672798
        pgm_function13[(34, 10, 23)] = 0.3511
        pgm_function13[(34, 10, 24)] = 0.25002513
        pgm_function13[(34, 10, 25)] = 0.09670979
        pgm_function13[(34, 10, 26)] = 0.01779822
        pgm_function13[(34, 11, 18)] = 0.0022
        pgm_function13[(34, 11, 19)] = 0.0811081
        pgm_function13[(34, 11, 20)] = 0.25
        pgm_function13[(34, 11, 21)] = 0.361064181
        pgm_function13[(34, 11, 22)] = 0.2622
        pgm_function13[(34, 11, 23)] = 0.1122
        pgm_function13[(34, 11, 24)] = 0.0222
        pgm_function13[(34, 12, 16)] = 0.0011
        pgm_function13[(34, 12, 17)] = 0.0644
        pgm_function13[(34, 12, 18)] = 0.23442316
        pgm_function13[(34, 12, 19)] = 0.36113614
        pgm_function13[(34, 12, 20)] = 0.27774419
        pgm_function13[(34, 12, 21)] = 0.13
        pgm_function13[(34, 12, 22)] = 0.02779723
        pgm_function13[(34, 13, 15)] = 0.04889515
        pgm_function13[(34, 13, 16)] = 0.2178
        pgm_function13[(34, 13, 17)] = 0.3489
        pgm_function13[(34, 13, 18)] = 0.2956
        pgm_function13[(34, 13, 19)] = 0.1489
        pgm_function13[(34, 13, 20)] = 0.03330331
        pgm_function13[(34, 14, 13)] = 0.0378
        pgm_function13[(34, 14, 14)] = 0.19558014
        pgm_function13[(34, 14, 15)] = 0.3411
        pgm_function13[(34, 14, 16)] = 0.3133
        pgm_function13[(34, 14, 17)] = 0.16333295
        pgm_function13[(34, 14, 18)] = 0.0433
        pgm_function13[(34, 14, 19)] = 0.0011
        pgm_function13[(34, 15, 11)] = 0.0289
        pgm_function13[(34, 15, 12)] = 0.1689
        pgm_function13[(34, 15, 13)] = 0.3378
        pgm_function13[(34, 15, 14)] = 0.3233
        pgm_function13[(34, 15, 15)] = 0.1789
        pgm_function13[(34, 15, 16)] = 0.052205213
        pgm_function13[(34, 15, 17)] = 0.00220022
        pgm_function13[(34, 16, 9)] = 0.02110211
        pgm_function13[(34, 16, 10)] = 0.14667096
        pgm_function13[(34, 16, 11)] = 0.3244
        pgm_function13[(34, 16, 12)] = 0.3378
        pgm_function13[(34, 16, 13)] = 0.20002005
        pgm_function13[(34, 16, 14)] = 0.062206229
        pgm_function13[(34, 16, 15)] = 0.0044
        pgm_function13[(34, 17, 7)] = 0.0111
        pgm_function13[(34, 17, 8)] = 0.13218705
        pgm_function13[(34, 17, 9)] = 0.3033
        pgm_function13[(34, 17, 10)] = 0.352235123
        pgm_function13[(34, 17, 11)] = 0.21672199
        pgm_function13[(34, 17, 12)] = 0.0722072
        pgm_function13[(34, 17, 13)] = 0.0067
        pgm_function13[(34, 18, 5)] = 0.006699332
        pgm_function13[(34, 18, 6)] = 0.112211018
        pgm_function13[(34, 18, 7)] = 0.2867
        pgm_function13[(34, 18, 8)] = 0.35783603
        pgm_function13[(34, 18, 9)] = 0.234423082
        pgm_function13[(34, 18, 10)] = 0.0844
        pgm_function13[(34, 18, 11)] = 0.009999004
        pgm_function13[(34, 19, 3)] = 0.0044
        pgm_function13[(34, 19, 4)] = 0.09
        pgm_function13[(34, 19, 5)] = 0.2756
        pgm_function13[(34, 19, 6)] = 0.358935914
        pgm_function13[(34, 19, 7)] = 0.25437499
        pgm_function13[(34, 19, 8)] = 0.096690329
        pgm_function13[(34, 19, 9)] = 0.0144
        pgm_function13[(34, 20, 1)] = 0.002199781
        pgm_function13[(34, 20, 2)] = 0.0711
        pgm_function13[(34, 20, 3)] = 0.2622
        pgm_function13[(34, 20, 4)] = 0.356664203
        pgm_function13[(34, 20, 5)] = 0.27332727
        pgm_function13[(34, 20, 6)] = 0.1111
        pgm_function13[(34, 20, 7)] = 0.0189
        pgm_function13[(34, 21, 0)] = 0.06669333
        pgm_function13[(34, 21, 1)] = 0.2333
        pgm_function13[(34, 21, 2)] = 0.3578
        pgm_function13[(34, 21, 3)] = 0.29
        pgm_function13[(34, 21, 4)] = 0.1278131
        pgm_function13[(34, 21, 5)] = 0.0256
        pgm_function13[(34, 22, 0)] = 0.366663099
        pgm_function13[(34, 22, 1)] = 0.3056
        pgm_function13[(34, 22, 2)] = 0.14438603
        pgm_function13[(34, 22, 3)] = 0.0322
        pgm_function13[(34, 23, 0)] = 0.1367
        pgm_function13[(34, 23, 1)] = 0.041095932
        pgm_function13[(35, 0, 40)] = 0.01
        pgm_function13[(35, 0, 41)] = 0.132213123
        pgm_function13[(35, 0, 42)] = 0.336734088
        pgm_function13[(35, 0, 43)] = 0.35673606
        pgm_function13[(35, 0, 44)] = 0.19
        pgm_function13[(35, 0, 45)] = 0.07220724
        pgm_function13[(35, 1, 38)] = 0.004400441
        pgm_function13[(35, 1, 39)] = 0.08890892
        pgm_function13[(35, 1, 40)] = 0.258874153
        pgm_function13[(35, 1, 41)] = 0.3444
        pgm_function13[(35, 1, 42)] = 0.2578
        pgm_function13[(35, 1, 43)] = 0.11
        pgm_function13[(35, 1, 44)] = 0.0256
        pgm_function13[(35, 2, 36)] = 0.002200221
        pgm_function13[(35, 2, 37)] = 0.076692337
        pgm_function13[(35, 2, 38)] = 0.23667612
        pgm_function13[(35, 2, 39)] = 0.3478
        pgm_function13[(35, 2, 40)] = 0.27442716
        pgm_function13[(35, 2, 41)] = 0.1233
        pgm_function13[(35, 2, 42)] = 0.03219683
        pgm_function13[(35, 3, 34)] = 0.001099891
        pgm_function13[(35, 3, 35)] = 0.06
        pgm_function13[(35, 3, 36)] = 0.22107813
        pgm_function13[(35, 3, 37)] = 0.34333427
        pgm_function13[(35, 3, 38)] = 0.29112929
        pgm_function13[(35, 3, 39)] = 0.13888612
        pgm_function13[(35, 3, 40)] = 0.0389
        pgm_function13[(35, 4, 33)] = 0.0444
        pgm_function13[(35, 4, 34)] = 0.2033
        pgm_function13[(35, 4, 35)] = 0.3377662
        pgm_function13[(35, 4, 36)] = 0.3056
        pgm_function13[(35, 4, 37)] = 0.15558411
        pgm_function13[(35, 4, 38)] = 0.0456
        pgm_function13[(35, 4, 39)] = 0.002199783
        pgm_function13[(35, 5, 31)] = 0.03440342
        pgm_function13[(35, 5, 32)] = 0.18
        pgm_function13[(35, 5, 33)] = 0.33443327
        pgm_function13[(35, 5, 34)] = 0.3133
        pgm_function13[(35, 5, 35)] = 0.1756
        pgm_function13[(35, 5, 36)] = 0.0522
        pgm_function13[(35, 5, 37)] = 0.004400444
        pgm_function13[(35, 6, 29)] = 0.0256
        pgm_function13[(35, 6, 30)] = 0.1556
        pgm_function13[(35, 6, 31)] = 0.3289332
        pgm_function13[(35, 6, 32)] = 0.3222
        pgm_function13[(35, 6, 33)] = 0.194419157
        pgm_function13[(35, 6, 34)] = 0.060006013
        pgm_function13[(35, 6, 35)] = 0.0067
        pgm_function13[(35, 7, 27)] = 0.01669832
        pgm_function13[(35, 7, 28)] = 0.1378141
        pgm_function13[(35, 7, 29)] = 0.3122
        pgm_function13[(35, 7, 30)] = 0.3378
        pgm_function13[(35, 7, 31)] = 0.210020941
        pgm_function13[(35, 7, 32)] = 0.071107179
        pgm_function13[(35, 7, 33)] = 0.01
        pgm_function13[(35, 8, 25)] = 0.01110111
        pgm_function13[(35, 8, 26)] = 0.12
        pgm_function13[(35, 8, 27)] = 0.29112898
        pgm_function13[(35, 8, 28)] = 0.34673498
        pgm_function13[(35, 8, 29)] = 0.2267
        pgm_function13[(35, 8, 30)] = 0.0822
        pgm_function13[(35, 8, 31)] = 0.01330131
        pgm_function13[(35, 9, 23)] = 0.0067
        pgm_function13[(35, 9, 24)] = 0.10000999
        pgm_function13[(35, 9, 25)] = 0.2789
        pgm_function13[(35, 9, 26)] = 0.35
        pgm_function13[(35, 9, 27)] = 0.24442427
        pgm_function13[(35, 9, 28)] = 0.09670976
        pgm_function13[(35, 9, 29)] = 0.0178
        pgm_function13[(35, 10, 21)] = 0.004400438
        pgm_function13[(35, 10, 22)] = 0.0822082
        pgm_function13[(35, 10, 23)] = 0.2589
        pgm_function13[(35, 10, 24)] = 0.35223518
        pgm_function13[(35, 10, 25)] = 0.26332624
        pgm_function13[(35, 10, 26)] = 0.1088891
        pgm_function13[(35, 10, 27)] = 0.02220221
        pgm_function13[(35, 11, 19)] = 0.00110011
        pgm_function13[(35, 11, 20)] = 0.0678
        pgm_function13[(35, 11, 21)] = 0.236676118
        pgm_function13[(35, 11, 22)] = 0.3589
        pgm_function13[(35, 11, 23)] = 0.2778
        pgm_function13[(35, 11, 24)] = 0.1278
        pgm_function13[(35, 11, 25)] = 0.02780283
        pgm_function13[(35, 12, 18)] = 0.05330534
        pgm_function13[(35, 12, 19)] = 0.21672209
        pgm_function13[(35, 12, 20)] = 0.35552925
        pgm_function13[(35, 12, 21)] = 0.2889
        pgm_function13[(35, 12, 22)] = 0.14668513
        pgm_function13[(35, 12, 23)] = 0.0333
        pgm_function13[(35, 13, 16)] = 0.04
        pgm_function13[(35, 13, 17)] = 0.1978
        pgm_function13[(35, 13, 18)] = 0.3444
        pgm_function13[(35, 13, 19)] = 0.3044
        pgm_function13[(35, 13, 20)] = 0.16221605
        pgm_function13[(35, 13, 21)] = 0.042195851
        pgm_function13[(35, 13, 22)] = 0.0011
        pgm_function13[(35, 14, 14)] = 0.02889712
        pgm_function13[(35, 14, 15)] = 0.1789
        pgm_function13[(35, 14, 16)] = 0.3322
        pgm_function13[(35, 14, 17)] = 0.3222639
        pgm_function13[(35, 14, 18)] = 0.1756
        pgm_function13[(35, 14, 19)] = 0.0511
        pgm_function13[(35, 14, 20)] = 0.00220022
        pgm_function13[(35, 15, 12)] = 0.0222
        pgm_function13[(35, 15, 13)] = 0.1533
        pgm_function13[(35, 15, 14)] = 0.3256
        pgm_function13[(35, 15, 15)] = 0.3378
        pgm_function13[(35, 15, 16)] = 0.192219048
        pgm_function13[(35, 15, 17)] = 0.06110611
        pgm_function13[(35, 15, 18)] = 0.004400441
        pgm_function13[(35, 16, 10)] = 0.0155969
        pgm_function13[(35, 16, 11)] = 0.1311
        pgm_function13[(35, 16, 12)] = 0.3133
        pgm_function13[(35, 16, 13)] = 0.341134085
        pgm_function13[(35, 16, 14)] = 0.213321098
        pgm_function13[(35, 16, 15)] = 0.0722
        pgm_function13[(35, 16, 16)] = 0.0067
        pgm_function13[(35, 17, 8)] = 0.007799223
        pgm_function13[(35, 17, 9)] = 0.1144
        pgm_function13[(35, 17, 10)] = 0.290029102
        pgm_function13[(35, 17, 11)] = 0.35223499
        pgm_function13[(35, 17, 12)] = 0.23222301
        pgm_function13[(35, 17, 13)] = 0.0833
        pgm_function13[(35, 17, 14)] = 0.01
        pgm_function13[(35, 18, 6)] = 0.004400441
        pgm_function13[(35, 18, 7)] = 0.0978
        pgm_function13[(35, 18, 8)] = 0.27112702
        pgm_function13[(35, 18, 9)] = 0.362236127
        pgm_function13[(35, 18, 10)] = 0.25
        pgm_function13[(35, 18, 11)] = 0.095590438
        pgm_function13[(35, 18, 12)] = 0.0144
        pgm_function13[(35, 19, 4)] = 0.0022
        pgm_function13[(35, 19, 5)] = 0.0778
        pgm_function13[(35, 19, 6)] = 0.258925938
        pgm_function13[(35, 19, 7)] = 0.35886399
        pgm_function13[(35, 19, 8)] = 0.268873081
        pgm_function13[(35, 19, 9)] = 0.11
        pgm_function13[(35, 19, 10)] = 0.0189
        pgm_function13[(35, 20, 2)] = 0.0011
        pgm_function13[(35, 20, 3)] = 0.0589
        pgm_function13[(35, 20, 4)] = 0.242176138
        pgm_function13[(35, 20, 5)] = 0.35333535
        pgm_function13[(35, 20, 6)] = 0.2889
        pgm_function13[(35, 20, 7)] = 0.1244
        pgm_function13[(35, 20, 8)] = 0.0256
        pgm_function13[(35, 21, 1)] = 0.0478
        pgm_function13[(35, 21, 2)] = 0.2178
        pgm_function13[(35, 21, 3)] = 0.3511
        pgm_function13[(35, 21, 4)] = 0.30223024
        pgm_function13[(35, 21, 5)] = 0.1422
        pgm_function13[(35, 21, 6)] = 0.03109694
        pgm_function13[(35, 22, 0)] = 0.22217806
        pgm_function13[(35, 22, 1)] = 0.3489
        pgm_function13[(35, 22, 2)] = 0.31556806
        pgm_function13[(35, 22, 3)] = 0.16
        pgm_function13[(35, 22, 4)] = 0.0411
        pgm_function13[(35, 23, 0)] = 0.3244
        pgm_function13[(35, 23, 1)] = 0.177782137
        pgm_function13[(35, 23, 2)] = 0.050005028
        pgm_function13[(35, 23, 3)] = 0.0011
        pgm_function13[(35, 24, 0)] = 0.040004031
        pgm_function13[(35, 24, 1)] = 0.004400443
        pgm_function13[(36, 0, 41)] = 0.006700676
        pgm_function13[(36, 0, 42)] = 0.110011029
        pgm_function13[(36, 0, 43)] = 0.32223206
        pgm_function13[(36, 0, 44)] = 0.3689
        pgm_function13[(36, 0, 45)] = 0.21332111
        pgm_function13[(36, 0, 46)] = 0.08330836
        pgm_function13[(36, 1, 39)] = 0.004400441
        pgm_function13[(36, 1, 40)] = 0.076692345
        pgm_function13[(36, 1, 41)] = 0.2456
        pgm_function13[(36, 1, 42)] = 0.3422
        pgm_function13[(36, 1, 43)] = 0.27
        pgm_function13[(36, 1, 44)] = 0.1233
        pgm_function13[(36, 1, 45)] = 0.03220323
        pgm_function13[(36, 2, 37)] = 0.001099891
        pgm_function13[(36, 2, 38)] = 0.06559343
        pgm_function13[(36, 2, 39)] = 0.22
        pgm_function13[(36, 2, 40)] = 0.34783521
        pgm_function13[(36, 2, 41)] = 0.2856
        pgm_function13[(36, 2, 42)] = 0.13668612
        pgm_function13[(36, 2, 43)] = 0.03889614
        pgm_function13[(36, 3, 36)] = 0.04999503
        pgm_function13[(36, 3, 37)] = 0.20002016
        pgm_function13[(36, 3, 38)] = 0.34223434
        pgm_function13[(36, 3, 39)] = 0.29997027
        pgm_function13[(36, 3, 40)] = 0.1522
        pgm_function13[(36, 3, 41)] = 0.0467
        pgm_function13[(36, 3, 42)] = 0.002200221
        pgm_function13[(36, 4, 34)] = 0.0356
        pgm_function13[(36, 4, 35)] = 0.18558111
        pgm_function13[(36, 4, 36)] = 0.3311
        pgm_function13[(36, 4, 37)] = 0.31326922
        pgm_function13[(36, 4, 38)] = 0.1711
        pgm_function13[(36, 4, 39)] = 0.052194874
        pgm_function13[(36, 4, 40)] = 0.004400444
        pgm_function13[(36, 5, 32)] = 0.0267
        pgm_function13[(36, 5, 33)] = 0.16331613
        pgm_function13[(36, 5, 34)] = 0.3256
        pgm_function13[(36, 5, 35)] = 0.3222
        pgm_function13[(36, 5, 36)] = 0.1889
        pgm_function13[(36, 5, 37)] = 0.06000606
        pgm_function13[(36, 5, 38)] = 0.0067
        pgm_function13[(36, 6, 30)] = 0.02
        pgm_function13[(36, 6, 31)] = 0.14001408
        pgm_function13[(36, 6, 32)] = 0.3178
        pgm_function13[(36, 6, 33)] = 0.330033267
        pgm_function13[(36, 6, 34)] = 0.208921046
        pgm_function13[(36, 6, 35)] = 0.07
        pgm_function13[(36, 6, 36)] = 0.009999007
        pgm_function13[(36, 7, 28)] = 0.01330131
        pgm_function13[(36, 7, 29)] = 0.12
        pgm_function13[(36, 7, 30)] = 0.2989
        pgm_function13[(36, 7, 31)] = 0.341133904
        pgm_function13[(36, 7, 32)] = 0.224422249
        pgm_function13[(36, 7, 33)] = 0.0811
        pgm_function13[(36, 7, 34)] = 0.01330131
        pgm_function13[(36, 8, 26)] = 0.0067
        pgm_function13[(36, 8, 27)] = 0.10671099
        pgm_function13[(36, 8, 28)] = 0.27892798
        pgm_function13[(36, 8, 29)] = 0.3511
        pgm_function13[(36, 8, 30)] = 0.2378
        pgm_function13[(36, 8, 31)] = 0.09670976
        pgm_function13[(36, 8, 32)] = 0.01779821
        pgm_function13[(36, 9, 24)] = 0.00440044
        pgm_function13[(36, 9, 25)] = 0.0878
        pgm_function13[(36, 9, 26)] = 0.2589
        pgm_function13[(36, 9, 27)] = 0.35333539
        pgm_function13[(36, 9, 28)] = 0.25442515
        pgm_function13[(36, 9, 29)] = 0.1089
        pgm_function13[(36, 9, 30)] = 0.0222
        pgm_function13[(36, 10, 22)] = 0.00220022
        pgm_function13[(36, 10, 23)] = 0.0711
        pgm_function13[(36, 10, 24)] = 0.24222412
        pgm_function13[(36, 10, 25)] = 0.35223532
        pgm_function13[(36, 10, 26)] = 0.27557225
        pgm_function13[(36, 10, 27)] = 0.12441206
        pgm_function13[(36, 10, 28)] = 0.0278
        pgm_function13[(36, 11, 20)] = 0.0011
        pgm_function13[(36, 11, 21)] = 0.056694328
        pgm_function13[(36, 11, 22)] = 0.22
        pgm_function13[(36, 11, 23)] = 0.35
        pgm_function13[(36, 11, 24)] = 0.29
        pgm_function13[(36, 11, 25)] = 0.14221413
        pgm_function13[(36, 11, 26)] = 0.03330333
        pgm_function13[(36, 12, 19)] = 0.04330432
        pgm_function13[(36, 12, 20)] = 0.19776014
        pgm_function13[(36, 12, 21)] = 0.3489
        pgm_function13[(36, 12, 22)] = 0.29997027
        pgm_function13[(36, 12, 23)] = 0.1589
        pgm_function13[(36, 12, 24)] = 0.04110413
        pgm_function13[(36, 12, 25)] = 0.0011
        pgm_function13[(36, 13, 17)] = 0.0322
        pgm_function13[(36, 13, 18)] = 0.18
        pgm_function13[(36, 13, 19)] = 0.3389
        pgm_function13[(36, 13, 20)] = 0.3167321
        pgm_function13[(36, 13, 21)] = 0.175582211
        pgm_function13[(36, 13, 22)] = 0.05
        pgm_function13[(36, 13, 23)] = 0.002200221
        pgm_function13[(36, 14, 15)] = 0.0222
        pgm_function13[(36, 14, 16)] = 0.16
        pgm_function13[(36, 14, 17)] = 0.3244649
        pgm_function13[(36, 14, 18)] = 0.3356
        pgm_function13[(36, 14, 19)] = 0.1889
        pgm_function13[(36, 14, 20)] = 0.060006
        pgm_function13[(36, 14, 21)] = 0.004400441
        pgm_function13[(36, 15, 13)] = 0.0156
        pgm_function13[(36, 15, 14)] = 0.1378
        pgm_function13[(36, 15, 15)] = 0.31
        pgm_function13[(36, 15, 16)] = 0.345635086
        pgm_function13[(36, 15, 17)] = 0.20562103
        pgm_function13[(36, 15, 18)] = 0.072207217
        pgm_function13[(36, 15, 19)] = 0.0067
        pgm_function13[(36, 16, 11)] = 0.0111
        pgm_function13[(36, 16, 12)] = 0.1156
        pgm_function13[(36, 16, 13)] = 0.297830074
        pgm_function13[(36, 16, 14)] = 0.346735159
        pgm_function13[(36, 16, 15)] = 0.2267
        pgm_function13[(36, 16, 16)] = 0.0822
        pgm_function13[(36, 16, 17)] = 0.010001
        pgm_function13[(36, 17, 9)] = 0.0067
        pgm_function13[(36, 17, 10)] = 0.098909935
        pgm_function13[(36, 17, 11)] = 0.28002799
        pgm_function13[(36, 17, 12)] = 0.35223502
        pgm_function13[(36, 17, 13)] = 0.2478
        pgm_function13[(36, 17, 14)] = 0.0944
        pgm_function13[(36, 17, 15)] = 0.01439862
        pgm_function13[(36, 18, 7)] = 0.0022
        pgm_function13[(36, 18, 8)] = 0.08440841
        pgm_function13[(36, 18, 9)] = 0.25672609
        pgm_function13[(36, 18, 10)] = 0.36
        pgm_function13[(36, 18, 11)] = 0.266673107
        pgm_function13[(36, 18, 12)] = 0.1078
        pgm_function13[(36, 18, 13)] = 0.0189
        pgm_function13[(36, 19, 5)] = 0.0011
        pgm_function13[(36, 19, 6)] = 0.064406385
        pgm_function13[(36, 19, 7)] = 0.23777599
        pgm_function13[(36, 19, 8)] = 0.359964108
        pgm_function13[(36, 19, 9)] = 0.2822
        pgm_function13[(36, 19, 10)] = 0.1222
        pgm_function13[(36, 19, 11)] = 0.02559742
        pgm_function13[(36, 20, 4)] = 0.048895128
        pgm_function13[(36, 20, 5)] = 0.22332222
        pgm_function13[(36, 20, 6)] = 0.3489
        pgm_function13[(36, 20, 7)] = 0.3011
        pgm_function13[(36, 20, 8)] = 0.1389
        pgm_function13[(36, 20, 9)] = 0.0311
        pgm_function13[(36, 21, 2)] = 0.0378
        pgm_function13[(36, 21, 3)] = 0.2
        pgm_function13[(36, 21, 4)] = 0.34443428
        pgm_function13[(36, 21, 5)] = 0.3144
        pgm_function13[(36, 21, 6)] = 0.1566842
        pgm_function13[(36, 21, 7)] = 0.04
        pgm_function13[(36, 22, 0)] = 0.03559641
        pgm_function13[(36, 22, 1)] = 0.1733
        pgm_function13[(36, 22, 2)] = 0.34216607
        pgm_function13[(36, 22, 3)] = 0.3256
        pgm_function13[(36, 22, 4)] = 0.1733
        pgm_function13[(36, 22, 5)] = 0.050005028
        pgm_function13[(36, 22, 6)] = 0.0011
        pgm_function13[(36, 23, 0)] = 0.3422
        pgm_function13[(36, 23, 1)] = 0.336666259
        pgm_function13[(36, 23, 2)] = 0.193319108
        pgm_function13[(36, 23, 3)] = 0.0578
        pgm_function13[(36, 23, 4)] = 0.0044
        pgm_function13[(36, 24, 0)] = 0.202220158
        pgm_function13[(36, 24, 1)] = 0.065606649
        pgm_function13[(36, 24, 2)] = 0.006699332
        pgm_function13[(37, 0, 42)] = 0.004400441
        pgm_function13[(37, 0, 43)] = 0.09440942
        pgm_function13[(37, 0, 44)] = 0.2911
        pgm_function13[(37, 0, 45)] = 0.36333618
        pgm_function13[(37, 0, 46)] = 0.23222316
        pgm_function13[(37, 0, 47)] = 0.0944
        pgm_function13[(37, 0, 48)] = 0.0056
        pgm_function13[(37, 1, 40)] = 0.002199781
        pgm_function13[(37, 1, 41)] = 0.0656
        pgm_function13[(37, 1, 42)] = 0.2311
        pgm_function13[(37, 1, 43)] = 0.34
        pgm_function13[(37, 1, 44)] = 0.2833
        pgm_function13[(37, 1, 45)] = 0.13331312
        pgm_function13[(37, 1, 46)] = 0.0389
        pgm_function13[(37, 2, 39)] = 0.0544
        pgm_function13[(37, 2, 40)] = 0.20332012
        pgm_function13[(37, 2, 41)] = 0.3389
        pgm_function13[(37, 2, 42)] = 0.29557027
        pgm_function13[(37, 2, 43)] = 0.14998513
        pgm_function13[(37, 2, 44)] = 0.0467
        pgm_function13[(37, 2, 45)] = 0.002200221
        pgm_function13[(37, 3, 37)] = 0.04220423
        pgm_function13[(37, 3, 38)] = 0.18331818
        pgm_function13[(37, 3, 39)] = 0.3366663
        pgm_function13[(37, 3, 40)] = 0.3078
        pgm_function13[(37, 3, 41)] = 0.1689
        pgm_function13[(37, 3, 42)] = 0.05220523
        pgm_function13[(37, 3, 43)] = 0.0044
        pgm_function13[(37, 4, 35)] = 0.02889712
        pgm_function13[(37, 4, 36)] = 0.1678
        pgm_function13[(37, 4, 37)] = 0.32556723
        pgm_function13[(37, 4, 38)] = 0.3189
        pgm_function13[(37, 4, 39)] = 0.185581264
        pgm_function13[(37, 4, 40)] = 0.060006053
        pgm_function13[(37, 4, 41)] = 0.006700676
        pgm_function13[(37, 5, 33)] = 0.02000202
        pgm_function13[(37, 5, 34)] = 0.1478
        pgm_function13[(37, 5, 35)] = 0.3122
        pgm_function13[(37, 5, 36)] = 0.3322
        pgm_function13[(37, 5, 37)] = 0.204420204
        pgm_function13[(37, 5, 38)] = 0.0689
        pgm_function13[(37, 5, 39)] = 0.009999008
        pgm_function13[(37, 6, 31)] = 0.01440141
        pgm_function13[(37, 6, 32)] = 0.1244
        pgm_function13[(37, 6, 33)] = 0.301130244
        pgm_function13[(37, 6, 34)] = 0.338934075
        pgm_function13[(37, 6, 35)] = 0.2211
        pgm_function13[(37, 6, 36)] = 0.078892156
        pgm_function13[(37, 6, 37)] = 0.0133
        pgm_function13[(37, 7, 29)] = 0.01
        pgm_function13[(37, 7, 30)] = 0.1056
        pgm_function13[(37, 7, 31)] = 0.28562892
        pgm_function13[(37, 7, 32)] = 0.343334381
        pgm_function13[(37, 7, 33)] = 0.2367
        pgm_function13[(37, 7, 34)] = 0.09220924
        pgm_function13[(37, 7, 35)] = 0.0178
        pgm_function13[(37, 8, 27)] = 0.00440044
        pgm_function13[(37, 8, 28)] = 0.09110909
        pgm_function13[(37, 8, 29)] = 0.2644
        pgm_function13[(37, 8, 30)] = 0.3544
        pgm_function13[(37, 8, 31)] = 0.24892515
        pgm_function13[(37, 8, 32)] = 0.10778904
        pgm_function13[(37, 8, 33)] = 0.0222
        pgm_function13[(37, 9, 25)] = 0.0022
        pgm_function13[(37, 9, 26)] = 0.0767
        pgm_function13[(37, 9, 27)] = 0.24332427
        pgm_function13[(37, 9, 28)] = 0.35673621
        pgm_function13[(37, 9, 29)] = 0.2667
        pgm_function13[(37, 9, 30)] = 0.1244
        pgm_function13[(37, 9, 31)] = 0.02779721
        pgm_function13[(37, 10, 23)] = 0.0011
        pgm_function13[(37, 10, 24)] = 0.06110613
        pgm_function13[(37, 10, 25)] = 0.2233222
        pgm_function13[(37, 10, 26)] = 0.34886531
        pgm_function13[(37, 10, 27)] = 0.28672914
        pgm_function13[(37, 10, 28)] = 0.14
        pgm_function13[(37, 10, 29)] = 0.03330332
        pgm_function13[(37, 11, 22)] = 0.0467
        pgm_function13[(37, 11, 23)] = 0.2044
        pgm_function13[(37, 11, 24)] = 0.3411
        pgm_function13[(37, 11, 25)] = 0.30223027
        pgm_function13[(37, 11, 26)] = 0.15441514
        pgm_function13[(37, 11, 27)] = 0.0411
        pgm_function13[(37, 11, 28)] = 0.0011
        pgm_function13[(37, 12, 20)] = 0.03559292
        pgm_function13[(37, 12, 21)] = 0.1833
        pgm_function13[(37, 12, 22)] = 0.3377663
        pgm_function13[(37, 12, 23)] = 0.3133
        pgm_function13[(37, 12, 24)] = 0.17221714
        pgm_function13[(37, 12, 25)] = 0.05
        pgm_function13[(37, 12, 26)] = 0.0022
        pgm_function13[(37, 13, 18)] = 0.0256
        pgm_function13[(37, 13, 19)] = 0.16
        pgm_function13[(37, 13, 20)] = 0.3300331
        pgm_function13[(37, 13, 21)] = 0.326667392
        pgm_function13[(37, 13, 22)] = 0.1889
        pgm_function13[(37, 13, 23)] = 0.058905926
        pgm_function13[(37, 13, 24)] = 0.0044
        pgm_function13[(37, 14, 16)] = 0.0167
        pgm_function13[(37, 14, 17)] = 0.14332896
        pgm_function13[(37, 14, 18)] = 0.3111
        pgm_function13[(37, 14, 19)] = 0.3433
        pgm_function13[(37, 14, 20)] = 0.20442001
        pgm_function13[(37, 14, 21)] = 0.07000701
        pgm_function13[(37, 14, 22)] = 0.006699335
        pgm_function13[(37, 15, 14)] = 0.0111
        pgm_function13[(37, 15, 15)] = 0.1233
        pgm_function13[(37, 15, 16)] = 0.294429074
        pgm_function13[(37, 15, 17)] = 0.35223505
        pgm_function13[(37, 15, 18)] = 0.220022053
        pgm_function13[(37, 15, 19)] = 0.0811
        pgm_function13[(37, 15, 20)] = 0.01
        pgm_function13[(37, 16, 12)] = 0.0067
        pgm_function13[(37, 16, 13)] = 0.103310026
        pgm_function13[(37, 16, 14)] = 0.284428131
        pgm_function13[(37, 16, 15)] = 0.3511
        pgm_function13[(37, 16, 16)] = 0.2422
        pgm_function13[(37, 16, 17)] = 0.09440942
        pgm_function13[(37, 16, 18)] = 0.0144
        pgm_function13[(37, 17, 10)] = 0.004400442
        pgm_function13[(37, 17, 11)] = 0.0844084
        pgm_function13[(37, 17, 12)] = 0.26562701
        pgm_function13[(37, 17, 13)] = 0.3511
        pgm_function13[(37, 17, 14)] = 0.2656
        pgm_function13[(37, 17, 15)] = 0.10558916
        pgm_function13[(37, 17, 16)] = 0.01889812
        pgm_function13[(37, 18, 8)] = 0.00110011
        pgm_function13[(37, 18, 9)] = 0.068906924
        pgm_function13[(37, 18, 10)] = 0.24
        pgm_function13[(37, 18, 11)] = 0.354365142
        pgm_function13[(37, 18, 12)] = 0.28
        pgm_function13[(37, 18, 13)] = 0.12
        pgm_function13[(37, 18, 14)] = 0.02559742
        pgm_function13[(37, 19, 7)] = 0.0555944
        pgm_function13[(37, 19, 8)] = 0.218878066
        pgm_function13[(37, 19, 9)] = 0.3556
        pgm_function13[(37, 19, 10)] = 0.2956
        pgm_function13[(37, 19, 11)] = 0.13668611
        pgm_function13[(37, 19, 12)] = 0.0311
        pgm_function13[(37, 20, 5)] = 0.04000404
        pgm_function13[(37, 20, 6)] = 0.2056
        pgm_function13[(37, 20, 7)] = 0.3467
        pgm_function13[(37, 20, 8)] = 0.3111
        pgm_function13[(37, 20, 9)] = 0.1533
        pgm_function13[(37, 20, 10)] = 0.03889614
        pgm_function13[(37, 21, 3)] = 0.0289
        pgm_function13[(37, 21, 4)] = 0.18331815
        pgm_function13[(37, 21, 5)] = 0.3378
        pgm_function13[(37, 21, 6)] = 0.32556742
        pgm_function13[(37, 21, 7)] = 0.1722
        pgm_function13[(37, 21, 8)] = 0.047795222
        pgm_function13[(37, 21, 9)] = 0.0011
        pgm_function13[(37, 22, 1)] = 0.0222
        pgm_function13[(37, 22, 2)] = 0.15668403
        pgm_function13[(37, 22, 3)] = 0.3311
        pgm_function13[(37, 22, 4)] = 0.3356
        pgm_function13[(37, 22, 5)] = 0.187819105
        pgm_function13[(37, 22, 6)] = 0.0567
        pgm_function13[(37, 22, 7)] = 0.003300659
        pgm_function13[(37, 23, 0)] = 0.16
        pgm_function13[(37, 23, 1)] = 0.321068247
        pgm_function13[(37, 23, 2)] = 0.34003419
        pgm_function13[(37, 23, 3)] = 0.21
        pgm_function13[(37, 23, 4)] = 0.0656
        pgm_function13[(37, 23, 5)] = 0.0067
        pgm_function13[(37, 24, 0)] = 0.344434269
        pgm_function13[(37, 24, 1)] = 0.232223174
        pgm_function13[(37, 24, 2)] = 0.07559242
        pgm_function13[(37, 24, 3)] = 0.01
        pgm_function13[(37, 25, 0)] = 0.0733
        pgm_function13[(37, 25, 1)] = 0.0133
        pgm_function13[(38, 0, 43)] = 0.00220022
        pgm_function13[(38, 0, 44)] = 0.0867
        pgm_function13[(38, 0, 45)] = 0.27782814
        pgm_function13[(38, 0, 46)] = 0.36223625
        pgm_function13[(38, 0, 47)] = 0.2511
        pgm_function13[(38, 0, 48)] = 0.1056
        pgm_function13[(38, 0, 49)] = 0.0122
        pgm_function13[(38, 1, 41)] = 0.0011
        pgm_function13[(38, 1, 42)] = 0.0544
        pgm_function13[(38, 1, 43)] = 0.2144
        pgm_function13[(38, 1, 44)] = 0.3344
        pgm_function13[(38, 1, 45)] = 0.29442926
        pgm_function13[(38, 1, 46)] = 0.1478
        pgm_function13[(38, 1, 47)] = 0.0456
        pgm_function13[(38, 1, 48)] = 0.0011
        pgm_function13[(38, 2, 40)] = 0.04440443
        pgm_function13[(38, 2, 41)] = 0.1911
        pgm_function13[(38, 2, 42)] = 0.3321673
        pgm_function13[(38, 2, 43)] = 0.30556928
        pgm_function13[(38, 2, 44)] = 0.1633
        pgm_function13[(38, 2, 45)] = 0.052205225
        pgm_function13[(38, 2, 46)] = 0.004400443
        pgm_function13[(38, 3, 38)] = 0.03330333
        pgm_function13[(38, 3, 39)] = 0.16558315
        pgm_function13[(38, 3, 40)] = 0.3311
        pgm_function13[(38, 3, 41)] = 0.3111
        pgm_function13[(38, 3, 42)] = 0.183318106
        pgm_function13[(38, 3, 43)] = 0.06
        pgm_function13[(38, 3, 44)] = 0.006699334
        pgm_function13[(38, 4, 36)] = 0.0222
        pgm_function13[(38, 4, 37)] = 0.1488851
        pgm_function13[(38, 4, 38)] = 0.3178
        pgm_function13[(38, 4, 39)] = 0.326667464
        pgm_function13[(38, 4, 40)] = 0.201120179
        pgm_function13[(38, 4, 41)] = 0.068906961
        pgm_function13[(38, 4, 42)] = 0.01
        pgm_function13[(38, 5, 34)] = 0.0144
        pgm_function13[(38, 5, 35)] = 0.1333
        pgm_function13[(38, 5, 36)] = 0.2978
        pgm_function13[(38, 5, 37)] = 0.338934339
        pgm_function13[(38, 5, 38)] = 0.2167
        pgm_function13[(38, 5, 39)] = 0.078892165
        pgm_function13[(38, 5, 40)] = 0.013301314
        pgm_function13[(38, 6, 32)] = 0.01
        pgm_function13[(38, 6, 33)] = 0.112211091
        pgm_function13[(38, 6, 34)] = 0.284428063
        pgm_function13[(38, 6, 35)] = 0.3444
        pgm_function13[(38, 6, 36)] = 0.235576167
        pgm_function13[(38, 6, 37)] = 0.0889
        pgm_function13[(38, 6, 38)] = 0.0178
        pgm_function13[(38, 7, 30)] = 0.0067
        pgm_function13[(38, 7, 31)] = 0.092209174
        pgm_function13[(38, 7, 32)] = 0.273327303
        pgm_function13[(38, 7, 33)] = 0.3489
        pgm_function13[(38, 7, 34)] = 0.2489251
        pgm_function13[(38, 7, 35)] = 0.1044
        pgm_function13[(38, 7, 36)] = 0.0222
        pgm_function13[(38, 8, 28)] = 0.00330033
        pgm_function13[(38, 8, 29)] = 0.0767
        pgm_function13[(38, 8, 30)] = 0.2489
        pgm_function13[(38, 8, 31)] = 0.35223521
        pgm_function13[(38, 8, 32)] = 0.2621741
        pgm_function13[(38, 8, 33)] = 0.1211
        pgm_function13[(38, 8, 34)] = 0.0278
        pgm_function13[(38, 9, 26)] = 0.0011
        pgm_function13[(38, 9, 27)] = 0.06560667
        pgm_function13[(38, 9, 28)] = 0.22442213
        pgm_function13[(38, 9, 29)] = 0.3522
        pgm_function13[(38, 9, 30)] = 0.2778
        pgm_function13[(38, 9, 31)] = 0.13888607
        pgm_function13[(38, 9, 32)] = 0.03330332
        pgm_function13[(38, 10, 25)] = 0.05110515
        pgm_function13[(38, 10, 26)] = 0.20777919
        pgm_function13[(38, 10, 27)] = 0.34333417
        pgm_function13[(38, 10, 28)] = 0.2944
        pgm_function13[(38, 10, 29)] = 0.15331511
        pgm_function13[(38, 10, 30)] = 0.0411
        pgm_function13[(38, 10, 31)] = 0.001099891
        pgm_function13[(38, 11, 23)] = 0.0378
        pgm_function13[(38, 11, 24)] = 0.1889
        pgm_function13[(38, 11, 25)] = 0.3344333
        pgm_function13[(38, 11, 26)] = 0.31333128
        pgm_function13[(38, 11, 27)] = 0.1678
        pgm_function13[(38, 11, 28)] = 0.05
        pgm_function13[(38, 11, 29)] = 0.0022
        pgm_function13[(38, 12, 21)] = 0.0267
        pgm_function13[(38, 12, 22)] = 0.16668315
        pgm_function13[(38, 12, 23)] = 0.3289
        pgm_function13[(38, 12, 24)] = 0.32783326
        pgm_function13[(38, 12, 25)] = 0.1833
        pgm_function13[(38, 12, 26)] = 0.0589
        pgm_function13[(38, 12, 27)] = 0.0044
        pgm_function13[(38, 13, 19)] = 0.02
        pgm_function13[(38, 13, 20)] = 0.14331404
        pgm_function13[(38, 13, 21)] = 0.31666838
        pgm_function13[(38, 13, 22)] = 0.3344
        pgm_function13[(38, 13, 23)] = 0.202220089
        pgm_function13[(38, 13, 24)] = 0.0689
        pgm_function13[(38, 13, 25)] = 0.006699333
        pgm_function13[(38, 14, 17)] = 0.0122024
        pgm_function13[(38, 14, 18)] = 0.1244
        pgm_function13[(38, 14, 19)] = 0.2989
        pgm_function13[(38, 14, 20)] = 0.34673501
        pgm_function13[(38, 14, 21)] = 0.220022031
        pgm_function13[(38, 14, 22)] = 0.078892162
        pgm_function13[(38, 14, 23)] = 0.01
        pgm_function13[(38, 15, 15)] = 0.0067
        pgm_function13[(38, 15, 16)] = 0.110011028
        pgm_function13[(38, 15, 17)] = 0.28332804
        pgm_function13[(38, 15, 18)] = 0.353335085
        pgm_function13[(38, 15, 19)] = 0.2344
        pgm_function13[(38, 15, 20)] = 0.0922
        pgm_function13[(38, 15, 21)] = 0.0133
        pgm_function13[(38, 16, 13)] = 0.004400441
        pgm_function13[(38, 16, 14)] = 0.088908941
        pgm_function13[(38, 16, 15)] = 0.2678
        pgm_function13[(38, 16, 16)] = 0.3533
        pgm_function13[(38, 16, 17)] = 0.25562605
        pgm_function13[(38, 16, 18)] = 0.1056
        pgm_function13[(38, 16, 19)] = 0.0189
        pgm_function13[(38, 17, 11)] = 0.00220022
        pgm_function13[(38, 17, 12)] = 0.0722072
        pgm_function13[(38, 17, 13)] = 0.2511
        pgm_function13[(38, 17, 14)] = 0.3467
        pgm_function13[(38, 17, 15)] = 0.27777242
        pgm_function13[(38, 17, 16)] = 0.11888813
        pgm_function13[(38, 17, 17)] = 0.0244
        pgm_function13[(38, 18, 9)] = 0.00110011
        pgm_function13[(38, 18, 10)] = 0.0589
        pgm_function13[(38, 18, 11)] = 0.22557709
        pgm_function13[(38, 18, 12)] = 0.3478
        pgm_function13[(38, 18, 13)] = 0.2956
        pgm_function13[(38, 18, 14)] = 0.13328712
        pgm_function13[(38, 18, 15)] = 0.03109693
        pgm_function13[(38, 19, 8)] = 0.045595414
        pgm_function13[(38, 19, 9)] = 0.2011
        pgm_function13[(38, 19, 10)] = 0.3511
        pgm_function13[(38, 19, 11)] = 0.30556924
        pgm_function13[(38, 19, 12)] = 0.1511
        pgm_function13[(38, 19, 13)] = 0.03889614
        pgm_function13[(38, 20, 6)] = 0.0311
        pgm_function13[(38, 20, 7)] = 0.1833
        pgm_function13[(38, 20, 8)] = 0.3411
        pgm_function13[(38, 20, 9)] = 0.32
        pgm_function13[(38, 20, 10)] = 0.16998317
        pgm_function13[(38, 20, 11)] = 0.0478
        pgm_function13[(38, 20, 12)] = 0.0011
        pgm_function13[(38, 21, 4)] = 0.02220222
        pgm_function13[(38, 21, 5)] = 0.1633
        pgm_function13[(38, 21, 6)] = 0.32886743
        pgm_function13[(38, 21, 7)] = 0.3322
        pgm_function13[(38, 21, 8)] = 0.186681088
        pgm_function13[(38, 21, 9)] = 0.0556
        pgm_function13[(38, 21, 10)] = 0.00330033
        pgm_function13[(38, 22, 2)] = 0.0155984
        pgm_function13[(38, 22, 3)] = 0.14
        pgm_function13[(38, 22, 4)] = 0.3189
        pgm_function13[(38, 22, 5)] = 0.343334192
        pgm_function13[(38, 22, 6)] = 0.2056
        pgm_function13[(38, 22, 7)] = 0.064412887
        pgm_function13[(38, 22, 8)] = 0.006699335
        pgm_function13[(38, 23, 0)] = 0.0111
        pgm_function13[(38, 23, 1)] = 0.11668809
        pgm_function13[(38, 23, 2)] = 0.310031174
        pgm_function13[(38, 23, 3)] = 0.3489
        pgm_function13[(38, 23, 4)] = 0.2267
        pgm_function13[(38, 23, 5)] = 0.0733
        pgm_function13[(38, 23, 6)] = 0.01
        pgm_function13[(38, 24, 0)] = 0.306731239
        pgm_function13[(38, 24, 1)] = 0.352235264
        pgm_function13[(38, 24, 2)] = 0.247775067
        pgm_function13[(38, 24, 3)] = 0.0856
        pgm_function13[(38, 24, 4)] = 0.0133
        pgm_function13[(38, 25, 0)] = 0.2411
        pgm_function13[(38, 25, 1)] = 0.1022
        pgm_function13[(38, 25, 2)] = 0.01779821
        pgm_function13[(38, 26, 0)] = 0.0155984
        pgm_function13[(39, 0, 44)] = 0.0011
        pgm_function13[(39, 0, 45)] = 0.07330734
        pgm_function13[(39, 0, 46)] = 0.26222618
        pgm_function13[(39, 0, 47)] = 0.36
        pgm_function13[(39, 0, 48)] = 0.2533
        pgm_function13[(39, 0, 49)] = 0.1167
        pgm_function13[(39, 0, 50)] = 0.01889812
        pgm_function13[(39, 1, 43)] = 0.0456
        pgm_function13[(39, 1, 44)] = 0.1978
        pgm_function13[(39, 1, 45)] = 0.3300333
        pgm_function13[(39, 1, 46)] = 0.3011
        pgm_function13[(39, 1, 47)] = 0.1622
        pgm_function13[(39, 1, 48)] = 0.0522
        pgm_function13[(39, 1, 49)] = 0.0044
        pgm_function13[(39, 2, 41)] = 0.0344
        pgm_function13[(39, 2, 42)] = 0.17668216
        pgm_function13[(39, 2, 43)] = 0.32666729
        pgm_function13[(39, 2, 44)] = 0.3144
        pgm_function13[(39, 2, 45)] = 0.178918086
        pgm_function13[(39, 2, 46)] = 0.058905945
        pgm_function13[(39, 2, 47)] = 0.006698657
        pgm_function13[(39, 3, 39)] = 0.02669732
        pgm_function13[(39, 3, 40)] = 0.15
        pgm_function13[(39, 3, 41)] = 0.3222
        pgm_function13[(39, 3, 42)] = 0.321132186
        pgm_function13[(39, 3, 43)] = 0.1967
        pgm_function13[(39, 3, 44)] = 0.067793241
        pgm_function13[(39, 3, 45)] = 0.01
        pgm_function13[(39, 4, 37)] = 0.01779821
        pgm_function13[(39, 4, 38)] = 0.1311
        pgm_function13[(39, 4, 39)] = 0.306669435
        pgm_function13[(39, 4, 40)] = 0.331133295
        pgm_function13[(39, 4, 41)] = 0.214421191
        pgm_function13[(39, 4, 42)] = 0.0789
        pgm_function13[(39, 4, 43)] = 0.013301308
        pgm_function13[(39, 5, 35)] = 0.01
        pgm_function13[(39, 5, 36)] = 0.1189
        pgm_function13[(39, 5, 37)] = 0.283328283
        pgm_function13[(39, 5, 38)] = 0.3433
        pgm_function13[(39, 5, 39)] = 0.229977189
        pgm_function13[(39, 5, 40)] = 0.088908997
        pgm_function13[(39, 5, 41)] = 0.0178
        pgm_function13[(39, 6, 33)] = 0.006700675
        pgm_function13[(39, 6, 34)] = 0.098909922
        pgm_function13[(39, 6, 35)] = 0.2689
        pgm_function13[(39, 6, 36)] = 0.351065249
        pgm_function13[(39, 6, 37)] = 0.2456
        pgm_function13[(39, 6, 38)] = 0.1033
        pgm_function13[(39, 6, 39)] = 0.0222
        pgm_function13[(39, 7, 31)] = 0.004400439
        pgm_function13[(39, 7, 32)] = 0.078907988
        pgm_function13[(39, 7, 33)] = 0.2533
        pgm_function13[(39, 7, 34)] = 0.35113514
        pgm_function13[(39, 7, 35)] = 0.2611
        pgm_function13[(39, 7, 36)] = 0.1178
        pgm_function13[(39, 7, 37)] = 0.0278
        pgm_function13[(39, 8, 29)] = 0.0022
        pgm_function13[(39, 8, 30)] = 0.0656
        pgm_function13[(39, 8, 31)] = 0.23442314
        pgm_function13[(39, 8, 32)] = 0.34776514
        pgm_function13[(39, 8, 33)] = 0.2767
        pgm_function13[(39, 8, 34)] = 0.1344
        pgm_function13[(39, 8, 35)] = 0.0333
        pgm_function13[(39, 9, 28)] = 0.05440543
        pgm_function13[(39, 9, 29)] = 0.21
        pgm_function13[(39, 9, 30)] = 0.3456
        pgm_function13[(39, 9, 31)] = 0.28777114
        pgm_function13[(39, 9, 32)] = 0.15331511
        pgm_function13[(39, 9, 33)] = 0.03999602
        pgm_function13[(39, 9, 34)] = 0.0011
        pgm_function13[(39, 10, 26)] = 0.04109594
        pgm_function13[(39, 10, 27)] = 0.1900191
        pgm_function13[(39, 10, 28)] = 0.34
        pgm_function13[(39, 10, 29)] = 0.30673121
        pgm_function13[(39, 10, 30)] = 0.1656
        pgm_function13[(39, 10, 31)] = 0.048895149
        pgm_function13[(39, 10, 32)] = 0.0022
        pgm_function13[(39, 11, 24)] = 0.03
        pgm_function13[(39, 11, 25)] = 0.17001715
        pgm_function13[(39, 11, 26)] = 0.3278333
        pgm_function13[(39, 11, 27)] = 0.3244
        pgm_function13[(39, 11, 28)] = 0.18
        pgm_function13[(39, 11, 29)] = 0.0589
        pgm_function13[(39, 11, 30)] = 0.0044
        pgm_function13[(39, 12, 22)] = 0.02109792
        pgm_function13[(39, 12, 23)] = 0.15
        pgm_function13[(39, 12, 24)] = 0.31333125
        pgm_function13[(39, 12, 25)] = 0.3356
        pgm_function13[(39, 12, 26)] = 0.1967
        pgm_function13[(39, 12, 27)] = 0.0678
        pgm_function13[(39, 12, 28)] = 0.0067
        pgm_function13[(39, 13, 20)] = 0.0144014
        pgm_function13[(39, 13, 21)] = 0.128887155
        pgm_function13[(39, 13, 22)] = 0.3033
        pgm_function13[(39, 13, 23)] = 0.343334151
        pgm_function13[(39, 13, 24)] = 0.2156
        pgm_function13[(39, 13, 25)] = 0.07889213
        pgm_function13[(39, 13, 26)] = 0.01
        pgm_function13[(39, 14, 18)] = 0.01
        pgm_function13[(39, 14, 19)] = 0.11
        pgm_function13[(39, 14, 20)] = 0.28892901
        pgm_function13[(39, 14, 21)] = 0.346735049
        pgm_function13[(39, 14, 22)] = 0.236676185
        pgm_function13[(39, 14, 23)] = 0.0889
        pgm_function13[(39, 14, 24)] = 0.01330131
        pgm_function13[(39, 15, 16)] = 0.004400441
        pgm_function13[(39, 15, 17)] = 0.09220921
        pgm_function13[(39, 15, 18)] = 0.268927065
        pgm_function13[(39, 15, 19)] = 0.3567
        pgm_function13[(39, 15, 20)] = 0.2511
        pgm_function13[(39, 15, 21)] = 0.1044
        pgm_function13[(39, 15, 22)] = 0.01890192
        pgm_function13[(39, 16, 14)] = 0.002200221
        pgm_function13[(39, 16, 15)] = 0.0767
        pgm_function13[(39, 16, 16)] = 0.25
        pgm_function13[(39, 16, 17)] = 0.35443507
        pgm_function13[(39, 16, 18)] = 0.2667
        pgm_function13[(39, 16, 19)] = 0.1178
        pgm_function13[(39, 16, 20)] = 0.02440242
        pgm_function13[(39, 17, 12)] = 0.00110011
        pgm_function13[(39, 17, 13)] = 0.06
        pgm_function13[(39, 17, 14)] = 0.2322
        pgm_function13[(39, 17, 15)] = 0.34556552
        pgm_function13[(39, 17, 16)] = 0.28887132
        pgm_function13[(39, 17, 17)] = 0.1322
        pgm_function13[(39, 17, 18)] = 0.03109693
        pgm_function13[(39, 18, 11)] = 0.047795219
        pgm_function13[(39, 18, 12)] = 0.2122
        pgm_function13[(39, 18, 13)] = 0.3444
        pgm_function13[(39, 18, 14)] = 0.30666928
        pgm_function13[(39, 18, 15)] = 0.14668513
        pgm_function13[(39, 18, 16)] = 0.0389
        pgm_function13[(39, 19, 9)] = 0.0367
        pgm_function13[(39, 19, 10)] = 0.1833
        pgm_function13[(39, 19, 11)] = 0.34216627
        pgm_function13[(39, 19, 12)] = 0.3167
        pgm_function13[(39, 19, 13)] = 0.16558317
        pgm_function13[(39, 19, 14)] = 0.0478
        pgm_function13[(39, 19, 15)] = 0.00109989
        pgm_function13[(39, 20, 7)] = 0.0256
        pgm_function13[(39, 20, 8)] = 0.1622
        pgm_function13[(39, 20, 9)] = 0.3356
        pgm_function13[(39, 20, 10)] = 0.32666733
        pgm_function13[(39, 20, 11)] = 0.1844
        pgm_function13[(39, 20, 12)] = 0.0556
        pgm_function13[(39, 20, 13)] = 0.00330033
        pgm_function13[(39, 21, 5)] = 0.0167
        pgm_function13[(39, 21, 6)] = 0.14558519
        pgm_function13[(39, 21, 7)] = 0.3189
        pgm_function13[(39, 21, 8)] = 0.33996616
        pgm_function13[(39, 21, 9)] = 0.2033
        pgm_function13[(39, 21, 10)] = 0.06330629
        pgm_function13[(39, 21, 11)] = 0.0067
        pgm_function13[(39, 22, 3)] = 0.0111
        pgm_function13[(39, 22, 4)] = 0.1244
        pgm_function13[(39, 22, 5)] = 0.30333017
        pgm_function13[(39, 22, 6)] = 0.3511
        pgm_function13[(39, 22, 7)] = 0.223344955
        pgm_function13[(39, 22, 8)] = 0.071092948
        pgm_function13[(39, 22, 9)] = 0.01
        pgm_function13[(39, 23, 1)] = 0.006699335
        pgm_function13[(39, 23, 2)] = 0.102210057
        pgm_function13[(39, 23, 3)] = 0.2911
        pgm_function13[(39, 23, 4)] = 0.3511
        pgm_function13[(39, 23, 5)] = 0.2433
        pgm_function13[(39, 23, 6)] = 0.0844
        pgm_function13[(39, 23, 7)] = 0.01329871
        pgm_function13[(39, 24, 0)] = 0.104410081
        pgm_function13[(39, 24, 1)] = 0.273327205
        pgm_function13[(39, 24, 2)] = 0.352165095
        pgm_function13[(39, 24, 3)] = 0.2622
        pgm_function13[(39, 24, 4)] = 0.0989
        pgm_function13[(39, 24, 5)] = 0.01780182
        pgm_function13[(39, 25, 0)] = 0.3678
        pgm_function13[(39, 25, 1)] = 0.2744
        pgm_function13[(39, 25, 2)] = 0.11558808
        pgm_function13[(39, 25, 3)] = 0.02220221
        pgm_function13[(39, 26, 0)] = 0.10668902
        pgm_function13[(39, 26, 1)] = 0.02779721
        pgm_function13[(40, 0, 46)] = 0.06000604
        pgm_function13[(40, 0, 47)] = 0.2478
        pgm_function13[(40, 0, 48)] = 0.3689
        pgm_function13[(40, 0, 49)] = 0.2644
        pgm_function13[(40, 0, 50)] = 0.12778712
        pgm_function13[(40, 0, 51)] = 0.0267
        pgm_function13[(40, 1, 44)] = 0.0356
        pgm_function13[(40, 1, 45)] = 0.18111816
        pgm_function13[(40, 1, 46)] = 0.3278
        pgm_function13[(40, 1, 47)] = 0.31
        pgm_function13[(40, 1, 48)] = 0.1778
        pgm_function13[(40, 1, 49)] = 0.0578
        pgm_function13[(40, 1, 50)] = 0.00669933
        pgm_function13[(40, 2, 42)] = 0.02669732
        pgm_function13[(40, 2, 43)] = 0.15888414
        pgm_function13[(40, 2, 44)] = 0.3156
        pgm_function13[(40, 2, 45)] = 0.322232155
        pgm_function13[(40, 2, 46)] = 0.192219148
        pgm_function13[(40, 2, 47)] = 0.066686672
        pgm_function13[(40, 2, 48)] = 0.009999007
        pgm_function13[(40, 3, 40)] = 0.02
        pgm_function13[(40, 3, 41)] = 0.1367
        pgm_function13[(40, 3, 42)] = 0.307831179
        pgm_function13[(40, 3, 43)] = 0.3278
        pgm_function13[(40, 3, 44)] = 0.208879127
        pgm_function13[(40, 3, 45)] = 0.0789
        pgm_function13[(40, 3, 46)] = 0.013301305
        pgm_function13[(40, 4, 38)] = 0.0144
        pgm_function13[(40, 4, 39)] = 0.116688166
        pgm_function13[(40, 4, 40)] = 0.293329261
        pgm_function13[(40, 4, 41)] = 0.333333297
        pgm_function13[(40, 4, 42)] = 0.2256
        pgm_function13[(40, 4, 43)] = 0.088908952
        pgm_function13[(40, 4, 44)] = 0.0178
        pgm_function13[(40, 5, 36)] = 0.0078
        pgm_function13[(40, 5, 37)] = 0.103310103
        pgm_function13[(40, 5, 38)] = 0.2711
        pgm_function13[(40, 5, 39)] = 0.346665284
        pgm_function13[(40, 5, 40)] = 0.243324265
        pgm_function13[(40, 5, 41)] = 0.1022
        pgm_function13[(40, 5, 42)] = 0.0222
        pgm_function13[(40, 6, 34)] = 0.004400441
        pgm_function13[(40, 6, 35)] = 0.0867
        pgm_function13[(40, 6, 36)] = 0.246675175
        pgm_function13[(40, 6, 37)] = 0.3544
        pgm_function13[(40, 6, 38)] = 0.2578
        pgm_function13[(40, 6, 39)] = 0.1156
        pgm_function13[(40, 6, 40)] = 0.0278
        pgm_function13[(40, 7, 32)] = 0.002200222
        pgm_function13[(40, 7, 33)] = 0.0689
        pgm_function13[(40, 7, 34)] = 0.23332309
        pgm_function13[(40, 7, 35)] = 0.35
        pgm_function13[(40, 7, 36)] = 0.2733
        pgm_function13[(40, 7, 37)] = 0.1311
        pgm_function13[(40, 7, 38)] = 0.03329673
        pgm_function13[(40, 8, 30)] = 0.0011
        pgm_function13[(40, 8, 31)] = 0.05440543
        pgm_function13[(40, 8, 32)] = 0.21887809
        pgm_function13[(40, 8, 33)] = 0.3411
        pgm_function13[(40, 8, 34)] = 0.29
        pgm_function13[(40, 8, 35)] = 0.1478
        pgm_function13[(40, 8, 36)] = 0.04
        pgm_function13[(40, 8, 37)] = 0.001100111
        pgm_function13[(40, 9, 29)] = 0.0444
        pgm_function13[(40, 9, 30)] = 0.1956
        pgm_function13[(40, 9, 31)] = 0.33776617
        pgm_function13[(40, 9, 32)] = 0.30113021
        pgm_function13[(40, 9, 33)] = 0.1632841
        pgm_function13[(40, 9, 34)] = 0.0478
        pgm_function13[(40, 9, 35)] = 0.0022
        pgm_function13[(40, 10, 27)] = 0.03330332
        pgm_function13[(40, 10, 28)] = 0.1711
        pgm_function13[(40, 10, 29)] = 0.33223323
        pgm_function13[(40, 10, 30)] = 0.3167
        pgm_function13[(40, 10, 31)] = 0.178882181
        pgm_function13[(40, 10, 32)] = 0.0589
        pgm_function13[(40, 10, 33)] = 0.004400442
        pgm_function13[(40, 11, 25)] = 0.02330232
        pgm_function13[(40, 11, 26)] = 0.15331514
        pgm_function13[(40, 11, 27)] = 0.3167
        pgm_function13[(40, 11, 28)] = 0.3322
        pgm_function13[(40, 11, 29)] = 0.1922
        pgm_function13[(40, 11, 30)] = 0.0678
        pgm_function13[(40, 11, 31)] = 0.0067
        pgm_function13[(40, 12, 23)] = 0.0156
        pgm_function13[(40, 12, 24)] = 0.13441311
        pgm_function13[(40, 12, 25)] = 0.3011
        pgm_function13[(40, 12, 26)] = 0.3433
        pgm_function13[(40, 12, 27)] = 0.21
        pgm_function13[(40, 12, 28)] = 0.0789
        pgm_function13[(40, 12, 29)] = 0.01
        pgm_function13[(40, 13, 21)] = 0.009999012
        pgm_function13[(40, 13, 22)] = 0.1156
        pgm_function13[(40, 13, 23)] = 0.287829127
        pgm_function13[(40, 13, 24)] = 0.3478
        pgm_function13[(40, 13, 25)] = 0.232177088
        pgm_function13[(40, 13, 26)] = 0.0889
        pgm_function13[(40, 13, 27)] = 0.0133013
        pgm_function13[(40, 14, 19)] = 0.0067
        pgm_function13[(40, 14, 20)] = 0.0933093
        pgm_function13[(40, 14, 21)] = 0.274427038
        pgm_function13[(40, 14, 22)] = 0.347765271
        pgm_function13[(40, 14, 23)] = 0.2522
        pgm_function13[(40, 14, 24)] = 0.10111005
        pgm_function13[(40, 14, 25)] = 0.0189
        pgm_function13[(40, 15, 17)] = 0.00330033
        pgm_function13[(40, 15, 18)] = 0.078907919
        pgm_function13[(40, 15, 19)] = 0.2533
        pgm_function13[(40, 15, 20)] = 0.3522
        pgm_function13[(40, 15, 21)] = 0.2656
        pgm_function13[(40, 15, 22)] = 0.11441115
        pgm_function13[(40, 15, 23)] = 0.02439764
        pgm_function13[(40, 16, 15)] = 0.0011
        pgm_function13[(40, 16, 16)] = 0.0656
        pgm_function13[(40, 16, 17)] = 0.23112305
        pgm_function13[(40, 16, 18)] = 0.3533
        pgm_function13[(40, 16, 19)] = 0.2822
        pgm_function13[(40, 16, 20)] = 0.13001312
        pgm_function13[(40, 16, 21)] = 0.0311
        pgm_function13[(40, 17, 14)] = 0.0511
        pgm_function13[(40, 17, 15)] = 0.21557832
        pgm_function13[(40, 17, 16)] = 0.34556538
        pgm_function13[(40, 17, 17)] = 0.3
        pgm_function13[(40, 17, 18)] = 0.14668516
        pgm_function13[(40, 17, 19)] = 0.03780383
        pgm_function13[(40, 18, 12)] = 0.0378
        pgm_function13[(40, 18, 13)] = 0.1911
        pgm_function13[(40, 18, 14)] = 0.3355663
        pgm_function13[(40, 18, 15)] = 0.31776829
        pgm_function13[(40, 18, 16)] = 0.1611
        pgm_function13[(40, 18, 17)] = 0.0478
        pgm_function13[(40, 18, 18)] = 0.00109989
        pgm_function13[(40, 19, 10)] = 0.0289
        pgm_function13[(40, 19, 11)] = 0.16778313
        pgm_function13[(40, 19, 12)] = 0.3333
        pgm_function13[(40, 19, 13)] = 0.32556733
        pgm_function13[(40, 19, 14)] = 0.1789
        pgm_function13[(40, 19, 15)] = 0.055594415
        pgm_function13[(40, 19, 16)] = 0.00330033
        pgm_function13[(40, 20, 8)] = 0.0211
        pgm_function13[(40, 20, 9)] = 0.1456
        pgm_function13[(40, 20, 10)] = 0.32556733
        pgm_function13[(40, 20, 11)] = 0.3311
        pgm_function13[(40, 20, 12)] = 0.2
        pgm_function13[(40, 20, 13)] = 0.06330631
        pgm_function13[(40, 20, 14)] = 0.0056
        pgm_function13[(40, 21, 6)] = 0.01219882
        pgm_function13[(40, 21, 7)] = 0.1278
        pgm_function13[(40, 21, 8)] = 0.307769145
        pgm_function13[(40, 21, 9)] = 0.3467
        pgm_function13[(40, 21, 10)] = 0.22112197
        pgm_function13[(40, 21, 11)] = 0.0711
        pgm_function13[(40, 21, 12)] = 0.01
        pgm_function13[(40, 22, 4)] = 0.0067
        pgm_function13[(40, 22, 5)] = 0.111111062
        pgm_function13[(40, 22, 6)] = 0.2878
        pgm_function13[(40, 22, 7)] = 0.354470929
        pgm_function13[(40, 22, 8)] = 0.239976163
        pgm_function13[(40, 22, 9)] = 0.0822
        pgm_function13[(40, 22, 10)] = 0.0133
        pgm_function13[(40, 23, 2)] = 0.004400442
        pgm_function13[(40, 23, 3)] = 0.0889
        pgm_function13[(40, 23, 4)] = 0.2733
        pgm_function13[(40, 23, 5)] = 0.3567
        pgm_function13[(40, 23, 6)] = 0.2556
        pgm_function13[(40, 23, 7)] = 0.09669036
        pgm_function13[(40, 23, 8)] = 0.01779821
        pgm_function13[(40, 24, 0)] = 0.002200222
        pgm_function13[(40, 24, 1)] = 0.071107153
        pgm_function13[(40, 24, 2)] = 0.25777407
        pgm_function13[(40, 24, 3)] = 0.3544
        pgm_function13[(40, 24, 4)] = 0.2722
        pgm_function13[(40, 24, 5)] = 0.11331111
        pgm_function13[(40, 24, 6)] = 0.0222
        pgm_function13[(40, 25, 0)] = 0.2589
        pgm_function13[(40, 25, 1)] = 0.3567
        pgm_function13[(40, 25, 2)] = 0.2888712
        pgm_function13[(40, 25, 3)] = 0.13001307
        pgm_function13[(40, 25, 4)] = 0.02779722
        pgm_function13[(40, 26, 0)] = 0.29777006
        pgm_function13[(40, 26, 1)] = 0.15108506
        pgm_function13[(40, 26, 2)] = 0.0344
        pgm_function13[(40, 27, 0)] = 0.034403432
        pgm_function13[(40, 27, 1)] = 0.00110011
        pgm_function13[(41, 0, 47)] = 0.0467
        pgm_function13[(41, 0, 48)] = 0.2344
        pgm_function13[(41, 0, 49)] = 0.36
        pgm_function13[(41, 0, 50)] = 0.27667225
        pgm_function13[(41, 0, 51)] = 0.1389
        pgm_function13[(41, 0, 52)] = 0.0344
        pgm_function13[(41, 1, 45)] = 0.02890293
        pgm_function13[(41, 1, 46)] = 0.1622
        pgm_function13[(41, 1, 47)] = 0.3189
        pgm_function13[(41, 1, 48)] = 0.3167
        pgm_function13[(41, 1, 49)] = 0.1922
        pgm_function13[(41, 1, 50)] = 0.0655934
        pgm_function13[(41, 1, 51)] = 0.010001
        pgm_function13[(41, 2, 43)] = 0.01999802
        pgm_function13[(41, 2, 44)] = 0.1444
        pgm_function13[(41, 2, 45)] = 0.304430146
        pgm_function13[(41, 2, 46)] = 0.328933253
        pgm_function13[(41, 2, 47)] = 0.206658913
        pgm_function13[(41, 2, 48)] = 0.075592456
        pgm_function13[(41, 2, 49)] = 0.0133
        pgm_function13[(41, 3, 41)] = 0.0144
        pgm_function13[(41, 3, 42)] = 0.123312072
        pgm_function13[(41, 3, 43)] = 0.2933
        pgm_function13[(41, 3, 44)] = 0.337766206
        pgm_function13[(41, 3, 45)] = 0.2189
        pgm_function13[(41, 3, 46)] = 0.087808833
        pgm_function13[(41, 3, 47)] = 0.0178
        pgm_function13[(41, 4, 39)] = 0.009999014
        pgm_function13[(41, 4, 40)] = 0.103310092
        pgm_function13[(41, 4, 41)] = 0.28112825
        pgm_function13[(41, 4, 42)] = 0.34
        pgm_function13[(41, 4, 43)] = 0.238924141
        pgm_function13[(41, 4, 44)] = 0.1011
        pgm_function13[(41, 4, 45)] = 0.02220222
        pgm_function13[(41, 5, 37)] = 0.005600566
        pgm_function13[(41, 5, 38)] = 0.0889
        pgm_function13[(41, 5, 39)] = 0.25557421
        pgm_function13[(41, 5, 40)] = 0.344434375
        pgm_function13[(41, 5, 41)] = 0.2556
        pgm_function13[(41, 5, 42)] = 0.1144
        pgm_function13[(41, 5, 43)] = 0.0278
        pgm_function13[(41, 6, 35)] = 0.0022
        pgm_function13[(41, 6, 36)] = 0.076692354
        pgm_function13[(41, 6, 37)] = 0.2311
        pgm_function13[(41, 6, 38)] = 0.35
        pgm_function13[(41, 6, 39)] = 0.2689
        pgm_function13[(41, 6, 40)] = 0.1289
        pgm_function13[(41, 6, 41)] = 0.0333
        pgm_function13[(41, 7, 33)] = 0.0011
        pgm_function13[(41, 7, 34)] = 0.06110612
        pgm_function13[(41, 7, 35)] = 0.2156
        pgm_function13[(41, 7, 36)] = 0.3456
        pgm_function13[(41, 7, 37)] = 0.2856
        pgm_function13[(41, 7, 38)] = 0.14558515
        pgm_function13[(41, 7, 39)] = 0.04
        pgm_function13[(41, 7, 40)] = 0.001100111
        pgm_function13[(41, 8, 32)] = 0.04559542
        pgm_function13[(41, 8, 33)] = 0.2033
        pgm_function13[(41, 8, 34)] = 0.3333
        pgm_function13[(41, 8, 35)] = 0.3022
        pgm_function13[(41, 8, 36)] = 0.1611
        pgm_function13[(41, 8, 37)] = 0.047804833
        pgm_function13[(41, 8, 38)] = 0.0022
        pgm_function13[(41, 9, 30)] = 0.0344
        pgm_function13[(41, 9, 31)] = 0.18108209
        pgm_function13[(41, 9, 32)] = 0.32783323
        pgm_function13[(41, 9, 33)] = 0.31556819
        pgm_function13[(41, 9, 34)] = 0.1767
        pgm_function13[(41, 9, 35)] = 0.0567
        pgm_function13[(41, 9, 36)] = 0.0044
        pgm_function13[(41, 10, 28)] = 0.0267
        pgm_function13[(41, 10, 29)] = 0.15441511
        pgm_function13[(41, 10, 30)] = 0.3211
        pgm_function13[(41, 10, 31)] = 0.325567329
        pgm_function13[(41, 10, 32)] = 0.1889
        pgm_function13[(41, 10, 33)] = 0.066706728
        pgm_function13[(41, 10, 34)] = 0.006699332
        pgm_function13[(41, 11, 26)] = 0.01780182
        pgm_function13[(41, 11, 27)] = 0.1367
        pgm_function13[(41, 11, 28)] = 0.3067
        pgm_function13[(41, 11, 29)] = 0.3367
        pgm_function13[(41, 11, 30)] = 0.2067
        pgm_function13[(41, 11, 31)] = 0.0789
        pgm_function13[(41, 11, 32)] = 0.01000101
        pgm_function13[(41, 12, 24)] = 0.01110111
        pgm_function13[(41, 12, 25)] = 0.1211
        pgm_function13[(41, 12, 26)] = 0.2889
        pgm_function13[(41, 12, 27)] = 0.3467
        pgm_function13[(41, 12, 28)] = 0.2267
        pgm_function13[(41, 12, 29)] = 0.0889
        pgm_function13[(41, 12, 30)] = 0.0133013
        pgm_function13[(41, 13, 22)] = 0.0067
        pgm_function13[(41, 13, 23)] = 0.101110044
        pgm_function13[(41, 13, 24)] = 0.2711
        pgm_function13[(41, 13, 25)] = 0.348865133
        pgm_function13[(41, 13, 26)] = 0.2444
        pgm_function13[(41, 13, 27)] = 0.10111003
        pgm_function13[(41, 13, 28)] = 0.01890191
        pgm_function13[(41, 14, 20)] = 0.00440044
        pgm_function13[(41, 14, 21)] = 0.082208212
        pgm_function13[(41, 14, 22)] = 0.257774201
        pgm_function13[(41, 14, 23)] = 0.3467
        pgm_function13[(41, 14, 24)] = 0.26782713
        pgm_function13[(41, 14, 25)] = 0.1111
        pgm_function13[(41, 14, 26)] = 0.02440241
        pgm_function13[(41, 15, 18)] = 0.002200221
        pgm_function13[(41, 15, 19)] = 0.0667
        pgm_function13[(41, 15, 20)] = 0.2378
        pgm_function13[(41, 15, 21)] = 0.3478
        pgm_function13[(41, 15, 22)] = 0.28222837
        pgm_function13[(41, 15, 23)] = 0.12558719
        pgm_function13[(41, 15, 24)] = 0.03
        pgm_function13[(41, 16, 17)] = 0.05440541
        pgm_function13[(41, 16, 18)] = 0.2156
        pgm_function13[(41, 16, 19)] = 0.3467
        pgm_function13[(41, 16, 20)] = 0.29442926
        pgm_function13[(41, 16, 21)] = 0.1456
        pgm_function13[(41, 16, 22)] = 0.03780383
        pgm_function13[(41, 17, 15)] = 0.04109596
        pgm_function13[(41, 17, 16)] = 0.19558022
        pgm_function13[(41, 17, 17)] = 0.3411
        pgm_function13[(41, 17, 18)] = 0.30776934
        pgm_function13[(41, 17, 19)] = 0.16111613
        pgm_function13[(41, 17, 20)] = 0.045595427
        pgm_function13[(41, 17, 21)] = 0.001100111
        pgm_function13[(41, 18, 13)] = 0.03
        pgm_function13[(41, 18, 14)] = 0.17558216
        pgm_function13[(41, 18, 15)] = 0.3299673
        pgm_function13[(41, 18, 16)] = 0.3222
        pgm_function13[(41, 18, 17)] = 0.1756
        pgm_function13[(41, 18, 18)] = 0.055594421
        pgm_function13[(41, 18, 19)] = 0.003300329
        pgm_function13[(41, 19, 11)] = 0.02219782
        pgm_function13[(41, 19, 12)] = 0.1522
        pgm_function13[(41, 19, 13)] = 0.32326832
        pgm_function13[(41, 19, 14)] = 0.3344
        pgm_function13[(41, 19, 15)] = 0.193281052
        pgm_function13[(41, 19, 16)] = 0.0633063
        pgm_function13[(41, 19, 17)] = 0.0056
        pgm_function13[(41, 20, 9)] = 0.0144
        pgm_function13[(41, 20, 10)] = 0.12778713
        pgm_function13[(41, 20, 11)] = 0.3144
        pgm_function13[(41, 20, 12)] = 0.3411
        pgm_function13[(41, 20, 13)] = 0.21562203
        pgm_function13[(41, 20, 14)] = 0.0722
        pgm_function13[(41, 20, 15)] = 0.010001005
        pgm_function13[(41, 21, 7)] = 0.0089
        pgm_function13[(41, 21, 8)] = 0.111089052
        pgm_function13[(41, 21, 9)] = 0.2933
        pgm_function13[(41, 21, 10)] = 0.34673495
        pgm_function13[(41, 21, 11)] = 0.2389
        pgm_function13[(41, 21, 12)] = 0.08
        pgm_function13[(41, 21, 13)] = 0.0133013
        pgm_function13[(41, 22, 5)] = 0.004400442
        pgm_function13[(41, 22, 6)] = 0.0944
        pgm_function13[(41, 22, 7)] = 0.271153946
        pgm_function13[(41, 22, 8)] = 0.356664243
        pgm_function13[(41, 22, 9)] = 0.2533
        pgm_function13[(41, 22, 10)] = 0.0933
        pgm_function13[(41, 22, 11)] = 0.01779821
        pgm_function13[(41, 23, 3)] = 0.0022
        pgm_function13[(41, 23, 4)] = 0.0778
        pgm_function13[(41, 23, 5)] = 0.2544
        pgm_function13[(41, 23, 6)] = 0.3611
        pgm_function13[(41, 23, 7)] = 0.26557316
        pgm_function13[(41, 23, 8)] = 0.11108906
        pgm_function13[(41, 23, 9)] = 0.02219782
        pgm_function13[(41, 24, 1)] = 0.001100111
        pgm_function13[(41, 24, 2)] = 0.059994016
        pgm_function13[(41, 24, 3)] = 0.2378
        pgm_function13[(41, 24, 4)] = 0.3567
        pgm_function13[(41, 24, 5)] = 0.28442828
        pgm_function13[(41, 24, 6)] = 0.1278
        pgm_function13[(41, 24, 7)] = 0.02780283
        pgm_function13[(41, 25, 0)] = 0.0589
        pgm_function13[(41, 25, 1)] = 0.2156
        pgm_function13[(41, 25, 2)] = 0.35106525
        pgm_function13[(41, 25, 3)] = 0.30003015
        pgm_function13[(41, 25, 4)] = 0.14668509
        pgm_function13[(41, 25, 5)] = 0.03440341
        pgm_function13[(41, 26, 0)] = 0.35216507
        pgm_function13[(41, 26, 1)] = 0.30996912
        pgm_function13[(41, 26, 2)] = 0.1656
        pgm_function13[(41, 26, 3)] = 0.041095932
        pgm_function13[(41, 26, 4)] = 0.0011
        pgm_function13[(41, 27, 0)] = 0.160016149
        pgm_function13[(41, 27, 1)] = 0.050005023
        pgm_function13[(41, 27, 2)] = 0.0022
        pgm_function13[(42, 0, 48)] = 0.0322
        pgm_function13[(42, 0, 49)] = 0.2211
        pgm_function13[(42, 0, 50)] = 0.35886432
        pgm_function13[(42, 0, 51)] = 0.2911
        pgm_function13[(42, 0, 52)] = 0.1456
        pgm_function13[(42, 0, 53)] = 0.0433
        pgm_function13[(42, 1, 46)] = 0.0222
        pgm_function13[(42, 1, 47)] = 0.1444
        pgm_function13[(42, 1, 48)] = 0.31
        pgm_function13[(42, 1, 49)] = 0.32
        pgm_function13[(42, 1, 50)] = 0.20667899
        pgm_function13[(42, 1, 51)] = 0.0733073
        pgm_function13[(42, 1, 52)] = 0.0133
        pgm_function13[(42, 2, 44)] = 0.0156
        pgm_function13[(42, 2, 45)] = 0.128913062
        pgm_function13[(42, 2, 46)] = 0.292229225
        pgm_function13[(42, 2, 47)] = 0.335532859
        pgm_function13[(42, 2, 48)] = 0.218878162
        pgm_function13[(42, 2, 49)] = 0.0856
        pgm_function13[(42, 2, 50)] = 0.0177982
        pgm_function13[(42, 3, 42)] = 0.010001006
        pgm_function13[(42, 3, 43)] = 0.1111
        pgm_function13[(42, 3, 44)] = 0.277772169
        pgm_function13[(42, 3, 45)] = 0.3422
        pgm_function13[(42, 3, 46)] = 0.232223088
        pgm_function13[(42, 3, 47)] = 0.0989
        pgm_function13[(42, 3, 48)] = 0.02220221
        pgm_function13[(42, 4, 40)] = 0.006700676
        pgm_function13[(42, 4, 41)] = 0.091109181
        pgm_function13[(42, 4, 42)] = 0.2633
        pgm_function13[(42, 4, 43)] = 0.342234202
        pgm_function13[(42, 4, 44)] = 0.25
        pgm_function13[(42, 4, 45)] = 0.11441109
        pgm_function13[(42, 4, 46)] = 0.0278
        pgm_function13[(42, 5, 38)] = 0.0044
        pgm_function13[(42, 5, 39)] = 0.076692363
        pgm_function13[(42, 5, 40)] = 0.243324265
        pgm_function13[(42, 5, 41)] = 0.34
        pgm_function13[(42, 5, 42)] = 0.2667
        pgm_function13[(42, 5, 43)] = 0.1267
        pgm_function13[(42, 5, 44)] = 0.0333
        pgm_function13[(42, 6, 36)] = 0.001099891
        pgm_function13[(42, 6, 37)] = 0.0656
        pgm_function13[(42, 6, 38)] = 0.2167
        pgm_function13[(42, 6, 39)] = 0.3433
        pgm_function13[(42, 6, 40)] = 0.2822
        pgm_function13[(42, 6, 41)] = 0.1444
        pgm_function13[(42, 6, 42)] = 0.03999604
        pgm_function13[(42, 6, 43)] = 0.001099891
        pgm_function13[(42, 7, 35)] = 0.0511
        pgm_function13[(42, 7, 36)] = 0.1989
        pgm_function13[(42, 7, 37)] = 0.3411
        pgm_function13[(42, 7, 38)] = 0.2955703
        pgm_function13[(42, 7, 39)] = 0.1589
        pgm_function13[(42, 7, 40)] = 0.047804833
        pgm_function13[(42, 7, 41)] = 0.0022
        pgm_function13[(42, 8, 33)] = 0.0356
        pgm_function13[(42, 8, 34)] = 0.1856
        pgm_function13[(42, 8, 35)] = 0.3267
        pgm_function13[(42, 8, 36)] = 0.31
        pgm_function13[(42, 8, 37)] = 0.17331712
        pgm_function13[(42, 8, 38)] = 0.0567
        pgm_function13[(42, 8, 39)] = 0.0044
        pgm_function13[(42, 9, 31)] = 0.02669731
        pgm_function13[(42, 9, 32)] = 0.16441612
        pgm_function13[(42, 9, 33)] = 0.31776819
        pgm_function13[(42, 9, 34)] = 0.3267
        pgm_function13[(42, 9, 35)] = 0.1867
        pgm_function13[(42, 9, 36)] = 0.0656
        pgm_function13[(42, 9, 37)] = 0.0067
        pgm_function13[(42, 10, 29)] = 0.02000201
        pgm_function13[(42, 10, 30)] = 0.1411
        pgm_function13[(42, 10, 31)] = 0.308869312
        pgm_function13[(42, 10, 32)] = 0.3344
        pgm_function13[(42, 10, 33)] = 0.203320085
        pgm_function13[(42, 10, 34)] = 0.075592423
        pgm_function13[(42, 10, 35)] = 0.01
        pgm_function13[(42, 11, 27)] = 0.0133
        pgm_function13[(42, 11, 28)] = 0.12
        pgm_function13[(42, 11, 29)] = 0.2989
        pgm_function13[(42, 11, 30)] = 0.34
        pgm_function13[(42, 11, 31)] = 0.2211
        pgm_function13[(42, 11, 32)] = 0.088908988
        pgm_function13[(42, 11, 33)] = 0.01330131
        pgm_function13[(42, 12, 25)] = 0.0078
        pgm_function13[(42, 12, 26)] = 0.1044
        pgm_function13[(42, 12, 27)] = 0.2767
        pgm_function13[(42, 12, 28)] = 0.3444
        pgm_function13[(42, 12, 29)] = 0.2389
        pgm_function13[(42, 12, 30)] = 0.10111003
        pgm_function13[(42, 12, 31)] = 0.01779821
        pgm_function13[(42, 13, 23)] = 0.004400442
        pgm_function13[(42, 13, 24)] = 0.09
        pgm_function13[(42, 13, 25)] = 0.255574097
        pgm_function13[(42, 13, 26)] = 0.3489
        pgm_function13[(42, 13, 27)] = 0.26002608
        pgm_function13[(42, 13, 28)] = 0.11111108
        pgm_function13[(42, 13, 29)] = 0.0244024
        pgm_function13[(42, 14, 21)] = 0.00220022
        pgm_function13[(42, 14, 22)] = 0.071092955
        pgm_function13[(42, 14, 23)] = 0.2411
        pgm_function13[(42, 14, 24)] = 0.34443417
        pgm_function13[(42, 14, 25)] = 0.2789
        pgm_function13[(42, 14, 26)] = 0.12441204
        pgm_function13[(42, 14, 27)] = 0.03
        pgm_function13[(42, 15, 19)] = 0.0011
        pgm_function13[(42, 15, 20)] = 0.0567
        pgm_function13[(42, 15, 21)] = 0.2233
        pgm_function13[(42, 15, 22)] = 0.34223444
        pgm_function13[(42, 15, 23)] = 0.29667045
        pgm_function13[(42, 15, 24)] = 0.14
        pgm_function13[(42, 15, 25)] = 0.0378
        pgm_function13[(42, 16, 18)] = 0.0444
        pgm_function13[(42, 16, 19)] = 0.2
        pgm_function13[(42, 16, 20)] = 0.34003431
        pgm_function13[(42, 16, 21)] = 0.3044
        pgm_function13[(42, 16, 22)] = 0.15781613
        pgm_function13[(42, 16, 23)] = 0.0456
        pgm_function13[(42, 16, 24)] = 0.001100111
        pgm_function13[(42, 17, 16)] = 0.03219684
        pgm_function13[(42, 17, 17)] = 0.1756
        pgm_function13[(42, 17, 18)] = 0.33666637
        pgm_function13[(42, 17, 19)] = 0.31443125
        pgm_function13[(42, 17, 20)] = 0.176682106
        pgm_function13[(42, 17, 21)] = 0.053305349
        pgm_function13[(42, 17, 22)] = 0.0033
        pgm_function13[(42, 18, 14)] = 0.02329772
        pgm_function13[(42, 18, 15)] = 0.15668414
        pgm_function13[(42, 18, 16)] = 0.3256
        pgm_function13[(42, 18, 17)] = 0.3311
        pgm_function13[(42, 18, 18)] = 0.189981072
        pgm_function13[(42, 18, 19)] = 0.062206183
        pgm_function13[(42, 18, 20)] = 0.005600566
        pgm_function13[(42, 19, 12)] = 0.0156
        pgm_function13[(42, 19, 13)] = 0.13558614
        pgm_function13[(42, 19, 14)] = 0.31
        pgm_function13[(42, 19, 15)] = 0.343266093
        pgm_function13[(42, 19, 16)] = 0.20782099
        pgm_function13[(42, 19, 17)] = 0.0722
        pgm_function13[(42, 19, 18)] = 0.01
        pgm_function13[(42, 20, 10)] = 0.01109891
        pgm_function13[(42, 20, 11)] = 0.1156
        pgm_function13[(42, 20, 12)] = 0.2967
        pgm_function13[(42, 20, 13)] = 0.34443405
        pgm_function13[(42, 20, 14)] = 0.2333
        pgm_function13[(42, 20, 15)] = 0.080008039
        pgm_function13[(42, 20, 16)] = 0.0133
        pgm_function13[(42, 21, 8)] = 0.006699333
        pgm_function13[(42, 21, 9)] = 0.0956
        pgm_function13[(42, 21, 10)] = 0.28002796
        pgm_function13[(42, 21, 11)] = 0.3467
        pgm_function13[(42, 21, 12)] = 0.2522
        pgm_function13[(42, 21, 13)] = 0.09220923
        pgm_function13[(42, 21, 14)] = 0.01779822
        pgm_function13[(42, 22, 6)] = 0.0033
        pgm_function13[(42, 22, 7)] = 0.081116184
        pgm_function13[(42, 22, 8)] = 0.256674175
        pgm_function13[(42, 22, 9)] = 0.3556
        pgm_function13[(42, 22, 10)] = 0.2678
        pgm_function13[(42, 22, 11)] = 0.10888907
        pgm_function13[(42, 22, 12)] = 0.02220222
        pgm_function13[(42, 23, 4)] = 0.0011
        pgm_function13[(42, 23, 5)] = 0.0656
        pgm_function13[(42, 23, 6)] = 0.2333
        pgm_function13[(42, 23, 7)] = 0.36326422
        pgm_function13[(42, 23, 8)] = 0.27887214
        pgm_function13[(42, 23, 9)] = 0.12558713
        pgm_function13[(42, 23, 10)] = 0.0278
        pgm_function13[(42, 24, 3)] = 0.05
        pgm_function13[(42, 24, 4)] = 0.2178
        pgm_function13[(42, 24, 5)] = 0.35333535
        pgm_function13[(42, 24, 6)] = 0.2933
        pgm_function13[(42, 24, 7)] = 0.14441417
        pgm_function13[(42, 24, 8)] = 0.03330331
        pgm_function13[(42, 25, 1)] = 0.0378
        pgm_function13[(42, 25, 2)] = 0.19778014
        pgm_function13[(42, 25, 3)] = 0.34443417
        pgm_function13[(42, 25, 4)] = 0.30996919
        pgm_function13[(42, 25, 5)] = 0.16111605
        pgm_function13[(42, 25, 6)] = 0.03999604
        pgm_function13[(42, 25, 7)] = 0.001099891
        pgm_function13[(42, 26, 0)] = 0.20218004
        pgm_function13[(42, 26, 1)] = 0.33996614
        pgm_function13[(42, 26, 2)] = 0.3211
        pgm_function13[(42, 26, 3)] = 0.178882138
        pgm_function13[(42, 26, 4)] = 0.05
        pgm_function13[(42, 26, 5)] = 0.002200438
        pgm_function13[(42, 27, 0)] = 0.332233309
        pgm_function13[(42, 27, 1)] = 0.19892009
        pgm_function13[(42, 27, 2)] = 0.06
        pgm_function13[(42, 27, 3)] = 0.0044
        pgm_function13[(42, 28, 0)] = 0.04889513
        pgm_function13[(42, 28, 1)] = 0.006700678
        pgm_function13[(43, 0, 49)] = 0.0256
        pgm_function13[(43, 0, 50)] = 0.19778018
        pgm_function13[(43, 0, 51)] = 0.3567
        pgm_function13[(43, 0, 52)] = 0.3078
        pgm_function13[(43, 0, 53)] = 0.1556
        pgm_function13[(43, 0, 54)] = 0.0522
        pgm_function13[(43, 1, 47)] = 0.0189
        pgm_function13[(43, 1, 48)] = 0.1289
        pgm_function13[(43, 1, 49)] = 0.3
        pgm_function13[(43, 1, 50)] = 0.32776698
        pgm_function13[(43, 1, 51)] = 0.21782199
        pgm_function13[(43, 1, 52)] = 0.0856
        pgm_function13[(43, 1, 53)] = 0.0178
        pgm_function13[(43, 2, 45)] = 0.011101105
        pgm_function13[(43, 2, 46)] = 0.114411088
        pgm_function13[(43, 2, 47)] = 0.279943882
        pgm_function13[(43, 2, 48)] = 0.338866251
        pgm_function13[(43, 2, 49)] = 0.2322
        pgm_function13[(43, 2, 50)] = 0.09669032
        pgm_function13[(43, 2, 51)] = 0.02219782
        pgm_function13[(43, 3, 43)] = 0.0067
        pgm_function13[(43, 3, 44)] = 0.096690359
        pgm_function13[(43, 3, 45)] = 0.2611
        pgm_function13[(43, 3, 46)] = 0.347835132
        pgm_function13[(43, 3, 47)] = 0.2422
        pgm_function13[(43, 3, 48)] = 0.11221107
        pgm_function13[(43, 3, 49)] = 0.02780283
        pgm_function13[(43, 4, 41)] = 0.004400444
        pgm_function13[(43, 4, 42)] = 0.08
        pgm_function13[(43, 4, 43)] = 0.244424144
        pgm_function13[(43, 4, 44)] = 0.3433
        pgm_function13[(43, 4, 45)] = 0.25782621
        pgm_function13[(43, 4, 46)] = 0.1256
        pgm_function13[(43, 4, 47)] = 0.03330332
        pgm_function13[(43, 5, 39)] = 0.002199782
        pgm_function13[(43, 5, 40)] = 0.065606672
        pgm_function13[(43, 5, 41)] = 0.23
        pgm_function13[(43, 5, 42)] = 0.3367
        pgm_function13[(43, 5, 43)] = 0.2789
        pgm_function13[(43, 5, 44)] = 0.14
        pgm_function13[(43, 5, 45)] = 0.04000403
        pgm_function13[(43, 5, 46)] = 0.0011
        pgm_function13[(43, 6, 37)] = 0.0011
        pgm_function13[(43, 6, 38)] = 0.0544
        pgm_function13[(43, 6, 39)] = 0.2056
        pgm_function13[(43, 6, 40)] = 0.3367
        pgm_function13[(43, 6, 41)] = 0.2922
        pgm_function13[(43, 6, 42)] = 0.15558416
        pgm_function13[(43, 6, 43)] = 0.047795229
        pgm_function13[(43, 6, 44)] = 0.002199782
        pgm_function13[(43, 7, 36)] = 0.0422
        pgm_function13[(43, 7, 37)] = 0.18
        pgm_function13[(43, 7, 38)] = 0.33216733
        pgm_function13[(43, 7, 39)] = 0.3056
        pgm_function13[(43, 7, 40)] = 0.171117118
        pgm_function13[(43, 7, 41)] = 0.0556
        pgm_function13[(43, 7, 42)] = 0.0044
        pgm_function13[(43, 8, 34)] = 0.0289
        pgm_function13[(43, 8, 35)] = 0.1667
        pgm_function13[(43, 8, 36)] = 0.3222
        pgm_function13[(43, 8, 37)] = 0.321132222
        pgm_function13[(43, 8, 38)] = 0.1844
        pgm_function13[(43, 8, 39)] = 0.0656
        pgm_function13[(43, 8, 40)] = 0.006700672
        pgm_function13[(43, 9, 32)] = 0.02000201
        pgm_function13[(43, 9, 33)] = 0.14778509
        pgm_function13[(43, 9, 34)] = 0.3044
        pgm_function13[(43, 9, 35)] = 0.3344
        pgm_function13[(43, 9, 36)] = 0.2
        pgm_function13[(43, 9, 37)] = 0.0744
        pgm_function13[(43, 9, 38)] = 0.009999005
        pgm_function13[(43, 10, 30)] = 0.0144
        pgm_function13[(43, 10, 31)] = 0.126687128
        pgm_function13[(43, 10, 32)] = 0.2956
        pgm_function13[(43, 10, 33)] = 0.342234144
        pgm_function13[(43, 10, 34)] = 0.217778065
        pgm_function13[(43, 10, 35)] = 0.0867
        pgm_function13[(43, 10, 36)] = 0.013301307
        pgm_function13[(43, 11, 28)] = 0.01
        pgm_function13[(43, 11, 29)] = 0.1044
        pgm_function13[(43, 11, 30)] = 0.2856
        pgm_function13[(43, 11, 31)] = 0.34
        pgm_function13[(43, 11, 32)] = 0.234423232
        pgm_function13[(43, 11, 33)] = 0.09890997
        pgm_function13[(43, 11, 34)] = 0.0178
        pgm_function13[(43, 12, 26)] = 0.0056
        pgm_function13[(43, 12, 27)] = 0.09
        pgm_function13[(43, 12, 28)] = 0.2644
        pgm_function13[(43, 12, 29)] = 0.3444
        pgm_function13[(43, 12, 30)] = 0.25332508
        pgm_function13[(43, 12, 31)] = 0.11108904
        pgm_function13[(43, 12, 32)] = 0.02440242
        pgm_function13[(43, 13, 24)] = 0.0022
        pgm_function13[(43, 13, 25)] = 0.076692329
        pgm_function13[(43, 13, 26)] = 0.2411
        pgm_function13[(43, 13, 27)] = 0.3478351
        pgm_function13[(43, 13, 28)] = 0.27112719
        pgm_function13[(43, 13, 29)] = 0.12441202
        pgm_function13[(43, 13, 30)] = 0.02999702
        pgm_function13[(43, 14, 22)] = 0.001099891
        pgm_function13[(43, 14, 23)] = 0.0611
        pgm_function13[(43, 14, 24)] = 0.22112211
        pgm_function13[(43, 14, 25)] = 0.3456
        pgm_function13[(43, 14, 26)] = 0.29112909
        pgm_function13[(43, 14, 27)] = 0.1378
        pgm_function13[(43, 14, 28)] = 0.0378
        pgm_function13[(43, 15, 21)] = 0.0456
        pgm_function13[(43, 15, 22)] = 0.20442027
        pgm_function13[(43, 15, 23)] = 0.3355665
        pgm_function13[(43, 15, 24)] = 0.3067
        pgm_function13[(43, 15, 25)] = 0.1533
        pgm_function13[(43, 15, 26)] = 0.0456
        pgm_function13[(43, 15, 27)] = 0.001100111
        pgm_function13[(43, 16, 19)] = 0.0344
        pgm_function13[(43, 16, 20)] = 0.18441817
        pgm_function13[(43, 16, 21)] = 0.3311
        pgm_function13[(43, 16, 22)] = 0.31443125
        pgm_function13[(43, 16, 23)] = 0.1711
        pgm_function13[(43, 16, 24)] = 0.053305337
        pgm_function13[(43, 16, 25)] = 0.0033
        pgm_function13[(43, 17, 17)] = 0.0267
        pgm_function13[(43, 17, 18)] = 0.15778417
        pgm_function13[(43, 17, 19)] = 0.33003326
        pgm_function13[(43, 17, 20)] = 0.323268194
        pgm_function13[(43, 17, 21)] = 0.190019175
        pgm_function13[(43, 17, 22)] = 0.0611
        pgm_function13[(43, 17, 23)] = 0.0056
        pgm_function13[(43, 18, 15)] = 0.01779822
        pgm_function13[(43, 18, 16)] = 0.1389
        pgm_function13[(43, 18, 17)] = 0.3144
        pgm_function13[(43, 18, 18)] = 0.336666128
        pgm_function13[(43, 18, 19)] = 0.206720944
        pgm_function13[(43, 18, 20)] = 0.071107173
        pgm_function13[(43, 18, 21)] = 0.01
        pgm_function13[(43, 19, 13)] = 0.01109891
        pgm_function13[(43, 19, 14)] = 0.1211
        pgm_function13[(43, 19, 15)] = 0.29557008
        pgm_function13[(43, 19, 16)] = 0.34783498
        pgm_function13[(43, 19, 17)] = 0.2244
        pgm_function13[(43, 19, 18)] = 0.08
        pgm_function13[(43, 19, 19)] = 0.0133
        pgm_function13[(43, 20, 11)] = 0.0067
        pgm_function13[(43, 20, 12)] = 0.1011
        pgm_function13[(43, 20, 13)] = 0.28112804
        pgm_function13[(43, 20, 14)] = 0.3478
        pgm_function13[(43, 20, 15)] = 0.24442412
        pgm_function13[(43, 20, 16)] = 0.0922
        pgm_function13[(43, 20, 17)] = 0.01780181
        pgm_function13[(43, 21, 9)] = 0.0044
        pgm_function13[(43, 21, 10)] = 0.08330829
        pgm_function13[(43, 21, 11)] = 0.2633
        pgm_function13[(43, 21, 12)] = 0.35
        pgm_function13[(43, 21, 13)] = 0.26562708
        pgm_function13[(43, 21, 14)] = 0.10558911
        pgm_function13[(43, 21, 15)] = 0.02220221
        pgm_function13[(43, 22, 7)] = 0.00220044
        pgm_function13[(43, 22, 8)] = 0.067793246
        pgm_function13[(43, 22, 9)] = 0.2411
        pgm_function13[(43, 22, 10)] = 0.3556
        pgm_function13[(43, 22, 11)] = 0.27887217
        pgm_function13[(43, 22, 12)] = 0.12111208
        pgm_function13[(43, 22, 13)] = 0.0278
        pgm_function13[(43, 23, 6)] = 0.0556
        pgm_function13[(43, 23, 7)] = 0.21557813
        pgm_function13[(43, 23, 8)] = 0.35776418
        pgm_function13[(43, 23, 9)] = 0.28887129
        pgm_function13[(43, 23, 10)] = 0.1422
        pgm_function13[(43, 23, 11)] = 0.0333
        pgm_function13[(43, 24, 4)] = 0.0411
        pgm_function13[(43, 24, 5)] = 0.1989202
        pgm_function13[(43, 24, 6)] = 0.35
        pgm_function13[(43, 24, 7)] = 0.30443037
        pgm_function13[(43, 24, 8)] = 0.16001605
        pgm_function13[(43, 24, 9)] = 0.04
        pgm_function13[(43, 24, 10)] = 0.001099891
        pgm_function13[(43, 25, 2)] = 0.02889712
        pgm_function13[(43, 25, 3)] = 0.18001809
        pgm_function13[(43, 25, 4)] = 0.3377662
        pgm_function13[(43, 25, 5)] = 0.3178321
        pgm_function13[(43, 25, 6)] = 0.17888218
        pgm_function13[(43, 25, 7)] = 0.046695322
        pgm_function13[(43, 25, 8)] = 0.0022
        pgm_function13[(43, 26, 0)] = 0.02559741
        pgm_function13[(43, 26, 1)] = 0.15558406
        pgm_function13[(43, 26, 2)] = 0.3267
        pgm_function13[(43, 26, 3)] = 0.335566258
        pgm_function13[(43, 26, 4)] = 0.1922
        pgm_function13[(43, 26, 5)] = 0.060011957
        pgm_function13[(43, 26, 6)] = 0.0044
        pgm_function13[(43, 27, 0)] = 0.324432302
        pgm_function13[(43, 27, 1)] = 0.341134154
        pgm_function13[(43, 27, 2)] = 0.21
        pgm_function13[(43, 27, 3)] = 0.07
        pgm_function13[(43, 27, 4)] = 0.006699332
        pgm_function13[(43, 28, 0)] = 0.21327913
        pgm_function13[(43, 28, 1)] = 0.081108192
        pgm_function13[(43, 28, 2)] = 0.01000101
        pgm_function13[(43, 29, 0)] = 0.006699331
        pgm_function13[(44, 0, 50)] = 0.01999802
        pgm_function13[(44, 0, 51)] = 0.1722
        pgm_function13[(44, 0, 52)] = 0.3422
        pgm_function13[(44, 0, 53)] = 0.3289
        pgm_function13[(44, 0, 54)] = 0.1656
        pgm_function13[(44, 0, 55)] = 0.062206222
        pgm_function13[(44, 1, 48)] = 0.0133
        pgm_function13[(44, 1, 49)] = 0.1156
        pgm_function13[(44, 1, 50)] = 0.28327198
        pgm_function13[(44, 1, 51)] = 0.33443299
        pgm_function13[(44, 1, 52)] = 0.2289
        pgm_function13[(44, 1, 53)] = 0.0956
        pgm_function13[(44, 1, 54)] = 0.0222
        pgm_function13[(44, 2, 46)] = 0.008900897
        pgm_function13[(44, 2, 47)] = 0.097780359
        pgm_function13[(44, 2, 48)] = 0.265573197
        pgm_function13[(44, 2, 49)] = 0.3411
        pgm_function13[(44, 2, 50)] = 0.24327605
        pgm_function13[(44, 2, 51)] = 0.10778911
        pgm_function13[(44, 2, 52)] = 0.0278
        pgm_function13[(44, 3, 44)] = 0.004399563
        pgm_function13[(44, 3, 45)] = 0.0856
        pgm_function13[(44, 3, 46)] = 0.243324092
        pgm_function13[(44, 3, 47)] = 0.35
        pgm_function13[(44, 3, 48)] = 0.25442515
        pgm_function13[(44, 3, 49)] = 0.12331211
        pgm_function13[(44, 3, 50)] = 0.0333
        pgm_function13[(44, 4, 42)] = 0.0022
        pgm_function13[(44, 4, 43)] = 0.071107142
        pgm_function13[(44, 4, 44)] = 0.2278
        pgm_function13[(44, 4, 45)] = 0.34443428
        pgm_function13[(44, 4, 46)] = 0.2711
        pgm_function13[(44, 4, 47)] = 0.13781407
        pgm_function13[(44, 4, 48)] = 0.04000402
        pgm_function13[(44, 4, 49)] = 0.001100111
        pgm_function13[(44, 5, 40)] = 0.001100111
        pgm_function13[(44, 5, 41)] = 0.0544
        pgm_function13[(44, 5, 42)] = 0.2133
        pgm_function13[(44, 5, 43)] = 0.3344
        pgm_function13[(44, 5, 44)] = 0.29
        pgm_function13[(44, 5, 45)] = 0.15331511
        pgm_function13[(44, 5, 46)] = 0.0478
        pgm_function13[(44, 5, 47)] = 0.0022
        pgm_function13[(44, 6, 39)] = 0.0444
        pgm_function13[(44, 6, 40)] = 0.19
        pgm_function13[(44, 6, 41)] = 0.3256
        pgm_function13[(44, 6, 42)] = 0.30556931
        pgm_function13[(44, 6, 43)] = 0.165583101
        pgm_function13[(44, 6, 44)] = 0.055594457
        pgm_function13[(44, 6, 45)] = 0.0044
        pgm_function13[(44, 7, 37)] = 0.0344
        pgm_function13[(44, 7, 38)] = 0.16668317
        pgm_function13[(44, 7, 39)] = 0.3233
        pgm_function13[(44, 7, 40)] = 0.314431217
        pgm_function13[(44, 7, 41)] = 0.1822
        pgm_function13[(44, 7, 42)] = 0.0656
        pgm_function13[(44, 7, 43)] = 0.006700675
        pgm_function13[(44, 8, 35)] = 0.0233
        pgm_function13[(44, 8, 36)] = 0.1489
        pgm_function13[(44, 8, 37)] = 0.311131215
        pgm_function13[(44, 8, 38)] = 0.3278
        pgm_function13[(44, 8, 39)] = 0.1978
        pgm_function13[(44, 8, 40)] = 0.074407422
        pgm_function13[(44, 8, 41)] = 0.00999901
        pgm_function13[(44, 9, 33)] = 0.01559841
        pgm_function13[(44, 9, 34)] = 0.1322
        pgm_function13[(44, 9, 35)] = 0.2944
        pgm_function13[(44, 9, 36)] = 0.3411
        pgm_function13[(44, 9, 37)] = 0.2156
        pgm_function13[(44, 9, 38)] = 0.085591445
        pgm_function13[(44, 9, 39)] = 0.0133
        pgm_function13[(44, 10, 31)] = 0.00999901
        pgm_function13[(44, 10, 32)] = 0.1133
        pgm_function13[(44, 10, 33)] = 0.278928117
        pgm_function13[(44, 10, 34)] = 0.345565104
        pgm_function13[(44, 10, 35)] = 0.2311
        pgm_function13[(44, 10, 36)] = 0.096709747
        pgm_function13[(44, 10, 37)] = 0.0178
        pgm_function13[(44, 11, 29)] = 0.0067
        pgm_function13[(44, 11, 30)] = 0.0911
        pgm_function13[(44, 11, 31)] = 0.27
        pgm_function13[(44, 11, 32)] = 0.34333434
        pgm_function13[(44, 11, 33)] = 0.24892517
        pgm_function13[(44, 11, 34)] = 0.1089
        pgm_function13[(44, 11, 35)] = 0.0244
        pgm_function13[(44, 12, 27)] = 0.0044
        pgm_function13[(44, 12, 28)] = 0.0767
        pgm_function13[(44, 12, 29)] = 0.2511
        pgm_function13[(44, 12, 30)] = 0.3411341
        pgm_function13[(44, 12, 31)] = 0.26887311
        pgm_function13[(44, 12, 32)] = 0.1211121
        pgm_function13[(44, 12, 33)] = 0.03000303
        pgm_function13[(44, 13, 25)] = 0.00109989
        pgm_function13[(44, 13, 26)] = 0.0656
        pgm_function13[(44, 13, 27)] = 0.22332207
        pgm_function13[(44, 13, 28)] = 0.34443424
        pgm_function13[(44, 13, 29)] = 0.28562906
        pgm_function13[(44, 13, 30)] = 0.1366861
        pgm_function13[(44, 13, 31)] = 0.03780385
        pgm_function13[(44, 14, 24)] = 0.05220523
        pgm_function13[(44, 14, 25)] = 0.2033
        pgm_function13[(44, 14, 26)] = 0.3400341
        pgm_function13[(44, 14, 27)] = 0.3
        pgm_function13[(44, 14, 28)] = 0.1522
        pgm_function13[(44, 14, 29)] = 0.0456
        pgm_function13[(44, 14, 30)] = 0.0011
        pgm_function13[(44, 15, 22)] = 0.03780385
        pgm_function13[(44, 15, 23)] = 0.18668128
        pgm_function13[(44, 15, 24)] = 0.3311
        pgm_function13[(44, 15, 25)] = 0.3133
        pgm_function13[(44, 15, 26)] = 0.1678
        pgm_function13[(44, 15, 27)] = 0.053305331
        pgm_function13[(44, 15, 28)] = 0.002199782
        pgm_function13[(44, 16, 20)] = 0.02670272
        pgm_function13[(44, 16, 21)] = 0.1678
        pgm_function13[(44, 16, 22)] = 0.32443226
        pgm_function13[(44, 16, 23)] = 0.3267
        pgm_function13[(44, 16, 24)] = 0.184418129
        pgm_function13[(44, 16, 25)] = 0.0611
        pgm_function13[(44, 16, 26)] = 0.0056
        pgm_function13[(44, 17, 18)] = 0.01999802
        pgm_function13[(44, 17, 19)] = 0.14221411
        pgm_function13[(44, 17, 20)] = 0.31666819
        pgm_function13[(44, 17, 21)] = 0.332233306
        pgm_function13[(44, 17, 22)] = 0.2056
        pgm_function13[(44, 17, 23)] = 0.0689
        pgm_function13[(44, 17, 24)] = 0.0089
        pgm_function13[(44, 18, 16)] = 0.0133
        pgm_function13[(44, 18, 17)] = 0.1211
        pgm_function13[(44, 18, 18)] = 0.303270115
        pgm_function13[(44, 18, 19)] = 0.340033908
        pgm_function13[(44, 18, 20)] = 0.222222227
        pgm_function13[(44, 18, 21)] = 0.0778
        pgm_function13[(44, 18, 22)] = 0.01330131
        pgm_function13[(44, 19, 14)] = 0.0078
        pgm_function13[(44, 19, 15)] = 0.105589029
        pgm_function13[(44, 19, 16)] = 0.28332798
        pgm_function13[(44, 19, 17)] = 0.3489
        pgm_function13[(44, 19, 18)] = 0.2389
        pgm_function13[(44, 19, 19)] = 0.0911
        pgm_function13[(44, 19, 20)] = 0.01779821
        pgm_function13[(44, 20, 12)] = 0.0044
        pgm_function13[(44, 20, 13)] = 0.09000901
        pgm_function13[(44, 20, 14)] = 0.2633
        pgm_function13[(44, 20, 15)] = 0.354435174
        pgm_function13[(44, 20, 16)] = 0.2567
        pgm_function13[(44, 20, 17)] = 0.10441008
        pgm_function13[(44, 20, 18)] = 0.0222
        pgm_function13[(44, 21, 10)] = 0.00220022
        pgm_function13[(44, 21, 11)] = 0.0722
        pgm_function13[(44, 21, 12)] = 0.2456
        pgm_function13[(44, 21, 13)] = 0.35223511
        pgm_function13[(44, 21, 14)] = 0.27557228
        pgm_function13[(44, 21, 15)] = 0.12111206
        pgm_function13[(44, 21, 16)] = 0.02780284
        pgm_function13[(44, 22, 8)] = 0.001099891
        pgm_function13[(44, 22, 9)] = 0.0578
        pgm_function13[(44, 22, 10)] = 0.2222
        pgm_function13[(44, 22, 11)] = 0.34886521
        pgm_function13[(44, 22, 12)] = 0.2922292
        pgm_function13[(44, 22, 13)] = 0.1356
        pgm_function13[(44, 22, 14)] = 0.03330333
        pgm_function13[(44, 23, 7)] = 0.04559543
        pgm_function13[(44, 23, 8)] = 0.1977801
        pgm_function13[(44, 23, 9)] = 0.34996535
        pgm_function13[(44, 23, 10)] = 0.3011
        pgm_function13[(44, 23, 11)] = 0.1567
        pgm_function13[(44, 23, 12)] = 0.04
        pgm_function13[(44, 23, 13)] = 0.0011
        pgm_function13[(44, 24, 5)] = 0.03220323
        pgm_function13[(44, 24, 6)] = 0.1811
        pgm_function13[(44, 24, 7)] = 0.34223441
        pgm_function13[(44, 24, 8)] = 0.31223109
        pgm_function13[(44, 24, 9)] = 0.1767
        pgm_function13[(44, 24, 10)] = 0.046695322
        pgm_function13[(44, 24, 11)] = 0.002200221
        pgm_function13[(44, 25, 3)] = 0.02330231
        pgm_function13[(44, 25, 4)] = 0.1599841
        pgm_function13[(44, 25, 5)] = 0.3300331
        pgm_function13[(44, 25, 6)] = 0.32886733
        pgm_function13[(44, 25, 7)] = 0.193281093
        pgm_function13[(44, 25, 8)] = 0.0578
        pgm_function13[(44, 25, 9)] = 0.0044
        pgm_function13[(44, 26, 1)] = 0.01559841
        pgm_function13[(44, 26, 2)] = 0.1411
        pgm_function13[(44, 26, 3)] = 0.31216924
        pgm_function13[(44, 26, 4)] = 0.3444
        pgm_function13[(44, 26, 5)] = 0.203340854
        pgm_function13[(44, 26, 6)] = 0.0689
        pgm_function13[(44, 26, 7)] = 0.0067
        pgm_function13[(44, 27, 0)] = 0.142214132
        pgm_function13[(44, 27, 1)] = 0.300030135
        pgm_function13[(44, 27, 2)] = 0.35
        pgm_function13[(44, 27, 3)] = 0.2233
        pgm_function13[(44, 27, 4)] = 0.079992022
        pgm_function13[(44, 27, 5)] = 0.010001
        pgm_function13[(44, 28, 0)] = 0.355564217
        pgm_function13[(44, 28, 1)] = 0.244424276
        pgm_function13[(44, 28, 2)] = 0.09330935
        pgm_function13[(44, 28, 3)] = 0.0133
        pgm_function13[(44, 29, 0)] = 0.086691315
        pgm_function13[(44, 29, 1)] = 0.0178
        pgm_function13[(45, 0, 51)] = 0.0144
        pgm_function13[(45, 0, 52)] = 0.16
        pgm_function13[(45, 0, 53)] = 0.3244
        pgm_function13[(45, 0, 54)] = 0.3444
        pgm_function13[(45, 0, 55)] = 0.181118065
        pgm_function13[(45, 0, 56)] = 0.074407428
        pgm_function13[(45, 1, 49)] = 0.01
        pgm_function13[(45, 1, 50)] = 0.10328999
        pgm_function13[(45, 1, 51)] = 0.26672699
        pgm_function13[(45, 1, 52)] = 0.3378
        pgm_function13[(45, 1, 53)] = 0.24
        pgm_function13[(45, 1, 54)] = 0.1067
        pgm_function13[(45, 1, 55)] = 0.0278
        pgm_function13[(45, 2, 47)] = 0.006698657
        pgm_function13[(45, 2, 48)] = 0.086691364
        pgm_function13[(45, 2, 49)] = 0.25
        pgm_function13[(45, 2, 50)] = 0.33886607
        pgm_function13[(45, 2, 51)] = 0.25777426
        pgm_function13[(45, 2, 52)] = 0.12
        pgm_function13[(45, 2, 53)] = 0.0333
        pgm_function13[(45, 3, 45)] = 0.0033
        pgm_function13[(45, 3, 46)] = 0.073307328
        pgm_function13[(45, 3, 47)] = 0.2278
        pgm_function13[(45, 3, 48)] = 0.34223421
        pgm_function13[(45, 3, 49)] = 0.27002724
        pgm_function13[(45, 3, 50)] = 0.1356
        pgm_function13[(45, 3, 51)] = 0.0389
        pgm_function13[(45, 3, 52)] = 0.0011
        pgm_function13[(45, 4, 43)] = 0.001100111
        pgm_function13[(45, 4, 44)] = 0.06
        pgm_function13[(45, 4, 45)] = 0.21112117
        pgm_function13[(45, 4, 46)] = 0.34
        pgm_function13[(45, 4, 47)] = 0.28332814
        pgm_function13[(45, 4, 48)] = 0.15221509
        pgm_function13[(45, 4, 49)] = 0.04670476
        pgm_function13[(45, 4, 50)] = 0.00220022
        pgm_function13[(45, 5, 42)] = 0.0467
        pgm_function13[(45, 5, 43)] = 0.1944
        pgm_function13[(45, 5, 44)] = 0.3278
        pgm_function13[(45, 5, 45)] = 0.29893021
        pgm_function13[(45, 5, 46)] = 0.1644
        pgm_function13[(45, 5, 47)] = 0.0544
        pgm_function13[(45, 5, 48)] = 0.004400442
        pgm_function13[(45, 6, 40)] = 0.0344
        pgm_function13[(45, 6, 41)] = 0.1778
        pgm_function13[(45, 6, 42)] = 0.31776832
        pgm_function13[(45, 6, 43)] = 0.316668193
        pgm_function13[(45, 6, 44)] = 0.17668218
        pgm_function13[(45, 6, 45)] = 0.0656
        pgm_function13[(45, 6, 46)] = 0.0067
        pgm_function13[(45, 7, 38)] = 0.02669733
        pgm_function13[(45, 7, 39)] = 0.1522
        pgm_function13[(45, 7, 40)] = 0.313331216
        pgm_function13[(45, 7, 41)] = 0.3256
        pgm_function13[(45, 7, 42)] = 0.1933
        pgm_function13[(45, 7, 43)] = 0.074407451
        pgm_function13[(45, 7, 44)] = 0.010000999
        pgm_function13[(45, 8, 36)] = 0.0178
        pgm_function13[(45, 8, 37)] = 0.13111309
        pgm_function13[(45, 8, 38)] = 0.3011
        pgm_function13[(45, 8, 39)] = 0.3322
        pgm_function13[(45, 8, 40)] = 0.211121061
        pgm_function13[(45, 8, 41)] = 0.085591487
        pgm_function13[(45, 8, 42)] = 0.0133
        pgm_function13[(45, 9, 34)] = 0.0111
        pgm_function13[(45, 9, 35)] = 0.1167
        pgm_function13[(45, 9, 36)] = 0.2811
        pgm_function13[(45, 9, 37)] = 0.34
        pgm_function13[(45, 9, 38)] = 0.22997712
        pgm_function13[(45, 9, 39)] = 0.0956
        pgm_function13[(45, 9, 40)] = 0.01779821
        pgm_function13[(45, 10, 32)] = 0.0067
        pgm_function13[(45, 10, 33)] = 0.100010042
        pgm_function13[(45, 10, 34)] = 0.264374079
        pgm_function13[(45, 10, 35)] = 0.3478
        pgm_function13[(45, 10, 36)] = 0.24442412
        pgm_function13[(45, 10, 37)] = 0.1067
        pgm_function13[(45, 10, 38)] = 0.0233
        pgm_function13[(45, 11, 30)] = 0.0044
        pgm_function13[(45, 11, 31)] = 0.0811
        pgm_function13[(45, 11, 32)] = 0.25222525
        pgm_function13[(45, 11, 33)] = 0.34443424
        pgm_function13[(45, 11, 34)] = 0.2656
        pgm_function13[(45, 11, 35)] = 0.1189
        pgm_function13[(45, 11, 36)] = 0.03
        pgm_function13[(45, 12, 28)] = 0.0022
        pgm_function13[(45, 12, 29)] = 0.0656
        pgm_function13[(45, 12, 30)] = 0.23672407
        pgm_function13[(45, 12, 31)] = 0.33776614
        pgm_function13[(45, 12, 32)] = 0.28332823
        pgm_function13[(45, 12, 33)] = 0.13331313
        pgm_function13[(45, 12, 34)] = 0.0367
        pgm_function13[(45, 13, 26)] = 0.0011
        pgm_function13[(45, 13, 27)] = 0.05440542
        pgm_function13[(45, 13, 28)] = 0.21002115
        pgm_function13[(45, 13, 29)] = 0.33443307
        pgm_function13[(45, 13, 30)] = 0.29557021
        pgm_function13[(45, 13, 31)] = 0.15001518
        pgm_function13[(45, 13, 32)] = 0.04559086
        pgm_function13[(45, 13, 33)] = 0.0011
        pgm_function13[(45, 14, 25)] = 0.0422
        pgm_function13[(45, 14, 26)] = 0.18671906
        pgm_function13[(45, 14, 27)] = 0.3344
        pgm_function13[(45, 14, 28)] = 0.3067
        pgm_function13[(45, 14, 29)] = 0.1656
        pgm_function13[(45, 14, 30)] = 0.0533
        pgm_function13[(45, 14, 31)] = 0.002200222
        pgm_function13[(45, 15, 23)] = 0.03109695
        pgm_function13[(45, 15, 24)] = 0.1678
        pgm_function13[(45, 15, 25)] = 0.3278
        pgm_function13[(45, 15, 26)] = 0.32
        pgm_function13[(45, 15, 27)] = 0.182218108
        pgm_function13[(45, 15, 28)] = 0.062193868
        pgm_function13[(45, 15, 29)] = 0.0056
        pgm_function13[(45, 16, 21)] = 0.02
        pgm_function13[(45, 16, 22)] = 0.15111512
        pgm_function13[(45, 16, 23)] = 0.3111
        pgm_function13[(45, 16, 24)] = 0.334433234
        pgm_function13[(45, 16, 25)] = 0.2
        pgm_function13[(45, 16, 26)] = 0.0689
        pgm_function13[(45, 16, 27)] = 0.0089
        pgm_function13[(45, 17, 19)] = 0.01440141
        pgm_function13[(45, 17, 20)] = 0.127787077
        pgm_function13[(45, 17, 21)] = 0.302230278
        pgm_function13[(45, 17, 22)] = 0.3389
        pgm_function13[(45, 17, 23)] = 0.22
        pgm_function13[(45, 17, 24)] = 0.0778
        pgm_function13[(45, 17, 25)] = 0.0133
        pgm_function13[(45, 18, 17)] = 0.01
        pgm_function13[(45, 18, 18)] = 0.106689041
        pgm_function13[(45, 18, 19)] = 0.290028922
        pgm_function13[(45, 18, 20)] = 0.34333435
        pgm_function13[(45, 18, 21)] = 0.2389
        pgm_function13[(45, 18, 22)] = 0.08780885
        pgm_function13[(45, 18, 23)] = 0.0178
        pgm_function13[(45, 19, 15)] = 0.005599442
        pgm_function13[(45, 19, 16)] = 0.09000899
        pgm_function13[(45, 19, 17)] = 0.27
        pgm_function13[(45, 19, 18)] = 0.35
        pgm_function13[(45, 19, 19)] = 0.2533
        pgm_function13[(45, 19, 20)] = 0.10219004
        pgm_function13[(45, 19, 21)] = 0.0222
        pgm_function13[(45, 20, 13)] = 0.00220022
        pgm_function13[(45, 20, 14)] = 0.0767
        pgm_function13[(45, 20, 15)] = 0.24562512
        pgm_function13[(45, 20, 16)] = 0.3556
        pgm_function13[(45, 20, 17)] = 0.26672721
        pgm_function13[(45, 20, 18)] = 0.1211
        pgm_function13[(45, 20, 19)] = 0.0278
        pgm_function13[(45, 21, 11)] = 0.0011
        pgm_function13[(45, 21, 12)] = 0.0622
        pgm_function13[(45, 21, 13)] = 0.22442207
        pgm_function13[(45, 21, 14)] = 0.34996535
        pgm_function13[(45, 21, 15)] = 0.28442814
        pgm_function13[(45, 21, 16)] = 0.1344132
        pgm_function13[(45, 21, 17)] = 0.03330332
        pgm_function13[(45, 22, 10)] = 0.0478
        pgm_function13[(45, 22, 11)] = 0.20777912
        pgm_function13[(45, 22, 12)] = 0.34333424
        pgm_function13[(45, 22, 13)] = 0.3022
        pgm_function13[(45, 22, 14)] = 0.15221512
        pgm_function13[(45, 22, 15)] = 0.04
        pgm_function13[(45, 22, 16)] = 0.0011
        pgm_function13[(45, 23, 8)] = 0.03669632
        pgm_function13[(45, 23, 9)] = 0.18558119
        pgm_function13[(45, 23, 10)] = 0.34
        pgm_function13[(45, 23, 11)] = 0.3122
        pgm_function13[(45, 23, 12)] = 0.1733
        pgm_function13[(45, 23, 13)] = 0.0467
        pgm_function13[(45, 23, 14)] = 0.0022
        pgm_function13[(45, 24, 6)] = 0.0256
        pgm_function13[(45, 24, 7)] = 0.16111619
        pgm_function13[(45, 24, 8)] = 0.3333331
        pgm_function13[(45, 24, 9)] = 0.3222
        pgm_function13[(45, 24, 10)] = 0.189981091
        pgm_function13[(45, 24, 11)] = 0.056705736
        pgm_function13[(45, 24, 12)] = 0.004400442
        pgm_function13[(45, 25, 4)] = 0.01779821
        pgm_function13[(45, 25, 5)] = 0.14331404
        pgm_function13[(45, 25, 6)] = 0.31666832
        pgm_function13[(45, 25, 7)] = 0.336666162
        pgm_function13[(45, 25, 8)] = 0.2056
        pgm_function13[(45, 25, 9)] = 0.0667
        pgm_function13[(45, 25, 10)] = 0.0067
        pgm_function13[(45, 26, 2)] = 0.0111
        pgm_function13[(45, 26, 3)] = 0.125587097
        pgm_function13[(45, 26, 4)] = 0.2967
        pgm_function13[(45, 26, 5)] = 0.353370746
        pgm_function13[(45, 26, 6)] = 0.2178
        pgm_function13[(45, 26, 7)] = 0.0778
        pgm_function13[(45, 26, 8)] = 0.01
        pgm_function13[(45, 27, 0)] = 0.006700676
        pgm_function13[(45, 27, 1)] = 0.104410047
        pgm_function13[(45, 27, 2)] = 0.2856
        pgm_function13[(45, 27, 3)] = 0.3567
        pgm_function13[(45, 27, 4)] = 0.237776064
        pgm_function13[(45, 27, 5)] = 0.09220924
        pgm_function13[(45, 27, 6)] = 0.0133013
        pgm_function13[(45, 28, 0)] = 0.29557018
        pgm_function13[(45, 28, 1)] = 0.353335399
        pgm_function13[(45, 28, 2)] = 0.25892613
        pgm_function13[(45, 28, 3)] = 0.1056
        pgm_function13[(45, 28, 4)] = 0.0178
        pgm_function13[(45, 29, 0)] = 0.258874044
        pgm_function13[(45, 29, 1)] = 0.1211
        pgm_function13[(45, 29, 2)] = 0.02330231
        pgm_function13[(45, 30, 0)] = 0.0233
        pgm_function13[(46, 0, 52)] = 0.01
        pgm_function13[(46, 0, 53)] = 0.1411
        pgm_function13[(46, 0, 54)] = 0.3122
        pgm_function13[(46, 0, 55)] = 0.357836129
        pgm_function13[(46, 0, 56)] = 0.188919072
        pgm_function13[(46, 0, 57)] = 0.08559143
        pgm_function13[(46, 1, 50)] = 0.00669933
        pgm_function13[(46, 1, 51)] = 0.0933093
        pgm_function13[(46, 1, 52)] = 0.25
        pgm_function13[(46, 1, 53)] = 0.3389
        pgm_function13[(46, 1, 54)] = 0.2522
        pgm_function13[(46, 1, 55)] = 0.12
        pgm_function13[(46, 1, 56)] = 0.03330332
        pgm_function13[(46, 2, 48)] = 0.004399563
        pgm_function13[(46, 2, 49)] = 0.0756
        pgm_function13[(46, 2, 50)] = 0.23667605
        pgm_function13[(46, 2, 51)] = 0.33666634
        pgm_function13[(46, 2, 52)] = 0.27
        pgm_function13[(46, 2, 53)] = 0.1322
        pgm_function13[(46, 2, 54)] = 0.0389
        pgm_function13[(46, 2, 55)] = 0.001099891
        pgm_function13[(46, 3, 46)] = 0.002200221
        pgm_function13[(46, 3, 47)] = 0.0622
        pgm_function13[(46, 3, 48)] = 0.21672213
        pgm_function13[(46, 3, 49)] = 0.3344333
        pgm_function13[(46, 3, 50)] = 0.2811
        pgm_function13[(46, 3, 51)] = 0.15
        pgm_function13[(46, 3, 52)] = 0.0467
        pgm_function13[(46, 3, 53)] = 0.002200221
        pgm_function13[(46, 4, 45)] = 0.05000504
        pgm_function13[(46, 4, 46)] = 0.1944
        pgm_function13[(46, 4, 47)] = 0.33223317
        pgm_function13[(46, 4, 48)] = 0.29332918
        pgm_function13[(46, 4, 49)] = 0.163316211
        pgm_function13[(46, 4, 50)] = 0.0544054
        pgm_function13[(46, 4, 51)] = 0.0044
        pgm_function13[(46, 5, 43)] = 0.0378
        pgm_function13[(46, 5, 44)] = 0.1789
        pgm_function13[(46, 5, 45)] = 0.32333223
        pgm_function13[(46, 5, 46)] = 0.3067
        pgm_function13[(46, 5, 47)] = 0.1778
        pgm_function13[(46, 5, 48)] = 0.062206222
        pgm_function13[(46, 5, 49)] = 0.0067
        pgm_function13[(46, 6, 41)] = 0.0267
        pgm_function13[(46, 6, 42)] = 0.16108416
        pgm_function13[(46, 6, 43)] = 0.308869188
        pgm_function13[(46, 6, 44)] = 0.325567332
        pgm_function13[(46, 6, 45)] = 0.1889
        pgm_function13[(46, 6, 46)] = 0.0733
        pgm_function13[(46, 6, 47)] = 0.010001006
        pgm_function13[(46, 7, 39)] = 0.02
        pgm_function13[(46, 7, 40)] = 0.137814095
        pgm_function13[(46, 7, 41)] = 0.3
        pgm_function13[(46, 7, 42)] = 0.3322
        pgm_function13[(46, 7, 43)] = 0.204420141
        pgm_function13[(46, 7, 44)] = 0.084408388
        pgm_function13[(46, 7, 45)] = 0.0133
        pgm_function13[(46, 8, 37)] = 0.01440141
        pgm_function13[(46, 8, 38)] = 0.1178
        pgm_function13[(46, 8, 39)] = 0.2889
        pgm_function13[(46, 8, 40)] = 0.334433097
        pgm_function13[(46, 8, 41)] = 0.22557723
        pgm_function13[(46, 8, 42)] = 0.0956
        pgm_function13[(46, 8, 43)] = 0.01779822
        pgm_function13[(46, 9, 35)] = 0.0089
        pgm_function13[(46, 9, 36)] = 0.1011
        pgm_function13[(46, 9, 37)] = 0.27
        pgm_function13[(46, 9, 38)] = 0.337766176
        pgm_function13[(46, 9, 39)] = 0.2433
        pgm_function13[(46, 9, 40)] = 0.10668905
        pgm_function13[(46, 9, 41)] = 0.0233
        pgm_function13[(46, 10, 33)] = 0.004400442
        pgm_function13[(46, 10, 34)] = 0.086691326
        pgm_function13[(46, 10, 35)] = 0.2478
        pgm_function13[(46, 10, 36)] = 0.34783517
        pgm_function13[(46, 10, 37)] = 0.2611
        pgm_function13[(46, 10, 38)] = 0.1189
        pgm_function13[(46, 10, 39)] = 0.03
        pgm_function13[(46, 11, 31)] = 0.0022
        pgm_function13[(46, 11, 32)] = 0.070007069
        pgm_function13[(46, 11, 33)] = 0.23332316
        pgm_function13[(46, 11, 34)] = 0.3422
        pgm_function13[(46, 11, 35)] = 0.2778
        pgm_function13[(46, 11, 36)] = 0.1311
        pgm_function13[(46, 11, 37)] = 0.03669631
        pgm_function13[(46, 12, 29)] = 0.0011
        pgm_function13[(46, 12, 30)] = 0.05440542
        pgm_function13[(46, 12, 31)] = 0.21887809
        pgm_function13[(46, 12, 32)] = 0.33333327
        pgm_function13[(46, 12, 33)] = 0.29332929
        pgm_function13[(46, 12, 34)] = 0.1467
        pgm_function13[(46, 12, 35)] = 0.0444
        pgm_function13[(46, 12, 36)] = 0.00110022
        pgm_function13[(46, 13, 28)] = 0.04440443
        pgm_function13[(46, 13, 29)] = 0.19672004
        pgm_function13[(46, 13, 30)] = 0.33106723
        pgm_function13[(46, 13, 31)] = 0.30443037
        pgm_function13[(46, 13, 32)] = 0.16106787
        pgm_function13[(46, 13, 33)] = 0.0522
        pgm_function13[(46, 13, 34)] = 0.0022
        pgm_function13[(46, 14, 26)] = 0.03330331
        pgm_function13[(46, 14, 27)] = 0.1711
        pgm_function13[(46, 14, 28)] = 0.33
        pgm_function13[(46, 14, 29)] = 0.3144
        pgm_function13[(46, 14, 30)] = 0.1789
        pgm_function13[(46, 14, 31)] = 0.062206257
        pgm_function13[(46, 14, 32)] = 0.005599444
        pgm_function13[(46, 15, 24)] = 0.0244
        pgm_function13[(46, 15, 25)] = 0.1489
        pgm_function13[(46, 15, 26)] = 0.32
        pgm_function13[(46, 15, 27)] = 0.324432191
        pgm_function13[(46, 15, 28)] = 0.197780216
        pgm_function13[(46, 15, 29)] = 0.0689
        pgm_function13[(46, 15, 30)] = 0.0089
        pgm_function13[(46, 16, 22)] = 0.01440141
        pgm_function13[(46, 16, 23)] = 0.1333
        pgm_function13[(46, 16, 24)] = 0.30003021
        pgm_function13[(46, 16, 25)] = 0.3378
        pgm_function13[(46, 16, 26)] = 0.2144
        pgm_function13[(46, 16, 27)] = 0.0778
        pgm_function13[(46, 16, 28)] = 0.0133
        pgm_function13[(46, 17, 20)] = 0.009999006
        pgm_function13[(46, 17, 21)] = 0.114411105
        pgm_function13[(46, 17, 22)] = 0.2856
        pgm_function13[(46, 17, 23)] = 0.3444
        pgm_function13[(46, 17, 24)] = 0.2344
        pgm_function13[(46, 17, 25)] = 0.0867
        pgm_function13[(46, 17, 26)] = 0.0178
        pgm_function13[(46, 18, 18)] = 0.006699333
        pgm_function13[(46, 18, 19)] = 0.093309275
        pgm_function13[(46, 18, 20)] = 0.27442728
        pgm_function13[(46, 18, 21)] = 0.3478
        pgm_function13[(46, 18, 22)] = 0.25222515
        pgm_function13[(46, 18, 23)] = 0.1
        pgm_function13[(46, 18, 24)] = 0.0222
        pgm_function13[(46, 19, 16)] = 0.00440044
        pgm_function13[(46, 19, 17)] = 0.0767
        pgm_function13[(46, 19, 18)] = 0.2544
        pgm_function13[(46, 19, 19)] = 0.3489
        pgm_function13[(46, 19, 20)] = 0.26557311
        pgm_function13[(46, 19, 21)] = 0.1167
        pgm_function13[(46, 19, 22)] = 0.0278
        pgm_function13[(46, 20, 14)] = 0.0011
        pgm_function13[(46, 20, 15)] = 0.064406432
        pgm_function13[(46, 20, 16)] = 0.2278
        pgm_function13[(46, 20, 17)] = 0.35443528
        pgm_function13[(46, 20, 18)] = 0.2767
        pgm_function13[(46, 20, 19)] = 0.1333
        pgm_function13[(46, 20, 20)] = 0.0333
        pgm_function13[(46, 21, 13)] = 0.05220522
        pgm_function13[(46, 21, 14)] = 0.20887921
        pgm_function13[(46, 21, 15)] = 0.34783517
        pgm_function13[(46, 21, 16)] = 0.29332944
        pgm_function13[(46, 21, 17)] = 0.15111511
        pgm_function13[(46, 21, 18)] = 0.04
        pgm_function13[(46, 21, 19)] = 0.0011
        pgm_function13[(46, 22, 11)] = 0.03779622
        pgm_function13[(46, 22, 12)] = 0.19001913
        pgm_function13[(46, 22, 13)] = 0.3389
        pgm_function13[(46, 22, 14)] = 0.31113125
        pgm_function13[(46, 22, 15)] = 0.1689
        pgm_function13[(46, 22, 16)] = 0.0467
        pgm_function13[(46, 22, 17)] = 0.002199781
        pgm_function13[(46, 23, 9)] = 0.02779723
        pgm_function13[(46, 23, 10)] = 0.1667
        pgm_function13[(46, 23, 11)] = 0.3311
        pgm_function13[(46, 23, 12)] = 0.3211
        pgm_function13[(46, 23, 13)] = 0.1844
        pgm_function13[(46, 23, 14)] = 0.0567
        pgm_function13[(46, 23, 15)] = 0.0044
        pgm_function13[(46, 24, 7)] = 0.02000202
        pgm_function13[(46, 24, 8)] = 0.14671504
        pgm_function13[(46, 24, 9)] = 0.32
        pgm_function13[(46, 24, 10)] = 0.332167159
        pgm_function13[(46, 24, 11)] = 0.202220129
        pgm_function13[(46, 24, 12)] = 0.066706736
        pgm_function13[(46, 24, 13)] = 0.006699332
        pgm_function13[(46, 25, 5)] = 0.0133013
        pgm_function13[(46, 25, 6)] = 0.12558713
        pgm_function13[(46, 25, 7)] = 0.305569147
        pgm_function13[(46, 25, 8)] = 0.3433
        pgm_function13[(46, 25, 9)] = 0.2189
        pgm_function13[(46, 25, 10)] = 0.0767
        pgm_function13[(46, 25, 11)] = 0.01
        pgm_function13[(46, 26, 3)] = 0.006699335
        pgm_function13[(46, 26, 4)] = 0.11
        pgm_function13[(46, 26, 5)] = 0.284456795
        pgm_function13[(46, 26, 6)] = 0.3578
        pgm_function13[(46, 26, 7)] = 0.2344
        pgm_function13[(46, 26, 8)] = 0.0911
        pgm_function13[(46, 26, 9)] = 0.01330131
        pgm_function13[(46, 27, 1)] = 0.004400442
        pgm_function13[(46, 27, 2)] = 0.09
        pgm_function13[(46, 27, 3)] = 0.2667
        pgm_function13[(46, 27, 4)] = 0.358864097
        pgm_function13[(46, 27, 5)] = 0.2500251
        pgm_function13[(46, 27, 6)] = 0.10441003
        pgm_function13[(46, 27, 7)] = 0.01779821
        pgm_function13[(46, 28, 0)] = 0.085591452
        pgm_function13[(46, 28, 1)] = 0.253325286
        pgm_function13[(46, 28, 2)] = 0.35223518
        pgm_function13[(46, 28, 3)] = 0.2711
        pgm_function13[(46, 28, 4)] = 0.12
        pgm_function13[(46, 28, 5)] = 0.02330232
        pgm_function13[(46, 29, 0)] = 0.365563062
        pgm_function13[(46, 29, 1)] = 0.2911
        pgm_function13[(46, 29, 2)] = 0.13331304
        pgm_function13[(46, 29, 3)] = 0.02889712
        pgm_function13[(46, 30, 0)] = 0.1333
        pgm_function13[(46, 30, 1)] = 0.0378
        pgm_function13[(47, 0, 53)] = 0.0067
        pgm_function13[(47, 0, 54)] = 0.12
        pgm_function13[(47, 0, 55)] = 0.290029104
        pgm_function13[(47, 0, 56)] = 0.371137141
        pgm_function13[(47, 0, 57)] = 0.20557906
        pgm_function13[(47, 0, 58)] = 0.0967
        pgm_function13[(47, 0, 59)] = 0.005599444
        pgm_function13[(47, 1, 51)] = 0.00440044
        pgm_function13[(47, 1, 52)] = 0.0822
        pgm_function13[(47, 1, 53)] = 0.2344
        pgm_function13[(47, 1, 54)] = 0.34
        pgm_function13[(47, 1, 55)] = 0.2611
        pgm_function13[(47, 1, 56)] = 0.13221308
        pgm_function13[(47, 1, 57)] = 0.0389
        pgm_function13[(47, 1, 58)] = 0.001100219
        pgm_function13[(47, 2, 49)] = 0.0022
        pgm_function13[(47, 2, 50)] = 0.06559341
        pgm_function13[(47, 2, 51)] = 0.21777822
        pgm_function13[(47, 2, 52)] = 0.3322
        pgm_function13[(47, 2, 53)] = 0.28
        pgm_function13[(47, 2, 54)] = 0.1467
        pgm_function13[(47, 2, 55)] = 0.045595451
        pgm_function13[(47, 2, 56)] = 0.0022
        pgm_function13[(47, 3, 47)] = 0.0011
        pgm_function13[(47, 3, 48)] = 0.05220523
        pgm_function13[(47, 3, 49)] = 0.20112018
        pgm_function13[(47, 3, 50)] = 0.3289
        pgm_function13[(47, 3, 51)] = 0.2944
        pgm_function13[(47, 3, 52)] = 0.1578
        pgm_function13[(47, 3, 53)] = 0.054405432
        pgm_function13[(47, 3, 54)] = 0.00440044
        pgm_function13[(47, 4, 46)] = 0.0411
        pgm_function13[(47, 4, 47)] = 0.18111809
        pgm_function13[(47, 4, 48)] = 0.32333219
        pgm_function13[(47, 4, 49)] = 0.303330391
        pgm_function13[(47, 4, 50)] = 0.174417
        pgm_function13[(47, 4, 51)] = 0.0622
        pgm_function13[(47, 4, 52)] = 0.006699334
        pgm_function13[(47, 5, 44)] = 0.03
        pgm_function13[(47, 5, 45)] = 0.16111611
        pgm_function13[(47, 5, 46)] = 0.3167
        pgm_function13[(47, 5, 47)] = 0.3167
        pgm_function13[(47, 5, 48)] = 0.191119069
        pgm_function13[(47, 5, 49)] = 0.0722
        pgm_function13[(47, 5, 50)] = 0.01000199
        pgm_function13[(47, 6, 42)] = 0.01999802
        pgm_function13[(47, 6, 43)] = 0.143286087
        pgm_function13[(47, 6, 44)] = 0.301070307
        pgm_function13[(47, 6, 45)] = 0.3289
        pgm_function13[(47, 6, 46)] = 0.2022
        pgm_function13[(47, 6, 47)] = 0.083308347
        pgm_function13[(47, 6, 48)] = 0.013301306
        pgm_function13[(47, 7, 40)] = 0.01440141
        pgm_function13[(47, 7, 41)] = 0.1244
        pgm_function13[(47, 7, 42)] = 0.2856
        pgm_function13[(47, 7, 43)] = 0.338934234
        pgm_function13[(47, 7, 44)] = 0.21672197
        pgm_function13[(47, 7, 45)] = 0.0956
        pgm_function13[(47, 7, 46)] = 0.0178
        pgm_function13[(47, 8, 38)] = 0.01
        pgm_function13[(47, 8, 39)] = 0.1044
        pgm_function13[(47, 8, 40)] = 0.27672808
        pgm_function13[(47, 8, 41)] = 0.335566342
        pgm_function13[(47, 8, 42)] = 0.2378
        pgm_function13[(47, 8, 43)] = 0.1055891
        pgm_function13[(47, 8, 44)] = 0.0233
        pgm_function13[(47, 9, 36)] = 0.0067
        pgm_function13[(47, 9, 37)] = 0.0889
        pgm_function13[(47, 9, 38)] = 0.257774134
        pgm_function13[(47, 9, 39)] = 0.3378
        pgm_function13[(47, 9, 40)] = 0.25887413
        pgm_function13[(47, 9, 41)] = 0.1167
        pgm_function13[(47, 9, 42)] = 0.02999703
        pgm_function13[(47, 10, 34)] = 0.003299671
        pgm_function13[(47, 10, 35)] = 0.0744
        pgm_function13[(47, 10, 36)] = 0.232223114
        pgm_function13[(47, 10, 37)] = 0.3422
        pgm_function13[(47, 10, 38)] = 0.2756
        pgm_function13[(47, 10, 39)] = 0.1289
        pgm_function13[(47, 10, 40)] = 0.0367
        pgm_function13[(47, 11, 32)] = 0.001100111
        pgm_function13[(47, 11, 33)] = 0.06110614
        pgm_function13[(47, 11, 34)] = 0.2144
        pgm_function13[(47, 11, 35)] = 0.34
        pgm_function13[(47, 11, 36)] = 0.2878
        pgm_function13[(47, 11, 37)] = 0.14438606
        pgm_function13[(47, 11, 38)] = 0.0444
        pgm_function13[(47, 11, 39)] = 0.00110011
        pgm_function13[(47, 12, 31)] = 0.04559542
        pgm_function13[(47, 12, 32)] = 0.20002016
        pgm_function13[(47, 12, 33)] = 0.33003333
        pgm_function13[(47, 12, 34)] = 0.3022
        pgm_function13[(47, 12, 35)] = 0.16
        pgm_function13[(47, 12, 36)] = 0.05221038
        pgm_function13[(47, 12, 37)] = 0.0022
        pgm_function13[(47, 13, 29)] = 0.03440341
        pgm_function13[(47, 13, 30)] = 0.17998213
        pgm_function13[(47, 13, 31)] = 0.32443239
        pgm_function13[(47, 13, 32)] = 0.31553675
        pgm_function13[(47, 13, 33)] = 0.1756
        pgm_function13[(47, 13, 34)] = 0.0611
        pgm_function13[(47, 13, 35)] = 0.005599439
        pgm_function13[(47, 14, 27)] = 0.0267
        pgm_function13[(47, 14, 28)] = 0.1533
        pgm_function13[(47, 14, 29)] = 0.3211
        pgm_function13[(47, 14, 30)] = 0.3222
        pgm_function13[(47, 14, 31)] = 0.192219175
        pgm_function13[(47, 14, 32)] = 0.068893155
        pgm_function13[(47, 14, 33)] = 0.0089
        pgm_function13[(47, 15, 25)] = 0.0189
        pgm_function13[(47, 15, 26)] = 0.1322
        pgm_function13[(47, 15, 27)] = 0.310031183
        pgm_function13[(47, 15, 28)] = 0.32996736
        pgm_function13[(47, 15, 29)] = 0.21
        pgm_function13[(47, 15, 30)] = 0.0778
        pgm_function13[(47, 15, 31)] = 0.0122
        pgm_function13[(47, 16, 23)] = 0.0122
        pgm_function13[(47, 16, 24)] = 0.117812082
        pgm_function13[(47, 16, 25)] = 0.2889
        pgm_function13[(47, 16, 26)] = 0.3422
        pgm_function13[(47, 16, 27)] = 0.23
        pgm_function13[(47, 16, 28)] = 0.0867
        pgm_function13[(47, 16, 29)] = 0.01779821
        pgm_function13[(47, 17, 21)] = 0.006700676
        pgm_function13[(47, 17, 22)] = 0.1011
        pgm_function13[(47, 17, 23)] = 0.27
        pgm_function13[(47, 17, 24)] = 0.3511
        pgm_function13[(47, 17, 25)] = 0.2467
        pgm_function13[(47, 17, 26)] = 0.0989
        pgm_function13[(47, 17, 27)] = 0.02220221
        pgm_function13[(47, 18, 19)] = 0.004400439
        pgm_function13[(47, 18, 20)] = 0.081108183
        pgm_function13[(47, 18, 21)] = 0.2522
        pgm_function13[(47, 18, 22)] = 0.35003521
        pgm_function13[(47, 18, 23)] = 0.2633
        pgm_function13[(47, 18, 24)] = 0.1133
        pgm_function13[(47, 18, 25)] = 0.02780282
        pgm_function13[(47, 19, 17)] = 0.0022
        pgm_function13[(47, 19, 18)] = 0.0656
        pgm_function13[(47, 19, 19)] = 0.2378
        pgm_function13[(47, 19, 20)] = 0.34776514
        pgm_function13[(47, 19, 21)] = 0.2778
        pgm_function13[(47, 19, 22)] = 0.1289
        pgm_function13[(47, 19, 23)] = 0.03330331
        pgm_function13[(47, 20, 15)] = 0.001100111
        pgm_function13[(47, 20, 16)] = 0.0544
        pgm_function13[(47, 20, 17)] = 0.21222117
        pgm_function13[(47, 20, 18)] = 0.3467
        pgm_function13[(47, 20, 19)] = 0.2889
        pgm_function13[(47, 20, 20)] = 0.1478
        pgm_function13[(47, 20, 21)] = 0.0389
        pgm_function13[(47, 20, 22)] = 0.0011
        pgm_function13[(47, 21, 14)] = 0.04219584
        pgm_function13[(47, 21, 15)] = 0.1911191
        pgm_function13[(47, 21, 16)] = 0.34443452
        pgm_function13[(47, 21, 17)] = 0.30443021
        pgm_function13[(47, 21, 18)] = 0.1667
        pgm_function13[(47, 21, 19)] = 0.0467
        pgm_function13[(47, 21, 20)] = 0.0022
        pgm_function13[(47, 22, 12)] = 0.03110312
        pgm_function13[(47, 22, 13)] = 0.1711
        pgm_function13[(47, 22, 14)] = 0.33113326
        pgm_function13[(47, 22, 15)] = 0.3167
        pgm_function13[(47, 22, 16)] = 0.1822
        pgm_function13[(47, 22, 17)] = 0.055594427
        pgm_function13[(47, 22, 18)] = 0.004400441
        pgm_function13[(47, 23, 10)] = 0.0222
        pgm_function13[(47, 23, 11)] = 0.1511
        pgm_function13[(47, 23, 12)] = 0.3167
        pgm_function13[(47, 23, 13)] = 0.3333
        pgm_function13[(47, 23, 14)] = 0.1967
        pgm_function13[(47, 23, 15)] = 0.0667
        pgm_function13[(47, 23, 16)] = 0.006699332
        pgm_function13[(47, 24, 8)] = 0.0144014
        pgm_function13[(47, 24, 9)] = 0.1311
        pgm_function13[(47, 24, 10)] = 0.305569147
        pgm_function13[(47, 24, 11)] = 0.34333422
        pgm_function13[(47, 24, 12)] = 0.213321115
        pgm_function13[(47, 24, 13)] = 0.076692321
        pgm_function13[(47, 24, 14)] = 0.01
        pgm_function13[(47, 25, 6)] = 0.00999901
        pgm_function13[(47, 25, 7)] = 0.109989053
        pgm_function13[(47, 25, 8)] = 0.2911
        pgm_function13[(47, 25, 9)] = 0.3478
        pgm_function13[(47, 25, 10)] = 0.2333
        pgm_function13[(47, 25, 11)] = 0.0878
        pgm_function13[(47, 25, 12)] = 0.01330131
        pgm_function13[(47, 26, 4)] = 0.0056
        pgm_function13[(47, 26, 5)] = 0.092218334
        pgm_function13[(47, 26, 6)] = 0.2689
        pgm_function13[(47, 26, 7)] = 0.3578
        pgm_function13[(47, 26, 8)] = 0.2478
        pgm_function13[(47, 26, 9)] = 0.10221009
        pgm_function13[(47, 26, 10)] = 0.0178
        pgm_function13[(47, 27, 2)] = 0.0022
        pgm_function13[(47, 27, 3)] = 0.0778
        pgm_function13[(47, 27, 4)] = 0.251075068
        pgm_function13[(47, 27, 5)] = 0.36003614
        pgm_function13[(47, 27, 6)] = 0.26222608
        pgm_function13[(47, 27, 7)] = 0.11778805
        pgm_function13[(47, 27, 8)] = 0.0222
        pgm_function13[(47, 28, 0)] = 0.001099891
        pgm_function13[(47, 28, 1)] = 0.061106169
        pgm_function13[(47, 28, 2)] = 0.23332312
        pgm_function13[(47, 28, 3)] = 0.3511
        pgm_function13[(47, 28, 4)] = 0.2844
        pgm_function13[(47, 28, 5)] = 0.13221313
        pgm_function13[(47, 28, 6)] = 0.02889713
        pgm_function13[(47, 29, 0)] = 0.23437704
        pgm_function13[(47, 29, 1)] = 0.3422
        pgm_function13[(47, 29, 2)] = 0.30443009
        pgm_function13[(47, 29, 3)] = 0.14778512
        pgm_function13[(47, 29, 4)] = 0.0367
        pgm_function13[(47, 30, 0)] = 0.2956
        pgm_function13[(47, 30, 1)] = 0.1644
        pgm_function13[(47, 30, 2)] = 0.045595417
        pgm_function13[(47, 30, 3)] = 0.0011
        pgm_function13[(47, 31, 0)] = 0.0389
        pgm_function13[(47, 31, 1)] = 0.00220022
        pgm_function13[(48, 0, 54)] = 0.0056
        pgm_function13[(48, 0, 55)] = 0.104410038
        pgm_function13[(48, 0, 56)] = 0.273327104
        pgm_function13[(48, 0, 57)] = 0.36996311
        pgm_function13[(48, 0, 58)] = 0.2289
        pgm_function13[(48, 0, 59)] = 0.103290079
        pgm_function13[(48, 0, 60)] = 0.01220121
        pgm_function13[(48, 1, 52)] = 0.0022
        pgm_function13[(48, 1, 53)] = 0.0722
        pgm_function13[(48, 1, 54)] = 0.2178
        pgm_function13[(48, 1, 55)] = 0.3367
        pgm_function13[(48, 1, 56)] = 0.27222716
        pgm_function13[(48, 1, 57)] = 0.1456
        pgm_function13[(48, 1, 58)] = 0.044408855
        pgm_function13[(48, 1, 59)] = 0.002200221
        pgm_function13[(48, 2, 50)] = 0.00109989
        pgm_function13[(48, 2, 51)] = 0.05779426
        pgm_function13[(48, 2, 52)] = 0.2011
        pgm_function13[(48, 2, 53)] = 0.3289
        pgm_function13[(48, 2, 54)] = 0.2889
        pgm_function13[(48, 2, 55)] = 0.157784175
        pgm_function13[(48, 2, 56)] = 0.0544
        pgm_function13[(48, 2, 57)] = 0.00440044
        pgm_function13[(48, 3, 49)] = 0.04330434
        pgm_function13[(48, 3, 50)] = 0.1878
        pgm_function13[(48, 3, 51)] = 0.3167
        pgm_function13[(48, 3, 52)] = 0.3056
        pgm_function13[(48, 3, 53)] = 0.170017099
        pgm_function13[(48, 3, 54)] = 0.0622062
        pgm_function13[(48, 3, 55)] = 0.006700678
        pgm_function13[(48, 4, 47)] = 0.03220322
        pgm_function13[(48, 4, 48)] = 0.1667171
        pgm_function13[(48, 4, 49)] = 0.313331404
        pgm_function13[(48, 4, 50)] = 0.31563199
        pgm_function13[(48, 4, 51)] = 0.1867
        pgm_function13[(48, 4, 52)] = 0.072192847
        pgm_function13[(48, 4, 53)] = 0.009999004
        pgm_function13[(48, 5, 45)] = 0.02330232
        pgm_function13[(48, 5, 46)] = 0.1444
        pgm_function13[(48, 5, 47)] = 0.3056
        pgm_function13[(48, 5, 48)] = 0.321132116
        pgm_function13[(48, 5, 49)] = 0.2022
        pgm_function13[(48, 5, 50)] = 0.081116121
        pgm_function13[(48, 5, 51)] = 0.0133
        pgm_function13[(48, 6, 43)] = 0.01669831
        pgm_function13[(48, 6, 44)] = 0.126687129
        pgm_function13[(48, 6, 45)] = 0.29
        pgm_function13[(48, 6, 46)] = 0.3344
        pgm_function13[(48, 6, 47)] = 0.21442112
        pgm_function13[(48, 6, 48)] = 0.093309345
        pgm_function13[(48, 6, 49)] = 0.0178
        pgm_function13[(48, 7, 41)] = 0.01
        pgm_function13[(48, 7, 42)] = 0.1122
        pgm_function13[(48, 7, 43)] = 0.273327189
        pgm_function13[(48, 7, 44)] = 0.341133952
        pgm_function13[(48, 7, 45)] = 0.23
        pgm_function13[(48, 7, 46)] = 0.1044
        pgm_function13[(48, 7, 47)] = 0.0233
        pgm_function13[(48, 8, 39)] = 0.0067
        pgm_function13[(48, 8, 40)] = 0.092209227
        pgm_function13[(48, 8, 41)] = 0.258874264
        pgm_function13[(48, 8, 42)] = 0.3378
        pgm_function13[(48, 8, 43)] = 0.25217523
        pgm_function13[(48, 8, 44)] = 0.1167
        pgm_function13[(48, 8, 45)] = 0.03000303
        pgm_function13[(48, 9, 37)] = 0.0044
        pgm_function13[(48, 9, 38)] = 0.07669234
        pgm_function13[(48, 9, 39)] = 0.2422
        pgm_function13[(48, 9, 40)] = 0.33326717
        pgm_function13[(48, 9, 41)] = 0.2733
        pgm_function13[(48, 9, 42)] = 0.12668711
        pgm_function13[(48, 9, 43)] = 0.03669633
        pgm_function13[(48, 10, 35)] = 0.0022
        pgm_function13[(48, 10, 36)] = 0.064406432
        pgm_function13[(48, 10, 37)] = 0.2178
        pgm_function13[(48, 10, 38)] = 0.3322
        pgm_function13[(48, 10, 39)] = 0.2878
        pgm_function13[(48, 10, 40)] = 0.1411
        pgm_function13[(48, 10, 41)] = 0.0433
        pgm_function13[(48, 10, 42)] = 0.0011
        pgm_function13[(48, 11, 34)] = 0.0511
        pgm_function13[(48, 11, 35)] = 0.1978
        pgm_function13[(48, 11, 36)] = 0.3356
        pgm_function13[(48, 11, 37)] = 0.29667012
        pgm_function13[(48, 11, 38)] = 0.1578
        pgm_function13[(48, 11, 39)] = 0.05220522
        pgm_function13[(48, 11, 40)] = 0.002200222
        pgm_function13[(48, 12, 32)] = 0.03780383
        pgm_function13[(48, 12, 33)] = 0.18331818
        pgm_function13[(48, 12, 34)] = 0.3278
        pgm_function13[(48, 12, 35)] = 0.31
        pgm_function13[(48, 12, 36)] = 0.17443494
        pgm_function13[(48, 12, 37)] = 0.06
        pgm_function13[(48, 12, 38)] = 0.0044
        pgm_function13[(48, 13, 30)] = 0.02669732
        pgm_function13[(48, 13, 31)] = 0.1633162
        pgm_function13[(48, 13, 32)] = 0.31553675
        pgm_function13[(48, 13, 33)] = 0.3222
        pgm_function13[(48, 13, 34)] = 0.19
        pgm_function13[(48, 13, 35)] = 0.066693289
        pgm_function13[(48, 13, 36)] = 0.0089
        pgm_function13[(48, 14, 28)] = 0.02
        pgm_function13[(48, 14, 29)] = 0.1389
        pgm_function13[(48, 14, 30)] = 0.3089
        pgm_function13[(48, 14, 31)] = 0.3300333
        pgm_function13[(48, 14, 32)] = 0.205579164
        pgm_function13[(48, 14, 33)] = 0.0767
        pgm_function13[(48, 14, 34)] = 0.012202392
        pgm_function13[(48, 15, 26)] = 0.0144
        pgm_function13[(48, 15, 27)] = 0.11891207
        pgm_function13[(48, 15, 28)] = 0.295570322
        pgm_function13[(48, 15, 29)] = 0.3356
        pgm_function13[(48, 15, 30)] = 0.2244
        pgm_function13[(48, 15, 31)] = 0.0867
        pgm_function13[(48, 15, 32)] = 0.01779821
        pgm_function13[(48, 16, 24)] = 0.008900896
        pgm_function13[(48, 16, 25)] = 0.1022
        pgm_function13[(48, 16, 26)] = 0.2756
        pgm_function13[(48, 16, 27)] = 0.3422
        pgm_function13[(48, 16, 28)] = 0.2444
        pgm_function13[(48, 16, 29)] = 0.09889014
        pgm_function13[(48, 16, 30)] = 0.0222
        pgm_function13[(48, 17, 22)] = 0.0044
        pgm_function13[(48, 17, 23)] = 0.0889
        pgm_function13[(48, 17, 24)] = 0.2489
        pgm_function13[(48, 17, 25)] = 0.3522
        pgm_function13[(48, 17, 26)] = 0.2589
        pgm_function13[(48, 17, 27)] = 0.11111104
        pgm_function13[(48, 17, 28)] = 0.02780282
        pgm_function13[(48, 18, 20)] = 0.002200222
        pgm_function13[(48, 18, 21)] = 0.0722
        pgm_function13[(48, 18, 22)] = 0.23332314
        pgm_function13[(48, 18, 23)] = 0.3511
        pgm_function13[(48, 18, 24)] = 0.2756
        pgm_function13[(48, 18, 25)] = 0.1267131
        pgm_function13[(48, 18, 26)] = 0.03330333
        pgm_function13[(48, 19, 18)] = 0.0011
        pgm_function13[(48, 19, 19)] = 0.0556
        pgm_function13[(48, 19, 20)] = 0.22107809
        pgm_function13[(48, 19, 21)] = 0.3433
        pgm_function13[(48, 19, 22)] = 0.29
        pgm_function13[(48, 19, 23)] = 0.14331404
        pgm_function13[(48, 19, 24)] = 0.03889614
        pgm_function13[(48, 19, 25)] = 0.001100111
        pgm_function13[(48, 20, 17)] = 0.04440444
        pgm_function13[(48, 20, 18)] = 0.1989
        pgm_function13[(48, 20, 19)] = 0.34
        pgm_function13[(48, 20, 20)] = 0.3022
        pgm_function13[(48, 20, 21)] = 0.1644
        pgm_function13[(48, 20, 22)] = 0.0456
        pgm_function13[(48, 20, 23)] = 0.0022
        pgm_function13[(48, 21, 15)] = 0.03330332
        pgm_function13[(48, 21, 16)] = 0.17331726
        pgm_function13[(48, 21, 17)] = 0.33333323
        pgm_function13[(48, 21, 18)] = 0.31
        pgm_function13[(48, 21, 19)] = 0.18
        pgm_function13[(48, 21, 20)] = 0.0544
        pgm_function13[(48, 21, 21)] = 0.004400878
        pgm_function13[(48, 22, 13)] = 0.0244
        pgm_function13[(48, 22, 14)] = 0.15331512
        pgm_function13[(48, 22, 15)] = 0.3233
        pgm_function13[(48, 22, 16)] = 0.3256
        pgm_function13[(48, 22, 17)] = 0.194381095
        pgm_function13[(48, 22, 18)] = 0.065606608
        pgm_function13[(48, 22, 19)] = 0.006699335
        pgm_function13[(48, 23, 11)] = 0.0156
        pgm_function13[(48, 23, 12)] = 0.1378
        pgm_function13[(48, 23, 13)] = 0.3056
        pgm_function13[(48, 23, 14)] = 0.3422
        pgm_function13[(48, 23, 15)] = 0.2078
        pgm_function13[(48, 23, 16)] = 0.076692322
        pgm_function13[(48, 23, 17)] = 0.009999005
        pgm_function13[(48, 24, 9)] = 0.01
        pgm_function13[(48, 24, 10)] = 0.117788057
        pgm_function13[(48, 24, 11)] = 0.287829184
        pgm_function13[(48, 24, 12)] = 0.350035189
        pgm_function13[(48, 24, 13)] = 0.227777064
        pgm_function13[(48, 24, 14)] = 0.0867
        pgm_function13[(48, 24, 15)] = 0.0133013
        pgm_function13[(48, 25, 7)] = 0.006699333
        pgm_function13[(48, 25, 8)] = 0.0956
        pgm_function13[(48, 25, 9)] = 0.2756
        pgm_function13[(48, 25, 10)] = 0.3522
        pgm_function13[(48, 25, 11)] = 0.2478
        pgm_function13[(48, 25, 12)] = 0.10001004
        pgm_function13[(48, 25, 13)] = 0.0178
        pgm_function13[(48, 26, 5)] = 0.004400877
        pgm_function13[(48, 26, 6)] = 0.08
        pgm_function13[(48, 26, 7)] = 0.2544
        pgm_function13[(48, 26, 8)] = 0.3522
        pgm_function13[(48, 26, 9)] = 0.26332624
        pgm_function13[(48, 26, 10)] = 0.1144
        pgm_function13[(48, 26, 11)] = 0.0222
        pgm_function13[(48, 27, 3)] = 0.0011
        pgm_function13[(48, 27, 4)] = 0.065593418
        pgm_function13[(48, 27, 5)] = 0.23332309
        pgm_function13[(48, 27, 6)] = 0.35673611
        pgm_function13[(48, 27, 7)] = 0.27887211
        pgm_function13[(48, 27, 8)] = 0.1311
        pgm_function13[(48, 27, 9)] = 0.0289
        pgm_function13[(48, 28, 2)] = 0.05220523
        pgm_function13[(48, 28, 3)] = 0.2167
        pgm_function13[(48, 28, 4)] = 0.3478
        pgm_function13[(48, 28, 5)] = 0.29442929
        pgm_function13[(48, 28, 6)] = 0.14778513
        pgm_function13[(48, 28, 7)] = 0.0356
        pgm_function13[(48, 29, 0)] = 0.047795208
        pgm_function13[(48, 29, 1)] = 0.1978
        pgm_function13[(48, 29, 2)] = 0.3356341
        pgm_function13[(48, 29, 3)] = 0.31556825
        pgm_function13[(48, 29, 4)] = 0.1611
        pgm_function13[(48, 29, 5)] = 0.0456
        pgm_function13[(48, 29, 6)] = 0.001100111
        pgm_function13[(48, 30, 0)] = 0.3467
        pgm_function13[(48, 30, 1)] = 0.3256
        pgm_function13[(48, 30, 2)] = 0.177782068
        pgm_function13[(48, 30, 3)] = 0.0544
        pgm_function13[(48, 30, 4)] = 0.0022
        pgm_function13[(48, 31, 0)] = 0.1756
        pgm_function13[(48, 31, 1)] = 0.0644064
        pgm_function13[(48, 31, 2)] = 0.0044
        pgm_function13[(49, 0, 55)] = 0.004400442
        pgm_function13[(49, 0, 56)] = 0.090009034
        pgm_function13[(49, 0, 57)] = 0.26217408
        pgm_function13[(49, 0, 58)] = 0.35
        pgm_function13[(49, 0, 59)] = 0.246675187
        pgm_function13[(49, 0, 60)] = 0.11331109
        pgm_function13[(49, 1, 53)] = 0.0011
        pgm_function13[(49, 1, 54)] = 0.0611
        pgm_function13[(49, 1, 55)] = 0.2033
        pgm_function13[(49, 1, 56)] = 0.3300332
        pgm_function13[(49, 1, 57)] = 0.2822
        pgm_function13[(49, 1, 58)] = 0.157831839
        pgm_function13[(49, 1, 59)] = 0.054405426
        pgm_function13[(49, 1, 60)] = 0.00440044
        pgm_function13[(49, 2, 52)] = 0.0489
        pgm_function13[(49, 2, 53)] = 0.1867
        pgm_function13[(49, 2, 54)] = 0.3233
        pgm_function13[(49, 2, 55)] = 0.297770331
        pgm_function13[(49, 2, 56)] = 0.1678
        pgm_function13[(49, 2, 57)] = 0.0622062
        pgm_function13[(49, 2, 58)] = 0.006699335
        pgm_function13[(49, 3, 50)] = 0.0333
        pgm_function13[(49, 3, 51)] = 0.1722
        pgm_function13[(49, 3, 52)] = 0.3122
        pgm_function13[(49, 3, 53)] = 0.314431182
        pgm_function13[(49, 3, 54)] = 0.18111801
        pgm_function13[(49, 3, 55)] = 0.072207282
        pgm_function13[(49, 3, 56)] = 0.009999005
        pgm_function13[(49, 4, 48)] = 0.02440241
        pgm_function13[(49, 4, 49)] = 0.153315198
        pgm_function13[(49, 4, 50)] = 0.30222999
        pgm_function13[(49, 4, 51)] = 0.3222
        pgm_function13[(49, 4, 52)] = 0.197780129
        pgm_function13[(49, 4, 53)] = 0.08109193
        pgm_function13[(49, 4, 54)] = 0.013302707
        pgm_function13[(49, 5, 46)] = 0.0189
        pgm_function13[(49, 5, 47)] = 0.13
        pgm_function13[(49, 5, 48)] = 0.293329106
        pgm_function13[(49, 5, 49)] = 0.3278
        pgm_function13[(49, 5, 50)] = 0.213342791
        pgm_function13[(49, 5, 51)] = 0.0911
        pgm_function13[(49, 5, 52)] = 0.017801814
        pgm_function13[(49, 6, 44)] = 0.012198812
        pgm_function13[(49, 6, 45)] = 0.1122
        pgm_function13[(49, 6, 46)] = 0.28
        pgm_function13[(49, 6, 47)] = 0.333333187
        pgm_function13[(49, 6, 48)] = 0.231123111
        pgm_function13[(49, 6, 49)] = 0.1022
        pgm_function13[(49, 6, 50)] = 0.0233
        pgm_function13[(49, 7, 42)] = 0.0067
        pgm_function13[(49, 7, 43)] = 0.097809867
        pgm_function13[(49, 7, 44)] = 0.260025964
        pgm_function13[(49, 7, 45)] = 0.34
        pgm_function13[(49, 7, 46)] = 0.2456
        pgm_function13[(49, 7, 47)] = 0.1156
        pgm_function13[(49, 7, 48)] = 0.0289
        pgm_function13[(49, 8, 40)] = 0.004400441
        pgm_function13[(49, 8, 41)] = 0.082191884
        pgm_function13[(49, 8, 42)] = 0.2422
        pgm_function13[(49, 8, 43)] = 0.3377663
        pgm_function13[(49, 8, 44)] = 0.2633
        pgm_function13[(49, 8, 45)] = 0.12671311
        pgm_function13[(49, 8, 46)] = 0.03669633
        pgm_function13[(49, 9, 38)] = 0.002199781
        pgm_function13[(49, 9, 39)] = 0.0667
        pgm_function13[(49, 9, 40)] = 0.22667711
        pgm_function13[(49, 9, 41)] = 0.3289
        pgm_function13[(49, 9, 42)] = 0.28557126
        pgm_function13[(49, 9, 43)] = 0.13888611
        pgm_function13[(49, 9, 44)] = 0.04330431
        pgm_function13[(49, 9, 45)] = 0.001100111
        pgm_function13[(49, 10, 36)] = 0.001100111
        pgm_function13[(49, 10, 37)] = 0.0544
        pgm_function13[(49, 10, 38)] = 0.2056
        pgm_function13[(49, 10, 39)] = 0.3289
        pgm_function13[(49, 10, 40)] = 0.2967
        pgm_function13[(49, 10, 41)] = 0.1544
        pgm_function13[(49, 10, 42)] = 0.0522
        pgm_function13[(49, 10, 43)] = 0.002200221
        pgm_function13[(49, 11, 35)] = 0.0411
        pgm_function13[(49, 11, 36)] = 0.1822
        pgm_function13[(49, 11, 37)] = 0.32996713
        pgm_function13[(49, 11, 38)] = 0.3056
        pgm_function13[(49, 11, 39)] = 0.17111705
        pgm_function13[(49, 11, 40)] = 0.060006047
        pgm_function13[(49, 11, 41)] = 0.0044
        pgm_function13[(49, 12, 33)] = 0.03000303
        pgm_function13[(49, 12, 34)] = 0.1633
        pgm_function13[(49, 12, 35)] = 0.32
        pgm_function13[(49, 12, 36)] = 0.3144629
        pgm_function13[(49, 12, 37)] = 0.1878
        pgm_function13[(49, 12, 38)] = 0.0678
        pgm_function13[(49, 12, 39)] = 0.008900889
        pgm_function13[(49, 13, 31)] = 0.02000202
        pgm_function13[(49, 13, 32)] = 0.14667088
        pgm_function13[(49, 13, 33)] = 0.3078
        pgm_function13[(49, 13, 34)] = 0.3267
        pgm_function13[(49, 13, 35)] = 0.205578965
        pgm_function13[(49, 13, 36)] = 0.0744
        pgm_function13[(49, 13, 37)] = 0.0122
        pgm_function13[(49, 14, 29)] = 0.0144
        pgm_function13[(49, 14, 30)] = 0.1256
        pgm_function13[(49, 14, 31)] = 0.294429268
        pgm_function13[(49, 14, 32)] = 0.338866271
        pgm_function13[(49, 14, 33)] = 0.2178
        pgm_function13[(49, 14, 34)] = 0.084416846
        pgm_function13[(49, 14, 35)] = 0.0178
        pgm_function13[(49, 15, 27)] = 0.010001006
        pgm_function13[(49, 15, 28)] = 0.105589115
        pgm_function13[(49, 15, 29)] = 0.2833
        pgm_function13[(49, 15, 30)] = 0.34
        pgm_function13[(49, 15, 31)] = 0.2389
        pgm_function13[(49, 15, 32)] = 0.09779027
        pgm_function13[(49, 15, 33)] = 0.0222
        pgm_function13[(49, 16, 25)] = 0.0067
        pgm_function13[(49, 16, 26)] = 0.0889
        pgm_function13[(49, 16, 27)] = 0.2622
        pgm_function13[(49, 16, 28)] = 0.34
        pgm_function13[(49, 16, 29)] = 0.2555741
        pgm_function13[(49, 16, 30)] = 0.11
        pgm_function13[(49, 16, 31)] = 0.0278
        pgm_function13[(49, 17, 23)] = 0.0022
        pgm_function13[(49, 17, 24)] = 0.0767
        pgm_function13[(49, 17, 25)] = 0.2344
        pgm_function13[(49, 17, 26)] = 0.3478
        pgm_function13[(49, 17, 27)] = 0.27112711
        pgm_function13[(49, 17, 28)] = 0.1256131
        pgm_function13[(49, 17, 29)] = 0.0333
        pgm_function13[(49, 18, 21)] = 0.0011
        pgm_function13[(49, 18, 22)] = 0.06330634
        pgm_function13[(49, 18, 23)] = 0.2156
        pgm_function13[(49, 18, 24)] = 0.3478
        pgm_function13[(49, 18, 25)] = 0.28442823
        pgm_function13[(49, 18, 26)] = 0.14111414
        pgm_function13[(49, 18, 27)] = 0.0389
        pgm_function13[(49, 18, 28)] = 0.0011
        pgm_function13[(49, 19, 20)] = 0.04559542
        pgm_function13[(49, 19, 21)] = 0.2022
        pgm_function13[(49, 19, 22)] = 0.3389
        pgm_function13[(49, 19, 23)] = 0.30003009
        pgm_function13[(49, 19, 24)] = 0.15998414
        pgm_function13[(49, 19, 25)] = 0.045604641
        pgm_function13[(49, 19, 26)] = 0.0022
        pgm_function13[(49, 20, 18)] = 0.0344
        pgm_function13[(49, 20, 19)] = 0.1833
        pgm_function13[(49, 20, 20)] = 0.33
        pgm_function13[(49, 20, 21)] = 0.3111
        pgm_function13[(49, 20, 22)] = 0.1767
        pgm_function13[(49, 20, 23)] = 0.0533
        pgm_function13[(49, 20, 24)] = 0.004400443
        pgm_function13[(49, 21, 16)] = 0.02670274
        pgm_function13[(49, 21, 17)] = 0.15781611
        pgm_function13[(49, 21, 18)] = 0.3256
        pgm_function13[(49, 21, 19)] = 0.3211
        pgm_function13[(49, 21, 20)] = 0.1922
        pgm_function13[(49, 21, 21)] = 0.063312671
        pgm_function13[(49, 21, 22)] = 0.006699337
        pgm_function13[(49, 22, 14)] = 0.01890192
        pgm_function13[(49, 22, 15)] = 0.1367
        pgm_function13[(49, 22, 16)] = 0.3133
        pgm_function13[(49, 22, 17)] = 0.335566164
        pgm_function13[(49, 22, 18)] = 0.205621025
        pgm_function13[(49, 22, 19)] = 0.07559246
        pgm_function13[(49, 22, 20)] = 0.01
        pgm_function13[(49, 23, 12)] = 0.0111
        pgm_function13[(49, 23, 13)] = 0.12
        pgm_function13[(49, 23, 14)] = 0.2911
        pgm_function13[(49, 23, 15)] = 0.3478
        pgm_function13[(49, 23, 16)] = 0.222178064
        pgm_function13[(49, 23, 17)] = 0.086691344
        pgm_function13[(49, 23, 18)] = 0.01329871
        pgm_function13[(49, 24, 10)] = 0.006699333
        pgm_function13[(49, 24, 11)] = 0.103310066
        pgm_function13[(49, 24, 12)] = 0.272227147
        pgm_function13[(49, 24, 13)] = 0.353265099
        pgm_function13[(49, 24, 14)] = 0.24
        pgm_function13[(49, 24, 15)] = 0.10001003
        pgm_function13[(49, 24, 16)] = 0.01780181
        pgm_function13[(49, 25, 8)] = 0.0044
        pgm_function13[(49, 25, 9)] = 0.0844
        pgm_function13[(49, 25, 10)] = 0.2567
        pgm_function13[(49, 25, 11)] = 0.35
        pgm_function13[(49, 25, 12)] = 0.2611261
        pgm_function13[(49, 25, 13)] = 0.1122
        pgm_function13[(49, 25, 14)] = 0.0222
        pgm_function13[(49, 26, 6)] = 0.0022
        pgm_function13[(49, 26, 7)] = 0.0678
        pgm_function13[(49, 26, 8)] = 0.2422
        pgm_function13[(49, 26, 9)] = 0.35003532
        pgm_function13[(49, 26, 10)] = 0.28
        pgm_function13[(49, 26, 11)] = 0.1267
        pgm_function13[(49, 26, 12)] = 0.0289
        pgm_function13[(49, 27, 5)] = 0.05440542
        pgm_function13[(49, 27, 6)] = 0.21892207
        pgm_function13[(49, 27, 7)] = 0.34776514
        pgm_function13[(49, 27, 8)] = 0.2922
        pgm_function13[(49, 27, 9)] = 0.1444
        pgm_function13[(49, 27, 10)] = 0.03559641
        pgm_function13[(49, 28, 3)] = 0.0422
        pgm_function13[(49, 28, 4)] = 0.1967
        pgm_function13[(49, 28, 5)] = 0.34333434
        pgm_function13[(49, 28, 6)] = 0.30556928
        pgm_function13[(49, 28, 7)] = 0.1611
        pgm_function13[(49, 28, 8)] = 0.04440443
        pgm_function13[(49, 28, 9)] = 0.0011
        pgm_function13[(49, 29, 1)] = 0.03
        pgm_function13[(49, 29, 2)] = 0.17891805
        pgm_function13[(49, 29, 3)] = 0.32996726
        pgm_function13[(49, 29, 4)] = 0.3211
        pgm_function13[(49, 29, 5)] = 0.1756
        pgm_function13[(49, 29, 6)] = 0.053305349
        pgm_function13[(49, 29, 7)] = 0.00220022
        pgm_function13[(49, 30, 0)] = 0.1811
        pgm_function13[(49, 30, 1)] = 0.3211
        pgm_function13[(49, 30, 2)] = 0.336666128
        pgm_function13[(49, 30, 3)] = 0.19
        pgm_function13[(49, 30, 4)] = 0.0644
        pgm_function13[(49, 30, 5)] = 0.004400441
        pgm_function13[(49, 31, 0)] = 0.3389
        pgm_function13[(49, 31, 1)] = 0.21222101
        pgm_function13[(49, 31, 2)] = 0.0733
        pgm_function13[(49, 31, 3)] = 0.007799225
        pgm_function13[(49, 32, 0)] = 0.0722
        pgm_function13[(49, 32, 1)] = 0.0111
        pgm_function13[(50, 0, 56)] = 0.002200221
        pgm_function13[(50, 0, 57)] = 0.07559242
        pgm_function13[(50, 0, 58)] = 0.2633
        pgm_function13[(50, 0, 59)] = 0.345565263
        pgm_function13[(50, 0, 60)] = 0.26002621
        pgm_function13[(50, 1, 55)] = 0.0511
        pgm_function13[(50, 1, 56)] = 0.19111911
        pgm_function13[(50, 1, 57)] = 0.3233
        pgm_function13[(50, 1, 58)] = 0.2944587
        pgm_function13[(50, 1, 59)] = 0.165617079
        pgm_function13[(50, 1, 60)] = 0.0611061
        pgm_function13[(50, 2, 53)] = 0.0389
        pgm_function13[(50, 2, 54)] = 0.1711
        pgm_function13[(50, 2, 55)] = 0.317768353
        pgm_function13[(50, 2, 56)] = 0.3067
        pgm_function13[(50, 2, 57)] = 0.17891801
        pgm_function13[(50, 2, 58)] = 0.071092955
        pgm_function13[(50, 2, 59)] = 0.01
        pgm_function13[(50, 3, 51)] = 0.0278
        pgm_function13[(50, 3, 52)] = 0.1544
        pgm_function13[(50, 3, 53)] = 0.303330176
        pgm_function13[(50, 3, 54)] = 0.31893202
        pgm_function13[(50, 3, 55)] = 0.19441922
        pgm_function13[(50, 3, 56)] = 0.081091938
        pgm_function13[(50, 3, 57)] = 0.013301307
        pgm_function13[(50, 4, 49)] = 0.018901924
        pgm_function13[(50, 4, 50)] = 0.136714
        pgm_function13[(50, 4, 51)] = 0.2889
        pgm_function13[(50, 4, 52)] = 0.327767213
        pgm_function13[(50, 4, 53)] = 0.207779077
        pgm_function13[(50, 4, 54)] = 0.091118247
        pgm_function13[(50, 4, 55)] = 0.0178
        pgm_function13[(50, 5, 47)] = 0.0133
        pgm_function13[(50, 5, 48)] = 0.117812042
        pgm_function13[(50, 5, 49)] = 0.2811
        pgm_function13[(50, 5, 50)] = 0.333366673
        pgm_function13[(50, 5, 51)] = 0.2278
        pgm_function13[(50, 5, 52)] = 0.10111008
        pgm_function13[(50, 5, 53)] = 0.023302311
        pgm_function13[(50, 6, 45)] = 0.01
        pgm_function13[(50, 6, 46)] = 0.0967
        pgm_function13[(50, 6, 47)] = 0.26782715
        pgm_function13[(50, 6, 48)] = 0.33333316
        pgm_function13[(50, 6, 49)] = 0.2456
        pgm_function13[(50, 6, 50)] = 0.1122
        pgm_function13[(50, 6, 51)] = 0.0289
        pgm_function13[(50, 7, 43)] = 0.004400443
        pgm_function13[(50, 7, 44)] = 0.083308288
        pgm_function13[(50, 7, 45)] = 0.2467
        pgm_function13[(50, 7, 46)] = 0.3378
        pgm_function13[(50, 7, 47)] = 0.2589
        pgm_function13[(50, 7, 48)] = 0.1256
        pgm_function13[(50, 7, 49)] = 0.03669631
        pgm_function13[(50, 8, 41)] = 0.002199782
        pgm_function13[(50, 8, 42)] = 0.0722
        pgm_function13[(50, 8, 43)] = 0.2255772
        pgm_function13[(50, 8, 44)] = 0.3367
        pgm_function13[(50, 8, 45)] = 0.27442725
        pgm_function13[(50, 8, 46)] = 0.13778612
        pgm_function13[(50, 8, 47)] = 0.0433
        pgm_function13[(50, 8, 48)] = 0.001100111
        pgm_function13[(50, 9, 39)] = 0.0011
        pgm_function13[(50, 9, 40)] = 0.05669433
        pgm_function13[(50, 9, 41)] = 0.2089
        pgm_function13[(50, 9, 42)] = 0.32776729
        pgm_function13[(50, 9, 43)] = 0.29217123
        pgm_function13[(50, 9, 44)] = 0.15221505
        pgm_function13[(50, 9, 45)] = 0.052205241
        pgm_function13[(50, 9, 46)] = 0.0022
        pgm_function13[(50, 10, 38)] = 0.0444
        pgm_function13[(50, 10, 39)] = 0.19
        pgm_function13[(50, 10, 40)] = 0.3233
        pgm_function13[(50, 10, 41)] = 0.3067
        pgm_function13[(50, 10, 42)] = 0.1667
        pgm_function13[(50, 10, 43)] = 0.060006029
        pgm_function13[(50, 10, 44)] = 0.004400443
        pgm_function13[(50, 11, 36)] = 0.0333
        pgm_function13[(50, 11, 37)] = 0.16558307
        pgm_function13[(50, 11, 38)] = 0.3211
        pgm_function13[(50, 11, 39)] = 0.31223109
        pgm_function13[(50, 11, 40)] = 0.183318143
        pgm_function13[(50, 11, 41)] = 0.0678
        pgm_function13[(50, 11, 42)] = 0.0089
        pgm_function13[(50, 12, 34)] = 0.0233
        pgm_function13[(50, 12, 35)] = 0.1467
        pgm_function13[(50, 12, 36)] = 0.3133629
        pgm_function13[(50, 12, 37)] = 0.32
        pgm_function13[(50, 12, 38)] = 0.2033
        pgm_function13[(50, 12, 39)] = 0.07440739
        pgm_function13[(50, 12, 40)] = 0.0122012
        pgm_function13[(50, 13, 32)] = 0.01559689
        pgm_function13[(50, 13, 33)] = 0.1289
        pgm_function13[(50, 13, 34)] = 0.2967
        pgm_function13[(50, 13, 35)] = 0.334366943
        pgm_function13[(50, 13, 36)] = 0.2189
        pgm_function13[(50, 13, 37)] = 0.0833
        pgm_function13[(50, 13, 38)] = 0.017798218
        pgm_function13[(50, 14, 30)] = 0.01
        pgm_function13[(50, 14, 31)] = 0.112211102
        pgm_function13[(50, 14, 32)] = 0.277772222
        pgm_function13[(50, 14, 33)] = 0.3444
        pgm_function13[(50, 14, 34)] = 0.23444685
        pgm_function13[(50, 14, 35)] = 0.0944
        pgm_function13[(50, 14, 36)] = 0.0222
        pgm_function13[(50, 15, 28)] = 0.006699337
        pgm_function13[(50, 15, 29)] = 0.0922
        pgm_function13[(50, 15, 30)] = 0.2656
        pgm_function13[(50, 15, 31)] = 0.3433
        pgm_function13[(50, 15, 32)] = 0.24777517
        pgm_function13[(50, 15, 33)] = 0.1089
        pgm_function13[(50, 15, 34)] = 0.0278
        pgm_function13[(50, 16, 26)] = 0.0044
        pgm_function13[(50, 16, 27)] = 0.0767
        pgm_function13[(50, 16, 28)] = 0.2478
        pgm_function13[(50, 16, 29)] = 0.34106614
        pgm_function13[(50, 16, 30)] = 0.2667
        pgm_function13[(50, 16, 31)] = 0.1233
        pgm_function13[(50, 16, 32)] = 0.0333
        pgm_function13[(50, 17, 24)] = 0.0022
        pgm_function13[(50, 17, 25)] = 0.0656
        pgm_function13[(50, 17, 26)] = 0.2222
        pgm_function13[(50, 17, 27)] = 0.34443414
        pgm_function13[(50, 17, 28)] = 0.28332823
        pgm_function13[(50, 17, 29)] = 0.1389
        pgm_function13[(50, 17, 30)] = 0.03890394
        pgm_function13[(50, 17, 31)] = 0.0011
        pgm_function13[(50, 18, 23)] = 0.0522
        pgm_function13[(50, 18, 24)] = 0.1978
        pgm_function13[(50, 18, 25)] = 0.34443428
        pgm_function13[(50, 18, 26)] = 0.29442929
        pgm_function13[(50, 18, 27)] = 0.1578
        pgm_function13[(50, 18, 28)] = 0.0456
        pgm_function13[(50, 18, 29)] = 0.002200221
        pgm_function13[(50, 19, 21)] = 0.0378
        pgm_function13[(50, 19, 22)] = 0.1833
        pgm_function13[(50, 19, 23)] = 0.3333331
        pgm_function13[(50, 19, 24)] = 0.30776928
        pgm_function13[(50, 19, 25)] = 0.174417155
        pgm_function13[(50, 19, 26)] = 0.0533
        pgm_function13[(50, 19, 27)] = 0.0044
        pgm_function13[(50, 20, 19)] = 0.0267
        pgm_function13[(50, 20, 20)] = 0.1667
        pgm_function13[(50, 20, 21)] = 0.3189
        pgm_function13[(50, 20, 22)] = 0.3211
        pgm_function13[(50, 20, 23)] = 0.1889
        pgm_function13[(50, 20, 24)] = 0.062206243
        pgm_function13[(50, 20, 25)] = 0.006700675
        pgm_function13[(50, 21, 17)] = 0.02000201
        pgm_function13[(50, 21, 18)] = 0.1433
        pgm_function13[(50, 21, 19)] = 0.3133
        pgm_function13[(50, 21, 20)] = 0.3333
        pgm_function13[(50, 21, 21)] = 0.204440906
        pgm_function13[(50, 21, 22)] = 0.073292781
        pgm_function13[(50, 21, 23)] = 0.01
        pgm_function13[(50, 22, 15)] = 0.0144
        pgm_function13[(50, 22, 16)] = 0.1211
        pgm_function13[(50, 22, 17)] = 0.298870146
        pgm_function13[(50, 22, 18)] = 0.341134041
        pgm_function13[(50, 22, 19)] = 0.217778172
        pgm_function13[(50, 22, 20)] = 0.0856
        pgm_function13[(50, 22, 21)] = 0.0133
        pgm_function13[(50, 23, 13)] = 0.0089
        pgm_function13[(50, 23, 14)] = 0.1044
        pgm_function13[(50, 23, 15)] = 0.2789
        pgm_function13[(50, 23, 16)] = 0.348865101
        pgm_function13[(50, 23, 17)] = 0.23557612
        pgm_function13[(50, 23, 18)] = 0.09999009
        pgm_function13[(50, 23, 19)] = 0.0178
        pgm_function13[(50, 24, 11)] = 0.004400443
        pgm_function13[(50, 24, 12)] = 0.091109149
        pgm_function13[(50, 24, 13)] = 0.256674072
        pgm_function13[(50, 24, 14)] = 0.3533
        pgm_function13[(50, 24, 15)] = 0.25332508
        pgm_function13[(50, 24, 16)] = 0.11221109
        pgm_function13[(50, 24, 17)] = 0.0222
        pgm_function13[(50, 25, 9)] = 0.0022
        pgm_function13[(50, 25, 10)] = 0.0733
        pgm_function13[(50, 25, 11)] = 0.24
        pgm_function13[(50, 25, 12)] = 0.35113514
        pgm_function13[(50, 25, 13)] = 0.2733
        pgm_function13[(50, 25, 14)] = 0.1267
        pgm_function13[(50, 25, 15)] = 0.02889712
        pgm_function13[(50, 26, 7)] = 0.0011
        pgm_function13[(50, 26, 8)] = 0.0567
        pgm_function13[(50, 26, 9)] = 0.2233222
        pgm_function13[(50, 26, 10)] = 0.3422
        pgm_function13[(50, 26, 11)] = 0.2944
        pgm_function13[(50, 26, 12)] = 0.14
        pgm_function13[(50, 26, 13)] = 0.0356
        pgm_function13[(50, 27, 6)] = 0.04440441
        pgm_function13[(50, 27, 7)] = 0.20218008
        pgm_function13[(50, 27, 8)] = 0.34
        pgm_function13[(50, 27, 9)] = 0.3056
        pgm_function13[(50, 27, 10)] = 0.15558405
        pgm_function13[(50, 27, 11)] = 0.04330432
        pgm_function13[(50, 27, 12)] = 0.001100111
        pgm_function13[(50, 28, 4)] = 0.0333
        pgm_function13[(50, 28, 5)] = 0.18001818
        pgm_function13[(50, 28, 6)] = 0.3355663
        pgm_function13[(50, 28, 7)] = 0.3144
        pgm_function13[(50, 28, 8)] = 0.1744171
        pgm_function13[(50, 28, 9)] = 0.0522
        pgm_function13[(50, 28, 10)] = 0.002200221
        pgm_function13[(50, 29, 2)] = 0.02440241
        pgm_function13[(50, 29, 3)] = 0.15888413
        pgm_function13[(50, 29, 4)] = 0.3267
        pgm_function13[(50, 29, 5)] = 0.3311
        pgm_function13[(50, 29, 6)] = 0.190019175
        pgm_function13[(50, 29, 7)] = 0.06110609
        pgm_function13[(50, 29, 8)] = 0.004400878
        pgm_function13[(50, 30, 0)] = 0.02
        pgm_function13[(50, 30, 1)] = 0.14
        pgm_function13[(50, 30, 2)] = 0.308869117
        pgm_function13[(50, 30, 3)] = 0.3433
        pgm_function13[(50, 30, 4)] = 0.2056
        pgm_function13[(50, 30, 5)] = 0.073307318
        pgm_function13[(50, 30, 6)] = 0.007799225
        pgm_function13[(50, 31, 0)] = 0.32
        pgm_function13[(50, 31, 1)] = 0.34563502
        pgm_function13[(50, 31, 2)] = 0.2267
        pgm_function13[(50, 31, 3)] = 0.082191857
        pgm_function13[(50, 31, 4)] = 0.0111011
        pgm_function13[(50, 32, 0)] = 0.2244
        pgm_function13[(50, 32, 1)] = 0.0933
        pgm_function13[(50, 32, 2)] = 0.0167
        pgm_function13[(51, 0, 57)] = 0.00109989
        pgm_function13[(51, 0, 58)] = 0.0611
        pgm_function13[(51, 0, 59)] = 0.246675187
        pgm_function13[(51, 0, 60)] = 0.34003427
        pgm_function13[(51, 1, 56)] = 0.04110412
        pgm_function13[(51, 1, 57)] = 0.1778
        pgm_function13[(51, 1, 58)] = 0.31336268
        pgm_function13[(51, 1, 59)] = 0.304430146
        pgm_function13[(51, 1, 60)] = 0.17671801
        pgm_function13[(51, 2, 54)] = 0.0311
        pgm_function13[(51, 2, 55)] = 0.155584173
        pgm_function13[(51, 2, 56)] = 0.3089
        pgm_function13[(51, 2, 57)] = 0.31333102
        pgm_function13[(51, 2, 58)] = 0.189981146
        pgm_function13[(51, 2, 59)] = 0.0811
        pgm_function13[(51, 2, 60)] = 0.013301298
        pgm_function13[(51, 3, 52)] = 0.0222
        pgm_function13[(51, 3, 53)] = 0.13781408
        pgm_function13[(51, 3, 54)] = 0.29673002
        pgm_function13[(51, 3, 55)] = 0.322232364
        pgm_function13[(51, 3, 56)] = 0.204380096
        pgm_function13[(51, 3, 57)] = 0.091109151
        pgm_function13[(51, 3, 58)] = 0.017798213
        pgm_function13[(51, 4, 50)] = 0.0144014
        pgm_function13[(51, 4, 51)] = 0.1256
        pgm_function13[(51, 4, 52)] = 0.277772181
        pgm_function13[(51, 4, 53)] = 0.333267123
        pgm_function13[(51, 4, 54)] = 0.223345116
        pgm_function13[(51, 4, 55)] = 0.1011
        pgm_function13[(51, 4, 56)] = 0.0233
        pgm_function13[(51, 5, 48)] = 0.010001004
        pgm_function13[(51, 5, 49)] = 0.1033
        pgm_function13[(51, 5, 50)] = 0.263352742
        pgm_function13[(51, 5, 51)] = 0.3356
        pgm_function13[(51, 5, 52)] = 0.24112419
        pgm_function13[(51, 5, 53)] = 0.111111054
        pgm_function13[(51, 5, 54)] = 0.0289
        pgm_function13[(51, 6, 46)] = 0.0067
        pgm_function13[(51, 6, 47)] = 0.086708749
        pgm_function13[(51, 6, 48)] = 0.25002512
        pgm_function13[(51, 6, 49)] = 0.3322
        pgm_function13[(51, 6, 50)] = 0.2578
        pgm_function13[(51, 6, 51)] = 0.1222
        pgm_function13[(51, 6, 52)] = 0.0367
        pgm_function13[(51, 7, 44)] = 0.004400439
        pgm_function13[(51, 7, 45)] = 0.0722
        pgm_function13[(51, 7, 46)] = 0.2311
        pgm_function13[(51, 7, 47)] = 0.3311
        pgm_function13[(51, 7, 48)] = 0.2744
        pgm_function13[(51, 7, 49)] = 0.13438704
        pgm_function13[(51, 7, 50)] = 0.04329575
        pgm_function13[(51, 7, 51)] = 0.001100111
        pgm_function13[(51, 8, 42)] = 0.0011
        pgm_function13[(51, 8, 43)] = 0.06109395
        pgm_function13[(51, 8, 44)] = 0.2089
        pgm_function13[(51, 8, 45)] = 0.3344333
        pgm_function13[(51, 8, 46)] = 0.28557126
        pgm_function13[(51, 8, 47)] = 0.1511
        pgm_function13[(51, 8, 48)] = 0.051105145
        pgm_function13[(51, 8, 49)] = 0.0022
        pgm_function13[(51, 9, 41)] = 0.0489
        pgm_function13[(51, 9, 42)] = 0.19108117
        pgm_function13[(51, 9, 43)] = 0.32556726
        pgm_function13[(51, 9, 44)] = 0.30113009
        pgm_function13[(51, 9, 45)] = 0.16441613
        pgm_function13[(51, 9, 46)] = 0.06
        pgm_function13[(51, 9, 47)] = 0.0044
        pgm_function13[(51, 10, 39)] = 0.0344
        pgm_function13[(51, 10, 40)] = 0.1744
        pgm_function13[(51, 10, 41)] = 0.3167
        pgm_function13[(51, 10, 42)] = 0.3111
        pgm_function13[(51, 10, 43)] = 0.178918086
        pgm_function13[(51, 10, 44)] = 0.067806852
        pgm_function13[(51, 10, 45)] = 0.007798435
        pgm_function13[(51, 11, 37)] = 0.02669731
        pgm_function13[(51, 11, 38)] = 0.1511
        pgm_function13[(51, 11, 39)] = 0.31113109
        pgm_function13[(51, 11, 40)] = 0.32003225
        pgm_function13[(51, 11, 41)] = 0.1978
        pgm_function13[(51, 11, 42)] = 0.0744
        pgm_function13[(51, 11, 43)] = 0.012201197
        pgm_function13[(51, 12, 35)] = 0.0189
        pgm_function13[(51, 12, 36)] = 0.13112596
        pgm_function13[(51, 12, 37)] = 0.3011
        pgm_function13[(51, 12, 38)] = 0.3278
        pgm_function13[(51, 12, 39)] = 0.215621972
        pgm_function13[(51, 12, 40)] = 0.08330829
        pgm_function13[(51, 12, 41)] = 0.0167
        pgm_function13[(51, 13, 33)] = 0.0122
        pgm_function13[(51, 13, 34)] = 0.1133
        pgm_function13[(51, 13, 35)] = 0.282171952
        pgm_function13[(51, 13, 36)] = 0.3356
        pgm_function13[(51, 13, 37)] = 0.2356
        pgm_function13[(51, 13, 38)] = 0.092190893
        pgm_function13[(51, 13, 39)] = 0.0222
        pgm_function13[(51, 14, 31)] = 0.006700676
        pgm_function13[(51, 14, 32)] = 0.098890179
        pgm_function13[(51, 14, 33)] = 0.2622
        pgm_function13[(51, 14, 34)] = 0.347869777
        pgm_function13[(51, 14, 35)] = 0.2456
        pgm_function13[(51, 14, 36)] = 0.1067
        pgm_function13[(51, 14, 37)] = 0.02779721
        pgm_function13[(51, 15, 29)] = 0.0044
        pgm_function13[(51, 15, 30)] = 0.0811
        pgm_function13[(51, 15, 31)] = 0.2456
        pgm_function13[(51, 15, 32)] = 0.34666524
        pgm_function13[(51, 15, 33)] = 0.26
        pgm_function13[(51, 15, 34)] = 0.12
        pgm_function13[(51, 15, 35)] = 0.03330332
        pgm_function13[(51, 16, 27)] = 0.0022
        pgm_function13[(51, 16, 28)] = 0.0667
        pgm_function13[(51, 16, 29)] = 0.22997709
        pgm_function13[(51, 16, 30)] = 0.3411
        pgm_function13[(51, 16, 31)] = 0.28
        pgm_function13[(51, 16, 32)] = 0.1367
        pgm_function13[(51, 16, 33)] = 0.0389
        pgm_function13[(51, 16, 34)] = 0.0011
        pgm_function13[(51, 17, 25)] = 0.0011
        pgm_function13[(51, 17, 26)] = 0.0544
        pgm_function13[(51, 17, 27)] = 0.20672108
        pgm_function13[(51, 17, 28)] = 0.33443327
        pgm_function13[(51, 17, 29)] = 0.2933
        pgm_function13[(51, 17, 30)] = 0.15331515
        pgm_function13[(51, 17, 31)] = 0.0456
        pgm_function13[(51, 17, 32)] = 0.0022
        pgm_function13[(51, 18, 24)] = 0.0433
        pgm_function13[(51, 18, 25)] = 0.18221815
        pgm_function13[(51, 18, 26)] = 0.33443333
        pgm_function13[(51, 18, 27)] = 0.3033
        pgm_function13[(51, 18, 28)] = 0.1711
        pgm_function13[(51, 18, 29)] = 0.053305326
        pgm_function13[(51, 18, 30)] = 0.004400443
        pgm_function13[(51, 19, 22)] = 0.0311
        pgm_function13[(51, 19, 23)] = 0.16561705
        pgm_function13[(51, 19, 24)] = 0.32666729
        pgm_function13[(51, 19, 25)] = 0.31443128
        pgm_function13[(51, 19, 26)] = 0.1867
        pgm_function13[(51, 19, 27)] = 0.0622
        pgm_function13[(51, 19, 28)] = 0.0067
        pgm_function13[(51, 20, 20)] = 0.02
        pgm_function13[(51, 20, 21)] = 0.1511
        pgm_function13[(51, 20, 22)] = 0.3111
        pgm_function13[(51, 20, 23)] = 0.3311
        pgm_function13[(51, 20, 24)] = 0.20222014
        pgm_function13[(51, 20, 25)] = 0.073307351
        pgm_function13[(51, 20, 26)] = 0.01
        pgm_function13[(51, 21, 18)] = 0.0144
        pgm_function13[(51, 21, 19)] = 0.1278
        pgm_function13[(51, 21, 20)] = 0.2956
        pgm_function13[(51, 21, 21)] = 0.343368842
        pgm_function13[(51, 21, 22)] = 0.215578237
        pgm_function13[(51, 21, 23)] = 0.0833
        pgm_function13[(51, 21, 24)] = 0.013301309
        pgm_function13[(51, 22, 16)] = 0.01
        pgm_function13[(51, 22, 17)] = 0.106689052
        pgm_function13[(51, 22, 18)] = 0.284428034
        pgm_function13[(51, 22, 19)] = 0.346665274
        pgm_function13[(51, 22, 20)] = 0.2311
        pgm_function13[(51, 22, 21)] = 0.0956
        pgm_function13[(51, 22, 22)] = 0.0178
        pgm_function13[(51, 23, 14)] = 0.0067
        pgm_function13[(51, 23, 15)] = 0.09
        pgm_function13[(51, 23, 16)] = 0.266673077
        pgm_function13[(51, 23, 17)] = 0.345565176
        pgm_function13[(51, 23, 18)] = 0.24887522
        pgm_function13[(51, 23, 19)] = 0.11
        pgm_function13[(51, 23, 20)] = 0.0222
        pgm_function13[(51, 24, 12)] = 0.002200221
        pgm_function13[(51, 24, 13)] = 0.077792222
        pgm_function13[(51, 24, 14)] = 0.2433
        pgm_function13[(51, 24, 15)] = 0.35113511
        pgm_function13[(51, 24, 16)] = 0.26672721
        pgm_function13[(51, 24, 17)] = 0.1267
        pgm_function13[(51, 24, 18)] = 0.0278
        pgm_function13[(51, 25, 10)] = 0.0011
        pgm_function13[(51, 25, 11)] = 0.0644
        pgm_function13[(51, 25, 12)] = 0.22112209
        pgm_function13[(51, 25, 13)] = 0.3478
        pgm_function13[(51, 25, 14)] = 0.2867
        pgm_function13[(51, 25, 15)] = 0.13888608
        pgm_function13[(51, 25, 16)] = 0.03559642
        pgm_function13[(51, 26, 9)] = 0.04780484
        pgm_function13[(51, 26, 10)] = 0.2056
        pgm_function13[(51, 26, 11)] = 0.3367
        pgm_function13[(51, 26, 12)] = 0.3044
        pgm_function13[(51, 26, 13)] = 0.1522
        pgm_function13[(51, 26, 14)] = 0.04330431
        pgm_function13[(51, 26, 15)] = 0.001100111
        pgm_function13[(51, 27, 7)] = 0.03559641
        pgm_function13[(51, 27, 8)] = 0.1878
        pgm_function13[(51, 27, 9)] = 0.33
        pgm_function13[(51, 27, 10)] = 0.3177681
        pgm_function13[(51, 27, 11)] = 0.17001709
        pgm_function13[(51, 27, 12)] = 0.052205242
        pgm_function13[(51, 27, 13)] = 0.0022
        pgm_function13[(51, 28, 5)] = 0.02670273
        pgm_function13[(51, 28, 6)] = 0.16218415
        pgm_function13[(51, 28, 7)] = 0.3278
        pgm_function13[(51, 28, 8)] = 0.3256332
        pgm_function13[(51, 28, 9)] = 0.1878
        pgm_function13[(51, 28, 10)] = 0.061106115
        pgm_function13[(51, 28, 11)] = 0.0044
        pgm_function13[(51, 29, 3)] = 0.01889812
        pgm_function13[(51, 29, 4)] = 0.14
        pgm_function13[(51, 29, 5)] = 0.3144
        pgm_function13[(51, 29, 6)] = 0.334433308
        pgm_function13[(51, 29, 7)] = 0.206720967
        pgm_function13[(51, 29, 8)] = 0.07111417
        pgm_function13[(51, 29, 9)] = 0.0078
        pgm_function13[(51, 30, 1)] = 0.0111
        pgm_function13[(51, 30, 2)] = 0.123288047
        pgm_function13[(51, 30, 3)] = 0.2989
        pgm_function13[(51, 30, 4)] = 0.3467
        pgm_function13[(51, 30, 5)] = 0.221122053
        pgm_function13[(51, 30, 6)] = 0.081091956
        pgm_function13[(51, 30, 7)] = 0.0111
        pgm_function13[(51, 31, 0)] = 0.1222
        pgm_function13[(51, 31, 1)] = 0.28222802
        pgm_function13[(51, 31, 2)] = 0.3511
        pgm_function13[(51, 31, 3)] = 0.238876165
        pgm_function13[(51, 31, 4)] = 0.09330932
        pgm_function13[(51, 31, 5)] = 0.0167
        pgm_function13[(51, 32, 0)] = 0.3578
        pgm_function13[(51, 32, 1)] = 0.2656
        pgm_function13[(51, 32, 2)] = 0.1033
        pgm_function13[(51, 32, 3)] = 0.0211
        pgm_function13[(52, 0, 59)] = 0.05219484
        pgm_function13[(52, 0, 60)] = 0.23442319
        pgm_function13[(52, 1, 57)] = 0.0322
        pgm_function13[(52, 1, 58)] = 0.164432832
        pgm_function13[(52, 1, 59)] = 0.303330146
        pgm_function13[(52, 1, 60)] = 0.31443102
        pgm_function13[(52, 2, 55)] = 0.024397627
        pgm_function13[(52, 2, 56)] = 0.1411
        pgm_function13[(52, 2, 57)] = 0.29893002
        pgm_function13[(52, 2, 58)] = 0.318868246
        pgm_function13[(52, 2, 59)] = 0.2
        pgm_function13[(52, 2, 60)] = 0.090008987
        pgm_function13[(52, 3, 53)] = 0.01780181
        pgm_function13[(52, 3, 54)] = 0.12331201
        pgm_function13[(52, 3, 55)] = 0.284428321
        pgm_function13[(52, 3, 56)] = 0.325567153
        pgm_function13[(52, 3, 57)] = 0.218922123
        pgm_function13[(52, 3, 58)] = 0.101090073
        pgm_function13[(52, 3, 59)] = 0.0233
        pgm_function13[(52, 4, 51)] = 0.01
        pgm_function13[(52, 4, 52)] = 0.109989071
        pgm_function13[(52, 4, 53)] = 0.265573098
        pgm_function13[(52, 4, 54)] = 0.332266173
        pgm_function13[(52, 4, 55)] = 0.2367
        pgm_function13[(52, 4, 56)] = 0.1111
        pgm_function13[(52, 4, 57)] = 0.02890293
        pgm_function13[(52, 5, 49)] = 0.0067
        pgm_function13[(52, 5, 50)] = 0.094418807
        pgm_function13[(52, 5, 51)] = 0.2456
        pgm_function13[(52, 5, 52)] = 0.334433264
        pgm_function13[(52, 5, 53)] = 0.253325124
        pgm_function13[(52, 5, 54)] = 0.1211
        pgm_function13[(52, 5, 55)] = 0.0356
        pgm_function13[(52, 6, 47)] = 0.004400442
        pgm_function13[(52, 6, 48)] = 0.076707737
        pgm_function13[(52, 6, 49)] = 0.2333
        pgm_function13[(52, 6, 50)] = 0.3311
        pgm_function13[(52, 6, 51)] = 0.2744
        pgm_function13[(52, 6, 52)] = 0.1311
        pgm_function13[(52, 6, 53)] = 0.0433
        pgm_function13[(52, 6, 54)] = 0.0011
        pgm_function13[(52, 7, 45)] = 0.0022
        pgm_function13[(52, 7, 46)] = 0.0622
        pgm_function13[(52, 7, 47)] = 0.22
        pgm_function13[(52, 7, 48)] = 0.3256
        pgm_function13[(52, 7, 49)] = 0.28667109
        pgm_function13[(52, 7, 50)] = 0.14778516
        pgm_function13[(52, 7, 51)] = 0.050005035
        pgm_function13[(52, 7, 52)] = 0.0022
        pgm_function13[(52, 8, 44)] = 0.0511
        pgm_function13[(52, 8, 45)] = 0.19331917
        pgm_function13[(52, 8, 46)] = 0.32556729
        pgm_function13[(52, 8, 47)] = 0.2956
        pgm_function13[(52, 8, 48)] = 0.163316145
        pgm_function13[(52, 8, 49)] = 0.0589
        pgm_function13[(52, 8, 50)] = 0.0044
        pgm_function13[(52, 9, 42)] = 0.03889614
        pgm_function13[(52, 9, 43)] = 0.17558214
        pgm_function13[(52, 9, 44)] = 0.3222321
        pgm_function13[(52, 9, 45)] = 0.30333024
        pgm_function13[(52, 9, 46)] = 0.1778
        pgm_function13[(52, 9, 47)] = 0.0667
        pgm_function13[(52, 9, 48)] = 0.007798437
        pgm_function13[(52, 10, 40)] = 0.0278
        pgm_function13[(52, 10, 41)] = 0.1578
        pgm_function13[(52, 10, 42)] = 0.3111
        pgm_function13[(52, 10, 43)] = 0.317832153
        pgm_function13[(52, 10, 44)] = 0.192219146
        pgm_function13[(52, 10, 45)] = 0.075584847
        pgm_function13[(52, 10, 46)] = 0.0122
        pgm_function13[(52, 11, 38)] = 0.02
        pgm_function13[(52, 11, 39)] = 0.13781404
        pgm_function13[(52, 11, 40)] = 0.300030234
        pgm_function13[(52, 11, 41)] = 0.3278
        pgm_function13[(52, 11, 42)] = 0.2111
        pgm_function13[(52, 11, 43)] = 0.08330828
        pgm_function13[(52, 11, 44)] = 0.016701711
        pgm_function13[(52, 12, 36)] = 0.0133027
        pgm_function13[(52, 12, 37)] = 0.1189
        pgm_function13[(52, 12, 38)] = 0.2844
        pgm_function13[(52, 12, 39)] = 0.332232957
        pgm_function13[(52, 12, 40)] = 0.23002297
        pgm_function13[(52, 12, 41)] = 0.0922
        pgm_function13[(52, 12, 42)] = 0.022202213
        pgm_function13[(52, 13, 34)] = 0.01
        pgm_function13[(52, 13, 35)] = 0.098890083
        pgm_function13[(52, 13, 36)] = 0.2689
        pgm_function13[(52, 13, 37)] = 0.3367
        pgm_function13[(52, 13, 38)] = 0.246675249
        pgm_function13[(52, 13, 39)] = 0.1044
        pgm_function13[(52, 13, 40)] = 0.0278
        pgm_function13[(52, 14, 32)] = 0.004399564
        pgm_function13[(52, 14, 33)] = 0.0867
        pgm_function13[(52, 14, 34)] = 0.244448844
        pgm_function13[(52, 14, 35)] = 0.3456
        pgm_function13[(52, 14, 36)] = 0.2589
        pgm_function13[(52, 14, 37)] = 0.11778805
        pgm_function13[(52, 14, 38)] = 0.0333
        pgm_function13[(52, 15, 30)] = 0.0022
        pgm_function13[(52, 15, 31)] = 0.0722
        pgm_function13[(52, 15, 32)] = 0.22887716
        pgm_function13[(52, 15, 33)] = 0.3467
        pgm_function13[(52, 15, 34)] = 0.2722
        pgm_function13[(52, 15, 35)] = 0.13561407
        pgm_function13[(52, 15, 36)] = 0.0389
        pgm_function13[(52, 15, 37)] = 0.001100111
        pgm_function13[(52, 16, 28)] = 0.0011
        pgm_function13[(52, 16, 29)] = 0.05669432
        pgm_function13[(52, 16, 30)] = 0.2122
        pgm_function13[(52, 16, 31)] = 0.3356
        pgm_function13[(52, 16, 32)] = 0.2878
        pgm_function13[(52, 16, 33)] = 0.1522
        pgm_function13[(52, 16, 34)] = 0.0444
        pgm_function13[(52, 16, 35)] = 0.002200221
        pgm_function13[(52, 17, 27)] = 0.04440442
        pgm_function13[(52, 17, 28)] = 0.19441916
        pgm_function13[(52, 17, 29)] = 0.3278
        pgm_function13[(52, 17, 30)] = 0.3044303
        pgm_function13[(52, 17, 31)] = 0.1656
        pgm_function13[(52, 17, 32)] = 0.0533
        pgm_function13[(52, 17, 33)] = 0.004400442
        pgm_function13[(52, 18, 25)] = 0.03440343
        pgm_function13[(52, 18, 26)] = 0.17001717
        pgm_function13[(52, 18, 27)] = 0.3256
        pgm_function13[(52, 18, 28)] = 0.3111
        pgm_function13[(52, 18, 29)] = 0.182218087
        pgm_function13[(52, 18, 30)] = 0.062206236
        pgm_function13[(52, 18, 31)] = 0.006699331
        pgm_function13[(52, 19, 23)] = 0.02440241
        pgm_function13[(52, 19, 24)] = 0.14668513
        pgm_function13[(52, 19, 25)] = 0.317832283
        pgm_function13[(52, 19, 26)] = 0.3222
        pgm_function13[(52, 19, 27)] = 0.2
        pgm_function13[(52, 19, 28)] = 0.0722
        pgm_function13[(52, 19, 29)] = 0.010001
        pgm_function13[(52, 20, 21)] = 0.0156
        pgm_function13[(52, 20, 22)] = 0.1333
        pgm_function13[(52, 20, 23)] = 0.2978
        pgm_function13[(52, 20, 24)] = 0.338934234
        pgm_function13[(52, 20, 25)] = 0.212221146
        pgm_function13[(52, 20, 26)] = 0.0833
        pgm_function13[(52, 20, 27)] = 0.013301307
        pgm_function13[(52, 21, 19)] = 0.01
        pgm_function13[(52, 21, 20)] = 0.1156
        pgm_function13[(52, 21, 21)] = 0.277855872
        pgm_function13[(52, 21, 22)] = 0.347765383
        pgm_function13[(52, 21, 23)] = 0.2289
        pgm_function13[(52, 21, 24)] = 0.093309364
        pgm_function13[(52, 21, 25)] = 0.0178
        pgm_function13[(52, 22, 17)] = 0.006699333
        pgm_function13[(52, 22, 18)] = 0.094409411
        pgm_function13[(52, 22, 19)] = 0.267773212
        pgm_function13[(52, 22, 20)] = 0.35
        pgm_function13[(52, 22, 21)] = 0.2478
        pgm_function13[(52, 22, 22)] = 0.1078
        pgm_function13[(52, 22, 23)] = 0.02220221
        pgm_function13[(52, 23, 15)] = 0.0044
        pgm_function13[(52, 23, 16)] = 0.076692322
        pgm_function13[(52, 23, 17)] = 0.25437513
        pgm_function13[(52, 23, 18)] = 0.34556531
        pgm_function13[(52, 23, 19)] = 0.2644
        pgm_function13[(52, 23, 20)] = 0.1233
        pgm_function13[(52, 23, 21)] = 0.02780283
        pgm_function13[(52, 24, 13)] = 0.00109989
        pgm_function13[(52, 24, 14)] = 0.0656
        pgm_function13[(52, 24, 15)] = 0.22782307
        pgm_function13[(52, 24, 16)] = 0.34443428
        pgm_function13[(52, 24, 17)] = 0.28
        pgm_function13[(52, 24, 18)] = 0.1378
        pgm_function13[(52, 24, 19)] = 0.03559642
        pgm_function13[(52, 25, 12)] = 0.05330532
        pgm_function13[(52, 25, 13)] = 0.2056
        pgm_function13[(52, 25, 14)] = 0.34
        pgm_function13[(52, 25, 15)] = 0.29557018
        pgm_function13[(52, 25, 16)] = 0.15108509
        pgm_function13[(52, 25, 17)] = 0.04330431
        pgm_function13[(52, 25, 18)] = 0.0011
        pgm_function13[(52, 26, 10)] = 0.04
        pgm_function13[(52, 26, 11)] = 0.1889
        pgm_function13[(52, 26, 12)] = 0.3322
        pgm_function13[(52, 26, 13)] = 0.3133
        pgm_function13[(52, 26, 14)] = 0.16671705
        pgm_function13[(52, 26, 15)] = 0.052205236
        pgm_function13[(52, 26, 16)] = 0.0022
        pgm_function13[(52, 27, 8)] = 0.0267
        pgm_function13[(52, 27, 9)] = 0.17
        pgm_function13[(52, 27, 10)] = 0.3232681
        pgm_function13[(52, 27, 11)] = 0.32673316
        pgm_function13[(52, 27, 12)] = 0.183318147
        pgm_function13[(52, 27, 13)] = 0.0611
        pgm_function13[(52, 27, 14)] = 0.004400441
        pgm_function13[(52, 28, 6)] = 0.01999802
        pgm_function13[(52, 28, 7)] = 0.1467
        pgm_function13[(52, 28, 8)] = 0.31443119
        pgm_function13[(52, 28, 9)] = 0.3333
        pgm_function13[(52, 28, 10)] = 0.202220049
        pgm_function13[(52, 28, 11)] = 0.07
        pgm_function13[(52, 28, 12)] = 0.007799225
        pgm_function13[(52, 29, 4)] = 0.0144
        pgm_function13[(52, 29, 5)] = 0.1233
        pgm_function13[(52, 29, 6)] = 0.30443028
        pgm_function13[(52, 29, 7)] = 0.338933946
        pgm_function13[(52, 29, 8)] = 0.221143907
        pgm_function13[(52, 29, 9)] = 0.0789
        pgm_function13[(52, 29, 10)] = 0.0111
        pgm_function13[(52, 30, 2)] = 0.007799223
        pgm_function13[(52, 30, 3)] = 0.1056
        pgm_function13[(52, 30, 4)] = 0.2856
        pgm_function13[(52, 30, 5)] = 0.347835083
        pgm_function13[(52, 30, 6)] = 0.236676163
        pgm_function13[(52, 30, 7)] = 0.0911
        pgm_function13[(52, 30, 8)] = 0.01669831
        pgm_function13[(52, 31, 0)] = 0.0044
        pgm_function13[(52, 31, 1)] = 0.09110911
        pgm_function13[(52, 31, 2)] = 0.2656
        pgm_function13[(52, 31, 3)] = 0.355564245
        pgm_function13[(52, 31, 4)] = 0.25562605
        pgm_function13[(52, 31, 5)] = 0.1033
        pgm_function13[(52, 31, 6)] = 0.02110211
        pgm_function13[(52, 32, 0)] = 0.2689
        pgm_function13[(52, 32, 1)] = 0.3489
        pgm_function13[(52, 32, 2)] = 0.2756
        pgm_function13[(52, 32, 3)] = 0.1178
        pgm_function13[(52, 32, 4)] = 0.0267
        pgm_function13[(53, 0, 60)] = 0.04000403
        pgm_function13[(53, 1, 58)] = 0.024404875
        pgm_function13[(53, 1, 59)] = 0.151115073
        pgm_function13[(53, 1, 60)] = 0.29332902
        pgm_function13[(53, 2, 56)] = 0.0189
        pgm_function13[(53, 2, 57)] = 0.12891301
        pgm_function13[(53, 2, 58)] = 0.287771222
        pgm_function13[(53, 2, 59)] = 0.3256
        pgm_function13[(53, 2, 60)] = 0.21332097
        pgm_function13[(53, 3, 54)] = 0.0133013
        pgm_function13[(53, 3, 55)] = 0.110011124
        pgm_function13[(53, 3, 56)] = 0.27557213
        pgm_function13[(53, 3, 57)] = 0.324432182
        pgm_function13[(53, 3, 58)] = 0.231077166
        pgm_function13[(53, 3, 59)] = 0.1111
        pgm_function13[(53, 3, 60)] = 0.02889712
        pgm_function13[(53, 4, 52)] = 0.007799225
        pgm_function13[(53, 4, 53)] = 0.095590435
        pgm_function13[(53, 4, 54)] = 0.252250131
        pgm_function13[(53, 4, 55)] = 0.3278
        pgm_function13[(53, 4, 56)] = 0.2489
        pgm_function13[(53, 4, 57)] = 0.12111211
        pgm_function13[(53, 4, 58)] = 0.03559643
        pgm_function13[(53, 5, 50)] = 0.004400876
        pgm_function13[(53, 5, 51)] = 0.0844
        pgm_function13[(53, 5, 52)] = 0.231123183
        pgm_function13[(53, 5, 53)] = 0.332233163
        pgm_function13[(53, 5, 54)] = 0.2656
        pgm_function13[(53, 5, 55)] = 0.1322
        pgm_function13[(53, 5, 56)] = 0.04330432
        pgm_function13[(53, 5, 57)] = 0.0011
        pgm_function13[(53, 6, 48)] = 0.002200221
        pgm_function13[(53, 6, 49)] = 0.0678
        pgm_function13[(53, 6, 50)] = 0.2178
        pgm_function13[(53, 6, 51)] = 0.3267
        pgm_function13[(53, 6, 52)] = 0.2833
        pgm_function13[(53, 6, 53)] = 0.1456
        pgm_function13[(53, 6, 54)] = 0.05
        pgm_function13[(53, 6, 55)] = 0.0022
        pgm_function13[(53, 7, 46)] = 0.0011
        pgm_function13[(53, 7, 47)] = 0.0511
        pgm_function13[(53, 7, 48)] = 0.2022
        pgm_function13[(53, 7, 49)] = 0.3210681
        pgm_function13[(53, 7, 50)] = 0.29557033
        pgm_function13[(53, 7, 51)] = 0.15891611
        pgm_function13[(53, 7, 52)] = 0.0589
        pgm_function13[(53, 7, 53)] = 0.004400443
        pgm_function13[(53, 8, 45)] = 0.04110414
        pgm_function13[(53, 8, 46)] = 0.18218216
        pgm_function13[(53, 8, 47)] = 0.3189
        pgm_function13[(53, 8, 48)] = 0.302230269
        pgm_function13[(53, 8, 49)] = 0.1756
        pgm_function13[(53, 8, 50)] = 0.0656
        pgm_function13[(53, 8, 51)] = 0.0078
        pgm_function13[(53, 9, 43)] = 0.03109692
        pgm_function13[(53, 9, 44)] = 0.15671605
        pgm_function13[(53, 9, 45)] = 0.31673225
        pgm_function13[(53, 9, 46)] = 0.31
        pgm_function13[(53, 9, 47)] = 0.1922
        pgm_function13[(53, 9, 48)] = 0.073285271
        pgm_function13[(53, 9, 49)] = 0.012201198
        pgm_function13[(53, 10, 41)] = 0.0211
        pgm_function13[(53, 10, 42)] = 0.14
        pgm_function13[(53, 10, 43)] = 0.304430146
        pgm_function13[(53, 10, 44)] = 0.323332246
        pgm_function13[(53, 10, 45)] = 0.206658855
        pgm_function13[(53, 10, 46)] = 0.0833
        pgm_function13[(53, 10, 47)] = 0.0167
        pgm_function13[(53, 11, 39)] = 0.0144014
        pgm_function13[(53, 11, 40)] = 0.124412097
        pgm_function13[(53, 11, 41)] = 0.2833
        pgm_function13[(53, 11, 42)] = 0.3311
        pgm_function13[(53, 11, 43)] = 0.223321946
        pgm_function13[(53, 11, 44)] = 0.092209263
        pgm_function13[(53, 11, 45)] = 0.0222
        pgm_function13[(53, 12, 37)] = 0.01
        pgm_function13[(53, 12, 38)] = 0.1056
        pgm_function13[(53, 12, 39)] = 0.270026965
        pgm_function13[(53, 12, 40)] = 0.33563396
        pgm_function13[(53, 12, 41)] = 0.2411
        pgm_function13[(53, 12, 42)] = 0.103310061
        pgm_function13[(53, 12, 43)] = 0.02779723
        pgm_function13[(53, 13, 35)] = 0.006699329
        pgm_function13[(53, 13, 36)] = 0.0889
        pgm_function13[(53, 13, 37)] = 0.2533
        pgm_function13[(53, 13, 38)] = 0.33666634
        pgm_function13[(53, 13, 39)] = 0.2589
        pgm_function13[(53, 13, 40)] = 0.1156
        pgm_function13[(53, 13, 41)] = 0.0333
        pgm_function13[(53, 14, 33)] = 0.0033
        pgm_function13[(53, 14, 34)] = 0.074414852
        pgm_function13[(53, 14, 35)] = 0.2322
        pgm_function13[(53, 14, 36)] = 0.3422
        pgm_function13[(53, 14, 37)] = 0.27217311
        pgm_function13[(53, 14, 38)] = 0.1311
        pgm_function13[(53, 14, 39)] = 0.0389
        pgm_function13[(53, 14, 40)] = 0.0011
        pgm_function13[(53, 15, 31)] = 0.0011
        pgm_function13[(53, 15, 32)] = 0.06109394
        pgm_function13[(53, 15, 33)] = 0.2111
        pgm_function13[(53, 15, 34)] = 0.3422
        pgm_function13[(53, 15, 35)] = 0.28112814
        pgm_function13[(53, 15, 36)] = 0.15
        pgm_function13[(53, 15, 37)] = 0.044404422
        pgm_function13[(53, 15, 38)] = 0.0022
        pgm_function13[(53, 16, 30)] = 0.0478
        pgm_function13[(53, 16, 31)] = 0.1944
        pgm_function13[(53, 16, 32)] = 0.3322
        pgm_function13[(53, 16, 33)] = 0.2956
        pgm_function13[(53, 16, 34)] = 0.1656
        pgm_function13[(53, 16, 35)] = 0.052205215
        pgm_function13[(53, 16, 36)] = 0.0044
        pgm_function13[(53, 17, 28)] = 0.03440343
        pgm_function13[(53, 17, 29)] = 0.1789
        pgm_function13[(53, 17, 30)] = 0.32113232
        pgm_function13[(53, 17, 31)] = 0.3122
        pgm_function13[(53, 17, 32)] = 0.1789
        pgm_function13[(53, 17, 33)] = 0.061106128
        pgm_function13[(53, 17, 34)] = 0.0067
        pgm_function13[(53, 18, 26)] = 0.02670273
        pgm_function13[(53, 18, 27)] = 0.1544
        pgm_function13[(53, 18, 28)] = 0.3167
        pgm_function13[(53, 18, 29)] = 0.323332155
        pgm_function13[(53, 18, 30)] = 0.193319112
        pgm_function13[(53, 18, 31)] = 0.072192809
        pgm_function13[(53, 18, 32)] = 0.010002005
        pgm_function13[(53, 19, 24)] = 0.01999802
        pgm_function13[(53, 19, 25)] = 0.132213118
        pgm_function13[(53, 19, 26)] = 0.3067
        pgm_function13[(53, 19, 27)] = 0.3289
        pgm_function13[(53, 19, 28)] = 0.21
        pgm_function13[(53, 19, 29)] = 0.08330831
        pgm_function13[(53, 19, 30)] = 0.0133027
        pgm_function13[(53, 20, 22)] = 0.0111
        pgm_function13[(53, 20, 23)] = 0.1167
        pgm_function13[(53, 20, 24)] = 0.283328195
        pgm_function13[(53, 20, 25)] = 0.341134235
        pgm_function13[(53, 20, 26)] = 0.2267
        pgm_function13[(53, 20, 27)] = 0.093309346
        pgm_function13[(53, 20, 28)] = 0.01779639
        pgm_function13[(53, 21, 20)] = 0.0067
        pgm_function13[(53, 21, 21)] = 0.102219953
        pgm_function13[(53, 21, 22)] = 0.265573292
        pgm_function13[(53, 21, 23)] = 0.35
        pgm_function13[(53, 21, 24)] = 0.243324168
        pgm_function13[(53, 21, 25)] = 0.1067
        pgm_function13[(53, 21, 26)] = 0.02220221
        pgm_function13[(53, 22, 18)] = 0.004400441
        pgm_function13[(53, 22, 19)] = 0.083291766
        pgm_function13[(53, 22, 20)] = 0.25
        pgm_function13[(53, 22, 21)] = 0.3489
        pgm_function13[(53, 22, 22)] = 0.2589
        pgm_function13[(53, 22, 23)] = 0.12111206
        pgm_function13[(53, 22, 24)] = 0.0278
        pgm_function13[(53, 23, 16)] = 0.002199781
        pgm_function13[(53, 23, 17)] = 0.066693334
        pgm_function13[(53, 23, 18)] = 0.23667621
        pgm_function13[(53, 23, 19)] = 0.3411
        pgm_function13[(53, 23, 20)] = 0.2778
        pgm_function13[(53, 23, 21)] = 0.13441316
        pgm_function13[(53, 23, 22)] = 0.03559641
        pgm_function13[(53, 24, 14)] = 0.0011
        pgm_function13[(53, 24, 15)] = 0.05440542
        pgm_function13[(53, 24, 16)] = 0.21442117
        pgm_function13[(53, 24, 17)] = 0.3367
        pgm_function13[(53, 24, 18)] = 0.2933
        pgm_function13[(53, 24, 19)] = 0.1488851
        pgm_function13[(53, 24, 20)] = 0.0422
        pgm_function13[(53, 24, 21)] = 0.0011
        pgm_function13[(53, 25, 13)] = 0.0433
        pgm_function13[(53, 25, 14)] = 0.19
        pgm_function13[(53, 25, 15)] = 0.3343672
        pgm_function13[(53, 25, 16)] = 0.30886919
        pgm_function13[(53, 25, 17)] = 0.16331605
        pgm_function13[(53, 25, 18)] = 0.0522
        pgm_function13[(53, 25, 19)] = 0.002200222
        pgm_function13[(53, 26, 11)] = 0.0311
        pgm_function13[(53, 26, 12)] = 0.1689
        pgm_function13[(53, 26, 13)] = 0.3278
        pgm_function13[(53, 26, 14)] = 0.3211321
        pgm_function13[(53, 26, 15)] = 0.181118125
        pgm_function13[(53, 26, 16)] = 0.0611
        pgm_function13[(53, 26, 17)] = 0.004400439
        pgm_function13[(53, 27, 9)] = 0.0211
        pgm_function13[(53, 27, 10)] = 0.15108505
        pgm_function13[(53, 27, 11)] = 0.31333116
        pgm_function13[(53, 27, 12)] = 0.331133265
        pgm_function13[(53, 27, 13)] = 0.1978
        pgm_function13[(53, 27, 14)] = 0.070007015
        pgm_function13[(53, 27, 15)] = 0.006699334
        pgm_function13[(53, 28, 7)] = 0.0144
        pgm_function13[(53, 28, 8)] = 0.13111308
        pgm_function13[(53, 28, 9)] = 0.3011
        pgm_function13[(53, 28, 10)] = 0.341134082
        pgm_function13[(53, 28, 11)] = 0.2156
        pgm_function13[(53, 28, 12)] = 0.078892147
        pgm_function13[(53, 28, 13)] = 0.011098907
        pgm_function13[(53, 29, 5)] = 0.01
        pgm_function13[(53, 29, 6)] = 0.110011101
        pgm_function13[(53, 29, 7)] = 0.292228953
        pgm_function13[(53, 29, 8)] = 0.343368856
        pgm_function13[(53, 29, 9)] = 0.2367
        pgm_function13[(53, 29, 10)] = 0.0878
        pgm_function13[(53, 29, 11)] = 0.01559841
        pgm_function13[(53, 30, 3)] = 0.0067
        pgm_function13[(53, 30, 4)] = 0.0911
        pgm_function13[(53, 30, 5)] = 0.273327066
        pgm_function13[(53, 30, 6)] = 0.349965241
        pgm_function13[(53, 30, 7)] = 0.2544
        pgm_function13[(53, 30, 8)] = 0.09999005
        pgm_function13[(53, 30, 9)] = 0.02110212
        pgm_function13[(53, 31, 1)] = 0.00220022
        pgm_function13[(53, 31, 2)] = 0.0778
        pgm_function13[(53, 31, 3)] = 0.248875172
        pgm_function13[(53, 31, 4)] = 0.35333507
        pgm_function13[(53, 31, 5)] = 0.2667
        pgm_function13[(53, 31, 6)] = 0.11671206
        pgm_function13[(53, 31, 7)] = 0.0267
        pgm_function13[(53, 32, 0)] = 0.0767
        pgm_function13[(53, 32, 1)] = 0.2278
        pgm_function13[(53, 32, 2)] = 0.35
        pgm_function13[(53, 32, 3)] = 0.2856
        pgm_function13[(53, 32, 4)] = 0.1311
        pgm_function13[(53, 32, 5)] = 0.0333
        pgm_function13[(54, 1, 59)] = 0.018901909
        pgm_function13[(54, 1, 60)] = 0.13561401
        pgm_function13[(54, 2, 57)] = 0.0133013
        pgm_function13[(54, 2, 58)] = 0.115588089
        pgm_function13[(54, 2, 59)] = 0.2733
        pgm_function13[(54, 2, 60)] = 0.328932954
        pgm_function13[(54, 3, 55)] = 0.010001011
        pgm_function13[(54, 3, 56)] = 0.096690345
        pgm_function13[(54, 3, 57)] = 0.262226147
        pgm_function13[(54, 3, 58)] = 0.325567234
        pgm_function13[(54, 3, 59)] = 0.2422
        pgm_function13[(54, 3, 60)] = 0.11888807
        pgm_function13[(54, 4, 53)] = 0.006699332
        pgm_function13[(54, 4, 54)] = 0.083316743
        pgm_function13[(54, 4, 55)] = 0.2422
        pgm_function13[(54, 4, 56)] = 0.3256
        pgm_function13[(54, 4, 57)] = 0.26112624
        pgm_function13[(54, 4, 58)] = 0.13108712
        pgm_function13[(54, 4, 59)] = 0.04330435
        pgm_function13[(54, 4, 60)] = 0.0011
        pgm_function13[(54, 5, 51)] = 0.0022
        pgm_function13[(54, 5, 52)] = 0.073307358
        pgm_function13[(54, 5, 53)] = 0.217822107
        pgm_function13[(54, 5, 54)] = 0.3289
        pgm_function13[(54, 5, 55)] = 0.2778
        pgm_function13[(54, 5, 56)] = 0.14441407
        pgm_function13[(54, 5, 57)] = 0.05
        pgm_function13[(54, 5, 58)] = 0.0022
        pgm_function13[(54, 6, 49)] = 0.0011
        pgm_function13[(54, 6, 50)] = 0.0578
        pgm_function13[(54, 6, 51)] = 0.1978
        pgm_function13[(54, 6, 52)] = 0.3256
        pgm_function13[(54, 6, 53)] = 0.29
        pgm_function13[(54, 6, 54)] = 0.1567
        pgm_function13[(54, 6, 55)] = 0.0589
        pgm_function13[(54, 6, 56)] = 0.0044
        pgm_function13[(54, 7, 48)] = 0.0433
        pgm_function13[(54, 7, 49)] = 0.18558106
        pgm_function13[(54, 7, 50)] = 0.31556835
        pgm_function13[(54, 7, 51)] = 0.302230209
        pgm_function13[(54, 7, 52)] = 0.1722
        pgm_function13[(54, 7, 53)] = 0.065606643
        pgm_function13[(54, 7, 54)] = 0.0078
        pgm_function13[(54, 8, 46)] = 0.03219683
        pgm_function13[(54, 8, 47)] = 0.1667
        pgm_function13[(54, 8, 48)] = 0.312231278
        pgm_function13[(54, 8, 49)] = 0.3111
        pgm_function13[(54, 8, 50)] = 0.1878
        pgm_function13[(54, 8, 51)] = 0.0733
        pgm_function13[(54, 8, 52)] = 0.0122
        pgm_function13[(54, 9, 44)] = 0.02440241
        pgm_function13[(54, 9, 45)] = 0.143314113
        pgm_function13[(54, 9, 46)] = 0.3078
        pgm_function13[(54, 9, 47)] = 0.3167
        pgm_function13[(54, 9, 48)] = 0.205558918
        pgm_function13[(54, 9, 49)] = 0.081108089
        pgm_function13[(54, 9, 50)] = 0.016701713
        pgm_function13[(54, 10, 42)] = 0.0178
        pgm_function13[(54, 10, 43)] = 0.123312059
        pgm_function13[(54, 10, 44)] = 0.292229222
        pgm_function13[(54, 10, 45)] = 0.326634771
        pgm_function13[(54, 10, 46)] = 0.22
        pgm_function13[(54, 10, 47)] = 0.0911
        pgm_function13[(54, 10, 48)] = 0.0211
        pgm_function13[(54, 11, 40)] = 0.010001008
        pgm_function13[(54, 11, 41)] = 0.1111
        pgm_function13[(54, 11, 42)] = 0.2722
        pgm_function13[(54, 11, 43)] = 0.335633919
        pgm_function13[(54, 11, 44)] = 0.234423159
        pgm_function13[(54, 11, 45)] = 0.1033
        pgm_function13[(54, 11, 46)] = 0.0278
        pgm_function13[(54, 12, 38)] = 0.0067
        pgm_function13[(54, 12, 39)] = 0.094409388
        pgm_function13[(54, 12, 40)] = 0.25222497
        pgm_function13[(54, 12, 41)] = 0.34
        pgm_function13[(54, 12, 42)] = 0.251125148
        pgm_function13[(54, 12, 43)] = 0.1155881
        pgm_function13[(54, 12, 44)] = 0.03330332
        pgm_function13[(54, 13, 36)] = 0.0044
        pgm_function13[(54, 13, 37)] = 0.0767
        pgm_function13[(54, 13, 38)] = 0.236676239
        pgm_function13[(54, 13, 39)] = 0.3378
        pgm_function13[(54, 13, 40)] = 0.27
        pgm_function13[(54, 13, 41)] = 0.1289
        pgm_function13[(54, 13, 42)] = 0.0389
        pgm_function13[(54, 13, 43)] = 0.0011
        pgm_function13[(54, 14, 34)] = 0.002200439
        pgm_function13[(54, 14, 35)] = 0.0633
        pgm_function13[(54, 14, 36)] = 0.2167
        pgm_function13[(54, 14, 37)] = 0.33556613
        pgm_function13[(54, 14, 38)] = 0.2844
        pgm_function13[(54, 14, 39)] = 0.1456
        pgm_function13[(54, 14, 40)] = 0.0444
        pgm_function13[(54, 14, 41)] = 0.0022
        pgm_function13[(54, 15, 33)] = 0.0511
        pgm_function13[(54, 15, 34)] = 0.1956
        pgm_function13[(54, 15, 35)] = 0.33443317
        pgm_function13[(54, 15, 36)] = 0.2922
        pgm_function13[(54, 15, 37)] = 0.162216079
        pgm_function13[(54, 15, 38)] = 0.0511
        pgm_function13[(54, 15, 39)] = 0.004400442
        pgm_function13[(54, 16, 31)] = 0.0389
        pgm_function13[(54, 16, 32)] = 0.1789
        pgm_function13[(54, 16, 33)] = 0.3289
        pgm_function13[(54, 16, 34)] = 0.3044
        pgm_function13[(54, 16, 35)] = 0.17891805
        pgm_function13[(54, 16, 36)] = 0.06
        pgm_function13[(54, 16, 37)] = 0.006699332
        pgm_function13[(54, 17, 29)] = 0.0278
        pgm_function13[(54, 17, 30)] = 0.16111616
        pgm_function13[(54, 17, 31)] = 0.3144
        pgm_function13[(54, 17, 32)] = 0.32
        pgm_function13[(54, 17, 33)] = 0.191119088
        pgm_function13[(54, 17, 34)] = 0.07
        pgm_function13[(54, 17, 35)] = 0.01
        pgm_function13[(54, 18, 27)] = 0.02
        pgm_function13[(54, 18, 28)] = 0.14
        pgm_function13[(54, 18, 29)] = 0.302230145
        pgm_function13[(54, 18, 30)] = 0.331133192
        pgm_function13[(54, 18, 31)] = 0.203280026
        pgm_function13[(54, 18, 32)] = 0.083316743
        pgm_function13[(54, 18, 33)] = 0.0133013
        pgm_function13[(54, 19, 25)] = 0.014401413
        pgm_function13[(54, 19, 26)] = 0.1189
        pgm_function13[(54, 19, 27)] = 0.29
        pgm_function13[(54, 19, 28)] = 0.3367
        pgm_function13[(54, 19, 29)] = 0.22002204
        pgm_function13[(54, 19, 30)] = 0.09331867
        pgm_function13[(54, 19, 31)] = 0.0178
        pgm_function13[(54, 20, 23)] = 0.01
        pgm_function13[(54, 20, 24)] = 0.102210071
        pgm_function13[(54, 20, 25)] = 0.273327189
        pgm_function13[(54, 20, 26)] = 0.3411
        pgm_function13[(54, 20, 27)] = 0.240024118
        pgm_function13[(54, 20, 28)] = 0.10557894
        pgm_function13[(54, 20, 29)] = 0.0222
        pgm_function13[(54, 21, 21)] = 0.004400878
        pgm_function13[(54, 21, 22)] = 0.087791297
        pgm_function13[(54, 21, 23)] = 0.25
        pgm_function13[(54, 21, 24)] = 0.348935241
        pgm_function13[(54, 21, 25)] = 0.2578
        pgm_function13[(54, 21, 26)] = 0.11891205
        pgm_function13[(54, 21, 27)] = 0.02779721
        pgm_function13[(54, 22, 19)] = 0.002199782
        pgm_function13[(54, 22, 20)] = 0.0722
        pgm_function13[(54, 22, 21)] = 0.2311
        pgm_function13[(54, 22, 22)] = 0.3489
        pgm_function13[(54, 22, 23)] = 0.27112714
        pgm_function13[(54, 22, 24)] = 0.1322
        pgm_function13[(54, 22, 25)] = 0.03440343
        pgm_function13[(54, 23, 17)] = 0.001099891
        pgm_function13[(54, 23, 18)] = 0.05559445
        pgm_function13[(54, 23, 19)] = 0.2189
        pgm_function13[(54, 23, 20)] = 0.3367
        pgm_function13[(54, 23, 21)] = 0.29112935
        pgm_function13[(54, 23, 22)] = 0.14558503
        pgm_function13[(54, 23, 23)] = 0.0422
        pgm_function13[(54, 23, 24)] = 0.001100111
        pgm_function13[(54, 24, 16)] = 0.04440444
        pgm_function13[(54, 24, 17)] = 0.2
        pgm_function13[(54, 24, 18)] = 0.33
        pgm_function13[(54, 24, 19)] = 0.30666921
        pgm_function13[(54, 24, 20)] = 0.16
        pgm_function13[(54, 24, 21)] = 0.05
        pgm_function13[(54, 24, 22)] = 0.0022
        pgm_function13[(54, 25, 14)] = 0.0344
        pgm_function13[(54, 25, 15)] = 0.17558211
        pgm_function13[(54, 25, 16)] = 0.3255672
        pgm_function13[(54, 25, 17)] = 0.3178321
        pgm_function13[(54, 25, 18)] = 0.1767
        pgm_function13[(54, 25, 19)] = 0.061106155
        pgm_function13[(54, 25, 20)] = 0.0044
        pgm_function13[(54, 26, 12)] = 0.0256
        pgm_function13[(54, 26, 13)] = 0.1511
        pgm_function13[(54, 26, 14)] = 0.3200321
        pgm_function13[(54, 26, 15)] = 0.324432224
        pgm_function13[(54, 26, 16)] = 0.1944
        pgm_function13[(54, 26, 17)] = 0.07000698
        pgm_function13[(54, 26, 18)] = 0.0067
        pgm_function13[(54, 27, 10)] = 0.01669831
        pgm_function13[(54, 27, 11)] = 0.13441307
        pgm_function13[(54, 27, 12)] = 0.304430244
        pgm_function13[(54, 27, 13)] = 0.3367
        pgm_function13[(54, 27, 14)] = 0.211121046
        pgm_function13[(54, 27, 15)] = 0.079992047
        pgm_function13[(54, 27, 16)] = 0.0111
        pgm_function13[(54, 28, 8)] = 0.01000101
        pgm_function13[(54, 28, 9)] = 0.1178
        pgm_function13[(54, 28, 10)] = 0.285629069
        pgm_function13[(54, 28, 11)] = 0.3456
        pgm_function13[(54, 28, 12)] = 0.232177139
        pgm_function13[(54, 28, 13)] = 0.087791254
        pgm_function13[(54, 28, 14)] = 0.0156
        pgm_function13[(54, 29, 6)] = 0.006700676
        pgm_function13[(54, 29, 7)] = 0.094409385
        pgm_function13[(54, 29, 8)] = 0.273354885
        pgm_function13[(54, 29, 9)] = 0.3478
        pgm_function13[(54, 29, 10)] = 0.2522
        pgm_function13[(54, 29, 11)] = 0.09889019
        pgm_function13[(54, 29, 12)] = 0.0211
        pgm_function13[(54, 30, 4)] = 0.0044
        pgm_function13[(54, 30, 5)] = 0.077807819
        pgm_function13[(54, 30, 6)] = 0.256674177
        pgm_function13[(54, 30, 7)] = 0.3478
        pgm_function13[(54, 30, 8)] = 0.26777313
        pgm_function13[(54, 30, 9)] = 0.1122111
        pgm_function13[(54, 30, 10)] = 0.02670273
        pgm_function13[(54, 31, 2)] = 0.0011
        pgm_function13[(54, 31, 3)] = 0.065593445
        pgm_function13[(54, 31, 4)] = 0.23222305
        pgm_function13[(54, 31, 5)] = 0.3511
        pgm_function13[(54, 31, 6)] = 0.28112814
        pgm_function13[(54, 31, 7)] = 0.1278
        pgm_function13[(54, 31, 8)] = 0.0333
        pgm_function13[(54, 32, 1)] = 0.0533
        pgm_function13[(54, 32, 2)] = 0.2111
        pgm_function13[(54, 32, 3)] = 0.3511
        pgm_function13[(54, 32, 4)] = 0.2944
        pgm_function13[(54, 32, 5)] = 0.1478
        pgm_function13[(54, 32, 6)] = 0.03890393
        pgm_function13[(54, 32, 7)] = 0.0011
        pgm_function13[(55, 1, 60)] = 0.0144014
        pgm_function13[(55, 2, 58)] = 0.009999008
        pgm_function13[(55, 2, 59)] = 0.1033
        pgm_function13[(55, 2, 60)] = 0.255625964
        pgm_function13[(55, 3, 56)] = 0.006699333
        pgm_function13[(55, 3, 57)] = 0.085608648
        pgm_function13[(55, 3, 58)] = 0.245575177
        pgm_function13[(55, 3, 59)] = 0.3278
        pgm_function13[(55, 3, 60)] = 0.25667415
        pgm_function13[(55, 4, 54)] = 0.004400882
        pgm_function13[(55, 4, 55)] = 0.0722
        pgm_function13[(55, 4, 56)] = 0.2278
        pgm_function13[(55, 4, 57)] = 0.32223229
        pgm_function13[(55, 4, 58)] = 0.27557225
        pgm_function13[(55, 4, 59)] = 0.14111416
        pgm_function13[(55, 4, 60)] = 0.05
        pgm_function13[(55, 5, 52)] = 0.001100111
        pgm_function13[(55, 5, 53)] = 0.06110613
        pgm_function13[(55, 5, 54)] = 0.2044
        pgm_function13[(55, 5, 55)] = 0.3211
        pgm_function13[(55, 5, 56)] = 0.28562914
        pgm_function13[(55, 5, 57)] = 0.1544
        pgm_function13[(55, 5, 58)] = 0.0578
        pgm_function13[(55, 5, 59)] = 0.0044
        pgm_function13[(55, 6, 51)] = 0.05
        pgm_function13[(55, 6, 52)] = 0.1833
        pgm_function13[(55, 6, 53)] = 0.3211
        pgm_function13[(55, 6, 54)] = 0.2967
        pgm_function13[(55, 6, 55)] = 0.17
        pgm_function13[(55, 6, 56)] = 0.0656
        pgm_function13[(55, 6, 57)] = 0.007800787
        pgm_function13[(55, 7, 49)] = 0.03559641
        pgm_function13[(55, 7, 50)] = 0.16998319
        pgm_function13[(55, 7, 51)] = 0.313331216
        pgm_function13[(55, 7, 52)] = 0.3078
        pgm_function13[(55, 7, 53)] = 0.184418122
        pgm_function13[(55, 7, 54)] = 0.0733
        pgm_function13[(55, 7, 55)] = 0.0111
        pgm_function13[(55, 8, 47)] = 0.0244
        pgm_function13[(55, 8, 48)] = 0.151115134
        pgm_function13[(55, 8, 49)] = 0.3011
        pgm_function13[(55, 8, 50)] = 0.3189
        pgm_function13[(55, 8, 51)] = 0.2022
        pgm_function13[(55, 8, 52)] = 0.08
        pgm_function13[(55, 8, 53)] = 0.0167
        pgm_function13[(55, 9, 45)] = 0.018901915
        pgm_function13[(55, 9, 46)] = 0.1289
        pgm_function13[(55, 9, 47)] = 0.2922
        pgm_function13[(55, 9, 48)] = 0.32553487
        pgm_function13[(55, 9, 49)] = 0.21782197
        pgm_function13[(55, 9, 50)] = 0.088908968
        pgm_function13[(55, 9, 51)] = 0.0211
        pgm_function13[(55, 10, 43)] = 0.013301306
        pgm_function13[(55, 10, 44)] = 0.110011084
        pgm_function13[(55, 10, 45)] = 0.279943804
        pgm_function13[(55, 10, 46)] = 0.3278
        pgm_function13[(55, 10, 47)] = 0.2322
        pgm_function13[(55, 10, 48)] = 0.1011
        pgm_function13[(55, 10, 49)] = 0.02779722
        pgm_function13[(55, 11, 41)] = 0.0078
        pgm_function13[(55, 11, 42)] = 0.0967
        pgm_function13[(55, 11, 43)] = 0.257825938
        pgm_function13[(55, 11, 44)] = 0.33893423
        pgm_function13[(55, 11, 45)] = 0.2467
        pgm_function13[(55, 11, 46)] = 0.1144
        pgm_function13[(55, 11, 47)] = 0.0333
        pgm_function13[(55, 12, 39)] = 0.004400439
        pgm_function13[(55, 12, 40)] = 0.08440839
        pgm_function13[(55, 12, 41)] = 0.2356
        pgm_function13[(55, 12, 42)] = 0.341134201
        pgm_function13[(55, 12, 43)] = 0.26217424
        pgm_function13[(55, 12, 44)] = 0.12781308
        pgm_function13[(55, 12, 45)] = 0.03890394
        pgm_function13[(55, 12, 46)] = 0.00110011
        pgm_function13[(55, 13, 37)] = 0.0022
        pgm_function13[(55, 13, 38)] = 0.06889317
        pgm_function13[(55, 13, 39)] = 0.2178
        pgm_function13[(55, 13, 40)] = 0.3344
        pgm_function13[(55, 13, 41)] = 0.28
        pgm_function13[(55, 13, 42)] = 0.1444
        pgm_function13[(55, 13, 43)] = 0.0444
        pgm_function13[(55, 13, 44)] = 0.0022
        pgm_function13[(55, 14, 35)] = 0.0011
        pgm_function13[(55, 14, 36)] = 0.0533
        pgm_function13[(55, 14, 37)] = 0.20108008
        pgm_function13[(55, 14, 38)] = 0.3278
        pgm_function13[(55, 14, 39)] = 0.2944
        pgm_function13[(55, 14, 40)] = 0.1578
        pgm_function13[(55, 14, 41)] = 0.0511
        pgm_function13[(55, 14, 42)] = 0.004400442
        pgm_function13[(55, 15, 34)] = 0.0422
        pgm_function13[(55, 15, 35)] = 0.18331809
        pgm_function13[(55, 15, 36)] = 0.3244
        pgm_function13[(55, 15, 37)] = 0.303330149
        pgm_function13[(55, 15, 38)] = 0.1756
        pgm_function13[(55, 15, 39)] = 0.060006028
        pgm_function13[(55, 15, 40)] = 0.006699333
        pgm_function13[(55, 16, 32)] = 0.0311
        pgm_function13[(55, 16, 33)] = 0.16
        pgm_function13[(55, 16, 34)] = 0.32
        pgm_function13[(55, 16, 35)] = 0.312231087
        pgm_function13[(55, 16, 36)] = 0.1911
        pgm_function13[(55, 16, 37)] = 0.068893117
        pgm_function13[(55, 16, 38)] = 0.01
        pgm_function13[(55, 17, 30)] = 0.02110212
        pgm_function13[(55, 17, 31)] = 0.1444
        pgm_function13[(55, 17, 32)] = 0.3056
        pgm_function13[(55, 17, 33)] = 0.32673315
        pgm_function13[(55, 17, 34)] = 0.2033
        pgm_function13[(55, 17, 35)] = 0.08
        pgm_function13[(55, 17, 36)] = 0.0133
        pgm_function13[(55, 18, 28)] = 0.0144
        pgm_function13[(55, 18, 29)] = 0.126713061
        pgm_function13[(55, 18, 30)] = 0.287829167
        pgm_function13[(55, 18, 31)] = 0.339966044
        pgm_function13[(55, 18, 32)] = 0.213343111
        pgm_function13[(55, 18, 33)] = 0.0922092
        pgm_function13[(55, 18, 34)] = 0.017801816
        pgm_function13[(55, 19, 26)] = 0.01
        pgm_function13[(55, 19, 27)] = 0.1078
        pgm_function13[(55, 19, 28)] = 0.2756
        pgm_function13[(55, 19, 29)] = 0.34223406
        pgm_function13[(55, 19, 30)] = 0.23334693
        pgm_function13[(55, 19, 31)] = 0.1044
        pgm_function13[(55, 19, 32)] = 0.0222
        pgm_function13[(55, 20, 24)] = 0.006700675
        pgm_function13[(55, 20, 25)] = 0.088908961
        pgm_function13[(55, 20, 26)] = 0.2589
        pgm_function13[(55, 20, 27)] = 0.340034167
        pgm_function13[(55, 20, 28)] = 0.25554885
        pgm_function13[(55, 20, 29)] = 0.1178
        pgm_function13[(55, 20, 30)] = 0.0278
        pgm_function13[(55, 21, 22)] = 0.003299674
        pgm_function13[(55, 21, 23)] = 0.0756
        pgm_function13[(55, 21, 24)] = 0.234423162
        pgm_function13[(55, 21, 25)] = 0.3411
        pgm_function13[(55, 21, 26)] = 0.27002711
        pgm_function13[(55, 21, 27)] = 0.12998705
        pgm_function13[(55, 21, 28)] = 0.0344
        pgm_function13[(55, 22, 20)] = 0.0011
        pgm_function13[(55, 22, 21)] = 0.0633
        pgm_function13[(55, 22, 22)] = 0.2133
        pgm_function13[(55, 22, 23)] = 0.34333417
        pgm_function13[(55, 22, 24)] = 0.2856
        pgm_function13[(55, 22, 25)] = 0.14441413
        pgm_function13[(55, 22, 26)] = 0.04219585
        pgm_function13[(55, 22, 27)] = 0.0011
        pgm_function13[(55, 23, 19)] = 0.0478
        pgm_function13[(55, 23, 20)] = 0.2022
        pgm_function13[(55, 23, 21)] = 0.3322334
        pgm_function13[(55, 23, 22)] = 0.30327006
        pgm_function13[(55, 23, 23)] = 0.1578
        pgm_function13[(55, 23, 24)] = 0.050005025
        pgm_function13[(55, 23, 25)] = 0.0022
        pgm_function13[(55, 24, 17)] = 0.0344
        pgm_function13[(55, 24, 18)] = 0.1833
        pgm_function13[(55, 24, 19)] = 0.32216823
        pgm_function13[(55, 24, 20)] = 0.3178
        pgm_function13[(55, 24, 21)] = 0.1756
        pgm_function13[(55, 24, 22)] = 0.0589
        pgm_function13[(55, 24, 23)] = 0.0044
        pgm_function13[(55, 25, 15)] = 0.02669732
        pgm_function13[(55, 25, 16)] = 0.1588841
        pgm_function13[(55, 25, 17)] = 0.3178321
        pgm_function13[(55, 25, 18)] = 0.3244
        pgm_function13[(55, 25, 19)] = 0.18891917
        pgm_function13[(55, 25, 20)] = 0.0689
        pgm_function13[(55, 25, 21)] = 0.0067
        pgm_function13[(55, 26, 13)] = 0.02
        pgm_function13[(55, 26, 14)] = 0.13441304
        pgm_function13[(55, 26, 15)] = 0.310031214
        pgm_function13[(55, 26, 16)] = 0.3289
        pgm_function13[(55, 26, 17)] = 0.206720942
        pgm_function13[(55, 26, 18)] = 0.08
        pgm_function13[(55, 26, 19)] = 0.0111
        pgm_function13[(55, 27, 11)] = 0.01220121
        pgm_function13[(55, 27, 12)] = 0.118912095
        pgm_function13[(55, 27, 13)] = 0.2933
        pgm_function13[(55, 27, 14)] = 0.340034075
        pgm_function13[(55, 27, 15)] = 0.227777134
        pgm_function13[(55, 27, 16)] = 0.0878
        pgm_function13[(55, 27, 17)] = 0.0155984
        pgm_function13[(55, 28, 9)] = 0.0067
        pgm_function13[(55, 28, 10)] = 0.103310025
        pgm_function13[(55, 28, 11)] = 0.2711
        pgm_function13[(55, 28, 12)] = 0.346665208
        pgm_function13[(55, 28, 13)] = 0.24557515
        pgm_function13[(55, 28, 14)] = 0.0989
        pgm_function13[(55, 28, 15)] = 0.02110211
        pgm_function13[(55, 29, 7)] = 0.004400439
        pgm_function13[(55, 29, 8)] = 0.084416865
        pgm_function13[(55, 29, 9)] = 0.2533
        pgm_function13[(55, 29, 10)] = 0.3489
        pgm_function13[(55, 29, 11)] = 0.26557324
        pgm_function13[(55, 29, 12)] = 0.11
        pgm_function13[(55, 29, 13)] = 0.0267
        pgm_function13[(55, 30, 5)] = 0.002200221
        pgm_function13[(55, 30, 6)] = 0.066693346
        pgm_function13[(55, 30, 7)] = 0.2378
        pgm_function13[(55, 30, 8)] = 0.34666517
        pgm_function13[(55, 30, 9)] = 0.28222825
        pgm_function13[(55, 30, 10)] = 0.12441214
        pgm_function13[(55, 30, 11)] = 0.03329673
        pgm_function13[(55, 31, 3)] = 0.001099891
        pgm_function13[(55, 31, 4)] = 0.05440541
        pgm_function13[(55, 31, 5)] = 0.2178
        pgm_function13[(55, 31, 6)] = 0.34443417
        pgm_function13[(55, 31, 7)] = 0.2944
        pgm_function13[(55, 31, 8)] = 0.1422
        pgm_function13[(55, 31, 9)] = 0.0389
        pgm_function13[(55, 31, 10)] = 0.001100111
        pgm_function13[(55, 32, 2)] = 0.0433
        pgm_function13[(55, 32, 3)] = 0.19
        pgm_function13[(55, 32, 4)] = 0.3444
        pgm_function13[(55, 32, 5)] = 0.3022
        pgm_function13[(55, 32, 6)] = 0.16331611
        pgm_function13[(55, 32, 7)] = 0.0456
        pgm_function13[(55, 32, 8)] = 0.0022
        pgm_function13[(56, 2, 59)] = 0.0067
        pgm_function13[(56, 2, 60)] = 0.094409387
        pgm_function13[(56, 3, 57)] = 0.004400442
        pgm_function13[(56, 3, 58)] = 0.076692355
        pgm_function13[(56, 3, 59)] = 0.2278
        pgm_function13[(56, 3, 60)] = 0.3255672
        pgm_function13[(56, 4, 55)] = 0.0022
        pgm_function13[(56, 4, 56)] = 0.0622
        pgm_function13[(56, 4, 57)] = 0.21442119
        pgm_function13[(56, 4, 58)] = 0.31666829
        pgm_function13[(56, 4, 59)] = 0.28332831
        pgm_function13[(56, 4, 60)] = 0.1533
        pgm_function13[(56, 5, 53)] = 0.001100111
        pgm_function13[(56, 5, 54)] = 0.0511
        pgm_function13[(56, 5, 55)] = 0.1922
        pgm_function13[(56, 5, 56)] = 0.31443116
        pgm_function13[(56, 5, 57)] = 0.2956
        pgm_function13[(56, 5, 58)] = 0.1656
        pgm_function13[(56, 5, 59)] = 0.0656
        pgm_function13[(56, 5, 60)] = 0.0078
        pgm_function13[(56, 6, 52)] = 0.04
        pgm_function13[(56, 6, 53)] = 0.1678
        pgm_function13[(56, 6, 54)] = 0.3167
        pgm_function13[(56, 6, 55)] = 0.3022
        pgm_function13[(56, 6, 56)] = 0.1822
        pgm_function13[(56, 6, 57)] = 0.073307367
        pgm_function13[(56, 6, 58)] = 0.0111
        pgm_function13[(56, 7, 50)] = 0.02779723
        pgm_function13[(56, 7, 51)] = 0.152215105
        pgm_function13[(56, 7, 52)] = 0.3056
        pgm_function13[(56, 7, 53)] = 0.312231206
        pgm_function13[(56, 7, 54)] = 0.1989
        pgm_function13[(56, 7, 55)] = 0.0811
        pgm_function13[(56, 7, 56)] = 0.0167
        pgm_function13[(56, 8, 48)] = 0.018901917
        pgm_function13[(56, 8, 49)] = 0.1367
        pgm_function13[(56, 8, 50)] = 0.2889
        pgm_function13[(56, 8, 51)] = 0.3233
        pgm_function13[(56, 8, 52)] = 0.2144
        pgm_function13[(56, 8, 53)] = 0.0889
        pgm_function13[(56, 8, 54)] = 0.0211
        pgm_function13[(56, 9, 46)] = 0.0133
        pgm_function13[(56, 9, 47)] = 0.1178
        pgm_function13[(56, 9, 48)] = 0.27554489
        pgm_function13[(56, 9, 49)] = 0.330032954
        pgm_function13[(56, 9, 50)] = 0.231123178
        pgm_function13[(56, 9, 51)] = 0.0989
        pgm_function13[(56, 9, 52)] = 0.027802828
        pgm_function13[(56, 10, 44)] = 0.010001008
        pgm_function13[(56, 10, 45)] = 0.096680632
        pgm_function13[(56, 10, 46)] = 0.2656
        pgm_function13[(56, 10, 47)] = 0.3333
        pgm_function13[(56, 10, 48)] = 0.2467
        pgm_function13[(56, 10, 49)] = 0.11108907
        pgm_function13[(56, 10, 50)] = 0.0333
        pgm_function13[(56, 11, 42)] = 0.0056
        pgm_function13[(56, 11, 43)] = 0.08330828
        pgm_function13[(56, 11, 44)] = 0.243324165
        pgm_function13[(56, 11, 45)] = 0.3356
        pgm_function13[(56, 11, 46)] = 0.2578
        pgm_function13[(56, 11, 47)] = 0.1256
        pgm_function13[(56, 11, 48)] = 0.0389
        pgm_function13[(56, 11, 49)] = 0.001100111
        pgm_function13[(56, 12, 40)] = 0.00220022
        pgm_function13[(56, 12, 41)] = 0.0733
        pgm_function13[(56, 12, 42)] = 0.22002213
        pgm_function13[(56, 12, 43)] = 0.3355663
        pgm_function13[(56, 12, 44)] = 0.27222716
        pgm_function13[(56, 12, 45)] = 0.14221413
        pgm_function13[(56, 12, 46)] = 0.0444044
        pgm_function13[(56, 12, 47)] = 0.0022
        pgm_function13[(56, 13, 38)] = 0.001099891
        pgm_function13[(56, 13, 39)] = 0.0589
        pgm_function13[(56, 13, 40)] = 0.2033
        pgm_function13[(56, 13, 41)] = 0.33
        pgm_function13[(56, 13, 42)] = 0.2856
        pgm_function13[(56, 13, 43)] = 0.1567
        pgm_function13[(56, 13, 44)] = 0.0511
        pgm_function13[(56, 13, 45)] = 0.004400442
        pgm_function13[(56, 14, 37)] = 0.04559542
        pgm_function13[(56, 14, 38)] = 0.1878
        pgm_function13[(56, 14, 39)] = 0.3211
        pgm_function13[(56, 14, 40)] = 0.3033
        pgm_function13[(56, 14, 41)] = 0.1733
        pgm_function13[(56, 14, 42)] = 0.058905921
        pgm_function13[(56, 14, 43)] = 0.0067
        pgm_function13[(56, 15, 35)] = 0.03220322
        pgm_function13[(56, 15, 36)] = 0.1689
        pgm_function13[(56, 15, 37)] = 0.315632155
        pgm_function13[(56, 15, 38)] = 0.3144
        pgm_function13[(56, 15, 39)] = 0.185619085
        pgm_function13[(56, 15, 40)] = 0.068893132
        pgm_function13[(56, 15, 41)] = 0.009999001
        pgm_function13[(56, 16, 33)] = 0.0244
        pgm_function13[(56, 16, 34)] = 0.1456
        pgm_function13[(56, 16, 35)] = 0.308931087
        pgm_function13[(56, 16, 36)] = 0.3189
        pgm_function13[(56, 16, 37)] = 0.202180049
        pgm_function13[(56, 16, 38)] = 0.0789
        pgm_function13[(56, 16, 39)] = 0.0133013
        pgm_function13[(56, 17, 31)] = 0.0167
        pgm_function13[(56, 17, 32)] = 0.1267
        pgm_function13[(56, 17, 33)] = 0.293329135
        pgm_function13[(56, 17, 34)] = 0.3333
        pgm_function13[(56, 17, 35)] = 0.2156
        pgm_function13[(56, 17, 36)] = 0.09
        pgm_function13[(56, 17, 37)] = 0.0178
        pgm_function13[(56, 18, 29)] = 0.010001005
        pgm_function13[(56, 18, 30)] = 0.113311066
        pgm_function13[(56, 18, 31)] = 0.275572036
        pgm_function13[(56, 18, 32)] = 0.342268178
        pgm_function13[(56, 18, 33)] = 0.228923
        pgm_function13[(56, 18, 34)] = 0.102210091
        pgm_function13[(56, 18, 35)] = 0.0222
        pgm_function13[(56, 19, 27)] = 0.0067
        pgm_function13[(56, 19, 28)] = 0.0944
        pgm_function13[(56, 19, 29)] = 0.25892605
        pgm_function13[(56, 19, 30)] = 0.34336889
        pgm_function13[(56, 19, 31)] = 0.2467
        pgm_function13[(56, 19, 32)] = 0.1178
        pgm_function13[(56, 19, 33)] = 0.0278
        pgm_function13[(56, 20, 25)] = 0.004400443
        pgm_function13[(56, 20, 26)] = 0.0778
        pgm_function13[(56, 20, 27)] = 0.24442412
        pgm_function13[(56, 20, 28)] = 0.3355328
        pgm_function13[(56, 20, 29)] = 0.2667
        pgm_function13[(56, 20, 30)] = 0.1289
        pgm_function13[(56, 20, 31)] = 0.0344
        pgm_function13[(56, 21, 23)] = 0.0022
        pgm_function13[(56, 21, 24)] = 0.065606645
        pgm_function13[(56, 21, 25)] = 0.2222
        pgm_function13[(56, 21, 26)] = 0.33443313
        pgm_function13[(56, 21, 27)] = 0.28557111
        pgm_function13[(56, 21, 28)] = 0.1411
        pgm_function13[(56, 21, 29)] = 0.0422
        pgm_function13[(56, 21, 30)] = 0.001100111
        pgm_function13[(56, 22, 22)] = 0.0533
        pgm_function13[(56, 22, 23)] = 0.1989201
        pgm_function13[(56, 22, 24)] = 0.3356
        pgm_function13[(56, 22, 25)] = 0.29893027
        pgm_function13[(56, 22, 26)] = 0.15668419
        pgm_function13[(56, 22, 27)] = 0.05
        pgm_function13[(56, 22, 28)] = 0.0022
        pgm_function13[(56, 23, 20)] = 0.0378
        pgm_function13[(56, 23, 21)] = 0.18441822
        pgm_function13[(56, 23, 22)] = 0.32556707
        pgm_function13[(56, 23, 23)] = 0.3111
        pgm_function13[(56, 23, 24)] = 0.173317085
        pgm_function13[(56, 23, 25)] = 0.0589
        pgm_function13[(56, 23, 26)] = 0.004399564
        pgm_function13[(56, 24, 18)] = 0.0278
        pgm_function13[(56, 24, 19)] = 0.16558312
        pgm_function13[(56, 24, 20)] = 0.3144
        pgm_function13[(56, 24, 21)] = 0.3211
        pgm_function13[(56, 24, 22)] = 0.1889
        pgm_function13[(56, 24, 23)] = 0.0678
        pgm_function13[(56, 24, 24)] = 0.0067
        pgm_function13[(56, 25, 16)] = 0.01999801
        pgm_function13[(56, 25, 17)] = 0.14331404
        pgm_function13[(56, 25, 18)] = 0.3067
        pgm_function13[(56, 25, 19)] = 0.332233299
        pgm_function13[(56, 25, 20)] = 0.2033
        pgm_function13[(56, 25, 21)] = 0.0778
        pgm_function13[(56, 25, 22)] = 0.011101108
        pgm_function13[(56, 26, 14)] = 0.0144014
        pgm_function13[(56, 26, 15)] = 0.121112084
        pgm_function13[(56, 26, 16)] = 0.3
        pgm_function13[(56, 26, 17)] = 0.336733906
        pgm_function13[(56, 26, 18)] = 0.2222
        pgm_function13[(56, 26, 19)] = 0.0867
        pgm_function13[(56, 26, 20)] = 0.01559841
        pgm_function13[(56, 27, 12)] = 0.008900897
        pgm_function13[(56, 27, 13)] = 0.1022
        pgm_function13[(56, 27, 14)] = 0.281128062
        pgm_function13[(56, 27, 15)] = 0.3388662
        pgm_function13[(56, 27, 16)] = 0.2422
        pgm_function13[(56, 27, 17)] = 0.09779022
        pgm_function13[(56, 27, 18)] = 0.02
        pgm_function13[(56, 28, 10)] = 0.004400441
        pgm_function13[(56, 28, 11)] = 0.09
        pgm_function13[(56, 28, 12)] = 0.255574153
        pgm_function13[(56, 28, 13)] = 0.346665211
        pgm_function13[(56, 28, 14)] = 0.26
        pgm_function13[(56, 28, 15)] = 0.11001106
        pgm_function13[(56, 28, 16)] = 0.02670272
        pgm_function13[(56, 29, 8)] = 0.002200439
        pgm_function13[(56, 29, 9)] = 0.0744
        pgm_function13[(56, 29, 10)] = 0.2367
        pgm_function13[(56, 29, 11)] = 0.34886531
        pgm_function13[(56, 29, 12)] = 0.2756
        pgm_function13[(56, 29, 13)] = 0.1233
        pgm_function13[(56, 29, 14)] = 0.0322
        pgm_function13[(56, 30, 6)] = 0.001099891
        pgm_function13[(56, 30, 7)] = 0.0578
        pgm_function13[(56, 30, 8)] = 0.22107811
        pgm_function13[(56, 30, 9)] = 0.34333431
        pgm_function13[(56, 30, 10)] = 0.29222932
        pgm_function13[(56, 30, 11)] = 0.13998613
        pgm_function13[(56, 30, 12)] = 0.03889614
        pgm_function13[(56, 30, 13)] = 0.001100111
        pgm_function13[(56, 31, 5)] = 0.0444
        pgm_function13[(56, 31, 6)] = 0.2022201
        pgm_function13[(56, 31, 7)] = 0.3389
        pgm_function13[(56, 31, 8)] = 0.3056
        pgm_function13[(56, 31, 9)] = 0.1578
        pgm_function13[(56, 31, 10)] = 0.045604645
        pgm_function13[(56, 31, 11)] = 0.0022
        pgm_function13[(56, 32, 3)] = 0.0344
        pgm_function13[(56, 32, 4)] = 0.1767
        pgm_function13[(56, 32, 5)] = 0.3356
        pgm_function13[(56, 32, 6)] = 0.31113122
        pgm_function13[(56, 32, 7)] = 0.1778
        pgm_function13[(56, 32, 8)] = 0.0522
        pgm_function13[(56, 32, 9)] = 0.0044
        pgm_function13[(57, 2, 60)] = 0.004400439
        pgm_function13[(57, 3, 58)] = 0.002199782
        pgm_function13[(57, 3, 59)] = 0.0667
        pgm_function13[(57, 3, 60)] = 0.21327913
        pgm_function13[(57, 4, 56)] = 0.0011
        pgm_function13[(57, 4, 57)] = 0.05220525
        pgm_function13[(57, 4, 58)] = 0.19778018
        pgm_function13[(57, 4, 59)] = 0.31443135
        pgm_function13[(57, 4, 60)] = 0.29
        pgm_function13[(57, 5, 55)] = 0.0411
        pgm_function13[(57, 5, 56)] = 0.18001809
        pgm_function13[(57, 5, 57)] = 0.31
        pgm_function13[(57, 5, 58)] = 0.3044
        pgm_function13[(57, 5, 59)] = 0.1778
        pgm_function13[(57, 5, 60)] = 0.0722
        pgm_function13[(57, 6, 53)] = 0.0322
        pgm_function13[(57, 6, 54)] = 0.1544
        pgm_function13[(57, 6, 55)] = 0.3056
        pgm_function13[(57, 6, 56)] = 0.3089
        pgm_function13[(57, 6, 57)] = 0.194419179
        pgm_function13[(57, 6, 58)] = 0.0811
        pgm_function13[(57, 6, 59)] = 0.016698306
        pgm_function13[(57, 7, 51)] = 0.022202215
        pgm_function13[(57, 7, 52)] = 0.1344
        pgm_function13[(57, 7, 53)] = 0.298930197
        pgm_function13[(57, 7, 54)] = 0.3144
        pgm_function13[(57, 7, 55)] = 0.2122
        pgm_function13[(57, 7, 56)] = 0.0889
        pgm_function13[(57, 7, 57)] = 0.0211
        pgm_function13[(57, 8, 49)] = 0.0144
        pgm_function13[(57, 8, 50)] = 0.1233
        pgm_function13[(57, 8, 51)] = 0.2767
        pgm_function13[(57, 8, 52)] = 0.3267
        pgm_function13[(57, 8, 53)] = 0.2267
        pgm_function13[(57, 8, 54)] = 0.0989
        pgm_function13[(57, 8, 55)] = 0.0267
        pgm_function13[(57, 9, 47)] = 0.01
        pgm_function13[(57, 9, 48)] = 0.105578958
        pgm_function13[(57, 9, 49)] = 0.260025964
        pgm_function13[(57, 9, 50)] = 0.334433258
        pgm_function13[(57, 9, 51)] = 0.2433
        pgm_function13[(57, 9, 52)] = 0.108911108
        pgm_function13[(57, 9, 53)] = 0.03330332
        pgm_function13[(57, 10, 45)] = 0.006698655
        pgm_function13[(57, 10, 46)] = 0.0867
        pgm_function13[(57, 10, 47)] = 0.2478
        pgm_function13[(57, 10, 48)] = 0.3344
        pgm_function13[(57, 10, 49)] = 0.25557415
        pgm_function13[(57, 10, 50)] = 0.1233
        pgm_function13[(57, 10, 51)] = 0.0389
        pgm_function13[(57, 10, 52)] = 0.0011
        pgm_function13[(57, 11, 43)] = 0.004400439
        pgm_function13[(57, 11, 44)] = 0.072207249
        pgm_function13[(57, 11, 45)] = 0.23
        pgm_function13[(57, 11, 46)] = 0.3311
        pgm_function13[(57, 11, 47)] = 0.2711
        pgm_function13[(57, 11, 48)] = 0.1378
        pgm_function13[(57, 11, 49)] = 0.044404426
        pgm_function13[(57, 11, 50)] = 0.0022
        pgm_function13[(57, 12, 41)] = 0.0011
        pgm_function13[(57, 12, 42)] = 0.061106136
        pgm_function13[(57, 12, 43)] = 0.20777919
        pgm_function13[(57, 12, 44)] = 0.3311332
        pgm_function13[(57, 12, 45)] = 0.28112825
        pgm_function13[(57, 12, 46)] = 0.15671601
        pgm_function13[(57, 12, 47)] = 0.05
        pgm_function13[(57, 12, 48)] = 0.004399563
        pgm_function13[(57, 13, 40)] = 0.0489
        pgm_function13[(57, 13, 41)] = 0.1878
        pgm_function13[(57, 13, 42)] = 0.3278
        pgm_function13[(57, 13, 43)] = 0.2956
        pgm_function13[(57, 13, 44)] = 0.1711
        pgm_function13[(57, 13, 45)] = 0.058905921
        pgm_function13[(57, 13, 46)] = 0.006699334
        pgm_function13[(57, 14, 38)] = 0.0356
        pgm_function13[(57, 14, 39)] = 0.1711
        pgm_function13[(57, 14, 40)] = 0.3156
        pgm_function13[(57, 14, 41)] = 0.3089
        pgm_function13[(57, 14, 42)] = 0.183318066
        pgm_function13[(57, 14, 43)] = 0.0689
        pgm_function13[(57, 14, 44)] = 0.009999003
        pgm_function13[(57, 15, 36)] = 0.0256
        pgm_function13[(57, 15, 37)] = 0.153315075
        pgm_function13[(57, 15, 38)] = 0.3044
        pgm_function13[(57, 15, 39)] = 0.320032147
        pgm_function13[(57, 15, 40)] = 0.19668009
        pgm_function13[(57, 15, 41)] = 0.077792205
        pgm_function13[(57, 15, 42)] = 0.0133013
        pgm_function13[(57, 16, 34)] = 0.0189
        pgm_function13[(57, 16, 35)] = 0.132213037
        pgm_function13[(57, 16, 36)] = 0.2967
        pgm_function13[(57, 16, 37)] = 0.328867079
        pgm_function13[(57, 16, 38)] = 0.2111
        pgm_function13[(57, 16, 39)] = 0.09000901
        pgm_function13[(57, 16, 40)] = 0.0178
        pgm_function13[(57, 17, 32)] = 0.0133
        pgm_function13[(57, 17, 33)] = 0.113311052
        pgm_function13[(57, 17, 34)] = 0.2822
        pgm_function13[(57, 17, 35)] = 0.3344
        pgm_function13[(57, 17, 36)] = 0.2289
        pgm_function13[(57, 17, 37)] = 0.1011
        pgm_function13[(57, 17, 38)] = 0.0222
        pgm_function13[(57, 18, 30)] = 0.007800785
        pgm_function13[(57, 18, 31)] = 0.096690313
        pgm_function13[(57, 18, 32)] = 0.262252136
        pgm_function13[(57, 18, 33)] = 0.34223399
        pgm_function13[(57, 18, 34)] = 0.243324217
        pgm_function13[(57, 18, 35)] = 0.1156
        pgm_function13[(57, 18, 36)] = 0.0278
        pgm_function13[(57, 19, 28)] = 0.0044
        pgm_function13[(57, 19, 29)] = 0.08330831
        pgm_function13[(57, 19, 30)] = 0.24224792
        pgm_function13[(57, 19, 31)] = 0.3422
        pgm_function13[(57, 19, 32)] = 0.2567
        pgm_function13[(57, 19, 33)] = 0.1278
        pgm_function13[(57, 19, 34)] = 0.0344
        pgm_function13[(57, 20, 26)] = 0.0022
        pgm_function13[(57, 20, 27)] = 0.067806833
        pgm_function13[(57, 20, 28)] = 0.22665486
        pgm_function13[(57, 20, 29)] = 0.3333
        pgm_function13[(57, 20, 30)] = 0.2778
        pgm_function13[(57, 20, 31)] = 0.14
        pgm_function13[(57, 20, 32)] = 0.04220422
        pgm_function13[(57, 20, 33)] = 0.0011
        pgm_function13[(57, 21, 24)] = 0.001100111
        pgm_function13[(57, 21, 25)] = 0.0544
        pgm_function13[(57, 21, 26)] = 0.21002108
        pgm_function13[(57, 21, 27)] = 0.32886713
        pgm_function13[(57, 21, 28)] = 0.2989
        pgm_function13[(57, 21, 29)] = 0.1522
        pgm_function13[(57, 21, 30)] = 0.050005055
        pgm_function13[(57, 21, 31)] = 0.0022
        pgm_function13[(57, 22, 23)] = 0.04330432
        pgm_function13[(57, 22, 24)] = 0.1844
        pgm_function13[(57, 22, 25)] = 0.32443229
        pgm_function13[(57, 22, 26)] = 0.30776937
        pgm_function13[(57, 22, 27)] = 0.1678
        pgm_function13[(57, 22, 28)] = 0.0578
        pgm_function13[(57, 22, 29)] = 0.0044
        pgm_function13[(57, 23, 21)] = 0.03000304
        pgm_function13[(57, 23, 22)] = 0.16438403
        pgm_function13[(57, 23, 23)] = 0.3211
        pgm_function13[(57, 23, 24)] = 0.315632155
        pgm_function13[(57, 23, 25)] = 0.1867
        pgm_function13[(57, 23, 26)] = 0.067793262
        pgm_function13[(57, 23, 27)] = 0.0067
        pgm_function13[(57, 24, 19)] = 0.02109791
        pgm_function13[(57, 24, 20)] = 0.1489
        pgm_function13[(57, 24, 21)] = 0.31
        pgm_function13[(57, 24, 22)] = 0.3267
        pgm_function13[(57, 24, 23)] = 0.2022
        pgm_function13[(57, 24, 24)] = 0.0767
        pgm_function13[(57, 24, 25)] = 0.01
        pgm_function13[(57, 25, 17)] = 0.0144014
        pgm_function13[(57, 25, 18)] = 0.1289
        pgm_function13[(57, 25, 19)] = 0.293329264
        pgm_function13[(57, 25, 20)] = 0.3389
        pgm_function13[(57, 25, 21)] = 0.2178
        pgm_function13[(57, 25, 22)] = 0.085608658
        pgm_function13[(57, 25, 23)] = 0.0156
        pgm_function13[(57, 26, 15)] = 0.010001007
        pgm_function13[(57, 26, 16)] = 0.1067
        pgm_function13[(57, 26, 17)] = 0.283327921
        pgm_function13[(57, 26, 18)] = 0.3389
        pgm_function13[(57, 26, 19)] = 0.2367
        pgm_function13[(57, 26, 20)] = 0.096690359
        pgm_function13[(57, 26, 21)] = 0.02
        pgm_function13[(57, 27, 13)] = 0.0067
        pgm_function13[(57, 27, 14)] = 0.08890892
        pgm_function13[(57, 27, 15)] = 0.267773158
        pgm_function13[(57, 27, 16)] = 0.3389
        pgm_function13[(57, 27, 17)] = 0.25557405
        pgm_function13[(57, 27, 18)] = 0.1089
        pgm_function13[(57, 27, 19)] = 0.02669732
        pgm_function13[(57, 28, 11)] = 0.0033
        pgm_function13[(57, 28, 12)] = 0.076692346
        pgm_function13[(57, 28, 13)] = 0.242176148
        pgm_function13[(57, 28, 14)] = 0.3444
        pgm_function13[(57, 28, 15)] = 0.27112714
        pgm_function13[(57, 28, 16)] = 0.12331211
        pgm_function13[(57, 28, 17)] = 0.0322
        pgm_function13[(57, 29, 9)] = 0.0011
        pgm_function13[(57, 29, 10)] = 0.0633
        pgm_function13[(57, 29, 11)] = 0.2166782
        pgm_function13[(57, 29, 12)] = 0.3489
        pgm_function13[(57, 29, 13)] = 0.2878
        pgm_function13[(57, 29, 14)] = 0.1378
        pgm_function13[(57, 29, 15)] = 0.0389
        pgm_function13[(57, 29, 16)] = 0.0011
        pgm_function13[(57, 30, 8)] = 0.04779522
        pgm_function13[(57, 30, 9)] = 0.20112018
        pgm_function13[(57, 30, 10)] = 0.34223438
        pgm_function13[(57, 30, 11)] = 0.29997027
        pgm_function13[(57, 30, 12)] = 0.15558414
        pgm_function13[(57, 30, 13)] = 0.045604641
        pgm_function13[(57, 30, 14)] = 0.0022
        pgm_function13[(57, 31, 6)] = 0.03440342
        pgm_function13[(57, 31, 7)] = 0.1844
        pgm_function13[(57, 31, 8)] = 0.33
        pgm_function13[(57, 31, 9)] = 0.3133
        pgm_function13[(57, 31, 10)] = 0.17221717
        pgm_function13[(57, 31, 11)] = 0.0522
        pgm_function13[(57, 31, 12)] = 0.004400444
        pgm_function13[(57, 32, 4)] = 0.0267
        pgm_function13[(57, 32, 5)] = 0.1611
        pgm_function13[(57, 32, 6)] = 0.32783323
        pgm_function13[(57, 32, 7)] = 0.3211
        pgm_function13[(57, 32, 8)] = 0.1922
        pgm_function13[(57, 32, 9)] = 0.06
        pgm_function13[(57, 32, 10)] = 0.006699335
        pgm_function13[(58, 3, 59)] = 0.0011
        pgm_function13[(58, 3, 60)] = 0.05669433
        pgm_function13[(58, 4, 58)] = 0.04329574
        pgm_function13[(58, 4, 59)] = 0.1822182
        pgm_function13[(58, 4, 60)] = 0.3122
        pgm_function13[(58, 5, 56)] = 0.03220322
        pgm_function13[(58, 5, 57)] = 0.1633
        pgm_function13[(58, 5, 58)] = 0.3011
        pgm_function13[(58, 5, 59)] = 0.31
        pgm_function13[(58, 5, 60)] = 0.19
        pgm_function13[(58, 6, 54)] = 0.0244
        pgm_function13[(58, 6, 55)] = 0.1422
        pgm_function13[(58, 6, 56)] = 0.2967
        pgm_function13[(58, 6, 57)] = 0.313331288
        pgm_function13[(58, 6, 58)] = 0.2056
        pgm_function13[(58, 6, 59)] = 0.088891132
        pgm_function13[(58, 6, 60)] = 0.0211
        pgm_function13[(58, 7, 52)] = 0.0189
        pgm_function13[(58, 7, 53)] = 0.12111208
        pgm_function13[(58, 7, 54)] = 0.2867
        pgm_function13[(58, 7, 55)] = 0.3189
        pgm_function13[(58, 7, 56)] = 0.2222
        pgm_function13[(58, 7, 57)] = 0.0989
        pgm_function13[(58, 7, 58)] = 0.026697316
        pgm_function13[(58, 8, 50)] = 0.0111
        pgm_function13[(58, 8, 51)] = 0.1078
        pgm_function13[(58, 8, 52)] = 0.2644
        pgm_function13[(58, 8, 53)] = 0.33
        pgm_function13[(58, 8, 54)] = 0.24
        pgm_function13[(58, 8, 55)] = 0.11
        pgm_function13[(58, 8, 56)] = 0.03330331
        pgm_function13[(58, 9, 48)] = 0.006698657
        pgm_function13[(58, 9, 49)] = 0.094409387
        pgm_function13[(58, 9, 50)] = 0.242224187
        pgm_function13[(58, 9, 51)] = 0.3367
        pgm_function13[(58, 9, 52)] = 0.253325251
        pgm_function13[(58, 9, 53)] = 0.12111207
        pgm_function13[(58, 9, 54)] = 0.03890394
        pgm_function13[(58, 9, 55)] = 0.00110011
        pgm_function13[(58, 10, 46)] = 0.0044
        pgm_function13[(58, 10, 47)] = 0.0767
        pgm_function13[(58, 10, 48)] = 0.2267
        pgm_function13[(58, 10, 49)] = 0.3355662
        pgm_function13[(58, 10, 50)] = 0.2667
        pgm_function13[(58, 10, 51)] = 0.1344
        pgm_function13[(58, 10, 52)] = 0.0444
        pgm_function13[(58, 10, 53)] = 0.002200221
        pgm_function13[(58, 11, 44)] = 0.002200221
        pgm_function13[(58, 11, 45)] = 0.0611
        pgm_function13[(58, 11, 46)] = 0.2167
        pgm_function13[(58, 11, 47)] = 0.3256
        pgm_function13[(58, 11, 48)] = 0.2822
        pgm_function13[(58, 11, 49)] = 0.15221509
        pgm_function13[(58, 11, 50)] = 0.05
        pgm_function13[(58, 11, 51)] = 0.004399565
        pgm_function13[(58, 12, 42)] = 0.001100111
        pgm_function13[(58, 12, 43)] = 0.05109495
        pgm_function13[(58, 12, 44)] = 0.19441912
        pgm_function13[(58, 12, 45)] = 0.32443229
        pgm_function13[(58, 12, 46)] = 0.29112903
        pgm_function13[(58, 12, 47)] = 0.1689
        pgm_function13[(58, 12, 48)] = 0.056694342
        pgm_function13[(58, 12, 49)] = 0.006699333
        pgm_function13[(58, 13, 41)] = 0.04
        pgm_function13[(58, 13, 42)] = 0.1711
        pgm_function13[(58, 13, 43)] = 0.32
        pgm_function13[(58, 13, 44)] = 0.3033
        pgm_function13[(58, 13, 45)] = 0.181118065
        pgm_function13[(58, 13, 46)] = 0.068893139
        pgm_function13[(58, 13, 47)] = 0.009999004
        pgm_function13[(58, 14, 39)] = 0.0289
        pgm_function13[(58, 14, 40)] = 0.1556
        pgm_function13[(58, 14, 41)] = 0.3078
        pgm_function13[(58, 14, 42)] = 0.315632114
        pgm_function13[(58, 14, 43)] = 0.1933
        pgm_function13[(58, 14, 44)] = 0.077792221
        pgm_function13[(58, 14, 45)] = 0.013301306
        pgm_function13[(58, 15, 37)] = 0.02000201
        pgm_function13[(58, 15, 38)] = 0.1367
        pgm_function13[(58, 15, 39)] = 0.294429135
        pgm_function13[(58, 15, 40)] = 0.328867151
        pgm_function13[(58, 15, 41)] = 0.206679014
        pgm_function13[(58, 15, 42)] = 0.090009
        pgm_function13[(58, 15, 43)] = 0.0178
        pgm_function13[(58, 16, 35)] = 0.013301304
        pgm_function13[(58, 16, 36)] = 0.1189
        pgm_function13[(58, 16, 37)] = 0.279972067
        pgm_function13[(58, 16, 38)] = 0.3367
        pgm_function13[(58, 16, 39)] = 0.22442202
        pgm_function13[(58, 16, 40)] = 0.1
        pgm_function13[(58, 16, 41)] = 0.0222
        pgm_function13[(58, 17, 33)] = 0.010001005
        pgm_function13[(58, 17, 34)] = 0.0978
        pgm_function13[(58, 17, 35)] = 0.2678
        pgm_function13[(58, 17, 36)] = 0.3367
        pgm_function13[(58, 17, 37)] = 0.2411
        pgm_function13[(58, 17, 38)] = 0.1111
        pgm_function13[(58, 17, 39)] = 0.0278
        pgm_function13[(58, 18, 31)] = 0.005599441
        pgm_function13[(58, 18, 32)] = 0.084416944
        pgm_function13[(58, 18, 33)] = 0.247825
        pgm_function13[(58, 18, 34)] = 0.340034303
        pgm_function13[(58, 18, 35)] = 0.2556
        pgm_function13[(58, 18, 36)] = 0.1244
        pgm_function13[(58, 18, 37)] = 0.0344
        pgm_function13[(58, 19, 29)] = 0.00220022
        pgm_function13[(58, 19, 30)] = 0.07331468
        pgm_function13[(58, 19, 31)] = 0.2267
        pgm_function13[(58, 19, 32)] = 0.34
        pgm_function13[(58, 19, 33)] = 0.2711
        pgm_function13[(58, 19, 34)] = 0.1378
        pgm_function13[(58, 19, 35)] = 0.0411
        pgm_function13[(58, 19, 36)] = 0.001099891
        pgm_function13[(58, 20, 27)] = 0.001100111
        pgm_function13[(58, 20, 28)] = 0.05888816
        pgm_function13[(58, 20, 29)] = 0.2111
        pgm_function13[(58, 20, 30)] = 0.3333
        pgm_function13[(58, 20, 31)] = 0.2911
        pgm_function13[(58, 20, 32)] = 0.15111506
        pgm_function13[(58, 20, 33)] = 0.05
        pgm_function13[(58, 20, 34)] = 0.002200222
        pgm_function13[(58, 21, 26)] = 0.04440442
        pgm_function13[(58, 21, 27)] = 0.19218108
        pgm_function13[(58, 21, 28)] = 0.3189
        pgm_function13[(58, 21, 29)] = 0.3078
        pgm_function13[(58, 21, 30)] = 0.164416179
        pgm_function13[(58, 21, 31)] = 0.0578
        pgm_function13[(58, 21, 32)] = 0.004400443
        pgm_function13[(58, 22, 24)] = 0.0344
        pgm_function13[(58, 22, 25)] = 0.17111715
        pgm_function13[(58, 22, 26)] = 0.31666838
        pgm_function13[(58, 22, 27)] = 0.3167
        pgm_function13[(58, 22, 28)] = 0.1811
        pgm_function13[(58, 22, 29)] = 0.0678
        pgm_function13[(58, 22, 30)] = 0.006698654
        pgm_function13[(58, 23, 22)] = 0.02559741
        pgm_function13[(58, 23, 23)] = 0.1489
        pgm_function13[(58, 23, 24)] = 0.313331154
        pgm_function13[(58, 23, 25)] = 0.32
        pgm_function13[(58, 23, 26)] = 0.198880181
        pgm_function13[(58, 23, 27)] = 0.0767
        pgm_function13[(58, 23, 28)] = 0.009999012
        pgm_function13[(58, 24, 20)] = 0.0167
        pgm_function13[(58, 24, 21)] = 0.13
        pgm_function13[(58, 24, 22)] = 0.2989
        pgm_function13[(58, 24, 23)] = 0.3322
        pgm_function13[(58, 24, 24)] = 0.2167
        pgm_function13[(58, 24, 25)] = 0.0856
        pgm_function13[(58, 24, 26)] = 0.015598416
        pgm_function13[(58, 25, 18)] = 0.01
        pgm_function13[(58, 25, 19)] = 0.114411103
        pgm_function13[(58, 25, 20)] = 0.28
        pgm_function13[(58, 25, 21)] = 0.3422
        pgm_function13[(58, 25, 22)] = 0.233323159
        pgm_function13[(58, 25, 23)] = 0.0944
        pgm_function13[(58, 25, 24)] = 0.02000201
        pgm_function13[(58, 26, 16)] = 0.0067
        pgm_function13[(58, 26, 17)] = 0.094409374
        pgm_function13[(58, 26, 18)] = 0.2656
        pgm_function13[(58, 26, 19)] = 0.3444
        pgm_function13[(58, 26, 20)] = 0.248875152
        pgm_function13[(58, 26, 21)] = 0.1067
        pgm_function13[(58, 26, 22)] = 0.0267
        pgm_function13[(58, 27, 14)] = 0.004400441
        pgm_function13[(58, 27, 15)] = 0.076692345
        pgm_function13[(58, 27, 16)] = 0.2511
        pgm_function13[(58, 27, 17)] = 0.34106607
        pgm_function13[(58, 27, 18)] = 0.2689
        pgm_function13[(58, 27, 19)] = 0.11998807
        pgm_function13[(58, 27, 20)] = 0.0322
        pgm_function13[(58, 28, 12)] = 0.002199781
        pgm_function13[(58, 28, 13)] = 0.06559344
        pgm_function13[(58, 28, 14)] = 0.2267
        pgm_function13[(58, 28, 15)] = 0.34003417
        pgm_function13[(58, 28, 16)] = 0.28442826
        pgm_function13[(58, 28, 17)] = 0.1344
        pgm_function13[(58, 28, 18)] = 0.0389
        pgm_function13[(58, 28, 19)] = 0.0011
        pgm_function13[(58, 29, 11)] = 0.05439465
        pgm_function13[(58, 29, 12)] = 0.2
        pgm_function13[(58, 29, 13)] = 0.3411
        pgm_function13[(58, 29, 14)] = 0.2956
        pgm_function13[(58, 29, 15)] = 0.1544
        pgm_function13[(58, 29, 16)] = 0.0456
        pgm_function13[(58, 29, 17)] = 0.002200221
        pgm_function13[(58, 30, 9)] = 0.04000404
        pgm_function13[(58, 30, 10)] = 0.1822182
        pgm_function13[(58, 30, 11)] = 0.3355663
        pgm_function13[(58, 30, 12)] = 0.30776928
        pgm_function13[(58, 30, 13)] = 0.170017151
        pgm_function13[(58, 30, 14)] = 0.0522
        pgm_function13[(58, 30, 15)] = 0.0044
        pgm_function13[(58, 31, 7)] = 0.0278
        pgm_function13[(58, 31, 8)] = 0.1678
        pgm_function13[(58, 31, 9)] = 0.3233
        pgm_function13[(58, 31, 10)] = 0.322232319
        pgm_function13[(58, 31, 11)] = 0.1878
        pgm_function13[(58, 31, 12)] = 0.060006053
        pgm_function13[(58, 31, 13)] = 0.006699337
        pgm_function13[(58, 32, 5)] = 0.02
        pgm_function13[(58, 32, 6)] = 0.1444141
        pgm_function13[(58, 32, 7)] = 0.3133
        pgm_function13[(58, 32, 8)] = 0.3322
        pgm_function13[(58, 32, 9)] = 0.2067
        pgm_function13[(58, 32, 10)] = 0.068893156
        pgm_function13[(58, 32, 11)] = 0.01
        pgm_function13[(59, 4, 59)] = 0.03560364
        pgm_function13[(59, 4, 60)] = 0.1656
        pgm_function13[(59, 5, 57)] = 0.0256
        pgm_function13[(59, 5, 58)] = 0.1489
        pgm_function13[(59, 5, 59)] = 0.2933
        pgm_function13[(59, 5, 60)] = 0.3133
        pgm_function13[(59, 6, 55)] = 0.0189
        pgm_function13[(59, 6, 56)] = 0.1289
        pgm_function13[(59, 6, 57)] = 0.283328261
        pgm_function13[(59, 6, 58)] = 0.3233
        pgm_function13[(59, 6, 59)] = 0.215578078
        pgm_function13[(59, 6, 60)] = 0.0978
        pgm_function13[(59, 7, 53)] = 0.013301309
        pgm_function13[(59, 7, 54)] = 0.1089
        pgm_function13[(59, 7, 55)] = 0.2711
        pgm_function13[(59, 7, 56)] = 0.3244
        pgm_function13[(59, 7, 57)] = 0.2344
        pgm_function13[(59, 7, 58)] = 0.108889066
        pgm_function13[(59, 7, 59)] = 0.0333
        pgm_function13[(59, 8, 51)] = 0.0089
        pgm_function13[(59, 8, 52)] = 0.0956
        pgm_function13[(59, 8, 53)] = 0.25
        pgm_function13[(59, 8, 54)] = 0.3267
        pgm_function13[(59, 8, 55)] = 0.2511
        pgm_function13[(59, 8, 56)] = 0.12001204
        pgm_function13[(59, 8, 57)] = 0.0389
        pgm_function13[(59, 8, 58)] = 0.001100111
        pgm_function13[(59, 9, 49)] = 0.004400439
        pgm_function13[(59, 9, 50)] = 0.083308364
        pgm_function13[(59, 9, 51)] = 0.2256
        pgm_function13[(59, 9, 52)] = 0.334433331
        pgm_function13[(59, 9, 53)] = 0.26332616
        pgm_function13[(59, 9, 54)] = 0.13331313
        pgm_function13[(59, 9, 55)] = 0.04440441
        pgm_function13[(59, 9, 56)] = 0.002200223
        pgm_function13[(59, 10, 47)] = 0.0022
        pgm_function13[(59, 10, 48)] = 0.0689
        pgm_function13[(59, 10, 49)] = 0.21217913
        pgm_function13[(59, 10, 50)] = 0.3311
        pgm_function13[(59, 10, 51)] = 0.2778
        pgm_function13[(59, 10, 52)] = 0.15
        pgm_function13[(59, 10, 53)] = 0.050005019
        pgm_function13[(59, 10, 54)] = 0.0044
        pgm_function13[(59, 11, 45)] = 0.0011
        pgm_function13[(59, 11, 46)] = 0.0522
        pgm_function13[(59, 11, 47)] = 0.2011
        pgm_function13[(59, 11, 48)] = 0.3211
        pgm_function13[(59, 11, 49)] = 0.291129172
        pgm_function13[(59, 11, 50)] = 0.1656
        pgm_function13[(59, 11, 51)] = 0.056694359
        pgm_function13[(59, 11, 52)] = 0.0067
        pgm_function13[(59, 12, 44)] = 0.04110412
        pgm_function13[(59, 12, 45)] = 0.18111816
        pgm_function13[(59, 12, 46)] = 0.31443103
        pgm_function13[(59, 12, 47)] = 0.3011
        pgm_function13[(59, 12, 48)] = 0.179982133
        pgm_function13[(59, 12, 49)] = 0.065593431
        pgm_function13[(59, 12, 50)] = 0.009999006
        pgm_function13[(59, 13, 42)] = 0.0322
        pgm_function13[(59, 13, 43)] = 0.1578
        pgm_function13[(59, 13, 44)] = 0.3078
        pgm_function13[(59, 13, 45)] = 0.311131112
        pgm_function13[(59, 13, 46)] = 0.189981108
        pgm_function13[(59, 13, 47)] = 0.076692328
        pgm_function13[(59, 13, 48)] = 0.0133
        pgm_function13[(59, 14, 40)] = 0.0222
        pgm_function13[(59, 14, 41)] = 0.1389
        pgm_function13[(59, 14, 42)] = 0.301130108
        pgm_function13[(59, 14, 43)] = 0.3211
        pgm_function13[(59, 14, 44)] = 0.203280055
        pgm_function13[(59, 14, 45)] = 0.088908941
        pgm_function13[(59, 14, 46)] = 0.0178
        pgm_function13[(59, 15, 38)] = 0.0156
        pgm_function13[(59, 15, 39)] = 0.124412057
        pgm_function13[(59, 15, 40)] = 0.281072129
        pgm_function13[(59, 15, 41)] = 0.333267023
        pgm_function13[(59, 15, 42)] = 0.22002199
        pgm_function13[(59, 15, 43)] = 0.1
        pgm_function13[(59, 15, 44)] = 0.022202211
        pgm_function13[(59, 16, 36)] = 0.01
        pgm_function13[(59, 16, 37)] = 0.106689026
        pgm_function13[(59, 16, 38)] = 0.2622
        pgm_function13[(59, 16, 39)] = 0.33783402
        pgm_function13[(59, 16, 40)] = 0.2356
        pgm_function13[(59, 16, 41)] = 0.1111
        pgm_function13[(59, 16, 42)] = 0.0278
        pgm_function13[(59, 17, 34)] = 0.0067
        pgm_function13[(59, 17, 35)] = 0.0878
        pgm_function13[(59, 17, 36)] = 0.25
        pgm_function13[(59, 17, 37)] = 0.3367
        pgm_function13[(59, 17, 38)] = 0.2567
        pgm_function13[(59, 17, 39)] = 0.1222
        pgm_function13[(59, 17, 40)] = 0.0344
        pgm_function13[(59, 18, 32)] = 0.004400882
        pgm_function13[(59, 18, 33)] = 0.0733073
        pgm_function13[(59, 18, 34)] = 0.233323208
        pgm_function13[(59, 18, 35)] = 0.3333
        pgm_function13[(59, 18, 36)] = 0.2722
        pgm_function13[(59, 18, 37)] = 0.1333
        pgm_function13[(59, 18, 38)] = 0.04109595
        pgm_function13[(59, 18, 39)] = 0.001100111
        pgm_function13[(59, 19, 30)] = 0.00110022
        pgm_function13[(59, 19, 31)] = 0.0611
        pgm_function13[(59, 19, 32)] = 0.2122
        pgm_function13[(59, 19, 33)] = 0.3333
        pgm_function13[(59, 19, 34)] = 0.2856
        pgm_function13[(59, 19, 35)] = 0.1511
        pgm_function13[(59, 19, 36)] = 0.048895144
        pgm_function13[(59, 19, 37)] = 0.002199781
        pgm_function13[(59, 20, 29)] = 0.0489
        pgm_function13[(59, 20, 30)] = 0.1933
        pgm_function13[(59, 20, 31)] = 0.3256
        pgm_function13[(59, 20, 32)] = 0.29893012
        pgm_function13[(59, 20, 33)] = 0.1633
        pgm_function13[(59, 20, 34)] = 0.056705744
        pgm_function13[(59, 20, 35)] = 0.0044
        pgm_function13[(59, 21, 27)] = 0.03559641
        pgm_function13[(59, 21, 28)] = 0.1778
        pgm_function13[(59, 21, 29)] = 0.3156
        pgm_function13[(59, 21, 30)] = 0.313331342
        pgm_function13[(59, 21, 31)] = 0.1778
        pgm_function13[(59, 21, 32)] = 0.067806852
        pgm_function13[(59, 21, 33)] = 0.00669933
        pgm_function13[(59, 22, 25)] = 0.02670272
        pgm_function13[(59, 22, 26)] = 0.15668419
        pgm_function13[(59, 22, 27)] = 0.31
        pgm_function13[(59, 22, 28)] = 0.3233
        pgm_function13[(59, 22, 29)] = 0.1933
        pgm_function13[(59, 22, 30)] = 0.076684629
        pgm_function13[(59, 22, 31)] = 0.010001007
        pgm_function13[(59, 23, 23)] = 0.0189
        pgm_function13[(59, 23, 24)] = 0.132213065
        pgm_function13[(59, 23, 25)] = 0.3022
        pgm_function13[(59, 23, 26)] = 0.327767298
        pgm_function13[(59, 23, 27)] = 0.2122
        pgm_function13[(59, 23, 28)] = 0.085591504
        pgm_function13[(59, 23, 29)] = 0.0156
        pgm_function13[(59, 24, 21)] = 0.0122
        pgm_function13[(59, 24, 22)] = 0.1144
        pgm_function13[(59, 24, 23)] = 0.2867
        pgm_function13[(59, 24, 24)] = 0.3322
        pgm_function13[(59, 24, 25)] = 0.2322
        pgm_function13[(59, 24, 26)] = 0.093290794
        pgm_function13[(59, 24, 27)] = 0.02000202
        pgm_function13[(59, 25, 19)] = 0.007800787
        pgm_function13[(59, 25, 20)] = 0.0989
        pgm_function13[(59, 25, 21)] = 0.2644
        pgm_function13[(59, 25, 22)] = 0.342234233
        pgm_function13[(59, 25, 23)] = 0.2478
        pgm_function13[(59, 25, 24)] = 0.10441006
        pgm_function13[(59, 25, 25)] = 0.02669468
        pgm_function13[(59, 26, 17)] = 0.004400439
        pgm_function13[(59, 26, 18)] = 0.0844
        pgm_function13[(59, 26, 19)] = 0.2478
        pgm_function13[(59, 26, 20)] = 0.346665211
        pgm_function13[(59, 26, 21)] = 0.2622
        pgm_function13[(59, 26, 22)] = 0.1178
        pgm_function13[(59, 26, 23)] = 0.03220322
        pgm_function13[(59, 27, 15)] = 0.002199781
        pgm_function13[(59, 27, 16)] = 0.0678
        pgm_function13[(59, 27, 17)] = 0.23217705
        pgm_function13[(59, 27, 18)] = 0.34
        pgm_function13[(59, 27, 19)] = 0.27997217
        pgm_function13[(59, 27, 20)] = 0.1333
        pgm_function13[(59, 27, 21)] = 0.0389
        pgm_function13[(59, 28, 13)] = 0.001099891
        pgm_function13[(59, 28, 14)] = 0.0544
        pgm_function13[(59, 28, 15)] = 0.21332111
        pgm_function13[(59, 28, 16)] = 0.3333333
        pgm_function13[(59, 28, 17)] = 0.2956
        pgm_function13[(59, 28, 18)] = 0.1489
        pgm_function13[(59, 28, 19)] = 0.0456
        pgm_function13[(59, 28, 20)] = 0.0022
        pgm_function13[(59, 29, 12)] = 0.0444
        pgm_function13[(59, 29, 13)] = 0.1867
        pgm_function13[(59, 29, 14)] = 0.3333
        pgm_function13[(59, 29, 15)] = 0.3033
        pgm_function13[(59, 29, 16)] = 0.1667
        pgm_function13[(59, 29, 17)] = 0.05220523
        pgm_function13[(59, 29, 18)] = 0.004400443
        pgm_function13[(59, 30, 10)] = 0.03220324
        pgm_function13[(59, 30, 11)] = 0.16558315
        pgm_function13[(59, 30, 12)] = 0.3299673
        pgm_function13[(59, 30, 13)] = 0.313331279
        pgm_function13[(59, 30, 14)] = 0.1867
        pgm_function13[(59, 30, 15)] = 0.06
        pgm_function13[(59, 30, 16)] = 0.006699334
        pgm_function13[(59, 31, 8)] = 0.0211
        pgm_function13[(59, 31, 9)] = 0.15
        pgm_function13[(59, 31, 10)] = 0.31333131
        pgm_function13[(59, 31, 11)] = 0.3289
        pgm_function13[(59, 31, 12)] = 0.203320181
        pgm_function13[(59, 31, 13)] = 0.06889317
        pgm_function13[(59, 31, 14)] = 0.01
        pgm_function13[(59, 32, 6)] = 0.01440141
        pgm_function13[(59, 32, 7)] = 0.1311
        pgm_function13[(59, 32, 8)] = 0.2967
        pgm_function13[(59, 32, 9)] = 0.34
        pgm_function13[(59, 32, 10)] = 0.217778176
        pgm_function13[(59, 32, 11)] = 0.0789
        pgm_function13[(59, 32, 12)] = 0.0133
        pgm_function13[(60, 4, 60)] = 0.0278
        pgm_function13[(60, 5, 58)] = 0.02
        pgm_function13[(60, 5, 59)] = 0.1333
        pgm_function13[(60, 5, 60)] = 0.2856
        pgm_function13[(60, 6, 56)] = 0.0133
        pgm_function13[(60, 6, 57)] = 0.117812108
        pgm_function13[(60, 6, 58)] = 0.2678
        pgm_function13[(60, 6, 59)] = 0.327767118
        pgm_function13[(60, 6, 60)] = 0.2278
        pgm_function13[(60, 7, 54)] = 0.01
        pgm_function13[(60, 7, 55)] = 0.0989
        pgm_function13[(60, 7, 56)] = 0.2556
        pgm_function13[(60, 7, 57)] = 0.3256
        pgm_function13[(60, 7, 58)] = 0.24557515
        pgm_function13[(60, 7, 59)] = 0.1189
        pgm_function13[(60, 7, 60)] = 0.03890395
        pgm_function13[(60, 8, 52)] = 0.0067
        pgm_function13[(60, 8, 53)] = 0.0833
        pgm_function13[(60, 8, 54)] = 0.2389
        pgm_function13[(60, 8, 55)] = 0.3233
        pgm_function13[(60, 8, 56)] = 0.26002608
        pgm_function13[(60, 8, 57)] = 0.1322
        pgm_function13[(60, 8, 58)] = 0.044404435
        pgm_function13[(60, 8, 59)] = 0.0022
        pgm_function13[(60, 9, 50)] = 0.003300333
        pgm_function13[(60, 9, 51)] = 0.0722
        pgm_function13[(60, 9, 52)] = 0.213321211
        pgm_function13[(60, 9, 53)] = 0.3278332
        pgm_function13[(60, 9, 54)] = 0.27442727
        pgm_function13[(60, 9, 55)] = 0.14781504
        pgm_function13[(60, 9, 56)] = 0.050005059
        pgm_function13[(60, 9, 57)] = 0.0044
        pgm_function13[(60, 10, 48)] = 0.0011
        pgm_function13[(60, 10, 49)] = 0.05779423
        pgm_function13[(60, 10, 50)] = 0.1967
        pgm_function13[(60, 10, 51)] = 0.3278
        pgm_function13[(60, 10, 52)] = 0.2856
        pgm_function13[(60, 10, 53)] = 0.163316062
        pgm_function13[(60, 10, 54)] = 0.0567
        pgm_function13[(60, 10, 55)] = 0.006700674
        pgm_function13[(60, 11, 47)] = 0.0433
        pgm_function13[(60, 11, 48)] = 0.1844
        pgm_function13[(60, 11, 49)] = 0.314431186
        pgm_function13[(60, 11, 50)] = 0.2967
        pgm_function13[(60, 11, 51)] = 0.177782185
        pgm_function13[(60, 11, 52)] = 0.0656
        pgm_function13[(60, 11, 53)] = 0.009999006
        pgm_function13[(60, 12, 45)] = 0.03220323
        pgm_function13[(60, 12, 46)] = 0.16781702
        pgm_function13[(60, 12, 47)] = 0.3056
        pgm_function13[(60, 12, 48)] = 0.312169231
        pgm_function13[(60, 12, 49)] = 0.188881089
        pgm_function13[(60, 12, 50)] = 0.075592445
        pgm_function13[(60, 12, 51)] = 0.013301303
        pgm_function13[(60, 13, 43)] = 0.0244
        pgm_function13[(60, 13, 44)] = 0.1456
        pgm_function13[(60, 13, 45)] = 0.301130108
        pgm_function13[(60, 13, 46)] = 0.318868182
        pgm_function13[(60, 13, 47)] = 0.201080074
        pgm_function13[(60, 13, 48)] = 0.0867
        pgm_function13[(60, 13, 49)] = 0.0178
        pgm_function13[(60, 14, 41)] = 0.0178
        pgm_function13[(60, 14, 42)] = 0.123312044
        pgm_function13[(60, 14, 43)] = 0.29
        pgm_function13[(60, 14, 44)] = 0.327767088
        pgm_function13[(60, 14, 45)] = 0.214421099
        pgm_function13[(60, 14, 46)] = 0.1
        pgm_function13[(60, 14, 47)] = 0.0222
        pgm_function13[(60, 15, 39)] = 0.011101105
        pgm_function13[(60, 15, 40)] = 0.10888905
        pgm_function13[(60, 15, 41)] = 0.269973019
        pgm_function13[(60, 15, 42)] = 0.33113299
        pgm_function13[(60, 15, 43)] = 0.2311
        pgm_function13[(60, 15, 44)] = 0.111111054
        pgm_function13[(60, 15, 45)] = 0.0278
        pgm_function13[(60, 16, 37)] = 0.006699332
        pgm_function13[(60, 16, 38)] = 0.0967
        pgm_function13[(60, 16, 39)] = 0.24782502
        pgm_function13[(60, 16, 40)] = 0.3378
        pgm_function13[(60, 16, 41)] = 0.2489
        pgm_function13[(60, 16, 42)] = 0.1222
        pgm_function13[(60, 16, 43)] = 0.0344
        pgm_function13[(60, 17, 35)] = 0.0044
        pgm_function13[(60, 17, 36)] = 0.0789
        pgm_function13[(60, 17, 37)] = 0.2333
        pgm_function13[(60, 17, 38)] = 0.3344
        pgm_function13[(60, 17, 39)] = 0.2678
        pgm_function13[(60, 17, 40)] = 0.1322
        pgm_function13[(60, 17, 41)] = 0.04110413
        pgm_function13[(60, 17, 42)] = 0.0011
        pgm_function13[(60, 18, 33)] = 0.00220022
        pgm_function13[(60, 18, 34)] = 0.062206255
        pgm_function13[(60, 18, 35)] = 0.2211
        pgm_function13[(60, 18, 36)] = 0.3278
        pgm_function13[(60, 18, 37)] = 0.2867
        pgm_function13[(60, 18, 38)] = 0.14668516
        pgm_function13[(60, 18, 39)] = 0.048904934
        pgm_function13[(60, 18, 40)] = 0.002199782
        pgm_function13[(60, 19, 31)] = 0.0011
        pgm_function13[(60, 19, 32)] = 0.0511
        pgm_function13[(60, 19, 33)] = 0.1989
        pgm_function13[(60, 19, 34)] = 0.3233
        pgm_function13[(60, 19, 35)] = 0.2967
        pgm_function13[(60, 19, 36)] = 0.161084147
        pgm_function13[(60, 19, 37)] = 0.056694335
        pgm_function13[(60, 19, 38)] = 0.00440044
        pgm_function13[(60, 20, 30)] = 0.0389
        pgm_function13[(60, 20, 31)] = 0.1767
        pgm_function13[(60, 20, 32)] = 0.32113213
        pgm_function13[(60, 20, 33)] = 0.3056
        pgm_function13[(60, 20, 34)] = 0.177818139
        pgm_function13[(60, 20, 35)] = 0.0656
        pgm_function13[(60, 20, 36)] = 0.0067
        pgm_function13[(60, 21, 28)] = 0.0289
        pgm_function13[(60, 21, 29)] = 0.16
        pgm_function13[(60, 21, 30)] = 0.311131339
        pgm_function13[(60, 21, 31)] = 0.3189
        pgm_function13[(60, 21, 32)] = 0.190019144
        pgm_function13[(60, 21, 33)] = 0.0755924
        pgm_function13[(60, 21, 34)] = 0.01
        pgm_function13[(60, 22, 26)] = 0.01999802
        pgm_function13[(60, 22, 27)] = 0.14
        pgm_function13[(60, 22, 28)] = 0.2989
        pgm_function13[(60, 22, 29)] = 0.3278
        pgm_function13[(60, 22, 30)] = 0.205558811
        pgm_function13[(60, 22, 31)] = 0.085608657
        pgm_function13[(60, 22, 32)] = 0.014402891
        pgm_function13[(60, 23, 24)] = 0.014401407
        pgm_function13[(60, 23, 25)] = 0.12
        pgm_function13[(60, 23, 26)] = 0.287771262
        pgm_function13[(60, 23, 27)] = 0.3311
        pgm_function13[(60, 23, 28)] = 0.226677277
        pgm_function13[(60, 23, 29)] = 0.0933
        pgm_function13[(60, 23, 30)] = 0.020002016
        pgm_function13[(60, 24, 22)] = 0.01
        pgm_function13[(60, 24, 23)] = 0.1
        pgm_function13[(60, 24, 24)] = 0.2733
        pgm_function13[(60, 24, 25)] = 0.3344
        pgm_function13[(60, 24, 26)] = 0.245575248
        pgm_function13[(60, 24, 27)] = 0.1033101
        pgm_function13[(60, 24, 28)] = 0.0256
        pgm_function13[(60, 25, 20)] = 0.0056
        pgm_function13[(60, 25, 21)] = 0.0867
        pgm_function13[(60, 25, 22)] = 0.251125171
        pgm_function13[(60, 25, 23)] = 0.3411
        pgm_function13[(60, 25, 24)] = 0.26332616
        pgm_function13[(60, 25, 25)] = 0.11557693
        pgm_function13[(60, 25, 26)] = 0.03219683
        pgm_function13[(60, 26, 18)] = 0.0022
        pgm_function13[(60, 26, 19)] = 0.0722
        pgm_function13[(60, 26, 20)] = 0.22887714
        pgm_function13[(60, 26, 21)] = 0.3467
        pgm_function13[(60, 26, 22)] = 0.2744
        pgm_function13[(60, 26, 23)] = 0.13111307
        pgm_function13[(60, 26, 24)] = 0.0389
        pgm_function13[(60, 27, 16)] = 0.0011
        pgm_function13[(60, 27, 17)] = 0.05779421
        pgm_function13[(60, 27, 18)] = 0.2133
        pgm_function13[(60, 27, 19)] = 0.3377662
        pgm_function13[(60, 27, 20)] = 0.2878
        pgm_function13[(60, 27, 21)] = 0.1467
        pgm_function13[(60, 27, 22)] = 0.0456
        pgm_function13[(60, 27, 23)] = 0.002200221
        pgm_function13[(60, 28, 15)] = 0.04440442
        pgm_function13[(60, 28, 16)] = 0.19782018
        pgm_function13[(60, 28, 17)] = 0.3289
        pgm_function13[(60, 28, 18)] = 0.3033
        pgm_function13[(60, 28, 19)] = 0.1633
        pgm_function13[(60, 28, 20)] = 0.0511
        pgm_function13[(60, 28, 21)] = 0.004400443
        pgm_function13[(60, 29, 13)] = 0.0344
        pgm_function13[(60, 29, 14)] = 0.1744
        pgm_function13[(60, 29, 15)] = 0.3267
        pgm_function13[(60, 29, 16)] = 0.3133
        pgm_function13[(60, 29, 17)] = 0.178918104
        pgm_function13[(60, 29, 18)] = 0.06000604
        pgm_function13[(60, 29, 19)] = 0.00669933
        pgm_function13[(60, 30, 11)] = 0.02559742
        pgm_function13[(60, 30, 12)] = 0.14778513
        pgm_function13[(60, 30, 13)] = 0.321132286
        pgm_function13[(60, 30, 14)] = 0.3211
        pgm_function13[(60, 30, 15)] = 0.2
        pgm_function13[(60, 30, 16)] = 0.068893142
        pgm_function13[(60, 30, 17)] = 0.010001005
        pgm_function13[(60, 31, 9)] = 0.0167
        pgm_function13[(60, 31, 10)] = 0.132213131
        pgm_function13[(60, 31, 11)] = 0.3022
        pgm_function13[(60, 31, 12)] = 0.332233296
        pgm_function13[(60, 31, 13)] = 0.215578218
        pgm_function13[(60, 31, 14)] = 0.0789
        pgm_function13[(60, 31, 15)] = 0.0133
        pgm_function13[(60, 32, 7)] = 0.01
        pgm_function13[(60, 32, 8)] = 0.1167
        pgm_function13[(60, 32, 9)] = 0.2811
        pgm_function13[(60, 32, 10)] = 0.34556528
        pgm_function13[(60, 32, 11)] = 0.2311
        pgm_function13[(60, 32, 12)] = 0.0911
        pgm_function13[(60, 32, 13)] = 0.0178
        pgm_function13[(61, 5, 59)] = 0.0156
        pgm_function13[(61, 5, 60)] = 0.1189
        pgm_function13[(61, 6, 57)] = 0.010001009
        pgm_function13[(61, 6, 58)] = 0.1033
        pgm_function13[(61, 6, 59)] = 0.253275091
        pgm_function13[(61, 6, 60)] = 0.33
        pgm_function13[(61, 7, 55)] = 0.0067
        pgm_function13[(61, 7, 56)] = 0.0878
        pgm_function13[(61, 7, 57)] = 0.2389
        pgm_function13[(61, 7, 58)] = 0.3277672
        pgm_function13[(61, 7, 59)] = 0.2522
        pgm_function13[(61, 7, 60)] = 0.13111317
        pgm_function13[(61, 8, 53)] = 0.0044
        pgm_function13[(61, 8, 54)] = 0.0722
        pgm_function13[(61, 8, 55)] = 0.2256
        pgm_function13[(61, 8, 56)] = 0.3233321
        pgm_function13[(61, 8, 57)] = 0.2722
        pgm_function13[(61, 8, 58)] = 0.144414114
        pgm_function13[(61, 8, 59)] = 0.05
        pgm_function13[(61, 8, 60)] = 0.0044
        pgm_function13[(61, 9, 51)] = 0.0022
        pgm_function13[(61, 9, 52)] = 0.06110616
        pgm_function13[(61, 9, 53)] = 0.20332012
        pgm_function13[(61, 9, 54)] = 0.32223232
        pgm_function13[(61, 9, 55)] = 0.28332808
        pgm_function13[(61, 9, 56)] = 0.160016189
        pgm_function13[(61, 9, 57)] = 0.0567
        pgm_function13[(61, 9, 58)] = 0.0067
        pgm_function13[(61, 10, 50)] = 0.0489
        pgm_function13[(61, 10, 51)] = 0.18
        pgm_function13[(61, 10, 52)] = 0.3189
        pgm_function13[(61, 10, 53)] = 0.292229111
        pgm_function13[(61, 10, 54)] = 0.1756
        pgm_function13[(61, 10, 55)] = 0.064406441
        pgm_function13[(61, 10, 56)] = 0.009999006
        pgm_function13[(61, 11, 48)] = 0.0356
        pgm_function13[(61, 11, 49)] = 0.167817099
        pgm_function13[(61, 11, 50)] = 0.3111
        pgm_function13[(61, 11, 51)] = 0.305569318
        pgm_function13[(61, 11, 52)] = 0.1867
        pgm_function13[(61, 11, 53)] = 0.075592445
        pgm_function13[(61, 11, 54)] = 0.0133
        pgm_function13[(61, 12, 46)] = 0.0244024
        pgm_function13[(61, 12, 47)] = 0.1522
        pgm_function13[(61, 12, 48)] = 0.295570219
        pgm_function13[(61, 12, 49)] = 0.31886815
        pgm_function13[(61, 12, 50)] = 0.198880119
        pgm_function13[(61, 12, 51)] = 0.084408419
        pgm_function13[(61, 12, 52)] = 0.0178
        pgm_function13[(61, 13, 44)] = 0.0189
        pgm_function13[(61, 13, 45)] = 0.130013047
        pgm_function13[(61, 13, 46)] = 0.286671163
        pgm_function13[(61, 13, 47)] = 0.328867122
        pgm_function13[(61, 13, 48)] = 0.2111
        pgm_function13[(61, 13, 49)] = 0.0978
        pgm_function13[(61, 13, 50)] = 0.0222
        pgm_function13[(61, 14, 42)] = 0.013301305
        pgm_function13[(61, 14, 43)] = 0.11
        pgm_function13[(61, 14, 44)] = 0.276672075
        pgm_function13[(61, 14, 45)] = 0.328933151
        pgm_function13[(61, 14, 46)] = 0.2256
        pgm_function13[(61, 14, 47)] = 0.11
        pgm_function13[(61, 14, 48)] = 0.0278
        pgm_function13[(61, 15, 40)] = 0.008899114
        pgm_function13[(61, 15, 41)] = 0.095590407
        pgm_function13[(61, 15, 42)] = 0.25782599
        pgm_function13[(61, 15, 43)] = 0.3311
        pgm_function13[(61, 15, 44)] = 0.243324119
        pgm_function13[(61, 15, 45)] = 0.1222
        pgm_function13[(61, 15, 46)] = 0.0344
        pgm_function13[(61, 16, 38)] = 0.0044
        pgm_function13[(61, 16, 39)] = 0.08330831
        pgm_function13[(61, 16, 40)] = 0.2344
        pgm_function13[(61, 16, 41)] = 0.3367
        pgm_function13[(61, 16, 42)] = 0.2622
        pgm_function13[(61, 16, 43)] = 0.1322
        pgm_function13[(61, 16, 44)] = 0.04110413
        pgm_function13[(61, 16, 45)] = 0.001099891
        pgm_function13[(61, 17, 36)] = 0.0022
        pgm_function13[(61, 17, 37)] = 0.0689
        pgm_function13[(61, 17, 38)] = 0.2156
        pgm_function13[(61, 17, 39)] = 0.3322
        pgm_function13[(61, 17, 40)] = 0.28
        pgm_function13[(61, 17, 41)] = 0.1444141
        pgm_function13[(61, 17, 42)] = 0.0478
        pgm_function13[(61, 17, 43)] = 0.0022
        pgm_function13[(61, 18, 34)] = 0.001100111
        pgm_function13[(61, 18, 35)] = 0.0522
        pgm_function13[(61, 18, 36)] = 0.2022
        pgm_function13[(61, 18, 37)] = 0.3222
        pgm_function13[(61, 18, 38)] = 0.29667033
        pgm_function13[(61, 18, 39)] = 0.156716108
        pgm_function13[(61, 18, 40)] = 0.056694346
        pgm_function13[(61, 18, 41)] = 0.004400878
        pgm_function13[(61, 19, 33)] = 0.0411
        pgm_function13[(61, 19, 34)] = 0.1867
        pgm_function13[(61, 19, 35)] = 0.3156
        pgm_function13[(61, 19, 36)] = 0.305569278
        pgm_function13[(61, 19, 37)] = 0.172183107
        pgm_function13[(61, 19, 38)] = 0.0644064
        pgm_function13[(61, 19, 39)] = 0.0067
        pgm_function13[(61, 20, 31)] = 0.0322
        pgm_function13[(61, 20, 32)] = 0.16221606
        pgm_function13[(61, 20, 33)] = 0.3144
        pgm_function13[(61, 20, 34)] = 0.313331244
        pgm_function13[(61, 20, 35)] = 0.19
        pgm_function13[(61, 20, 36)] = 0.0744
        pgm_function13[(61, 20, 37)] = 0.01
        pgm_function13[(61, 21, 29)] = 0.0222
        pgm_function13[(61, 21, 30)] = 0.142214155
        pgm_function13[(61, 21, 31)] = 0.3056
        pgm_function13[(61, 21, 32)] = 0.321132244
        pgm_function13[(61, 21, 33)] = 0.20437999
        pgm_function13[(61, 21, 34)] = 0.0844
        pgm_function13[(61, 21, 35)] = 0.0144014
        pgm_function13[(61, 22, 27)] = 0.0144
        pgm_function13[(61, 22, 28)] = 0.1256
        pgm_function13[(61, 22, 29)] = 0.2878
        pgm_function13[(61, 22, 30)] = 0.332133694
        pgm_function13[(61, 22, 31)] = 0.218922144
        pgm_function13[(61, 22, 32)] = 0.09441884
        pgm_function13[(61, 22, 33)] = 0.020002012
        pgm_function13[(61, 23, 25)] = 0.01
        pgm_function13[(61, 23, 26)] = 0.106689097
        pgm_function13[(61, 23, 27)] = 0.2722
        pgm_function13[(61, 23, 28)] = 0.335566409
        pgm_function13[(61, 23, 29)] = 0.2378
        pgm_function13[(61, 23, 30)] = 0.103310082
        pgm_function13[(61, 23, 31)] = 0.0256
        pgm_function13[(61, 24, 23)] = 0.0067
        pgm_function13[(61, 24, 24)] = 0.09
        pgm_function13[(61, 24, 25)] = 0.2567
        pgm_function13[(61, 24, 26)] = 0.33666634
        pgm_function13[(61, 24, 27)] = 0.26112626
        pgm_function13[(61, 24, 28)] = 0.1144
        pgm_function13[(61, 24, 29)] = 0.0322
        pgm_function13[(61, 25, 21)] = 0.0044
        pgm_function13[(61, 25, 22)] = 0.074407451
        pgm_function13[(61, 25, 23)] = 0.2356
        pgm_function13[(61, 25, 24)] = 0.3378342
        pgm_function13[(61, 25, 25)] = 0.27554483
        pgm_function13[(61, 25, 26)] = 0.12668711
        pgm_function13[(61, 25, 27)] = 0.0389
        pgm_function13[(61, 26, 19)] = 0.0011
        pgm_function13[(61, 26, 20)] = 0.062193838
        pgm_function13[(61, 26, 21)] = 0.2122
        pgm_function13[(61, 26, 22)] = 0.3411
        pgm_function13[(61, 26, 23)] = 0.28442814
        pgm_function13[(61, 26, 24)] = 0.1444
        pgm_function13[(61, 26, 25)] = 0.04559543
        pgm_function13[(61, 26, 26)] = 0.0022
        pgm_function13[(61, 27, 18)] = 0.0489
        pgm_function13[(61, 27, 19)] = 0.19668012
        pgm_function13[(61, 27, 20)] = 0.3356
        pgm_function13[(61, 27, 21)] = 0.2967
        pgm_function13[(61, 27, 22)] = 0.1622
        pgm_function13[(61, 27, 23)] = 0.051105119
        pgm_function13[(61, 27, 24)] = 0.0044
        pgm_function13[(61, 28, 16)] = 0.03440343
        pgm_function13[(61, 28, 17)] = 0.18
        pgm_function13[(61, 28, 18)] = 0.3256
        pgm_function13[(61, 28, 19)] = 0.31
        pgm_function13[(61, 28, 20)] = 0.1789
        pgm_function13[(61, 28, 21)] = 0.057805844
        pgm_function13[(61, 28, 22)] = 0.00669933
        pgm_function13[(61, 29, 14)] = 0.0267
        pgm_function13[(61, 29, 15)] = 0.1567
        pgm_function13[(61, 29, 16)] = 0.3156
        pgm_function13[(61, 29, 17)] = 0.324432188
        pgm_function13[(61, 29, 18)] = 0.19331913
        pgm_function13[(61, 29, 19)] = 0.0688931
        pgm_function13[(61, 29, 20)] = 0.01
        pgm_function13[(61, 30, 12)] = 0.01999802
        pgm_function13[(61, 30, 13)] = 0.13441312
        pgm_function13[(61, 30, 14)] = 0.3067
        pgm_function13[(61, 30, 15)] = 0.3278
        pgm_function13[(61, 30, 16)] = 0.209979128
        pgm_function13[(61, 30, 17)] = 0.078907938
        pgm_function13[(61, 30, 18)] = 0.0133013
        pgm_function13[(61, 31, 10)] = 0.013301313
        pgm_function13[(61, 31, 11)] = 0.1167
        pgm_function13[(61, 31, 12)] = 0.291129259
        pgm_function13[(61, 31, 13)] = 0.335566339
        pgm_function13[(61, 31, 14)] = 0.2278
        pgm_function13[(61, 31, 15)] = 0.09
        pgm_function13[(61, 31, 16)] = 0.0178
        pgm_function13[(61, 32, 8)] = 0.0078
        pgm_function13[(61, 32, 9)] = 0.1022
        pgm_function13[(61, 32, 10)] = 0.268873218
        pgm_function13[(61, 32, 11)] = 0.3511
        pgm_function13[(61, 32, 12)] = 0.2422
        pgm_function13[(61, 32, 13)] = 0.1033
        pgm_function13[(61, 32, 14)] = 0.02219782
        pgm_function13[(62, 5, 60)] = 0.0122
        pgm_function13[(62, 6, 58)] = 0.0078
        pgm_function13[(62, 6, 59)] = 0.092190833
        pgm_function13[(62, 6, 60)] = 0.2389
        pgm_function13[(62, 7, 56)] = 0.0044
        pgm_function13[(62, 7, 57)] = 0.0789
        pgm_function13[(62, 7, 58)] = 0.222178136
        pgm_function13[(62, 7, 59)] = 0.33
        pgm_function13[(62, 7, 60)] = 0.26442634
        pgm_function13[(62, 8, 54)] = 0.0022
        pgm_function13[(62, 8, 55)] = 0.0622
        pgm_function13[(62, 8, 56)] = 0.20892106
        pgm_function13[(62, 8, 57)] = 0.3189
        pgm_function13[(62, 8, 58)] = 0.280028221
        pgm_function13[(62, 8, 59)] = 0.1589
        pgm_function13[(62, 8, 60)] = 0.0567
        pgm_function13[(62, 9, 52)] = 0.001100111
        pgm_function13[(62, 9, 53)] = 0.05110513
        pgm_function13[(62, 9, 54)] = 0.19001919
        pgm_function13[(62, 9, 55)] = 0.31113109
        pgm_function13[(62, 9, 56)] = 0.293329346
        pgm_function13[(62, 9, 57)] = 0.17
        pgm_function13[(62, 9, 58)] = 0.0644
        pgm_function13[(62, 9, 59)] = 0.010001
        pgm_function13[(62, 10, 51)] = 0.0411
        pgm_function13[(62, 10, 52)] = 0.1678
        pgm_function13[(62, 10, 53)] = 0.311131118
        pgm_function13[(62, 10, 54)] = 0.3
        pgm_function13[(62, 10, 55)] = 0.184418116
        pgm_function13[(62, 10, 56)] = 0.075592445
        pgm_function13[(62, 10, 57)] = 0.013301307
        pgm_function13[(62, 11, 49)] = 0.028902917
        pgm_function13[(62, 11, 50)] = 0.1522
        pgm_function13[(62, 11, 51)] = 0.301070313
        pgm_function13[(62, 11, 52)] = 0.3133
        pgm_function13[(62, 11, 53)] = 0.197780119
        pgm_function13[(62, 11, 54)] = 0.0844
        pgm_function13[(62, 11, 55)] = 0.0178
        pgm_function13[(62, 12, 47)] = 0.02
        pgm_function13[(62, 12, 48)] = 0.1355861
        pgm_function13[(62, 12, 49)] = 0.286671135
        pgm_function13[(62, 12, 50)] = 0.325567195
        pgm_function13[(62, 12, 51)] = 0.210021048
        pgm_function13[(62, 12, 52)] = 0.0956
        pgm_function13[(62, 12, 53)] = 0.0222022
        pgm_function13[(62, 13, 45)] = 0.013301305
        pgm_function13[(62, 13, 46)] = 0.118888068
        pgm_function13[(62, 13, 47)] = 0.2699731
        pgm_function13[(62, 13, 48)] = 0.3333
        pgm_function13[(62, 13, 49)] = 0.2222
        pgm_function13[(62, 13, 50)] = 0.1078
        pgm_function13[(62, 13, 51)] = 0.0278
        pgm_function13[(62, 14, 43)] = 0.01
        pgm_function13[(62, 14, 44)] = 0.097790226
        pgm_function13[(62, 14, 45)] = 0.26112612
        pgm_function13[(62, 14, 46)] = 0.3322
        pgm_function13[(62, 14, 47)] = 0.2389
        pgm_function13[(62, 14, 48)] = 0.1189
        pgm_function13[(62, 14, 49)] = 0.03329674
        pgm_function13[(62, 15, 41)] = 0.00669933
        pgm_function13[(62, 15, 42)] = 0.0833083
        pgm_function13[(62, 15, 43)] = 0.2456
        pgm_function13[(62, 15, 44)] = 0.328933161
        pgm_function13[(62, 15, 45)] = 0.2578
        pgm_function13[(62, 15, 46)] = 0.13
        pgm_function13[(62, 15, 47)] = 0.0411
        pgm_function13[(62, 15, 48)] = 0.0011
        pgm_function13[(62, 16, 39)] = 0.00330033
        pgm_function13[(62, 16, 40)] = 0.0722
        pgm_function13[(62, 16, 41)] = 0.2189
        pgm_function13[(62, 16, 42)] = 0.3278
        pgm_function13[(62, 16, 43)] = 0.2756
        pgm_function13[(62, 16, 44)] = 0.1433141
        pgm_function13[(62, 16, 45)] = 0.047795224
        pgm_function13[(62, 16, 46)] = 0.002200222
        pgm_function13[(62, 17, 37)] = 0.0011
        pgm_function13[(62, 17, 38)] = 0.06
        pgm_function13[(62, 17, 39)] = 0.2
        pgm_function13[(62, 17, 40)] = 0.3278
        pgm_function13[(62, 17, 41)] = 0.2889292
        pgm_function13[(62, 17, 42)] = 0.1567
        pgm_function13[(62, 17, 43)] = 0.0567
        pgm_function13[(62, 17, 44)] = 0.004400439
        pgm_function13[(62, 18, 36)] = 0.0456
        pgm_function13[(62, 18, 37)] = 0.1867
        pgm_function13[(62, 18, 38)] = 0.31556835
        pgm_function13[(62, 18, 39)] = 0.303330209
        pgm_function13[(62, 18, 40)] = 0.169983139
        pgm_function13[(62, 18, 41)] = 0.064412869
        pgm_function13[(62, 18, 42)] = 0.0067
        pgm_function13[(62, 19, 34)] = 0.0322
        pgm_function13[(62, 19, 35)] = 0.1711
        pgm_function13[(62, 19, 36)] = 0.30776928
        pgm_function13[(62, 19, 37)] = 0.316668196
        pgm_function13[(62, 19, 38)] = 0.18561899
        pgm_function13[(62, 19, 39)] = 0.0744
        pgm_function13[(62, 19, 40)] = 0.009999005
        pgm_function13[(62, 20, 32)] = 0.02440241
        pgm_function13[(62, 20, 33)] = 0.1467
        pgm_function13[(62, 20, 34)] = 0.304430237
        pgm_function13[(62, 20, 35)] = 0.3178
        pgm_function13[(62, 20, 36)] = 0.2033
        pgm_function13[(62, 20, 37)] = 0.0822
        pgm_function13[(62, 20, 38)] = 0.014401397
        pgm_function13[(62, 21, 30)] = 0.017801819
        pgm_function13[(62, 21, 31)] = 0.1244
        pgm_function13[(62, 21, 32)] = 0.294429224
        pgm_function13[(62, 21, 33)] = 0.32556698
        pgm_function13[(62, 21, 34)] = 0.2167
        pgm_function13[(62, 21, 35)] = 0.09220922
        pgm_function13[(62, 21, 36)] = 0.02
        pgm_function13[(62, 22, 28)] = 0.0111
        pgm_function13[(62, 22, 29)] = 0.11
        pgm_function13[(62, 22, 30)] = 0.276644745
        pgm_function13[(62, 22, 31)] = 0.334433221
        pgm_function13[(62, 22, 32)] = 0.233346851
        pgm_function13[(62, 22, 33)] = 0.10221006
        pgm_function13[(62, 22, 34)] = 0.0256
        pgm_function13[(62, 23, 26)] = 0.006699336
        pgm_function13[(62, 23, 27)] = 0.0967
        pgm_function13[(62, 23, 28)] = 0.255574312
        pgm_function13[(62, 23, 29)] = 0.34
        pgm_function13[(62, 23, 30)] = 0.252225199
        pgm_function13[(62, 23, 31)] = 0.1144
        pgm_function13[(62, 23, 32)] = 0.0322
        pgm_function13[(62, 24, 24)] = 0.0044
        pgm_function13[(62, 24, 25)] = 0.0789
        pgm_function13[(62, 24, 26)] = 0.23777624
        pgm_function13[(62, 24, 27)] = 0.33443333
        pgm_function13[(62, 24, 28)] = 0.2711
        pgm_function13[(62, 24, 29)] = 0.1267
        pgm_function13[(62, 24, 30)] = 0.0389
        pgm_function13[(62, 25, 22)] = 0.002200221
        pgm_function13[(62, 25, 23)] = 0.0644
        pgm_function13[(62, 25, 24)] = 0.22002213
        pgm_function13[(62, 25, 25)] = 0.3310338
        pgm_function13[(62, 25, 26)] = 0.28667126
        pgm_function13[(62, 25, 27)] = 0.14
        pgm_function13[(62, 25, 28)] = 0.0456
        pgm_function13[(62, 25, 29)] = 0.0022
        pgm_function13[(62, 26, 20)] = 0.001099891
        pgm_function13[(62, 26, 21)] = 0.0522
        pgm_function13[(62, 26, 22)] = 0.1978
        pgm_function13[(62, 26, 23)] = 0.33333317
        pgm_function13[(62, 26, 24)] = 0.2944
        pgm_function13[(62, 26, 25)] = 0.15778409
        pgm_function13[(62, 26, 26)] = 0.0511
        pgm_function13[(62, 26, 27)] = 0.004400442
        pgm_function13[(62, 27, 19)] = 0.03889612
        pgm_function13[(62, 27, 20)] = 0.18
        pgm_function13[(62, 27, 21)] = 0.33
        pgm_function13[(62, 27, 22)] = 0.3044
        pgm_function13[(62, 27, 23)] = 0.177818068
        pgm_function13[(62, 27, 24)] = 0.0578
        pgm_function13[(62, 27, 25)] = 0.00669933
        pgm_function13[(62, 28, 17)] = 0.0289
        pgm_function13[(62, 28, 18)] = 0.1611
        pgm_function13[(62, 28, 19)] = 0.3178
        pgm_function13[(62, 28, 20)] = 0.3178
        pgm_function13[(62, 28, 21)] = 0.193319147
        pgm_function13[(62, 28, 22)] = 0.0666933
        pgm_function13[(62, 28, 23)] = 0.01
        pgm_function13[(62, 29, 15)] = 0.02
        pgm_function13[(62, 29, 16)] = 0.1433
        pgm_function13[(62, 29, 17)] = 0.303330176
        pgm_function13[(62, 29, 18)] = 0.330033221
        pgm_function13[(62, 29, 19)] = 0.20437999
        pgm_function13[(62, 29, 20)] = 0.0778
        pgm_function13[(62, 29, 21)] = 0.013301305
        pgm_function13[(62, 30, 13)] = 0.014401413
        pgm_function13[(62, 30, 14)] = 0.1211
        pgm_function13[(62, 30, 15)] = 0.2922
        pgm_function13[(62, 30, 16)] = 0.336666205
        pgm_function13[(62, 30, 17)] = 0.221122106
        pgm_function13[(62, 30, 18)] = 0.09000903
        pgm_function13[(62, 30, 19)] = 0.0178
        pgm_function13[(62, 31, 11)] = 0.01
        pgm_function13[(62, 31, 12)] = 0.102210091
        pgm_function13[(62, 31, 13)] = 0.278872282
        pgm_function13[(62, 31, 14)] = 0.3411
        pgm_function13[(62, 31, 15)] = 0.24
        pgm_function13[(62, 31, 16)] = 0.1022
        pgm_function13[(62, 31, 17)] = 0.02220222
        pgm_function13[(62, 32, 9)] = 0.0056
        pgm_function13[(62, 32, 10)] = 0.087791271
        pgm_function13[(62, 32, 11)] = 0.25
        pgm_function13[(62, 32, 12)] = 0.3478
        pgm_function13[(62, 32, 13)] = 0.2556
        pgm_function13[(62, 32, 14)] = 0.11558809
        pgm_function13[(62, 32, 15)] = 0.0278
        pgm_function13[(63, 6, 59)] = 0.005599442
        pgm_function13[(63, 6, 60)] = 0.08
        pgm_function13[(63, 7, 57)] = 0.0022
        pgm_function13[(63, 7, 58)] = 0.067793241
        pgm_function13[(63, 7, 59)] = 0.2078
        pgm_function13[(63, 7, 60)] = 0.32443242
        pgm_function13[(63, 8, 55)] = 0.0011
        pgm_function13[(63, 8, 56)] = 0.05440542
        pgm_function13[(63, 8, 57)] = 0.1922
        pgm_function13[(63, 8, 58)] = 0.314431248
        pgm_function13[(63, 8, 59)] = 0.2867
        pgm_function13[(63, 8, 60)] = 0.1689
        pgm_function13[(63, 9, 54)] = 0.04110414
        pgm_function13[(63, 9, 55)] = 0.18001805
        pgm_function13[(63, 9, 56)] = 0.304430359
        pgm_function13[(63, 9, 57)] = 0.3011
        pgm_function13[(63, 9, 58)] = 0.18
        pgm_function13[(63, 9, 59)] = 0.07440742
        pgm_function13[(63, 9, 60)] = 0.0133013
        pgm_function13[(63, 10, 52)] = 0.0322
        pgm_function13[(63, 10, 53)] = 0.15671606
        pgm_function13[(63, 10, 54)] = 0.3011
        pgm_function13[(63, 10, 55)] = 0.311131196
        pgm_function13[(63, 10, 56)] = 0.193281116
        pgm_function13[(63, 10, 57)] = 0.084408444
        pgm_function13[(63, 10, 58)] = 0.0178
        pgm_function13[(63, 11, 50)] = 0.0222
        pgm_function13[(63, 11, 51)] = 0.135586141
        pgm_function13[(63, 11, 52)] = 0.2911
        pgm_function13[(63, 11, 53)] = 0.31666819
        pgm_function13[(63, 11, 54)] = 0.2067
        pgm_function13[(63, 11, 55)] = 0.0956
        pgm_function13[(63, 11, 56)] = 0.022197832
        pgm_function13[(63, 12, 48)] = 0.015598412
        pgm_function13[(63, 12, 49)] = 0.121088057
        pgm_function13[(63, 12, 50)] = 0.273273164
        pgm_function13[(63, 12, 51)] = 0.326733075
        pgm_function13[(63, 12, 52)] = 0.2222
        pgm_function13[(63, 12, 53)] = 0.10671102
        pgm_function13[(63, 12, 54)] = 0.0278
        pgm_function13[(63, 13, 46)] = 0.009999006
        pgm_function13[(63, 13, 47)] = 0.106689039
        pgm_function13[(63, 13, 48)] = 0.2556
        pgm_function13[(63, 13, 49)] = 0.3356
        pgm_function13[(63, 13, 50)] = 0.2356
        pgm_function13[(63, 13, 51)] = 0.1167
        pgm_function13[(63, 13, 52)] = 0.03329675
        pgm_function13[(63, 14, 44)] = 0.006699332
        pgm_function13[(63, 14, 45)] = 0.088908941
        pgm_function13[(63, 14, 46)] = 0.2444
        pgm_function13[(63, 14, 47)] = 0.3322
        pgm_function13[(63, 14, 48)] = 0.2533
        pgm_function13[(63, 14, 49)] = 0.12998716
        pgm_function13[(63, 14, 50)] = 0.0411
        pgm_function13[(63, 14, 51)] = 0.0011
        pgm_function13[(63, 15, 42)] = 0.00440044
        pgm_function13[(63, 15, 43)] = 0.0722
        pgm_function13[(63, 15, 44)] = 0.231123113
        pgm_function13[(63, 15, 45)] = 0.3233
        pgm_function13[(63, 15, 46)] = 0.2722
        pgm_function13[(63, 15, 47)] = 0.14
        pgm_function13[(63, 15, 48)] = 0.0478
        pgm_function13[(63, 15, 49)] = 0.0022
        pgm_function13[(63, 16, 40)] = 0.0022
        pgm_function13[(63, 16, 41)] = 0.0611
        pgm_function13[(63, 16, 42)] = 0.2089
        pgm_function13[(63, 16, 43)] = 0.32
        pgm_function13[(63, 16, 44)] = 0.2856292
        pgm_function13[(63, 16, 45)] = 0.154385079
        pgm_function13[(63, 16, 46)] = 0.056705761
        pgm_function13[(63, 16, 47)] = 0.004400442
        pgm_function13[(63, 17, 39)] = 0.05
        pgm_function13[(63, 17, 40)] = 0.1856
        pgm_function13[(63, 17, 41)] = 0.32113222
        pgm_function13[(63, 17, 42)] = 0.2967
        pgm_function13[(63, 17, 43)] = 0.1678
        pgm_function13[(63, 17, 44)] = 0.064406391
        pgm_function13[(63, 17, 45)] = 0.0067
        pgm_function13[(63, 18, 37)] = 0.0367
        pgm_function13[(63, 18, 38)] = 0.16998319
        pgm_function13[(63, 18, 39)] = 0.313331216
        pgm_function13[(63, 18, 40)] = 0.308869253
        pgm_function13[(63, 18, 41)] = 0.183336912
        pgm_function13[(63, 18, 42)] = 0.0744
        pgm_function13[(63, 18, 43)] = 0.01
        pgm_function13[(63, 19, 35)] = 0.0244
        pgm_function13[(63, 19, 36)] = 0.156684143
        pgm_function13[(63, 19, 37)] = 0.297770185
        pgm_function13[(63, 19, 38)] = 0.31893199
        pgm_function13[(63, 19, 39)] = 0.1989
        pgm_function13[(63, 19, 40)] = 0.082191839
        pgm_function13[(63, 19, 41)] = 0.014401395
        pgm_function13[(63, 20, 33)] = 0.0189
        pgm_function13[(63, 20, 34)] = 0.132213103
        pgm_function13[(63, 20, 35)] = 0.2922
        pgm_function13[(63, 20, 36)] = 0.3244
        pgm_function13[(63, 20, 37)] = 0.2156
        pgm_function13[(63, 20, 38)] = 0.091109078
        pgm_function13[(63, 20, 39)] = 0.020002014
        pgm_function13[(63, 21, 31)] = 0.0133
        pgm_function13[(63, 21, 32)] = 0.112211085
        pgm_function13[(63, 21, 33)] = 0.28107198
        pgm_function13[(63, 21, 34)] = 0.3289
        pgm_function13[(63, 21, 35)] = 0.23222304
        pgm_function13[(63, 21, 36)] = 0.1
        pgm_function13[(63, 21, 37)] = 0.0256
        pgm_function13[(63, 22, 29)] = 0.0089
        pgm_function13[(63, 22, 30)] = 0.095580812
        pgm_function13[(63, 22, 31)] = 0.263326174
        pgm_function13[(63, 22, 32)] = 0.333366787
        pgm_function13[(63, 22, 33)] = 0.248925147
        pgm_function13[(63, 22, 34)] = 0.1133
        pgm_function13[(63, 22, 35)] = 0.0311
        pgm_function13[(63, 23, 27)] = 0.0044
        pgm_function13[(63, 23, 28)] = 0.084391703
        pgm_function13[(63, 23, 29)] = 0.2389
        pgm_function13[(63, 23, 30)] = 0.337834267
        pgm_function13[(63, 23, 31)] = 0.2622
        pgm_function13[(63, 23, 32)] = 0.1267
        pgm_function13[(63, 23, 33)] = 0.03890394
        pgm_function13[(63, 24, 25)] = 0.0022
        pgm_function13[(63, 24, 26)] = 0.069993071
        pgm_function13[(63, 24, 27)] = 0.22112222
        pgm_function13[(63, 24, 28)] = 0.3333
        pgm_function13[(63, 24, 29)] = 0.2789
        pgm_function13[(63, 24, 30)] = 0.1389
        pgm_function13[(63, 24, 31)] = 0.0456
        pgm_function13[(63, 24, 32)] = 0.0011
        pgm_function13[(63, 25, 23)] = 0.0011
        pgm_function13[(63, 25, 24)] = 0.05440543
        pgm_function13[(63, 25, 25)] = 0.20555888
        pgm_function13[(63, 25, 26)] = 0.3299673
        pgm_function13[(63, 25, 27)] = 0.2944
        pgm_function13[(63, 25, 28)] = 0.1544
        pgm_function13[(63, 25, 29)] = 0.0511
        pgm_function13[(63, 25, 30)] = 0.004400442
        pgm_function13[(63, 26, 22)] = 0.0422
        pgm_function13[(63, 26, 23)] = 0.18561909
        pgm_function13[(63, 26, 24)] = 0.3267
        pgm_function13[(63, 26, 25)] = 0.30556918
        pgm_function13[(63, 26, 26)] = 0.1733
        pgm_function13[(63, 26, 27)] = 0.057805832
        pgm_function13[(63, 26, 28)] = 0.006699332
        pgm_function13[(63, 27, 20)] = 0.0311
        pgm_function13[(63, 27, 21)] = 0.1633
        pgm_function13[(63, 27, 22)] = 0.32
        pgm_function13[(63, 27, 23)] = 0.311131118
        pgm_function13[(63, 27, 24)] = 0.19
        pgm_function13[(63, 27, 25)] = 0.0655934
        pgm_function13[(63, 27, 26)] = 0.010001012
        pgm_function13[(63, 28, 18)] = 0.0222
        pgm_function13[(63, 28, 19)] = 0.1444
        pgm_function13[(63, 28, 20)] = 0.3089
        pgm_function13[(63, 28, 21)] = 0.322232245
        pgm_function13[(63, 28, 22)] = 0.20667901
        pgm_function13[(63, 28, 23)] = 0.0756
        pgm_function13[(63, 28, 24)] = 0.0133
        pgm_function13[(63, 29, 16)] = 0.0144
        pgm_function13[(63, 29, 17)] = 0.128913075
        pgm_function13[(63, 29, 18)] = 0.291129195
        pgm_function13[(63, 29, 19)] = 0.33776598
        pgm_function13[(63, 29, 20)] = 0.2167
        pgm_function13[(63, 29, 21)] = 0.086708733
        pgm_function13[(63, 29, 22)] = 0.0178
        pgm_function13[(63, 30, 14)] = 0.01
        pgm_function13[(63, 30, 15)] = 0.1089
        pgm_function13[(63, 30, 16)] = 0.277772169
        pgm_function13[(63, 30, 17)] = 0.344434165
        pgm_function13[(63, 30, 18)] = 0.23112307
        pgm_function13[(63, 30, 19)] = 0.1022
        pgm_function13[(63, 30, 20)] = 0.02220222
        pgm_function13[(63, 31, 12)] = 0.006700676
        pgm_function13[(63, 31, 13)] = 0.089991091
        pgm_function13[(63, 31, 14)] = 0.2611
        pgm_function13[(63, 31, 15)] = 0.3411
        pgm_function13[(63, 31, 16)] = 0.2511
        pgm_function13[(63, 31, 17)] = 0.11441109
        pgm_function13[(63, 31, 18)] = 0.0278
        pgm_function13[(63, 32, 10)] = 0.004399564
        pgm_function13[(63, 32, 11)] = 0.0767
        pgm_function13[(63, 32, 12)] = 0.2389
        pgm_function13[(63, 32, 13)] = 0.3422
        pgm_function13[(63, 32, 14)] = 0.26777321
        pgm_function13[(63, 32, 15)] = 0.13
        pgm_function13[(63, 32, 16)] = 0.03330333
        pgm_function13[(64, 6, 60)] = 0.0044
        pgm_function13[(64, 7, 58)] = 0.001099891
        pgm_function13[(64, 7, 59)] = 0.0567
        pgm_function13[(64, 7, 60)] = 0.19331925
        pgm_function13[(64, 8, 57)] = 0.0456
        pgm_function13[(64, 8, 58)] = 0.178918141
        pgm_function13[(64, 8, 59)] = 0.31
        pgm_function13[(64, 8, 60)] = 0.2922
        pgm_function13[(64, 9, 55)] = 0.03220321
        pgm_function13[(64, 9, 56)] = 0.164416194
        pgm_function13[(64, 9, 57)] = 0.2989
        pgm_function13[(64, 9, 58)] = 0.31
        pgm_function13[(64, 9, 59)] = 0.18891906
        pgm_function13[(64, 9, 60)] = 0.08440843
        pgm_function13[(64, 10, 53)] = 0.024402409
        pgm_function13[(64, 10, 54)] = 0.1433
        pgm_function13[(64, 10, 55)] = 0.290029183
        pgm_function13[(64, 10, 56)] = 0.31666819
        pgm_function13[(64, 10, 57)] = 0.200020104
        pgm_function13[(64, 10, 58)] = 0.0944
        pgm_function13[(64, 10, 59)] = 0.0222
        pgm_function13[(64, 11, 51)] = 0.01889812
        pgm_function13[(64, 11, 52)] = 0.1233
        pgm_function13[(64, 11, 53)] = 0.278872167
        pgm_function13[(64, 11, 54)] = 0.3211
        pgm_function13[(64, 11, 55)] = 0.2178
        pgm_function13[(64, 11, 56)] = 0.106689151
        pgm_function13[(64, 11, 57)] = 0.0278
        pgm_function13[(64, 12, 49)] = 0.012198806
        pgm_function13[(64, 12, 50)] = 0.106689064
        pgm_function13[(64, 12, 51)] = 0.264426061
        pgm_function13[(64, 12, 52)] = 0.3256
        pgm_function13[(64, 12, 53)] = 0.23442304
        pgm_function13[(64, 12, 54)] = 0.1167
        pgm_function13[(64, 12, 55)] = 0.03329673
        pgm_function13[(64, 13, 47)] = 0.006699332
        pgm_function13[(64, 13, 48)] = 0.0944
        pgm_function13[(64, 13, 49)] = 0.2411
        pgm_function13[(64, 13, 50)] = 0.3333
        pgm_function13[(64, 13, 51)] = 0.2511
        pgm_function13[(64, 13, 52)] = 0.12778718
        pgm_function13[(64, 13, 53)] = 0.0411
        pgm_function13[(64, 13, 54)] = 0.001099891
        pgm_function13[(64, 14, 45)] = 0.004400442
        pgm_function13[(64, 14, 46)] = 0.0778
        pgm_function13[(64, 14, 47)] = 0.2267
        pgm_function13[(64, 14, 48)] = 0.33
        pgm_function13[(64, 14, 49)] = 0.26557332
        pgm_function13[(64, 14, 50)] = 0.1378
        pgm_function13[(64, 14, 51)] = 0.0478
        pgm_function13[(64, 14, 52)] = 0.00220022
        pgm_function13[(64, 15, 43)] = 0.0022
        pgm_function13[(64, 15, 44)] = 0.06220623
        pgm_function13[(64, 15, 45)] = 0.2156
        pgm_function13[(64, 15, 46)] = 0.32
        pgm_function13[(64, 15, 47)] = 0.2822
        pgm_function13[(64, 15, 48)] = 0.1511
        pgm_function13[(64, 15, 49)] = 0.0556
        pgm_function13[(64, 15, 50)] = 0.0044
        pgm_function13[(64, 16, 41)] = 0.0011
        pgm_function13[(64, 16, 42)] = 0.0511
        pgm_function13[(64, 16, 43)] = 0.1967
        pgm_function13[(64, 16, 44)] = 0.31443122
        pgm_function13[(64, 16, 45)] = 0.296670151
        pgm_function13[(64, 16, 46)] = 0.164416178
        pgm_function13[(64, 16, 47)] = 0.063306335
        pgm_function13[(64, 16, 48)] = 0.0067
        pgm_function13[(64, 17, 40)] = 0.04
        pgm_function13[(64, 17, 41)] = 0.17221712
        pgm_function13[(64, 17, 42)] = 0.3144
        pgm_function13[(64, 17, 43)] = 0.3044
        pgm_function13[(64, 17, 44)] = 0.178917975
        pgm_function13[(64, 17, 45)] = 0.0733
        pgm_function13[(64, 17, 46)] = 0.01
        pgm_function13[(64, 18, 38)] = 0.02999703
        pgm_function13[(64, 18, 39)] = 0.153315106
        pgm_function13[(64, 18, 40)] = 0.305569251
        pgm_function13[(64, 18, 41)] = 0.311161851
        pgm_function13[(64, 18, 42)] = 0.1967
        pgm_function13[(64, 18, 43)] = 0.0822
        pgm_function13[(64, 18, 44)] = 0.014401402
        pgm_function13[(64, 19, 36)] = 0.018898117
        pgm_function13[(64, 19, 37)] = 0.137786085
        pgm_function13[(64, 19, 38)] = 0.29222899
        pgm_function13[(64, 19, 39)] = 0.3211
        pgm_function13[(64, 19, 40)] = 0.211079099
        pgm_function13[(64, 19, 41)] = 0.091109069
        pgm_function13[(64, 19, 42)] = 0.018901911
        pgm_function13[(64, 20, 34)] = 0.01330131
        pgm_function13[(64, 20, 35)] = 0.12
        pgm_function13[(64, 20, 36)] = 0.2778
        pgm_function13[(64, 20, 37)] = 0.33
        pgm_function13[(64, 20, 38)] = 0.227822945
        pgm_function13[(64, 20, 39)] = 0.098909967
        pgm_function13[(64, 20, 40)] = 0.0256
        pgm_function13[(64, 21, 32)] = 0.010001008
        pgm_function13[(64, 21, 33)] = 0.09998999
        pgm_function13[(64, 21, 34)] = 0.2667
        pgm_function13[(64, 21, 35)] = 0.33333306
        pgm_function13[(64, 21, 36)] = 0.2467
        pgm_function13[(64, 21, 37)] = 0.11
        pgm_function13[(64, 21, 38)] = 0.03110312
        pgm_function13[(64, 22, 30)] = 0.006698654
        pgm_function13[(64, 22, 31)] = 0.083308355
        pgm_function13[(64, 22, 32)] = 0.25004984
        pgm_function13[(64, 22, 33)] = 0.331133195
        pgm_function13[(64, 22, 34)] = 0.26
        pgm_function13[(64, 22, 35)] = 0.1233
        pgm_function13[(64, 22, 36)] = 0.03890395
        pgm_function13[(64, 23, 28)] = 0.002199783
        pgm_function13[(64, 23, 29)] = 0.0722
        pgm_function13[(64, 23, 30)] = 0.224422177
        pgm_function13[(64, 23, 31)] = 0.3356
        pgm_function13[(64, 23, 32)] = 0.2722
        pgm_function13[(64, 23, 33)] = 0.13781412
        pgm_function13[(64, 23, 34)] = 0.04559541
        pgm_function13[(64, 23, 35)] = 0.001100111
        pgm_function13[(64, 24, 26)] = 0.001099891
        pgm_function13[(64, 24, 27)] = 0.06000606
        pgm_function13[(64, 24, 28)] = 0.2056
        pgm_function13[(64, 24, 29)] = 0.3333
        pgm_function13[(64, 24, 30)] = 0.2867
        pgm_function13[(64, 24, 31)] = 0.1522
        pgm_function13[(64, 24, 32)] = 0.0522
        pgm_function13[(64, 24, 33)] = 0.004400442
        pgm_function13[(64, 25, 25)] = 0.04559087
        pgm_function13[(64, 25, 26)] = 0.18778117
        pgm_function13[(64, 25, 27)] = 0.3256
        pgm_function13[(64, 25, 28)] = 0.3022
        pgm_function13[(64, 25, 29)] = 0.17
        pgm_function13[(64, 25, 30)] = 0.057805827
        pgm_function13[(64, 25, 31)] = 0.006699332
        pgm_function13[(64, 26, 23)] = 0.03330332
        pgm_function13[(64, 26, 24)] = 0.1689
        pgm_function13[(64, 26, 25)] = 0.31666819
        pgm_function13[(64, 26, 26)] = 0.3122
        pgm_function13[(64, 26, 27)] = 0.184418103
        pgm_function13[(64, 26, 28)] = 0.065593418
        pgm_function13[(64, 26, 29)] = 0.01
        pgm_function13[(64, 27, 21)] = 0.0244
        pgm_function13[(64, 27, 22)] = 0.1489
        pgm_function13[(64, 27, 23)] = 0.310031118
        pgm_function13[(64, 27, 24)] = 0.3189
        pgm_function13[(64, 27, 25)] = 0.20327999
        pgm_function13[(64, 27, 26)] = 0.075607688
        pgm_function13[(64, 27, 27)] = 0.013301305
        pgm_function13[(64, 28, 19)] = 0.0178
        pgm_function13[(64, 28, 20)] = 0.1278
        pgm_function13[(64, 28, 21)] = 0.297830226
        pgm_function13[(64, 28, 22)] = 0.32996701
        pgm_function13[(64, 28, 23)] = 0.2178
        pgm_function13[(64, 28, 24)] = 0.0856
        pgm_function13[(64, 28, 25)] = 0.0178
        pgm_function13[(64, 29, 17)] = 0.010001006
        pgm_function13[(64, 29, 18)] = 0.112211075
        pgm_function13[(64, 29, 19)] = 0.27887198
        pgm_function13[(64, 29, 20)] = 0.3422
        pgm_function13[(64, 29, 21)] = 0.231123088
        pgm_function13[(64, 29, 22)] = 0.1
        pgm_function13[(64, 29, 23)] = 0.02219782
        pgm_function13[(64, 30, 15)] = 0.0067
        pgm_function13[(64, 30, 16)] = 0.095590458
        pgm_function13[(64, 30, 17)] = 0.258926124
        pgm_function13[(64, 30, 18)] = 0.3478351
        pgm_function13[(64, 30, 19)] = 0.2411
        pgm_function13[(64, 30, 20)] = 0.11331108
        pgm_function13[(64, 30, 21)] = 0.0278
        pgm_function13[(64, 31, 13)] = 0.004399564
        pgm_function13[(64, 31, 14)] = 0.0789
        pgm_function13[(64, 31, 15)] = 0.2456
        pgm_function13[(64, 31, 16)] = 0.3422
        pgm_function13[(64, 31, 17)] = 0.26112621
        pgm_function13[(64, 31, 18)] = 0.1278
        pgm_function13[(64, 31, 19)] = 0.03330332
        pgm_function13[(64, 32, 11)] = 0.0022
        pgm_function13[(64, 32, 12)] = 0.0656
        pgm_function13[(64, 32, 13)] = 0.2267
        pgm_function13[(64, 32, 14)] = 0.33776627
        pgm_function13[(64, 32, 15)] = 0.2811
        pgm_function13[(64, 32, 16)] = 0.14111411
        pgm_function13[(64, 32, 17)] = 0.04000403
        pgm_function13[(64, 32, 18)] = 0.001100111
        pgm_function13[(65, 7, 59)] = 0.0011
        pgm_function13[(65, 7, 60)] = 0.04780486
        pgm_function13[(65, 8, 58)] = 0.036703729
        pgm_function13[(65, 8, 59)] = 0.1633
        pgm_function13[(65, 8, 60)] = 0.3056
        pgm_function13[(65, 9, 56)] = 0.02560263
        pgm_function13[(65, 9, 57)] = 0.1478
        pgm_function13[(65, 9, 58)] = 0.2911
        pgm_function13[(65, 9, 59)] = 0.31333109
        pgm_function13[(65, 9, 60)] = 0.19782006
        pgm_function13[(65, 10, 54)] = 0.0189
        pgm_function13[(65, 10, 55)] = 0.130013082
        pgm_function13[(65, 10, 56)] = 0.275572165
        pgm_function13[(65, 10, 57)] = 0.324432169
        pgm_function13[(65, 10, 58)] = 0.21
        pgm_function13[(65, 10, 59)] = 0.1067
        pgm_function13[(65, 10, 60)] = 0.027797226
        pgm_function13[(65, 11, 52)] = 0.0133
        pgm_function13[(65, 11, 53)] = 0.111089067
        pgm_function13[(65, 11, 54)] = 0.2678
        pgm_function13[(65, 11, 55)] = 0.3244
        pgm_function13[(65, 11, 56)] = 0.227777323
        pgm_function13[(65, 11, 57)] = 0.1167
        pgm_function13[(65, 11, 58)] = 0.0333
        pgm_function13[(65, 12, 50)] = 0.009999006
        pgm_function13[(65, 12, 51)] = 0.094409422
        pgm_function13[(65, 12, 52)] = 0.25
        pgm_function13[(65, 12, 53)] = 0.32443206
        pgm_function13[(65, 12, 54)] = 0.2478
        pgm_function13[(65, 12, 55)] = 0.12558711
        pgm_function13[(65, 12, 56)] = 0.04
        pgm_function13[(65, 12, 57)] = 0.0011
        pgm_function13[(65, 13, 48)] = 0.0056
        pgm_function13[(65, 13, 49)] = 0.0811
        pgm_function13[(65, 13, 50)] = 0.2278
        pgm_function13[(65, 13, 51)] = 0.3278
        pgm_function13[(65, 13, 52)] = 0.26557337
        pgm_function13[(65, 13, 53)] = 0.1356
        pgm_function13[(65, 13, 54)] = 0.047795263
        pgm_function13[(65, 13, 55)] = 0.0022
        pgm_function13[(65, 14, 46)] = 0.0022
        pgm_function13[(65, 14, 47)] = 0.0689
        pgm_function13[(65, 14, 48)] = 0.2111
        pgm_function13[(65, 14, 49)] = 0.32666739
        pgm_function13[(65, 14, 50)] = 0.2767
        pgm_function13[(65, 14, 51)] = 0.1489
        pgm_function13[(65, 14, 52)] = 0.0544054
        pgm_function13[(65, 14, 53)] = 0.004400442
        pgm_function13[(65, 15, 44)] = 0.001100111
        pgm_function13[(65, 15, 45)] = 0.0533
        pgm_function13[(65, 15, 46)] = 0.1978
        pgm_function13[(65, 15, 47)] = 0.3178
        pgm_function13[(65, 15, 48)] = 0.2922
        pgm_function13[(65, 15, 49)] = 0.1622
        pgm_function13[(65, 15, 50)] = 0.0633
        pgm_function13[(65, 15, 51)] = 0.006699337
        pgm_function13[(65, 16, 43)] = 0.0411
        pgm_function13[(65, 16, 44)] = 0.18331813
        pgm_function13[(65, 16, 45)] = 0.306669156
        pgm_function13[(65, 16, 46)] = 0.303330328
        pgm_function13[(65, 16, 47)] = 0.176718099
        pgm_function13[(65, 16, 48)] = 0.0722
        pgm_function13[(65, 16, 49)] = 0.01
        pgm_function13[(65, 17, 41)] = 0.03220322
        pgm_function13[(65, 17, 42)] = 0.1589
        pgm_function13[(65, 17, 43)] = 0.3044
        pgm_function13[(65, 17, 44)] = 0.311130956
        pgm_function13[(65, 17, 45)] = 0.1911
        pgm_function13[(65, 17, 46)] = 0.0822
        pgm_function13[(65, 17, 47)] = 0.0144
        pgm_function13[(65, 18, 39)] = 0.023302316
        pgm_function13[(65, 18, 40)] = 0.137786113
        pgm_function13[(65, 18, 41)] = 0.300059856
        pgm_function13[(65, 18, 42)] = 0.3133
        pgm_function13[(65, 18, 43)] = 0.2067
        pgm_function13[(65, 18, 44)] = 0.091109115
        pgm_function13[(65, 18, 45)] = 0.0189
        pgm_function13[(65, 19, 37)] = 0.01669831
        pgm_function13[(65, 19, 38)] = 0.122212
        pgm_function13[(65, 19, 39)] = 0.2811
        pgm_function13[(65, 19, 40)] = 0.325567153
        pgm_function13[(65, 19, 41)] = 0.225622923
        pgm_function13[(65, 19, 42)] = 0.100010058
        pgm_function13[(65, 19, 43)] = 0.0256
        pgm_function13[(65, 20, 35)] = 0.01
        pgm_function13[(65, 20, 36)] = 0.1067
        pgm_function13[(65, 20, 37)] = 0.2611
        pgm_function13[(65, 20, 38)] = 0.335633919
        pgm_function13[(65, 20, 39)] = 0.242224165
        pgm_function13[(65, 20, 40)] = 0.1089
        pgm_function13[(65, 20, 41)] = 0.03109694
        pgm_function13[(65, 21, 33)] = 0.00669933
        pgm_function13[(65, 21, 34)] = 0.0889
        pgm_function13[(65, 21, 35)] = 0.24562504
        pgm_function13[(65, 21, 36)] = 0.3333
        pgm_function13[(65, 21, 37)] = 0.2578
        pgm_function13[(65, 21, 38)] = 0.1211121
        pgm_function13[(65, 21, 39)] = 0.0389
        pgm_function13[(65, 22, 31)] = 0.004400443
        pgm_function13[(65, 22, 32)] = 0.072214354
        pgm_function13[(65, 22, 33)] = 0.233323138
        pgm_function13[(65, 22, 34)] = 0.3289
        pgm_function13[(65, 22, 35)] = 0.2733
        pgm_function13[(65, 22, 36)] = 0.13331317
        pgm_function13[(65, 22, 37)] = 0.04559543
        pgm_function13[(65, 22, 38)] = 0.0011
        pgm_function13[(65, 23, 29)] = 0.0022
        pgm_function13[(65, 23, 30)] = 0.061106148
        pgm_function13[(65, 23, 31)] = 0.2111
        pgm_function13[(65, 23, 32)] = 0.3311
        pgm_function13[(65, 23, 33)] = 0.28222825
        pgm_function13[(65, 23, 34)] = 0.14998503
        pgm_function13[(65, 23, 35)] = 0.05110514
        pgm_function13[(65, 23, 36)] = 0.004399563
        pgm_function13[(65, 24, 28)] = 0.05
        pgm_function13[(65, 24, 29)] = 0.1889
        pgm_function13[(65, 24, 30)] = 0.33
        pgm_function13[(65, 24, 31)] = 0.2956
        pgm_function13[(65, 24, 32)] = 0.1678
        pgm_function13[(65, 24, 33)] = 0.057805827
        pgm_function13[(65, 24, 34)] = 0.0067
        pgm_function13[(65, 25, 26)] = 0.03669633
        pgm_function13[(65, 25, 27)] = 0.1711
        pgm_function13[(65, 25, 28)] = 0.3189
        pgm_function13[(65, 25, 29)] = 0.3067
        pgm_function13[(65, 25, 30)] = 0.182218084
        pgm_function13[(65, 25, 31)] = 0.065593418
        pgm_function13[(65, 25, 32)] = 0.01
        pgm_function13[(65, 26, 24)] = 0.0267
        pgm_function13[(65, 26, 25)] = 0.15438509
        pgm_function13[(65, 26, 26)] = 0.3056
        pgm_function13[(65, 26, 27)] = 0.318932179
        pgm_function13[(65, 26, 28)] = 0.198880054
        pgm_function13[(65, 26, 29)] = 0.0744
        pgm_function13[(65, 26, 30)] = 0.013301305
        pgm_function13[(65, 27, 22)] = 0.0189
        pgm_function13[(65, 27, 23)] = 0.134413051
        pgm_function13[(65, 27, 24)] = 0.2967
        pgm_function13[(65, 27, 25)] = 0.32886698
        pgm_function13[(65, 27, 26)] = 0.213321247
        pgm_function13[(65, 27, 27)] = 0.085608632
        pgm_function13[(65, 27, 28)] = 0.0178
        pgm_function13[(65, 28, 20)] = 0.0133
        pgm_function13[(65, 28, 21)] = 0.114411087
        pgm_function13[(65, 28, 22)] = 0.28217201
        pgm_function13[(65, 28, 23)] = 0.3333
        pgm_function13[(65, 28, 24)] = 0.23
        pgm_function13[(65, 28, 25)] = 0.0967
        pgm_function13[(65, 28, 26)] = 0.0222
        pgm_function13[(65, 29, 18)] = 0.008900896
        pgm_function13[(65, 29, 19)] = 0.09669029
        pgm_function13[(65, 29, 20)] = 0.2633
        pgm_function13[(65, 29, 21)] = 0.344434131
        pgm_function13[(65, 29, 22)] = 0.2411
        pgm_function13[(65, 29, 23)] = 0.11108909
        pgm_function13[(65, 29, 24)] = 0.0278
        pgm_function13[(65, 30, 16)] = 0.004399563
        pgm_function13[(65, 30, 17)] = 0.084408441
        pgm_function13[(65, 30, 18)] = 0.24332407
        pgm_function13[(65, 30, 19)] = 0.3489
        pgm_function13[(65, 30, 20)] = 0.25442518
        pgm_function13[(65, 30, 21)] = 0.1256
        pgm_function13[(65, 30, 22)] = 0.0333
        pgm_function13[(65, 31, 14)] = 0.0022
        pgm_function13[(65, 31, 15)] = 0.0689
        pgm_function13[(65, 31, 16)] = 0.2267
        pgm_function13[(65, 31, 17)] = 0.34223427
        pgm_function13[(65, 31, 18)] = 0.2733
        pgm_function13[(65, 31, 19)] = 0.14001407
        pgm_function13[(65, 31, 20)] = 0.04000402
        pgm_function13[(65, 31, 21)] = 0.001100111
        pgm_function13[(65, 32, 12)] = 0.0011
        pgm_function13[(65, 32, 13)] = 0.0544
        pgm_function13[(65, 32, 14)] = 0.21107917
        pgm_function13[(65, 32, 15)] = 0.33
        pgm_function13[(65, 32, 16)] = 0.29332923
        pgm_function13[(65, 32, 17)] = 0.15331511
        pgm_function13[(65, 32, 18)] = 0.047804857
        pgm_function13[(65, 32, 19)] = 0.002199783
        pgm_function13[(66, 8, 59)] = 0.0289
        pgm_function13[(66, 8, 60)] = 0.1489
        pgm_function13[(66, 9, 57)] = 0.0211
        pgm_function13[(66, 9, 58)] = 0.1311
        pgm_function13[(66, 9, 59)] = 0.28222808
        pgm_function13[(66, 9, 60)] = 0.3200321
        pgm_function13[(66, 10, 55)] = 0.013301308
        pgm_function13[(66, 10, 56)] = 0.118888071
        pgm_function13[(66, 10, 57)] = 0.265627138
        pgm_function13[(66, 10, 58)] = 0.3289
        pgm_function13[(66, 10, 59)] = 0.2211
        pgm_function13[(66, 10, 60)] = 0.115588106
        pgm_function13[(66, 11, 53)] = 0.009999006
        pgm_function13[(66, 11, 54)] = 0.1
        pgm_function13[(66, 11, 55)] = 0.25
        pgm_function13[(66, 11, 56)] = 0.325567462
        pgm_function13[(66, 11, 57)] = 0.2411
        pgm_function13[(66, 11, 58)] = 0.1256
        pgm_function13[(66, 11, 59)] = 0.04
        pgm_function13[(66, 11, 60)] = 0.0011
        pgm_function13[(66, 12, 51)] = 0.006700672
        pgm_function13[(66, 12, 52)] = 0.0844
        pgm_function13[(66, 12, 53)] = 0.23562404
        pgm_function13[(66, 12, 54)] = 0.3211
        pgm_function13[(66, 12, 55)] = 0.26107423
        pgm_function13[(66, 12, 56)] = 0.1356
        pgm_function13[(66, 12, 57)] = 0.0478
        pgm_function13[(66, 12, 58)] = 0.002200221
        pgm_function13[(66, 13, 49)] = 0.0044
        pgm_function13[(66, 13, 50)] = 0.0711
        pgm_function13[(66, 13, 51)] = 0.2144
        pgm_function13[(66, 13, 52)] = 0.31666844
        pgm_function13[(66, 13, 53)] = 0.2778
        pgm_function13[(66, 13, 54)] = 0.145585191
        pgm_function13[(66, 13, 55)] = 0.0544
        pgm_function13[(66, 13, 56)] = 0.0044
        pgm_function13[(66, 14, 47)] = 0.0011
        pgm_function13[(66, 14, 48)] = 0.0589
        pgm_function13[(66, 14, 49)] = 0.19558023
        pgm_function13[(66, 14, 50)] = 0.3222
        pgm_function13[(66, 14, 51)] = 0.2889
        pgm_function13[(66, 14, 52)] = 0.160016
        pgm_function13[(66, 14, 53)] = 0.063306323
        pgm_function13[(66, 14, 54)] = 0.0067
        pgm_function13[(66, 15, 46)] = 0.0456
        pgm_function13[(66, 15, 47)] = 0.1822
        pgm_function13[(66, 15, 48)] = 0.3122
        pgm_function13[(66, 15, 49)] = 0.2989
        pgm_function13[(66, 15, 50)] = 0.1756
        pgm_function13[(66, 15, 51)] = 0.071092976
        pgm_function13[(66, 15, 52)] = 0.01000101
        pgm_function13[(66, 16, 44)] = 0.03220322
        pgm_function13[(66, 16, 45)] = 0.167783086
        pgm_function13[(66, 16, 46)] = 0.301130325
        pgm_function13[(66, 16, 47)] = 0.310031174
        pgm_function13[(66, 16, 48)] = 0.1889
        pgm_function13[(66, 16, 49)] = 0.08
        pgm_function13[(66, 16, 50)] = 0.014398607
        pgm_function13[(66, 17, 42)] = 0.0244
        pgm_function13[(66, 17, 43)] = 0.1456
        pgm_function13[(66, 17, 44)] = 0.296729958
        pgm_function13[(66, 17, 45)] = 0.3156
        pgm_function13[(66, 17, 46)] = 0.2022
        pgm_function13[(66, 17, 47)] = 0.09
        pgm_function13[(66, 17, 48)] = 0.0189
        pgm_function13[(66, 18, 40)] = 0.018898115
        pgm_function13[(66, 18, 41)] = 0.123324941
        pgm_function13[(66, 18, 42)] = 0.2867
        pgm_function13[(66, 18, 43)] = 0.3211
        pgm_function13[(66, 18, 44)] = 0.218922035
        pgm_function13[(66, 18, 45)] = 0.1
        pgm_function13[(66, 18, 46)] = 0.0256
        pgm_function13[(66, 19, 38)] = 0.0122012
        pgm_function13[(66, 19, 39)] = 0.1078
        pgm_function13[(66, 19, 40)] = 0.268873126
        pgm_function13[(66, 19, 41)] = 0.32443189
        pgm_function13[(66, 19, 42)] = 0.240024139
        pgm_function13[(66, 19, 43)] = 0.1089
        pgm_function13[(66, 19, 44)] = 0.0311
        pgm_function13[(66, 20, 36)] = 0.0067
        pgm_function13[(66, 20, 37)] = 0.0967
        pgm_function13[(66, 20, 38)] = 0.243323942
        pgm_function13[(66, 20, 39)] = 0.333333227
        pgm_function13[(66, 20, 40)] = 0.2544
        pgm_function13[(66, 20, 41)] = 0.11998814
        pgm_function13[(66, 20, 42)] = 0.0389
        pgm_function13[(66, 21, 34)] = 0.0044
        pgm_function13[(66, 21, 35)] = 0.08000801
        pgm_function13[(66, 21, 36)] = 0.2278
        pgm_function13[(66, 21, 37)] = 0.3333
        pgm_function13[(66, 21, 38)] = 0.27002722
        pgm_function13[(66, 21, 39)] = 0.1311
        pgm_function13[(66, 21, 40)] = 0.04559544
        pgm_function13[(66, 21, 41)] = 0.00110011
        pgm_function13[(66, 22, 32)] = 0.002200439
        pgm_function13[(66, 22, 33)] = 0.063306337
        pgm_function13[(66, 22, 34)] = 0.2189
        pgm_function13[(66, 22, 35)] = 0.3278
        pgm_function13[(66, 22, 36)] = 0.28332837
        pgm_function13[(66, 22, 37)] = 0.14668509
        pgm_function13[(66, 22, 38)] = 0.0511
        pgm_function13[(66, 22, 39)] = 0.0033
        pgm_function13[(66, 23, 30)] = 0.001100111
        pgm_function13[(66, 23, 31)] = 0.0511
        pgm_function13[(66, 23, 32)] = 0.1967
        pgm_function13[(66, 23, 33)] = 0.32443229
        pgm_function13[(66, 23, 34)] = 0.29437106
        pgm_function13[(66, 23, 35)] = 0.16441613
        pgm_function13[(66, 23, 36)] = 0.056694342
        pgm_function13[(66, 23, 37)] = 0.0067
        pgm_function13[(66, 24, 29)] = 0.04
        pgm_function13[(66, 24, 30)] = 0.1733
        pgm_function13[(66, 24, 31)] = 0.3211
        pgm_function13[(66, 24, 32)] = 0.3011
        pgm_function13[(66, 24, 33)] = 0.180018083
        pgm_function13[(66, 24, 34)] = 0.0644
        pgm_function13[(66, 24, 35)] = 0.009999009
        pgm_function13[(66, 25, 27)] = 0.03
        pgm_function13[(66, 25, 28)] = 0.1556
        pgm_function13[(66, 25, 29)] = 0.3122
        pgm_function13[(66, 25, 30)] = 0.312231144
        pgm_function13[(66, 25, 31)] = 0.195580053
        pgm_function13[(66, 25, 32)] = 0.0744
        pgm_function13[(66, 25, 33)] = 0.013301298
        pgm_function13[(66, 26, 25)] = 0.01999801
        pgm_function13[(66, 26, 26)] = 0.14
        pgm_function13[(66, 26, 27)] = 0.298930167
        pgm_function13[(66, 26, 28)] = 0.326667088
        pgm_function13[(66, 26, 29)] = 0.2089
        pgm_function13[(66, 26, 30)] = 0.085608631
        pgm_function13[(66, 26, 31)] = 0.0178
        pgm_function13[(66, 27, 23)] = 0.013301305
        pgm_function13[(66, 27, 24)] = 0.1222
        pgm_function13[(66, 27, 25)] = 0.27997198
        pgm_function13[(66, 27, 26)] = 0.334433388
        pgm_function13[(66, 27, 27)] = 0.224422083
        pgm_function13[(66, 27, 28)] = 0.0956
        pgm_function13[(66, 27, 29)] = 0.0222
        pgm_function13[(66, 28, 21)] = 0.010001008
        pgm_function13[(66, 28, 22)] = 0.10109
        pgm_function13[(66, 28, 23)] = 0.2678
        pgm_function13[(66, 28, 24)] = 0.3389
        pgm_function13[(66, 28, 25)] = 0.2411
        pgm_function13[(66, 28, 26)] = 0.1089
        pgm_function13[(66, 28, 27)] = 0.0278
        pgm_function13[(66, 29, 19)] = 0.00669933
        pgm_function13[(66, 29, 20)] = 0.0856
        pgm_function13[(66, 29, 21)] = 0.247825094
        pgm_function13[(66, 29, 22)] = 0.34
        pgm_function13[(66, 29, 23)] = 0.2555742
        pgm_function13[(66, 29, 24)] = 0.1211
        pgm_function13[(66, 29, 25)] = 0.0333
        pgm_function13[(66, 30, 17)] = 0.002200221
        pgm_function13[(66, 30, 18)] = 0.07330732
        pgm_function13[(66, 30, 19)] = 0.2278
        pgm_function13[(66, 30, 20)] = 0.34333424
        pgm_function13[(66, 30, 21)] = 0.27
        pgm_function13[(66, 30, 22)] = 0.1378
        pgm_function13[(66, 30, 23)] = 0.04
        pgm_function13[(66, 30, 24)] = 0.0011
        pgm_function13[(66, 31, 15)] = 0.0011
        pgm_function13[(66, 31, 16)] = 0.06
        pgm_function13[(66, 31, 17)] = 0.21002117
        pgm_function13[(66, 31, 18)] = 0.3378
        pgm_function13[(66, 31, 19)] = 0.28332814
        pgm_function13[(66, 31, 20)] = 0.15331509
        pgm_function13[(66, 31, 21)] = 0.04670476
        pgm_function13[(66, 31, 22)] = 0.0022
        pgm_function13[(66, 32, 14)] = 0.04559544
        pgm_function13[(66, 32, 15)] = 0.1944
        pgm_function13[(66, 32, 16)] = 0.32443226
        pgm_function13[(66, 32, 17)] = 0.30333021
        pgm_function13[(66, 32, 18)] = 0.164416196
        pgm_function13[(66, 32, 19)] = 0.056694369
        pgm_function13[(66, 32, 20)] = 0.004400441
        pgm_function13[(67, 8, 60)] = 0.0233
        pgm_function13[(67, 9, 58)] = 0.0167
        pgm_function13[(67, 9, 59)] = 0.11781204
        pgm_function13[(67, 9, 60)] = 0.27002708
        pgm_function13[(67, 10, 56)] = 0.009999006
        pgm_function13[(67, 10, 57)] = 0.104410054
        pgm_function13[(67, 10, 58)] = 0.2522
        pgm_function13[(67, 10, 59)] = 0.3256
        pgm_function13[(67, 10, 60)] = 0.235576217
        pgm_function13[(67, 11, 54)] = 0.0067
        pgm_function13[(67, 11, 55)] = 0.09
        pgm_function13[(67, 11, 56)] = 0.235576335
        pgm_function13[(67, 11, 57)] = 0.3244
        pgm_function13[(67, 11, 58)] = 0.2511
        pgm_function13[(67, 11, 59)] = 0.1356
        pgm_function13[(67, 11, 60)] = 0.0478
        pgm_function13[(67, 12, 52)] = 0.0044
        pgm_function13[(67, 12, 53)] = 0.07440741
        pgm_function13[(67, 12, 54)] = 0.2211
        pgm_function13[(67, 12, 55)] = 0.31666829
        pgm_function13[(67, 12, 56)] = 0.2744
        pgm_function13[(67, 12, 57)] = 0.1433
        pgm_function13[(67, 12, 58)] = 0.054405421
        pgm_function13[(67, 12, 59)] = 0.00440044
        pgm_function13[(67, 13, 50)] = 0.0022
        pgm_function13[(67, 13, 51)] = 0.0611
        pgm_function13[(67, 13, 52)] = 0.20557929
        pgm_function13[(67, 13, 53)] = 0.3133
        pgm_function13[(67, 13, 54)] = 0.28997138
        pgm_function13[(67, 13, 55)] = 0.1567
        pgm_function13[(67, 13, 56)] = 0.0633
        pgm_function13[(67, 13, 57)] = 0.006699334
        pgm_function13[(67, 14, 49)] = 0.04889516
        pgm_function13[(67, 14, 50)] = 0.1822
        pgm_function13[(67, 14, 51)] = 0.3111
        pgm_function13[(67, 14, 52)] = 0.29672999
        pgm_function13[(67, 14, 53)] = 0.172217062
        pgm_function13[(67, 14, 54)] = 0.0711
        pgm_function13[(67, 14, 55)] = 0.01
        pgm_function13[(67, 15, 47)] = 0.0367
        pgm_function13[(67, 15, 48)] = 0.1667
        pgm_function13[(67, 15, 49)] = 0.3056
        pgm_function13[(67, 15, 50)] = 0.3022
        pgm_function13[(67, 15, 51)] = 0.1866812
        pgm_function13[(67, 15, 52)] = 0.08000808
        pgm_function13[(67, 15, 53)] = 0.0144
        pgm_function13[(67, 16, 45)] = 0.025597413
        pgm_function13[(67, 16, 46)] = 0.152215164
        pgm_function13[(67, 16, 47)] = 0.294429165
        pgm_function13[(67, 16, 48)] = 0.3111
        pgm_function13[(67, 16, 49)] = 0.2033
        pgm_function13[(67, 16, 50)] = 0.087791241
        pgm_function13[(67, 16, 51)] = 0.0189
        pgm_function13[(67, 17, 43)] = 0.0189
        pgm_function13[(67, 17, 44)] = 0.131112982
        pgm_function13[(67, 17, 45)] = 0.2844
        pgm_function13[(67, 17, 46)] = 0.3222
        pgm_function13[(67, 17, 47)] = 0.2144
        pgm_function13[(67, 17, 48)] = 0.0978
        pgm_function13[(67, 17, 49)] = 0.0244
        pgm_function13[(67, 18, 41)] = 0.013302694
        pgm_function13[(67, 18, 42)] = 0.1122
        pgm_function13[(67, 18, 43)] = 0.2733
        pgm_function13[(67, 18, 44)] = 0.324432052
        pgm_function13[(67, 18, 45)] = 0.2322
        pgm_function13[(67, 18, 46)] = 0.1089
        pgm_function13[(67, 18, 47)] = 0.0311
        pgm_function13[(67, 19, 39)] = 0.01
        pgm_function13[(67, 19, 40)] = 0.095590445
        pgm_function13[(67, 19, 41)] = 0.255625913
        pgm_function13[(67, 19, 42)] = 0.322232187
        pgm_function13[(67, 19, 43)] = 0.2511
        pgm_function13[(67, 19, 44)] = 0.1189
        pgm_function13[(67, 19, 45)] = 0.0378
        pgm_function13[(67, 20, 37)] = 0.0044
        pgm_function13[(67, 20, 38)] = 0.08330828
        pgm_function13[(67, 20, 39)] = 0.231123157
        pgm_function13[(67, 20, 40)] = 0.3289
        pgm_function13[(67, 20, 41)] = 0.26557332
        pgm_function13[(67, 20, 42)] = 0.1311
        pgm_function13[(67, 20, 43)] = 0.04560465
        pgm_function13[(67, 20, 44)] = 0.0011
        pgm_function13[(67, 21, 35)] = 0.00220022
        pgm_function13[(67, 21, 36)] = 0.0711
        pgm_function13[(67, 21, 37)] = 0.2133
        pgm_function13[(67, 21, 38)] = 0.33223327
        pgm_function13[(67, 21, 39)] = 0.2778
        pgm_function13[(67, 21, 40)] = 0.14558512
        pgm_function13[(67, 21, 41)] = 0.05110512
        pgm_function13[(67, 21, 42)] = 0.0033
        pgm_function13[(67, 22, 33)] = 0.001100111
        pgm_function13[(67, 22, 34)] = 0.0533
        pgm_function13[(67, 22, 35)] = 0.1989
        pgm_function13[(67, 22, 36)] = 0.32443242
        pgm_function13[(67, 22, 37)] = 0.29107117
        pgm_function13[(67, 22, 38)] = 0.16
        pgm_function13[(67, 22, 39)] = 0.0578
        pgm_function13[(67, 22, 40)] = 0.0067
        pgm_function13[(67, 23, 32)] = 0.0411
        pgm_function13[(67, 23, 33)] = 0.18441817
        pgm_function13[(67, 23, 34)] = 0.31556806
        pgm_function13[(67, 23, 35)] = 0.30333024
        pgm_function13[(67, 23, 36)] = 0.177782132
        pgm_function13[(67, 23, 37)] = 0.0633
        pgm_function13[(67, 23, 38)] = 0.01
        pgm_function13[(67, 24, 30)] = 0.0322
        pgm_function13[(67, 24, 31)] = 0.1611
        pgm_function13[(67, 24, 32)] = 0.3111
        pgm_function13[(67, 24, 33)] = 0.310031143
        pgm_function13[(67, 24, 34)] = 0.1933
        pgm_function13[(67, 24, 35)] = 0.071092963
        pgm_function13[(67, 24, 36)] = 0.013301306
        pgm_function13[(67, 25, 28)] = 0.0233
        pgm_function13[(67, 25, 29)] = 0.1389
        pgm_function13[(67, 25, 30)] = 0.305631141
        pgm_function13[(67, 25, 31)] = 0.318868086
        pgm_function13[(67, 25, 32)] = 0.2067
        pgm_function13[(67, 25, 33)] = 0.084408388
        pgm_function13[(67, 25, 34)] = 0.0178
        pgm_function13[(67, 26, 26)] = 0.0156
        pgm_function13[(67, 26, 27)] = 0.123312069
        pgm_function13[(67, 26, 28)] = 0.283272076
        pgm_function13[(67, 26, 29)] = 0.3311
        pgm_function13[(67, 26, 30)] = 0.220022079
        pgm_function13[(67, 26, 31)] = 0.0956
        pgm_function13[(67, 26, 32)] = 0.02220221
        pgm_function13[(67, 27, 24)] = 0.01
        pgm_function13[(67, 27, 25)] = 0.10888899
        pgm_function13[(67, 27, 26)] = 0.264426307
        pgm_function13[(67, 27, 27)] = 0.338934125
        pgm_function13[(67, 27, 28)] = 0.2344
        pgm_function13[(67, 27, 29)] = 0.1089
        pgm_function13[(67, 27, 30)] = 0.0278
        pgm_function13[(67, 28, 22)] = 0.00669933
        pgm_function13[(67, 28, 23)] = 0.0911
        pgm_function13[(67, 28, 24)] = 0.25
        pgm_function13[(67, 28, 25)] = 0.3389
        pgm_function13[(67, 28, 26)] = 0.2533
        pgm_function13[(67, 28, 27)] = 0.12
        pgm_function13[(67, 28, 28)] = 0.0333
        pgm_function13[(67, 29, 20)] = 0.0044
        pgm_function13[(67, 29, 21)] = 0.074407428
        pgm_function13[(67, 29, 22)] = 0.2356
        pgm_function13[(67, 29, 23)] = 0.33776627
        pgm_function13[(67, 29, 24)] = 0.2711
        pgm_function13[(67, 29, 25)] = 0.1344
        pgm_function13[(67, 29, 26)] = 0.04
        pgm_function13[(67, 29, 27)] = 0.0011
        pgm_function13[(67, 30, 18)] = 0.00110011
        pgm_function13[(67, 30, 19)] = 0.0611
        pgm_function13[(67, 30, 20)] = 0.21562215
        pgm_function13[(67, 30, 21)] = 0.3344
        pgm_function13[(67, 30, 22)] = 0.2822
        pgm_function13[(67, 30, 23)] = 0.15
        pgm_function13[(67, 30, 24)] = 0.0467
        pgm_function13[(67, 30, 25)] = 0.0022
        pgm_function13[(67, 31, 17)] = 0.05000504
        pgm_function13[(67, 31, 18)] = 0.1933
        pgm_function13[(67, 31, 19)] = 0.33223317
        pgm_function13[(67, 31, 20)] = 0.29332918
        pgm_function13[(67, 31, 21)] = 0.164416212
        pgm_function13[(67, 31, 22)] = 0.0544
        pgm_function13[(67, 31, 23)] = 0.004400441
        pgm_function13[(67, 32, 15)] = 0.0367
        pgm_function13[(67, 32, 16)] = 0.17891814
        pgm_function13[(67, 32, 17)] = 0.32003222
        pgm_function13[(67, 32, 18)] = 0.31113137
        pgm_function13[(67, 32, 19)] = 0.175582214
        pgm_function13[(67, 32, 20)] = 0.06440641
        pgm_function13[(67, 32, 21)] = 0.0067
        pgm_function13[(68, 9, 59)] = 0.0133013
        pgm_function13[(68, 9, 60)] = 0.10441003
        pgm_function13[(68, 10, 57)] = 0.007800784
        pgm_function13[(68, 10, 58)] = 0.09
        pgm_function13[(68, 10, 59)] = 0.2411
        pgm_function13[(68, 10, 60)] = 0.322168296
        pgm_function13[(68, 11, 55)] = 0.0044
        pgm_function13[(68, 11, 56)] = 0.079992114
        pgm_function13[(68, 11, 57)] = 0.22
        pgm_function13[(68, 11, 58)] = 0.3233
        pgm_function13[(68, 11, 59)] = 0.2644
        pgm_function13[(68, 11, 60)] = 0.1422
        pgm_function13[(68, 12, 53)] = 0.00220022
        pgm_function13[(68, 12, 54)] = 0.0644
        pgm_function13[(68, 12, 55)] = 0.20777919
        pgm_function13[(68, 12, 56)] = 0.3133
        pgm_function13[(68, 12, 57)] = 0.2833
        pgm_function13[(68, 12, 58)] = 0.154415059
        pgm_function13[(68, 12, 59)] = 0.0622062
        pgm_function13[(68, 12, 60)] = 0.006699334
        pgm_function13[(68, 13, 51)] = 0.0011
        pgm_function13[(68, 13, 52)] = 0.05109497
        pgm_function13[(68, 13, 53)] = 0.19
        pgm_function13[(68, 13, 54)] = 0.3055694
        pgm_function13[(68, 13, 55)] = 0.2967
        pgm_function13[(68, 13, 56)] = 0.1678
        pgm_function13[(68, 13, 57)] = 0.071092941
        pgm_function13[(68, 13, 58)] = 0.01
        pgm_function13[(68, 14, 50)] = 0.04
        pgm_function13[(68, 14, 51)] = 0.17
        pgm_function13[(68, 14, 52)] = 0.30442999
        pgm_function13[(68, 14, 53)] = 0.301130108
        pgm_function13[(68, 14, 54)] = 0.1822
        pgm_function13[(68, 14, 55)] = 0.08
        pgm_function13[(68, 14, 56)] = 0.0133
        pgm_function13[(68, 15, 48)] = 0.0289
        pgm_function13[(68, 15, 49)] = 0.1522
        pgm_function13[(68, 15, 50)] = 0.3
        pgm_function13[(68, 15, 51)] = 0.306669328
        pgm_function13[(68, 15, 52)] = 0.2011202
        pgm_function13[(68, 15, 53)] = 0.0878
        pgm_function13[(68, 15, 54)] = 0.0189
        pgm_function13[(68, 16, 46)] = 0.020002022
        pgm_function13[(68, 16, 47)] = 0.134413075
        pgm_function13[(68, 16, 48)] = 0.2889
        pgm_function13[(68, 16, 49)] = 0.3167
        pgm_function13[(68, 16, 50)] = 0.215578101
        pgm_function13[(68, 16, 51)] = 0.0967
        pgm_function13[(68, 16, 52)] = 0.0244
        pgm_function13[(68, 17, 44)] = 0.013301298
        pgm_function13[(68, 17, 45)] = 0.1189
        pgm_function13[(68, 17, 46)] = 0.27
        pgm_function13[(68, 17, 47)] = 0.3256
        pgm_function13[(68, 17, 48)] = 0.2278
        pgm_function13[(68, 17, 49)] = 0.1078
        pgm_function13[(68, 17, 50)] = 0.0311
        pgm_function13[(68, 18, 42)] = 0.01
        pgm_function13[(68, 18, 43)] = 0.1
        pgm_function13[(68, 18, 44)] = 0.257826041
        pgm_function13[(68, 18, 45)] = 0.3267
        pgm_function13[(68, 18, 46)] = 0.2422
        pgm_function13[(68, 18, 47)] = 0.1178
        pgm_function13[(68, 18, 48)] = 0.03779623
        pgm_function13[(68, 19, 40)] = 0.006699333
        pgm_function13[(68, 19, 41)] = 0.084408371
        pgm_function13[(68, 19, 42)] = 0.243324141
        pgm_function13[(68, 19, 43)] = 0.3222
        pgm_function13[(68, 19, 44)] = 0.26
        pgm_function13[(68, 19, 45)] = 0.13
        pgm_function13[(68, 19, 46)] = 0.04559542
        pgm_function13[(68, 19, 47)] = 0.0011
        pgm_function13[(68, 20, 38)] = 0.004400439
        pgm_function13[(68, 20, 39)] = 0.072207249
        pgm_function13[(68, 20, 40)] = 0.22
        pgm_function13[(68, 20, 41)] = 0.32666739
        pgm_function13[(68, 20, 42)] = 0.2756
        pgm_function13[(68, 20, 43)] = 0.14331416
        pgm_function13[(68, 20, 44)] = 0.0511
        pgm_function13[(68, 20, 45)] = 0.0033
        pgm_function13[(68, 21, 36)] = 0.0011
        pgm_function13[(68, 21, 37)] = 0.06
        pgm_function13[(68, 21, 38)] = 0.19441916
        pgm_function13[(68, 21, 39)] = 0.3289
        pgm_function13[(68, 21, 40)] = 0.28557123
        pgm_function13[(68, 21, 41)] = 0.15781606
        pgm_function13[(68, 21, 42)] = 0.0578
        pgm_function13[(68, 21, 43)] = 0.006700674
        pgm_function13[(68, 22, 35)] = 0.0456
        pgm_function13[(68, 22, 36)] = 0.18221824
        pgm_function13[(68, 22, 37)] = 0.31996819
        pgm_function13[(68, 22, 38)] = 0.2978
        pgm_function13[(68, 22, 39)] = 0.1756
        pgm_function13[(68, 22, 40)] = 0.0633
        pgm_function13[(68, 22, 41)] = 0.01000101
        pgm_function13[(68, 23, 33)] = 0.03220323
        pgm_function13[(68, 23, 34)] = 0.16888303
        pgm_function13[(68, 23, 35)] = 0.306731242
        pgm_function13[(68, 23, 36)] = 0.308869229
        pgm_function13[(68, 23, 37)] = 0.19
        pgm_function13[(68, 23, 38)] = 0.0711
        pgm_function13[(68, 23, 39)] = 0.0133
        pgm_function13[(68, 24, 31)] = 0.0244
        pgm_function13[(68, 24, 32)] = 0.1478
        pgm_function13[(68, 24, 33)] = 0.302230139
        pgm_function13[(68, 24, 34)] = 0.3178
        pgm_function13[(68, 24, 35)] = 0.205579181
        pgm_function13[(68, 24, 36)] = 0.083308337
        pgm_function13[(68, 24, 37)] = 0.017801806
        pgm_function13[(68, 25, 29)] = 0.0189
        pgm_function13[(68, 25, 30)] = 0.124412057
        pgm_function13[(68, 25, 31)] = 0.291071079
        pgm_function13[(68, 25, 32)] = 0.3244
        pgm_function13[(68, 25, 33)] = 0.21562197
        pgm_function13[(68, 25, 34)] = 0.0944
        pgm_function13[(68, 25, 35)] = 0.0222
        pgm_function13[(68, 26, 27)] = 0.012201207
        pgm_function13[(68, 26, 28)] = 0.108889029
        pgm_function13[(68, 26, 29)] = 0.2733
        pgm_function13[(68, 26, 30)] = 0.33333312
        pgm_function13[(68, 26, 31)] = 0.23
        pgm_function13[(68, 26, 32)] = 0.10781104
        pgm_function13[(68, 26, 33)] = 0.02779721
        pgm_function13[(68, 27, 25)] = 0.00669933
        pgm_function13[(68, 27, 26)] = 0.097809913
        pgm_function13[(68, 27, 27)] = 0.250025093
        pgm_function13[(68, 27, 28)] = 0.3411
        pgm_function13[(68, 27, 29)] = 0.2456
        pgm_function13[(68, 27, 30)] = 0.12
        pgm_function13[(68, 27, 31)] = 0.03330332
        pgm_function13[(68, 28, 23)] = 0.0044
        pgm_function13[(68, 28, 24)] = 0.08
        pgm_function13[(68, 28, 25)] = 0.2322
        pgm_function13[(68, 28, 26)] = 0.3389
        pgm_function13[(68, 28, 27)] = 0.2644
        pgm_function13[(68, 28, 28)] = 0.1322
        pgm_function13[(68, 28, 29)] = 0.04
        pgm_function13[(68, 28, 30)] = 0.0011
        pgm_function13[(68, 29, 21)] = 0.002200221
        pgm_function13[(68, 29, 22)] = 0.0644
        pgm_function13[(68, 29, 23)] = 0.21777817
        pgm_function13[(68, 29, 24)] = 0.3311
        pgm_function13[(68, 29, 25)] = 0.2822
        pgm_function13[(68, 29, 26)] = 0.1467
        pgm_function13[(68, 29, 27)] = 0.0467
        pgm_function13[(68, 29, 28)] = 0.0022
        pgm_function13[(68, 30, 19)] = 0.0011
        pgm_function13[(68, 30, 20)] = 0.05110514
        pgm_function13[(68, 30, 21)] = 0.2
        pgm_function13[(68, 30, 22)] = 0.3267
        pgm_function13[(68, 30, 23)] = 0.2944
        pgm_function13[(68, 30, 24)] = 0.16
        pgm_function13[(68, 30, 25)] = 0.0544
        pgm_function13[(68, 30, 26)] = 0.00440044
        pgm_function13[(68, 31, 18)] = 0.04
        pgm_function13[(68, 31, 19)] = 0.17891809
        pgm_function13[(68, 31, 20)] = 0.3256332
        pgm_function13[(68, 31, 21)] = 0.304430393
        pgm_function13[(68, 31, 22)] = 0.1756
        pgm_function13[(68, 31, 23)] = 0.063306316
        pgm_function13[(68, 31, 24)] = 0.006699334
        pgm_function13[(68, 32, 16)] = 0.02890292
        pgm_function13[(68, 32, 17)] = 0.16001611
        pgm_function13[(68, 32, 18)] = 0.314431374
        pgm_function13[(68, 32, 19)] = 0.31996839
        pgm_function13[(68, 32, 20)] = 0.18891903
        pgm_function13[(68, 32, 21)] = 0.0733
        pgm_function13[(68, 32, 22)] = 0.010001
        pgm_function13[(69, 9, 60)] = 0.010001
        pgm_function13[(69, 10, 58)] = 0.0067
        pgm_function13[(69, 10, 59)] = 0.0789
        pgm_function13[(69, 10, 60)] = 0.22777721
        pgm_function13[(69, 11, 56)] = 0.002199783
        pgm_function13[(69, 11, 57)] = 0.0689
        pgm_function13[(69, 11, 58)] = 0.2078
        pgm_function13[(69, 11, 59)] = 0.3178
        pgm_function13[(69, 11, 60)] = 0.2767
        pgm_function13[(69, 12, 54)] = 0.0011
        pgm_function13[(69, 12, 55)] = 0.05559445
        pgm_function13[(69, 12, 56)] = 0.19
        pgm_function13[(69, 12, 57)] = 0.31
        pgm_function13[(69, 12, 58)] = 0.291129111
        pgm_function13[(69, 12, 59)] = 0.16561701
        pgm_function13[(69, 12, 60)] = 0.071092941
        pgm_function13[(69, 13, 53)] = 0.0422
        pgm_function13[(69, 13, 54)] = 0.17558223
        pgm_function13[(69, 13, 55)] = 0.3011
        pgm_function13[(69, 13, 56)] = 0.2989
        pgm_function13[(69, 13, 57)] = 0.178882102
        pgm_function13[(69, 13, 58)] = 0.08
        pgm_function13[(69, 13, 59)] = 0.01330131
        pgm_function13[(69, 14, 51)] = 0.0322
        pgm_function13[(69, 14, 52)] = 0.157816
        pgm_function13[(69, 14, 53)] = 0.295630106
        pgm_function13[(69, 14, 54)] = 0.3078
        pgm_function13[(69, 14, 55)] = 0.1944
        pgm_function13[(69, 14, 56)] = 0.0889
        pgm_function13[(69, 14, 57)] = 0.018898105
        pgm_function13[(69, 15, 49)] = 0.0233
        pgm_function13[(69, 15, 50)] = 0.1367
        pgm_function13[(69, 15, 51)] = 0.28997131
        pgm_function13[(69, 15, 52)] = 0.31113131
        pgm_function13[(69, 15, 53)] = 0.2111
        pgm_function13[(69, 15, 54)] = 0.0967
        pgm_function13[(69, 15, 55)] = 0.024402407
        pgm_function13[(69, 16, 47)] = 0.016701709
        pgm_function13[(69, 16, 48)] = 0.1189
        pgm_function13[(69, 16, 49)] = 0.2744
        pgm_function13[(69, 16, 50)] = 0.317768149
        pgm_function13[(69, 16, 51)] = 0.2289
        pgm_function13[(69, 16, 52)] = 0.1056
        pgm_function13[(69, 16, 53)] = 0.031103134
        pgm_function13[(69, 17, 45)] = 0.01
        pgm_function13[(69, 17, 46)] = 0.1056
        pgm_function13[(69, 17, 47)] = 0.2567
        pgm_function13[(69, 17, 48)] = 0.3289
        pgm_function13[(69, 17, 49)] = 0.24
        pgm_function13[(69, 17, 50)] = 0.1156
        pgm_function13[(69, 17, 51)] = 0.03779623
        pgm_function13[(69, 18, 43)] = 0.0067
        pgm_function13[(69, 18, 44)] = 0.088908914
        pgm_function13[(69, 18, 45)] = 0.24
        pgm_function13[(69, 18, 46)] = 0.3289
        pgm_function13[(69, 18, 47)] = 0.2533
        pgm_function13[(69, 18, 48)] = 0.12778709
        pgm_function13[(69, 18, 49)] = 0.0456
        pgm_function13[(69, 18, 50)] = 0.001100111
        pgm_function13[(69, 19, 41)] = 0.004400439
        pgm_function13[(69, 19, 42)] = 0.073307343
        pgm_function13[(69, 19, 43)] = 0.2267
        pgm_function13[(69, 19, 44)] = 0.3244
        pgm_function13[(69, 19, 45)] = 0.2722
        pgm_function13[(69, 19, 46)] = 0.14108606
        pgm_function13[(69, 19, 47)] = 0.0511
        pgm_function13[(69, 19, 48)] = 0.0033
        pgm_function13[(69, 20, 39)] = 0.002200221
        pgm_function13[(69, 20, 40)] = 0.0611
        pgm_function13[(69, 20, 41)] = 0.20557925
        pgm_function13[(69, 20, 42)] = 0.3189
        pgm_function13[(69, 20, 43)] = 0.28442831
        pgm_function13[(69, 20, 44)] = 0.1544
        pgm_function13[(69, 20, 45)] = 0.0578
        pgm_function13[(69, 20, 46)] = 0.0067
        pgm_function13[(69, 21, 38)] = 0.05110514
        pgm_function13[(69, 21, 39)] = 0.1822
        pgm_function13[(69, 21, 40)] = 0.31996826
        pgm_function13[(69, 21, 41)] = 0.29442911
        pgm_function13[(69, 21, 42)] = 0.1711
        pgm_function13[(69, 21, 43)] = 0.06330634
        pgm_function13[(69, 21, 44)] = 0.01000101
        pgm_function13[(69, 22, 36)] = 0.03780385
        pgm_function13[(69, 22, 37)] = 0.1666831
        pgm_function13[(69, 22, 38)] = 0.3156
        pgm_function13[(69, 22, 39)] = 0.3033
        pgm_function13[(69, 22, 40)] = 0.1878
        pgm_function13[(69, 22, 41)] = 0.07110716
        pgm_function13[(69, 22, 42)] = 0.0133
        pgm_function13[(69, 23, 34)] = 0.02559741
        pgm_function13[(69, 23, 35)] = 0.153315121
        pgm_function13[(69, 23, 36)] = 0.299970222
        pgm_function13[(69, 23, 37)] = 0.3156
        pgm_function13[(69, 23, 38)] = 0.2033
        pgm_function13[(69, 23, 39)] = 0.0811
        pgm_function13[(69, 23, 40)] = 0.0178
        pgm_function13[(69, 24, 32)] = 0.0189
        pgm_function13[(69, 24, 33)] = 0.132213061
        pgm_function13[(69, 24, 34)] = 0.2867
        pgm_function13[(69, 24, 35)] = 0.326667287
        pgm_function13[(69, 24, 36)] = 0.213321094
        pgm_function13[(69, 24, 37)] = 0.092209233
        pgm_function13[(69, 24, 38)] = 0.022202208
        pgm_function13[(69, 25, 30)] = 0.013301306
        pgm_function13[(69, 25, 31)] = 0.11218903
        pgm_function13[(69, 25, 32)] = 0.2767
        pgm_function13[(69, 25, 33)] = 0.332232953
        pgm_function13[(69, 25, 34)] = 0.2256
        pgm_function13[(69, 25, 35)] = 0.1056
        pgm_function13[(69, 25, 36)] = 0.027797223
        pgm_function13[(69, 26, 28)] = 0.009999003
        pgm_function13[(69, 26, 29)] = 0.0956
        pgm_function13[(69, 26, 30)] = 0.260026094
        pgm_function13[(69, 26, 31)] = 0.3333
        pgm_function13[(69, 26, 32)] = 0.24332409
        pgm_function13[(69, 26, 33)] = 0.11778805
        pgm_function13[(69, 26, 34)] = 0.03329673
        pgm_function13[(69, 27, 26)] = 0.004400445
        pgm_function13[(69, 27, 27)] = 0.084408431
        pgm_function13[(69, 27, 28)] = 0.2367
        pgm_function13[(69, 27, 29)] = 0.3378
        pgm_function13[(69, 27, 30)] = 0.2589
        pgm_function13[(69, 27, 31)] = 0.13221307
        pgm_function13[(69, 27, 32)] = 0.03890393
        pgm_function13[(69, 27, 33)] = 0.001099891
        pgm_function13[(69, 28, 24)] = 0.0022
        pgm_function13[(69, 28, 25)] = 0.0722
        pgm_function13[(69, 28, 26)] = 0.2156
        pgm_function13[(69, 28, 27)] = 0.3356
        pgm_function13[(69, 28, 28)] = 0.2756
        pgm_function13[(69, 28, 29)] = 0.1456
        pgm_function13[(69, 28, 30)] = 0.0467
        pgm_function13[(69, 28, 31)] = 0.0022
        pgm_function13[(69, 29, 22)] = 0.0011
        pgm_function13[(69, 29, 23)] = 0.05559444
        pgm_function13[(69, 29, 24)] = 0.2011
        pgm_function13[(69, 29, 25)] = 0.3256
        pgm_function13[(69, 29, 26)] = 0.2922
        pgm_function13[(69, 29, 27)] = 0.1567
        pgm_function13[(69, 29, 28)] = 0.0544
        pgm_function13[(69, 29, 29)] = 0.00440044
        pgm_function13[(69, 30, 21)] = 0.0422
        pgm_function13[(69, 30, 22)] = 0.1878
        pgm_function13[(69, 30, 23)] = 0.3178
        pgm_function13[(69, 30, 24)] = 0.3078
        pgm_function13[(69, 30, 25)] = 0.1711
        pgm_function13[(69, 30, 26)] = 0.0633063
        pgm_function13[(69, 30, 27)] = 0.0067
        pgm_function13[(69, 31, 19)] = 0.03220322
        pgm_function13[(69, 31, 20)] = 0.1633161
        pgm_function13[(69, 31, 21)] = 0.313331404
        pgm_function13[(69, 31, 22)] = 0.3167
        pgm_function13[(69, 31, 23)] = 0.186719049
        pgm_function13[(69, 31, 24)] = 0.072192847
        pgm_function13[(69, 31, 25)] = 0.01
        pgm_function13[(69, 32, 17)] = 0.02330232
        pgm_function13[(69, 32, 18)] = 0.142214169
        pgm_function13[(69, 32, 19)] = 0.305569373
        pgm_function13[(69, 32, 20)] = 0.322232052
        pgm_function13[(69, 32, 21)] = 0.2022
        pgm_function13[(69, 32, 22)] = 0.0833083
        pgm_function13[(69, 32, 23)] = 0.0133013
        pgm_function13[(70, 10, 59)] = 0.0044
        pgm_function13[(70, 10, 60)] = 0.068893163
        pgm_function13[(70, 11, 57)] = 0.0011
        pgm_function13[(70, 11, 58)] = 0.0578
        pgm_function13[(70, 11, 59)] = 0.1944
        pgm_function13[(70, 11, 60)] = 0.3089
        pgm_function13[(70, 12, 56)] = 0.0467
        pgm_function13[(70, 12, 57)] = 0.1767
        pgm_function13[(70, 12, 58)] = 0.306731117
        pgm_function13[(70, 12, 59)] = 0.29222902
        pgm_function13[(70, 12, 60)] = 0.177782101
        pgm_function13[(70, 13, 54)] = 0.034396645
        pgm_function13[(70, 13, 55)] = 0.1622
        pgm_function13[(70, 13, 56)] = 0.2967
        pgm_function13[(70, 13, 57)] = 0.305569174
        pgm_function13[(70, 13, 58)] = 0.19
        pgm_function13[(70, 13, 59)] = 0.08890897
        pgm_function13[(70, 13, 60)] = 0.0189
        pgm_function13[(70, 14, 52)] = 0.0244024
        pgm_function13[(70, 14, 53)] = 0.144414052
        pgm_function13[(70, 14, 54)] = 0.2878
        pgm_function13[(70, 14, 55)] = 0.3111
        pgm_function13[(70, 14, 56)] = 0.2067
        pgm_function13[(70, 14, 57)] = 0.096690326
        pgm_function13[(70, 14, 58)] = 0.0244
        pgm_function13[(70, 15, 50)] = 0.0178
        pgm_function13[(70, 15, 51)] = 0.125587134
        pgm_function13[(70, 15, 52)] = 0.27442727
        pgm_function13[(70, 15, 53)] = 0.3156
        pgm_function13[(70, 15, 54)] = 0.2233
        pgm_function13[(70, 15, 55)] = 0.105611029
        pgm_function13[(70, 15, 56)] = 0.0311
        pgm_function13[(70, 16, 48)] = 0.0133
        pgm_function13[(70, 16, 49)] = 0.1056
        pgm_function13[(70, 16, 50)] = 0.262174123
        pgm_function13[(70, 16, 51)] = 0.3178
        pgm_function13[(70, 16, 52)] = 0.24
        pgm_function13[(70, 16, 53)] = 0.114411125
        pgm_function13[(70, 16, 54)] = 0.0378
        pgm_function13[(70, 17, 46)] = 0.0078
        pgm_function13[(70, 17, 47)] = 0.0933
        pgm_function13[(70, 17, 48)] = 0.2422
        pgm_function13[(70, 17, 49)] = 0.3256
        pgm_function13[(70, 17, 50)] = 0.2533
        pgm_function13[(70, 17, 51)] = 0.12558711
        pgm_function13[(70, 17, 52)] = 0.0444
        pgm_function13[(70, 17, 53)] = 0.0011
        pgm_function13[(70, 18, 44)] = 0.004400441
        pgm_function13[(70, 18, 45)] = 0.08
        pgm_function13[(70, 18, 46)] = 0.2244
        pgm_function13[(70, 18, 47)] = 0.3289
        pgm_function13[(70, 18, 48)] = 0.26557319
        pgm_function13[(70, 18, 49)] = 0.1389
        pgm_function13[(70, 18, 50)] = 0.051105135
        pgm_function13[(70, 18, 51)] = 0.003300332
        pgm_function13[(70, 19, 42)] = 0.002200221
        pgm_function13[(70, 19, 43)] = 0.0644
        pgm_function13[(70, 19, 44)] = 0.21
        pgm_function13[(70, 19, 45)] = 0.3211
        pgm_function13[(70, 19, 46)] = 0.27777211
        pgm_function13[(70, 19, 47)] = 0.1544
        pgm_function13[(70, 19, 48)] = 0.0567
        pgm_function13[(70, 19, 49)] = 0.0056
        pgm_function13[(70, 20, 40)] = 0.0011
        pgm_function13[(70, 20, 41)] = 0.05109496
        pgm_function13[(70, 20, 42)] = 0.1933
        pgm_function13[(70, 20, 43)] = 0.31333134
        pgm_function13[(70, 20, 44)] = 0.2956
        pgm_function13[(70, 20, 45)] = 0.1667
        pgm_function13[(70, 20, 46)] = 0.0633
        pgm_function13[(70, 20, 47)] = 0.01
        pgm_function13[(70, 21, 39)] = 0.0411
        pgm_function13[(70, 21, 40)] = 0.17108314
        pgm_function13[(70, 21, 41)] = 0.31223112
        pgm_function13[(70, 21, 42)] = 0.3022
        pgm_function13[(70, 21, 43)] = 0.183318115
        pgm_function13[(70, 21, 44)] = 0.07110716
        pgm_function13[(70, 21, 45)] = 0.013301311
        pgm_function13[(70, 22, 37)] = 0.02999702
        pgm_function13[(70, 22, 38)] = 0.15
        pgm_function13[(70, 22, 39)] = 0.3044
        pgm_function13[(70, 22, 40)] = 0.3078
        pgm_function13[(70, 22, 41)] = 0.20112018
        pgm_function13[(70, 22, 42)] = 0.08
        pgm_function13[(70, 22, 43)] = 0.0178
        pgm_function13[(70, 23, 35)] = 0.020002016
        pgm_function13[(70, 23, 36)] = 0.136686101
        pgm_function13[(70, 23, 37)] = 0.29
        pgm_function13[(70, 23, 38)] = 0.3211
        pgm_function13[(70, 23, 39)] = 0.2122
        pgm_function13[(70, 23, 40)] = 0.0922
        pgm_function13[(70, 23, 41)] = 0.0222
        pgm_function13[(70, 24, 33)] = 0.013301306
        pgm_function13[(70, 24, 34)] = 0.1211
        pgm_function13[(70, 24, 35)] = 0.271073239
        pgm_function13[(70, 24, 36)] = 0.331133146
        pgm_function13[(70, 24, 37)] = 0.224422081
        pgm_function13[(70, 24, 38)] = 0.102210039
        pgm_function13[(70, 24, 39)] = 0.0278
        pgm_function13[(70, 25, 31)] = 0.009999003
        pgm_function13[(70, 25, 32)] = 0.1011
        pgm_function13[(70, 25, 33)] = 0.260025964
        pgm_function13[(70, 25, 34)] = 0.3378
        pgm_function13[(70, 25, 35)] = 0.2389
        pgm_function13[(70, 25, 36)] = 0.115588094
        pgm_function13[(70, 25, 37)] = 0.0333
        pgm_function13[(70, 26, 29)] = 0.0067
        pgm_function13[(70, 26, 30)] = 0.08330833
        pgm_function13[(70, 26, 31)] = 0.2478
        pgm_function13[(70, 26, 32)] = 0.33113313
        pgm_function13[(70, 26, 33)] = 0.2555741
        pgm_function13[(70, 26, 34)] = 0.12998712
        pgm_function13[(70, 26, 35)] = 0.0389
        pgm_function13[(70, 26, 36)] = 0.0011
        pgm_function13[(70, 27, 27)] = 0.003300331
        pgm_function13[(70, 27, 28)] = 0.0722
        pgm_function13[(70, 27, 29)] = 0.2233
        pgm_function13[(70, 27, 30)] = 0.33
        pgm_function13[(70, 27, 31)] = 0.27002714
        pgm_function13[(70, 27, 32)] = 0.14441412
        pgm_function13[(70, 27, 33)] = 0.046695324
        pgm_function13[(70, 27, 34)] = 0.002200439
        pgm_function13[(70, 28, 25)] = 0.0011
        pgm_function13[(70, 28, 26)] = 0.0611
        pgm_function13[(70, 28, 27)] = 0.2011
        pgm_function13[(70, 28, 28)] = 0.3289
        pgm_function13[(70, 28, 29)] = 0.2844
        pgm_function13[(70, 28, 30)] = 0.1556
        pgm_function13[(70, 28, 31)] = 0.0544
        pgm_function13[(70, 28, 32)] = 0.00440044
        pgm_function13[(70, 29, 24)] = 0.0478
        pgm_function13[(70, 29, 25)] = 0.1867
        pgm_function13[(70, 29, 26)] = 0.3211
        pgm_function13[(70, 29, 27)] = 0.3
        pgm_function13[(70, 29, 28)] = 0.17
        pgm_function13[(70, 29, 29)] = 0.0622062
        pgm_function13[(70, 29, 30)] = 0.0067
        pgm_function13[(70, 30, 22)] = 0.0322
        pgm_function13[(70, 30, 23)] = 0.1711
        pgm_function13[(70, 30, 24)] = 0.3089
        pgm_function13[(70, 30, 25)] = 0.3178
        pgm_function13[(70, 30, 26)] = 0.18221801
        pgm_function13[(70, 30, 27)] = 0.0722
        pgm_function13[(70, 30, 28)] = 0.01
        pgm_function13[(70, 31, 20)] = 0.02440241
        pgm_function13[(70, 31, 21)] = 0.151115195
        pgm_function13[(70, 31, 22)] = 0.3022
        pgm_function13[(70, 31, 23)] = 0.322232084
        pgm_function13[(70, 31, 24)] = 0.198880129
        pgm_function13[(70, 31, 25)] = 0.0811
        pgm_function13[(70, 31, 26)] = 0.013302691
        pgm_function13[(70, 32, 18)] = 0.018901922
        pgm_function13[(70, 32, 19)] = 0.126687155
        pgm_function13[(70, 32, 20)] = 0.294429047
        pgm_function13[(70, 32, 21)] = 0.3278
        pgm_function13[(70, 32, 22)] = 0.21562201
        pgm_function13[(70, 32, 23)] = 0.09220921
        pgm_function13[(70, 32, 24)] = 0.017801818
        pgm_function13[(71, 10, 60)] = 0.002199782
        pgm_function13[(71, 11, 58)] = 0.0011
        pgm_function13[(71, 11, 59)] = 0.0478
        pgm_function13[(71, 11, 60)] = 0.1844
        pgm_function13[(71, 12, 57)] = 0.0378
        pgm_function13[(71, 12, 58)] = 0.161116061
        pgm_function13[(71, 12, 59)] = 0.30223002
        pgm_function13[(71, 12, 60)] = 0.29777017
        pgm_function13[(71, 13, 55)] = 0.0267
        pgm_function13[(71, 13, 56)] = 0.1467
        pgm_function13[(71, 13, 57)] = 0.291071166
        pgm_function13[(71, 13, 58)] = 0.3056
        pgm_function13[(71, 13, 59)] = 0.20332016
        pgm_function13[(71, 13, 60)] = 0.0967
        pgm_function13[(71, 14, 53)] = 0.018901907
        pgm_function13[(71, 14, 54)] = 0.13
        pgm_function13[(71, 14, 55)] = 0.2756
        pgm_function13[(71, 14, 56)] = 0.3133
        pgm_function13[(71, 14, 57)] = 0.217778059
        pgm_function13[(71, 14, 58)] = 0.1056
        pgm_function13[(71, 14, 59)] = 0.030003029
        pgm_function13[(71, 15, 51)] = 0.013298714
        pgm_function13[(71, 15, 52)] = 0.11331111
        pgm_function13[(71, 15, 53)] = 0.2622
        pgm_function13[(71, 15, 54)] = 0.3189
        pgm_function13[(71, 15, 55)] = 0.234423063
        pgm_function13[(71, 15, 56)] = 0.1144
        pgm_function13[(71, 15, 57)] = 0.0378
        pgm_function13[(71, 16, 49)] = 0.01
        pgm_function13[(71, 16, 50)] = 0.095590445
        pgm_function13[(71, 16, 51)] = 0.2489
        pgm_function13[(71, 16, 52)] = 0.32
        pgm_function13[(71, 16, 53)] = 0.252225275
        pgm_function13[(71, 16, 54)] = 0.1233
        pgm_function13[(71, 16, 55)] = 0.0444
        pgm_function13[(71, 16, 56)] = 0.0011
        pgm_function13[(71, 17, 47)] = 0.0056
        pgm_function13[(71, 17, 48)] = 0.08
        pgm_function13[(71, 17, 49)] = 0.23
        pgm_function13[(71, 17, 50)] = 0.3233
        pgm_function13[(71, 17, 51)] = 0.26557324
        pgm_function13[(71, 17, 52)] = 0.1356
        pgm_function13[(71, 17, 53)] = 0.0511
        pgm_function13[(71, 17, 54)] = 0.0033
        pgm_function13[(71, 18, 45)] = 0.0022
        pgm_function13[(71, 18, 46)] = 0.0689
        pgm_function13[(71, 18, 47)] = 0.21
        pgm_function13[(71, 18, 48)] = 0.32436823
        pgm_function13[(71, 18, 49)] = 0.2733
        pgm_function13[(71, 18, 50)] = 0.152215105
        pgm_function13[(71, 18, 51)] = 0.056705732
        pgm_function13[(71, 18, 52)] = 0.0056
        pgm_function13[(71, 19, 43)] = 0.0011
        pgm_function13[(71, 19, 44)] = 0.0556
        pgm_function13[(71, 19, 45)] = 0.1933
        pgm_function13[(71, 19, 46)] = 0.31886813
        pgm_function13[(71, 19, 47)] = 0.2856
        pgm_function13[(71, 19, 48)] = 0.1656
        pgm_function13[(71, 19, 49)] = 0.0633
        pgm_function13[(71, 19, 50)] = 0.01
        pgm_function13[(71, 20, 42)] = 0.0422
        pgm_function13[(71, 20, 43)] = 0.1800182
        pgm_function13[(71, 20, 44)] = 0.3078
        pgm_function13[(71, 20, 45)] = 0.3
        pgm_function13[(71, 20, 46)] = 0.1811
        pgm_function13[(71, 20, 47)] = 0.07
        pgm_function13[(71, 20, 48)] = 0.0133
        pgm_function13[(71, 21, 40)] = 0.03219683
        pgm_function13[(71, 21, 41)] = 0.15891606
        pgm_function13[(71, 21, 42)] = 0.3011
        pgm_function13[(71, 21, 43)] = 0.310031195
        pgm_function13[(71, 21, 44)] = 0.19441916
        pgm_function13[(71, 21, 45)] = 0.080008065
        pgm_function13[(71, 21, 46)] = 0.017798212
        pgm_function13[(71, 22, 38)] = 0.0244
        pgm_function13[(71, 22, 39)] = 0.1367
        pgm_function13[(71, 22, 40)] = 0.2967
        pgm_function13[(71, 22, 41)] = 0.31223128
        pgm_function13[(71, 22, 42)] = 0.21
        pgm_function13[(71, 22, 43)] = 0.0922
        pgm_function13[(71, 22, 44)] = 0.0222
        pgm_function13[(71, 23, 36)] = 0.015598412
        pgm_function13[(71, 23, 37)] = 0.1211
        pgm_function13[(71, 23, 38)] = 0.2767
        pgm_function13[(71, 23, 39)] = 0.3244
        pgm_function13[(71, 23, 40)] = 0.2222
        pgm_function13[(71, 23, 41)] = 0.1022
        pgm_function13[(71, 23, 42)] = 0.0278
        pgm_function13[(71, 24, 34)] = 0.01
        pgm_function13[(71, 24, 35)] = 0.107789095
        pgm_function13[(71, 24, 36)] = 0.258926114
        pgm_function13[(71, 24, 37)] = 0.336734121
        pgm_function13[(71, 24, 38)] = 0.23672409
        pgm_function13[(71, 24, 39)] = 0.1144
        pgm_function13[(71, 24, 40)] = 0.0333
        pgm_function13[(71, 25, 32)] = 0.0067
        pgm_function13[(71, 25, 33)] = 0.090008987
        pgm_function13[(71, 25, 34)] = 0.2422
        pgm_function13[(71, 25, 35)] = 0.3367
        pgm_function13[(71, 25, 36)] = 0.249975202
        pgm_function13[(71, 25, 37)] = 0.1278
        pgm_function13[(71, 25, 38)] = 0.03890394
        pgm_function13[(71, 25, 39)] = 0.0011
        pgm_function13[(71, 26, 30)] = 0.004400442
        pgm_function13[(71, 26, 31)] = 0.0733
        pgm_function13[(71, 26, 32)] = 0.23112309
        pgm_function13[(71, 26, 33)] = 0.32886713
        pgm_function13[(71, 26, 34)] = 0.26667324
        pgm_function13[(71, 26, 35)] = 0.1411
        pgm_function13[(71, 26, 36)] = 0.0456
        pgm_function13[(71, 26, 37)] = 0.00220022
        pgm_function13[(71, 27, 28)] = 0.0022
        pgm_function13[(71, 27, 29)] = 0.0611
        pgm_function13[(71, 27, 30)] = 0.2122
        pgm_function13[(71, 27, 31)] = 0.32443216
        pgm_function13[(71, 27, 32)] = 0.28222823
        pgm_function13[(71, 27, 33)] = 0.153285078
        pgm_function13[(71, 27, 34)] = 0.053310682
        pgm_function13[(71, 27, 35)] = 0.0044
        pgm_function13[(71, 28, 27)] = 0.0511
        pgm_function13[(71, 28, 28)] = 0.1889
        pgm_function13[(71, 28, 29)] = 0.3222
        pgm_function13[(71, 28, 30)] = 0.2967
        pgm_function13[(71, 28, 31)] = 0.1667
        pgm_function13[(71, 28, 32)] = 0.0622062
        pgm_function13[(71, 28, 33)] = 0.0067
        pgm_function13[(71, 29, 25)] = 0.0378
        pgm_function13[(71, 29, 26)] = 0.1689
        pgm_function13[(71, 29, 27)] = 0.3178
        pgm_function13[(71, 29, 28)] = 0.3089
        pgm_function13[(71, 29, 29)] = 0.18111801
        pgm_function13[(71, 29, 30)] = 0.0722
        pgm_function13[(71, 29, 31)] = 0.010001012
        pgm_function13[(71, 30, 23)] = 0.0267
        pgm_function13[(71, 30, 24)] = 0.1544
        pgm_function13[(71, 30, 25)] = 0.3
        pgm_function13[(71, 30, 26)] = 0.31893202
        pgm_function13[(71, 30, 27)] = 0.1956
        pgm_function13[(71, 30, 28)] = 0.0811
        pgm_function13[(71, 30, 29)] = 0.013302715
        pgm_function13[(71, 31, 21)] = 0.018901924
        pgm_function13[(71, 31, 22)] = 0.1356
        pgm_function13[(71, 31, 23)] = 0.290029075
        pgm_function13[(71, 31, 24)] = 0.328867214
        pgm_function13[(71, 31, 25)] = 0.2111
        pgm_function13[(71, 31, 26)] = 0.092218337
        pgm_function13[(71, 31, 27)] = 0.0178
        pgm_function13[(71, 32, 19)] = 0.013298716
        pgm_function13[(71, 32, 20)] = 0.115612018
        pgm_function13[(71, 32, 21)] = 0.2822
        pgm_function13[(71, 32, 22)] = 0.33003302
        pgm_function13[(71, 32, 23)] = 0.22892302
        pgm_function13[(71, 32, 24)] = 0.1011101
        pgm_function13[(71, 32, 25)] = 0.023302311
        pgm_function13[(72, 11, 60)] = 0.0389
        pgm_function13[(72, 12, 58)] = 0.030003011
        pgm_function13[(72, 12, 59)] = 0.15001501
        pgm_function13[(72, 12, 60)] = 0.292171167
        pgm_function13[(72, 13, 56)] = 0.0222
        pgm_function13[(72, 13, 57)] = 0.128887073
        pgm_function13[(72, 13, 58)] = 0.2844
        pgm_function13[(72, 13, 59)] = 0.30783125
        pgm_function13[(72, 13, 60)] = 0.2144
        pgm_function13[(72, 14, 54)] = 0.0144
        pgm_function13[(72, 14, 55)] = 0.1178
        pgm_function13[(72, 14, 56)] = 0.2656
        pgm_function13[(72, 14, 57)] = 0.316668086
        pgm_function13[(72, 14, 58)] = 0.2278
        pgm_function13[(72, 14, 59)] = 0.114411112
        pgm_function13[(72, 14, 60)] = 0.0378
        pgm_function13[(72, 15, 52)] = 0.01000101
        pgm_function13[(72, 15, 53)] = 0.1022
        pgm_function13[(72, 15, 54)] = 0.2456
        pgm_function13[(72, 15, 55)] = 0.321132087
        pgm_function13[(72, 15, 56)] = 0.2456
        pgm_function13[(72, 15, 57)] = 0.1233
        pgm_function13[(72, 15, 58)] = 0.04440444
        pgm_function13[(72, 15, 59)] = 0.0011
        pgm_function13[(72, 16, 50)] = 0.006699333
        pgm_function13[(72, 16, 51)] = 0.0844
        pgm_function13[(72, 16, 52)] = 0.2311
        pgm_function13[(72, 16, 53)] = 0.320032349
        pgm_function13[(72, 16, 54)] = 0.2622
        pgm_function13[(72, 16, 55)] = 0.1344
        pgm_function13[(72, 16, 56)] = 0.0511
        pgm_function13[(72, 16, 57)] = 0.003299673
        pgm_function13[(72, 17, 48)] = 0.0044
        pgm_function13[(72, 17, 49)] = 0.07
        pgm_function13[(72, 17, 50)] = 0.2156
        pgm_function13[(72, 17, 51)] = 0.31666829
        pgm_function13[(72, 17, 52)] = 0.2767
        pgm_function13[(72, 17, 53)] = 0.1478
        pgm_function13[(72, 17, 54)] = 0.0567
        pgm_function13[(72, 17, 55)] = 0.0056
        pgm_function13[(72, 18, 46)] = 0.0011
        pgm_function13[(72, 18, 47)] = 0.0578
        pgm_function13[(72, 18, 48)] = 0.19558014
        pgm_function13[(72, 18, 49)] = 0.3189
        pgm_function13[(72, 18, 50)] = 0.283328195
        pgm_function13[(72, 18, 51)] = 0.162216092
        pgm_function13[(72, 18, 52)] = 0.0633
        pgm_function13[(72, 18, 53)] = 0.009999005
        pgm_function13[(72, 19, 45)] = 0.0456
        pgm_function13[(72, 19, 46)] = 0.17888207
        pgm_function13[(72, 19, 47)] = 0.3156
        pgm_function13[(72, 19, 48)] = 0.2933
        pgm_function13[(72, 19, 49)] = 0.1811
        pgm_function13[(72, 19, 50)] = 0.0689
        pgm_function13[(72, 19, 51)] = 0.01330131
        pgm_function13[(72, 20, 43)] = 0.03330334
        pgm_function13[(72, 20, 44)] = 0.1633
        pgm_function13[(72, 20, 45)] = 0.3022
        pgm_function13[(72, 20, 46)] = 0.3056
        pgm_function13[(72, 20, 47)] = 0.1922
        pgm_function13[(72, 20, 48)] = 0.0789
        pgm_function13[(72, 20, 49)] = 0.0177982
        pgm_function13[(72, 21, 41)] = 0.02440241
        pgm_function13[(72, 21, 42)] = 0.1456
        pgm_function13[(72, 21, 43)] = 0.291129183
        pgm_function13[(72, 21, 44)] = 0.31443125
        pgm_function13[(72, 21, 45)] = 0.203320165
        pgm_function13[(72, 21, 46)] = 0.091090961
        pgm_function13[(72, 21, 47)] = 0.022202208
        pgm_function13[(72, 22, 39)] = 0.0189
        pgm_function13[(72, 22, 40)] = 0.1244
        pgm_function13[(72, 22, 41)] = 0.28112825
        pgm_function13[(72, 22, 42)] = 0.3211
        pgm_function13[(72, 22, 43)] = 0.2156
        pgm_function13[(72, 22, 44)] = 0.1022
        pgm_function13[(72, 22, 45)] = 0.0278
        pgm_function13[(72, 23, 37)] = 0.0133
        pgm_function13[(72, 23, 38)] = 0.1078
        pgm_function13[(72, 23, 39)] = 0.2667
        pgm_function13[(72, 23, 40)] = 0.3278
        pgm_function13[(72, 23, 41)] = 0.2344
        pgm_function13[(72, 23, 42)] = 0.1133
        pgm_function13[(72, 23, 43)] = 0.0333
        pgm_function13[(72, 24, 35)] = 0.007799227
        pgm_function13[(72, 24, 36)] = 0.094409442
        pgm_function13[(72, 24, 37)] = 0.242224087
        pgm_function13[(72, 24, 38)] = 0.334433127
        pgm_function13[(72, 24, 39)] = 0.25
        pgm_function13[(72, 24, 40)] = 0.1256
        pgm_function13[(72, 24, 41)] = 0.0389
        pgm_function13[(72, 24, 42)] = 0.001099891
        pgm_function13[(72, 25, 33)] = 0.004400439
        pgm_function13[(72, 25, 34)] = 0.08
        pgm_function13[(72, 25, 35)] = 0.2244
        pgm_function13[(72, 25, 36)] = 0.335566272
        pgm_function13[(72, 25, 37)] = 0.2622
        pgm_function13[(72, 25, 38)] = 0.13891414
        pgm_function13[(72, 25, 39)] = 0.0456
        pgm_function13[(72, 25, 40)] = 0.00220022
        pgm_function13[(72, 26, 31)] = 0.0022
        pgm_function13[(72, 26, 32)] = 0.06330632
        pgm_function13[(72, 26, 33)] = 0.21437909
        pgm_function13[(72, 26, 34)] = 0.32556729
        pgm_function13[(72, 26, 35)] = 0.2778
        pgm_function13[(72, 26, 36)] = 0.1522
        pgm_function13[(72, 26, 37)] = 0.05330531
        pgm_function13[(72, 26, 38)] = 0.0044
        pgm_function13[(72, 27, 29)] = 0.0011
        pgm_function13[(72, 27, 30)] = 0.0511
        pgm_function13[(72, 27, 31)] = 0.1978201
        pgm_function13[(72, 27, 32)] = 0.31783225
        pgm_function13[(72, 27, 33)] = 0.295570151
        pgm_function13[(72, 27, 34)] = 0.163332944
        pgm_function13[(72, 27, 35)] = 0.0611
        pgm_function13[(72, 27, 36)] = 0.0067
        pgm_function13[(72, 28, 28)] = 0.0411
        pgm_function13[(72, 28, 29)] = 0.1756
        pgm_function13[(72, 28, 30)] = 0.3133
        pgm_function13[(72, 28, 31)] = 0.3056
        pgm_function13[(72, 28, 32)] = 0.17671799
        pgm_function13[(72, 28, 33)] = 0.0722
        pgm_function13[(72, 28, 34)] = 0.009999009
        pgm_function13[(72, 29, 26)] = 0.0311
        pgm_function13[(72, 29, 27)] = 0.1533
        pgm_function13[(72, 29, 28)] = 0.3067
        pgm_function13[(72, 29, 29)] = 0.31333102
        pgm_function13[(72, 29, 30)] = 0.1922
        pgm_function13[(72, 29, 31)] = 0.0811082
        pgm_function13[(72, 29, 32)] = 0.0133013
        pgm_function13[(72, 30, 24)] = 0.0211
        pgm_function13[(72, 30, 25)] = 0.1378
        pgm_function13[(72, 30, 26)] = 0.29563002
        pgm_function13[(72, 30, 27)] = 0.3233
        pgm_function13[(72, 30, 28)] = 0.2078
        pgm_function13[(72, 30, 29)] = 0.092218503
        pgm_function13[(72, 30, 30)] = 0.0178
        pgm_function13[(72, 31, 22)] = 0.0133
        pgm_function13[(72, 31, 23)] = 0.123312032
        pgm_function13[(72, 31, 24)] = 0.27667218
        pgm_function13[(72, 31, 25)] = 0.3333
        pgm_function13[(72, 31, 26)] = 0.224444847
        pgm_function13[(72, 31, 27)] = 0.1011
        pgm_function13[(72, 31, 28)] = 0.0233
        pgm_function13[(72, 32, 20)] = 0.010001002
        pgm_function13[(72, 32, 21)] = 0.1011
        pgm_function13[(72, 32, 22)] = 0.26442602
        pgm_function13[(72, 32, 23)] = 0.33443303
        pgm_function13[(72, 32, 24)] = 0.243324241
        pgm_function13[(72, 32, 25)] = 0.111111054
        pgm_function13[(72, 32, 26)] = 0.03
        pgm_function13[(73, 12, 59)] = 0.0233023
        pgm_function13[(73, 12, 60)] = 0.136686078
        pgm_function13[(73, 13, 57)] = 0.01779821
        pgm_function13[(73, 13, 58)] = 0.1167
        pgm_function13[(73, 13, 59)] = 0.27222722
        pgm_function13[(73, 13, 60)] = 0.31
        pgm_function13[(73, 14, 55)] = 0.0111
        pgm_function13[(73, 14, 56)] = 0.1033
        pgm_function13[(73, 14, 57)] = 0.253275068
        pgm_function13[(73, 14, 58)] = 0.3178
        pgm_function13[(73, 14, 59)] = 0.242224237
        pgm_function13[(73, 14, 60)] = 0.1222
        pgm_function13[(73, 15, 53)] = 0.0067
        pgm_function13[(73, 15, 54)] = 0.0922
        pgm_function13[(73, 15, 55)] = 0.231123062
        pgm_function13[(73, 15, 56)] = 0.3211
        pgm_function13[(73, 15, 57)] = 0.2544
        pgm_function13[(73, 15, 58)] = 0.13441311
        pgm_function13[(73, 15, 59)] = 0.0511
        pgm_function13[(73, 15, 60)] = 0.0033
        pgm_function13[(73, 16, 51)] = 0.0044
        pgm_function13[(73, 16, 52)] = 0.0767
        pgm_function13[(73, 16, 53)] = 0.214421234
        pgm_function13[(73, 16, 54)] = 0.3178
        pgm_function13[(73, 16, 55)] = 0.2711
        pgm_function13[(73, 16, 56)] = 0.1467
        pgm_function13[(73, 16, 57)] = 0.056694358
        pgm_function13[(73, 16, 58)] = 0.0056
        pgm_function13[(73, 17, 49)] = 0.0022
        pgm_function13[(73, 17, 50)] = 0.06
        pgm_function13[(73, 17, 51)] = 0.20328018
        pgm_function13[(73, 17, 52)] = 0.3122
        pgm_function13[(73, 17, 53)] = 0.2844
        pgm_function13[(73, 17, 54)] = 0.1589
        pgm_function13[(73, 17, 55)] = 0.0633
        pgm_function13[(73, 17, 56)] = 0.0089
        pgm_function13[(73, 18, 47)] = 0.0011
        pgm_function13[(73, 18, 48)] = 0.04889513
        pgm_function13[(73, 18, 49)] = 0.1844
        pgm_function13[(73, 18, 50)] = 0.308931213
        pgm_function13[(73, 18, 51)] = 0.293329167
        pgm_function13[(73, 18, 52)] = 0.1767
        pgm_function13[(73, 18, 53)] = 0.068893134
        pgm_function13[(73, 18, 54)] = 0.0133
        pgm_function13[(73, 19, 46)] = 0.03779622
        pgm_function13[(73, 19, 47)] = 0.1622
        pgm_function13[(73, 19, 48)] = 0.3067
        pgm_function13[(73, 19, 49)] = 0.2989
        pgm_function13[(73, 19, 50)] = 0.1922
        pgm_function13[(73, 19, 51)] = 0.07780787
        pgm_function13[(73, 19, 52)] = 0.0178
        pgm_function13[(73, 20, 44)] = 0.0267
        pgm_function13[(73, 20, 45)] = 0.1489
        pgm_function13[(73, 20, 46)] = 0.2944
        pgm_function13[(73, 20, 47)] = 0.31
        pgm_function13[(73, 20, 48)] = 0.2033
        pgm_function13[(73, 20, 49)] = 0.0888911
        pgm_function13[(73, 20, 50)] = 0.022202217
        pgm_function13[(73, 21, 42)] = 0.0189
        pgm_function13[(73, 21, 43)] = 0.131113083
        pgm_function13[(73, 21, 44)] = 0.28002822
        pgm_function13[(73, 21, 45)] = 0.323332262
        pgm_function13[(73, 21, 46)] = 0.211079141
        pgm_function13[(73, 21, 47)] = 0.101110036
        pgm_function13[(73, 21, 48)] = 0.0278
        pgm_function13[(73, 22, 40)] = 0.0133
        pgm_function13[(73, 22, 41)] = 0.1144111
        pgm_function13[(73, 22, 42)] = 0.2667
        pgm_function13[(73, 22, 43)] = 0.3289
        pgm_function13[(73, 22, 44)] = 0.2278
        pgm_function13[(73, 22, 45)] = 0.1122
        pgm_function13[(73, 22, 46)] = 0.0333
        pgm_function13[(73, 23, 38)] = 0.01
        pgm_function13[(73, 23, 39)] = 0.0956
        pgm_function13[(73, 23, 40)] = 0.25
        pgm_function13[(73, 23, 41)] = 0.3256
        pgm_function13[(73, 23, 42)] = 0.2478
        pgm_function13[(73, 23, 43)] = 0.1244
        pgm_function13[(73, 23, 44)] = 0.03889612
        pgm_function13[(73, 23, 45)] = 0.001099892
        pgm_function13[(73, 24, 36)] = 0.005600562
        pgm_function13[(73, 24, 37)] = 0.08220823
        pgm_function13[(73, 24, 38)] = 0.230023087
        pgm_function13[(73, 24, 39)] = 0.3267
        pgm_function13[(73, 24, 40)] = 0.2611
        pgm_function13[(73, 24, 41)] = 0.1367
        pgm_function13[(73, 24, 42)] = 0.044395649
        pgm_function13[(73, 24, 43)] = 0.002200222
        pgm_function13[(73, 25, 34)] = 0.0022
        pgm_function13[(73, 25, 35)] = 0.0711
        pgm_function13[(73, 25, 36)] = 0.211079171
        pgm_function13[(73, 25, 37)] = 0.3289
        pgm_function13[(73, 25, 38)] = 0.27442727
        pgm_function13[(73, 25, 39)] = 0.15
        pgm_function13[(73, 25, 40)] = 0.0533053
        pgm_function13[(73, 25, 41)] = 0.004400442
        pgm_function13[(73, 26, 32)] = 0.00110011
        pgm_function13[(73, 26, 33)] = 0.05559442
        pgm_function13[(73, 26, 34)] = 0.19888018
        pgm_function13[(73, 26, 35)] = 0.3222
        pgm_function13[(73, 26, 36)] = 0.29
        pgm_function13[(73, 26, 37)] = 0.16221603
        pgm_function13[(73, 26, 38)] = 0.0611
        pgm_function13[(73, 26, 39)] = 0.0067
        pgm_function13[(73, 27, 31)] = 0.04220422
        pgm_function13[(73, 27, 32)] = 0.18331815
        pgm_function13[(73, 27, 33)] = 0.308869158
        pgm_function13[(73, 27, 34)] = 0.304460896
        pgm_function13[(73, 27, 35)] = 0.1756
        pgm_function13[(73, 27, 36)] = 0.07
        pgm_function13[(73, 27, 37)] = 0.009999009
        pgm_function13[(73, 28, 29)] = 0.0322
        pgm_function13[(73, 28, 30)] = 0.1622
        pgm_function13[(73, 28, 31)] = 0.3033
        pgm_function13[(73, 28, 32)] = 0.31443099
        pgm_function13[(73, 28, 33)] = 0.1867
        pgm_function13[(73, 28, 34)] = 0.079992071
        pgm_function13[(73, 28, 35)] = 0.0133
        pgm_function13[(73, 29, 27)] = 0.0244
        pgm_function13[(73, 29, 28)] = 0.1389
        pgm_function13[(73, 29, 29)] = 0.29893002
        pgm_function13[(73, 29, 30)] = 0.3167
        pgm_function13[(73, 29, 31)] = 0.202220249
        pgm_function13[(73, 29, 32)] = 0.0911091
        pgm_function13[(73, 29, 33)] = 0.0178
        pgm_function13[(73, 30, 25)] = 0.0167
        pgm_function13[(73, 30, 26)] = 0.12331201
        pgm_function13[(73, 30, 27)] = 0.2844
        pgm_function13[(73, 30, 28)] = 0.3244
        pgm_function13[(73, 30, 29)] = 0.222244249
        pgm_function13[(73, 30, 30)] = 0.1011
        pgm_function13[(73, 30, 31)] = 0.0233
        pgm_function13[(73, 31, 23)] = 0.010001003
        pgm_function13[(73, 31, 24)] = 0.108889071
        pgm_function13[(73, 31, 25)] = 0.2622
        pgm_function13[(73, 31, 26)] = 0.333366773
        pgm_function13[(73, 31, 27)] = 0.2378
        pgm_function13[(73, 31, 28)] = 0.1111
        pgm_function13[(73, 31, 29)] = 0.0289
        pgm_function13[(73, 32, 21)] = 0.0067
        pgm_function13[(73, 32, 22)] = 0.09220921
        pgm_function13[(73, 32, 23)] = 0.24672502
        pgm_function13[(73, 32, 24)] = 0.334433331
        pgm_function13[(73, 32, 25)] = 0.257826126
        pgm_function13[(73, 32, 26)] = 0.12
        pgm_function13[(73, 32, 27)] = 0.0367
        pgm_function13[(74, 12, 60)] = 0.01779821
        pgm_function13[(74, 13, 58)] = 0.0133
        pgm_function13[(74, 13, 59)] = 0.10441008
        pgm_function13[(74, 13, 60)] = 0.2589
        pgm_function13[(74, 14, 56)] = 0.0089
        pgm_function13[(74, 14, 57)] = 0.089991024
        pgm_function13[(74, 14, 58)] = 0.2411
        pgm_function13[(74, 14, 59)] = 0.314431308
        pgm_function13[(74, 14, 60)] = 0.2511
        pgm_function13[(74, 15, 54)] = 0.0044
        pgm_function13[(74, 15, 55)] = 0.080008022
        pgm_function13[(74, 15, 56)] = 0.2178
        pgm_function13[(74, 15, 57)] = 0.3178
        pgm_function13[(74, 15, 58)] = 0.26442621
        pgm_function13[(74, 15, 59)] = 0.1456
        pgm_function13[(74, 15, 60)] = 0.0567
        pgm_function13[(74, 16, 52)] = 0.0022
        pgm_function13[(74, 16, 53)] = 0.066706773
        pgm_function13[(74, 16, 54)] = 0.2022
        pgm_function13[(74, 16, 55)] = 0.3167
        pgm_function13[(74, 16, 56)] = 0.2767
        pgm_function13[(74, 16, 57)] = 0.157784163
        pgm_function13[(74, 16, 58)] = 0.0633
        pgm_function13[(74, 16, 59)] = 0.008899116
        pgm_function13[(74, 17, 50)] = 0.0011
        pgm_function13[(74, 17, 51)] = 0.05109495
        pgm_function13[(74, 17, 52)] = 0.1878
        pgm_function13[(74, 17, 53)] = 0.3078
        pgm_function13[(74, 17, 54)] = 0.2922
        pgm_function13[(74, 17, 55)] = 0.1722
        pgm_function13[(74, 17, 56)] = 0.07
        pgm_function13[(74, 17, 57)] = 0.0133
        pgm_function13[(74, 18, 49)] = 0.0389
        pgm_function13[(74, 18, 50)] = 0.172217119
        pgm_function13[(74, 18, 51)] = 0.301130172
        pgm_function13[(74, 18, 52)] = 0.3011
        pgm_function13[(74, 18, 53)] = 0.186681093
        pgm_function13[(74, 18, 54)] = 0.0778
        pgm_function13[(74, 18, 55)] = 0.017798209
        pgm_function13[(74, 19, 47)] = 0.03
        pgm_function13[(74, 19, 48)] = 0.1511
        pgm_function13[(74, 19, 49)] = 0.2944
        pgm_function13[(74, 19, 50)] = 0.3044
        pgm_function13[(74, 19, 51)] = 0.20222018
        pgm_function13[(74, 19, 52)] = 0.0867
        pgm_function13[(74, 19, 53)] = 0.0222
        pgm_function13[(74, 20, 45)] = 0.0211
        pgm_function13[(74, 20, 46)] = 0.1322
        pgm_function13[(74, 20, 47)] = 0.2856
        pgm_function13[(74, 20, 48)] = 0.3156
        pgm_function13[(74, 20, 49)] = 0.21217899
        pgm_function13[(74, 20, 50)] = 0.098909975
        pgm_function13[(74, 20, 51)] = 0.0278
        pgm_function13[(74, 21, 43)] = 0.014401409
        pgm_function13[(74, 21, 44)] = 0.1189121
        pgm_function13[(74, 21, 45)] = 0.267827217
        pgm_function13[(74, 21, 46)] = 0.326667219
        pgm_function13[(74, 21, 47)] = 0.22332208
        pgm_function13[(74, 21, 48)] = 0.1111
        pgm_function13[(74, 21, 49)] = 0.0333
        pgm_function13[(74, 22, 41)] = 0.01000101
        pgm_function13[(74, 22, 42)] = 0.1022
        pgm_function13[(74, 22, 43)] = 0.25
        pgm_function13[(74, 22, 44)] = 0.3289
        pgm_function13[(74, 22, 45)] = 0.2389
        pgm_function13[(74, 22, 46)] = 0.1244
        pgm_function13[(74, 22, 47)] = 0.03889613
        pgm_function13[(74, 22, 48)] = 0.001100111
        pgm_function13[(74, 23, 39)] = 0.0067
        pgm_function13[(74, 23, 40)] = 0.0856
        pgm_function13[(74, 23, 41)] = 0.2378
        pgm_function13[(74, 23, 42)] = 0.3222
        pgm_function13[(74, 23, 43)] = 0.2567
        pgm_function13[(74, 23, 44)] = 0.13668608
        pgm_function13[(74, 23, 45)] = 0.044395663
        pgm_function13[(74, 23, 46)] = 0.0022
        pgm_function13[(74, 24, 37)] = 0.004400442
        pgm_function13[(74, 24, 38)] = 0.072207227
        pgm_function13[(74, 24, 39)] = 0.2189
        pgm_function13[(74, 24, 40)] = 0.3211
        pgm_function13[(74, 24, 41)] = 0.2733
        pgm_function13[(74, 24, 42)] = 0.147785164
        pgm_function13[(74, 24, 43)] = 0.052205241
        pgm_function13[(74, 24, 44)] = 0.0044
        pgm_function13[(74, 25, 35)] = 0.0011
        pgm_function13[(74, 25, 36)] = 0.058894148
        pgm_function13[(74, 25, 37)] = 0.1978
        pgm_function13[(74, 25, 38)] = 0.32223232
        pgm_function13[(74, 25, 39)] = 0.2867
        pgm_function13[(74, 25, 40)] = 0.16001601
        pgm_function13[(74, 25, 41)] = 0.061106134
        pgm_function13[(74, 25, 42)] = 0.006699331
        pgm_function13[(74, 26, 34)] = 0.04559544
        pgm_function13[(74, 26, 35)] = 0.1833
        pgm_function13[(74, 26, 36)] = 0.3144
        pgm_function13[(74, 26, 37)] = 0.29673005
        pgm_function13[(74, 26, 38)] = 0.1733
        pgm_function13[(74, 26, 39)] = 0.0689
        pgm_function13[(74, 26, 40)] = 0.01
        pgm_function13[(74, 27, 32)] = 0.03330333
        pgm_function13[(74, 27, 33)] = 0.167783086
        pgm_function13[(74, 27, 34)] = 0.303360897
        pgm_function13[(74, 27, 35)] = 0.31
        pgm_function13[(74, 27, 36)] = 0.1867
        pgm_function13[(74, 27, 37)] = 0.078892171
        pgm_function13[(74, 27, 38)] = 0.013298706
        pgm_function13[(74, 28, 30)] = 0.0244
        pgm_function13[(74, 28, 31)] = 0.1489
        pgm_function13[(74, 28, 32)] = 0.29562999
        pgm_function13[(74, 28, 33)] = 0.32
        pgm_function13[(74, 28, 34)] = 0.198880177
        pgm_function13[(74, 28, 35)] = 0.0889
        pgm_function13[(74, 28, 36)] = 0.017798222
        pgm_function13[(74, 29, 28)] = 0.0189
        pgm_function13[(74, 29, 29)] = 0.12671301
        pgm_function13[(74, 29, 30)] = 0.2889
        pgm_function13[(74, 29, 31)] = 0.324432399
        pgm_function13[(74, 29, 32)] = 0.21672199
        pgm_function13[(74, 29, 33)] = 0.1011
        pgm_function13[(74, 29, 34)] = 0.0233
        pgm_function13[(74, 30, 26)] = 0.0122012
        pgm_function13[(74, 30, 27)] = 0.1078
        pgm_function13[(74, 30, 28)] = 0.2744
        pgm_function13[(74, 30, 29)] = 0.322264361
        pgm_function13[(74, 30, 30)] = 0.2333
        pgm_function13[(74, 30, 31)] = 0.1111
        pgm_function13[(74, 30, 32)] = 0.0289
        pgm_function13[(74, 31, 24)] = 0.007799225
        pgm_function13[(74, 31, 25)] = 0.0967
        pgm_function13[(74, 31, 26)] = 0.248949831
        pgm_function13[(74, 31, 27)] = 0.33
        pgm_function13[(74, 31, 28)] = 0.2522
        pgm_function13[(74, 31, 29)] = 0.1211
        pgm_function13[(74, 31, 30)] = 0.03669633
        pgm_function13[(74, 32, 22)] = 0.00440044
        pgm_function13[(74, 32, 23)] = 0.08220821
        pgm_function13[(74, 32, 24)] = 0.231123229
        pgm_function13[(74, 32, 25)] = 0.332233163
        pgm_function13[(74, 32, 26)] = 0.2689
        pgm_function13[(74, 32, 27)] = 0.1311
        pgm_function13[(74, 32, 28)] = 0.0433
        pgm_function13[(74, 32, 29)] = 0.00110011
        pgm_function13[(75, 13, 59)] = 0.01000101
        pgm_function13[(75, 13, 60)] = 0.0944
        pgm_function13[(75, 14, 57)] = 0.006699332
        pgm_function13[(75, 14, 58)] = 0.0789
        pgm_function13[(75, 14, 59)] = 0.228923224
        pgm_function13[(75, 14, 60)] = 0.3122
        pgm_function13[(75, 15, 55)] = 0.003300331
        pgm_function13[(75, 15, 56)] = 0.0678
        pgm_function13[(75, 15, 57)] = 0.2078
        pgm_function13[(75, 15, 58)] = 0.31333125
        pgm_function13[(75, 15, 59)] = 0.2722
        pgm_function13[(75, 15, 60)] = 0.1578
        pgm_function13[(75, 16, 53)] = 0.001100111
        pgm_function13[(75, 16, 54)] = 0.0567
        pgm_function13[(75, 16, 55)] = 0.1856
        pgm_function13[(75, 16, 56)] = 0.3122
        pgm_function13[(75, 16, 57)] = 0.285571294
        pgm_function13[(75, 16, 58)] = 0.17
        pgm_function13[(75, 16, 59)] = 0.069993048
        pgm_function13[(75, 16, 60)] = 0.0133
        pgm_function13[(75, 17, 52)] = 0.0433
        pgm_function13[(75, 17, 53)] = 0.1722
        pgm_function13[(75, 17, 54)] = 0.3022
        pgm_function13[(75, 17, 55)] = 0.2956
        pgm_function13[(75, 17, 56)] = 0.1844
        pgm_function13[(75, 17, 57)] = 0.0778
        pgm_function13[(75, 17, 58)] = 0.017798209
        pgm_function13[(75, 18, 50)] = 0.031103121
        pgm_function13[(75, 18, 51)] = 0.158916091
        pgm_function13[(75, 18, 52)] = 0.29
        pgm_function13[(75, 18, 53)] = 0.305569153
        pgm_function13[(75, 18, 54)] = 0.1967
        pgm_function13[(75, 18, 55)] = 0.086691343
        pgm_function13[(75, 18, 56)] = 0.0222
        pgm_function13[(75, 19, 48)] = 0.0233
        pgm_function13[(75, 19, 49)] = 0.1389
        pgm_function13[(75, 19, 50)] = 0.2856
        pgm_function13[(75, 19, 51)] = 0.31333128
        pgm_function13[(75, 19, 52)] = 0.2089
        pgm_function13[(75, 19, 53)] = 0.0989
        pgm_function13[(75, 19, 54)] = 0.0278
        pgm_function13[(75, 20, 46)] = 0.0167
        pgm_function13[(75, 20, 47)] = 0.1189
        pgm_function13[(75, 20, 48)] = 0.2733
        pgm_function13[(75, 20, 49)] = 0.31996799
        pgm_function13[(75, 20, 50)] = 0.22332217
        pgm_function13[(75, 20, 51)] = 0.1089
        pgm_function13[(75, 20, 52)] = 0.0333
        pgm_function13[(75, 21, 44)] = 0.01110111
        pgm_function13[(75, 21, 45)] = 0.103310084
        pgm_function13[(75, 21, 46)] = 0.255574171
        pgm_function13[(75, 21, 47)] = 0.326733118
        pgm_function13[(75, 21, 48)] = 0.2356
        pgm_function13[(75, 21, 49)] = 0.1211
        pgm_function13[(75, 21, 50)] = 0.03890394
        pgm_function13[(75, 21, 51)] = 0.00110011
        pgm_function13[(75, 22, 42)] = 0.0067
        pgm_function13[(75, 22, 43)] = 0.0911
        pgm_function13[(75, 22, 44)] = 0.2356
        pgm_function13[(75, 22, 45)] = 0.3289
        pgm_function13[(75, 22, 46)] = 0.2467
        pgm_function13[(75, 22, 47)] = 0.13558609
        pgm_function13[(75, 22, 48)] = 0.044404426
        pgm_function13[(75, 22, 49)] = 0.002200221
        pgm_function13[(75, 23, 40)] = 0.0044
        pgm_function13[(75, 23, 41)] = 0.0756
        pgm_function13[(75, 23, 42)] = 0.2211
        pgm_function13[(75, 23, 43)] = 0.3211
        pgm_function13[(75, 23, 44)] = 0.26667316
        pgm_function13[(75, 23, 45)] = 0.146685207
        pgm_function13[(75, 23, 46)] = 0.0522
        pgm_function13[(75, 23, 47)] = 0.004400881
        pgm_function13[(75, 24, 38)] = 0.002200221
        pgm_function13[(75, 24, 39)] = 0.0611
        pgm_function13[(75, 24, 40)] = 0.2078
        pgm_function13[(75, 24, 41)] = 0.3167
        pgm_function13[(75, 24, 42)] = 0.285571317
        pgm_function13[(75, 24, 43)] = 0.157816123
        pgm_function13[(75, 24, 44)] = 0.0611
        pgm_function13[(75, 24, 45)] = 0.006699332
        pgm_function13[(75, 25, 36)] = 0.001099891
        pgm_function13[(75, 25, 37)] = 0.05
        pgm_function13[(75, 25, 38)] = 0.18441818
        pgm_function13[(75, 25, 39)] = 0.3111
        pgm_function13[(75, 25, 40)] = 0.29563002
        pgm_function13[(75, 25, 41)] = 0.170017095
        pgm_function13[(75, 25, 42)] = 0.068893112
        pgm_function13[(75, 25, 43)] = 0.01
        pgm_function13[(75, 26, 35)] = 0.0367
        pgm_function13[(75, 26, 36)] = 0.1656
        pgm_function13[(75, 26, 37)] = 0.30893106
        pgm_function13[(75, 26, 38)] = 0.3056
        pgm_function13[(75, 26, 39)] = 0.1844
        pgm_function13[(75, 26, 40)] = 0.0789
        pgm_function13[(75, 26, 41)] = 0.0133
        pgm_function13[(75, 27, 33)] = 0.026697314
        pgm_function13[(75, 27, 34)] = 0.152229948
        pgm_function13[(75, 27, 35)] = 0.2978
        pgm_function13[(75, 27, 36)] = 0.3144
        pgm_function13[(75, 27, 37)] = 0.198880179
        pgm_function13[(75, 27, 38)] = 0.087791241
        pgm_function13[(75, 27, 39)] = 0.0178
        pgm_function13[(75, 28, 31)] = 0.0189
        pgm_function13[(75, 28, 32)] = 0.13221299
        pgm_function13[(75, 28, 33)] = 0.2833
        pgm_function13[(75, 28, 34)] = 0.32556729
        pgm_function13[(75, 28, 35)] = 0.2122
        pgm_function13[(75, 28, 36)] = 0.098890223
        pgm_function13[(75, 28, 37)] = 0.023302309
        pgm_function13[(75, 29, 29)] = 0.0133013
        pgm_function13[(75, 29, 30)] = 0.1133
        pgm_function13[(75, 29, 31)] = 0.274427338
        pgm_function13[(75, 29, 32)] = 0.32443199
        pgm_function13[(75, 29, 33)] = 0.2267
        pgm_function13[(75, 29, 34)] = 0.11
        pgm_function13[(75, 29, 35)] = 0.0289
        pgm_function13[(75, 30, 27)] = 0.01
        pgm_function13[(75, 30, 28)] = 0.0956
        pgm_function13[(75, 30, 29)] = 0.261152292
        pgm_function13[(75, 30, 30)] = 0.3244
        pgm_function13[(75, 30, 31)] = 0.2467
        pgm_function13[(75, 30, 32)] = 0.12
        pgm_function13[(75, 30, 33)] = 0.03669631
        pgm_function13[(75, 31, 25)] = 0.0056
        pgm_function13[(75, 31, 26)] = 0.083316643
        pgm_function13[(75, 31, 27)] = 0.2389
        pgm_function13[(75, 31, 28)] = 0.3256
        pgm_function13[(75, 31, 29)] = 0.2656
        pgm_function13[(75, 31, 30)] = 0.13108712
        pgm_function13[(75, 31, 31)] = 0.0433
        pgm_function13[(75, 31, 32)] = 0.001100111
        pgm_function13[(75, 32, 23)] = 0.00220022
        pgm_function13[(75, 32, 24)] = 0.07110717
        pgm_function13[(75, 32, 25)] = 0.213321105
        pgm_function13[(75, 32, 26)] = 0.3311
        pgm_function13[(75, 32, 27)] = 0.2789
        pgm_function13[(75, 32, 28)] = 0.1444
        pgm_function13[(75, 32, 29)] = 0.05110512
        pgm_function13[(75, 32, 30)] = 0.0022
        pgm_function13[(76, 13, 60)] = 0.0067
        pgm_function13[(76, 14, 58)] = 0.0044
        pgm_function13[(76, 14, 59)] = 0.067806866
        pgm_function13[(76, 14, 60)] = 0.2167
        pgm_function13[(76, 15, 56)] = 0.0022
        pgm_function13[(76, 15, 57)] = 0.0578
        pgm_function13[(76, 15, 58)] = 0.19562016
        pgm_function13[(76, 15, 59)] = 0.3078
        pgm_function13[(76, 15, 60)] = 0.2811
        pgm_function13[(76, 16, 55)] = 0.0478
        pgm_function13[(76, 16, 56)] = 0.1733
        pgm_function13[(76, 16, 57)] = 0.305569315
        pgm_function13[(76, 16, 58)] = 0.29
        pgm_function13[(76, 16, 59)] = 0.181082125
        pgm_function13[(76, 16, 60)] = 0.0778
        pgm_function13[(76, 17, 53)] = 0.0356
        pgm_function13[(76, 17, 54)] = 0.1589
        pgm_function13[(76, 17, 55)] = 0.2967
        pgm_function13[(76, 17, 56)] = 0.3
        pgm_function13[(76, 17, 57)] = 0.1933
        pgm_function13[(76, 17, 58)] = 0.086691343
        pgm_function13[(76, 17, 59)] = 0.0222
        pgm_function13[(76, 18, 51)] = 0.024402414
        pgm_function13[(76, 18, 52)] = 0.1433
        pgm_function13[(76, 18, 53)] = 0.283272142
        pgm_function13[(76, 18, 54)] = 0.3111
        pgm_function13[(76, 18, 55)] = 0.206679103
        pgm_function13[(76, 18, 56)] = 0.0978
        pgm_function13[(76, 18, 57)] = 0.0278
        pgm_function13[(76, 19, 49)] = 0.0178
        pgm_function13[(76, 19, 50)] = 0.1256
        pgm_function13[(76, 19, 51)] = 0.26892724
        pgm_function13[(76, 19, 52)] = 0.3222
        pgm_function13[(76, 19, 53)] = 0.2189
        pgm_function13[(76, 19, 54)] = 0.1078
        pgm_function13[(76, 19, 55)] = 0.0333
        pgm_function13[(76, 20, 47)] = 0.0133
        pgm_function13[(76, 20, 48)] = 0.1056
        pgm_function13[(76, 20, 49)] = 0.25887399
        pgm_function13[(76, 20, 50)] = 0.322232245
        pgm_function13[(76, 20, 51)] = 0.2344
        pgm_function13[(76, 20, 52)] = 0.1189
        pgm_function13[(76, 20, 53)] = 0.03889613
        pgm_function13[(76, 20, 54)] = 0.0011
        pgm_function13[(76, 21, 45)] = 0.008900897
        pgm_function13[(76, 21, 46)] = 0.091090961
        pgm_function13[(76, 21, 47)] = 0.242224087
        pgm_function13[(76, 21, 48)] = 0.3244
        pgm_function13[(76, 21, 49)] = 0.2478
        pgm_function13[(76, 21, 50)] = 0.13221312
        pgm_function13[(76, 21, 51)] = 0.0444044
        pgm_function13[(76, 21, 52)] = 0.0022
        pgm_function13[(76, 22, 43)] = 0.0044
        pgm_function13[(76, 22, 44)] = 0.08
        pgm_function13[(76, 22, 45)] = 0.2222
        pgm_function13[(76, 22, 46)] = 0.3278
        pgm_function13[(76, 22, 47)] = 0.25997418
        pgm_function13[(76, 22, 48)] = 0.144414085
        pgm_function13[(76, 22, 49)] = 0.051105135
        pgm_function13[(76, 22, 50)] = 0.004400881
        pgm_function13[(76, 23, 41)] = 0.0022
        pgm_function13[(76, 23, 42)] = 0.0667
        pgm_function13[(76, 23, 43)] = 0.2078
        pgm_function13[(76, 23, 44)] = 0.31996819
        pgm_function13[(76, 23, 45)] = 0.27667239
        pgm_function13[(76, 23, 46)] = 0.1567
        pgm_function13[(76, 23, 47)] = 0.061112213
        pgm_function13[(76, 23, 48)] = 0.006699332
        pgm_function13[(76, 24, 39)] = 0.0011
        pgm_function13[(76, 24, 40)] = 0.0511
        pgm_function13[(76, 24, 41)] = 0.1911
        pgm_function13[(76, 24, 42)] = 0.307769342
        pgm_function13[(76, 24, 43)] = 0.29442923
        pgm_function13[(76, 24, 44)] = 0.1656
        pgm_function13[(76, 24, 45)] = 0.068893125
        pgm_function13[(76, 24, 46)] = 0.01
        pgm_function13[(76, 25, 38)] = 0.04110414
        pgm_function13[(76, 25, 39)] = 0.1733
        pgm_function13[(76, 25, 40)] = 0.30333002
        pgm_function13[(76, 25, 41)] = 0.30443017
        pgm_function13[(76, 25, 42)] = 0.17888203
        pgm_function13[(76, 25, 43)] = 0.0789
        pgm_function13[(76, 25, 44)] = 0.0133
        pgm_function13[(76, 26, 36)] = 0.0311
        pgm_function13[(76, 26, 37)] = 0.15331503
        pgm_function13[(76, 26, 38)] = 0.2978
        pgm_function13[(76, 26, 39)] = 0.31
        pgm_function13[(76, 26, 40)] = 0.1967
        pgm_function13[(76, 26, 41)] = 0.0878
        pgm_function13[(76, 26, 42)] = 0.0178
        pgm_function13[(76, 27, 34)] = 0.021104193
        pgm_function13[(76, 27, 35)] = 0.1344
        pgm_function13[(76, 27, 36)] = 0.2889
        pgm_function13[(76, 27, 37)] = 0.317768286
        pgm_function13[(76, 27, 38)] = 0.211079099
        pgm_function13[(76, 27, 39)] = 0.0978
        pgm_function13[(76, 27, 40)] = 0.0233
        pgm_function13[(76, 28, 32)] = 0.0144014
        pgm_function13[(76, 28, 33)] = 0.12
        pgm_function13[(76, 28, 34)] = 0.271073241
        pgm_function13[(76, 28, 35)] = 0.3267
        pgm_function13[(76, 28, 36)] = 0.22557728
        pgm_function13[(76, 28, 37)] = 0.107811041
        pgm_function13[(76, 28, 38)] = 0.0289
        pgm_function13[(76, 29, 30)] = 0.01
        pgm_function13[(76, 29, 31)] = 0.101110124
        pgm_function13[(76, 29, 32)] = 0.25782599
        pgm_function13[(76, 29, 33)] = 0.33
        pgm_function13[(76, 29, 34)] = 0.2389
        pgm_function13[(76, 29, 35)] = 0.1178
        pgm_function13[(76, 29, 36)] = 0.03559642
        pgm_function13[(76, 30, 28)] = 0.0067
        pgm_function13[(76, 30, 29)] = 0.084416995
        pgm_function13[(76, 30, 30)] = 0.2456
        pgm_function13[(76, 30, 31)] = 0.3244
        pgm_function13[(76, 30, 32)] = 0.26
        pgm_function13[(76, 30, 33)] = 0.12888705
        pgm_function13[(76, 30, 34)] = 0.0433
        pgm_function13[(76, 30, 35)] = 0.0011
        pgm_function13[(76, 31, 26)] = 0.004400877
        pgm_function13[(76, 31, 27)] = 0.0722
        pgm_function13[(76, 31, 28)] = 0.2256
        pgm_function13[(76, 31, 29)] = 0.32
        pgm_function13[(76, 31, 30)] = 0.27667225
        pgm_function13[(76, 31, 31)] = 0.1411
        pgm_function13[(76, 31, 32)] = 0.050005055
        pgm_function13[(76, 31, 33)] = 0.0022
        pgm_function13[(76, 32, 24)] = 0.001100111
        pgm_function13[(76, 32, 25)] = 0.06110613
        pgm_function13[(76, 32, 26)] = 0.1989
        pgm_function13[(76, 32, 27)] = 0.3244
        pgm_function13[(76, 32, 28)] = 0.2867
        pgm_function13[(76, 32, 29)] = 0.15671606
        pgm_function13[(76, 32, 30)] = 0.0589
        pgm_function13[(76, 32, 31)] = 0.004400442
        pgm_function13[(77, 14, 59)] = 0.002200222
        pgm_function13[(77, 14, 60)] = 0.0589
        pgm_function13[(77, 15, 57)] = 0.0011
        pgm_function13[(77, 15, 58)] = 0.04780484
        pgm_function13[(77, 15, 59)] = 0.1833
        pgm_function13[(77, 15, 60)] = 0.2989
        pgm_function13[(77, 16, 56)] = 0.0389
        pgm_function13[(77, 16, 57)] = 0.161084166
        pgm_function13[(77, 16, 58)] = 0.2956
        pgm_function13[(77, 16, 59)] = 0.297770205
        pgm_function13[(77, 16, 60)] = 0.19
        pgm_function13[(77, 17, 54)] = 0.0278
        pgm_function13[(77, 17, 55)] = 0.1444
        pgm_function13[(77, 17, 56)] = 0.2889
        pgm_function13[(77, 17, 57)] = 0.3056
        pgm_function13[(77, 17, 58)] = 0.202180101
        pgm_function13[(77, 17, 59)] = 0.0967
        pgm_function13[(77, 17, 60)] = 0.027797223
        pgm_function13[(77, 18, 52)] = 0.02
        pgm_function13[(77, 18, 53)] = 0.129987065
        pgm_function13[(77, 18, 54)] = 0.2733
        pgm_function13[(77, 18, 55)] = 0.315568158
        pgm_function13[(77, 18, 56)] = 0.2167
        pgm_function13[(77, 18, 57)] = 0.1078
        pgm_function13[(77, 18, 58)] = 0.0333
        pgm_function13[(77, 19, 50)] = 0.0133
        pgm_function13[(77, 19, 51)] = 0.1144111
        pgm_function13[(77, 19, 52)] = 0.2533
        pgm_function13[(77, 19, 53)] = 0.3233
        pgm_function13[(77, 19, 54)] = 0.2289
        pgm_function13[(77, 19, 55)] = 0.1178
        pgm_function13[(77, 19, 56)] = 0.0389
        pgm_function13[(77, 19, 57)] = 0.0011
        pgm_function13[(77, 20, 48)] = 0.01
        pgm_function13[(77, 20, 49)] = 0.0955904
        pgm_function13[(77, 20, 50)] = 0.242224184
        pgm_function13[(77, 20, 51)] = 0.3222
        pgm_function13[(77, 20, 52)] = 0.2478
        pgm_function13[(77, 20, 53)] = 0.12998709
        pgm_function13[(77, 20, 54)] = 0.0444
        pgm_function13[(77, 20, 55)] = 0.0022
        pgm_function13[(77, 21, 46)] = 0.006699334
        pgm_function13[(77, 21, 47)] = 0.080008029
        pgm_function13[(77, 21, 48)] = 0.23
        pgm_function13[(77, 21, 49)] = 0.3189
        pgm_function13[(77, 21, 50)] = 0.26112624
        pgm_function13[(77, 21, 51)] = 0.14111401
        pgm_function13[(77, 21, 52)] = 0.0511
        pgm_function13[(77, 21, 53)] = 0.0044
        pgm_function13[(77, 22, 44)] = 0.0033
        pgm_function13[(77, 22, 45)] = 0.0678
        pgm_function13[(77, 22, 46)] = 0.2089
        pgm_function13[(77, 22, 47)] = 0.31886822
        pgm_function13[(77, 22, 48)] = 0.272227161
        pgm_function13[(77, 22, 49)] = 0.156716107
        pgm_function13[(77, 22, 50)] = 0.060012013
        pgm_function13[(77, 22, 51)] = 0.0067
        pgm_function13[(77, 23, 42)] = 0.0011
        pgm_function13[(77, 23, 43)] = 0.0567
        pgm_function13[(77, 23, 44)] = 0.19108111
        pgm_function13[(77, 23, 45)] = 0.315568445
        pgm_function13[(77, 23, 46)] = 0.2867
        pgm_function13[(77, 23, 47)] = 0.164433036
        pgm_function13[(77, 23, 48)] = 0.067793218
        pgm_function13[(77, 23, 49)] = 0.009999009
        pgm_function13[(77, 24, 41)] = 0.0433
        pgm_function13[(77, 24, 42)] = 0.177782197
        pgm_function13[(77, 24, 43)] = 0.303330237
        pgm_function13[(77, 24, 44)] = 0.3011
        pgm_function13[(77, 24, 45)] = 0.175582065
        pgm_function13[(77, 24, 46)] = 0.0778
        pgm_function13[(77, 24, 47)] = 0.0133
        pgm_function13[(77, 25, 39)] = 0.0322
        pgm_function13[(77, 25, 40)] = 0.16111601
        pgm_function13[(77, 25, 41)] = 0.294429165
        pgm_function13[(77, 25, 42)] = 0.313269053
        pgm_function13[(77, 25, 43)] = 0.19
        pgm_function13[(77, 25, 44)] = 0.0878
        pgm_function13[(77, 25, 45)] = 0.017798205
        pgm_function13[(77, 26, 37)] = 0.0233023
        pgm_function13[(77, 26, 38)] = 0.1389
        pgm_function13[(77, 26, 39)] = 0.29
        pgm_function13[(77, 26, 40)] = 0.3133
        pgm_function13[(77, 26, 41)] = 0.2067
        pgm_function13[(77, 26, 42)] = 0.0978
        pgm_function13[(77, 26, 43)] = 0.0222
        pgm_function13[(77, 27, 35)] = 0.0167
        pgm_function13[(77, 27, 36)] = 0.12
        pgm_function13[(77, 27, 37)] = 0.276672249
        pgm_function13[(77, 27, 38)] = 0.31886815
        pgm_function13[(77, 27, 39)] = 0.2244
        pgm_function13[(77, 27, 40)] = 0.1067
        pgm_function13[(77, 27, 41)] = 0.028897123
        pgm_function13[(77, 28, 33)] = 0.0111
        pgm_function13[(77, 28, 34)] = 0.105589094
        pgm_function13[(77, 28, 35)] = 0.2589
        pgm_function13[(77, 28, 36)] = 0.326667405
        pgm_function13[(77, 28, 37)] = 0.238924091
        pgm_function13[(77, 28, 38)] = 0.1156
        pgm_function13[(77, 28, 39)] = 0.0356
        pgm_function13[(77, 29, 31)] = 0.006700678
        pgm_function13[(77, 29, 32)] = 0.0922092
        pgm_function13[(77, 29, 33)] = 0.2422
        pgm_function13[(77, 29, 34)] = 0.3311
        pgm_function13[(77, 29, 35)] = 0.2544
        pgm_function13[(77, 29, 36)] = 0.12778706
        pgm_function13[(77, 29, 37)] = 0.04329576
        pgm_function13[(77, 29, 38)] = 0.0011
        pgm_function13[(77, 30, 29)] = 0.004400885
        pgm_function13[(77, 30, 30)] = 0.0756
        pgm_function13[(77, 30, 31)] = 0.2278
        pgm_function13[(77, 30, 32)] = 0.3233
        pgm_function13[(77, 30, 33)] = 0.27107311
        pgm_function13[(77, 30, 34)] = 0.14
        pgm_function13[(77, 30, 35)] = 0.05
        pgm_function13[(77, 30, 36)] = 0.002200221
        pgm_function13[(77, 31, 27)] = 0.0022
        pgm_function13[(77, 31, 28)] = 0.0611
        pgm_function13[(77, 31, 29)] = 0.2133
        pgm_function13[(77, 31, 30)] = 0.31556828
        pgm_function13[(77, 31, 31)] = 0.2856
        pgm_function13[(77, 31, 32)] = 0.153315167
        pgm_function13[(77, 31, 33)] = 0.0589
        pgm_function13[(77, 31, 34)] = 0.004400442
        pgm_function13[(77, 32, 25)] = 0.001100111
        pgm_function13[(77, 32, 26)] = 0.0511
        pgm_function13[(77, 32, 27)] = 0.1878
        pgm_function13[(77, 32, 28)] = 0.3167
        pgm_function13[(77, 32, 29)] = 0.29332911
        pgm_function13[(77, 32, 30)] = 0.1678
        pgm_function13[(77, 32, 31)] = 0.065606637
        pgm_function13[(77, 32, 32)] = 0.007800786
        pgm_function13[(78, 14, 60)] = 0.0011
        pgm_function13[(78, 15, 59)] = 0.0389
        pgm_function13[(78, 15, 60)] = 0.1722
        pgm_function13[(78, 16, 57)] = 0.029997031
        pgm_function13[(78, 16, 58)] = 0.1522
        pgm_function13[(78, 16, 59)] = 0.286671198
        pgm_function13[(78, 16, 60)] = 0.3044
        pgm_function13[(78, 17, 55)] = 0.0222
        pgm_function13[(78, 17, 56)] = 0.13
        pgm_function13[(78, 17, 57)] = 0.2789
        pgm_function13[(78, 17, 58)] = 0.309969155
        pgm_function13[(78, 17, 59)] = 0.2122
        pgm_function13[(78, 17, 60)] = 0.107789091
        pgm_function13[(78, 18, 53)] = 0.015598408
        pgm_function13[(78, 18, 54)] = 0.1156
        pgm_function13[(78, 18, 55)] = 0.261074131
        pgm_function13[(78, 18, 56)] = 0.3144
        pgm_function13[(78, 18, 57)] = 0.2256
        pgm_function13[(78, 18, 58)] = 0.1178
        pgm_function13[(78, 18, 59)] = 0.0389
        pgm_function13[(78, 18, 60)] = 0.0011
        pgm_function13[(78, 19, 51)] = 0.01000101
        pgm_function13[(78, 19, 52)] = 0.1044
        pgm_function13[(78, 19, 53)] = 0.24
        pgm_function13[(78, 19, 54)] = 0.3222
        pgm_function13[(78, 19, 55)] = 0.2411
        pgm_function13[(78, 19, 56)] = 0.1289
        pgm_function13[(78, 19, 57)] = 0.0444
        pgm_function13[(78, 19, 58)] = 0.002200221
        pgm_function13[(78, 20, 49)] = 0.00669933
        pgm_function13[(78, 20, 50)] = 0.086708766
        pgm_function13[(78, 20, 51)] = 0.2278
        pgm_function13[(78, 20, 52)] = 0.32
        pgm_function13[(78, 20, 53)] = 0.25777418
        pgm_function13[(78, 20, 54)] = 0.14
        pgm_function13[(78, 20, 55)] = 0.0511
        pgm_function13[(78, 20, 56)] = 0.0044
        pgm_function13[(78, 21, 47)] = 0.004400442
        pgm_function13[(78, 21, 48)] = 0.0689
        pgm_function13[(78, 21, 49)] = 0.2178
        pgm_function13[(78, 21, 50)] = 0.31443128
        pgm_function13[(78, 21, 51)] = 0.27222702
        pgm_function13[(78, 21, 52)] = 0.1522
        pgm_function13[(78, 21, 53)] = 0.0589
        pgm_function13[(78, 21, 54)] = 0.0067
        pgm_function13[(78, 22, 45)] = 0.0022
        pgm_function13[(78, 22, 46)] = 0.0578
        pgm_function13[(78, 22, 47)] = 0.19888014
        pgm_function13[(78, 22, 48)] = 0.311131184
        pgm_function13[(78, 22, 49)] = 0.284428193
        pgm_function13[(78, 22, 50)] = 0.162232036
        pgm_function13[(78, 22, 51)] = 0.0678
        pgm_function13[(78, 22, 52)] = 0.009999003
        pgm_function13[(78, 23, 44)] = 0.04669533
        pgm_function13[(78, 23, 45)] = 0.176682249
        pgm_function13[(78, 23, 46)] = 0.3078
        pgm_function13[(78, 23, 47)] = 0.293359065
        pgm_function13[(78, 23, 48)] = 0.176682048
        pgm_function13[(78, 23, 49)] = 0.075592468
        pgm_function13[(78, 23, 50)] = 0.0133
        pgm_function13[(78, 24, 42)] = 0.03559644
        pgm_function13[(78, 24, 43)] = 0.162216127
        pgm_function13[(78, 24, 44)] = 0.2989
        pgm_function13[(78, 24, 45)] = 0.307769114
        pgm_function13[(78, 24, 46)] = 0.1889
        pgm_function13[(78, 24, 47)] = 0.0867
        pgm_function13[(78, 24, 48)] = 0.017798198
        pgm_function13[(78, 25, 40)] = 0.0244024
        pgm_function13[(78, 25, 41)] = 0.146715082
        pgm_function13[(78, 25, 42)] = 0.285571049
        pgm_function13[(78, 25, 43)] = 0.3133
        pgm_function13[(78, 25, 44)] = 0.2011
        pgm_function13[(78, 25, 45)] = 0.097790226
        pgm_function13[(78, 25, 46)] = 0.0222
        pgm_function13[(78, 26, 38)] = 0.0189
        pgm_function13[(78, 26, 39)] = 0.1267
        pgm_function13[(78, 26, 40)] = 0.2767
        pgm_function13[(78, 26, 41)] = 0.3178
        pgm_function13[(78, 26, 42)] = 0.2178
        pgm_function13[(78, 26, 43)] = 0.1078
        pgm_function13[(78, 26, 44)] = 0.0289
        pgm_function13[(78, 27, 36)] = 0.0133
        pgm_function13[(78, 27, 37)] = 0.107789097
        pgm_function13[(78, 27, 38)] = 0.265573125
        pgm_function13[(78, 27, 39)] = 0.3189
        pgm_function13[(78, 27, 40)] = 0.2356
        pgm_function13[(78, 27, 41)] = 0.115588094
        pgm_function13[(78, 27, 42)] = 0.0356
        pgm_function13[(78, 28, 34)] = 0.008899118
        pgm_function13[(78, 28, 35)] = 0.0933
        pgm_function13[(78, 28, 36)] = 0.245575305
        pgm_function13[(78, 28, 37)] = 0.323332123
        pgm_function13[(78, 28, 38)] = 0.2544
        pgm_function13[(78, 28, 39)] = 0.1267
        pgm_function13[(78, 28, 40)] = 0.04330431
        pgm_function13[(78, 28, 41)] = 0.0011
        pgm_function13[(78, 29, 32)] = 0.00440044
        pgm_function13[(78, 29, 33)] = 0.0789
        pgm_function13[(78, 29, 34)] = 0.2256
        pgm_function13[(78, 29, 35)] = 0.3278
        pgm_function13[(78, 29, 36)] = 0.26667313
        pgm_function13[(78, 29, 37)] = 0.13778618
        pgm_function13[(78, 29, 38)] = 0.05
        pgm_function13[(78, 29, 39)] = 0.0022
        pgm_function13[(78, 30, 30)] = 0.0022
        pgm_function13[(78, 30, 31)] = 0.0656
        pgm_function13[(78, 30, 32)] = 0.2111
        pgm_function13[(78, 30, 33)] = 0.32106813
        pgm_function13[(78, 30, 34)] = 0.2778
        pgm_function13[(78, 30, 35)] = 0.1522
        pgm_function13[(78, 30, 36)] = 0.057805839
        pgm_function13[(78, 30, 37)] = 0.0044
        pgm_function13[(78, 31, 28)] = 0.0011
        pgm_function13[(78, 31, 29)] = 0.0511
        pgm_function13[(78, 31, 30)] = 0.19778018
        pgm_function13[(78, 31, 31)] = 0.3133
        pgm_function13[(78, 31, 32)] = 0.292229319
        pgm_function13[(78, 31, 33)] = 0.1644
        pgm_function13[(78, 31, 34)] = 0.064406423
        pgm_function13[(78, 31, 35)] = 0.0078
        pgm_function13[(78, 32, 27)] = 0.0411
        pgm_function13[(78, 32, 28)] = 0.1767
        pgm_function13[(78, 32, 29)] = 0.31223112
        pgm_function13[(78, 32, 30)] = 0.3022
        pgm_function13[(78, 32, 31)] = 0.180018101
        pgm_function13[(78, 32, 32)] = 0.073307353
        pgm_function13[(78, 32, 33)] = 0.01220121
        pgm_function13[(79, 15, 60)] = 0.03
        pgm_function13[(79, 16, 58)] = 0.0233
        pgm_function13[(79, 16, 59)] = 0.137786095
        pgm_function13[(79, 16, 60)] = 0.2756
        pgm_function13[(79, 17, 56)] = 0.0178
        pgm_function13[(79, 17, 57)] = 0.1178
        pgm_function13[(79, 17, 58)] = 0.267773134
        pgm_function13[(79, 17, 59)] = 0.3122
        pgm_function13[(79, 17, 60)] = 0.219978185
        pgm_function13[(79, 18, 54)] = 0.0122
        pgm_function13[(79, 18, 55)] = 0.102190051
        pgm_function13[(79, 18, 56)] = 0.2522
        pgm_function13[(79, 18, 57)] = 0.3144
        pgm_function13[(79, 18, 58)] = 0.2367
        pgm_function13[(79, 18, 59)] = 0.1289
        pgm_function13[(79, 18, 60)] = 0.0444
        pgm_function13[(79, 19, 52)] = 0.0067
        pgm_function13[(79, 19, 53)] = 0.0911
        pgm_function13[(79, 19, 54)] = 0.23
        pgm_function13[(79, 19, 55)] = 0.3211
        pgm_function13[(79, 19, 56)] = 0.2533
        pgm_function13[(79, 19, 57)] = 0.14
        pgm_function13[(79, 19, 58)] = 0.051105135
        pgm_function13[(79, 19, 59)] = 0.0044
        pgm_function13[(79, 20, 50)] = 0.004400443
        pgm_function13[(79, 20, 51)] = 0.0767
        pgm_function13[(79, 20, 52)] = 0.2111
        pgm_function13[(79, 20, 53)] = 0.31776822
        pgm_function13[(79, 20, 54)] = 0.2667
        pgm_function13[(79, 20, 55)] = 0.15
        pgm_function13[(79, 20, 56)] = 0.0589
        pgm_function13[(79, 20, 57)] = 0.0067
        pgm_function13[(79, 21, 48)] = 0.0022
        pgm_function13[(79, 21, 49)] = 0.06
        pgm_function13[(79, 21, 50)] = 0.20112018
        pgm_function13[(79, 21, 51)] = 0.31113103
        pgm_function13[(79, 21, 52)] = 0.2822
        pgm_function13[(79, 21, 53)] = 0.16
        pgm_function13[(79, 21, 54)] = 0.0678
        pgm_function13[(79, 21, 55)] = 0.009999004
        pgm_function13[(79, 22, 46)] = 0.0011
        pgm_function13[(79, 22, 47)] = 0.04779523
        pgm_function13[(79, 22, 48)] = 0.187819111
        pgm_function13[(79, 22, 49)] = 0.302230206
        pgm_function13[(79, 22, 50)] = 0.294459065
        pgm_function13[(79, 22, 51)] = 0.1711
        pgm_function13[(79, 22, 52)] = 0.075592423
        pgm_function13[(79, 22, 53)] = 0.01330131
        pgm_function13[(79, 23, 45)] = 0.038896155
        pgm_function13[(79, 23, 46)] = 0.1644
        pgm_function13[(79, 23, 47)] = 0.301160066
        pgm_function13[(79, 23, 48)] = 0.302170082
        pgm_function13[(79, 23, 49)] = 0.187781169
        pgm_function13[(79, 23, 50)] = 0.0856
        pgm_function13[(79, 23, 51)] = 0.0178
        pgm_function13[(79, 24, 43)] = 0.027802822
        pgm_function13[(79, 24, 44)] = 0.1467
        pgm_function13[(79, 24, 45)] = 0.292171108
        pgm_function13[(79, 24, 46)] = 0.3067
        pgm_function13[(79, 24, 47)] = 0.2
        pgm_function13[(79, 24, 48)] = 0.096690287
        pgm_function13[(79, 24, 49)] = 0.0222
        pgm_function13[(79, 25, 41)] = 0.018901911
        pgm_function13[(79, 25, 42)] = 0.131087022
        pgm_function13[(79, 25, 43)] = 0.2789
        pgm_function13[(79, 25, 44)] = 0.3167
        pgm_function13[(79, 25, 45)] = 0.212179057
        pgm_function13[(79, 25, 46)] = 0.1078
        pgm_function13[(79, 25, 47)] = 0.028902923
        pgm_function13[(79, 26, 39)] = 0.0133
        pgm_function13[(79, 26, 40)] = 0.1144
        pgm_function13[(79, 26, 41)] = 0.2633
        pgm_function13[(79, 26, 42)] = 0.3222
        pgm_function13[(79, 26, 43)] = 0.2278
        pgm_function13[(79, 26, 44)] = 0.1156
        pgm_function13[(79, 26, 45)] = 0.0356
        pgm_function13[(79, 27, 37)] = 0.009999009
        pgm_function13[(79, 27, 38)] = 0.096690345
        pgm_function13[(79, 27, 39)] = 0.25
        pgm_function13[(79, 27, 40)] = 0.3211
        pgm_function13[(79, 27, 41)] = 0.251075203
        pgm_function13[(79, 27, 42)] = 0.1233
        pgm_function13[(79, 27, 43)] = 0.0433
        pgm_function13[(79, 27, 44)] = 0.0011
        pgm_function13[(79, 28, 35)] = 0.0067
        pgm_function13[(79, 28, 36)] = 0.081092001
        pgm_function13[(79, 28, 37)] = 0.233323089
        pgm_function13[(79, 28, 38)] = 0.3189
        pgm_function13[(79, 28, 39)] = 0.2656
        pgm_function13[(79, 28, 40)] = 0.13441304
        pgm_function13[(79, 28, 41)] = 0.05
        pgm_function13[(79, 28, 42)] = 0.002199782
        pgm_function13[(79, 29, 33)] = 0.0033
        pgm_function13[(79, 29, 34)] = 0.0689
        pgm_function13[(79, 29, 35)] = 0.2111
        pgm_function13[(79, 29, 36)] = 0.32216816
        pgm_function13[(79, 29, 37)] = 0.27557236
        pgm_function13[(79, 29, 38)] = 0.15
        pgm_function13[(79, 29, 39)] = 0.0567
        pgm_function13[(79, 29, 40)] = 0.004400441
        pgm_function13[(79, 30, 31)] = 0.0011
        pgm_function13[(79, 30, 32)] = 0.0567
        pgm_function13[(79, 30, 33)] = 0.19558008
        pgm_function13[(79, 30, 34)] = 0.3211
        pgm_function13[(79, 30, 35)] = 0.2856
        pgm_function13[(79, 30, 36)] = 0.163316111
        pgm_function13[(79, 30, 37)] = 0.0644
        pgm_function13[(79, 30, 38)] = 0.007799229
        pgm_function13[(79, 31, 30)] = 0.04219584
        pgm_function13[(79, 31, 31)] = 0.1811
        pgm_function13[(79, 31, 32)] = 0.31223134
        pgm_function13[(79, 31, 33)] = 0.2978
        pgm_function13[(79, 31, 34)] = 0.178918064
        pgm_function13[(79, 31, 35)] = 0.0722
        pgm_function13[(79, 31, 36)] = 0.0111
        pgm_function13[(79, 32, 28)] = 0.0322
        pgm_function13[(79, 32, 29)] = 0.16111606
        pgm_function13[(79, 32, 30)] = 0.3011
        pgm_function13[(79, 32, 31)] = 0.310031174
        pgm_function13[(79, 32, 32)] = 0.191119138
        pgm_function13[(79, 32, 33)] = 0.08000806
        pgm_function13[(79, 32, 34)] = 0.0167
        pgm_function13[(80, 16, 59)] = 0.017798212
        pgm_function13[(80, 16, 60)] = 0.1256
        pgm_function13[(80, 17, 57)] = 0.0133
        pgm_function13[(80, 17, 58)] = 0.105589053
        pgm_function13[(80, 17, 59)] = 0.2533
        pgm_function13[(80, 17, 60)] = 0.316668266
        pgm_function13[(80, 18, 55)] = 0.009999005
        pgm_function13[(80, 18, 56)] = 0.09
        pgm_function13[(80, 18, 57)] = 0.24
        pgm_function13[(80, 18, 58)] = 0.3133
        pgm_function13[(80, 18, 59)] = 0.2478
        pgm_function13[(80, 18, 60)] = 0.1389
        pgm_function13[(80, 19, 53)] = 0.0056
        pgm_function13[(80, 19, 54)] = 0.0789
        pgm_function13[(80, 19, 55)] = 0.2167
        pgm_function13[(80, 19, 56)] = 0.3122
        pgm_function13[(80, 19, 57)] = 0.2633
        pgm_function13[(80, 19, 58)] = 0.148915101
        pgm_function13[(80, 19, 59)] = 0.0578
        pgm_function13[(80, 19, 60)] = 0.00669933
        pgm_function13[(80, 20, 51)] = 0.0022
        pgm_function13[(80, 20, 52)] = 0.0678
        pgm_function13[(80, 20, 53)] = 0.19778014
        pgm_function13[(80, 20, 54)] = 0.3156
        pgm_function13[(80, 20, 55)] = 0.2756
        pgm_function13[(80, 20, 56)] = 0.1589
        pgm_function13[(80, 20, 57)] = 0.0678
        pgm_function13[(80, 20, 58)] = 0.009999004
        pgm_function13[(80, 21, 49)] = 0.0011
        pgm_function13[(80, 21, 50)] = 0.05220525
        pgm_function13[(80, 21, 51)] = 0.18561902
        pgm_function13[(80, 21, 52)] = 0.3056
        pgm_function13[(80, 21, 53)] = 0.2911
        pgm_function13[(80, 21, 54)] = 0.1689
        pgm_function13[(80, 21, 55)] = 0.07559243
        pgm_function13[(80, 21, 56)] = 0.0133013
        pgm_function13[(80, 22, 48)] = 0.038903923
        pgm_function13[(80, 22, 49)] = 0.173317118
        pgm_function13[(80, 22, 50)] = 0.293359065
        pgm_function13[(80, 22, 51)] = 0.3044
        pgm_function13[(80, 22, 52)] = 0.182182055
        pgm_function13[(80, 22, 53)] = 0.08560867
        pgm_function13[(80, 22, 54)] = 0.01780181
        pgm_function13[(80, 23, 46)] = 0.03
        pgm_function13[(80, 23, 47)] = 0.152230033
        pgm_function13[(80, 23, 48)] = 0.288871078
        pgm_function13[(80, 23, 49)] = 0.305569275
        pgm_function13[(80, 23, 50)] = 0.1989
        pgm_function13[(80, 23, 51)] = 0.0944
        pgm_function13[(80, 23, 52)] = 0.0222
        pgm_function13[(80, 24, 44)] = 0.0222
        pgm_function13[(80, 24, 45)] = 0.131087049
        pgm_function13[(80, 24, 46)] = 0.2833
        pgm_function13[(80, 24, 47)] = 0.3111
        pgm_function13[(80, 24, 48)] = 0.208878973
        pgm_function13[(80, 24, 49)] = 0.1056
        pgm_function13[(80, 24, 50)] = 0.027797223
        pgm_function13[(80, 25, 42)] = 0.015598403
        pgm_function13[(80, 25, 43)] = 0.1167
        pgm_function13[(80, 25, 44)] = 0.2689
        pgm_function13[(80, 25, 45)] = 0.318868086
        pgm_function13[(80, 25, 46)] = 0.2244
        pgm_function13[(80, 25, 47)] = 0.114411089
        pgm_function13[(80, 25, 48)] = 0.0356
        pgm_function13[(80, 26, 40)] = 0.01
        pgm_function13[(80, 26, 41)] = 0.1044
        pgm_function13[(80, 26, 42)] = 0.2478
        pgm_function13[(80, 26, 43)] = 0.3233
        pgm_function13[(80, 26, 44)] = 0.2433
        pgm_function13[(80, 26, 45)] = 0.1233
        pgm_function13[(80, 26, 46)] = 0.04220424
        pgm_function13[(80, 26, 47)] = 0.0011
        pgm_function13[(80, 27, 38)] = 0.006699333
        pgm_function13[(80, 27, 39)] = 0.0867
        pgm_function13[(80, 27, 40)] = 0.2333
        pgm_function13[(80, 27, 41)] = 0.317768257
        pgm_function13[(80, 27, 42)] = 0.2622
        pgm_function13[(80, 27, 43)] = 0.1344
        pgm_function13[(80, 27, 44)] = 0.05
        pgm_function13[(80, 27, 45)] = 0.0022
        pgm_function13[(80, 28, 36)] = 0.004399565
        pgm_function13[(80, 28, 37)] = 0.071107127
        pgm_function13[(80, 28, 38)] = 0.2189
        pgm_function13[(80, 28, 39)] = 0.3144
        pgm_function13[(80, 28, 40)] = 0.27672808
        pgm_function13[(80, 28, 41)] = 0.1456
        pgm_function13[(80, 28, 42)] = 0.056694346
        pgm_function13[(80, 28, 43)] = 0.004400878
        pgm_function13[(80, 29, 34)] = 0.0022
        pgm_function13[(80, 29, 35)] = 0.0589
        pgm_function13[(80, 29, 36)] = 0.1988801
        pgm_function13[(80, 29, 37)] = 0.31556841
        pgm_function13[(80, 29, 38)] = 0.2856
        pgm_function13[(80, 29, 39)] = 0.16
        pgm_function13[(80, 29, 40)] = 0.06440641
        pgm_function13[(80, 29, 41)] = 0.0078
        pgm_function13[(80, 30, 33)] = 0.04669532
        pgm_function13[(80, 30, 34)] = 0.18
        pgm_function13[(80, 30, 35)] = 0.3167
        pgm_function13[(80, 30, 36)] = 0.292229199
        pgm_function13[(80, 30, 37)] = 0.1778
        pgm_function13[(80, 30, 38)] = 0.071092984
        pgm_function13[(80, 30, 39)] = 0.0111
        pgm_function13[(80, 31, 31)] = 0.0356
        pgm_function13[(80, 31, 32)] = 0.163316178
        pgm_function13[(80, 31, 33)] = 0.3056
        pgm_function13[(80, 31, 34)] = 0.30443011
        pgm_function13[(80, 31, 35)] = 0.19
        pgm_function13[(80, 31, 36)] = 0.0789
        pgm_function13[(80, 31, 37)] = 0.016696692
        pgm_function13[(80, 32, 29)] = 0.02440241
        pgm_function13[(80, 32, 30)] = 0.1489
        pgm_function13[(80, 32, 31)] = 0.292229164
        pgm_function13[(80, 32, 32)] = 0.314431226
        pgm_function13[(80, 32, 33)] = 0.20332016
        pgm_function13[(80, 32, 34)] = 0.0878
        pgm_function13[(80, 32, 35)] = 0.0211
        pgm_function13[(81, 16, 60)] = 0.0133
        pgm_function13[(81, 17, 58)] = 0.009999005
        pgm_function13[(81, 17, 59)] = 0.0967
        pgm_function13[(81, 17, 60)] = 0.2377762
        pgm_function13[(81, 18, 56)] = 0.0067
        pgm_function13[(81, 18, 57)] = 0.08
        pgm_function13[(81, 18, 58)] = 0.2267
        pgm_function13[(81, 18, 59)] = 0.31
        pgm_function13[(81, 18, 60)] = 0.2578
        pgm_function13[(81, 19, 54)] = 0.0044
        pgm_function13[(81, 19, 55)] = 0.0678
        pgm_function13[(81, 19, 56)] = 0.2078
        pgm_function13[(81, 19, 57)] = 0.3056
        pgm_function13[(81, 19, 58)] = 0.272227185
        pgm_function13[(81, 19, 59)] = 0.1578
        pgm_function13[(81, 19, 60)] = 0.0666933
        pgm_function13[(81, 20, 52)] = 0.0011
        pgm_function13[(81, 20, 53)] = 0.05779424
        pgm_function13[(81, 20, 54)] = 0.1844
        pgm_function13[(81, 20, 55)] = 0.3078
        pgm_function13[(81, 20, 56)] = 0.2867
        pgm_function13[(81, 20, 57)] = 0.1667
        pgm_function13[(81, 20, 58)] = 0.07559243
        pgm_function13[(81, 20, 59)] = 0.0133013
        pgm_function13[(81, 21, 51)] = 0.0444044
        pgm_function13[(81, 21, 52)] = 0.17
        pgm_function13[(81, 21, 53)] = 0.3
        pgm_function13[(81, 21, 54)] = 0.2967
        pgm_function13[(81, 21, 55)] = 0.179982072
        pgm_function13[(81, 21, 56)] = 0.0844084
        pgm_function13[(81, 21, 57)] = 0.0178
        pgm_function13[(81, 22, 49)] = 0.03000302
        pgm_function13[(81, 22, 50)] = 0.161132035
        pgm_function13[(81, 22, 51)] = 0.2856
        pgm_function13[(81, 22, 52)] = 0.306669092
        pgm_function13[(81, 22, 53)] = 0.19441916
        pgm_function13[(81, 22, 54)] = 0.09440948
        pgm_function13[(81, 22, 55)] = 0.0222
        pgm_function13[(81, 23, 47)] = 0.023304705
        pgm_function13[(81, 23, 48)] = 0.139986038
        pgm_function13[(81, 23, 49)] = 0.279972252
        pgm_function13[(81, 23, 50)] = 0.31
        pgm_function13[(81, 23, 51)] = 0.2078
        pgm_function13[(81, 23, 52)] = 0.1044
        pgm_function13[(81, 23, 53)] = 0.027802824
        pgm_function13[(81, 24, 45)] = 0.017798207
        pgm_function13[(81, 24, 46)] = 0.12
        pgm_function13[(81, 24, 47)] = 0.2722
        pgm_function13[(81, 24, 48)] = 0.314368959
        pgm_function13[(81, 24, 49)] = 0.2233
        pgm_function13[(81, 24, 50)] = 0.113289093
        pgm_function13[(81, 24, 51)] = 0.035596418
        pgm_function13[(81, 25, 43)] = 0.0122
        pgm_function13[(81, 25, 44)] = 0.1022
        pgm_function13[(81, 25, 45)] = 0.256674069
        pgm_function13[(81, 25, 46)] = 0.3156
        pgm_function13[(81, 25, 47)] = 0.240024187
        pgm_function13[(81, 25, 48)] = 0.1222
        pgm_function13[(81, 25, 49)] = 0.04220422
        pgm_function13[(81, 25, 50)] = 0.0011
        pgm_function13[(81, 26, 41)] = 0.0067
        pgm_function13[(81, 26, 42)] = 0.0922
        pgm_function13[(81, 26, 43)] = 0.2356
        pgm_function13[(81, 26, 44)] = 0.3189
        pgm_function13[(81, 26, 45)] = 0.2544
        pgm_function13[(81, 26, 46)] = 0.13441313
        pgm_function13[(81, 26, 47)] = 0.05
        pgm_function13[(81, 26, 48)] = 0.002200222
        pgm_function13[(81, 27, 39)] = 0.0044
        pgm_function13[(81, 27, 40)] = 0.0778
        pgm_function13[(81, 27, 41)] = 0.217778176
        pgm_function13[(81, 27, 42)] = 0.3167
        pgm_function13[(81, 27, 43)] = 0.2689
        pgm_function13[(81, 27, 44)] = 0.1444
        pgm_function13[(81, 27, 45)] = 0.0567
        pgm_function13[(81, 27, 46)] = 0.004400439
        pgm_function13[(81, 28, 37)] = 0.002200221
        pgm_function13[(81, 28, 38)] = 0.0622
        pgm_function13[(81, 28, 39)] = 0.2044
        pgm_function13[(81, 28, 40)] = 0.31333109
        pgm_function13[(81, 28, 41)] = 0.2844
        pgm_function13[(81, 28, 42)] = 0.157784129
        pgm_function13[(81, 28, 43)] = 0.064412869
        pgm_function13[(81, 28, 44)] = 0.0078
        pgm_function13[(81, 29, 35)] = 0.0011
        pgm_function13[(81, 29, 36)] = 0.04889512
        pgm_function13[(81, 29, 37)] = 0.18778124
        pgm_function13[(81, 29, 38)] = 0.3089
        pgm_function13[(81, 29, 39)] = 0.2944
        pgm_function13[(81, 29, 40)] = 0.173317028
        pgm_function13[(81, 29, 41)] = 0.0711
        pgm_function13[(81, 29, 42)] = 0.01109891
        pgm_function13[(81, 30, 34)] = 0.0378
        pgm_function13[(81, 30, 35)] = 0.1644
        pgm_function13[(81, 30, 36)] = 0.306731209
        pgm_function13[(81, 30, 37)] = 0.2989
        pgm_function13[(81, 30, 38)] = 0.187781222
        pgm_function13[(81, 30, 39)] = 0.0789
        pgm_function13[(81, 30, 40)] = 0.016698301
        pgm_function13[(81, 31, 32)] = 0.02780283
        pgm_function13[(81, 31, 33)] = 0.1489
        pgm_function13[(81, 31, 34)] = 0.296730107
        pgm_function13[(81, 31, 35)] = 0.3067
        pgm_function13[(81, 31, 36)] = 0.2056
        pgm_function13[(81, 31, 37)] = 0.085582861
        pgm_function13[(81, 31, 38)] = 0.0211
        pgm_function13[(81, 32, 30)] = 0.0189
        pgm_function13[(81, 32, 31)] = 0.133313075
        pgm_function13[(81, 32, 32)] = 0.283328204
        pgm_function13[(81, 32, 33)] = 0.32003226
        pgm_function13[(81, 32, 34)] = 0.2144
        pgm_function13[(81, 32, 35)] = 0.0967
        pgm_function13[(81, 32, 36)] = 0.0278
        pgm_function13[(82, 17, 59)] = 0.0067
        pgm_function13[(82, 17, 60)] = 0.085591472
        pgm_function13[(82, 18, 57)] = 0.0044
        pgm_function13[(82, 18, 58)] = 0.07
        pgm_function13[(82, 18, 59)] = 0.2122
        pgm_function13[(82, 18, 60)] = 0.3078
        pgm_function13[(82, 19, 55)] = 0.0022
        pgm_function13[(82, 19, 56)] = 0.0578
        pgm_function13[(82, 19, 57)] = 0.1978
        pgm_function13[(82, 19, 58)] = 0.302230206
        pgm_function13[(82, 19, 59)] = 0.2856
        pgm_function13[(82, 19, 60)] = 0.164384
        pgm_function13[(82, 20, 54)] = 0.0478
        pgm_function13[(82, 20, 55)] = 0.1744
        pgm_function13[(82, 20, 56)] = 0.2978
        pgm_function13[(82, 20, 57)] = 0.2933
        pgm_function13[(82, 20, 58)] = 0.176682071
        pgm_function13[(82, 20, 59)] = 0.08440839
        pgm_function13[(82, 20, 60)] = 0.0178
        pgm_function13[(82, 21, 52)] = 0.0367
        pgm_function13[(82, 21, 53)] = 0.1567
        pgm_function13[(82, 21, 54)] = 0.2933
        pgm_function13[(82, 21, 55)] = 0.29887012
        pgm_function13[(82, 21, 56)] = 0.192219
        pgm_function13[(82, 21, 57)] = 0.0944
        pgm_function13[(82, 21, 58)] = 0.0222
        pgm_function13[(82, 22, 50)] = 0.024404905
        pgm_function13[(82, 22, 51)] = 0.1433
        pgm_function13[(82, 22, 52)] = 0.279972084
        pgm_function13[(82, 22, 53)] = 0.30563124
        pgm_function13[(82, 22, 54)] = 0.20442016
        pgm_function13[(82, 22, 55)] = 0.1044
        pgm_function13[(82, 22, 56)] = 0.027802818
        pgm_function13[(82, 23, 48)] = 0.017798205
        pgm_function13[(82, 23, 49)] = 0.127787115
        pgm_function13[(82, 23, 50)] = 0.2678
        pgm_function13[(82, 23, 51)] = 0.3156
        pgm_function13[(82, 23, 52)] = 0.2189
        pgm_function13[(82, 23, 53)] = 0.112211097
        pgm_function13[(82, 23, 54)] = 0.035596422
        pgm_function13[(82, 24, 46)] = 0.0133
        pgm_function13[(82, 24, 47)] = 0.1067
        pgm_function13[(82, 24, 48)] = 0.258873966
        pgm_function13[(82, 24, 49)] = 0.3167
        pgm_function13[(82, 24, 50)] = 0.236676194
        pgm_function13[(82, 24, 51)] = 0.119988061
        pgm_function13[(82, 24, 52)] = 0.0422
        pgm_function13[(82, 24, 53)] = 0.001099891
        pgm_function13[(82, 25, 44)] = 0.01
        pgm_function13[(82, 25, 45)] = 0.089991024
        pgm_function13[(82, 25, 46)] = 0.2456
        pgm_function13[(82, 25, 47)] = 0.313331244
        pgm_function13[(82, 25, 48)] = 0.2522
        pgm_function13[(82, 25, 49)] = 0.13111307
        pgm_function13[(82, 25, 50)] = 0.05
        pgm_function13[(82, 25, 51)] = 0.0022
        pgm_function13[(82, 26, 42)] = 0.0044
        pgm_function13[(82, 26, 43)] = 0.0789
        pgm_function13[(82, 26, 44)] = 0.2233
        pgm_function13[(82, 26, 45)] = 0.3156
        pgm_function13[(82, 26, 46)] = 0.26442626
        pgm_function13[(82, 26, 47)] = 0.1433
        pgm_function13[(82, 26, 48)] = 0.05670575
        pgm_function13[(82, 26, 49)] = 0.004400443
        pgm_function13[(82, 27, 40)] = 0.0022
        pgm_function13[(82, 27, 41)] = 0.067793255
        pgm_function13[(82, 27, 42)] = 0.2044
        pgm_function13[(82, 27, 43)] = 0.3178
        pgm_function13[(82, 27, 44)] = 0.2756
        pgm_function13[(82, 27, 45)] = 0.1567
        pgm_function13[(82, 27, 46)] = 0.064406391
        pgm_function13[(82, 27, 47)] = 0.007799225
        pgm_function13[(82, 28, 38)] = 0.0011
        pgm_function13[(82, 28, 39)] = 0.0533
        pgm_function13[(82, 28, 40)] = 0.18781906
        pgm_function13[(82, 28, 41)] = 0.3089
        pgm_function13[(82, 28, 42)] = 0.289971238
        pgm_function13[(82, 28, 43)] = 0.170033918
        pgm_function13[(82, 28, 44)] = 0.0711
        pgm_function13[(82, 28, 45)] = 0.01110111
        pgm_function13[(82, 29, 37)] = 0.03999605
        pgm_function13[(82, 29, 38)] = 0.1722
        pgm_function13[(82, 29, 39)] = 0.3022
        pgm_function13[(82, 29, 40)] = 0.298930048
        pgm_function13[(82, 29, 41)] = 0.1833
        pgm_function13[(82, 29, 42)] = 0.0788922
        pgm_function13[(82, 29, 43)] = 0.015598405
        pgm_function13[(82, 30, 35)] = 0.03
        pgm_function13[(82, 30, 36)] = 0.154415105
        pgm_function13[(82, 30, 37)] = 0.2956
        pgm_function13[(82, 30, 38)] = 0.305569361
        pgm_function13[(82, 30, 39)] = 0.2011
        pgm_function13[(82, 30, 40)] = 0.085591407
        pgm_function13[(82, 30, 41)] = 0.021097908
        pgm_function13[(82, 31, 33)] = 0.0222
        pgm_function13[(82, 31, 34)] = 0.133313048
        pgm_function13[(82, 31, 35)] = 0.29
        pgm_function13[(82, 31, 36)] = 0.3122
        pgm_function13[(82, 31, 37)] = 0.215556901
        pgm_function13[(82, 31, 38)] = 0.0956
        pgm_function13[(82, 31, 39)] = 0.0267
        pgm_function13[(82, 32, 31)] = 0.014401408
        pgm_function13[(82, 32, 32)] = 0.117812085
        pgm_function13[(82, 32, 33)] = 0.27112722
        pgm_function13[(82, 32, 34)] = 0.3244
        pgm_function13[(82, 32, 35)] = 0.2278
        pgm_function13[(82, 32, 36)] = 0.1067
        pgm_function13[(82, 32, 37)] = 0.03330331
        pgm_function13[(83, 17, 60)] = 0.004399564
        pgm_function13[(83, 18, 58)] = 0.0022
        pgm_function13[(83, 18, 59)] = 0.0611
        pgm_function13[(83, 18, 60)] = 0.1967
        pgm_function13[(83, 19, 56)] = 0.0011
        pgm_function13[(83, 19, 57)] = 0.0478
        pgm_function13[(83, 19, 58)] = 0.183318125
        pgm_function13[(83, 19, 59)] = 0.2922
        pgm_function13[(83, 19, 60)] = 0.29217099
        pgm_function13[(83, 20, 55)] = 0.0389
        pgm_function13[(83, 20, 56)] = 0.1633
        pgm_function13[(83, 20, 57)] = 0.29
        pgm_function13[(83, 20, 58)] = 0.29887012
        pgm_function13[(83, 20, 59)] = 0.18671898
        pgm_function13[(83, 20, 60)] = 0.0944
        pgm_function13[(83, 21, 53)] = 0.0289
        pgm_function13[(83, 21, 54)] = 0.1433
        pgm_function13[(83, 21, 55)] = 0.286671115
        pgm_function13[(83, 21, 56)] = 0.30003
        pgm_function13[(83, 21, 57)] = 0.2
        pgm_function13[(83, 21, 58)] = 0.1044
        pgm_function13[(83, 21, 59)] = 0.0278
        pgm_function13[(83, 22, 51)] = 0.0211
        pgm_function13[(83, 22, 52)] = 0.128887039
        pgm_function13[(83, 22, 53)] = 0.27332722
        pgm_function13[(83, 22, 54)] = 0.31003125
        pgm_function13[(83, 22, 55)] = 0.2167
        pgm_function13[(83, 22, 56)] = 0.112211074
        pgm_function13[(83, 22, 57)] = 0.035603635
        pgm_function13[(83, 23, 49)] = 0.013298712
        pgm_function13[(83, 23, 50)] = 0.1144
        pgm_function13[(83, 23, 51)] = 0.2533
        pgm_function13[(83, 23, 52)] = 0.3178
        pgm_function13[(83, 23, 53)] = 0.233323201
        pgm_function13[(83, 23, 54)] = 0.118888074
        pgm_function13[(83, 23, 55)] = 0.042195847
        pgm_function13[(83, 23, 56)] = 0.001099891
        pgm_function13[(83, 24, 47)] = 0.01
        pgm_function13[(83, 24, 48)] = 0.096690287
        pgm_function13[(83, 24, 49)] = 0.24
        pgm_function13[(83, 24, 50)] = 0.31666826
        pgm_function13[(83, 24, 51)] = 0.248875127
        pgm_function13[(83, 24, 52)] = 0.1278
        pgm_function13[(83, 24, 53)] = 0.04889514
        pgm_function13[(83, 24, 54)] = 0.002200223
        pgm_function13[(83, 25, 45)] = 0.006699332
        pgm_function13[(83, 25, 46)] = 0.08
        pgm_function13[(83, 25, 47)] = 0.230023179
        pgm_function13[(83, 25, 48)] = 0.3111
        pgm_function13[(83, 25, 49)] = 0.26332613
        pgm_function13[(83, 25, 50)] = 0.14
        pgm_function13[(83, 25, 51)] = 0.0567
        pgm_function13[(83, 25, 52)] = 0.004400882
        pgm_function13[(83, 26, 43)] = 0.0044
        pgm_function13[(83, 26, 44)] = 0.0678
        pgm_function13[(83, 26, 45)] = 0.2122
        pgm_function13[(83, 26, 46)] = 0.31333131
        pgm_function13[(83, 26, 47)] = 0.2733
        pgm_function13[(83, 26, 48)] = 0.154415136
        pgm_function13[(83, 26, 49)] = 0.063306342
        pgm_function13[(83, 26, 50)] = 0.006699335
        pgm_function13[(83, 27, 41)] = 0.001099891
        pgm_function13[(83, 27, 42)] = 0.0578
        pgm_function13[(83, 27, 43)] = 0.1878
        pgm_function13[(83, 27, 44)] = 0.3133
        pgm_function13[(83, 27, 45)] = 0.2844
        pgm_function13[(83, 27, 46)] = 0.167816977
        pgm_function13[(83, 27, 47)] = 0.071092948
        pgm_function13[(83, 27, 48)] = 0.0111
        pgm_function13[(83, 28, 40)] = 0.04440441
        pgm_function13[(83, 28, 41)] = 0.1733
        pgm_function13[(83, 28, 42)] = 0.305569251
        pgm_function13[(83, 28, 43)] = 0.293358859
        pgm_function13[(83, 28, 44)] = 0.1811
        pgm_function13[(83, 28, 45)] = 0.07890796
        pgm_function13[(83, 28, 46)] = 0.015598405
        pgm_function13[(83, 29, 38)] = 0.0322
        pgm_function13[(83, 29, 39)] = 0.1589
        pgm_function13[(83, 29, 40)] = 0.293329047
        pgm_function13[(83, 29, 41)] = 0.3044
        pgm_function13[(83, 29, 42)] = 0.19558025
        pgm_function13[(83, 29, 43)] = 0.086691326
        pgm_function13[(83, 29, 44)] = 0.021097908
        pgm_function13[(83, 30, 36)] = 0.023302316
        pgm_function13[(83, 30, 37)] = 0.1411
        pgm_function13[(83, 30, 38)] = 0.285571337
        pgm_function13[(83, 30, 39)] = 0.3133
        pgm_function13[(83, 30, 40)] = 0.211079017
        pgm_function13[(83, 30, 41)] = 0.095590434
        pgm_function13[(83, 30, 42)] = 0.026702726
        pgm_function13[(83, 31, 34)] = 0.017801806
        pgm_function13[(83, 31, 35)] = 0.12
        pgm_function13[(83, 31, 36)] = 0.2744
        pgm_function13[(83, 31, 37)] = 0.316636854
        pgm_function13[(83, 31, 38)] = 0.2267
        pgm_function13[(83, 31, 39)] = 0.1044
        pgm_function13[(83, 31, 40)] = 0.0333
        pgm_function13[(83, 32, 32)] = 0.012201209
        pgm_function13[(83, 32, 33)] = 0.10331008
        pgm_function13[(83, 32, 34)] = 0.2578
        pgm_function13[(83, 32, 35)] = 0.3267
        pgm_function13[(83, 32, 36)] = 0.2378
        pgm_function13[(83, 32, 37)] = 0.11671203
        pgm_function13[(83, 32, 38)] = 0.03889612
        pgm_function13[(83, 32, 39)] = 0.0011
        pgm_function13[(84, 18, 59)] = 0.0011
        pgm_function13[(84, 18, 60)] = 0.0533
        pgm_function13[(84, 19, 58)] = 0.040004027
        pgm_function13[(84, 19, 59)] = 0.17
        pgm_function13[(84, 19, 60)] = 0.28777099
        pgm_function13[(84, 20, 56)] = 0.03
        pgm_function13[(84, 20, 57)] = 0.1522
        pgm_function13[(84, 20, 58)] = 0.281072112
        pgm_function13[(84, 20, 59)] = 0.30222997
        pgm_function13[(84, 20, 60)] = 0.1956
        pgm_function13[(84, 21, 54)] = 0.0233
        pgm_function13[(84, 21, 55)] = 0.131087052
        pgm_function13[(84, 21, 56)] = 0.276728
        pgm_function13[(84, 21, 57)] = 0.3056
        pgm_function13[(84, 21, 58)] = 0.2111
        pgm_function13[(84, 21, 59)] = 0.1122
        pgm_function13[(84, 21, 60)] = 0.034403423
        pgm_function13[(84, 22, 52)] = 0.016698305
        pgm_function13[(84, 22, 53)] = 0.11441109
        pgm_function13[(84, 22, 54)] = 0.26112621
        pgm_function13[(84, 22, 55)] = 0.3078
        pgm_function13[(84, 22, 56)] = 0.231123153
        pgm_function13[(84, 22, 57)] = 0.118912117
        pgm_function13[(84, 22, 58)] = 0.0422
        pgm_function13[(84, 22, 59)] = 0.001100111
        pgm_function13[(84, 23, 50)] = 0.01
        pgm_function13[(84, 23, 51)] = 0.1033
        pgm_function13[(84, 23, 52)] = 0.24
        pgm_function13[(84, 23, 53)] = 0.31443127
        pgm_function13[(84, 23, 54)] = 0.246675153
        pgm_function13[(84, 23, 55)] = 0.126687141
        pgm_function13[(84, 23, 56)] = 0.048895144
        pgm_function13[(84, 23, 57)] = 0.0022
        pgm_function13[(84, 24, 48)] = 0.006699329
        pgm_function13[(84, 24, 49)] = 0.0878
        pgm_function13[(84, 24, 50)] = 0.225577185
        pgm_function13[(84, 24, 51)] = 0.315568161
        pgm_function13[(84, 24, 52)] = 0.2611
        pgm_function13[(84, 24, 53)] = 0.137786112
        pgm_function13[(84, 24, 54)] = 0.056705767
        pgm_function13[(84, 24, 55)] = 0.004400441
        pgm_function13[(84, 25, 46)] = 0.0044
        pgm_function13[(84, 25, 47)] = 0.071107155
        pgm_function13[(84, 25, 48)] = 0.2167
        pgm_function13[(84, 25, 49)] = 0.31113116
        pgm_function13[(84, 25, 50)] = 0.2722
        pgm_function13[(84, 25, 51)] = 0.1522
        pgm_function13[(84, 25, 52)] = 0.063312727
        pgm_function13[(84, 25, 53)] = 0.006700676
        pgm_function13[(84, 26, 44)] = 0.0022
        pgm_function13[(84, 26, 45)] = 0.0578
        pgm_function13[(84, 26, 46)] = 0.1978202
        pgm_function13[(84, 26, 47)] = 0.3056
        pgm_function13[(84, 26, 48)] = 0.283328249
        pgm_function13[(84, 26, 49)] = 0.164416109
        pgm_function13[(84, 26, 50)] = 0.071092955
        pgm_function13[(84, 26, 51)] = 0.01109891
        pgm_function13[(84, 27, 43)] = 0.0478
        pgm_function13[(84, 27, 44)] = 0.1767
        pgm_function13[(84, 27, 45)] = 0.3044
        pgm_function13[(84, 27, 46)] = 0.28892896
        pgm_function13[(84, 27, 47)] = 0.178882122
        pgm_function13[(84, 27, 48)] = 0.0778
        pgm_function13[(84, 27, 49)] = 0.01560161
        pgm_function13[(84, 28, 41)] = 0.0367
        pgm_function13[(84, 28, 42)] = 0.15888413
        pgm_function13[(84, 28, 43)] = 0.300059856
        pgm_function13[(84, 28, 44)] = 0.2978
        pgm_function13[(84, 28, 45)] = 0.19221913
        pgm_function13[(84, 28, 46)] = 0.086691326
        pgm_function13[(84, 28, 47)] = 0.0211
        pgm_function13[(84, 29, 39)] = 0.0256
        pgm_function13[(84, 29, 40)] = 0.145615023
        pgm_function13[(84, 29, 41)] = 0.2878
        pgm_function13[(84, 29, 42)] = 0.3099694
        pgm_function13[(84, 29, 43)] = 0.207779062
        pgm_function13[(84, 29, 44)] = 0.095590435
        pgm_function13[(84, 29, 45)] = 0.0267
        pgm_function13[(84, 30, 37)] = 0.0178
        pgm_function13[(84, 30, 38)] = 0.128887152
        pgm_function13[(84, 30, 39)] = 0.2689
        pgm_function13[(84, 30, 40)] = 0.316668025
        pgm_function13[(84, 30, 41)] = 0.22217808
        pgm_function13[(84, 30, 42)] = 0.1044101
        pgm_function13[(84, 30, 43)] = 0.033303323
        pgm_function13[(84, 31, 35)] = 0.0133
        pgm_function13[(84, 31, 36)] = 0.1078
        pgm_function13[(84, 31, 37)] = 0.25994788
        pgm_function13[(84, 31, 38)] = 0.3211
        pgm_function13[(84, 31, 39)] = 0.2367
        pgm_function13[(84, 31, 40)] = 0.1156
        pgm_function13[(84, 31, 41)] = 0.038896132
        pgm_function13[(84, 31, 42)] = 0.0011
        pgm_function13[(84, 32, 33)] = 0.01000101
        pgm_function13[(84, 32, 34)] = 0.0922
        pgm_function13[(84, 32, 35)] = 0.2422
        pgm_function13[(84, 32, 36)] = 0.3233
        pgm_function13[(84, 32, 37)] = 0.25002507
        pgm_function13[(84, 32, 38)] = 0.12668706
        pgm_function13[(84, 32, 39)] = 0.0444
        pgm_function13[(84, 32, 40)] = 0.0022
        pgm_function13[(85, 19, 59)] = 0.0322
        pgm_function13[(85, 19, 60)] = 0.156684
        pgm_function13[(85, 20, 57)] = 0.0233
        pgm_function13[(85, 20, 58)] = 0.139986056
        pgm_function13[(85, 20, 59)] = 0.27332697
        pgm_function13[(85, 20, 60)] = 0.3067
        pgm_function13[(85, 21, 55)] = 0.017798207
        pgm_function13[(85, 21, 56)] = 0.120012
        pgm_function13[(85, 21, 57)] = 0.2644
        pgm_function13[(85, 21, 58)] = 0.3078
        pgm_function13[(85, 21, 59)] = 0.2222
        pgm_function13[(85, 21, 60)] = 0.12001208
        pgm_function13[(85, 22, 53)] = 0.01330131
        pgm_function13[(85, 22, 54)] = 0.10221008
        pgm_function13[(85, 22, 55)] = 0.2511
        pgm_function13[(85, 22, 56)] = 0.3033302
        pgm_function13[(85, 22, 57)] = 0.242224237
        pgm_function13[(85, 22, 58)] = 0.1267
        pgm_function13[(85, 22, 59)] = 0.048904934
        pgm_function13[(85, 22, 60)] = 0.002199781
        pgm_function13[(85, 23, 51)] = 0.0078
        pgm_function13[(85, 23, 52)] = 0.09
        pgm_function13[(85, 23, 53)] = 0.228923197
        pgm_function13[(85, 23, 54)] = 0.309969192
        pgm_function13[(85, 23, 55)] = 0.257774286
        pgm_function13[(85, 23, 56)] = 0.137786125
        pgm_function13[(85, 23, 57)] = 0.0567
        pgm_function13[(85, 23, 58)] = 0.00440044
        pgm_function13[(85, 24, 49)] = 0.0044
        pgm_function13[(85, 24, 50)] = 0.077792264
        pgm_function13[(85, 24, 51)] = 0.211079108
        pgm_function13[(85, 24, 52)] = 0.3144
        pgm_function13[(85, 24, 53)] = 0.268873218
        pgm_function13[(85, 24, 54)] = 0.150015177
        pgm_function13[(85, 24, 55)] = 0.063306316
        pgm_function13[(85, 24, 56)] = 0.0067
        pgm_function13[(85, 25, 47)] = 0.002200222
        pgm_function13[(85, 25, 48)] = 0.0611
        pgm_function13[(85, 25, 49)] = 0.1989201
        pgm_function13[(85, 25, 50)] = 0.3078
        pgm_function13[(85, 25, 51)] = 0.2789
        pgm_function13[(85, 25, 52)] = 0.162232068
        pgm_function13[(85, 25, 53)] = 0.071107166
        pgm_function13[(85, 25, 54)] = 0.0111
        pgm_function13[(85, 26, 45)] = 0.0011
        pgm_function13[(85, 26, 46)] = 0.04780485
        pgm_function13[(85, 26, 47)] = 0.1867
        pgm_function13[(85, 26, 48)] = 0.300030264
        pgm_function13[(85, 26, 49)] = 0.290029191
        pgm_function13[(85, 26, 50)] = 0.176682136
        pgm_function13[(85, 26, 51)] = 0.07669235
        pgm_function13[(85, 26, 52)] = 0.01560161
        pgm_function13[(85, 27, 44)] = 0.0389
        pgm_function13[(85, 27, 45)] = 0.1656
        pgm_function13[(85, 27, 46)] = 0.297829958
        pgm_function13[(85, 27, 47)] = 0.296670202
        pgm_function13[(85, 27, 48)] = 0.19
        pgm_function13[(85, 27, 49)] = 0.08440848
        pgm_function13[(85, 27, 50)] = 0.021102115
        pgm_function13[(85, 28, 42)] = 0.028897124
        pgm_function13[(85, 28, 43)] = 0.144428931
        pgm_function13[(85, 28, 44)] = 0.2933
        pgm_function13[(85, 28, 45)] = 0.30223021
        pgm_function13[(85, 28, 46)] = 0.204380061
        pgm_function13[(85, 28, 47)] = 0.0956
        pgm_function13[(85, 28, 48)] = 0.0267
        pgm_function13[(85, 29, 40)] = 0.020002003
        pgm_function13[(85, 29, 41)] = 0.13
        pgm_function13[(85, 29, 42)] = 0.27557236
        pgm_function13[(85, 29, 43)] = 0.311069093
        pgm_function13[(85, 29, 44)] = 0.217778081
        pgm_function13[(85, 29, 45)] = 0.1044
        pgm_function13[(85, 29, 46)] = 0.0322
        pgm_function13[(85, 30, 38)] = 0.013298716
        pgm_function13[(85, 30, 39)] = 0.1167
        pgm_function13[(85, 30, 40)] = 0.257774021
        pgm_function13[(85, 30, 41)] = 0.318868115
        pgm_function13[(85, 30, 42)] = 0.231123222
        pgm_function13[(85, 30, 43)] = 0.114411078
        pgm_function13[(85, 30, 44)] = 0.0389
        pgm_function13[(85, 30, 45)] = 0.0011
        pgm_function13[(85, 31, 36)] = 0.01
        pgm_function13[(85, 31, 37)] = 0.098880155
        pgm_function13[(85, 31, 38)] = 0.2433
        pgm_function13[(85, 31, 39)] = 0.3244
        pgm_function13[(85, 31, 40)] = 0.2467
        pgm_function13[(85, 31, 41)] = 0.125587102
        pgm_function13[(85, 31, 42)] = 0.0444
        pgm_function13[(85, 31, 43)] = 0.0022
        pgm_function13[(85, 32, 34)] = 0.0067
        pgm_function13[(85, 32, 35)] = 0.0811
        pgm_function13[(85, 32, 36)] = 0.2311
        pgm_function13[(85, 32, 37)] = 0.32113209
        pgm_function13[(85, 32, 38)] = 0.26327413
        pgm_function13[(85, 32, 39)] = 0.1389
        pgm_function13[(85, 32, 40)] = 0.05
        pgm_function13[(85, 32, 41)] = 0.0044
        pgm_function13[(86, 19, 60)] = 0.0255974
        pgm_function13[(86, 20, 58)] = 0.017798207
        pgm_function13[(86, 20, 59)] = 0.12561299
        pgm_function13[(86, 20, 60)] = 0.2622
        pgm_function13[(86, 21, 56)] = 0.0133013
        pgm_function13[(86, 21, 57)] = 0.1078
        pgm_function13[(86, 21, 58)] = 0.2511
        pgm_function13[(86, 21, 59)] = 0.31
        pgm_function13[(86, 21, 60)] = 0.233323156
        pgm_function13[(86, 22, 54)] = 0.01000101
        pgm_function13[(86, 22, 55)] = 0.0911
        pgm_function13[(86, 22, 56)] = 0.240024158
        pgm_function13[(86, 22, 57)] = 0.304430298
        pgm_function13[(86, 22, 58)] = 0.2522
        pgm_function13[(86, 22, 59)] = 0.135614094
        pgm_function13[(86, 22, 60)] = 0.056694329
        pgm_function13[(86, 23, 52)] = 0.0067
        pgm_function13[(86, 23, 53)] = 0.078907968
        pgm_function13[(86, 23, 54)] = 0.218878136
        pgm_function13[(86, 23, 55)] = 0.30666934
        pgm_function13[(86, 23, 56)] = 0.266673243
        pgm_function13[(86, 23, 57)] = 0.1478
        pgm_function13[(86, 23, 58)] = 0.0633063
        pgm_function13[(86, 23, 59)] = 0.006699333
        pgm_function13[(86, 24, 50)] = 0.002199782
        pgm_function13[(86, 24, 51)] = 0.067793235
        pgm_function13[(86, 24, 52)] = 0.1956
        pgm_function13[(86, 24, 53)] = 0.309969251
        pgm_function13[(86, 24, 54)] = 0.274427324
        pgm_function13[(86, 24, 55)] = 0.160016042
        pgm_function13[(86, 24, 56)] = 0.0711
        pgm_function13[(86, 24, 57)] = 0.009999007
        pgm_function13[(86, 25, 48)] = 0.0011
        pgm_function13[(86, 25, 49)] = 0.05330533
        pgm_function13[(86, 25, 50)] = 0.1833
        pgm_function13[(86, 25, 51)] = 0.3044
        pgm_function13[(86, 25, 52)] = 0.283357119
        pgm_function13[(86, 25, 53)] = 0.174417162
        pgm_function13[(86, 25, 54)] = 0.0767
        pgm_function13[(86, 25, 55)] = 0.0156
        pgm_function13[(86, 26, 47)] = 0.04
        pgm_function13[(86, 26, 48)] = 0.171117151
        pgm_function13[(86, 26, 49)] = 0.294429194
        pgm_function13[(86, 26, 50)] = 0.295570228
        pgm_function13[(86, 26, 51)] = 0.18778111
        pgm_function13[(86, 26, 52)] = 0.08440846
        pgm_function13[(86, 26, 53)] = 0.02000202
        pgm_function13[(86, 27, 45)] = 0.03
        pgm_function13[(86, 27, 46)] = 0.153314979
        pgm_function13[(86, 27, 47)] = 0.287771196
        pgm_function13[(86, 27, 48)] = 0.3033
        pgm_function13[(86, 27, 49)] = 0.20222018
        pgm_function13[(86, 27, 50)] = 0.093309366
        pgm_function13[(86, 27, 51)] = 0.026697307
        pgm_function13[(86, 28, 43)] = 0.023304689
        pgm_function13[(86, 28, 44)] = 0.1311
        pgm_function13[(86, 28, 45)] = 0.2822282
        pgm_function13[(86, 28, 46)] = 0.306669092
        pgm_function13[(86, 28, 47)] = 0.2122
        pgm_function13[(86, 28, 48)] = 0.1033
        pgm_function13[(86, 28, 49)] = 0.032203222
        pgm_function13[(86, 29, 41)] = 0.0156
        pgm_function13[(86, 29, 42)] = 0.11558815
        pgm_function13[(86, 29, 43)] = 0.26667308
        pgm_function13[(86, 29, 44)] = 0.313269116
        pgm_function13[(86, 29, 45)] = 0.2267
        pgm_function13[(86, 29, 46)] = 0.1144
        pgm_function13[(86, 29, 47)] = 0.038903927
        pgm_function13[(86, 29, 48)] = 0.00110011
        pgm_function13[(86, 30, 39)] = 0.01
        pgm_function13[(86, 30, 40)] = 0.104390008
        pgm_function13[(86, 30, 41)] = 0.245575088
        pgm_function13[(86, 30, 42)] = 0.322232309
        pgm_function13[(86, 30, 43)] = 0.242224165
        pgm_function13[(86, 30, 44)] = 0.1256
        pgm_function13[(86, 30, 45)] = 0.0444
        pgm_function13[(86, 30, 46)] = 0.002200221
        pgm_function13[(86, 31, 37)] = 0.006698657
        pgm_function13[(86, 31, 38)] = 0.0878
        pgm_function13[(86, 31, 39)] = 0.2256
        pgm_function13[(86, 31, 40)] = 0.3233
        pgm_function13[(86, 31, 41)] = 0.256674208
        pgm_function13[(86, 31, 42)] = 0.1367
        pgm_function13[(86, 31, 43)] = 0.05
        pgm_function13[(86, 31, 44)] = 0.0044
        pgm_function13[(86, 32, 35)] = 0.0044
        pgm_function13[(86, 32, 36)] = 0.0711
        pgm_function13[(86, 32, 37)] = 0.21442106
        pgm_function13[(86, 32, 38)] = 0.31666816
        pgm_function13[(86, 32, 39)] = 0.2722
        pgm_function13[(86, 32, 40)] = 0.1522
        pgm_function13[(86, 32, 41)] = 0.0556
        pgm_function13[(86, 32, 42)] = 0.006700675
        pgm_function13[(87, 20, 59)] = 0.0144014
        pgm_function13[(87, 20, 60)] = 0.1122
        pgm_function13[(87, 21, 57)] = 0.01
        pgm_function13[(87, 21, 58)] = 0.0967
        pgm_function13[(87, 21, 59)] = 0.2356
        pgm_function13[(87, 21, 60)] = 0.311131208
        pgm_function13[(87, 22, 55)] = 0.0067
        pgm_function13[(87, 22, 56)] = 0.081108154
        pgm_function13[(87, 22, 57)] = 0.22442222
        pgm_function13[(87, 22, 58)] = 0.3056
        pgm_function13[(87, 22, 59)] = 0.262226181
        pgm_function13[(87, 22, 60)] = 0.146685076
        pgm_function13[(87, 23, 53)] = 0.004400444
        pgm_function13[(87, 23, 54)] = 0.067793242
        pgm_function13[(87, 23, 55)] = 0.207779231
        pgm_function13[(87, 23, 56)] = 0.301070274
        pgm_function13[(87, 23, 57)] = 0.2733
        pgm_function13[(87, 23, 58)] = 0.15671599
        pgm_function13[(87, 23, 59)] = 0.071092933
        pgm_function13[(87, 23, 60)] = 0.01
        pgm_function13[(87, 24, 51)] = 0.001099891
        pgm_function13[(87, 24, 52)] = 0.0578
        pgm_function13[(87, 24, 53)] = 0.18558115
        pgm_function13[(87, 24, 54)] = 0.303330358
        pgm_function13[(87, 24, 55)] = 0.281128073
        pgm_function13[(87, 24, 56)] = 0.17
        pgm_function13[(87, 24, 57)] = 0.077792254
        pgm_function13[(87, 24, 58)] = 0.01559841
        pgm_function13[(87, 25, 50)] = 0.0456
        pgm_function13[(87, 25, 51)] = 0.1689
        pgm_function13[(87, 25, 52)] = 0.302260127
        pgm_function13[(87, 25, 53)] = 0.288929269
        pgm_function13[(87, 25, 54)] = 0.1867
        pgm_function13[(87, 25, 55)] = 0.0844
        pgm_function13[(87, 25, 56)] = 0.02
        pgm_function13[(87, 26, 48)] = 0.032203228
        pgm_function13[(87, 26, 49)] = 0.157816104
        pgm_function13[(87, 26, 50)] = 0.286671221
        pgm_function13[(87, 26, 51)] = 0.29997018
        pgm_function13[(87, 26, 52)] = 0.20002014
        pgm_function13[(87, 26, 53)] = 0.09220927
        pgm_function13[(87, 26, 54)] = 0.0267
        pgm_function13[(87, 27, 46)] = 0.023302297
        pgm_function13[(87, 27, 47)] = 0.139986095
        pgm_function13[(87, 27, 48)] = 0.2756
        pgm_function13[(87, 27, 49)] = 0.30893128
        pgm_function13[(87, 27, 50)] = 0.21112115
        pgm_function13[(87, 27, 51)] = 0.101090027
        pgm_function13[(87, 27, 52)] = 0.032203215
        pgm_function13[(87, 28, 44)] = 0.0178
        pgm_function13[(87, 28, 45)] = 0.12001208
        pgm_function13[(87, 28, 46)] = 0.26777308
        pgm_function13[(87, 28, 47)] = 0.3133
        pgm_function13[(87, 28, 48)] = 0.2222
        pgm_function13[(87, 28, 49)] = 0.112211075
        pgm_function13[(87, 28, 50)] = 0.0389
        pgm_function13[(87, 28, 51)] = 0.0011
        pgm_function13[(87, 29, 42)] = 0.01329872
        pgm_function13[(87, 29, 43)] = 0.102190031
        pgm_function13[(87, 29, 44)] = 0.255574095
        pgm_function13[(87, 29, 45)] = 0.3156
        pgm_function13[(87, 29, 46)] = 0.2378
        pgm_function13[(87, 29, 47)] = 0.124412086
        pgm_function13[(87, 29, 48)] = 0.04440441
        pgm_function13[(87, 29, 49)] = 0.002200221
        pgm_function13[(87, 30, 40)] = 0.007799221
        pgm_function13[(87, 30, 41)] = 0.091090933
        pgm_function13[(87, 30, 42)] = 0.232223223
        pgm_function13[(87, 30, 43)] = 0.318932217
        pgm_function13[(87, 30, 44)] = 0.2522
        pgm_function13[(87, 30, 45)] = 0.1367
        pgm_function13[(87, 30, 46)] = 0.050005034
        pgm_function13[(87, 30, 47)] = 0.0044
        pgm_function13[(87, 31, 38)] = 0.0044
        pgm_function13[(87, 31, 39)] = 0.08
        pgm_function13[(87, 31, 40)] = 0.2111
        pgm_function13[(87, 31, 41)] = 0.319968259
        pgm_function13[(87, 31, 42)] = 0.2667
        pgm_function13[(87, 31, 43)] = 0.1511
        pgm_function13[(87, 31, 44)] = 0.0556
        pgm_function13[(87, 31, 45)] = 0.0067
        pgm_function13[(87, 32, 36)] = 0.0022
        pgm_function13[(87, 32, 37)] = 0.06330632
        pgm_function13[(87, 32, 38)] = 0.1988801
        pgm_function13[(87, 32, 39)] = 0.3122
        pgm_function13[(87, 32, 40)] = 0.2789
        pgm_function13[(87, 32, 41)] = 0.1622
        pgm_function13[(87, 32, 42)] = 0.063306346
        pgm_function13[(87, 32, 43)] = 0.01000101
        pgm_function13[(88, 20, 60)] = 0.0111
        pgm_function13[(88, 21, 58)] = 0.0067
        pgm_function13[(88, 21, 59)] = 0.0878
        pgm_function13[(88, 21, 60)] = 0.222222149
        pgm_function13[(88, 22, 56)] = 0.004400443
        pgm_function13[(88, 22, 57)] = 0.072207271
        pgm_function13[(88, 22, 58)] = 0.2089
        pgm_function13[(88, 22, 59)] = 0.30443021
        pgm_function13[(88, 22, 60)] = 0.265573138
        pgm_function13[(88, 23, 54)] = 0.002199781
        pgm_function13[(88, 23, 55)] = 0.057794264
        pgm_function13[(88, 23, 56)] = 0.195580178
        pgm_function13[(88, 23, 57)] = 0.2967
        pgm_function13[(88, 23, 58)] = 0.28112799
        pgm_function13[(88, 23, 59)] = 0.166683078
        pgm_function13[(88, 23, 60)] = 0.0778
        pgm_function13[(88, 24, 52)] = 0.0011
        pgm_function13[(88, 24, 53)] = 0.047795239
        pgm_function13[(88, 24, 54)] = 0.174417206
        pgm_function13[(88, 24, 55)] = 0.296730077
        pgm_function13[(88, 24, 56)] = 0.29
        pgm_function13[(88, 24, 57)] = 0.181082127
        pgm_function13[(88, 24, 58)] = 0.08439165
        pgm_function13[(88, 24, 59)] = 0.02000201
        pgm_function13[(88, 25, 51)] = 0.0367
        pgm_function13[(88, 25, 52)] = 0.154431065
        pgm_function13[(88, 25, 53)] = 0.291129271
        pgm_function13[(88, 25, 54)] = 0.2922
        pgm_function13[(88, 25, 55)] = 0.1978
        pgm_function13[(88, 25, 56)] = 0.0922
        pgm_function13[(88, 25, 57)] = 0.0267
        pgm_function13[(88, 26, 49)] = 0.025602617
        pgm_function13[(88, 26, 50)] = 0.14328611
        pgm_function13[(88, 26, 51)] = 0.27887217
        pgm_function13[(88, 26, 52)] = 0.30113021
        pgm_function13[(88, 26, 53)] = 0.21112117
        pgm_function13[(88, 26, 54)] = 0.1011
        pgm_function13[(88, 26, 55)] = 0.0322032
        pgm_function13[(88, 27, 47)] = 0.017798212
        pgm_function13[(88, 27, 48)] = 0.1278
        pgm_function13[(88, 27, 49)] = 0.26332624
        pgm_function13[(88, 27, 50)] = 0.312231222
        pgm_function13[(88, 27, 51)] = 0.22217806
        pgm_function13[(88, 27, 52)] = 0.110011051
        pgm_function13[(88, 27, 53)] = 0.0389
        pgm_function13[(88, 27, 54)] = 0.001100111
        pgm_function13[(88, 28, 45)] = 0.01330131
        pgm_function13[(88, 28, 46)] = 0.108889033
        pgm_function13[(88, 28, 47)] = 0.2533
        pgm_function13[(88, 28, 48)] = 0.3189
        pgm_function13[(88, 28, 49)] = 0.234423157
        pgm_function13[(88, 28, 50)] = 0.1211
        pgm_function13[(88, 28, 51)] = 0.0444
        pgm_function13[(88, 28, 52)] = 0.0022
        pgm_function13[(88, 29, 43)] = 0.009999003
        pgm_function13[(88, 29, 44)] = 0.089991033
        pgm_function13[(88, 29, 45)] = 0.2411
        pgm_function13[(88, 29, 46)] = 0.3156
        pgm_function13[(88, 29, 47)] = 0.247825171
        pgm_function13[(88, 29, 48)] = 0.13441303
        pgm_function13[(88, 29, 49)] = 0.050005019
        pgm_function13[(88, 29, 50)] = 0.004399564
        pgm_function13[(88, 30, 41)] = 0.005599442
        pgm_function13[(88, 30, 42)] = 0.078907976
        pgm_function13[(88, 30, 43)] = 0.22112215
        pgm_function13[(88, 30, 44)] = 0.3133
        pgm_function13[(88, 30, 45)] = 0.2622
        pgm_function13[(88, 30, 46)] = 0.147815101
        pgm_function13[(88, 30, 47)] = 0.0556
        pgm_function13[(88, 30, 48)] = 0.006699334
        pgm_function13[(88, 31, 39)] = 0.0022
        pgm_function13[(88, 31, 40)] = 0.0689
        pgm_function13[(88, 31, 41)] = 0.199980162
        pgm_function13[(88, 31, 42)] = 0.3133
        pgm_function13[(88, 31, 43)] = 0.2722
        pgm_function13[(88, 31, 44)] = 0.1611
        pgm_function13[(88, 31, 45)] = 0.0633
        pgm_function13[(88, 31, 46)] = 0.01
        pgm_function13[(88, 32, 37)] = 0.00110011
        pgm_function13[(88, 32, 38)] = 0.05559443
        pgm_function13[(88, 32, 39)] = 0.1856
        pgm_function13[(88, 32, 40)] = 0.3089
        pgm_function13[(88, 32, 41)] = 0.2878
        pgm_function13[(88, 32, 42)] = 0.173317127
        pgm_function13[(88, 32, 43)] = 0.07220727
        pgm_function13[(88, 32, 44)] = 0.0133013
        pgm_function13[(89, 21, 59)] = 0.0044
        pgm_function13[(89, 21, 60)] = 0.075607651
        pgm_function13[(89, 22, 57)] = 0.002200222
        pgm_function13[(89, 22, 58)] = 0.0633
        pgm_function13[(89, 22, 59)] = 0.194419134
        pgm_function13[(89, 22, 60)] = 0.303270158
        pgm_function13[(89, 23, 55)] = 0.001099891
        pgm_function13[(89, 23, 56)] = 0.048895144
        pgm_function13[(89, 23, 57)] = 0.1822
        pgm_function13[(89, 23, 58)] = 0.29442899
        pgm_function13[(89, 23, 59)] = 0.285571134
        pgm_function13[(89, 23, 60)] = 0.1789
        pgm_function13[(89, 24, 54)] = 0.038903946
        pgm_function13[(89, 24, 55)] = 0.164416043
        pgm_function13[(89, 24, 56)] = 0.2856
        pgm_function13[(89, 24, 57)] = 0.295570207
        pgm_function13[(89, 24, 58)] = 0.19108111
        pgm_function13[(89, 24, 59)] = 0.09220926
        pgm_function13[(89, 24, 60)] = 0.0256
        pgm_function13[(89, 25, 52)] = 0.030006013
        pgm_function13[(89, 25, 53)] = 0.144414134
        pgm_function13[(89, 25, 54)] = 0.2822
        pgm_function13[(89, 25, 55)] = 0.2956
        pgm_function13[(89, 25, 56)] = 0.2078
        pgm_function13[(89, 25, 57)] = 0.1011
        pgm_function13[(89, 25, 58)] = 0.0322
        pgm_function13[(89, 26, 50)] = 0.019998015
        pgm_function13[(89, 26, 51)] = 0.12778708
        pgm_function13[(89, 26, 52)] = 0.27222719
        pgm_function13[(89, 26, 53)] = 0.30333024
        pgm_function13[(89, 26, 54)] = 0.22
        pgm_function13[(89, 26, 55)] = 0.11001101
        pgm_function13[(89, 26, 56)] = 0.0389
        pgm_function13[(89, 27, 48)] = 0.0144
        pgm_function13[(89, 27, 49)] = 0.1144111
        pgm_function13[(89, 27, 50)] = 0.252225179
        pgm_function13[(89, 27, 51)] = 0.315568085
        pgm_function13[(89, 27, 52)] = 0.233323107
        pgm_function13[(89, 27, 53)] = 0.12
        pgm_function13[(89, 27, 54)] = 0.044404421
        pgm_function13[(89, 27, 55)] = 0.002200221
        pgm_function13[(89, 28, 46)] = 0.009999003
        pgm_function13[(89, 28, 47)] = 0.0978
        pgm_function13[(89, 28, 48)] = 0.2367
        pgm_function13[(89, 28, 49)] = 0.318932214
        pgm_function13[(89, 28, 50)] = 0.2444
        pgm_function13[(89, 28, 51)] = 0.1322
        pgm_function13[(89, 28, 52)] = 0.05
        pgm_function13[(89, 28, 53)] = 0.0044
        pgm_function13[(89, 29, 44)] = 0.006699332
        pgm_function13[(89, 29, 45)] = 0.0811
        pgm_function13[(89, 29, 46)] = 0.2267
        pgm_function13[(89, 29, 47)] = 0.313331216
        pgm_function13[(89, 29, 48)] = 0.25782605
        pgm_function13[(89, 29, 49)] = 0.144414055
        pgm_function13[(89, 29, 50)] = 0.055594447
        pgm_function13[(89, 29, 51)] = 0.006699335
        pgm_function13[(89, 30, 42)] = 0.004400444
        pgm_function13[(89, 30, 43)] = 0.067806846
        pgm_function13[(89, 30, 44)] = 0.2111
        pgm_function13[(89, 30, 45)] = 0.3078
        pgm_function13[(89, 30, 46)] = 0.271127184
        pgm_function13[(89, 30, 47)] = 0.1589
        pgm_function13[(89, 30, 48)] = 0.062193835
        pgm_function13[(89, 30, 49)] = 0.01
        pgm_function13[(89, 31, 40)] = 0.0011
        pgm_function13[(89, 31, 41)] = 0.057794247
        pgm_function13[(89, 31, 42)] = 0.19
        pgm_function13[(89, 31, 43)] = 0.3078
        pgm_function13[(89, 31, 44)] = 0.2833
        pgm_function13[(89, 31, 45)] = 0.1711
        pgm_function13[(89, 31, 46)] = 0.0711
        pgm_function13[(89, 31, 47)] = 0.0133
        pgm_function13[(89, 32, 39)] = 0.0456
        pgm_function13[(89, 32, 40)] = 0.17
        pgm_function13[(89, 32, 41)] = 0.3033
        pgm_function13[(89, 32, 42)] = 0.293329214
        pgm_function13[(89, 32, 43)] = 0.18111818
        pgm_function13[(89, 32, 44)] = 0.08220822
        pgm_function13[(89, 32, 45)] = 0.0178
        pgm_function13[(90, 21, 60)] = 0.003300332
        pgm_function13[(90, 22, 58)] = 0.0011
        pgm_function13[(90, 22, 59)] = 0.053305337
        pgm_function13[(90, 22, 60)] = 0.179982094
        pgm_function13[(90, 23, 57)] = 0.0411
        pgm_function13[(90, 23, 58)] = 0.16671699
        pgm_function13[(90, 23, 59)] = 0.288871136
        pgm_function13[(90, 23, 60)] = 0.29
        pgm_function13[(90, 24, 55)] = 0.030003008
        pgm_function13[(90, 24, 56)] = 0.1522
        pgm_function13[(90, 24, 57)] = 0.277772194
        pgm_function13[(90, 24, 58)] = 0.29777018
        pgm_function13[(90, 24, 59)] = 0.20112012
        pgm_function13[(90, 24, 60)] = 0.1011
        pgm_function13[(90, 25, 53)] = 0.023302322
        pgm_function13[(90, 25, 54)] = 0.1333
        pgm_function13[(90, 25, 55)] = 0.2733
        pgm_function13[(90, 25, 56)] = 0.3011
        pgm_function13[(90, 25, 57)] = 0.2133
        pgm_function13[(90, 25, 58)] = 0.11
        pgm_function13[(90, 25, 59)] = 0.03890391
        pgm_function13[(90, 26, 51)] = 0.01779821
        pgm_function13[(90, 26, 52)] = 0.11331108
        pgm_function13[(90, 26, 53)] = 0.26002621
        pgm_function13[(90, 26, 54)] = 0.3078
        pgm_function13[(90, 26, 55)] = 0.23002301
        pgm_function13[(90, 26, 56)] = 0.1189
        pgm_function13[(90, 26, 57)] = 0.0456
        pgm_function13[(90, 26, 58)] = 0.0022
        pgm_function13[(90, 27, 49)] = 0.01110111
        pgm_function13[(90, 27, 50)] = 0.101110072
        pgm_function13[(90, 27, 51)] = 0.238876064
        pgm_function13[(90, 27, 52)] = 0.314431145
        pgm_function13[(90, 27, 53)] = 0.2444
        pgm_function13[(90, 27, 54)] = 0.130013062
        pgm_function13[(90, 27, 55)] = 0.050005034
        pgm_function13[(90, 27, 56)] = 0.004400443
        pgm_function13[(90, 28, 47)] = 0.0067
        pgm_function13[(90, 28, 48)] = 0.0878
        pgm_function13[(90, 28, 49)] = 0.221122148
        pgm_function13[(90, 28, 50)] = 0.3189
        pgm_function13[(90, 28, 51)] = 0.2533
        pgm_function13[(90, 28, 52)] = 0.1422
        pgm_function13[(90, 28, 53)] = 0.0556
        pgm_function13[(90, 28, 54)] = 0.0067
        pgm_function13[(90, 29, 45)] = 0.0044
        pgm_function13[(90, 29, 46)] = 0.0711
        pgm_function13[(90, 29, 47)] = 0.211121146
        pgm_function13[(90, 29, 48)] = 0.31223106
        pgm_function13[(90, 29, 49)] = 0.266727101
        pgm_function13[(90, 29, 50)] = 0.156684132
        pgm_function13[(90, 29, 51)] = 0.062193848
        pgm_function13[(90, 29, 52)] = 0.009999013
        pgm_function13[(90, 30, 43)] = 0.002200221
        pgm_function13[(90, 30, 44)] = 0.0578
        pgm_function13[(90, 30, 45)] = 0.2
        pgm_function13[(90, 30, 46)] = 0.303330206
        pgm_function13[(90, 30, 47)] = 0.2811
        pgm_function13[(90, 30, 48)] = 0.168883096
        pgm_function13[(90, 30, 49)] = 0.07
        pgm_function13[(90, 30, 50)] = 0.01329871
        pgm_function13[(90, 31, 41)] = 0.001099891
        pgm_function13[(90, 31, 42)] = 0.0478
        pgm_function13[(90, 31, 43)] = 0.1778
        pgm_function13[(90, 31, 44)] = 0.2989
        pgm_function13[(90, 31, 45)] = 0.29
        pgm_function13[(90, 31, 46)] = 0.1778
        pgm_function13[(90, 31, 47)] = 0.0822
        pgm_function13[(90, 31, 48)] = 0.01780182
        pgm_function13[(90, 32, 40)] = 0.0378
        pgm_function13[(90, 32, 41)] = 0.1567
        pgm_function13[(90, 32, 42)] = 0.294429215
        pgm_function13[(90, 32, 43)] = 0.3000303
        pgm_function13[(90, 32, 44)] = 0.18891904
        pgm_function13[(90, 32, 45)] = 0.0911
        pgm_function13[(90, 32, 46)] = 0.0222
        pgm_function13[(91, 22, 60)] = 0.045595424
        pgm_function13[(91, 23, 58)] = 0.0333033
        pgm_function13[(91, 23, 59)] = 0.154385073
        pgm_function13[(91, 23, 60)] = 0.2822
        pgm_function13[(91, 24, 56)] = 0.0244
        pgm_function13[(91, 24, 57)] = 0.138886097
        pgm_function13[(91, 24, 58)] = 0.26997316
        pgm_function13[(91, 24, 59)] = 0.30333018
        pgm_function13[(91, 24, 60)] = 0.21
        pgm_function13[(91, 25, 54)] = 0.0178
        pgm_function13[(91, 25, 55)] = 0.12
        pgm_function13[(91, 25, 56)] = 0.2589
        pgm_function13[(91, 25, 57)] = 0.3089
        pgm_function13[(91, 25, 58)] = 0.2233
        pgm_function13[(91, 25, 59)] = 0.118912031
        pgm_function13[(91, 25, 60)] = 0.0456
        pgm_function13[(91, 26, 52)] = 0.01330131
        pgm_function13[(91, 26, 53)] = 0.10331008
        pgm_function13[(91, 26, 54)] = 0.2444
        pgm_function13[(91, 26, 55)] = 0.30783102
        pgm_function13[(91, 26, 56)] = 0.24
        pgm_function13[(91, 26, 57)] = 0.13
        pgm_function13[(91, 26, 58)] = 0.05
        pgm_function13[(91, 26, 59)] = 0.0044
        pgm_function13[(91, 27, 50)] = 0.008900896
        pgm_function13[(91, 27, 51)] = 0.088891124
        pgm_function13[(91, 27, 52)] = 0.226723104
        pgm_function13[(91, 27, 53)] = 0.3089
        pgm_function13[(91, 27, 54)] = 0.253325122
        pgm_function13[(91, 27, 55)] = 0.140014095
        pgm_function13[(91, 27, 56)] = 0.055605637
        pgm_function13[(91, 27, 57)] = 0.0067
        pgm_function13[(91, 28, 48)] = 0.0044
        pgm_function13[(91, 28, 49)] = 0.077807852
        pgm_function13[(91, 28, 50)] = 0.2089
        pgm_function13[(91, 28, 51)] = 0.3156
        pgm_function13[(91, 28, 52)] = 0.2644
        pgm_function13[(91, 28, 53)] = 0.1533
        pgm_function13[(91, 28, 54)] = 0.0622
        pgm_function13[(91, 28, 55)] = 0.01000101
        pgm_function13[(91, 29, 46)] = 0.0022
        pgm_function13[(91, 29, 47)] = 0.063306344
        pgm_function13[(91, 29, 48)] = 0.19672004
        pgm_function13[(91, 29, 49)] = 0.308931117
        pgm_function13[(91, 29, 50)] = 0.275572231
        pgm_function13[(91, 29, 51)] = 0.166683128
        pgm_function13[(91, 29, 52)] = 0.069993091
        pgm_function13[(91, 29, 53)] = 0.0133
        pgm_function13[(91, 30, 44)] = 0.0011
        pgm_function13[(91, 30, 45)] = 0.0478
        pgm_function13[(91, 30, 46)] = 0.184418125
        pgm_function13[(91, 30, 47)] = 0.2967
        pgm_function13[(91, 30, 48)] = 0.287771164
        pgm_function13[(91, 30, 49)] = 0.1778
        pgm_function13[(91, 30, 50)] = 0.07889218
        pgm_function13[(91, 30, 51)] = 0.01779822
        pgm_function13[(91, 31, 43)] = 0.0389
        pgm_function13[(91, 31, 44)] = 0.1667
        pgm_function13[(91, 31, 45)] = 0.29
        pgm_function13[(91, 31, 46)] = 0.3011
        pgm_function13[(91, 31, 47)] = 0.1833
        pgm_function13[(91, 31, 48)] = 0.09000909
        pgm_function13[(91, 31, 49)] = 0.0222
        pgm_function13[(91, 32, 41)] = 0.03
        pgm_function13[(91, 32, 42)] = 0.145615106
        pgm_function13[(91, 32, 43)] = 0.28442828
        pgm_function13[(91, 32, 44)] = 0.30443006
        pgm_function13[(91, 32, 45)] = 0.1978
        pgm_function13[(91, 32, 46)] = 0.1022
        pgm_function13[(91, 32, 47)] = 0.027794373
        pgm_function13[(92, 23, 59)] = 0.026697313
        pgm_function13[(92, 23, 60)] = 0.14
        pgm_function13[(92, 24, 57)] = 0.018898113
        pgm_function13[(92, 24, 58)] = 0.12558708
        pgm_function13[(92, 24, 59)] = 0.26112616
        pgm_function13[(92, 24, 60)] = 0.3044
        pgm_function13[(92, 25, 55)] = 0.0133
        pgm_function13[(92, 25, 56)] = 0.11
        pgm_function13[(92, 25, 57)] = 0.2444
        pgm_function13[(92, 25, 58)] = 0.3111
        pgm_function13[(92, 25, 59)] = 0.23112306
        pgm_function13[(92, 25, 60)] = 0.1289
        pgm_function13[(92, 26, 53)] = 0.01000101
        pgm_function13[(92, 26, 54)] = 0.0933
        pgm_function13[(92, 26, 55)] = 0.23222301
        pgm_function13[(92, 26, 56)] = 0.3078
        pgm_function13[(92, 26, 57)] = 0.2478
        pgm_function13[(92, 26, 58)] = 0.14
        pgm_function13[(92, 26, 59)] = 0.0556
        pgm_function13[(92, 26, 60)] = 0.006699333
        pgm_function13[(92, 27, 51)] = 0.006699332
        pgm_function13[(92, 27, 52)] = 0.078907936
        pgm_function13[(92, 27, 53)] = 0.2178
        pgm_function13[(92, 27, 54)] = 0.304430146
        pgm_function13[(92, 27, 55)] = 0.26442618
        pgm_function13[(92, 27, 56)] = 0.1511151
        pgm_function13[(92, 27, 57)] = 0.0622
        pgm_function13[(92, 27, 58)] = 0.01
        pgm_function13[(92, 28, 49)] = 0.003300332
        pgm_function13[(92, 28, 50)] = 0.0656
        pgm_function13[(92, 28, 51)] = 0.1956
        pgm_function13[(92, 28, 52)] = 0.3067
        pgm_function13[(92, 28, 53)] = 0.2744
        pgm_function13[(92, 28, 54)] = 0.1644
        pgm_function13[(92, 28, 55)] = 0.07000704
        pgm_function13[(92, 28, 56)] = 0.0133
        pgm_function13[(92, 29, 47)] = 0.001100111
        pgm_function13[(92, 29, 48)] = 0.05330531
        pgm_function13[(92, 29, 49)] = 0.18331807
        pgm_function13[(92, 29, 50)] = 0.301070253
        pgm_function13[(92, 29, 51)] = 0.282172217
        pgm_function13[(92, 29, 52)] = 0.175582228
        pgm_function13[(92, 29, 53)] = 0.0778
        pgm_function13[(92, 29, 54)] = 0.0178
        pgm_function13[(92, 30, 46)] = 0.041104128
        pgm_function13[(92, 30, 47)] = 0.17
        pgm_function13[(92, 30, 48)] = 0.291071166
        pgm_function13[(92, 30, 49)] = 0.2944
        pgm_function13[(92, 30, 50)] = 0.18558119
        pgm_function13[(92, 30, 51)] = 0.08889119
        pgm_function13[(92, 30, 52)] = 0.0222
        pgm_function13[(92, 31, 44)] = 0.03
        pgm_function13[(92, 31, 45)] = 0.1556
        pgm_function13[(92, 31, 46)] = 0.2811
        pgm_function13[(92, 31, 47)] = 0.3067
        pgm_function13[(92, 31, 48)] = 0.19441919
        pgm_function13[(92, 31, 49)] = 0.0989
        pgm_function13[(92, 31, 50)] = 0.027797208
        pgm_function13[(92, 32, 42)] = 0.023302317
        pgm_function13[(92, 32, 43)] = 0.13441313
        pgm_function13[(92, 32, 44)] = 0.27672806
        pgm_function13[(92, 32, 45)] = 0.31
        pgm_function13[(92, 32, 46)] = 0.2078
        pgm_function13[(92, 32, 47)] = 0.11217789
        pgm_function13[(92, 32, 48)] = 0.0333
        pgm_function13[(93, 23, 60)] = 0.0211
        pgm_function13[(93, 24, 58)] = 0.01559841
        pgm_function13[(93, 24, 59)] = 0.11001107
        pgm_function13[(93, 24, 60)] = 0.2511
        pgm_function13[(93, 25, 56)] = 0.01
        pgm_function13[(93, 25, 57)] = 0.0978
        pgm_function13[(93, 25, 58)] = 0.2311
        pgm_function13[(93, 25, 59)] = 0.312231081
        pgm_function13[(93, 25, 60)] = 0.24
        pgm_function13[(93, 26, 54)] = 0.0067
        pgm_function13[(93, 26, 55)] = 0.0833083
        pgm_function13[(93, 26, 56)] = 0.2189
        pgm_function13[(93, 26, 57)] = 0.3067
        pgm_function13[(93, 26, 58)] = 0.2567
        pgm_function13[(93, 26, 59)] = 0.15
        pgm_function13[(93, 26, 60)] = 0.061093929
        pgm_function13[(93, 27, 52)] = 0.004400442
        pgm_function13[(93, 27, 53)] = 0.0678
        pgm_function13[(93, 27, 54)] = 0.206721099
        pgm_function13[(93, 27, 55)] = 0.301130205
        pgm_function13[(93, 27, 56)] = 0.27222718
        pgm_function13[(93, 27, 57)] = 0.1611
        pgm_function13[(93, 27, 58)] = 0.07
        pgm_function13[(93, 27, 59)] = 0.0133
        pgm_function13[(93, 28, 50)] = 0.0022
        pgm_function13[(93, 28, 51)] = 0.0567
        pgm_function13[(93, 28, 52)] = 0.1867
        pgm_function13[(93, 28, 53)] = 0.2967
        pgm_function13[(93, 28, 54)] = 0.2811
        pgm_function13[(93, 28, 55)] = 0.1722171
        pgm_function13[(93, 28, 56)] = 0.0778
        pgm_function13[(93, 28, 57)] = 0.01779821
        pgm_function13[(93, 29, 49)] = 0.044404417
        pgm_function13[(93, 29, 50)] = 0.168883142
        pgm_function13[(93, 29, 51)] = 0.295570228
        pgm_function13[(93, 29, 52)] = 0.288871376
        pgm_function13[(93, 29, 53)] = 0.1844
        pgm_function13[(93, 29, 54)] = 0.0889
        pgm_function13[(93, 29, 55)] = 0.02220222
        pgm_function13[(93, 30, 47)] = 0.0333
        pgm_function13[(93, 30, 48)] = 0.156684089
        pgm_function13[(93, 30, 49)] = 0.2856
        pgm_function13[(93, 30, 50)] = 0.2999703
        pgm_function13[(93, 30, 51)] = 0.1955802
        pgm_function13[(93, 30, 52)] = 0.0978
        pgm_function13[(93, 30, 53)] = 0.027797224
        pgm_function13[(93, 31, 45)] = 0.0233
        pgm_function13[(93, 31, 46)] = 0.1411
        pgm_function13[(93, 31, 47)] = 0.2722
        pgm_function13[(93, 31, 48)] = 0.31003131
        pgm_function13[(93, 31, 49)] = 0.2056
        pgm_function13[(93, 31, 50)] = 0.10998903
        pgm_function13[(93, 31, 51)] = 0.0333
        pgm_function13[(93, 32, 43)] = 0.01780182
        pgm_function13[(93, 32, 44)] = 0.12111202
        pgm_function13[(93, 32, 45)] = 0.2644
        pgm_function13[(93, 32, 46)] = 0.3111
        pgm_function13[(93, 32, 47)] = 0.216656788
        pgm_function13[(93, 32, 48)] = 0.12
        pgm_function13[(93, 32, 49)] = 0.04
        pgm_function13[(93, 32, 50)] = 0.0011
        pgm_function13[(94, 24, 59)] = 0.01220121
        pgm_function13[(94, 24, 60)] = 0.0978
        pgm_function13[(94, 25, 57)] = 0.0078
        pgm_function13[(94, 25, 58)] = 0.0867
        pgm_function13[(94, 25, 59)] = 0.220022057
        pgm_function13[(94, 25, 60)] = 0.31
        pgm_function13[(94, 26, 55)] = 0.00440044
        pgm_function13[(94, 26, 56)] = 0.0733
        pgm_function13[(94, 26, 57)] = 0.2044
        pgm_function13[(94, 26, 58)] = 0.3056
        pgm_function13[(94, 26, 59)] = 0.2633
        pgm_function13[(94, 26, 60)] = 0.161084076
        pgm_function13[(94, 27, 53)] = 0.0022
        pgm_function13[(94, 27, 54)] = 0.058905928
        pgm_function13[(94, 27, 55)] = 0.19111913
        pgm_function13[(94, 27, 56)] = 0.294429194
        pgm_function13[(94, 27, 57)] = 0.2789
        pgm_function13[(94, 27, 58)] = 0.1689
        pgm_function13[(94, 27, 59)] = 0.0778
        pgm_function13[(94, 27, 60)] = 0.0178
        pgm_function13[(94, 28, 51)] = 0.0011
        pgm_function13[(94, 28, 52)] = 0.0478
        pgm_function13[(94, 28, 53)] = 0.1767
        pgm_function13[(94, 28, 54)] = 0.2889
        pgm_function13[(94, 28, 55)] = 0.28892917
        pgm_function13[(94, 28, 56)] = 0.1789
        pgm_function13[(94, 28, 57)] = 0.08779123
        pgm_function13[(94, 28, 58)] = 0.0222
        pgm_function13[(94, 29, 50)] = 0.037796232
        pgm_function13[(94, 29, 51)] = 0.157784121
        pgm_function13[(94, 29, 52)] = 0.285571371
        pgm_function13[(94, 29, 53)] = 0.2967
        pgm_function13[(94, 29, 54)] = 0.1922
        pgm_function13[(94, 29, 55)] = 0.0978099
        pgm_function13[(94, 29, 56)] = 0.02779722
        pgm_function13[(94, 30, 48)] = 0.026697315
        pgm_function13[(94, 30, 49)] = 0.1411
        pgm_function13[(94, 30, 50)] = 0.27667228
        pgm_function13[(94, 30, 51)] = 0.3021703
        pgm_function13[(94, 30, 52)] = 0.2056
        pgm_function13[(94, 30, 53)] = 0.107789094
        pgm_function13[(94, 30, 54)] = 0.03329674
        pgm_function13[(94, 31, 46)] = 0.0178
        pgm_function13[(94, 31, 47)] = 0.1267
        pgm_function13[(94, 31, 48)] = 0.26332626
        pgm_function13[(94, 31, 49)] = 0.3111
        pgm_function13[(94, 31, 50)] = 0.216678059
        pgm_function13[(94, 31, 51)] = 0.1178
        pgm_function13[(94, 31, 52)] = 0.04000403
        pgm_function13[(94, 31, 53)] = 0.001099891
        pgm_function13[(94, 32, 44)] = 0.0133013
        pgm_function13[(94, 32, 45)] = 0.1089
        pgm_function13[(94, 32, 46)] = 0.25
        pgm_function13[(94, 32, 47)] = 0.315536691
        pgm_function13[(94, 32, 48)] = 0.2278
        pgm_function13[(94, 32, 49)] = 0.1267
        pgm_function13[(94, 32, 50)] = 0.0467
        pgm_function13[(94, 32, 51)] = 0.0022
        pgm_function13[(95, 24, 60)] = 0.01
        pgm_function13[(95, 25, 58)] = 0.0056
        pgm_function13[(95, 25, 59)] = 0.074407419
        pgm_function13[(95, 25, 60)] = 0.2089
        pgm_function13[(95, 26, 56)] = 0.0022
        pgm_function13[(95, 26, 57)] = 0.0644
        pgm_function13[(95, 26, 58)] = 0.1911
        pgm_function13[(95, 26, 59)] = 0.3022
        pgm_function13[(95, 26, 60)] = 0.271073127
        pgm_function13[(95, 27, 54)] = 0.001100111
        pgm_function13[(95, 27, 55)] = 0.051105135
        pgm_function13[(95, 27, 56)] = 0.178918118
        pgm_function13[(95, 27, 57)] = 0.2911
        pgm_function13[(95, 27, 58)] = 0.2844
        pgm_function13[(95, 27, 59)] = 0.1767
        pgm_function13[(95, 27, 60)] = 0.0878
        pgm_function13[(95, 28, 53)] = 0.0389
        pgm_function13[(95, 28, 54)] = 0.1667
        pgm_function13[(95, 28, 55)] = 0.28112817
        pgm_function13[(95, 28, 56)] = 0.2978
        pgm_function13[(95, 28, 57)] = 0.18888106
        pgm_function13[(95, 28, 58)] = 0.0978
        pgm_function13[(95, 28, 59)] = 0.02779722
        pgm_function13[(95, 29, 51)] = 0.028897122
        pgm_function13[(95, 29, 52)] = 0.146685191
        pgm_function13[(95, 29, 53)] = 0.2744
        pgm_function13[(95, 29, 54)] = 0.3
        pgm_function13[(95, 29, 55)] = 0.2011202
        pgm_function13[(95, 29, 56)] = 0.10668909
        pgm_function13[(95, 29, 57)] = 0.0333
        pgm_function13[(95, 30, 49)] = 0.0211
        pgm_function13[(95, 30, 50)] = 0.12778713
        pgm_function13[(95, 30, 51)] = 0.26667327
        pgm_function13[(95, 30, 52)] = 0.3033
        pgm_function13[(95, 30, 53)] = 0.215578188
        pgm_function13[(95, 30, 54)] = 0.11668815
        pgm_function13[(95, 30, 55)] = 0.04000404
        pgm_function13[(95, 30, 56)] = 0.0011
        pgm_function13[(95, 31, 47)] = 0.0156
        pgm_function13[(95, 31, 48)] = 0.11221111
        pgm_function13[(95, 31, 49)] = 0.2533
        pgm_function13[(95, 31, 50)] = 0.309969084
        pgm_function13[(95, 31, 51)] = 0.2289
        pgm_function13[(95, 31, 52)] = 0.1244121
        pgm_function13[(95, 31, 53)] = 0.046695338
        pgm_function13[(95, 31, 54)] = 0.0022
        pgm_function13[(95, 32, 45)] = 0.01
        pgm_function13[(95, 32, 46)] = 0.1
        pgm_function13[(95, 32, 47)] = 0.235552769
        pgm_function13[(95, 32, 48)] = 0.3167
        pgm_function13[(95, 32, 49)] = 0.2433
        pgm_function13[(95, 32, 50)] = 0.1344
        pgm_function13[(95, 32, 51)] = 0.0544
        pgm_function13[(95, 32, 52)] = 0.0044
        pgm_function13[(96, 25, 59)] = 0.004400441
        pgm_function13[(96, 25, 60)] = 0.0644
        pgm_function13[(96, 26, 57)] = 0.0011
        pgm_function13[(96, 26, 58)] = 0.0533
        pgm_function13[(96, 26, 59)] = 0.1789
        pgm_function13[(96, 26, 60)] = 0.295570139
        pgm_function13[(96, 27, 56)] = 0.043304329
        pgm_function13[(96, 27, 57)] = 0.1656
        pgm_function13[(96, 27, 58)] = 0.2867
        pgm_function13[(96, 27, 59)] = 0.2911
        pgm_function13[(96, 27, 60)] = 0.1856
        pgm_function13[(96, 28, 54)] = 0.03
        pgm_function13[(96, 28, 55)] = 0.15331509
        pgm_function13[(96, 28, 56)] = 0.2733
        pgm_function13[(96, 28, 57)] = 0.29777009
        pgm_function13[(96, 28, 58)] = 0.1956
        pgm_function13[(96, 28, 59)] = 0.10668909
        pgm_function13[(96, 28, 60)] = 0.03329674
        pgm_function13[(96, 29, 52)] = 0.02329773
        pgm_function13[(96, 29, 53)] = 0.1356
        pgm_function13[(96, 29, 54)] = 0.2656
        pgm_function13[(96, 29, 55)] = 0.3022303
        pgm_function13[(96, 29, 56)] = 0.21107917
        pgm_function13[(96, 29, 57)] = 0.1167
        pgm_function13[(96, 29, 58)] = 0.04000404
        pgm_function13[(96, 29, 59)] = 0.0011
        pgm_function13[(96, 30, 50)] = 0.01779822
        pgm_function13[(96, 30, 51)] = 0.11558812
        pgm_function13[(96, 30, 52)] = 0.2567
        pgm_function13[(96, 30, 53)] = 0.305569266
        pgm_function13[(96, 30, 54)] = 0.22557729
        pgm_function13[(96, 30, 55)] = 0.12441212
        pgm_function13[(96, 30, 56)] = 0.0467
        pgm_function13[(96, 30, 57)] = 0.0022
        pgm_function13[(96, 31, 48)] = 0.01220121
        pgm_function13[(96, 31, 49)] = 0.0989
        pgm_function13[(96, 31, 50)] = 0.241076065
        pgm_function13[(96, 31, 51)] = 0.3078
        pgm_function13[(96, 31, 52)] = 0.24332419
        pgm_function13[(96, 31, 53)] = 0.132187107
        pgm_function13[(96, 31, 54)] = 0.0544
        pgm_function13[(96, 31, 55)] = 0.0044
        pgm_function13[(96, 32, 46)] = 0.0067
        pgm_function13[(96, 32, 47)] = 0.086682615
        pgm_function13[(96, 32, 48)] = 0.2222
        pgm_function13[(96, 32, 49)] = 0.3111
        pgm_function13[(96, 32, 50)] = 0.2567
        pgm_function13[(96, 32, 51)] = 0.1411
        pgm_function13[(96, 32, 52)] = 0.0611
        pgm_function13[(96, 32, 53)] = 0.0067
        pgm_function13[(97, 25, 60)] = 0.0022
        pgm_function13[(97, 26, 58)] = 0.0011
        pgm_function13[(97, 26, 59)] = 0.0456
        pgm_function13[(97, 26, 60)] = 0.167783079
        pgm_function13[(97, 27, 57)] = 0.0344
        pgm_function13[(97, 27, 58)] = 0.1522
        pgm_function13[(97, 27, 59)] = 0.28
        pgm_function13[(97, 27, 60)] = 0.2922
        pgm_function13[(97, 28, 55)] = 0.02440241
        pgm_function13[(97, 28, 56)] = 0.1389
        pgm_function13[(97, 28, 57)] = 0.26777308
        pgm_function13[(97, 28, 58)] = 0.3
        pgm_function13[(97, 28, 59)] = 0.20557916
        pgm_function13[(97, 28, 60)] = 0.11558815
        pgm_function13[(97, 29, 53)] = 0.0178
        pgm_function13[(97, 29, 54)] = 0.1222
        pgm_function13[(97, 29, 55)] = 0.25442525
        pgm_function13[(97, 29, 56)] = 0.30556924
        pgm_function13[(97, 29, 57)] = 0.22
        pgm_function13[(97, 29, 58)] = 0.12441212
        pgm_function13[(97, 29, 59)] = 0.0467
        pgm_function13[(97, 29, 60)] = 0.002200221
        pgm_function13[(97, 30, 51)] = 0.01329871
        pgm_function13[(97, 30, 52)] = 0.1044
        pgm_function13[(97, 30, 53)] = 0.242176211
        pgm_function13[(97, 30, 54)] = 0.3066694
        pgm_function13[(97, 30, 55)] = 0.23892424
        pgm_function13[(97, 30, 56)] = 0.1311
        pgm_function13[(97, 30, 57)] = 0.0533
        pgm_function13[(97, 30, 58)] = 0.004400442
        pgm_function13[(97, 31, 49)] = 0.01
        pgm_function13[(97, 31, 50)] = 0.087791224
        pgm_function13[(97, 31, 51)] = 0.2289
        pgm_function13[(97, 31, 52)] = 0.30443024
        pgm_function13[(97, 31, 53)] = 0.256674208
        pgm_function13[(97, 31, 54)] = 0.1378
        pgm_function13[(97, 31, 55)] = 0.0611
        pgm_function13[(97, 31, 56)] = 0.006699333
        pgm_function13[(97, 32, 47)] = 0.005598875
        pgm_function13[(97, 32, 48)] = 0.0756
        pgm_function13[(97, 32, 49)] = 0.2111
        pgm_function13[(97, 32, 50)] = 0.3044
        pgm_function13[(97, 32, 51)] = 0.2667
        pgm_function13[(97, 32, 52)] = 0.1511
        pgm_function13[(97, 32, 53)] = 0.0678
        pgm_function13[(97, 32, 54)] = 0.01
        pgm_function13[(98, 26, 60)] = 0.036696317
        pgm_function13[(98, 27, 58)] = 0.0278
        pgm_function13[(98, 27, 59)] = 0.1389
        pgm_function13[(98, 27, 60)] = 0.2722
        pgm_function13[(98, 28, 56)] = 0.02
        pgm_function13[(98, 28, 57)] = 0.12328804
        pgm_function13[(98, 28, 58)] = 0.2622
        pgm_function13[(98, 28, 59)] = 0.30327024
        pgm_function13[(98, 28, 60)] = 0.21557828
        pgm_function13[(98, 29, 54)] = 0.0133
        pgm_function13[(98, 29, 55)] = 0.11221111
        pgm_function13[(98, 29, 56)] = 0.24217619
        pgm_function13[(98, 29, 57)] = 0.3056
        pgm_function13[(98, 29, 58)] = 0.23222323
        pgm_function13[(98, 29, 59)] = 0.1311
        pgm_function13[(98, 29, 60)] = 0.053305326
        pgm_function13[(98, 30, 52)] = 0.01
        pgm_function13[(98, 30, 53)] = 0.094390682
        pgm_function13[(98, 30, 54)] = 0.2277773
        pgm_function13[(98, 30, 55)] = 0.3044303
        pgm_function13[(98, 30, 56)] = 0.25
        pgm_function13[(98, 30, 57)] = 0.1389
        pgm_function13[(98, 30, 58)] = 0.061106128
        pgm_function13[(98, 30, 59)] = 0.0067
        pgm_function13[(98, 31, 50)] = 0.006699332
        pgm_function13[(98, 31, 51)] = 0.0789
        pgm_function13[(98, 31, 52)] = 0.21562217
        pgm_function13[(98, 31, 53)] = 0.297770241
        pgm_function13[(98, 31, 54)] = 0.2667
        pgm_function13[(98, 31, 55)] = 0.1478
        pgm_function13[(98, 31, 56)] = 0.067793232
        pgm_function13[(98, 31, 57)] = 0.01
        pgm_function13[(98, 32, 48)] = 0.0044
        pgm_function13[(98, 32, 49)] = 0.0656
        pgm_function13[(98, 32, 50)] = 0.2
        pgm_function13[(98, 32, 51)] = 0.2989
        pgm_function13[(98, 32, 52)] = 0.2756
        pgm_function13[(98, 32, 53)] = 0.1622
        pgm_function13[(98, 32, 54)] = 0.0767
        pgm_function13[(98, 32, 55)] = 0.0133
        pgm_function13[(99, 27, 59)] = 0.0222
        pgm_function13[(99, 27, 60)] = 0.1444
        pgm_function13[(99, 28, 57)] = 0.01669831
        pgm_function13[(99, 28, 58)] = 0.1222
        pgm_function13[(99, 28, 59)] = 0.35666429
        pgm_function13[(99, 28, 60)] = 0.63553683
        pgm_function13[(99, 29, 55)] = 0.01000101
        pgm_function13[(99, 29, 56)] = 0.10668909
        pgm_function13[(99, 29, 57)] = 0.3244
        pgm_function13[(99, 29, 58)] = 0.6033606
        pgm_function13[(99, 29, 59)] = 0.8211
        pgm_function13[(99, 29, 60)] = 0.944494453
        pgm_function13[(99, 30, 53)] = 0.006699336
        pgm_function13[(99, 30, 54)] = 0.08999112
        pgm_function13[(99, 30, 55)] = 0.29222929
        pgm_function13[(99, 30, 56)] = 0.5711
        pgm_function13[(99, 30, 57)] = 0.8056
        pgm_function13[(99, 30, 58)] = 0.93449343
        pgm_function13[(99, 30, 59)] = 0.9933
        pgm_function13[(99, 30, 60)] = 1.0
        pgm_function13[(99, 31, 51)] = 0.0044
        pgm_function13[(99, 31, 52)] = 0.07220726
        pgm_function13[(99, 31, 53)] = 0.265573215
        pgm_function13[(99, 31, 54)] = 0.5389
        pgm_function13[(99, 31, 55)] = 0.7867
        pgm_function13[(99, 31, 56)] = 0.925507435
        pgm_function13[(99, 31, 57)] = 0.99
        pgm_function13[(99, 31, 58)] = 1.0
        pgm_function13[(99, 31, 59)] = 1.0
        pgm_function13[(99, 31, 60)] = 1.0
        pgm_function13[(99, 32, 49)] = 0.0022
        pgm_function13[(99, 32, 50)] = 0.0567
        pgm_function13[(99, 32, 51)] = 0.2367
        pgm_function13[(99, 32, 52)] = 0.5078
        pgm_function13[(99, 32, 53)] = 0.7633
        pgm_function13[(99, 32, 54)] = 0.9133
        pgm_function13[(99, 32, 55)] = 0.9867
        pgm_function13[(99, 32, 56)] = 1.0
        pgm_function13[(99, 32, 57)] = 1.0
        pgm_function13[(99, 32, 58)] = 1.0
        pgm_function13[(99, 32, 59)] = 1.0
        pgm_function13[(99, 32, 60)] = 1.0

        pgm_function14 = pgm_factor14.set_sparse()
        pgm_function14[(0, 0, 0, 0)] = 0.5
        pgm_function14[(0, 0, 0, 1)] = 0.49995005
        pgm_function14[(0, 0, 0, 2)] = 0.50005004
        pgm_function14[(0, 0, 0, 3)] = 0.49995002
        pgm_function14[(0, 0, 1, 0)] = 0.5000497
        pgm_function14[(0, 0, 1, 1)] = 0.500050165
        pgm_function14[(0, 0, 1, 2)] = 0.5
        pgm_function14[(0, 0, 1, 3)] = 0.49995005
        pgm_function14[(0, 0, 2, 0)] = 0.500050085
        pgm_function14[(0, 0, 2, 1)] = 0.5
        pgm_function14[(0, 0, 2, 2)] = 0.5
        pgm_function14[(0, 0, 2, 3)] = 0.5
        pgm_function14[(0, 0, 3, 0)] = 0.5
        pgm_function14[(0, 0, 3, 1)] = 0.5
        pgm_function14[(0, 0, 3, 2)] = 0.50005005
        pgm_function14[(0, 0, 3, 3)] = 0.5
        pgm_function14[(1, 0, 0, 0)] = 0.1
        pgm_function14[(1, 0, 0, 1)] = 0.09999001
        pgm_function14[(1, 0, 0, 2)] = 0.10001001
        pgm_function14[(1, 0, 0, 3)] = 0.09999
        pgm_function14[(1, 0, 1, 0)] = 0.10000994
        pgm_function14[(1, 0, 1, 1)] = 0.100010033
        pgm_function14[(1, 0, 1, 2)] = 0.1
        pgm_function14[(1, 0, 1, 3)] = 0.09999001
        pgm_function14[(1, 0, 2, 0)] = 0.100010017
        pgm_function14[(1, 0, 2, 1)] = 0.1
        pgm_function14[(1, 0, 2, 2)] = 0.1
        pgm_function14[(1, 0, 2, 3)] = 0.1
        pgm_function14[(1, 0, 3, 0)] = 0.1
        pgm_function14[(1, 0, 3, 1)] = 0.1
        pgm_function14[(1, 0, 3, 2)] = 0.10001001
        pgm_function14[(1, 0, 3, 3)] = 0.1
        pgm_function14[(2, 0, 0, 0)] = 0.1
        pgm_function14[(2, 0, 0, 1)] = 0.08199181
        pgm_function14[(2, 0, 0, 2)] = 0.0377038
        pgm_function14[(2, 0, 0, 3)] = 0.00069993
        pgm_function14[(2, 0, 1, 0)] = 0.10100994
        pgm_function14[(2, 0, 1, 1)] = 0.085308528
        pgm_function14[(2, 0, 1, 2)] = 0.0423
        pgm_function14[(2, 0, 1, 3)] = 0.0049995
        pgm_function14[(2, 0, 2, 0)] = 0.104310018
        pgm_function14[(2, 0, 2, 1)] = 0.089
        pgm_function14[(2, 0, 2, 2)] = 0.047
        pgm_function14[(2, 0, 2, 3)] = 0.0107
        pgm_function14[(2, 0, 3, 0)] = 0.1077
        pgm_function14[(2, 0, 3, 1)] = 0.0927
        pgm_function14[(2, 0, 3, 2)] = 0.05130511
        pgm_function14[(2, 0, 3, 3)] = 0.0163
        pgm_function14[(3, 0, 0, 0)] = 0.0977
        pgm_function14[(3, 0, 0, 1)] = 0.06269371
        pgm_function14[(3, 0, 0, 2)] = 0.0653065
        pgm_function14[(3, 0, 0, 3)] = 0.0992901
        pgm_function14[(3, 0, 1, 0)] = 0.10531094
        pgm_function14[(3, 0, 1, 1)] = 0.064006421
        pgm_function14[(3, 0, 1, 2)] = 0.0673
        pgm_function14[(3, 0, 1, 3)] = 0.09499051
        pgm_function14[(3, 0, 2, 0)] = 0.111311019
        pgm_function14[(3, 0, 2, 1)] = 0.066
        pgm_function14[(3, 0, 2, 2)] = 0.07
        pgm_function14[(3, 0, 2, 3)] = 0.0893
        pgm_function14[(3, 0, 3, 0)] = 0.1147
        pgm_function14[(3, 0, 3, 1)] = 0.072
        pgm_function14[(3, 0, 3, 2)] = 0.07300731
        pgm_function14[(3, 0, 3, 3)] = 0.0837
        pgm_function14[(4, 0, 0, 0)] = 0.1023
        pgm_function14[(4, 0, 0, 1)] = 0.08869111
        pgm_function14[(4, 0, 0, 2)] = 0.08030801
        pgm_function14[(4, 0, 0, 3)] = 0.0446955
        pgm_function14[(4, 0, 1, 0)] = 0.10701094
        pgm_function14[(4, 0, 1, 1)] = 0.094309431
        pgm_function14[(4, 0, 1, 2)] = 0.0853
        pgm_function14[(4, 0, 1, 3)] = 0.05369461
        pgm_function14[(4, 0, 2, 0)] = 0.11601202
        pgm_function14[(4, 0, 2, 1)] = 0.096
        pgm_function14[(4, 0, 2, 2)] = 0.095
        pgm_function14[(4, 0, 2, 3)] = 0.0643
        pgm_function14[(4, 0, 3, 0)] = 0.1233
        pgm_function14[(4, 0, 3, 1)] = 0.099
        pgm_function14[(4, 0, 3, 2)] = 0.09900991
        pgm_function14[(4, 0, 3, 3)] = 0.074
        pgm_function14[(4, 1, 3, 0)] = 0.004699531
        pgm_function14[(5, 0, 0, 0)] = 0.083
        pgm_function14[(5, 0, 0, 1)] = 0.09669031
        pgm_function14[(5, 0, 0, 2)] = 0.07230721
        pgm_function14[(5, 0, 0, 3)] = 0.0769923
        pgm_function14[(5, 0, 1, 0)] = 0.07630755
        pgm_function14[(5, 0, 1, 1)] = 0.102310034
        pgm_function14[(5, 0, 1, 2)] = 0.0817
        pgm_function14[(5, 0, 1, 3)] = 0.07969201
        pgm_function14[(5, 0, 2, 0)] = 0.065006511
        pgm_function14[(5, 0, 2, 1)] = 0.1033
        pgm_function14[(5, 0, 2, 2)] = 0.0863
        pgm_function14[(5, 0, 2, 3)] = 0.0797
        pgm_function14[(5, 0, 3, 0)] = 0.0543
        pgm_function14[(5, 0, 3, 1)] = 0.104
        pgm_function14[(5, 0, 3, 2)] = 0.09730971
        pgm_function14[(5, 0, 3, 3)] = 0.083
        pgm_function14[(5, 1, 0, 0)] = 0.03270334
        pgm_function14[(5, 1, 1, 0)] = 0.0527
        pgm_function14[(5, 1, 1, 1)] = 0.001999798
        pgm_function14[(5, 1, 2, 0)] = 0.068
        pgm_function14[(5, 1, 2, 1)] = 0.0110011
        pgm_function14[(5, 1, 3, 0)] = 0.087691224
        pgm_function14[(5, 1, 3, 1)] = 0.021
        pgm_function14[(6, 0, 0, 0)] = 0.017
        pgm_function14[(6, 0, 0, 1)] = 0.05799421
        pgm_function14[(6, 0, 0, 2)] = 0.09170921
        pgm_function14[(6, 0, 0, 3)] = 0.0686931
        pgm_function14[(6, 0, 1, 0)] = 0.01030099
        pgm_function14[(6, 0, 1, 1)] = 0.051305117
        pgm_function14[(6, 0, 1, 2)] = 0.0827
        pgm_function14[(6, 0, 1, 3)] = 0.08469151
        pgm_function14[(6, 0, 2, 0)] = 0.003300331
        pgm_function14[(6, 0, 2, 1)] = 0.0457
        pgm_function14[(6, 0, 2, 2)] = 0.0767
        pgm_function14[(6, 0, 2, 3)] = 0.095
        pgm_function14[(6, 0, 3, 1)] = 0.0323
        pgm_function14[(6, 0, 3, 2)] = 0.06530651
        pgm_function14[(6, 0, 3, 3)] = 0.0963
        pgm_function14[(6, 1, 0, 0)] = 0.11401114
        pgm_function14[(6, 1, 0, 1)] = 0.043704381
        pgm_function14[(6, 1, 0, 2)] = 0.0023
        pgm_function14[(6, 1, 1, 0)] = 0.1277
        pgm_function14[(6, 1, 1, 1)] = 0.062693637
        pgm_function14[(6, 1, 1, 2)] = 0.014
        pgm_function14[(6, 1, 2, 0)] = 0.1593
        pgm_function14[(6, 1, 2, 1)] = 0.0813081
        pgm_function14[(6, 1, 2, 2)] = 0.027697177
        pgm_function14[(6, 1, 3, 0)] = 0.171983046
        pgm_function14[(6, 1, 3, 1)] = 0.1093
        pgm_function14[(6, 1, 3, 2)] = 0.045295474
        pgm_function14[(6, 1, 3, 3)] = 0.01
        pgm_function14[(7, 0, 0, 1)] = 0.0119988
        pgm_function14[(7, 0, 0, 2)] = 0.0473047
        pgm_function14[(7, 0, 0, 3)] = 0.0689931
        pgm_function14[(7, 0, 1, 1)] = 0.002700271
        pgm_function14[(7, 0, 1, 2)] = 0.0407
        pgm_function14[(7, 0, 1, 3)] = 0.05699431
        pgm_function14[(7, 0, 2, 2)] = 0.025
        pgm_function14[(7, 0, 2, 3)] = 0.051
        pgm_function14[(7, 0, 3, 2)] = 0.0140014
        pgm_function14[(7, 0, 3, 3)] = 0.0467
        pgm_function14[(7, 1, 0, 0)] = 0.14431417
        pgm_function14[(7, 1, 0, 1)] = 0.102709956
        pgm_function14[(7, 1, 0, 2)] = 0.051
        pgm_function14[(7, 1, 0, 3)] = 0.0117
        pgm_function14[(7, 1, 1, 0)] = 0.169
        pgm_function14[(7, 1, 1, 1)] = 0.124687875
        pgm_function14[(7, 1, 1, 2)] = 0.069
        pgm_function14[(7, 1, 1, 3)] = 0.0287
        pgm_function14[(7, 1, 2, 0)] = 0.1763
        pgm_function14[(7, 1, 2, 1)] = 0.146715
        pgm_function14[(7, 1, 2, 2)] = 0.0942905217
        pgm_function14[(7, 1, 2, 3)] = 0.0483
        pgm_function14[(7, 1, 3, 0)] = 0.205679056
        pgm_function14[(7, 1, 3, 1)] = 0.1567
        pgm_function14[(7, 1, 3, 2)] = 0.121687931
        pgm_function14[(7, 1, 3, 3)] = 0.0737
        pgm_function14[(8, 0, 0, 2)] = 0.00530053
        pgm_function14[(8, 0, 0, 3)] = 0.039996
        pgm_function14[(8, 0, 1, 3)] = 0.0249975
        pgm_function14[(8, 0, 2, 3)] = 0.01
        pgm_function14[(8, 1, 0, 0)] = 0.1693172
        pgm_function14[(8, 1, 0, 1)] = 0.127012945
        pgm_function14[(8, 1, 0, 2)] = 0.0977
        pgm_function14[(8, 1, 0, 3)] = 0.0547
        pgm_function14[(8, 1, 1, 0)] = 0.1843
        pgm_function14[(8, 1, 1, 1)] = 0.148684851
        pgm_function14[(8, 1, 1, 2)] = 0.1217
        pgm_function14[(8, 1, 1, 3)] = 0.0753
        pgm_function14[(8, 1, 2, 0)] = 0.2127
        pgm_function14[(8, 1, 2, 1)] = 0.161016
        pgm_function14[(8, 1, 2, 2)] = 0.1346868882
        pgm_function14[(8, 1, 2, 3)] = 0.1047
        pgm_function14[(8, 1, 3, 0)] = 0.229277062
        pgm_function14[(8, 1, 3, 1)] = 0.1883
        pgm_function14[(8, 1, 3, 2)] = 0.152684913
        pgm_function14[(8, 1, 3, 3)] = 0.126
        pgm_function14[(8, 2, 3, 0)] = 0.007
        pgm_function14[(9, 0, 0, 3)] = 0.00069993
        pgm_function14[(9, 1, 0, 0)] = 0.18801923
        pgm_function14[(9, 1, 0, 1)] = 0.145314938
        pgm_function14[(9, 1, 0, 2)] = 0.1157
        pgm_function14[(9, 1, 0, 3)] = 0.0943
        pgm_function14[(9, 1, 1, 0)] = 0.204
        pgm_function14[(9, 1, 1, 1)] = 0.162283838
        pgm_function14[(9, 1, 1, 2)] = 0.1327
        pgm_function14[(9, 1, 1, 3)] = 0.1143
        pgm_function14[(9, 1, 2, 0)] = 0.2017
        pgm_function14[(9, 1, 2, 1)] = 0.191319
        pgm_function14[(9, 1, 2, 2)] = 0.1539848722
        pgm_function14[(9, 1, 2, 3)] = 0.131
        pgm_function14[(9, 1, 3, 0)] = 0.181282049
        pgm_function14[(9, 1, 3, 1)] = 0.2097
        pgm_function14[(9, 1, 3, 2)] = 0.173682901
        pgm_function14[(9, 1, 3, 3)] = 0.146
        pgm_function14[(9, 2, 0, 0)] = 0.0009998995
        pgm_function14[(9, 2, 1, 0)] = 0.015001523
        pgm_function14[(9, 2, 2, 0)] = 0.04730472
        pgm_function14[(9, 2, 3, 0)] = 0.099
        pgm_function14[(9, 2, 3, 1)] = 0.0027
        pgm_function14[(10, 1, 0, 0)] = 0.17231721
        pgm_function14[(10, 1, 0, 1)] = 0.16231593
        pgm_function14[(10, 1, 0, 2)] = 0.1297
        pgm_function14[(10, 1, 0, 3)] = 0.1063
        pgm_function14[(10, 1, 1, 0)] = 0.1533
        pgm_function14[(10, 1, 1, 1)] = 0.184681815
        pgm_function14[(10, 1, 1, 2)] = 0.1497
        pgm_function14[(10, 1, 1, 3)] = 0.126
        pgm_function14[(10, 1, 2, 0)] = 0.127
        pgm_function14[(10, 1, 2, 1)] = 0.189319
        pgm_function14[(10, 1, 2, 2)] = 0.1729828564
        pgm_function14[(10, 1, 2, 3)] = 0.1447
        pgm_function14[(10, 1, 3, 0)] = 0.097690226
        pgm_function14[(10, 1, 3, 1)] = 0.1723
        pgm_function14[(10, 1, 3, 2)] = 0.195679888
        pgm_function14[(10, 1, 3, 3)] = 0.1663
        pgm_function14[(10, 2, 0, 0)] = 0.0449954775
        pgm_function14[(10, 2, 1, 0)] = 0.100710151
        pgm_function14[(10, 2, 1, 1)] = 0.003
        pgm_function14[(10, 2, 2, 0)] = 0.16631707
        pgm_function14[(10, 2, 2, 1)] = 0.0267
        pgm_function14[(10, 2, 3, 0)] = 0.2373
        pgm_function14[(10, 2, 3, 1)] = 0.075
        pgm_function14[(10, 2, 3, 2)] = 0.002300463
        pgm_function14[(10, 3, 3, 0)] = 0.002999699
        pgm_function14[(11, 1, 0, 0)] = 0.11431114
        pgm_function14[(11, 1, 0, 1)] = 0.168316928
        pgm_function14[(11, 1, 0, 2)] = 0.1433
        pgm_function14[(11, 1, 0, 3)] = 0.1187
        pgm_function14[(11, 1, 1, 0)] = 0.0847
        pgm_function14[(11, 1, 1, 1)] = 0.156683843
        pgm_function14[(11, 1, 1, 2)] = 0.1667
        pgm_function14[(11, 1, 1, 3)] = 0.1397
        pgm_function14[(11, 1, 2, 0)] = 0.0507
        pgm_function14[(11, 1, 2, 1)] = 0.131313
        pgm_function14[(11, 1, 2, 2)] = 0.1786818517
        pgm_function14[(11, 1, 2, 3)] = 0.1633
        pgm_function14[(11, 1, 3, 0)] = 0.021697806
        pgm_function14[(11, 1, 3, 1)] = 0.105
        pgm_function14[(11, 1, 3, 2)] = 0.15798391
        pgm_function14[(11, 1, 3, 3)] = 0.183
        pgm_function14[(11, 2, 0, 0)] = 0.1406859297
        pgm_function14[(11, 2, 0, 1)] = 0.0153015
        pgm_function14[(11, 2, 1, 0)] = 0.21332132
        pgm_function14[(11, 2, 1, 1)] = 0.0583
        pgm_function14[(11, 2, 1, 2)] = 0.0003000299
        pgm_function14[(11, 2, 2, 0)] = 0.27232711
        pgm_function14[(11, 2, 2, 1)] = 0.1187
        pgm_function14[(11, 2, 2, 2)] = 0.018
        pgm_function14[(11, 2, 3, 0)] = 0.29
        pgm_function14[(11, 2, 3, 1)] = 0.182
        pgm_function14[(11, 2, 3, 2)] = 0.066313378
        pgm_function14[(11, 2, 3, 3)] = 0.003300328
        pgm_function14[(11, 3, 1, 0)] = 0.0030003
        pgm_function14[(11, 3, 2, 0)] = 0.03300332
        pgm_function14[(11, 3, 3, 0)] = 0.101689969
        pgm_function14[(12, 1, 0, 0)] = 0.05400546
        pgm_function14[(12, 1, 0, 1)] = 0.129712944
        pgm_function14[(12, 1, 0, 2)] = 0.157
        pgm_function14[(12, 1, 0, 3)] = 0.131
        pgm_function14[(12, 1, 1, 0)] = 0.024
        pgm_function14[(12, 1, 1, 1)] = 0.102989897
        pgm_function14[(12, 1, 1, 2)] = 0.1523
        pgm_function14[(12, 1, 1, 3)] = 0.154
        pgm_function14[(12, 1, 2, 0)] = 0.0043
        pgm_function14[(12, 1, 2, 1)] = 0.0717072
        pgm_function14[(12, 1, 2, 2)] = 0.1279868938
        pgm_function14[(12, 1, 2, 3)] = 0.165
        pgm_function14[(12, 1, 3, 1)] = 0.037
        pgm_function14[(12, 1, 3, 2)] = 0.103689941
        pgm_function14[(12, 1, 3, 3)] = 0.1437
        pgm_function14[(12, 2, 0, 0)] = 0.2306768847
        pgm_function14[(12, 2, 0, 1)] = 0.0793079
        pgm_function14[(12, 2, 0, 2)] = 0.00330033
        pgm_function14[(12, 2, 1, 0)] = 0.263026395
        pgm_function14[(12, 2, 1, 1)] = 0.146
        pgm_function14[(12, 2, 1, 2)] = 0.0380037886
        pgm_function14[(12, 2, 2, 0)] = 0.2527251
        pgm_function14[(12, 2, 2, 1)] = 0.2177
        pgm_function14[(12, 2, 2, 2)] = 0.0943
        pgm_function14[(12, 2, 2, 3)] = 0.0152985
        pgm_function14[(12, 2, 3, 0)] = 0.2173
        pgm_function14[(12, 2, 3, 1)] = 0.2663
        pgm_function14[(12, 2, 3, 2)] = 0.15233018
        pgm_function14[(12, 2, 3, 3)] = 0.066306558
        pgm_function14[(12, 3, 0, 0)] = 0.01769821
        pgm_function14[(12, 3, 1, 0)] = 0.08200821
        pgm_function14[(12, 3, 2, 0)] = 0.1743171
        pgm_function14[(12, 3, 2, 1)] = 0.003000299
        pgm_function14[(12, 3, 3, 0)] = 0.237675929
        pgm_function14[(12, 3, 3, 1)] = 0.037
        pgm_function14[(12, 4, 2, 0)] = 0.0120012056
        pgm_function14[(12, 4, 3, 0)] = 0.07229279
        pgm_function14[(12, 5, 3, 0)] = 0.0007000705
        pgm_function14[(13, 1, 0, 0)] = 0.01100111
        pgm_function14[(13, 1, 0, 1)] = 0.081308065
        pgm_function14[(13, 1, 0, 2)] = 0.1313
        pgm_function14[(13, 1, 0, 3)] = 0.144
        pgm_function14[(13, 1, 1, 0)] = 0.0003
        pgm_function14[(13, 1, 1, 1)] = 0.048295152
        pgm_function14[(13, 1, 1, 2)] = 0.1073
        pgm_function14[(13, 1, 1, 3)] = 0.1463
        pgm_function14[(13, 1, 2, 1)] = 0.0163016
        pgm_function14[(13, 1, 2, 2)] = 0.0799919336
        pgm_function14[(13, 1, 2, 3)] = 0.1217
        pgm_function14[(13, 1, 3, 1)] = 0.0007
        pgm_function14[(13, 1, 3, 2)] = 0.045995374
        pgm_function14[(13, 1, 3, 3)] = 0.097
        pgm_function14[(13, 2, 0, 0)] = 0.241975879
        pgm_function14[(13, 2, 0, 1)] = 0.156316
        pgm_function14[(13, 2, 0, 2)] = 0.047304707
        pgm_function14[(13, 2, 0, 3)] = 0.0007
        pgm_function14[(13, 2, 1, 0)] = 0.21332132
        pgm_function14[(13, 2, 1, 1)] = 0.2287
        pgm_function14[(13, 2, 1, 2)] = 0.1063109681
        pgm_function14[(13, 2, 1, 3)] = 0.0267
        pgm_function14[(13, 2, 2, 0)] = 0.17231707
        pgm_function14[(13, 2, 2, 1)] = 0.2493
        pgm_function14[(13, 2, 2, 2)] = 0.174
        pgm_function14[(13, 2, 2, 3)] = 0.08229182
        pgm_function14[(13, 2, 3, 0)] = 0.1177
        pgm_function14[(13, 2, 3, 1)] = 0.229
        pgm_function14[(13, 2, 3, 2)] = 0.236047279
        pgm_function14[(13, 2, 3, 3)] = 0.135313915
        pgm_function14[(13, 3, 0, 0)] = 0.11798809
        pgm_function14[(13, 3, 1, 0)] = 0.20602102
        pgm_function14[(13, 3, 1, 1)] = 0.0153015
        pgm_function14[(13, 3, 2, 0)] = 0.24132414
        pgm_function14[(13, 3, 2, 1)] = 0.082008167
        pgm_function14[(13, 3, 3, 0)] = 0.256973923
        pgm_function14[(13, 3, 3, 1)] = 0.1713
        pgm_function14[(13, 3, 3, 2)] = 0.01100111
        pgm_function14[(13, 4, 0, 0)] = 0.0030003
        pgm_function14[(13, 4, 1, 0)] = 0.0537
        pgm_function14[(13, 4, 2, 0)] = 0.1440140677
        pgm_function14[(13, 4, 3, 0)] = 0.20867897
        pgm_function14[(13, 4, 3, 1)] = 0.004
        pgm_function14[(13, 5, 1, 0)] = 0.00030003
        pgm_function14[(13, 5, 2, 0)] = 0.0343
        pgm_function14[(13, 5, 3, 0)] = 0.1173120821
        pgm_function14[(13, 6, 2, 0)] = 0.00030003
        pgm_function14[(13, 6, 3, 0)] = 0.03669629
        pgm_function14[(14, 1, 0, 1)] = 0.035303485
        pgm_function14[(14, 1, 0, 2)] = 0.095
        pgm_function14[(14, 1, 0, 3)] = 0.13
        pgm_function14[(14, 1, 1, 1)] = 0.006999293
        pgm_function14[(14, 1, 1, 2)] = 0.0653
        pgm_function14[(14, 1, 1, 3)] = 0.107
        pgm_function14[(14, 1, 2, 2)] = 0.0289970759
        pgm_function14[(14, 1, 2, 3)] = 0.081
        pgm_function14[(14, 1, 3, 2)] = 0.003299668
        pgm_function14[(14, 1, 3, 3)] = 0.0493
        pgm_function14[(14, 2, 0, 0)] = 0.1822819089
        pgm_function14[(14, 2, 0, 1)] = 0.21802201
        pgm_function14[(14, 2, 0, 2)] = 0.107311015
        pgm_function14[(14, 2, 0, 3)] = 0.0283
        pgm_function14[(14, 2, 1, 0)] = 0.134313201
        pgm_function14[(14, 2, 1, 1)] = 0.2277
        pgm_function14[(14, 2, 1, 2)] = 0.1817179455
        pgm_function14[(14, 2, 1, 3)] = 0.0843
        pgm_function14[(14, 2, 2, 0)] = 0.07630763
        pgm_function14[(14, 2, 2, 1)] = 0.1973
        pgm_function14[(14, 2, 2, 2)] = 0.2327
        pgm_function14[(14, 2, 2, 3)] = 0.14768504
        pgm_function14[(14, 2, 3, 0)] = 0.0317
        pgm_function14[(14, 2, 3, 1)] = 0.159
        pgm_function14[(14, 2, 3, 2)] = 0.227045268
        pgm_function14[(14, 2, 3, 3)] = 0.211020867
        pgm_function14[(14, 3, 0, 0)] = 0.20567916
        pgm_function14[(14, 3, 0, 1)] = 0.0253
        pgm_function14[(14, 3, 1, 0)] = 0.23332302
        pgm_function14[(14, 3, 1, 1)] = 0.11271101
        pgm_function14[(14, 3, 1, 2)] = 0.0007
        pgm_function14[(14, 3, 2, 0)] = 0.23902414
        pgm_function14[(14, 3, 2, 1)] = 0.197019921
        pgm_function14[(14, 3, 2, 2)] = 0.03169368
        pgm_function14[(14, 3, 3, 0)] = 0.23367693
        pgm_function14[(14, 3, 3, 1)] = 0.226
        pgm_function14[(14, 3, 3, 2)] = 0.11131108
        pgm_function14[(14, 3, 3, 3)] = 0.003
        pgm_function14[(14, 4, 0, 0)] = 0.0920092
        pgm_function14[(14, 4, 1, 0)] = 0.1703
        pgm_function14[(14, 4, 1, 1)] = 0.0002999699
        pgm_function14[(14, 4, 2, 0)] = 0.2293231078
        pgm_function14[(14, 4, 2, 1)] = 0.028697088
        pgm_function14[(14, 4, 3, 0)] = 0.23167697
        pgm_function14[(14, 4, 3, 1)] = 0.122
        pgm_function14[(14, 5, 0, 0)] = 0.009698062
        pgm_function14[(14, 5, 1, 0)] = 0.0923092
        pgm_function14[(14, 5, 2, 0)] = 0.161
        pgm_function14[(14, 5, 3, 0)] = 0.21432115
        pgm_function14[(14, 5, 3, 1)] = 0.00529947
        pgm_function14[(14, 6, 1, 0)] = 0.025697384
        pgm_function14[(14, 6, 2, 0)] = 0.112011
        pgm_function14[(14, 6, 3, 0)] = 0.16428395
        pgm_function14[(15, 1, 0, 1)] = 0.004300428
        pgm_function14[(15, 1, 0, 2)] = 0.0567
        pgm_function14[(15, 1, 0, 3)] = 0.098
        pgm_function14[(15, 1, 1, 2)] = 0.021
        pgm_function14[(15, 1, 1, 3)] = 0.0717
        pgm_function14[(15, 1, 2, 2)] = 0.0006999294
        pgm_function14[(15, 1, 2, 3)] = 0.037
        pgm_function14[(15, 1, 3, 3)] = 0.005
        pgm_function14[(15, 2, 0, 0)] = 0.1096889452
        pgm_function14[(15, 2, 0, 1)] = 0.20932101
        pgm_function14[(15, 2, 0, 2)] = 0.172017024
        pgm_function14[(15, 2, 0, 3)] = 0.0787
        pgm_function14[(15, 2, 1, 0)] = 0.054305481
        pgm_function14[(15, 2, 1, 1)] = 0.1723
        pgm_function14[(15, 2, 1, 2)] = 0.2183219345
        pgm_function14[(15, 2, 1, 3)] = 0.1467
        pgm_function14[(15, 2, 2, 0)] = 0.01270131
        pgm_function14[(15, 2, 2, 1)] = 0.13
        pgm_function14[(15, 2, 2, 2)] = 0.2037
        pgm_function14[(15, 2, 2, 3)] = 0.20867906
        pgm_function14[(15, 2, 3, 1)] = 0.0747
        pgm_function14[(15, 2, 3, 2)] = 0.171334202
        pgm_function14[(15, 2, 3, 3)] = 0.217021863
        pgm_function14[(15, 3, 0, 0)] = 0.22367818
        pgm_function14[(15, 3, 0, 1)] = 0.1213
        pgm_function14[(15, 3, 0, 2)] = 0.001299868
        pgm_function14[(15, 3, 1, 0)] = 0.22132202
        pgm_function14[(15, 3, 1, 1)] = 0.19802002
        pgm_function14[(15, 3, 1, 2)] = 0.0447
        pgm_function14[(15, 3, 2, 0)] = 0.20132012
        pgm_function14[(15, 3, 2, 1)] = 0.218021913
        pgm_function14[(15, 3, 2, 2)] = 0.13867193
        pgm_function14[(15, 3, 2, 3)] = 0.01
        pgm_function14[(15, 3, 3, 0)] = 0.13268696
        pgm_function14[(15, 3, 3, 1)] = 0.2233
        pgm_function14[(15, 3, 3, 2)] = 0.20332014
        pgm_function14[(15, 3, 3, 3)] = 0.076
        pgm_function14[(15, 4, 0, 0)] = 0.17471699
        pgm_function14[(15, 4, 0, 1)] = 0.002000201
        pgm_function14[(15, 4, 1, 0)] = 0.2257
        pgm_function14[(15, 4, 1, 1)] = 0.0589940858
        pgm_function14[(15, 4, 2, 0)] = 0.2097210986
        pgm_function14[(15, 4, 2, 1)] = 0.16328393
        pgm_function14[(15, 4, 2, 2)] = 0.0007000699
        pgm_function14[(15, 4, 3, 0)] = 0.24067597
        pgm_function14[(15, 4, 3, 1)] = 0.2073
        pgm_function14[(15, 4, 3, 2)] = 0.031696785
        pgm_function14[(15, 5, 0, 0)] = 0.118676028
        pgm_function14[(15, 5, 1, 0)] = 0.17231699
        pgm_function14[(15, 5, 1, 1)] = 0.0003000298
        pgm_function14[(15, 5, 2, 0)] = 0.2333
        pgm_function14[(15, 5, 2, 1)] = 0.0387
        pgm_function14[(15, 5, 3, 0)] = 0.2033201423
        pgm_function14[(15, 5, 3, 1)] = 0.13868599
        pgm_function14[(15, 6, 0, 0)] = 0.062306217
        pgm_function14[(15, 6, 1, 0)] = 0.14268591
        pgm_function14[(15, 6, 2, 0)] = 0.18801901
        pgm_function14[(15, 6, 2, 1)] = 0.0003000302
        pgm_function14[(15, 6, 3, 0)] = 0.23897593
        pgm_function14[(15, 6, 3, 1)] = 0.0392960737
        pgm_function14[(16, 1, 0, 2)] = 0.0193
        pgm_function14[(16, 1, 0, 3)] = 0.0687
        pgm_function14[(16, 1, 1, 2)] = 0.0003
        pgm_function14[(16, 1, 1, 3)] = 0.0333
        pgm_function14[(16, 1, 2, 3)] = 0.0033
        pgm_function14[(16, 2, 0, 0)] = 0.0436955782
        pgm_function14[(16, 2, 0, 1)] = 0.161716
        pgm_function14[(16, 2, 0, 2)] = 0.204020029
        pgm_function14[(16, 2, 0, 3)] = 0.1297
        pgm_function14[(16, 2, 1, 0)] = 0.006000609
        pgm_function14[(16, 2, 1, 1)] = 0.113
        pgm_function14[(16, 2, 1, 2)] = 0.1870189439
        pgm_function14[(16, 2, 1, 3)] = 0.1993
        pgm_function14[(16, 2, 2, 1)] = 0.055
        pgm_function14[(16, 2, 2, 2)] = 0.152
        pgm_function14[(16, 2, 2, 3)] = 0.20068006
        pgm_function14[(16, 2, 3, 1)] = 0.0113
        pgm_function14[(16, 2, 3, 2)] = 0.104321123
        pgm_function14[(16, 2, 3, 3)] = 0.17401689
        pgm_function14[(16, 3, 0, 0)] = 0.20567916
        pgm_function14[(16, 3, 0, 1)] = 0.1873
        pgm_function14[(16, 3, 0, 2)] = 0.04369554
        pgm_function14[(16, 3, 1, 0)] = 0.16971702
        pgm_function14[(16, 3, 1, 1)] = 0.20672102
        pgm_function14[(16, 3, 1, 2)] = 0.1443
        pgm_function14[(16, 3, 1, 3)] = 0.0133
        pgm_function14[(16, 3, 2, 0)] = 0.09470956
        pgm_function14[(16, 3, 2, 1)] = 0.211020916
        pgm_function14[(16, 3, 2, 2)] = 0.1976599
        pgm_function14[(16, 3, 2, 3)] = 0.0913
        pgm_function14[(16, 3, 3, 0)] = 0.03429659
        pgm_function14[(16, 3, 3, 1)] = 0.2047
        pgm_function14[(16, 3, 3, 2)] = 0.20102014
        pgm_function14[(16, 3, 3, 3)] = 0.166
        pgm_function14[(16, 4, 0, 0)] = 0.20802099
        pgm_function14[(16, 4, 0, 1)] = 0.071307136
        pgm_function14[(16, 4, 1, 0)] = 0.205
        pgm_function14[(16, 4, 1, 1)] = 0.1716829588
        pgm_function14[(16, 4, 1, 2)] = 0.003
        pgm_function14[(16, 4, 2, 0)] = 0.2223221045
        pgm_function14[(16, 4, 2, 1)] = 0.201679913
        pgm_function14[(16, 4, 2, 2)] = 0.0633062937
        pgm_function14[(16, 4, 3, 0)] = 0.16998298
        pgm_function14[(16, 4, 3, 1)] = 0.1997
        pgm_function14[(16, 4, 3, 2)] = 0.171682919
        pgm_function14[(16, 4, 3, 3)] = 0.003699626
        pgm_function14[(16, 5, 0, 0)] = 0.181664044
        pgm_function14[(16, 5, 0, 1)] = 0.002
        pgm_function14[(16, 5, 1, 0)] = 0.21402099
        pgm_function14[(16, 5, 1, 1)] = 0.0730072591
        pgm_function14[(16, 5, 2, 0)] = 0.193
        pgm_function14[(16, 5, 2, 1)] = 0.1667
        pgm_function14[(16, 5, 3, 0)] = 0.240024168
        pgm_function14[(16, 5, 3, 1)] = 0.19997999
        pgm_function14[(16, 5, 3, 2)] = 0.022
        pgm_function14[(16, 6, 0, 0)] = 0.140314038
        pgm_function14[(16, 6, 1, 0)] = 0.213978865
        pgm_function14[(16, 6, 1, 1)] = 0.0093
        pgm_function14[(16, 6, 2, 0)] = 0.20102001
        pgm_function14[(16, 6, 2, 1)] = 0.1007100775
        pgm_function14[(16, 6, 3, 0)] = 0.18968094
        pgm_function14[(16, 6, 3, 1)] = 0.1736828836
        pgm_function14[(17, 1, 0, 2)] = 0.001
        pgm_function14[(17, 1, 0, 3)] = 0.0353
        pgm_function14[(17, 1, 1, 3)] = 0.0037
        pgm_function14[(17, 2, 0, 0)] = 0.0049994975
        pgm_function14[(17, 2, 0, 1)] = 0.10401
        pgm_function14[(17, 2, 0, 2)] = 0.178018025
        pgm_function14[(17, 2, 0, 3)] = 0.1803
        pgm_function14[(17, 2, 1, 1)] = 0.0457
        pgm_function14[(17, 2, 1, 2)] = 0.143313957
        pgm_function14[(17, 2, 1, 3)] = 0.1877
        pgm_function14[(17, 2, 2, 1)] = 0.0053
        pgm_function14[(17, 2, 2, 2)] = 0.0917
        pgm_function14[(17, 2, 2, 3)] = 0.16198405
        pgm_function14[(17, 2, 3, 2)] = 0.039007846
        pgm_function14[(17, 2, 3, 3)] = 0.116311927
        pgm_function14[(17, 3, 0, 0)] = 0.14898512
        pgm_function14[(17, 3, 0, 1)] = 0.1937
        pgm_function14[(17, 3, 0, 2)] = 0.129686822
        pgm_function14[(17, 3, 0, 3)] = 0.0087
        pgm_function14[(17, 3, 1, 0)] = 0.07430741
        pgm_function14[(17, 3, 1, 1)] = 0.19832002
        pgm_function14[(17, 3, 1, 2)] = 0.186
        pgm_function14[(17, 3, 1, 3)] = 0.0887
        pgm_function14[(17, 3, 2, 0)] = 0.01630161
        pgm_function14[(17, 3, 2, 1)] = 0.179317928
        pgm_function14[(17, 3, 2, 2)] = 0.1916619
        pgm_function14[(17, 3, 2, 3)] = 0.169
        pgm_function14[(17, 3, 3, 1)] = 0.1117
        pgm_function14[(17, 3, 3, 2)] = 0.20472014
        pgm_function14[(17, 3, 3, 3)] = 0.193
        pgm_function14[(17, 4, 0, 0)] = 0.19901999
        pgm_function14[(17, 4, 0, 1)] = 0.162016081
        pgm_function14[(17, 4, 0, 2)] = 0.003300328
        pgm_function14[(17, 4, 1, 0)] = 0.194
        pgm_function14[(17, 4, 1, 1)] = 0.1906809542
        pgm_function14[(17, 4, 1, 2)] = 0.079
        pgm_function14[(17, 4, 2, 0)] = 0.1393140655
        pgm_function14[(17, 4, 2, 1)] = 0.187980919
        pgm_function14[(17, 4, 2, 2)] = 0.1813179819
        pgm_function14[(17, 4, 2, 3)] = 0.010302111
        pgm_function14[(17, 4, 3, 0)] = 0.07499249
        pgm_function14[(17, 4, 3, 1)] = 0.211
        pgm_function14[(17, 4, 3, 2)] = 0.182981914
        pgm_function14[(17, 4, 3, 3)] = 0.095990304
        pgm_function14[(17, 5, 0, 0)] = 0.190262046
        pgm_function14[(17, 5, 0, 1)] = 0.085
        pgm_function14[(17, 5, 1, 0)] = 0.20031999
        pgm_function14[(17, 5, 1, 1)] = 0.1670169065
        pgm_function14[(17, 5, 1, 2)] = 0.001
        pgm_function14[(17, 5, 2, 0)] = 0.2087
        pgm_function14[(17, 5, 2, 1)] = 0.1953
        pgm_function14[(17, 5, 2, 2)] = 0.0563
        pgm_function14[(17, 5, 3, 0)] = 0.1523151066
        pgm_function14[(17, 5, 3, 1)] = 0.18068199
        pgm_function14[(17, 5, 3, 2)] = 0.1683
        pgm_function14[(17, 6, 0, 0)] = 0.212321057
        pgm_function14[(17, 6, 0, 1)] = 0.0207041
        pgm_function14[(17, 6, 1, 0)] = 0.165982895
        pgm_function14[(17, 6, 1, 1)] = 0.13
        pgm_function14[(17, 6, 2, 0)] = 0.22232201
        pgm_function14[(17, 6, 2, 1)] = 0.1733171335
        pgm_function14[(17, 6, 2, 2)] = 0.001
        pgm_function14[(17, 6, 3, 0)] = 0.20767894
        pgm_function14[(17, 6, 3, 1)] = 0.1996798662
        pgm_function14[(17, 6, 3, 2)] = 0.057694169
        pgm_function14[(18, 1, 0, 3)] = 0.0073
        pgm_function14[(18, 2, 0, 1)] = 0.0473047
        pgm_function14[(18, 2, 0, 2)] = 0.14001402
        pgm_function14[(18, 2, 0, 3)] = 0.1817
        pgm_function14[(18, 2, 1, 1)] = 0.0053
        pgm_function14[(18, 2, 1, 2)] = 0.0863085741
        pgm_function14[(18, 2, 1, 3)] = 0.1553
        pgm_function14[(18, 2, 2, 2)] = 0.0323
        pgm_function14[(18, 2, 2, 3)] = 0.10798903
        pgm_function14[(18, 2, 3, 2)] = 0.001300262
        pgm_function14[(18, 2, 3, 3)] = 0.066006558
        pgm_function14[(18, 3, 0, 0)] = 0.06899316
        pgm_function14[(18, 3, 0, 1)] = 0.187
        pgm_function14[(18, 3, 0, 2)] = 0.173282763
        pgm_function14[(18, 3, 0, 3)] = 0.068
        pgm_function14[(18, 3, 1, 0)] = 0.010301
        pgm_function14[(18, 3, 1, 1)] = 0.16431602
        pgm_function14[(18, 3, 1, 2)] = 0.181
        pgm_function14[(18, 3, 1, 3)] = 0.1617
        pgm_function14[(18, 3, 2, 1)] = 0.091309063
        pgm_function14[(18, 3, 2, 2)] = 0.1919619
        pgm_function14[(18, 3, 2, 3)] = 0.18
        pgm_function14[(18, 3, 3, 1)] = 0.026
        pgm_function14[(18, 3, 3, 2)] = 0.16631712
        pgm_function14[(18, 3, 3, 3)] = 0.1833
        pgm_function14[(18, 4, 0, 0)] = 0.17731799
        pgm_function14[(18, 4, 0, 1)] = 0.182318091
        pgm_function14[(18, 4, 0, 2)] = 0.068306769
        pgm_function14[(18, 4, 1, 0)] = 0.119
        pgm_function14[(18, 4, 1, 1)] = 0.1796819569
        pgm_function14[(18, 4, 1, 2)] = 0.172
        pgm_function14[(18, 4, 1, 3)] = 0.0129986887
        pgm_function14[(18, 4, 2, 0)] = 0.0430043202
        pgm_function14[(18, 4, 2, 1)] = 0.200979914
        pgm_function14[(18, 4, 2, 2)] = 0.1713169829
        pgm_function14[(18, 4, 2, 3)] = 0.117023124
        pgm_function14[(18, 4, 3, 0)] = 0.00169983
        pgm_function14[(18, 4, 3, 1)] = 0.1707
        pgm_function14[(18, 4, 3, 2)] = 0.183281914
        pgm_function14[(18, 4, 3, 3)] = 0.182681817
        pgm_function14[(18, 5, 0, 0)] = 0.198660048
        pgm_function14[(18, 5, 0, 1)] = 0.1563
        pgm_function14[(18, 5, 0, 2)] = 0.0009998992
        pgm_function14[(18, 5, 1, 0)] = 0.17771799
        pgm_function14[(18, 5, 1, 1)] = 0.1880188947
        pgm_function14[(18, 5, 1, 2)] = 0.0737
        pgm_function14[(18, 5, 2, 0)] = 0.1307
        pgm_function14[(18, 5, 2, 1)] = 0.17
        pgm_function14[(18, 5, 2, 2)] = 0.1753
        pgm_function14[(18, 5, 2, 3)] = 0.002
        pgm_function14[(18, 5, 3, 0)] = 0.0717072502
        pgm_function14[(18, 5, 3, 1)] = 0.20797899
        pgm_function14[(18, 5, 3, 2)] = 0.1737
        pgm_function14[(18, 5, 3, 3)] = 0.06269376
        pgm_function14[(18, 6, 0, 0)] = 0.160016043
        pgm_function14[(18, 6, 0, 1)] = 0.12932601
        pgm_function14[(18, 6, 1, 0)] = 0.220977861
        pgm_function14[(18, 6, 1, 1)] = 0.173
        pgm_function14[(18, 6, 1, 2)] = 0.006698659
        pgm_function14[(18, 6, 2, 0)] = 0.15631601
        pgm_function14[(18, 6, 2, 1)] = 0.1850191425
        pgm_function14[(18, 6, 2, 2)] = 0.1053
        pgm_function14[(18, 6, 3, 0)] = 0.13298696
        pgm_function14[(18, 6, 3, 1)] = 0.1636838903
        pgm_function14[(18, 6, 3, 2)] = 0.180981904
        pgm_function14[(18, 6, 3, 3)] = 0.0002999697
        pgm_function14[(19, 2, 0, 1)] = 0.00870087
        pgm_function14[(19, 2, 0, 2)] = 0.092709313
        pgm_function14[(19, 2, 0, 3)] = 0.153
        pgm_function14[(19, 2, 1, 2)] = 0.0360035892
        pgm_function14[(19, 2, 1, 3)] = 0.1103
        pgm_function14[(19, 2, 2, 2)] = 0.0013
        pgm_function14[(19, 2, 2, 3)] = 0.06269372
        pgm_function14[(19, 2, 3, 3)] = 0.010701093
        pgm_function14[(19, 3, 0, 0)] = 0.01129891
        pgm_function14[(19, 3, 0, 1)] = 0.162
        pgm_function14[(19, 3, 0, 2)] = 0.172282764
        pgm_function14[(19, 3, 0, 3)] = 0.1393
        pgm_function14[(19, 3, 1, 1)] = 0.08530851
        pgm_function14[(19, 3, 1, 2)] = 0.1833
        pgm_function14[(19, 3, 1, 3)] = 0.1683
        pgm_function14[(19, 3, 2, 1)] = 0.018301793
        pgm_function14[(19, 3, 2, 2)] = 0.15196992
        pgm_function14[(19, 3, 2, 3)] = 0.1757
        pgm_function14[(19, 3, 3, 2)] = 0.08700876
        pgm_function14[(19, 3, 3, 3)] = 0.1813
        pgm_function14[(19, 4, 0, 0)] = 0.110311
        pgm_function14[(19, 4, 0, 1)] = 0.166017083
        pgm_function14[(19, 4, 0, 2)] = 0.155015929
        pgm_function14[(19, 4, 0, 3)] = 0.007
        pgm_function14[(19, 4, 1, 0)] = 0.0323
        pgm_function14[(19, 4, 1, 1)] = 0.1896809545
        pgm_function14[(19, 4, 1, 2)] = 0.1643
        pgm_function14[(19, 4, 1, 3)] = 0.1099889043
        pgm_function14[(19, 4, 2, 0)] = 0.0003000301
        pgm_function14[(19, 4, 2, 1)] = 0.150984935
        pgm_function14[(19, 4, 2, 2)] = 0.1777179822
        pgm_function14[(19, 4, 2, 3)] = 0.172334183
        pgm_function14[(19, 4, 3, 1)] = 0.081
        pgm_function14[(19, 4, 3, 2)] = 0.185680913
        pgm_function14[(19, 4, 3, 3)] = 0.15968384
        pgm_function14[(19, 5, 0, 0)] = 0.161668039
        pgm_function14[(19, 5, 0, 1)] = 0.179
        pgm_function14[(19, 5, 0, 2)] = 0.0639935488
        pgm_function14[(19, 5, 1, 0)] = 0.115312
        pgm_function14[(19, 5, 1, 1)] = 0.1627159089
        pgm_function14[(19, 5, 1, 2)] = 0.1677
        pgm_function14[(19, 5, 1, 3)] = 0.003
        pgm_function14[(19, 5, 2, 0)] = 0.039
        pgm_function14[(19, 5, 2, 1)] = 0.201
        pgm_function14[(19, 5, 2, 2)] = 0.1633
        pgm_function14[(19, 5, 2, 3)] = 0.0927
        pgm_function14[(19, 5, 3, 0)] = 0.0003000302
        pgm_function14[(19, 5, 3, 1)] = 0.16368399
        pgm_function14[(19, 5, 3, 2)] = 0.1703
        pgm_function14[(19, 5, 3, 3)] = 0.18568119
        pgm_function14[(19, 6, 0, 0)] = 0.204720055
        pgm_function14[(19, 6, 0, 1)] = 0.16333301
        pgm_function14[(19, 6, 0, 2)] = 0.0067
        pgm_function14[(19, 6, 1, 0)] = 0.133286916
        pgm_function14[(19, 6, 1, 1)] = 0.1683
        pgm_function14[(19, 6, 1, 2)] = 0.118675981
        pgm_function14[(19, 6, 2, 0)] = 0.110711
        pgm_function14[(19, 6, 2, 1)] = 0.1703171311
        pgm_function14[(19, 6, 2, 2)] = 0.1717
        pgm_function14[(19, 6, 2, 3)] = 0.0047
        pgm_function14[(19, 6, 3, 0)] = 0.02969699
        pgm_function14[(19, 6, 3, 1)] = 0.205978862
        pgm_function14[(19, 6, 3, 2)] = 0.160683915
        pgm_function14[(19, 6, 3, 3)] = 0.0916907019
        pgm_function14[(20, 2, 0, 2)] = 0.046004606
        pgm_function14[(20, 2, 0, 3)] = 0.119
        pgm_function14[(20, 2, 1, 2)] = 0.0027002692
        pgm_function14[(20, 2, 1, 3)] = 0.0677
        pgm_function14[(20, 2, 2, 3)] = 0.0126987
        pgm_function14[(20, 3, 0, 1)] = 0.092
        pgm_function14[(20, 3, 0, 2)] = 0.170682766
        pgm_function14[(20, 3, 0, 3)] = 0.1607
        pgm_function14[(20, 3, 1, 1)] = 0.0193019
        pgm_function14[(20, 3, 1, 2)] = 0.151
        pgm_function14[(20, 3, 1, 3)] = 0.165
        pgm_function14[(20, 3, 2, 2)] = 0.08168366
        pgm_function14[(20, 3, 2, 3)] = 0.174
        pgm_function14[(20, 3, 3, 2)] = 0.01530151
        pgm_function14[(20, 3, 3, 3)] = 0.13
        pgm_function14[(20, 4, 0, 0)] = 0.0353035
        pgm_function14[(20, 4, 0, 1)] = 0.183318092
        pgm_function14[(20, 4, 0, 2)] = 0.158315927
        pgm_function14[(20, 4, 0, 3)] = 0.077
        pgm_function14[(20, 4, 1, 1)] = 0.1406859662
        pgm_function14[(20, 4, 1, 2)] = 0.1673
        pgm_function14[(20, 4, 1, 3)] = 0.1646838567
        pgm_function14[(20, 4, 2, 1)] = 0.063693573
        pgm_function14[(20, 4, 2, 2)] = 0.1760179824
        pgm_function14[(20, 4, 2, 3)] = 0.15133016
        pgm_function14[(20, 4, 3, 1)] = 0.0043
        pgm_function14[(20, 4, 3, 2)] = 0.161683924
        pgm_function14[(20, 4, 3, 3)] = 0.174282826
        pgm_function14[(20, 5, 0, 0)] = 0.107678026
        pgm_function14[(20, 5, 0, 1)] = 0.152
        pgm_function14[(20, 5, 0, 2)] = 0.1516848787
        pgm_function14[(20, 5, 0, 3)] = 0.001
        pgm_function14[(20, 5, 1, 0)] = 0.0277028
        pgm_function14[(20, 5, 1, 1)] = 0.1890188941
        pgm_function14[(20, 5, 1, 2)] = 0.1563
        pgm_function14[(20, 5, 1, 3)] = 0.0873
        pgm_function14[(20, 5, 2, 1)] = 0.1483
        pgm_function14[(20, 5, 2, 2)] = 0.165
        pgm_function14[(20, 5, 2, 3)] = 0.175
        pgm_function14[(20, 5, 3, 1)] = 0.09769019
        pgm_function14[(20, 5, 3, 2)] = 0.1777
        pgm_function14[(20, 5, 3, 3)] = 0.13798614
        pgm_function14[(20, 6, 0, 0)] = 0.125313034
        pgm_function14[(20, 6, 0, 1)] = 0.16233201
        pgm_function14[(20, 6, 0, 2)] = 0.1053
        pgm_function14[(20, 6, 1, 0)] = 0.091690742
        pgm_function14[(20, 6, 1, 1)] = 0.171
        pgm_function14[(20, 6, 1, 2)] = 0.160967974
        pgm_function14[(20, 6, 1, 3)] = 0.0077
        pgm_function14[(20, 6, 2, 0)] = 0.00930093
        pgm_function14[(20, 6, 2, 1)] = 0.1840181417
        pgm_function14[(20, 6, 2, 2)] = 0.1527
        pgm_function14[(20, 6, 2, 3)] = 0.12
        pgm_function14[(20, 6, 3, 1)] = 0.1436859037
        pgm_function14[(20, 6, 3, 2)] = 0.164683913
        pgm_function14[(20, 6, 3, 3)] = 0.1819818053
        pgm_function14[(21, 2, 0, 2)] = 0.009300931
        pgm_function14[(21, 2, 0, 3)] = 0.0803
        pgm_function14[(21, 2, 1, 3)] = 0.021
        pgm_function14[(21, 3, 0, 1)] = 0.0297
        pgm_function14[(21, 3, 0, 2)] = 0.154684788
        pgm_function14[(21, 3, 0, 3)] = 0.1523
        pgm_function14[(21, 3, 1, 2)] = 0.0857
        pgm_function14[(21, 3, 1, 3)] = 0.166
        pgm_function14[(21, 3, 2, 2)] = 0.01469709
        pgm_function14[(21, 3, 2, 3)] = 0.1257
        pgm_function14[(21, 3, 3, 3)] = 0.0617
        pgm_function14[(21, 4, 0, 0)] = 0.00030003
        pgm_function14[(21, 4, 0, 1)] = 0.141014071
        pgm_function14[(21, 4, 0, 2)] = 0.154314929
        pgm_function14[(21, 4, 0, 3)] = 0.152
        pgm_function14[(21, 4, 1, 1)] = 0.0639935846
        pgm_function14[(21, 4, 1, 2)] = 0.1677
        pgm_function14[(21, 4, 1, 3)] = 0.1426858759
        pgm_function14[(21, 4, 2, 1)] = 0.002699729
        pgm_function14[(21, 4, 2, 2)] = 0.1520149848
        pgm_function14[(21, 4, 2, 3)] = 0.168334178
        pgm_function14[(21, 4, 3, 2)] = 0.077692163
        pgm_function14[(21, 4, 3, 3)] = 0.162983837
        pgm_function14[(21, 5, 0, 0)] = 0.031693708
        pgm_function14[(21, 5, 0, 1)] = 0.1807
        pgm_function14[(21, 5, 0, 2)] = 0.151284879
        pgm_function14[(21, 5, 0, 3)] = 0.0577
        pgm_function14[(21, 5, 1, 1)] = 0.1373139231
        pgm_function14[(21, 5, 1, 2)] = 0.154
        pgm_function14[(21, 5, 1, 3)] = 0.1673
        pgm_function14[(21, 5, 2, 1)] = 0.0767
        pgm_function14[(21, 5, 2, 2)] = 0.1697
        pgm_function14[(21, 5, 2, 3)] = 0.131
        pgm_function14[(21, 5, 3, 1)] = 0.0059994
        pgm_function14[(21, 5, 3, 2)] = 0.163
        pgm_function14[(21, 5, 3, 3)] = 0.17128317
        pgm_function14[(21, 6, 0, 0)] = 0.085708623
        pgm_function14[(21, 6, 0, 1)] = 0.15733101
        pgm_function14[(21, 6, 0, 2)] = 0.1503
        pgm_function14[(21, 6, 0, 3)] = 0.0037
        pgm_function14[(21, 6, 1, 0)] = 0.005699426
        pgm_function14[(21, 6, 1, 1)] = 0.1687
        pgm_function14[(21, 6, 1, 2)] = 0.147669976
        pgm_function14[(21, 6, 1, 3)] = 0.1167
        pgm_function14[(21, 6, 2, 1)] = 0.1340131032
        pgm_function14[(21, 6, 2, 2)] = 0.1583
        pgm_function14[(21, 6, 2, 3)] = 0.1683
        pgm_function14[(21, 6, 3, 1)] = 0.0736925506
        pgm_function14[(21, 6, 3, 2)] = 0.174682907
        pgm_function14[(21, 6, 3, 3)] = 0.1249878663
        pgm_function14[(22, 2, 0, 3)] = 0.0403
        pgm_function14[(22, 2, 1, 3)] = 0.001
        pgm_function14[(22, 3, 0, 1)] = 0.0017
        pgm_function14[(22, 3, 0, 2)] = 0.103689858
        pgm_function14[(22, 3, 0, 3)] = 0.1583
        pgm_function14[(22, 3, 1, 2)] = 0.023
        pgm_function14[(22, 3, 1, 3)] = 0.1337
        pgm_function14[(22, 3, 2, 3)] = 0.0653
        pgm_function14[(22, 3, 3, 3)] = 0.0057
        pgm_function14[(22, 4, 0, 1)] = 0.076707738
        pgm_function14[(22, 4, 0, 2)] = 0.159715927
        pgm_function14[(22, 4, 0, 3)] = 0.1383
        pgm_function14[(22, 4, 1, 1)] = 0.004299569
        pgm_function14[(22, 4, 1, 2)] = 0.148
        pgm_function14[(22, 4, 1, 3)] = 0.1579838626
        pgm_function14[(22, 4, 2, 2)] = 0.0713070929
        pgm_function14[(22, 4, 2, 3)] = 0.156331166
        pgm_function14[(22, 4, 3, 2)] = 0.005299468
        pgm_function14[(22, 4, 3, 3)] = 0.150684849
        pgm_function14[(22, 5, 0, 1)] = 0.136
        pgm_function14[(22, 5, 0, 2)] = 0.1439858848
        pgm_function14[(22, 5, 0, 3)] = 0.1493
        pgm_function14[(22, 5, 1, 1)] = 0.0773076567
        pgm_function14[(22, 5, 1, 2)] = 0.1627
        pgm_function14[(22, 5, 1, 3)] = 0.128
        pgm_function14[(22, 5, 2, 1)] = 0.0033
        pgm_function14[(22, 5, 2, 2)] = 0.153
        pgm_function14[(22, 5, 2, 3)] = 0.1623
        pgm_function14[(22, 5, 3, 2)] = 0.1127
        pgm_function14[(22, 5, 3, 3)] = 0.15128515
        pgm_function14[(22, 6, 0, 0)] = 0.009300933
        pgm_function14[(22, 6, 0, 1)] = 0.16833401
        pgm_function14[(22, 6, 0, 2)] = 0.1433
        pgm_function14[(22, 6, 0, 3)] = 0.0843
        pgm_function14[(22, 6, 1, 1)] = 0.126
        pgm_function14[(22, 6, 1, 2)] = 0.149669976
        pgm_function14[(22, 6, 1, 3)] = 0.1597
        pgm_function14[(22, 6, 2, 1)] = 0.0523052403
        pgm_function14[(22, 6, 2, 2)] = 0.1663
        pgm_function14[(22, 6, 2, 3)] = 0.1217
        pgm_function14[(22, 6, 3, 1)] = 0.0002999698
        pgm_function14[(22, 6, 3, 2)] = 0.149284921
        pgm_function14[(22, 6, 3, 3)] = 0.1666828216
        pgm_function14[(23, 2, 0, 3)] = 0.008
        pgm_function14[(23, 3, 0, 2)] = 0.04369554
        pgm_function14[(23, 3, 0, 3)] = 0.143
        pgm_function14[(23, 3, 1, 2)] = 0.0003
        pgm_function14[(23, 3, 1, 3)] = 0.0803
        pgm_function14[(23, 3, 2, 3)] = 0.009
        pgm_function14[(23, 4, 0, 1)] = 0.015301508
        pgm_function14[(23, 4, 0, 2)] = 0.149714931
        pgm_function14[(23, 4, 0, 3)] = 0.142
        pgm_function14[(23, 4, 1, 2)] = 0.0847
        pgm_function14[(23, 4, 1, 3)] = 0.1486848706
        pgm_function14[(23, 4, 2, 2)] = 0.0063006294
        pgm_function14[(23, 4, 2, 3)] = 0.145329154
        pgm_function14[(23, 4, 3, 3)] = 0.065693334
        pgm_function14[(23, 5, 0, 1)] = 0.0913
        pgm_function14[(23, 5, 0, 2)] = 0.1526848779
        pgm_function14[(23, 5, 0, 3)] = 0.1327
        pgm_function14[(23, 5, 1, 1)] = 0.005300527
        pgm_function14[(23, 5, 1, 2)] = 0.1473
        pgm_function14[(23, 5, 1, 3)] = 0.15
        pgm_function14[(23, 5, 2, 2)] = 0.1047
        pgm_function14[(23, 5, 2, 3)] = 0.148
        pgm_function14[(23, 5, 3, 2)] = 0.0123
        pgm_function14[(23, 5, 3, 3)] = 0.15668416
        pgm_function14[(23, 6, 0, 1)] = 0.119324
        pgm_function14[(23, 6, 0, 2)] = 0.138
        pgm_function14[(23, 6, 0, 3)] = 0.1497
        pgm_function14[(23, 6, 1, 1)] = 0.053
        pgm_function14[(23, 6, 1, 2)] = 0.160667974
        pgm_function14[(23, 6, 1, 3)] = 0.1183
        pgm_function14[(23, 6, 2, 2)] = 0.1437
        pgm_function14[(23, 6, 2, 3)] = 0.1597
        pgm_function14[(23, 6, 3, 2)] = 0.105288944
        pgm_function14[(23, 6, 3, 3)] = 0.1449858449
        pgm_function14[(24, 3, 0, 2)] = 0.00699929
        pgm_function14[(24, 3, 0, 3)] = 0.1047
        pgm_function14[(24, 3, 1, 3)] = 0.0223
        pgm_function14[(24, 4, 0, 2)] = 0.10831095
        pgm_function14[(24, 4, 0, 3)] = 0.1447
        pgm_function14[(24, 4, 1, 2)] = 0.014
        pgm_function14[(24, 4, 1, 3)] = 0.1446858741
        pgm_function14[(24, 4, 2, 3)] = 0.071314376
        pgm_function14[(24, 4, 3, 3)] = 0.004299566
        pgm_function14[(24, 5, 0, 1)] = 0.0177
        pgm_function14[(24, 5, 0, 2)] = 0.1466848827
        pgm_function14[(24, 5, 0, 3)] = 0.128
        pgm_function14[(24, 5, 1, 2)] = 0.111
        pgm_function14[(24, 5, 1, 3)] = 0.1427
        pgm_function14[(24, 5, 2, 2)] = 0.0127
        pgm_function14[(24, 5, 2, 3)] = 0.1493
        pgm_function14[(24, 5, 3, 3)] = 0.11768812
        pgm_function14[(24, 6, 0, 1)] = 0.0730146
        pgm_function14[(24, 6, 0, 2)] = 0.152
        pgm_function14[(24, 6, 0, 3)] = 0.122
        pgm_function14[(24, 6, 1, 1)] = 0.0007
        pgm_function14[(24, 6, 1, 2)] = 0.136672978
        pgm_function14[(24, 6, 1, 3)] = 0.1493
        pgm_function14[(24, 6, 2, 2)] = 0.0943
        pgm_function14[(24, 6, 2, 3)] = 0.139
        pgm_function14[(24, 6, 3, 2)] = 0.006699326
        pgm_function14[(24, 6, 3, 3)] = 0.1499848395
        pgm_function14[(25, 3, 0, 3)] = 0.053
        pgm_function14[(25, 3, 1, 3)] = 0.0007
        pgm_function14[(25, 4, 0, 2)] = 0.039703982
        pgm_function14[(25, 4, 0, 3)] = 0.1407
        pgm_function14[(25, 4, 1, 3)] = 0.094290518
        pgm_function14[(25, 4, 2, 3)] = 0.007701548
        pgm_function14[(25, 5, 0, 2)] = 0.1216879026
        pgm_function14[(25, 5, 0, 3)] = 0.1427
        pgm_function14[(25, 5, 1, 2)] = 0.0263
        pgm_function14[(25, 5, 1, 3)] = 0.14
        pgm_function14[(25, 5, 2, 3)] = 0.116
        pgm_function14[(25, 5, 3, 3)] = 0.01669832
        pgm_function14[(25, 6, 0, 1)] = 0.00630126
        pgm_function14[(25, 6, 0, 2)] = 0.137
        pgm_function14[(25, 6, 0, 3)] = 0.128
        pgm_function14[(25, 6, 1, 2)] = 0.101679984
        pgm_function14[(25, 6, 1, 3)] = 0.1357
        pgm_function14[(25, 6, 2, 2)] = 0.0067
        pgm_function14[(25, 6, 2, 3)] = 0.1433
        pgm_function14[(25, 6, 3, 3)] = 0.1226878687
        pgm_function14[(26, 3, 0, 3)] = 0.0117
        pgm_function14[(26, 4, 0, 2)] = 0.003300328
        pgm_function14[(26, 4, 0, 3)] = 0.1203
        pgm_function14[(26, 4, 1, 3)] = 0.0236975794
        pgm_function14[(26, 5, 0, 2)] = 0.059993952
        pgm_function14[(26, 5, 0, 3)] = 0.1323
        pgm_function14[(26, 5, 1, 3)] = 0.1287
        pgm_function14[(26, 5, 2, 3)] = 0.0237
        pgm_function14[(26, 6, 0, 2)] = 0.115
        pgm_function14[(26, 6, 0, 3)] = 0.1363
        pgm_function14[(26, 6, 1, 2)] = 0.017296497
        pgm_function14[(26, 6, 1, 3)] = 0.135
        pgm_function14[(26, 6, 2, 3)] = 0.121
        pgm_function14[(26, 6, 3, 3)] = 0.0166982821
        pgm_function14[(27, 3, 0, 3)] = 0.0003
        pgm_function14[(27, 4, 0, 3)] = 0.0647
        pgm_function14[(27, 4, 1, 3)] = 0.0002999697
        pgm_function14[(27, 5, 0, 2)] = 0.0069992944
        pgm_function14[(27, 5, 0, 3)] = 0.131
        pgm_function14[(27, 5, 1, 3)] = 0.05
        pgm_function14[(27, 6, 0, 2)] = 0.0497
        pgm_function14[(27, 6, 0, 3)] = 0.1283
        pgm_function14[(27, 6, 1, 3)] = 0.127
        pgm_function14[(27, 6, 2, 3)] = 0.0223
        pgm_function14[(28, 4, 0, 3)] = 0.0133
        pgm_function14[(28, 5, 0, 3)] = 0.0943
        pgm_function14[(28, 5, 1, 3)] = 0.003
        pgm_function14[(28, 6, 0, 2)] = 0.0027
        pgm_function14[(28, 6, 0, 3)] = 0.127
        pgm_function14[(28, 6, 1, 3)] = 0.0493
        pgm_function14[(29, 5, 0, 3)] = 0.0303
        pgm_function14[(29, 6, 0, 3)] = 0.0927
        pgm_function14[(29, 6, 1, 3)] = 0.0013
        pgm_function14[(30, 5, 0, 3)] = 0.0007
        pgm_function14[(30, 6, 0, 3)] = 0.0277
        pgm_function14[(31, 6, 0, 3)] = 0.0003

        pgm_function15 = pgm_factor15.set_dense()
        pgm_function15.set_flat(0.067, 0.433, 0.433, 0.067)

        pgm_function16 = pgm_factor16.set_dense()
        pgm_function16.set_flat(0.0, 0.3, 0.533, 0.167)

        pgm_function17 = pgm_factor17.set_sparse()
        pgm_function17[(0, 0, 0)] = 1.0
        pgm_function17[(0, 0, 1)] = 1.0
        pgm_function17[(0, 0, 2)] = 1.0
        pgm_function17[(0, 0, 3)] = 1.0
        pgm_function17[(0, 0, 4)] = 1.0
        pgm_function17[(0, 0, 5)] = 1.0
        pgm_function17[(0, 0, 6)] = 1.0
        pgm_function17[(0, 0, 7)] = 1.0
        pgm_function17[(0, 0, 8)] = 1.0
        pgm_function17[(0, 1, 0)] = 0.2333
        pgm_function17[(0, 1, 1)] = 0.2333
        pgm_function17[(0, 1, 2)] = 0.2333
        pgm_function17[(0, 1, 3)] = 0.2333
        pgm_function17[(0, 1, 4)] = 0.27
        pgm_function17[(0, 1, 5)] = 0.3
        pgm_function17[(0, 1, 6)] = 0.39
        pgm_function17[(0, 1, 7)] = 0.6833
        pgm_function17[(0, 1, 8)] = 0.9967
        pgm_function17[(0, 2, 7)] = 0.0033
        pgm_function17[(0, 2, 8)] = 0.7467
        pgm_function17[(0, 3, 8)] = 0.4867
        pgm_function17[(0, 4, 8)] = 0.37
        pgm_function17[(0, 5, 8)] = 0.2967
        pgm_function17[(0, 6, 8)] = 0.2433242
        pgm_function17[(0, 7, 8)] = 0.2
        pgm_function17[(1, 1, 0)] = 0.7667
        pgm_function17[(1, 1, 1)] = 0.7667
        pgm_function17[(1, 1, 2)] = 0.7667
        pgm_function17[(1, 1, 3)] = 0.7667
        pgm_function17[(1, 1, 4)] = 0.73
        pgm_function17[(1, 1, 5)] = 0.7
        pgm_function17[(1, 1, 6)] = 0.61
        pgm_function17[(1, 1, 7)] = 0.3167
        pgm_function17[(1, 1, 8)] = 0.0033
        pgm_function17[(1, 2, 0)] = 0.7
        pgm_function17[(1, 2, 1)] = 0.7
        pgm_function17[(1, 2, 2)] = 0.7
        pgm_function17[(1, 2, 3)] = 0.7333
        pgm_function17[(1, 2, 4)] = 0.7833
        pgm_function17[(1, 2, 5)] = 0.8433
        pgm_function17[(1, 2, 6)] = 0.96
        pgm_function17[(1, 2, 7)] = 0.9967
        pgm_function17[(1, 2, 8)] = 0.2533
        pgm_function17[(1, 3, 4)] = 0.01
        pgm_function17[(1, 3, 5)] = 0.0467
        pgm_function17[(1, 3, 6)] = 0.21
        pgm_function17[(1, 3, 7)] = 0.8267
        pgm_function17[(1, 3, 8)] = 0.5133
        pgm_function17[(1, 4, 7)] = 0.2367
        pgm_function17[(1, 4, 8)] = 0.62
        pgm_function17[(1, 5, 7)] = 0.006699334
        pgm_function17[(1, 5, 8)] = 0.58
        pgm_function17[(1, 6, 8)] = 0.4933495
        pgm_function17[(1, 7, 8)] = 0.43
        pgm_function17[(2, 2, 0)] = 0.3
        pgm_function17[(2, 2, 1)] = 0.3
        pgm_function17[(2, 2, 2)] = 0.3
        pgm_function17[(2, 2, 3)] = 0.2667
        pgm_function17[(2, 2, 4)] = 0.2167
        pgm_function17[(2, 2, 5)] = 0.1567
        pgm_function17[(2, 2, 6)] = 0.04
        pgm_function17[(2, 3, 0)] = 0.9333
        pgm_function17[(2, 3, 1)] = 0.9333
        pgm_function17[(2, 3, 2)] = 0.9333
        pgm_function17[(2, 3, 3)] = 0.96
        pgm_function17[(2, 3, 4)] = 0.9733
        pgm_function17[(2, 3, 5)] = 0.9533
        pgm_function17[(2, 3, 6)] = 0.79
        pgm_function17[(2, 3, 7)] = 0.1733
        pgm_function17[(2, 4, 0)] = 0.2
        pgm_function17[(2, 4, 1)] = 0.2367
        pgm_function17[(2, 4, 2)] = 0.2667
        pgm_function17[(2, 4, 3)] = 0.2667
        pgm_function17[(2, 4, 4)] = 0.3367
        pgm_function17[(2, 4, 5)] = 0.48
        pgm_function17[(2, 4, 6)] = 0.7933
        pgm_function17[(2, 4, 7)] = 0.7633
        pgm_function17[(2, 4, 8)] = 0.01
        pgm_function17[(2, 5, 6)] = 0.1533
        pgm_function17[(2, 5, 7)] = 0.836616561
        pgm_function17[(2, 5, 8)] = 0.1233
        pgm_function17[(2, 6, 7)] = 0.45
        pgm_function17[(2, 6, 8)] = 0.2633263
        pgm_function17[(2, 7, 7)] = 0.1367
        pgm_function17[(2, 7, 8)] = 0.3533
        pgm_function17[(3, 3, 0)] = 0.0667
        pgm_function17[(3, 3, 1)] = 0.0667
        pgm_function17[(3, 3, 2)] = 0.0667
        pgm_function17[(3, 3, 3)] = 0.04
        pgm_function17[(3, 3, 4)] = 0.0167
        pgm_function17[(3, 4, 0)] = 0.8
        pgm_function17[(3, 4, 1)] = 0.7633
        pgm_function17[(3, 4, 2)] = 0.7333
        pgm_function17[(3, 4, 3)] = 0.7333
        pgm_function17[(3, 4, 4)] = 0.6633
        pgm_function17[(3, 4, 5)] = 0.52
        pgm_function17[(3, 4, 6)] = 0.2067
        pgm_function17[(3, 5, 0)] = 0.5667
        pgm_function17[(3, 5, 1)] = 0.5733
        pgm_function17[(3, 5, 2)] = 0.6
        pgm_function17[(3, 5, 3)] = 0.63
        pgm_function17[(3, 5, 4)] = 0.7133
        pgm_function17[(3, 5, 5)] = 0.84
        pgm_function17[(3, 5, 6)] = 0.8267
        pgm_function17[(3, 5, 7)] = 0.156684105
        pgm_function17[(3, 6, 0)] = 0.06669335
        pgm_function17[(3, 6, 1)] = 0.06669335
        pgm_function17[(3, 6, 2)] = 0.06669335
        pgm_function17[(3, 6, 3)] = 0.08
        pgm_function17[(3, 6, 4)] = 0.1333
        pgm_function17[(3, 6, 5)] = 0.23
        pgm_function17[(3, 6, 6)] = 0.6133
        pgm_function17[(3, 6, 7)] = 0.5433
        pgm_function17[(3, 7, 6)] = 0.1467
        pgm_function17[(3, 7, 7)] = 0.7133
        pgm_function17[(3, 7, 8)] = 0.0167
        pgm_function17[(4, 5, 0)] = 0.4333
        pgm_function17[(4, 5, 1)] = 0.4267
        pgm_function17[(4, 5, 2)] = 0.4
        pgm_function17[(4, 5, 3)] = 0.37
        pgm_function17[(4, 5, 4)] = 0.2867
        pgm_function17[(4, 5, 5)] = 0.16
        pgm_function17[(4, 5, 6)] = 0.02
        pgm_function17[(4, 6, 0)] = 0.76662354
        pgm_function17[(4, 6, 1)] = 0.76662354
        pgm_function17[(4, 6, 2)] = 0.76662354
        pgm_function17[(4, 6, 3)] = 0.7667
        pgm_function17[(4, 6, 4)] = 0.7667
        pgm_function17[(4, 6, 5)] = 0.7533
        pgm_function17[(4, 6, 6)] = 0.3867
        pgm_function17[(4, 6, 7)] = 0.0067
        pgm_function17[(4, 7, 0)] = 0.3
        pgm_function17[(4, 7, 1)] = 0.3
        pgm_function17[(4, 7, 2)] = 0.3
        pgm_function17[(4, 7, 3)] = 0.35
        pgm_function17[(4, 7, 4)] = 0.44
        pgm_function17[(4, 7, 5)] = 0.5467
        pgm_function17[(4, 7, 6)] = 0.74
        pgm_function17[(4, 7, 7)] = 0.15
        pgm_function17[(5, 6, 0)] = 0.16668312
        pgm_function17[(5, 6, 1)] = 0.16668312
        pgm_function17[(5, 6, 2)] = 0.16668312
        pgm_function17[(5, 6, 3)] = 0.1533
        pgm_function17[(5, 6, 4)] = 0.1
        pgm_function17[(5, 6, 5)] = 0.0167
        pgm_function17[(5, 7, 0)] = 0.6333
        pgm_function17[(5, 7, 1)] = 0.6333
        pgm_function17[(5, 7, 2)] = 0.6333
        pgm_function17[(5, 7, 3)] = 0.6167
        pgm_function17[(5, 7, 4)] = 0.5567
        pgm_function17[(5, 7, 5)] = 0.4533
        pgm_function17[(5, 7, 6)] = 0.1133
        pgm_function17[(6, 7, 0)] = 0.0667
        pgm_function17[(6, 7, 1)] = 0.0667
        pgm_function17[(6, 7, 2)] = 0.0667
        pgm_function17[(6, 7, 3)] = 0.0333
        pgm_function17[(6, 7, 4)] = 0.0033

        pgm_function18 = pgm_factor18.set_sparse()
        pgm_function18[(0, 0, 0, 0)] = 1.0
        pgm_function18[(0, 0, 0, 1)] = 0.3
        pgm_function18[(0, 0, 0, 2)] = 0.1
        pgm_function18[(0, 0, 0, 3)] = 0.1
        pgm_function18[(0, 0, 1, 0)] = 1.0
        pgm_function18[(0, 0, 1, 1)] = 0.2
        pgm_function18[(0, 0, 1, 2)] = 0.1
        pgm_function18[(0, 0, 2, 0)] = 0.9
        pgm_function18[(0, 0, 2, 1)] = 0.05
        pgm_function18[(0, 0, 3, 0)] = 0.75
        pgm_function18[(0, 1, 0, 0)] = 1.0
        pgm_function18[(0, 1, 0, 1)] = 1.0
        pgm_function18[(0, 1, 0, 2)] = 0.95
        pgm_function18[(0, 1, 0, 3)] = 0.95
        pgm_function18[(0, 1, 0, 4)] = 0.8
        pgm_function18[(0, 1, 0, 5)] = 0.5
        pgm_function18[(0, 1, 0, 6)] = 0.2
        pgm_function18[(0, 1, 0, 7)] = 0.05
        pgm_function18[(0, 1, 1, 0)] = 1.0
        pgm_function18[(0, 1, 1, 1)] = 1.0
        pgm_function18[(0, 1, 1, 2)] = 0.95
        pgm_function18[(0, 1, 1, 3)] = 0.9
        pgm_function18[(0, 1, 1, 4)] = 0.75
        pgm_function18[(0, 1, 1, 5)] = 0.4
        pgm_function18[(0, 1, 1, 6)] = 0.1
        pgm_function18[(0, 1, 2, 0)] = 1.0
        pgm_function18[(0, 1, 2, 1)] = 1.0
        pgm_function18[(0, 1, 2, 2)] = 0.95
        pgm_function18[(0, 1, 2, 3)] = 0.7
        pgm_function18[(0, 1, 2, 4)] = 0.4
        pgm_function18[(0, 1, 2, 5)] = 0.1
        pgm_function18[(0, 1, 3, 0)] = 1.0
        pgm_function18[(0, 1, 3, 1)] = 1.0
        pgm_function18[(0, 1, 3, 2)] = 0.85
        pgm_function18[(0, 1, 3, 3)] = 0.6
        pgm_function18[(0, 1, 3, 4)] = 0.25
        pgm_function18[(0, 1, 3, 5)] = 0.05
        pgm_function18[(0, 2, 0, 0)] = 1.0
        pgm_function18[(0, 2, 0, 1)] = 1.0
        pgm_function18[(0, 2, 0, 2)] = 1.0
        pgm_function18[(0, 2, 0, 3)] = 0.95
        pgm_function18[(0, 2, 0, 4)] = 0.9
        pgm_function18[(0, 2, 0, 5)] = 0.65
        pgm_function18[(0, 2, 0, 6)] = 0.4
        pgm_function18[(0, 2, 0, 7)] = 0.2
        pgm_function18[(0, 2, 0, 8)] = 0.05
        pgm_function18[(0, 2, 1, 0)] = 1.0
        pgm_function18[(0, 2, 1, 1)] = 1.0
        pgm_function18[(0, 2, 1, 2)] = 1.0
        pgm_function18[(0, 2, 1, 3)] = 0.95
        pgm_function18[(0, 2, 1, 4)] = 0.85
        pgm_function18[(0, 2, 1, 5)] = 0.5
        pgm_function18[(0, 2, 1, 6)] = 0.3
        pgm_function18[(0, 2, 1, 7)] = 0.1
        pgm_function18[(0, 2, 2, 0)] = 1.0
        pgm_function18[(0, 2, 2, 1)] = 1.0
        pgm_function18[(0, 2, 2, 2)] = 1.0
        pgm_function18[(0, 2, 2, 3)] = 0.9
        pgm_function18[(0, 2, 2, 4)] = 0.75
        pgm_function18[(0, 2, 2, 5)] = 0.3
        pgm_function18[(0, 2, 2, 6)] = 0.1
        pgm_function18[(0, 2, 3, 0)] = 1.0
        pgm_function18[(0, 2, 3, 1)] = 1.0
        pgm_function18[(0, 2, 3, 2)] = 0.95
        pgm_function18[(0, 2, 3, 3)] = 0.85
        pgm_function18[(0, 2, 3, 4)] = 0.65
        pgm_function18[(0, 2, 3, 5)] = 0.2
        pgm_function18[(0, 2, 3, 6)] = 0.05
        pgm_function18[(0, 3, 0, 0)] = 1.0
        pgm_function18[(0, 3, 0, 1)] = 1.0
        pgm_function18[(0, 3, 0, 2)] = 1.0
        pgm_function18[(0, 3, 0, 3)] = 1.0
        pgm_function18[(0, 3, 0, 4)] = 0.95
        pgm_function18[(0, 3, 0, 5)] = 0.85
        pgm_function18[(0, 3, 0, 6)] = 0.7
        pgm_function18[(0, 3, 0, 7)] = 0.4
        pgm_function18[(0, 3, 0, 8)] = 0.2
        pgm_function18[(0, 3, 1, 0)] = 1.0
        pgm_function18[(0, 3, 1, 1)] = 1.0
        pgm_function18[(0, 3, 1, 2)] = 1.0
        pgm_function18[(0, 3, 1, 3)] = 1.0
        pgm_function18[(0, 3, 1, 4)] = 0.9
        pgm_function18[(0, 3, 1, 5)] = 0.8
        pgm_function18[(0, 3, 1, 6)] = 0.6
        pgm_function18[(0, 3, 1, 7)] = 0.2
        pgm_function18[(0, 3, 1, 8)] = 0.1
        pgm_function18[(0, 3, 2, 0)] = 1.0
        pgm_function18[(0, 3, 2, 1)] = 1.0
        pgm_function18[(0, 3, 2, 2)] = 1.0
        pgm_function18[(0, 3, 2, 3)] = 0.95
        pgm_function18[(0, 3, 2, 4)] = 0.8
        pgm_function18[(0, 3, 2, 5)] = 0.5
        pgm_function18[(0, 3, 2, 6)] = 0.3
        pgm_function18[(0, 3, 2, 7)] = 0.1
        pgm_function18[(0, 3, 2, 8)] = 0.05
        pgm_function18[(0, 3, 3, 0)] = 1.0
        pgm_function18[(0, 3, 3, 1)] = 1.0
        pgm_function18[(0, 3, 3, 2)] = 1.0
        pgm_function18[(0, 3, 3, 3)] = 0.9
        pgm_function18[(0, 3, 3, 4)] = 0.7
        pgm_function18[(0, 3, 3, 5)] = 0.4
        pgm_function18[(0, 3, 3, 6)] = 0.1
        pgm_function18[(0, 3, 3, 7)] = 0.05
        pgm_function18[(1, 0, 0, 1)] = 0.6
        pgm_function18[(1, 0, 0, 2)] = 0.3
        pgm_function18[(1, 0, 0, 3)] = 0.1
        pgm_function18[(1, 0, 0, 4)] = 0.1
        pgm_function18[(1, 0, 1, 1)] = 0.4
        pgm_function18[(1, 0, 1, 2)] = 0.1
        pgm_function18[(1, 0, 1, 3)] = 0.05
        pgm_function18[(1, 0, 2, 0)] = 0.1
        pgm_function18[(1, 0, 2, 1)] = 0.1
        pgm_function18[(1, 0, 2, 2)] = 0.05
        pgm_function18[(1, 0, 3, 0)] = 0.2
        pgm_function18[(1, 0, 3, 1)] = 0.1
        pgm_function18[(1, 1, 0, 2)] = 0.05
        pgm_function18[(1, 1, 0, 3)] = 0.05
        pgm_function18[(1, 1, 0, 4)] = 0.15
        pgm_function18[(1, 1, 0, 5)] = 0.3
        pgm_function18[(1, 1, 0, 6)] = 0.3
        pgm_function18[(1, 1, 0, 7)] = 0.1
        pgm_function18[(1, 1, 0, 8)] = 0.05
        pgm_function18[(1, 1, 1, 2)] = 0.05
        pgm_function18[(1, 1, 1, 3)] = 0.1
        pgm_function18[(1, 1, 1, 4)] = 0.15
        pgm_function18[(1, 1, 1, 5)] = 0.3
        pgm_function18[(1, 1, 1, 6)] = 0.25
        pgm_function18[(1, 1, 1, 7)] = 0.05
        pgm_function18[(1, 1, 2, 2)] = 0.05
        pgm_function18[(1, 1, 2, 3)] = 0.2
        pgm_function18[(1, 1, 2, 4)] = 0.3
        pgm_function18[(1, 1, 2, 5)] = 0.35
        pgm_function18[(1, 1, 2, 6)] = 0.15
        pgm_function18[(1, 1, 3, 2)] = 0.1
        pgm_function18[(1, 1, 3, 3)] = 0.25
        pgm_function18[(1, 1, 3, 4)] = 0.35
        pgm_function18[(1, 1, 3, 5)] = 0.3
        pgm_function18[(1, 1, 3, 6)] = 0.05
        pgm_function18[(1, 2, 0, 3)] = 0.05
        pgm_function18[(1, 2, 0, 4)] = 0.075
        pgm_function18[(1, 2, 0, 5)] = 0.225
        pgm_function18[(1, 2, 0, 6)] = 0.3
        pgm_function18[(1, 2, 0, 7)] = 0.3
        pgm_function18[(1, 2, 0, 8)] = 0.1
        pgm_function18[(1, 2, 1, 3)] = 0.05
        pgm_function18[(1, 2, 1, 4)] = 0.1
        pgm_function18[(1, 2, 1, 5)] = 0.3
        pgm_function18[(1, 2, 1, 6)] = 0.3
        pgm_function18[(1, 2, 1, 7)] = 0.3
        pgm_function18[(1, 2, 1, 8)] = 0.1
        pgm_function18[(1, 2, 2, 3)] = 0.075
        pgm_function18[(1, 2, 2, 4)] = 0.15
        pgm_function18[(1, 2, 2, 5)] = 0.35
        pgm_function18[(1, 2, 2, 6)] = 0.25
        pgm_function18[(1, 2, 2, 7)] = 0.1
        pgm_function18[(1, 2, 3, 2)] = 0.05
        pgm_function18[(1, 2, 3, 3)] = 0.1
        pgm_function18[(1, 2, 3, 4)] = 0.2
        pgm_function18[(1, 2, 3, 5)] = 0.3
        pgm_function18[(1, 2, 3, 6)] = 0.15
        pgm_function18[(1, 2, 3, 7)] = 0.05
        pgm_function18[(1, 3, 0, 4)] = 0.05
        pgm_function18[(1, 3, 0, 5)] = 0.1
        pgm_function18[(1, 3, 0, 6)] = 0.15
        pgm_function18[(1, 3, 0, 7)] = 0.35
        pgm_function18[(1, 3, 0, 8)] = 0.4
        pgm_function18[(1, 3, 1, 4)] = 0.075
        pgm_function18[(1, 3, 1, 5)] = 0.125
        pgm_function18[(1, 3, 1, 6)] = 0.2
        pgm_function18[(1, 3, 1, 7)] = 0.35
        pgm_function18[(1, 3, 1, 8)] = 0.3
        pgm_function18[(1, 3, 2, 3)] = 0.05
        pgm_function18[(1, 3, 2, 4)] = 0.15
        pgm_function18[(1, 3, 2, 5)] = 0.3
        pgm_function18[(1, 3, 2, 6)] = 0.35
        pgm_function18[(1, 3, 2, 7)] = 0.325
        pgm_function18[(1, 3, 2, 8)] = 0.15
        pgm_function18[(1, 3, 3, 3)] = 0.075
        pgm_function18[(1, 3, 3, 4)] = 0.2
        pgm_function18[(1, 3, 3, 5)] = 0.3
        pgm_function18[(1, 3, 3, 6)] = 0.4
        pgm_function18[(1, 3, 3, 7)] = 0.2
        pgm_function18[(1, 3, 3, 8)] = 0.1
        pgm_function18[(2, 0, 0, 1)] = 0.1
        pgm_function18[(2, 0, 0, 2)] = 0.5
        pgm_function18[(2, 0, 0, 3)] = 0.4
        pgm_function18[(2, 0, 0, 4)] = 0.1
        pgm_function18[(2, 0, 0, 5)] = 0.1
        pgm_function18[(2, 0, 1, 1)] = 0.3
        pgm_function18[(2, 0, 1, 2)] = 0.4
        pgm_function18[(2, 0, 1, 3)] = 0.15
        pgm_function18[(2, 0, 1, 4)] = 0.05
        pgm_function18[(2, 0, 2, 1)] = 0.25
        pgm_function18[(2, 0, 2, 2)] = 0.1
        pgm_function18[(2, 0, 2, 3)] = 0.05
        pgm_function18[(2, 0, 3, 0)] = 0.05
        pgm_function18[(2, 0, 3, 1)] = 0.2
        pgm_function18[(2, 0, 3, 2)] = 0.1
        pgm_function18[(2, 1, 0, 4)] = 0.05
        pgm_function18[(2, 1, 0, 5)] = 0.15
        pgm_function18[(2, 1, 0, 6)] = 0.3
        pgm_function18[(2, 1, 0, 7)] = 0.25
        pgm_function18[(2, 1, 0, 8)] = 0.1
        pgm_function18[(2, 1, 1, 4)] = 0.1
        pgm_function18[(2, 1, 1, 5)] = 0.2
        pgm_function18[(2, 1, 1, 6)] = 0.35
        pgm_function18[(2, 1, 1, 7)] = 0.25
        pgm_function18[(2, 1, 1, 8)] = 0.05
        pgm_function18[(2, 1, 2, 3)] = 0.1
        pgm_function18[(2, 1, 2, 4)] = 0.2
        pgm_function18[(2, 1, 2, 5)] = 0.3
        pgm_function18[(2, 1, 2, 6)] = 0.35
        pgm_function18[(2, 1, 2, 7)] = 0.15
        pgm_function18[(2, 1, 3, 2)] = 0.05
        pgm_function18[(2, 1, 3, 3)] = 0.1
        pgm_function18[(2, 1, 3, 4)] = 0.25
        pgm_function18[(2, 1, 3, 5)] = 0.3
        pgm_function18[(2, 1, 3, 6)] = 0.2
        pgm_function18[(2, 1, 3, 7)] = 0.05
        pgm_function18[(2, 2, 0, 4)] = 0.025
        pgm_function18[(2, 2, 0, 5)] = 0.1
        pgm_function18[(2, 2, 0, 6)] = 0.2
        pgm_function18[(2, 2, 0, 7)] = 0.25
        pgm_function18[(2, 2, 0, 8)] = 0.25
        pgm_function18[(2, 2, 1, 4)] = 0.05
        pgm_function18[(2, 2, 1, 5)] = 0.15
        pgm_function18[(2, 2, 1, 6)] = 0.25
        pgm_function18[(2, 2, 1, 7)] = 0.3
        pgm_function18[(2, 2, 1, 8)] = 0.2
        pgm_function18[(2, 2, 2, 3)] = 0.025
        pgm_function18[(2, 2, 2, 4)] = 0.075
        pgm_function18[(2, 2, 2, 5)] = 0.2
        pgm_function18[(2, 2, 2, 6)] = 0.3
        pgm_function18[(2, 2, 2, 7)] = 0.3
        pgm_function18[(2, 2, 2, 8)] = 0.1
        pgm_function18[(2, 2, 3, 3)] = 0.05
        pgm_function18[(2, 2, 3, 4)] = 0.1
        pgm_function18[(2, 2, 3, 5)] = 0.3
        pgm_function18[(2, 2, 3, 6)] = 0.3
        pgm_function18[(2, 2, 3, 7)] = 0.15
        pgm_function18[(2, 2, 3, 8)] = 0.05
        pgm_function18[(2, 3, 0, 5)] = 0.05
        pgm_function18[(2, 3, 0, 6)] = 0.1
        pgm_function18[(2, 3, 0, 7)] = 0.15
        pgm_function18[(2, 3, 0, 8)] = 0.2
        pgm_function18[(2, 3, 1, 4)] = 0.025
        pgm_function18[(2, 3, 1, 5)] = 0.05
        pgm_function18[(2, 3, 1, 6)] = 0.125
        pgm_function18[(2, 3, 1, 7)] = 0.25
        pgm_function18[(2, 3, 1, 8)] = 0.25
        pgm_function18[(2, 3, 2, 4)] = 0.05
        pgm_function18[(2, 3, 2, 5)] = 0.15
        pgm_function18[(2, 3, 2, 6)] = 0.2
        pgm_function18[(2, 3, 2, 7)] = 0.325
        pgm_function18[(2, 3, 2, 8)] = 0.3
        pgm_function18[(2, 3, 3, 3)] = 0.025
        pgm_function18[(2, 3, 3, 4)] = 0.075
        pgm_function18[(2, 3, 3, 5)] = 0.2
        pgm_function18[(2, 3, 3, 6)] = 0.25
        pgm_function18[(2, 3, 3, 7)] = 0.35
        pgm_function18[(2, 3, 3, 8)] = 0.25
        pgm_function18[(3, 0, 0, 2)] = 0.1
        pgm_function18[(3, 0, 0, 3)] = 0.3
        pgm_function18[(3, 0, 0, 4)] = 0.4
        pgm_function18[(3, 0, 0, 5)] = 0.1
        pgm_function18[(3, 0, 0, 6)] = 0.1
        pgm_function18[(3, 0, 1, 1)] = 0.1
        pgm_function18[(3, 0, 1, 2)] = 0.3
        pgm_function18[(3, 0, 1, 3)] = 0.4
        pgm_function18[(3, 0, 1, 4)] = 0.15
        pgm_function18[(3, 0, 1, 5)] = 0.05
        pgm_function18[(3, 0, 2, 1)] = 0.3
        pgm_function18[(3, 0, 2, 2)] = 0.25
        pgm_function18[(3, 0, 2, 3)] = 0.1
        pgm_function18[(3, 0, 2, 4)] = 0.05
        pgm_function18[(3, 0, 3, 1)] = 0.35
        pgm_function18[(3, 0, 3, 2)] = 0.2
        pgm_function18[(3, 0, 3, 3)] = 0.1
        pgm_function18[(3, 1, 0, 5)] = 0.05
        pgm_function18[(3, 1, 0, 6)] = 0.15
        pgm_function18[(3, 1, 0, 7)] = 0.25
        pgm_function18[(3, 1, 0, 8)] = 0.15
        pgm_function18[(3, 1, 1, 5)] = 0.1
        pgm_function18[(3, 1, 1, 6)] = 0.25
        pgm_function18[(3, 1, 1, 7)] = 0.3
        pgm_function18[(3, 1, 1, 8)] = 0.1
        pgm_function18[(3, 1, 2, 4)] = 0.1
        pgm_function18[(3, 1, 2, 5)] = 0.2
        pgm_function18[(3, 1, 2, 6)] = 0.3
        pgm_function18[(3, 1, 2, 7)] = 0.35
        pgm_function18[(3, 1, 2, 8)] = 0.05
        pgm_function18[(3, 1, 3, 3)] = 0.05
        pgm_function18[(3, 1, 3, 4)] = 0.1
        pgm_function18[(3, 1, 3, 5)] = 0.2
        pgm_function18[(3, 1, 3, 6)] = 0.35
        pgm_function18[(3, 1, 3, 7)] = 0.2
        pgm_function18[(3, 1, 3, 8)] = 0.05
        pgm_function18[(3, 2, 0, 5)] = 0.025
        pgm_function18[(3, 2, 0, 6)] = 0.075
        pgm_function18[(3, 2, 0, 7)] = 0.15
        pgm_function18[(3, 2, 0, 8)] = 0.25
        pgm_function18[(3, 2, 1, 5)] = 0.05
        pgm_function18[(3, 2, 1, 6)] = 0.1
        pgm_function18[(3, 2, 1, 7)] = 0.15
        pgm_function18[(3, 2, 1, 8)] = 0.25
        pgm_function18[(3, 2, 2, 4)] = 0.025
        pgm_function18[(3, 2, 2, 5)] = 0.1
        pgm_function18[(3, 2, 2, 6)] = 0.2
        pgm_function18[(3, 2, 2, 7)] = 0.3
        pgm_function18[(3, 2, 2, 8)] = 0.25
        pgm_function18[(3, 2, 3, 4)] = 0.05
        pgm_function18[(3, 2, 3, 5)] = 0.15
        pgm_function18[(3, 2, 3, 6)] = 0.3
        pgm_function18[(3, 2, 3, 7)] = 0.3
        pgm_function18[(3, 2, 3, 8)] = 0.15
        pgm_function18[(3, 3, 0, 6)] = 0.05
        pgm_function18[(3, 3, 0, 7)] = 0.075
        pgm_function18[(3, 3, 0, 8)] = 0.1
        pgm_function18[(3, 3, 1, 5)] = 0.025
        pgm_function18[(3, 3, 1, 6)] = 0.05
        pgm_function18[(3, 3, 1, 7)] = 0.125
        pgm_function18[(3, 3, 1, 8)] = 0.175
        pgm_function18[(3, 3, 2, 5)] = 0.05
        pgm_function18[(3, 3, 2, 6)] = 0.1
        pgm_function18[(3, 3, 2, 7)] = 0.15
        pgm_function18[(3, 3, 2, 8)] = 0.25
        pgm_function18[(3, 3, 3, 4)] = 0.025
        pgm_function18[(3, 3, 3, 5)] = 0.075
        pgm_function18[(3, 3, 3, 6)] = 0.15
        pgm_function18[(3, 3, 3, 7)] = 0.2
        pgm_function18[(3, 3, 3, 8)] = 0.3
        pgm_function18[(4, 0, 0, 3)] = 0.1
        pgm_function18[(4, 0, 0, 4)] = 0.3
        pgm_function18[(4, 0, 0, 5)] = 0.4
        pgm_function18[(4, 0, 0, 6)] = 0.1
        pgm_function18[(4, 0, 0, 7)] = 0.1
        pgm_function18[(4, 0, 1, 2)] = 0.1
        pgm_function18[(4, 0, 1, 3)] = 0.3
        pgm_function18[(4, 0, 1, 4)] = 0.4
        pgm_function18[(4, 0, 1, 5)] = 0.15
        pgm_function18[(4, 0, 1, 6)] = 0.05
        pgm_function18[(4, 0, 1, 7)] = 0.05
        pgm_function18[(4, 0, 2, 1)] = 0.25
        pgm_function18[(4, 0, 2, 2)] = 0.3
        pgm_function18[(4, 0, 2, 3)] = 0.25
        pgm_function18[(4, 0, 2, 4)] = 0.1
        pgm_function18[(4, 0, 2, 5)] = 0.05
        pgm_function18[(4, 0, 3, 1)] = 0.25
        pgm_function18[(4, 0, 3, 2)] = 0.35
        pgm_function18[(4, 0, 3, 3)] = 0.2
        pgm_function18[(4, 0, 3, 4)] = 0.1
        pgm_function18[(4, 1, 0, 6)] = 0.05
        pgm_function18[(4, 1, 0, 7)] = 0.25
        pgm_function18[(4, 1, 0, 8)] = 0.25
        pgm_function18[(4, 1, 1, 6)] = 0.05
        pgm_function18[(4, 1, 1, 7)] = 0.3
        pgm_function18[(4, 1, 1, 8)] = 0.3
        pgm_function18[(4, 1, 2, 5)] = 0.05
        pgm_function18[(4, 1, 2, 6)] = 0.15
        pgm_function18[(4, 1, 2, 7)] = 0.35
        pgm_function18[(4, 1, 2, 8)] = 0.25
        pgm_function18[(4, 1, 3, 4)] = 0.05
        pgm_function18[(4, 1, 3, 5)] = 0.1
        pgm_function18[(4, 1, 3, 6)] = 0.25
        pgm_function18[(4, 1, 3, 7)] = 0.3
        pgm_function18[(4, 1, 3, 8)] = 0.1
        pgm_function18[(4, 2, 0, 6)] = 0.025
        pgm_function18[(4, 2, 0, 7)] = 0.075
        pgm_function18[(4, 2, 0, 8)] = 0.25
        pgm_function18[(4, 2, 1, 6)] = 0.05
        pgm_function18[(4, 2, 1, 7)] = 0.1
        pgm_function18[(4, 2, 1, 8)] = 0.3
        pgm_function18[(4, 2, 2, 5)] = 0.05
        pgm_function18[(4, 2, 2, 6)] = 0.1
        pgm_function18[(4, 2, 2, 7)] = 0.15
        pgm_function18[(4, 2, 2, 8)] = 0.3
        pgm_function18[(4, 2, 3, 5)] = 0.05
        pgm_function18[(4, 2, 3, 6)] = 0.15
        pgm_function18[(4, 2, 3, 7)] = 0.3
        pgm_function18[(4, 2, 3, 8)] = 0.3
        pgm_function18[(4, 3, 0, 7)] = 0.025
        pgm_function18[(4, 3, 0, 8)] = 0.075
        pgm_function18[(4, 3, 1, 6)] = 0.025
        pgm_function18[(4, 3, 1, 7)] = 0.05
        pgm_function18[(4, 3, 1, 8)] = 0.1
        pgm_function18[(4, 3, 2, 6)] = 0.05
        pgm_function18[(4, 3, 2, 7)] = 0.075
        pgm_function18[(4, 3, 2, 8)] = 0.15
        pgm_function18[(4, 3, 3, 5)] = 0.025
        pgm_function18[(4, 3, 3, 6)] = 0.075
        pgm_function18[(4, 3, 3, 7)] = 0.1
        pgm_function18[(4, 3, 3, 8)] = 0.175
        pgm_function18[(5, 0, 0, 4)] = 0.1
        pgm_function18[(5, 0, 0, 5)] = 0.3
        pgm_function18[(5, 0, 0, 6)] = 0.4
        pgm_function18[(5, 0, 0, 7)] = 0.2
        pgm_function18[(5, 0, 0, 8)] = 0.1
        pgm_function18[(5, 0, 1, 3)] = 0.1
        pgm_function18[(5, 0, 1, 4)] = 0.3
        pgm_function18[(5, 0, 1, 5)] = 0.4
        pgm_function18[(5, 0, 1, 6)] = 0.15
        pgm_function18[(5, 0, 1, 7)] = 0.15
        pgm_function18[(5, 0, 1, 8)] = 0.1
        pgm_function18[(5, 0, 2, 1)] = 0.05
        pgm_function18[(5, 0, 2, 2)] = 0.25
        pgm_function18[(5, 0, 2, 3)] = 0.3
        pgm_function18[(5, 0, 2, 4)] = 0.25
        pgm_function18[(5, 0, 2, 5)] = 0.1
        pgm_function18[(5, 0, 2, 6)] = 0.05
        pgm_function18[(5, 0, 3, 1)] = 0.1
        pgm_function18[(5, 0, 3, 2)] = 0.25
        pgm_function18[(5, 0, 3, 3)] = 0.35
        pgm_function18[(5, 0, 3, 4)] = 0.2
        pgm_function18[(5, 0, 3, 5)] = 0.1
        pgm_function18[(5, 1, 0, 7)] = 0.1
        pgm_function18[(5, 1, 0, 8)] = 0.25
        pgm_function18[(5, 1, 1, 7)] = 0.1
        pgm_function18[(5, 1, 1, 8)] = 0.35
        pgm_function18[(5, 1, 2, 6)] = 0.05
        pgm_function18[(5, 1, 2, 7)] = 0.1
        pgm_function18[(5, 1, 2, 8)] = 0.35
        pgm_function18[(5, 1, 3, 5)] = 0.05
        pgm_function18[(5, 1, 3, 6)] = 0.1
        pgm_function18[(5, 1, 3, 7)] = 0.3
        pgm_function18[(5, 1, 3, 8)] = 0.25
        pgm_function18[(5, 2, 0, 7)] = 0.025
        pgm_function18[(5, 2, 0, 8)] = 0.075
        pgm_function18[(5, 2, 1, 7)] = 0.05
        pgm_function18[(5, 2, 1, 8)] = 0.1
        pgm_function18[(5, 2, 2, 6)] = 0.05
        pgm_function18[(5, 2, 2, 7)] = 0.1
        pgm_function18[(5, 2, 2, 8)] = 0.2
        pgm_function18[(5, 2, 3, 6)] = 0.05
        pgm_function18[(5, 2, 3, 7)] = 0.15
        pgm_function18[(5, 2, 3, 8)] = 0.3
        pgm_function18[(5, 3, 0, 8)] = 0.025
        pgm_function18[(5, 3, 1, 7)] = 0.025
        pgm_function18[(5, 3, 1, 8)] = 0.05
        pgm_function18[(5, 3, 2, 7)] = 0.025
        pgm_function18[(5, 3, 2, 8)] = 0.075
        pgm_function18[(5, 3, 3, 6)] = 0.025
        pgm_function18[(5, 3, 3, 7)] = 0.075
        pgm_function18[(5, 3, 3, 8)] = 0.1
        pgm_function18[(6, 0, 0, 5)] = 0.1
        pgm_function18[(6, 0, 0, 6)] = 0.3
        pgm_function18[(6, 0, 0, 7)] = 0.4
        pgm_function18[(6, 0, 0, 8)] = 0.1
        pgm_function18[(6, 0, 1, 4)] = 0.1
        pgm_function18[(6, 0, 1, 5)] = 0.3
        pgm_function18[(6, 0, 1, 6)] = 0.4
        pgm_function18[(6, 0, 1, 7)] = 0.2
        pgm_function18[(6, 0, 1, 8)] = 0.1
        pgm_function18[(6, 0, 2, 2)] = 0.05
        pgm_function18[(6, 0, 2, 3)] = 0.25
        pgm_function18[(6, 0, 2, 4)] = 0.3
        pgm_function18[(6, 0, 2, 5)] = 0.25
        pgm_function18[(6, 0, 2, 6)] = 0.1
        pgm_function18[(6, 0, 2, 7)] = 0.05
        pgm_function18[(6, 0, 3, 2)] = 0.1
        pgm_function18[(6, 0, 3, 3)] = 0.25
        pgm_function18[(6, 0, 3, 4)] = 0.35
        pgm_function18[(6, 0, 3, 5)] = 0.2
        pgm_function18[(6, 0, 3, 6)] = 0.1
        pgm_function18[(6, 1, 0, 8)] = 0.15
        pgm_function18[(6, 1, 1, 8)] = 0.15
        pgm_function18[(6, 1, 2, 7)] = 0.05
        pgm_function18[(6, 1, 2, 8)] = 0.25
        pgm_function18[(6, 1, 3, 6)] = 0.05
        pgm_function18[(6, 1, 3, 7)] = 0.1
        pgm_function18[(6, 1, 3, 8)] = 0.35
        pgm_function18[(6, 2, 0, 8)] = 0.025
        pgm_function18[(6, 2, 1, 8)] = 0.05
        pgm_function18[(6, 2, 2, 7)] = 0.05
        pgm_function18[(6, 2, 2, 8)] = 0.1
        pgm_function18[(6, 2, 3, 7)] = 0.05
        pgm_function18[(6, 2, 3, 8)] = 0.15
        pgm_function18[(6, 3, 1, 8)] = 0.025
        pgm_function18[(6, 3, 2, 8)] = 0.025
        pgm_function18[(6, 3, 3, 7)] = 0.025
        pgm_function18[(6, 3, 3, 8)] = 0.05
        pgm_function18[(7, 0, 0, 6)] = 0.1
        pgm_function18[(7, 0, 0, 7)] = 0.2
        pgm_function18[(7, 0, 0, 8)] = 0.5
        pgm_function18[(7, 0, 1, 5)] = 0.1
        pgm_function18[(7, 0, 1, 6)] = 0.3
        pgm_function18[(7, 0, 1, 7)] = 0.4
        pgm_function18[(7, 0, 1, 8)] = 0.3
        pgm_function18[(7, 0, 2, 3)] = 0.05
        pgm_function18[(7, 0, 2, 4)] = 0.25
        pgm_function18[(7, 0, 2, 5)] = 0.35
        pgm_function18[(7, 0, 2, 6)] = 0.25
        pgm_function18[(7, 0, 2, 7)] = 0.15
        pgm_function18[(7, 0, 2, 8)] = 0.05
        pgm_function18[(7, 0, 3, 3)] = 0.1
        pgm_function18[(7, 0, 3, 4)] = 0.25
        pgm_function18[(7, 0, 3, 5)] = 0.4
        pgm_function18[(7, 0, 3, 6)] = 0.25
        pgm_function18[(7, 0, 3, 7)] = 0.1
        pgm_function18[(7, 0, 3, 8)] = 0.05
        pgm_function18[(7, 1, 0, 8)] = 0.05
        pgm_function18[(7, 1, 1, 8)] = 0.05
        pgm_function18[(7, 1, 2, 8)] = 0.1
        pgm_function18[(7, 1, 3, 7)] = 0.05
        pgm_function18[(7, 1, 3, 8)] = 0.2
        pgm_function18[(7, 2, 2, 8)] = 0.05
        pgm_function18[(7, 2, 3, 8)] = 0.05
        pgm_function18[(7, 3, 3, 8)] = 0.025
        pgm_function18[(8, 0, 0, 7)] = 0.1
        pgm_function18[(8, 0, 0, 8)] = 0.3
        pgm_function18[(8, 0, 1, 6)] = 0.1
        pgm_function18[(8, 0, 1, 7)] = 0.2
        pgm_function18[(8, 0, 1, 8)] = 0.5
        pgm_function18[(8, 0, 2, 4)] = 0.05
        pgm_function18[(8, 0, 2, 5)] = 0.25
        pgm_function18[(8, 0, 2, 6)] = 0.6
        pgm_function18[(8, 0, 2, 7)] = 0.8
        pgm_function18[(8, 0, 2, 8)] = 0.95
        pgm_function18[(8, 0, 3, 4)] = 0.1
        pgm_function18[(8, 0, 3, 5)] = 0.3
        pgm_function18[(8, 0, 3, 6)] = 0.65
        pgm_function18[(8, 0, 3, 7)] = 0.9
        pgm_function18[(8, 0, 3, 8)] = 0.95
        pgm_function18[(8, 1, 3, 8)] = 0.05

        pgm_function19 = pgm_factor19.set_sparse()
        pgm_function19[(0, 0, 0)] = 1.0
        pgm_function19[(0, 0, 1)] = 1.0
        pgm_function19[(0, 0, 2)] = 1.0
        pgm_function19[(0, 0, 3)] = 0.9922
        pgm_function19[(0, 0, 4)] = 0.8378
        pgm_function19[(0, 0, 5)] = 0.492249384
        pgm_function19[(0, 0, 6)] = 0.165583184
        pgm_function19[(0, 0, 7)] = 0.01890191
        pgm_function19[(0, 1, 0)] = 1.0
        pgm_function19[(0, 1, 1)] = 0.9956
        pgm_function19[(0, 1, 2)] = 0.894489698
        pgm_function19[(0, 1, 3)] = 0.616638499
        pgm_function19[(0, 1, 4)] = 0.2767
        pgm_function19[(0, 1, 5)] = 0.0644
        pgm_function19[(0, 1, 6)] = 0.002199781
        pgm_function19[(0, 2, 0)] = 0.8967
        pgm_function19[(0, 2, 1)] = 0.6567
        pgm_function19[(0, 2, 2)] = 0.3089
        pgm_function19[(0, 2, 3)] = 0.08110816
        pgm_function19[(0, 2, 4)] = 0.004400441
        pgm_function19[(0, 3, 0)] = 0.29777033
        pgm_function19[(0, 3, 1)] = 0.0967
        pgm_function19[(0, 3, 2)] = 0.0067
        pgm_function19[(0, 4, 0)] = 0.0056
        pgm_function19[(1, 0, 3)] = 0.0078
        pgm_function19[(1, 0, 4)] = 0.1578
        pgm_function19[(1, 0, 5)] = 0.371137289
        pgm_function19[(1, 0, 6)] = 0.355564395
        pgm_function19[(1, 0, 7)] = 0.17221712
        pgm_function19[(1, 0, 8)] = 0.0267
        pgm_function19[(1, 1, 1)] = 0.0044
        pgm_function19[(1, 1, 2)] = 0.103310081
        pgm_function19[(1, 1, 3)] = 0.295570239
        pgm_function19[(1, 1, 4)] = 0.3678
        pgm_function19[(1, 1, 5)] = 0.2411
        pgm_function19[(1, 1, 6)] = 0.075592439
        pgm_function19[(1, 1, 7)] = 0.004399564
        pgm_function19[(1, 2, 0)] = 0.1033
        pgm_function19[(1, 2, 1)] = 0.2744
        pgm_function19[(1, 2, 2)] = 0.3744
        pgm_function19[(1, 2, 3)] = 0.25782618
        pgm_function19[(1, 2, 4)] = 0.091109124
        pgm_function19[(1, 2, 5)] = 0.006700676
        pgm_function19[(1, 3, 0)] = 0.38556142
        pgm_function19[(1, 3, 1)] = 0.2789
        pgm_function19[(1, 3, 2)] = 0.1078
        pgm_function19[(1, 3, 3)] = 0.0111
        pgm_function19[(1, 4, 0)] = 0.0967
        pgm_function19[(1, 4, 1)] = 0.0156
        pgm_function19[(2, 0, 4)] = 0.0044
        pgm_function19[(2, 0, 5)] = 0.134413105
        pgm_function19[(2, 0, 6)] = 0.362164402
        pgm_function19[(2, 0, 7)] = 0.36223625
        pgm_function19[(2, 0, 8)] = 0.1933
        pgm_function19[(2, 0, 9)] = 0.0344
        pgm_function19[(2, 1, 2)] = 0.002200222
        pgm_function19[(2, 1, 3)] = 0.08669137
        pgm_function19[(2, 1, 4)] = 0.2833
        pgm_function19[(2, 1, 5)] = 0.37
        pgm_function19[(2, 1, 6)] = 0.258874135
        pgm_function19[(2, 1, 7)] = 0.086691373
        pgm_function19[(2, 1, 8)] = 0.0067
        pgm_function19[(2, 2, 1)] = 0.0689
        pgm_function19[(2, 2, 2)] = 0.2611
        pgm_function19[(2, 2, 3)] = 0.37443726
        pgm_function19[(2, 2, 4)] = 0.274427071
        pgm_function19[(2, 2, 5)] = 0.104410097
        pgm_function19[(2, 2, 6)] = 0.01109891
        pgm_function19[(2, 3, 0)] = 0.26557329
        pgm_function19[(2, 3, 1)] = 0.3722
        pgm_function19[(2, 3, 2)] = 0.2944
        pgm_function19[(2, 3, 3)] = 0.1211
        pgm_function19[(2, 3, 4)] = 0.0156
        pgm_function19[(2, 4, 0)] = 0.3
        pgm_function19[(2, 4, 1)] = 0.1378
        pgm_function19[(2, 4, 2)] = 0.0211
        pgm_function19[(2, 5, 0)] = 0.016698319
        pgm_function19[(3, 0, 5)] = 0.002200222
        pgm_function19[(3, 0, 6)] = 0.115588128
        pgm_function19[(3, 0, 7)] = 0.35223525
        pgm_function19[(3, 0, 8)] = 0.3667
        pgm_function19[(3, 0, 9)] = 0.21
        pgm_function19[(3, 0, 10)] = 0.0433
        pgm_function19[(3, 1, 3)] = 0.001099891
        pgm_function19[(3, 1, 4)] = 0.0722
        pgm_function19[(3, 1, 5)] = 0.2667
        pgm_function19[(3, 1, 6)] = 0.368863192
        pgm_function19[(3, 1, 7)] = 0.275572231
        pgm_function19[(3, 1, 8)] = 0.1011
        pgm_function19[(3, 1, 9)] = 0.01000101
        pgm_function19[(3, 2, 2)] = 0.0556
        pgm_function19[(3, 2, 3)] = 0.24442417
        pgm_function19[(3, 2, 4)] = 0.368937096
        pgm_function19[(3, 2, 5)] = 0.293329273
        pgm_function19[(3, 2, 6)] = 0.11668812
        pgm_function19[(3, 2, 7)] = 0.0156
        pgm_function19[(3, 3, 0)] = 0.05109496
        pgm_function19[(3, 3, 1)] = 0.22
        pgm_function19[(3, 3, 2)] = 0.3678
        pgm_function19[(3, 3, 3)] = 0.3056
        pgm_function19[(3, 3, 4)] = 0.1378
        pgm_function19[(3, 3, 5)] = 0.019998016
        pgm_function19[(3, 4, 0)] = 0.3722
        pgm_function19[(3, 4, 1)] = 0.3278
        pgm_function19[(3, 4, 2)] = 0.1544
        pgm_function19[(3, 4, 3)] = 0.028902919
        pgm_function19[(3, 5, 0)] = 0.15778418
        pgm_function19[(3, 5, 1)] = 0.03669633
        pgm_function19[(4, 0, 6)] = 0.001099891
        pgm_function19[(4, 0, 7)] = 0.09440947
        pgm_function19[(4, 0, 8)] = 0.3389
        pgm_function19[(4, 0, 9)] = 0.3811
        pgm_function19[(4, 0, 10)] = 0.2256
        pgm_function19[(4, 0, 11)] = 0.05220523
        pgm_function19[(4, 1, 5)] = 0.0578
        pgm_function19[(4, 1, 6)] = 0.247775129
        pgm_function19[(4, 1, 7)] = 0.367763309
        pgm_function19[(4, 1, 8)] = 0.29
        pgm_function19[(4, 1, 9)] = 0.11441107
        pgm_function19[(4, 1, 10)] = 0.0155969
        pgm_function19[(4, 2, 3)] = 0.04220423
        pgm_function19[(4, 2, 4)] = 0.22892306
        pgm_function19[(4, 2, 5)] = 0.362236337
        pgm_function19[(4, 2, 6)] = 0.30776931
        pgm_function19[(4, 2, 7)] = 0.1322
        pgm_function19[(4, 2, 8)] = 0.02
        pgm_function19[(4, 3, 1)] = 0.0322
        pgm_function19[(4, 3, 2)] = 0.1989
        pgm_function19[(4, 3, 3)] = 0.3622
        pgm_function19[(4, 3, 4)] = 0.3189
        pgm_function19[(4, 3, 5)] = 0.151085118
        pgm_function19[(4, 3, 6)] = 0.027802821
        pgm_function19[(4, 4, 0)] = 0.2033
        pgm_function19[(4, 4, 1)] = 0.3522
        pgm_function19[(4, 4, 2)] = 0.3367
        pgm_function19[(4, 4, 3)] = 0.171117113
        pgm_function19[(4, 4, 4)] = 0.035596429
        pgm_function19[(4, 5, 0)] = 0.335566383
        pgm_function19[(4, 5, 1)] = 0.191081157
        pgm_function19[(4, 5, 2)] = 0.0456
        pgm_function19[(4, 5, 3)] = 0.001099891
        pgm_function19[(4, 6, 0)] = 0.0378
        pgm_function19[(4, 6, 1)] = 0.0022
        pgm_function19[(5, 0, 8)] = 0.0744
        pgm_function19[(5, 0, 9)] = 0.3167
        pgm_function19[(5, 0, 10)] = 0.39
        pgm_function19[(5, 0, 11)] = 0.25002515
        pgm_function19[(5, 0, 12)] = 0.06220622
        pgm_function19[(5, 1, 6)] = 0.046695324
        pgm_function19[(5, 1, 7)] = 0.228877192
        pgm_function19[(5, 1, 8)] = 0.3644
        pgm_function19[(5, 1, 9)] = 0.30563118
        pgm_function19[(5, 1, 10)] = 0.12887396
        pgm_function19[(5, 1, 11)] = 0.02
        pgm_function19[(5, 2, 4)] = 0.032203208
        pgm_function19[(5, 2, 5)] = 0.208921194
        pgm_function19[(5, 2, 6)] = 0.35776436
        pgm_function19[(5, 2, 7)] = 0.3211
        pgm_function19[(5, 2, 8)] = 0.1467
        pgm_function19[(5, 2, 9)] = 0.0278
        pgm_function19[(5, 3, 2)] = 0.0244
        pgm_function19[(5, 3, 3)] = 0.1822
        pgm_function19[(5, 3, 4)] = 0.3522
        pgm_function19[(5, 3, 5)] = 0.335566262
        pgm_function19[(5, 3, 6)] = 0.168917128
        pgm_function19[(5, 3, 7)] = 0.034406881
        pgm_function19[(5, 4, 0)] = 0.0222
        pgm_function19[(5, 4, 1)] = 0.1544
        pgm_function19[(5, 4, 2)] = 0.3422
        pgm_function19[(5, 4, 3)] = 0.343334227
        pgm_function19[(5, 4, 4)] = 0.188881155
        pgm_function19[(5, 4, 5)] = 0.0444
        pgm_function19[(5, 5, 0)] = 0.347765396
        pgm_function19[(5, 5, 1)] = 0.355564292
        pgm_function19[(5, 5, 2)] = 0.2089
        pgm_function19[(5, 5, 3)] = 0.055594439
        pgm_function19[(5, 5, 4)] = 0.0022
        pgm_function19[(5, 6, 0)] = 0.2078
        pgm_function19[(5, 6, 1)] = 0.0656
        pgm_function19[(5, 6, 2)] = 0.004400442
        pgm_function19[(6, 0, 9)] = 0.0578
        pgm_function19[(6, 0, 10)] = 0.3
        pgm_function19[(6, 0, 11)] = 0.38333823
        pgm_function19[(6, 0, 12)] = 0.27222711
        pgm_function19[(6, 0, 13)] = 0.07779225
        pgm_function19[(6, 1, 7)] = 0.036696331
        pgm_function19[(6, 1, 8)] = 0.2078
        pgm_function19[(6, 1, 9)] = 0.36223622
        pgm_function19[(6, 1, 10)] = 0.31553691
        pgm_function19[(6, 1, 11)] = 0.1444
        pgm_function19[(6, 1, 12)] = 0.0267
        pgm_function19[(6, 2, 5)] = 0.024402423
        pgm_function19[(6, 2, 6)] = 0.18778119
        pgm_function19[(6, 2, 7)] = 0.3489
        pgm_function19[(6, 2, 8)] = 0.3344
        pgm_function19[(6, 2, 9)] = 0.1644
        pgm_function19[(6, 2, 10)] = 0.034403406
        pgm_function19[(6, 3, 3)] = 0.0178
        pgm_function19[(6, 3, 4)] = 0.1633
        pgm_function19[(6, 3, 5)] = 0.339966265
        pgm_function19[(6, 3, 6)] = 0.344434262
        pgm_function19[(6, 3, 7)] = 0.184436897
        pgm_function19[(6, 3, 8)] = 0.04330431
        pgm_function19[(6, 4, 1)] = 0.0122
        pgm_function19[(6, 4, 2)] = 0.1378
        pgm_function19[(6, 4, 3)] = 0.331133219
        pgm_function19[(6, 4, 4)] = 0.351065288
        pgm_function19[(6, 4, 5)] = 0.2067
        pgm_function19[(6, 4, 6)] = 0.0533
        pgm_function19[(6, 4, 7)] = 0.002200221
        pgm_function19[(6, 5, 0)] = 0.137786157
        pgm_function19[(6, 5, 1)] = 0.315568259
        pgm_function19[(6, 5, 2)] = 0.3611
        pgm_function19[(6, 5, 3)] = 0.226677161
        pgm_function19[(6, 5, 4)] = 0.0633
        pgm_function19[(6, 5, 5)] = 0.004400442
        pg