# Copyright 2018-2024 contributors to the OpenLineage project
# SPDX-License-Identifier: Apache-2.0

from __future__ import annotations

from typing import ClassVar

from attr import define, field
from openlineage.client.generated.base import RunFacet


@define
class ErrorMessageRunFacet(RunFacet):
    message: str
    """A human-readable string representing error message generated by observed system"""

    programmingLanguage: str  # noqa: N815
    """Programming language the observed system uses."""

    stackTrace: str | None = field(default=None)  # noqa: N815
    """A language-specific stack trace generated by observed system"""

    _additional_skip_redact: ClassVar[list[str]] = ["programmingLanguage"]

    @staticmethod
    def _get_schema() -> str:
        return (
            "https://openlineage.io/spec/facets/1-0-1/ErrorMessageRunFacet.json#/$defs/ErrorMessageRunFacet"
        )
