import unittest
import json

import sys

from etk.extractors.html_content_extractor import HTMLContentExtractor, Strategy


class TestGlossaryExtractor(unittest.TestCase):

    def test_html_content_extractor(self) -> None:
        hce = HTMLContentExtractor()

        with open('etk/unit_tests/ground_truth/sample_html.jl', 'r') as f:
            sample_html = json.load(f)

        test_html = sample_html["raw_content"]

        all_text = hce.extract(test_html, strategy=Strategy.ALL_TEXT)[0].value
        main_strict = hce.extract(test_html, strategy=Strategy.MAIN_CONTENT_STRICT)[0].value
        main_relax = hce.extract(test_html, strategy=Strategy.MAIN_CONTENT_RELAXED)[0].value

        expected_all_text = """         323-452-2013 Los Angeles Escort Listing View Escorts in other cities            smoothlegs24 28    chrissy391 27    My name is Helena height 160cms weight 55 kilos  contact me at escort.here@gmail.com           jefferson ave         age: 23 HrumpMeNow 28    xxtradition 24    jumblyjumb 26    claudia77 26    gushinPuss 28    Littlexdit 25    PinkSweets2 28    withoutlimit 27    bothOfUs3 28    lovelylips 27    killerbod 27    Littlexdit 27    azneyes 23      323-452-2013 ESCORT ALERT! - Luna The Hot Playmate (323) 452-2013 - 23  Escort's Phone:   323-452-2013    Escort's Location: Los Angeles, California  Escort's Age:  23  Date of Escort Post:  Jan 02nd 6:46am  REVIEWS:   READ AND CREATE REVIEWS FOR THIS ESCORT         There are 50 girls looking in . VIEW GIRLS  Hey I'm luna 3234522013 Let's explore , embrace and indulge in your favorite fantasy % independent. discreet no drama Firm Thighs and Sexy. My Soft skin & Tight Grip is exactly what you deserve Call or text Fetish friendly Fantasy friendly Party friendly 140 Hr SPECIALS 3234522013.\u00a0Call 323-452-2013 . Me and my friends are on EZsex soooo you can find us all on there if you want... skittlegirl       Call me on my cell at 323-452-2013. Date of ad: 2017-01-02 06:46:00  More posts from 323-452-2013  323-452-2013  Nov 04, 2016 Guess whose New with 80Specials (323) 452-2013 - 21         Recent Escort Classifieds  North Jersey, New Jersey (732-621-4443)  :*: G O O D G I R L :*: G O N E *:**: B A D ;) LATINA - 21  Chicago, Illinois (773-412-2044)  ( LAtE NiGHt ) UNRUShEd (ULTiMAtE) PLEASURE (*AmAziNg Azz*) CHOOSE..W...  Chicago, Illinois (414-914-3777)  Petite. and Sweet. Super new and Ready... in out call - 21  Chicago, Illinois (312-600-8628)  CM Get PAMPERED - 22  Ft Lauderdale, Florida (786-504-1860)  you will ME. GORGEOUSLY sexy LATIN - 21  Atlanta, Georgia (401-324-9388)  WoW. MuSt TaKe A LoOk At ThIs. - 21  Atlanta, Georgia (347-940-1982)  SMOKiNG HOT Specials BuSTy BaBe (( 5 SeRvICe )) Pretty 36DDDs ( ) ( ...  Atlanta, Georgia (305-849-8140)  Here to please all your desiresCALL ME 100% Real Curvy White Girl. - 21  Houston, Texas (832-914-9667)  Beautiful Salvadorean The One And Only(: - 21  Phoenix, Arizona (623-500-7076)  NEW GIRL PERSIAN Gem EXotIC Blend - 21  Toronto, Ontario (416-554-3337)  (L) (L) ~~~Special 80 for 20 min:) 22YeAr oLd $$exyy LaTiNa BoMbSheLL~~(L...  Toronto, Ontario (416-520-5198)  **21 years old * $80 **real pictures ** A sian Kathy *** - 21  Toronto, Ontario (647-702-6825)  **: :** 18 Yr Old Mercedes **: :** Incalls/Outcalls (647)702-6825 - 1...  Toronto, Ontario (416-275-1296)  100% real pictures ** True college sweet heart ** Taiwan Kelly ** 416-275...  Northern Virginia, DC (206-922-9303)  SPECIALs 60/90/150 FuN & WiLd BrUnEtTe ThIcK & BuSty JUSt THe WAy U LIKe ...  Chicago, Illinois (608-609-5899)  New To Town Dont Miss Me 100$ Specials - 18  Dallas, Texas (469-510-5849)  JENNY ...A New RedHeaded Firecracker. YeeHaw. - 21  New York, New York (442-222-0227)  F R E A K Y __ O B S E S S I O N UPSCALE UNRUSHED-100%...  New York, New York (917-676-1333)  SuPeR SpEciALs Red BoNe ThiCk Incalls - 19  Houston, Texas (301-000-6018)  (Jamaican Ebony Goddess) petite sexy spontaneous UPSCALE discreet dates M...     Site Map  Call this Escort at 323-452-2013  View escorts in other cities  Register Here  Login to your account  Key for Escort Acronyms  Top 10 Escort Practices  Prostitution Laws Around the World  Prostitution Laws In Your State       Top Escort Cities  New York, New York  Toronto, Ontario  Dallas, Texas  Chicago, Illinois  Atlanta, Georgia  North Jersey, New Jersey  Detroit, Michigan  Los Angeles, California  San Diego, California  Orange County, California  Houston, Texas  Phoenix, Arizona  Philadelphia, Pennsylvania  Boston, Massachusetts  Washington DC, DC  Orlando, Florida  Las Vegas, Nevada  Miami, Florida     Recent Blog Posts  Sheriff candidate Minister and Detective Reno Fells arrested in prostitution bust Man gets 35 years for impersonating cop to get free sex from hooker Alexander Marino: Psychologist by Day, Pimp by Night Surfside Beach, SC Prostitution BUST: Video College Park, Maryland Prostitution Sting: 30 arrested SMU Players Robbed By Escort Study: 1 in 6 Sex Offenders Live Double Life Dark Knight Rises Suspect Killer James Holmes Bought Prostitutes Online Hookers Picked Up Off the Street Hookers paid extra for photos     Links  Escorts on Webcam  Ad Removal Form  Contact Us         Search Box   Search For Profiles   Register Here  Login to your account  Non Mobile Version  Escort Blog  Key for Escort Acronyms  Top 10 Escort Practices  Escort Reviews  See Escorts on Webcam  Prostitution Laws   Most Recently Viewed  Today at 10:02am Pacific      346-908-0622   Killeen        """
        # if readability is improved in the future, the expectation should be:
        # expected_main_strict = """\n \n \n \n \n \n smoothlegs24  28 \n \n \n chrissy391  27 \n \n \n My name is Helena height 160cms weight 55 kilos  contact me at escort.here@gmail.com           jefferson ave         age: 23 HrumpMeNow  28 \n \n \n xxtradition  24 \n \n \n jumblyjumb  26 \n \n \n claudia77  26 \n \n \n gushinPuss  28 \n \n \n Littlexdit  25 \n \n \n PinkSweets2  28 \n \n \n withoutlimit  27 \n \n \n bothOfUs3  28 \n \n \n lovelylips  27 \n \n \n killerbod  27 \n \n \n Littlexdit  27 \n \n \n azneyes  23 \n \n \n \n \n \n Escort's Phone: \n \n \n323-452-2013  \n \n Escort's Location: \nLos Angeles, California  \n Escort's Age:   23   Date of Escort Post:   Jan 02nd 6:46am \n REVIEWS:   \n READ AND CREATE REVIEWS FOR THIS ESCORT   \n \n \n \n \n \nThere are  50  girls looking in  .\n VIEW GIRLS \n \nHey I'm luna 3234522013 Let's explore , embrace and indulge in your favorite fantasy  % independent. discreet no drama Firm Thighs and Sexy. My Soft skin & Tight Grip is exactly what you deserve Call or text   Fetish friendly   Fantasy friendly   Party friendly 140 Hr SPECIALS 3234522013. Call  323-452-2013 .  Me and my friends are on EZsex  soooo you can find us all on there if you want... skittlegirl \n   \n \n   \n \n   \n Call me on my cell at 323-452-2013. Date of ad: 2017-01-02 06:46:00 \n \n \n"""
        # expected_main_relax = """\n \n \n \n \n \n \n smoothlegs24  28 \n \n \n chrissy391  27 \n \n \n My name is Helena height 160cms weight 55 kilos  contact me at escort.here@gmail.com           jefferson ave         age: 23 HrumpMeNow  28 \n \n \n xxtradition  24 \n \n \n jumblyjumb  26 \n \n \n claudia77  26 \n \n \n gushinPuss  28 \n \n \n Littlexdit  25 \n \n \n PinkSweets2  28 \n \n \n withoutlimit  27 \n \n \n bothOfUs3  28 \n \n \n lovelylips  27 \n \n \n killerbod  27 \n \n \n Littlexdit  27 \n \n \n azneyes  23 \n \n \n \n \n \n Escort's Phone: \n \n \n323-452-2013  \n \n Escort's Location: \nLos Angeles, California  \n Escort's Age:   23   Date of Escort Post:   Jan 02nd 6:46am \n REVIEWS:   \n READ AND CREATE REVIEWS FOR THIS ESCORT   \n \n \n \n \n \nThere are  50  girls looking in  .\n VIEW GIRLS \n \nHey I'm luna 3234522013 Let's explore , embrace and indulge in your favorite fantasy  % independent. discreet no drama Firm Thighs and Sexy. My Soft skin & Tight Grip is exactly what you deserve Call or text   Fetish friendly   Fantasy friendly   Party friendly 140 Hr SPECIALS 3234522013.\u00a0Call  323-452-2013 .  Me and my friends are on EZsex  soooo you can find us all on there if you want... skittlegirl \n \u00a0\u00a0\n \n \u00a0\u00a0\n \n \u00a0\u00a0\n Call me on my cell at 323-452-2013. Date of ad: 2017-01-02 06:46:00 \n \n \n \n" != "\n \n \n \n \n \n Escort's Phone: \n \n \n323-452-2013  \n \n Escort's Location: \nLos Angeles, California  \n Escort's Age:   23   Date of Escort Post:   Jan 02nd 6:46am \n REVIEWS:   \n READ AND CREATE REVIEWS FOR THIS ESCORT   \n \n \n \n \n \nThere are  50  girls looking in  .\n VIEW GIRLS \n \nHey I'm luna 3234522013 Let's explore , embrace and indulge in your favorite fantasy  % independent. discreet no drama Firm Thighs and Sexy. My Soft skin & Tight Grip is exactly what you deserve Call or text   Fetish friendly   Fantasy friendly   Party friendly 140 Hr SPECIALS 3234522013.\u00a0Call  323-452-2013 .  Me and my friends are on EZsex  soooo you can find us all on there if you want... skittlegirl \n \u00a0\u00a0\n \n \u00a0\u00a0\n \n \u00a0\u00a0\n Call me on my cell at 323-452-2013. Date of ad: 2017-01-02 06:46:00 \n \n \n \n"""
        expected_main_strict = """\n \n \n \n \n Escort's Phone: \n \n \n323-452-2013  \n \n Escort's Location: \nLos Angeles, California  \n Escort's Age:   23   Date of Escort Post:   Jan 02nd 6:46am \n REVIEWS:   \n READ AND CREATE REVIEWS FOR THIS ESCORT   \n \n \n \n \n \nThere are  50  girls looking in  .\n VIEW GIRLS \n \nHey I'm luna 3234522013 Let's explore , embrace and indulge in your favorite fantasy  % independent. discreet no drama Firm Thighs and Sexy. My Soft skin & Tight Grip is exactly what you deserve Call or text   Fetish friendly   Fantasy friendly   Party friendly 140 Hr SPECIALS 3234522013.\u00a0Call  323-452-2013 .  Me and my friends are on EZsex  soooo you can find us all on there if you want... skittlegirl \n \u00a0\u00a0\n \n \u00a0\u00a0\n \n \u00a0\u00a0\n Call me on my cell at 323-452-2013. Date of ad: 2017-01-02 06:46:00 \n \n \n"""
        expected_main_relax = """\n \n \n \n \n \n Escort's Phone: \n \n \n323-452-2013  \n \n Escort's Location: \nLos Angeles, California  \n Escort's Age:   23   Date of Escort Post:   Jan 02nd 6:46am \n REVIEWS:   \n READ AND CREATE REVIEWS FOR THIS ESCORT   \n \n \n \n \n \nThere are  50  girls looking in  .\n VIEW GIRLS \n \nHey I'm luna 3234522013 Let's explore , embrace and indulge in your favorite fantasy  % independent. discreet no drama Firm Thighs and Sexy. My Soft skin & Tight Grip is exactly what you deserve Call or text   Fetish friendly   Fantasy friendly   Party friendly 140 Hr SPECIALS 3234522013.\u00a0Call  323-452-2013 .  Me and my friends are on EZsex  soooo you can find us all on there if you want... skittlegirl \n \u00a0\u00a0\n \n \u00a0\u00a0\n \n \u00a0\u00a0\n Call me on my cell at 323-452-2013. Date of ad: 2017-01-02 06:46:00 \n \n \n \n"""

        self.assertEqual(json.dumps(all_text), json.dumps(expected_all_text))
        self.assertEqual(json.dumps(main_strict), json.dumps(expected_main_strict))
        self.assertEqual(json.dumps(main_relax), json.dumps(expected_main_relax))


if __name__ == '__main__':
    unittest.main()
