# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudAccountArgs', 'CloudAccount']

@pulumi.input_type
class CloudAccountArgs:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['CloudAccountAwsArgs']] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input['CloudAccountAzureArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gcp: Optional[pulumi.Input['CloudAccountGcpArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ngs: Optional[pulumi.Input['CloudAccountNgsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a CloudAccount resource.
        :param pulumi.Input['CloudAccountAwsArgs'] aws: Contains AWS cloud account configuration.
        :param pulumi.Input[Sequence[pulumi.Input['CloudAccountAzureArgs']]] azures: Contains Azure cloud account configuration.
        :param pulumi.Input[builtins.str] description: Description of the Cloud Account.
        :param pulumi.Input['CloudAccountGcpArgs'] gcp: Contains GCP cloud account configuration.
        :param pulumi.Input[builtins.str] name: Name of the Cloud Account.
        :param pulumi.Input['CloudAccountNgsArgs'] ngs: Contains NGS cloud account configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azures is not None:
            pulumi.set(__self__, "azures", azures)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngs is not None:
            pulumi.set(__self__, "ngs", ngs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['CloudAccountAwsArgs']]:
        """
        Contains AWS cloud account configuration.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['CloudAccountAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudAccountAzureArgs']]]]:
        """
        Contains Azure cloud account configuration.
        """
        return pulumi.get(self, "azures")

    @azures.setter
    def azures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudAccountAzureArgs']]]]):
        pulumi.set(self, "azures", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Cloud Account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input['CloudAccountGcpArgs']]:
        """
        Contains GCP cloud account configuration.
        """
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input['CloudAccountGcpArgs']]):
        pulumi.set(self, "gcp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Cloud Account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ngs(self) -> Optional[pulumi.Input['CloudAccountNgsArgs']]:
        """
        Contains NGS cloud account configuration.
        """
        return pulumi.get(self, "ngs")

    @ngs.setter
    def ngs(self, value: Optional[pulumi.Input['CloudAccountNgsArgs']]):
        pulumi.set(self, "ngs", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CloudAccountState:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['CloudAccountAwsArgs']] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input['CloudAccountAzureArgs']]]] = None,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gcp: Optional[pulumi.Input['CloudAccountGcpArgs']] = None,
                 gcp_roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 gcp_service_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ngs: Optional[pulumi.Input['CloudAccountNgsArgs']] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CloudAccount resources.
        :param pulumi.Input['CloudAccountAwsArgs'] aws: Contains AWS cloud account configuration.
        :param pulumi.Input[Sequence[pulumi.Input['CloudAccountAzureArgs']]] azures: Contains Azure cloud account configuration.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Cloud Account.
        :param pulumi.Input[builtins.str] description: Description of the Cloud Account.
        :param pulumi.Input['CloudAccountGcpArgs'] gcp: Contains GCP cloud account configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gcp_roles: GCP roles used during the configuration of the cloud account at GCP.
        :param pulumi.Input[builtins.str] gcp_service_account_name: GCP service account name used during the configuration of the cloud account at GCP.
        :param pulumi.Input[builtins.str] name: Name of the Cloud Account.
        :param pulumi.Input['CloudAccountNgsArgs'] ngs: Contains NGS cloud account configuration.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azures is not None:
            pulumi.set(__self__, "azures", azures)
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)
        if gcp_roles is not None:
            pulumi.set(__self__, "gcp_roles", gcp_roles)
        if gcp_service_account_name is not None:
            pulumi.set(__self__, "gcp_service_account_name", gcp_service_account_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ngs is not None:
            pulumi.set(__self__, "ngs", ngs)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['CloudAccountAwsArgs']]:
        """
        Contains AWS cloud account configuration.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['CloudAccountAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudAccountAzureArgs']]]]:
        """
        Contains Azure cloud account configuration.
        """
        return pulumi.get(self, "azures")

    @azures.setter
    def azures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudAccountAzureArgs']]]]):
        pulumi.set(self, "azures", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the Cloud Account.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Cloud Account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input['CloudAccountGcpArgs']]:
        """
        Contains GCP cloud account configuration.
        """
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input['CloudAccountGcpArgs']]):
        pulumi.set(self, "gcp", value)

    @property
    @pulumi.getter(name="gcpRoles")
    def gcp_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        GCP roles used during the configuration of the cloud account at GCP.
        """
        return pulumi.get(self, "gcp_roles")

    @gcp_roles.setter
    def gcp_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "gcp_roles", value)

    @property
    @pulumi.getter(name="gcpServiceAccountName")
    def gcp_service_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GCP service account name used during the configuration of the cloud account at GCP.
        """
        return pulumi.get(self, "gcp_service_account_name")

    @gcp_service_account_name.setter
    def gcp_service_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcp_service_account_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Cloud Account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ngs(self) -> Optional[pulumi.Input['CloudAccountNgsArgs']]:
        """
        Contains NGS cloud account configuration.
        """
        return pulumi.get(self, "ngs")

    @ngs.setter
    def ngs(self, value: Optional[pulumi.Input['CloudAccountNgsArgs']]):
        pulumi.set(self, "ngs", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("cpln:index/cloudAccount:CloudAccount")
class CloudAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['CloudAccountAwsArgs', 'CloudAccountAwsArgsDict']]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudAccountAzureArgs', 'CloudAccountAzureArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gcp: Optional[pulumi.Input[Union['CloudAccountGcpArgs', 'CloudAccountGcpArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ngs: Optional[pulumi.Input[Union['CloudAccountNgsArgs', 'CloudAccountNgsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Create a CloudAccount resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CloudAccountAwsArgs', 'CloudAccountAwsArgsDict']] aws: Contains AWS cloud account configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudAccountAzureArgs', 'CloudAccountAzureArgsDict']]]] azures: Contains Azure cloud account configuration.
        :param pulumi.Input[builtins.str] description: Description of the Cloud Account.
        :param pulumi.Input[Union['CloudAccountGcpArgs', 'CloudAccountGcpArgsDict']] gcp: Contains GCP cloud account configuration.
        :param pulumi.Input[builtins.str] name: Name of the Cloud Account.
        :param pulumi.Input[Union['CloudAccountNgsArgs', 'CloudAccountNgsArgsDict']] ngs: Contains NGS cloud account configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CloudAccountArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CloudAccount resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CloudAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['CloudAccountAwsArgs', 'CloudAccountAwsArgsDict']]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudAccountAzureArgs', 'CloudAccountAzureArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gcp: Optional[pulumi.Input[Union['CloudAccountGcpArgs', 'CloudAccountGcpArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ngs: Optional[pulumi.Input[Union['CloudAccountNgsArgs', 'CloudAccountNgsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudAccountArgs.__new__(CloudAccountArgs)

            __props__.__dict__["aws"] = aws
            __props__.__dict__["azures"] = azures
            __props__.__dict__["description"] = description
            __props__.__dict__["gcp"] = gcp
            __props__.__dict__["name"] = name
            __props__.__dict__["ngs"] = ngs
            __props__.__dict__["tags"] = tags
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["gcp_roles"] = None
            __props__.__dict__["gcp_service_account_name"] = None
            __props__.__dict__["self_link"] = None
        super(CloudAccount, __self__).__init__(
            'cpln:index/cloudAccount:CloudAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws: Optional[pulumi.Input[Union['CloudAccountAwsArgs', 'CloudAccountAwsArgsDict']]] = None,
            azures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudAccountAzureArgs', 'CloudAccountAzureArgsDict']]]]] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            gcp: Optional[pulumi.Input[Union['CloudAccountGcpArgs', 'CloudAccountGcpArgsDict']]] = None,
            gcp_roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            gcp_service_account_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            ngs: Optional[pulumi.Input[Union['CloudAccountNgsArgs', 'CloudAccountNgsArgsDict']]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'CloudAccount':
        """
        Get an existing CloudAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CloudAccountAwsArgs', 'CloudAccountAwsArgsDict']] aws: Contains AWS cloud account configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudAccountAzureArgs', 'CloudAccountAzureArgsDict']]]] azures: Contains Azure cloud account configuration.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Cloud Account.
        :param pulumi.Input[builtins.str] description: Description of the Cloud Account.
        :param pulumi.Input[Union['CloudAccountGcpArgs', 'CloudAccountGcpArgsDict']] gcp: Contains GCP cloud account configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gcp_roles: GCP roles used during the configuration of the cloud account at GCP.
        :param pulumi.Input[builtins.str] gcp_service_account_name: GCP service account name used during the configuration of the cloud account at GCP.
        :param pulumi.Input[builtins.str] name: Name of the Cloud Account.
        :param pulumi.Input[Union['CloudAccountNgsArgs', 'CloudAccountNgsArgsDict']] ngs: Contains NGS cloud account configuration.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudAccountState.__new__(_CloudAccountState)

        __props__.__dict__["aws"] = aws
        __props__.__dict__["azures"] = azures
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["gcp"] = gcp
        __props__.__dict__["gcp_roles"] = gcp_roles
        __props__.__dict__["gcp_service_account_name"] = gcp_service_account_name
        __props__.__dict__["name"] = name
        __props__.__dict__["ngs"] = ngs
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tags"] = tags
        return CloudAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional['outputs.CloudAccountAws']]:
        """
        Contains AWS cloud account configuration.
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter
    def azures(self) -> pulumi.Output[Optional[Sequence['outputs.CloudAccountAzure']]]:
        """
        Contains Azure cloud account configuration.
        """
        return pulumi.get(self, "azures")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the Cloud Account.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the Cloud Account.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def gcp(self) -> pulumi.Output[Optional['outputs.CloudAccountGcp']]:
        """
        Contains GCP cloud account configuration.
        """
        return pulumi.get(self, "gcp")

    @property
    @pulumi.getter(name="gcpRoles")
    def gcp_roles(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        GCP roles used during the configuration of the cloud account at GCP.
        """
        return pulumi.get(self, "gcp_roles")

    @property
    @pulumi.getter(name="gcpServiceAccountName")
    def gcp_service_account_name(self) -> pulumi.Output[builtins.str]:
        """
        GCP service account name used during the configuration of the cloud account at GCP.
        """
        return pulumi.get(self, "gcp_service_account_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Cloud Account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ngs(self) -> pulumi.Output[Optional['outputs.CloudAccountNgs']]:
        """
        Contains NGS cloud account configuration.
        """
        return pulumi.get(self, "ngs")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

