# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrgArgs', 'Org']

@pulumi.input_type
class OrgArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 auth_config: Optional[pulumi.Input['OrgAuthConfigArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invitees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 observability: Optional[pulumi.Input['OrgObservabilityArgs']] = None,
                 security: Optional[pulumi.Input['OrgSecurityArgs']] = None,
                 session_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Org resource.
        :param pulumi.Input[builtins.str] account_id: The associated account ID that will be used when creating the org. Only used on org creation. The account ID can be
               obtained from the `Org Management & Billing` page.
        :param pulumi.Input['OrgAuthConfigArgs'] auth_config: The configuration settings and parameters related to authentication within the org.
        :param pulumi.Input[builtins.str] description: Description of the Organization.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] invitees: When an org is created, the list of email addresses which will receive an invitation to join the org and be assigned to
               the `superusers` group. The user account used when creating the org will be included in this list.
        :param pulumi.Input['OrgObservabilityArgs'] observability: The retention period (in days) for logs, metrics, and traces. Charges apply for storage beyond the 30 day default.
        :param pulumi.Input[builtins.int] session_timeout_seconds: The idle time (in seconds) in which the console UI will automatically sign-out the user. Default: 900 (15 minutes)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if invitees is not None:
            pulumi.set(__self__, "invitees", invitees)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if session_timeout_seconds is not None:
            pulumi.set(__self__, "session_timeout_seconds", session_timeout_seconds)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The associated account ID that will be used when creating the org. Only used on org creation. The account ID can be
        obtained from the `Org Management & Billing` page.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['OrgAuthConfigArgs']]:
        """
        The configuration settings and parameters related to authentication within the org.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['OrgAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Organization.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def invitees(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        When an org is created, the list of email addresses which will receive an invitation to join the org and be assigned to
        the `superusers` group. The user account used when creating the org will be included in this list.
        """
        return pulumi.get(self, "invitees")

    @invitees.setter
    def invitees(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "invitees", value)

    @property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['OrgObservabilityArgs']]:
        """
        The retention period (in days) for logs, metrics, and traces. Charges apply for storage beyond the 30 day default.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['OrgObservabilityArgs']]):
        pulumi.set(self, "observability", value)

    @property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input['OrgSecurityArgs']]:
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input['OrgSecurityArgs']]):
        pulumi.set(self, "security", value)

    @property
    @pulumi.getter(name="sessionTimeoutSeconds")
    def session_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The idle time (in seconds) in which the console UI will automatically sign-out the user. Default: 900 (15 minutes)
        """
        return pulumi.get(self, "session_timeout_seconds")

    @session_timeout_seconds.setter
    def session_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_timeout_seconds", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _OrgState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 auth_config: Optional[pulumi.Input['OrgAuthConfigArgs']] = None,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invitees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 observability: Optional[pulumi.Input['OrgObservabilityArgs']] = None,
                 security: Optional[pulumi.Input['OrgSecurityArgs']] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['OrgStatusArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Org resources.
        :param pulumi.Input[builtins.str] account_id: The associated account ID that will be used when creating the org. Only used on org creation. The account ID can be
               obtained from the `Org Management & Billing` page.
        :param pulumi.Input['OrgAuthConfigArgs'] auth_config: The configuration settings and parameters related to authentication within the org.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Organization.
        :param pulumi.Input[builtins.str] description: Description of the Organization.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] invitees: When an org is created, the list of email addresses which will receive an invitation to join the org and be assigned to
               the `superusers` group. The user account used when creating the org will be included in this list.
        :param pulumi.Input[builtins.str] name: Name of the Organization.
        :param pulumi.Input['OrgObservabilityArgs'] observability: The retention period (in days) for logs, metrics, and traces. Charges apply for storage beyond the 30 day default.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[builtins.int] session_timeout_seconds: The idle time (in seconds) in which the console UI will automatically sign-out the user. Default: 900 (15 minutes)
        :param pulumi.Input[Sequence[pulumi.Input['OrgStatusArgs']]] statuses: Status of the org.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if invitees is not None:
            pulumi.set(__self__, "invitees", invitees)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if session_timeout_seconds is not None:
            pulumi.set(__self__, "session_timeout_seconds", session_timeout_seconds)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The associated account ID that will be used when creating the org. Only used on org creation. The account ID can be
        obtained from the `Org Management & Billing` page.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['OrgAuthConfigArgs']]:
        """
        The configuration settings and parameters related to authentication within the org.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['OrgAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the Organization.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Organization.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def invitees(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        When an org is created, the list of email addresses which will receive an invitation to join the org and be assigned to
        the `superusers` group. The user account used when creating the org will be included in this list.
        """
        return pulumi.get(self, "invitees")

    @invitees.setter
    def invitees(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "invitees", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['OrgObservabilityArgs']]:
        """
        The retention period (in days) for logs, metrics, and traces. Charges apply for storage beyond the 30 day default.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['OrgObservabilityArgs']]):
        pulumi.set(self, "observability", value)

    @property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input['OrgSecurityArgs']]:
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input['OrgSecurityArgs']]):
        pulumi.set(self, "security", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sessionTimeoutSeconds")
    def session_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The idle time (in seconds) in which the console UI will automatically sign-out the user. Default: 900 (15 minutes)
        """
        return pulumi.get(self, "session_timeout_seconds")

    @session_timeout_seconds.setter
    def session_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_timeout_seconds", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgStatusArgs']]]]:
        """
        Status of the org.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("cpln:index/org:Org")
class Org(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 auth_config: Optional[pulumi.Input[Union['OrgAuthConfigArgs', 'OrgAuthConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invitees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 observability: Optional[pulumi.Input[Union['OrgObservabilityArgs', 'OrgObservabilityArgsDict']]] = None,
                 security: Optional[pulumi.Input[Union['OrgSecurityArgs', 'OrgSecurityArgsDict']]] = None,
                 session_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Create a Org resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The associated account ID that will be used when creating the org. Only used on org creation. The account ID can be
               obtained from the `Org Management & Billing` page.
        :param pulumi.Input[Union['OrgAuthConfigArgs', 'OrgAuthConfigArgsDict']] auth_config: The configuration settings and parameters related to authentication within the org.
        :param pulumi.Input[builtins.str] description: Description of the Organization.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] invitees: When an org is created, the list of email addresses which will receive an invitation to join the org and be assigned to
               the `superusers` group. The user account used when creating the org will be included in this list.
        :param pulumi.Input[Union['OrgObservabilityArgs', 'OrgObservabilityArgsDict']] observability: The retention period (in days) for logs, metrics, and traces. Charges apply for storage beyond the 30 day default.
        :param pulumi.Input[builtins.int] session_timeout_seconds: The idle time (in seconds) in which the console UI will automatically sign-out the user. Default: 900 (15 minutes)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OrgArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Org resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param OrgArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrgArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 auth_config: Optional[pulumi.Input[Union['OrgAuthConfigArgs', 'OrgAuthConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invitees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 observability: Optional[pulumi.Input[Union['OrgObservabilityArgs', 'OrgObservabilityArgsDict']]] = None,
                 security: Optional[pulumi.Input[Union['OrgSecurityArgs', 'OrgSecurityArgsDict']]] = None,
                 session_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrgArgs.__new__(OrgArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["auth_config"] = auth_config
            __props__.__dict__["description"] = description
            __props__.__dict__["invitees"] = invitees
            __props__.__dict__["observability"] = observability
            __props__.__dict__["security"] = security
            __props__.__dict__["session_timeout_seconds"] = session_timeout_seconds
            __props__.__dict__["tags"] = tags
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["statuses"] = None
        super(Org, __self__).__init__(
            'cpln:index/org:Org',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            auth_config: Optional[pulumi.Input[Union['OrgAuthConfigArgs', 'OrgAuthConfigArgsDict']]] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            invitees: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            observability: Optional[pulumi.Input[Union['OrgObservabilityArgs', 'OrgObservabilityArgsDict']]] = None,
            security: Optional[pulumi.Input[Union['OrgSecurityArgs', 'OrgSecurityArgsDict']]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            session_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgStatusArgs', 'OrgStatusArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Org':
        """
        Get an existing Org resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The associated account ID that will be used when creating the org. Only used on org creation. The account ID can be
               obtained from the `Org Management & Billing` page.
        :param pulumi.Input[Union['OrgAuthConfigArgs', 'OrgAuthConfigArgsDict']] auth_config: The configuration settings and parameters related to authentication within the org.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Organization.
        :param pulumi.Input[builtins.str] description: Description of the Organization.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] invitees: When an org is created, the list of email addresses which will receive an invitation to join the org and be assigned to
               the `superusers` group. The user account used when creating the org will be included in this list.
        :param pulumi.Input[builtins.str] name: Name of the Organization.
        :param pulumi.Input[Union['OrgObservabilityArgs', 'OrgObservabilityArgsDict']] observability: The retention period (in days) for logs, metrics, and traces. Charges apply for storage beyond the 30 day default.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[builtins.int] session_timeout_seconds: The idle time (in seconds) in which the console UI will automatically sign-out the user. Default: 900 (15 minutes)
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgStatusArgs', 'OrgStatusArgsDict']]]] statuses: Status of the org.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrgState.__new__(_OrgState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["auth_config"] = auth_config
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["invitees"] = invitees
        __props__.__dict__["name"] = name
        __props__.__dict__["observability"] = observability
        __props__.__dict__["security"] = security
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["session_timeout_seconds"] = session_timeout_seconds
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["tags"] = tags
        return Org(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        The associated account ID that will be used when creating the org. Only used on org creation. The account ID can be
        obtained from the `Org Management & Billing` page.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> pulumi.Output[Optional['outputs.OrgAuthConfig']]:
        """
        The configuration settings and parameters related to authentication within the org.
        """
        return pulumi.get(self, "auth_config")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the Organization.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the Organization.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def invitees(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        When an org is created, the list of email addresses which will receive an invitation to join the org and be assigned to
        the `superusers` group. The user account used when creating the org will be included in this list.
        """
        return pulumi.get(self, "invitees")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def observability(self) -> pulumi.Output[Optional['outputs.OrgObservability']]:
        """
        The retention period (in days) for logs, metrics, and traces. Charges apply for storage beyond the 30 day default.
        """
        return pulumi.get(self, "observability")

    @property
    @pulumi.getter
    def security(self) -> pulumi.Output[Optional['outputs.OrgSecurity']]:
        return pulumi.get(self, "security")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sessionTimeoutSeconds")
    def session_timeout_seconds(self) -> pulumi.Output[builtins.int]:
        """
        The idle time (in seconds) in which the console UI will automatically sign-out the user. Default: 900 (15 minutes)
        """
        return pulumi.get(self, "session_timeout_seconds")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.OrgStatus']]:
        """
        Status of the org.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

