const AWS = require('aws-sdk');
const util = require('util');


exports.handler = async (event) => {
    const body = JSON.parse(event.body)
    console.log(body)
    const task_name = process.env.ecs_task_arn.split('/')[1].split(':')[0]
    
    const ecs = new AWS.ECS();

    let messages = []
    
    // run an ECS Fargate task
    const params = {
        cluster: `${process.env.ecs_cluster}`,
        launchType: 'FARGATE',
        taskDefinition: `${process.env.ecs_task_arn}`,
        networkConfiguration: {
            awsvpcConfiguration: {
                subnets: [
                    `${process.env.subnet}`,
                ],
                assignPublicIp: "ENABLED",
                securityGroups: [
                    `${process.env.security_group}`,
                ],
            },
        },
        overrides: { 
            containerOverrides: [{
                name: task_name,
                environment: [{ 
                    name: "TRIGGER_ID",
                    value: body.triggerId
               }]
            }]
        }
    };
    console.log("running task with taskDefinition:", params.taskDefinition);
    const taskStart = await ecs.runTask(params).promise();

    console.log("started :", );

    const message = {
        task: taskStart.tasks[0].taskArn,
        status: "pending"
    };
    messages.push(message)

    return {
        statusCode: 200,
        body: JSON.stringify(messages)
    };
};
