"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
 * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
 * attribute, AWS CloudFormation deletes the resource by default. Note that this capability also applies to update operations
 * that lead to resources being removed.
 */
var CfnDeletionPolicy;
(function (CfnDeletionPolicy) {
    /**
     * AWS CloudFormation deletes the resource and all its content if applicable during stack deletion. You can add this
     * deletion policy to any resource type. By default, if you don't specify a DeletionPolicy, AWS CloudFormation deletes
     * your resources. However, be aware of the following considerations:
     */
    CfnDeletionPolicy["DELETE"] = "Delete";
    /**
     * AWS CloudFormation keeps the resource without deleting the resource or its contents when its stack is deleted.
     * You can add this deletion policy to any resource type. Note that when AWS CloudFormation completes the stack deletion,
     * the stack will be in Delete_Complete state; however, resources that are retained continue to exist and continue to incur
     * applicable charges until you delete those resources.
     */
    CfnDeletionPolicy["RETAIN"] = "Retain";
    /**
     * For resources that support snapshots (AWS::EC2::Volume, AWS::ElastiCache::CacheCluster, AWS::ElastiCache::ReplicationGroup,
     * AWS::RDS::DBInstance, AWS::RDS::DBCluster, and AWS::Redshift::Cluster), AWS CloudFormation creates a snapshot for the
     * resource before deleting it. Note that when AWS CloudFormation completes the stack deletion, the stack will be in the
     * Delete_Complete state; however, the snapshots that are created with this policy continue to exist and continue to
     * incur applicable charges until you delete those snapshots.
     */
    CfnDeletionPolicy["SNAPSHOT"] = "Snapshot";
})(CfnDeletionPolicy = exports.CfnDeletionPolicy || (exports.CfnDeletionPolicy = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLXJlc291cmNlLXBvbGljeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNmbi1yZXNvdXJjZS1wb2xpY3kudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFrRUE7Ozs7O0dBS0c7QUFDSCxJQUFZLGlCQXdCWDtBQXhCRCxXQUFZLGlCQUFpQjtJQUMzQjs7OztPQUlHO0lBQ0gsc0NBQWlCLENBQUE7SUFFakI7Ozs7O09BS0c7SUFDSCxzQ0FBaUIsQ0FBQTtJQUVqQjs7Ozs7O09BTUc7SUFDSCwwQ0FBcUIsQ0FBQTtBQUN2QixDQUFDLEVBeEJXLGlCQUFpQixHQUFqQix5QkFBaUIsS0FBakIseUJBQWlCLFFBd0I1QiIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQXNzb2NpYXRlIHRoZSBDcmVhdGlvblBvbGljeSBhdHRyaWJ1dGUgd2l0aCBhIHJlc291cmNlIHRvIHByZXZlbnQgaXRzIHN0YXR1cyBmcm9tIHJlYWNoaW5nIGNyZWF0ZSBjb21wbGV0ZSB1bnRpbFxuICogQVdTIENsb3VkRm9ybWF0aW9uIHJlY2VpdmVzIGEgc3BlY2lmaWVkIG51bWJlciBvZiBzdWNjZXNzIHNpZ25hbHMgb3IgdGhlIHRpbWVvdXQgcGVyaW9kIGlzIGV4Y2VlZGVkLiBUbyBzaWduYWwgYVxuICogcmVzb3VyY2UsIHlvdSBjYW4gdXNlIHRoZSBjZm4tc2lnbmFsIGhlbHBlciBzY3JpcHQgb3IgU2lnbmFsUmVzb3VyY2UgQVBJLiBBV1MgQ2xvdWRGb3JtYXRpb24gcHVibGlzaGVzIHZhbGlkIHNpZ25hbHNcbiAqIHRvIHRoZSBzdGFjayBldmVudHMgc28gdGhhdCB5b3UgdHJhY2sgdGhlIG51bWJlciBvZiBzaWduYWxzIHNlbnQuXG4gKlxuICogVGhlIGNyZWF0aW9uIHBvbGljeSBpcyBpbnZva2VkIG9ubHkgd2hlbiBBV1MgQ2xvdWRGb3JtYXRpb24gY3JlYXRlcyB0aGUgYXNzb2NpYXRlZCByZXNvdXJjZS4gQ3VycmVudGx5LCB0aGUgb25seVxuICogQVdTIENsb3VkRm9ybWF0aW9uIHJlc291cmNlcyB0aGF0IHN1cHBvcnQgY3JlYXRpb24gcG9saWNpZXMgYXJlIEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAsIEFXUzo6RUMyOjpJbnN0YW5jZSxcbiAqIGFuZCBBV1M6OkNsb3VkRm9ybWF0aW9uOjpXYWl0Q29uZGl0aW9uLlxuICpcbiAqIFVzZSB0aGUgQ3JlYXRpb25Qb2xpY3kgYXR0cmlidXRlIHdoZW4geW91IHdhbnQgdG8gd2FpdCBvbiByZXNvdXJjZSBjb25maWd1cmF0aW9uIGFjdGlvbnMgYmVmb3JlIHN0YWNrIGNyZWF0aW9uIHByb2NlZWRzLlxuICogRm9yIGV4YW1wbGUsIGlmIHlvdSBpbnN0YWxsIGFuZCBjb25maWd1cmUgc29mdHdhcmUgYXBwbGljYXRpb25zIG9uIGFuIEVDMiBpbnN0YW5jZSwgeW91IG1pZ2h0IHdhbnQgdGhvc2UgYXBwbGljYXRpb25zIHRvXG4gKiBiZSBydW5uaW5nIGJlZm9yZSBwcm9jZWVkaW5nLiBJbiBzdWNoIGNhc2VzLCB5b3UgY2FuIGFkZCBhIENyZWF0aW9uUG9saWN5IGF0dHJpYnV0ZSB0byB0aGUgaW5zdGFuY2UsIGFuZCB0aGVuIHNlbmQgYSBzdWNjZXNzXG4gKiBzaWduYWwgdG8gdGhlIGluc3RhbmNlIGFmdGVyIHRoZSBhcHBsaWNhdGlvbnMgYXJlIGluc3RhbGxlZCBhbmQgY29uZmlndXJlZC4gRm9yIGEgZGV0YWlsZWQgZXhhbXBsZSwgc2VlIERlcGxveWluZyBBcHBsaWNhdGlvbnNcbiAqIG9uIEFtYXpvbiBFQzIgd2l0aCBBV1MgQ2xvdWRGb3JtYXRpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuQ3JlYXRpb25Qb2xpY3kge1xuICAvKipcbiAgICogRm9yIGFuIEF1dG8gU2NhbGluZyBncm91cCByZXBsYWNlbWVudCB1cGRhdGUsIHNwZWNpZmllcyBob3cgbWFueSBpbnN0YW5jZXMgbXVzdCBzaWduYWwgc3VjY2VzcyBmb3IgdGhlXG4gICAqIHVwZGF0ZSB0byBzdWNjZWVkLlxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b1NjYWxpbmdDcmVhdGlvblBvbGljeT86IENmblJlc291cmNlQXV0b1NjYWxpbmdDcmVhdGlvblBvbGljeTtcblxuICAvKipcbiAgICogV2hlbiBBV1MgQ2xvdWRGb3JtYXRpb24gY3JlYXRlcyB0aGUgYXNzb2NpYXRlZCByZXNvdXJjZSwgY29uZmlndXJlcyB0aGUgbnVtYmVyIG9mIHJlcXVpcmVkIHN1Y2Nlc3Mgc2lnbmFscyBhbmRcbiAgICogdGhlIGxlbmd0aCBvZiB0aW1lIHRoYXQgQVdTIENsb3VkRm9ybWF0aW9uIHdhaXRzIGZvciB0aG9zZSBzaWduYWxzLlxuICAgKi9cbiAgcmVhZG9ubHkgcmVzb3VyY2VTaWduYWw/OiBDZm5SZXNvdXJjZVNpZ25hbDtcbn1cblxuLyoqXG4gKiBGb3IgYW4gQXV0byBTY2FsaW5nIGdyb3VwIHJlcGxhY2VtZW50IHVwZGF0ZSwgc3BlY2lmaWVzIGhvdyBtYW55IGluc3RhbmNlcyBtdXN0IHNpZ25hbCBzdWNjZXNzIGZvciB0aGVcbiAqIHVwZGF0ZSB0byBzdWNjZWVkLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmblJlc291cmNlQXV0b1NjYWxpbmdDcmVhdGlvblBvbGljeSB7XG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgdGhlIHBlcmNlbnRhZ2Ugb2YgaW5zdGFuY2VzIGluIGFuIEF1dG8gU2NhbGluZyByZXBsYWNlbWVudCB1cGRhdGUgdGhhdCBtdXN0IHNpZ25hbCBzdWNjZXNzIGZvciB0aGVcbiAgICogdXBkYXRlIHRvIHN1Y2NlZWQuIFlvdSBjYW4gc3BlY2lmeSBhIHZhbHVlIGZyb20gMCB0byAxMDAuIEFXUyBDbG91ZEZvcm1hdGlvbiByb3VuZHMgdG8gdGhlIG5lYXJlc3QgdGVudGggb2YgYSBwZXJjZW50LlxuICAgKiBGb3IgZXhhbXBsZSwgaWYgeW91IHVwZGF0ZSBmaXZlIGluc3RhbmNlcyB3aXRoIGEgbWluaW11bSBzdWNjZXNzZnVsIHBlcmNlbnRhZ2Ugb2YgNTAsIHRocmVlIGluc3RhbmNlcyBtdXN0IHNpZ25hbCBzdWNjZXNzLlxuICAgKiBJZiBhbiBpbnN0YW5jZSBkb2Vzbid0IHNlbmQgYSBzaWduYWwgd2l0aGluIHRoZSB0aW1lIHNwZWNpZmllZCBieSB0aGUgVGltZW91dCBwcm9wZXJ0eSwgQVdTIENsb3VkRm9ybWF0aW9uIGFzc3VtZXMgdGhhdCB0aGVcbiAgICogaW5zdGFuY2Ugd2Fzbid0IGNyZWF0ZWQuXG4gICAqL1xuICByZWFkb25seSBtaW5TdWNjZXNzZnVsSW5zdGFuY2VzUGVyY2VudD86IG51bWJlcjtcbn1cblxuLyoqXG4gKiBXaGVuIEFXUyBDbG91ZEZvcm1hdGlvbiBjcmVhdGVzIHRoZSBhc3NvY2lhdGVkIHJlc291cmNlLCBjb25maWd1cmVzIHRoZSBudW1iZXIgb2YgcmVxdWlyZWQgc3VjY2VzcyBzaWduYWxzIGFuZFxuICogdGhlIGxlbmd0aCBvZiB0aW1lIHRoYXQgQVdTIENsb3VkRm9ybWF0aW9uIHdhaXRzIGZvciB0aG9zZSBzaWduYWxzLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmblJlc291cmNlU2lnbmFsIHtcblxuICAvKipcbiAgICogVGhlIG51bWJlciBvZiBzdWNjZXNzIHNpZ25hbHMgQVdTIENsb3VkRm9ybWF0aW9uIG11c3QgcmVjZWl2ZSBiZWZvcmUgaXQgc2V0cyB0aGUgcmVzb3VyY2Ugc3RhdHVzIGFzIENSRUFURV9DT01QTEVURS5cbiAgICogSWYgdGhlIHJlc291cmNlIHJlY2VpdmVzIGEgZmFpbHVyZSBzaWduYWwgb3IgZG9lc24ndCByZWNlaXZlIHRoZSBzcGVjaWZpZWQgbnVtYmVyIG9mIHNpZ25hbHMgYmVmb3JlIHRoZSB0aW1lb3V0IHBlcmlvZFxuICAgKiBleHBpcmVzLCB0aGUgcmVzb3VyY2UgY3JlYXRpb24gZmFpbHMgYW5kIEFXUyBDbG91ZEZvcm1hdGlvbiByb2xscyB0aGUgc3RhY2sgYmFjay5cbiAgICovXG4gIHJlYWRvbmx5IGNvdW50PzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgbGVuZ3RoIG9mIHRpbWUgdGhhdCBBV1MgQ2xvdWRGb3JtYXRpb24gd2FpdHMgZm9yIHRoZSBudW1iZXIgb2Ygc2lnbmFscyB0aGF0IHdhcyBzcGVjaWZpZWQgaW4gdGhlIENvdW50IHByb3BlcnR5LlxuICAgKiBUaGUgdGltZW91dCBwZXJpb2Qgc3RhcnRzIGFmdGVyIEFXUyBDbG91ZEZvcm1hdGlvbiBzdGFydHMgY3JlYXRpbmcgdGhlIHJlc291cmNlLCBhbmQgdGhlIHRpbWVvdXQgZXhwaXJlcyBubyBzb29uZXJcbiAgICogdGhhbiB0aGUgdGltZSB5b3Ugc3BlY2lmeSBidXQgY2FuIG9jY3VyIHNob3J0bHkgdGhlcmVhZnRlci4gVGhlIG1heGltdW0gdGltZSB0aGF0IHlvdSBjYW4gc3BlY2lmeSBpcyAxMiBob3Vycy5cbiAgICovXG4gIHJlYWRvbmx5IHRpbWVvdXQ/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogV2l0aCB0aGUgRGVsZXRpb25Qb2xpY3kgYXR0cmlidXRlIHlvdSBjYW4gcHJlc2VydmUgb3IgKGluIHNvbWUgY2FzZXMpIGJhY2t1cCBhIHJlc291cmNlIHdoZW4gaXRzIHN0YWNrIGlzIGRlbGV0ZWQuXG4gKiBZb3Ugc3BlY2lmeSBhIERlbGV0aW9uUG9saWN5IGF0dHJpYnV0ZSBmb3IgZWFjaCByZXNvdXJjZSB0aGF0IHlvdSB3YW50IHRvIGNvbnRyb2wuIElmIGEgcmVzb3VyY2UgaGFzIG5vIERlbGV0aW9uUG9saWN5XG4gKiBhdHRyaWJ1dGUsIEFXUyBDbG91ZEZvcm1hdGlvbiBkZWxldGVzIHRoZSByZXNvdXJjZSBieSBkZWZhdWx0LiBOb3RlIHRoYXQgdGhpcyBjYXBhYmlsaXR5IGFsc28gYXBwbGllcyB0byB1cGRhdGUgb3BlcmF0aW9uc1xuICogdGhhdCBsZWFkIHRvIHJlc291cmNlcyBiZWluZyByZW1vdmVkLlxuICovXG5leHBvcnQgZW51bSBDZm5EZWxldGlvblBvbGljeSB7XG4gIC8qKlxuICAgKiBBV1MgQ2xvdWRGb3JtYXRpb24gZGVsZXRlcyB0aGUgcmVzb3VyY2UgYW5kIGFsbCBpdHMgY29udGVudCBpZiBhcHBsaWNhYmxlIGR1cmluZyBzdGFjayBkZWxldGlvbi4gWW91IGNhbiBhZGQgdGhpc1xuICAgKiBkZWxldGlvbiBwb2xpY3kgdG8gYW55IHJlc291cmNlIHR5cGUuIEJ5IGRlZmF1bHQsIGlmIHlvdSBkb24ndCBzcGVjaWZ5IGEgRGVsZXRpb25Qb2xpY3ksIEFXUyBDbG91ZEZvcm1hdGlvbiBkZWxldGVzXG4gICAqIHlvdXIgcmVzb3VyY2VzLiBIb3dldmVyLCBiZSBhd2FyZSBvZiB0aGUgZm9sbG93aW5nIGNvbnNpZGVyYXRpb25zOlxuICAgKi9cbiAgREVMRVRFID0gJ0RlbGV0ZScsXG5cbiAgLyoqXG4gICAqIEFXUyBDbG91ZEZvcm1hdGlvbiBrZWVwcyB0aGUgcmVzb3VyY2Ugd2l0aG91dCBkZWxldGluZyB0aGUgcmVzb3VyY2Ugb3IgaXRzIGNvbnRlbnRzIHdoZW4gaXRzIHN0YWNrIGlzIGRlbGV0ZWQuXG4gICAqIFlvdSBjYW4gYWRkIHRoaXMgZGVsZXRpb24gcG9saWN5IHRvIGFueSByZXNvdXJjZSB0eXBlLiBOb3RlIHRoYXQgd2hlbiBBV1MgQ2xvdWRGb3JtYXRpb24gY29tcGxldGVzIHRoZSBzdGFjayBkZWxldGlvbixcbiAgICogdGhlIHN0YWNrIHdpbGwgYmUgaW4gRGVsZXRlX0NvbXBsZXRlIHN0YXRlOyBob3dldmVyLCByZXNvdXJjZXMgdGhhdCBhcmUgcmV0YWluZWQgY29udGludWUgdG8gZXhpc3QgYW5kIGNvbnRpbnVlIHRvIGluY3VyXG4gICAqIGFwcGxpY2FibGUgY2hhcmdlcyB1bnRpbCB5b3UgZGVsZXRlIHRob3NlIHJlc291cmNlcy5cbiAgICovXG4gIFJFVEFJTiA9ICdSZXRhaW4nLFxuXG4gIC8qKlxuICAgKiBGb3IgcmVzb3VyY2VzIHRoYXQgc3VwcG9ydCBzbmFwc2hvdHMgKEFXUzo6RUMyOjpWb2x1bWUsIEFXUzo6RWxhc3RpQ2FjaGU6OkNhY2hlQ2x1c3RlciwgQVdTOjpFbGFzdGlDYWNoZTo6UmVwbGljYXRpb25Hcm91cCxcbiAgICogQVdTOjpSRFM6OkRCSW5zdGFuY2UsIEFXUzo6UkRTOjpEQkNsdXN0ZXIsIGFuZCBBV1M6OlJlZHNoaWZ0OjpDbHVzdGVyKSwgQVdTIENsb3VkRm9ybWF0aW9uIGNyZWF0ZXMgYSBzbmFwc2hvdCBmb3IgdGhlXG4gICAqIHJlc291cmNlIGJlZm9yZSBkZWxldGluZyBpdC4gTm90ZSB0aGF0IHdoZW4gQVdTIENsb3VkRm9ybWF0aW9uIGNvbXBsZXRlcyB0aGUgc3RhY2sgZGVsZXRpb24sIHRoZSBzdGFjayB3aWxsIGJlIGluIHRoZVxuICAgKiBEZWxldGVfQ29tcGxldGUgc3RhdGU7IGhvd2V2ZXIsIHRoZSBzbmFwc2hvdHMgdGhhdCBhcmUgY3JlYXRlZCB3aXRoIHRoaXMgcG9saWN5IGNvbnRpbnVlIHRvIGV4aXN0IGFuZCBjb250aW51ZSB0b1xuICAgKiBpbmN1ciBhcHBsaWNhYmxlIGNoYXJnZXMgdW50aWwgeW91IGRlbGV0ZSB0aG9zZSBzbmFwc2hvdHMuXG4gICAqL1xuICBTTkFQU0hPVCA9ICdTbmFwc2hvdCcsXG59XG5cbi8qKlxuICogVXNlIHRoZSBVcGRhdGVQb2xpY3kgYXR0cmlidXRlIHRvIHNwZWNpZnkgaG93IEFXUyBDbG91ZEZvcm1hdGlvbiBoYW5kbGVzIHVwZGF0ZXMgdG8gdGhlIEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXBcbiAqIHJlc291cmNlLiBBV1MgQ2xvdWRGb3JtYXRpb24gaW52b2tlcyBvbmUgb2YgdGhyZWUgdXBkYXRlIHBvbGljaWVzIGRlcGVuZGluZyBvbiB0aGUgdHlwZSBvZiBjaGFuZ2UgeW91IG1ha2Ugb3Igd2hldGhlciBhXG4gKiBzY2hlZHVsZWQgYWN0aW9uIGlzIGFzc29jaWF0ZWQgd2l0aCB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmblVwZGF0ZVBvbGljeSB7XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyB3aGV0aGVyIGFuIEF1dG8gU2NhbGluZyBncm91cCBhbmQgdGhlIGluc3RhbmNlcyBpdCBjb250YWlucyBhcmUgcmVwbGFjZWQgZHVyaW5nIGFuIHVwZGF0ZS4gRHVyaW5nIHJlcGxhY2VtZW50LFxuICAgKiBBV1MgQ2xvdWRGb3JtYXRpb24gcmV0YWlucyB0aGUgb2xkIGdyb3VwIHVudGlsIGl0IGZpbmlzaGVzIGNyZWF0aW5nIHRoZSBuZXcgb25lLiBJZiB0aGUgdXBkYXRlIGZhaWxzLCBBV1MgQ2xvdWRGb3JtYXRpb25cbiAgICogY2FuIHJvbGwgYmFjayB0byB0aGUgb2xkIEF1dG8gU2NhbGluZyBncm91cCBhbmQgZGVsZXRlIHRoZSBuZXcgQXV0byBTY2FsaW5nIGdyb3VwLlxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b1NjYWxpbmdSZXBsYWNpbmdVcGRhdGU/OiBDZm5BdXRvU2NhbGluZ1JlcGxhY2luZ1VwZGF0ZTtcblxuICAvKipcbiAgICogVG8gc3BlY2lmeSBob3cgQVdTIENsb3VkRm9ybWF0aW9uIGhhbmRsZXMgcm9sbGluZyB1cGRhdGVzIGZvciBhbiBBdXRvIFNjYWxpbmcgZ3JvdXAsIHVzZSB0aGUgQXV0b1NjYWxpbmdSb2xsaW5nVXBkYXRlXG4gICAqIHBvbGljeS4gUm9sbGluZyB1cGRhdGVzIGVuYWJsZSB5b3UgdG8gc3BlY2lmeSB3aGV0aGVyIEFXUyBDbG91ZEZvcm1hdGlvbiB1cGRhdGVzIGluc3RhbmNlcyB0aGF0IGFyZSBpbiBhbiBBdXRvIFNjYWxpbmdcbiAgICogZ3JvdXAgaW4gYmF0Y2hlcyBvciBhbGwgYXQgb25jZS5cbiAgICovXG4gIHJlYWRvbmx5IGF1dG9TY2FsaW5nUm9sbGluZ1VwZGF0ZT86IENmbkF1dG9TY2FsaW5nUm9sbGluZ1VwZGF0ZTtcblxuICAvKipcbiAgICogVG8gc3BlY2lmeSBob3cgQVdTIENsb3VkRm9ybWF0aW9uIGhhbmRsZXMgdXBkYXRlcyBmb3IgdGhlIE1pblNpemUsIE1heFNpemUsIGFuZCBEZXNpcmVkQ2FwYWNpdHkgcHJvcGVydGllcyB3aGVuXG4gICAqIHRoZSBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwIHJlc291cmNlIGhhcyBhbiBhc3NvY2lhdGVkIHNjaGVkdWxlZCBhY3Rpb24sIHVzZSB0aGUgQXV0b1NjYWxpbmdTY2hlZHVsZWRBY3Rpb25cbiAgICogcG9saWN5LlxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b1NjYWxpbmdTY2hlZHVsZWRBY3Rpb24/OiBDZm5BdXRvU2NhbGluZ1NjaGVkdWxlZEFjdGlvbjtcblxuICAvKipcbiAgICogVG8gcGVyZm9ybSBhbiBBV1MgQ29kZURlcGxveSBkZXBsb3ltZW50IHdoZW4gdGhlIHZlcnNpb24gY2hhbmdlcyBvbiBhbiBBV1M6OkxhbWJkYTo6QWxpYXMgcmVzb3VyY2UsXG4gICAqIHVzZSB0aGUgQ29kZURlcGxveUxhbWJkYUFsaWFzVXBkYXRlIHVwZGF0ZSBwb2xpY3kuXG4gICAqL1xuICByZWFkb25seSBjb2RlRGVwbG95TGFtYmRhQWxpYXNVcGRhdGU/OiBDZm5Db2RlRGVwbG95TGFtYmRhQWxpYXNVcGRhdGU7XG5cbiAgLyoqXG4gICAqIFRvIG1vZGlmeSBhIHJlcGxpY2F0aW9uIGdyb3VwJ3Mgc2hhcmRzIGJ5IGFkZGluZyBvciByZW1vdmluZyBzaGFyZHMsIHJhdGhlciB0aGFuIHJlcGxhY2luZyB0aGUgZW50aXJlXG4gICAqIEFXUzo6RWxhc3RpQ2FjaGU6OlJlcGxpY2F0aW9uR3JvdXAgcmVzb3VyY2UsIHVzZSB0aGUgVXNlT25saW5lUmVzaGFyZGluZyB1cGRhdGUgcG9saWN5LlxuICAgKi9cbiAgcmVhZG9ubHkgdXNlT25saW5lUmVzaGFyZGluZz86IGJvb2xlYW47XG5cbn1cblxuLyoqXG4gKiBUbyBzcGVjaWZ5IGhvdyBBV1MgQ2xvdWRGb3JtYXRpb24gaGFuZGxlcyByb2xsaW5nIHVwZGF0ZXMgZm9yIGFuIEF1dG8gU2NhbGluZyBncm91cCwgdXNlIHRoZSBBdXRvU2NhbGluZ1JvbGxpbmdVcGRhdGVcbiAqIHBvbGljeS4gUm9sbGluZyB1cGRhdGVzIGVuYWJsZSB5b3UgdG8gc3BlY2lmeSB3aGV0aGVyIEFXUyBDbG91ZEZvcm1hdGlvbiB1cGRhdGVzIGluc3RhbmNlcyB0aGF0IGFyZSBpbiBhbiBBdXRvIFNjYWxpbmdcbiAqIGdyb3VwIGluIGJhdGNoZXMgb3IgYWxsIGF0IG9uY2UuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuQXV0b1NjYWxpbmdSb2xsaW5nVXBkYXRlIHtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHRoZSBtYXhpbXVtIG51bWJlciBvZiBpbnN0YW5jZXMgdGhhdCBBV1MgQ2xvdWRGb3JtYXRpb24gdXBkYXRlcy5cbiAgICovXG4gIHJlYWRvbmx5IG1heEJhdGNoU2l6ZT86IG51bWJlcjtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHRoZSBtaW5pbXVtIG51bWJlciBvZiBpbnN0YW5jZXMgdGhhdCBtdXN0IGJlIGluIHNlcnZpY2Ugd2l0aGluIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgd2hpbGUgQVdTXG4gICAqIENsb3VkRm9ybWF0aW9uIHVwZGF0ZXMgb2xkIGluc3RhbmNlcy5cbiAgICovXG4gIHJlYWRvbmx5IG1pbkluc3RhbmNlc0luU2VydmljZT86IG51bWJlcjtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHRoZSBwZXJjZW50YWdlIG9mIGluc3RhbmNlcyBpbiBhbiBBdXRvIFNjYWxpbmcgcm9sbGluZyB1cGRhdGUgdGhhdCBtdXN0IHNpZ25hbCBzdWNjZXNzIGZvciBhbiB1cGRhdGUgdG8gc3VjY2VlZC5cbiAgICogWW91IGNhbiBzcGVjaWZ5IGEgdmFsdWUgZnJvbSAwIHRvIDEwMC4gQVdTIENsb3VkRm9ybWF0aW9uIHJvdW5kcyB0byB0aGUgbmVhcmVzdCB0ZW50aCBvZiBhIHBlcmNlbnQuIEZvciBleGFtcGxlLCBpZiB5b3VcbiAgICogdXBkYXRlIGZpdmUgaW5zdGFuY2VzIHdpdGggYSBtaW5pbXVtIHN1Y2Nlc3NmdWwgcGVyY2VudGFnZSBvZiA1MCwgdGhyZWUgaW5zdGFuY2VzIG11c3Qgc2lnbmFsIHN1Y2Nlc3MuXG4gICAqXG4gICAqIElmIGFuIGluc3RhbmNlIGRvZXNuJ3Qgc2VuZCBhIHNpZ25hbCB3aXRoaW4gdGhlIHRpbWUgc3BlY2lmaWVkIGluIHRoZSBQYXVzZVRpbWUgcHJvcGVydHksIEFXUyBDbG91ZEZvcm1hdGlvbiBhc3N1bWVzXG4gICAqIHRoYXQgdGhlIGluc3RhbmNlIHdhc24ndCB1cGRhdGVkLlxuICAgKlxuICAgKiBJZiB5b3Ugc3BlY2lmeSB0aGlzIHByb3BlcnR5LCB5b3UgbXVzdCBhbHNvIGVuYWJsZSB0aGUgV2FpdE9uUmVzb3VyY2VTaWduYWxzIGFuZCBQYXVzZVRpbWUgcHJvcGVydGllcy5cbiAgICovXG4gIHJlYWRvbmx5IG1pblN1Y2Nlc3NmdWxJbnN0YW5jZXNQZXJjZW50PzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgYW1vdW50IG9mIHRpbWUgdGhhdCBBV1MgQ2xvdWRGb3JtYXRpb24gcGF1c2VzIGFmdGVyIG1ha2luZyBhIGNoYW5nZSB0byBhIGJhdGNoIG9mIGluc3RhbmNlcyB0byBnaXZlIHRob3NlIGluc3RhbmNlc1xuICAgKiB0aW1lIHRvIHN0YXJ0IHNvZnR3YXJlIGFwcGxpY2F0aW9ucy4gRm9yIGV4YW1wbGUsIHlvdSBtaWdodCBuZWVkIHRvIHNwZWNpZnkgUGF1c2VUaW1lIHdoZW4gc2NhbGluZyB1cCB0aGUgbnVtYmVyIG9mXG4gICAqIGluc3RhbmNlcyBpbiBhbiBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAqXG4gICAqIElmIHlvdSBlbmFibGUgdGhlIFdhaXRPblJlc291cmNlU2lnbmFscyBwcm9wZXJ0eSwgUGF1c2VUaW1lIGlzIHRoZSBhbW91bnQgb2YgdGltZSB0aGF0IEFXUyBDbG91ZEZvcm1hdGlvbiBzaG91bGQgd2FpdFxuICAgKiBmb3IgdGhlIEF1dG8gU2NhbGluZyBncm91cCB0byByZWNlaXZlIHRoZSByZXF1aXJlZCBudW1iZXIgb2YgdmFsaWQgc2lnbmFscyBmcm9tIGFkZGVkIG9yIHJlcGxhY2VkIGluc3RhbmNlcy4gSWYgdGhlXG4gICAqIFBhdXNlVGltZSBpcyBleGNlZWRlZCBiZWZvcmUgdGhlIEF1dG8gU2NhbGluZyBncm91cCByZWNlaXZlcyB0aGUgcmVxdWlyZWQgbnVtYmVyIG9mIHNpZ25hbHMsIHRoZSB1cGRhdGUgZmFpbHMuIEZvciBiZXN0XG4gICAqIHJlc3VsdHMsIHNwZWNpZnkgYSB0aW1lIHBlcmlvZCB0aGF0IGdpdmVzIHlvdXIgYXBwbGljYXRpb25zIHN1ZmZpY2llbnQgdGltZSB0byBnZXQgc3RhcnRlZC4gSWYgdGhlIHVwZGF0ZSBuZWVkcyB0byBiZVxuICAgKiByb2xsZWQgYmFjaywgYSBzaG9ydCBQYXVzZVRpbWUgY2FuIGNhdXNlIHRoZSByb2xsYmFjayB0byBmYWlsLlxuICAgKlxuICAgKiBTcGVjaWZ5IFBhdXNlVGltZSBpbiB0aGUgSVNPODYwMSBkdXJhdGlvbiBmb3JtYXQgKGluIHRoZSBmb3JtYXQgUFQjSCNNI1MsIHdoZXJlIGVhY2ggIyBpcyB0aGUgbnVtYmVyIG9mIGhvdXJzLCBtaW51dGVzLFxuICAgKiBhbmQgc2Vjb25kcywgcmVzcGVjdGl2ZWx5KS4gVGhlIG1heGltdW0gUGF1c2VUaW1lIGlzIG9uZSBob3VyIChQVDFIKS5cbiAgICovXG4gIHJlYWRvbmx5IHBhdXNlVGltZT86IHN0cmluZztcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHRoZSBBdXRvIFNjYWxpbmcgcHJvY2Vzc2VzIHRvIHN1c3BlbmQgZHVyaW5nIGEgc3RhY2sgdXBkYXRlLiBTdXNwZW5kaW5nIHByb2Nlc3NlcyBwcmV2ZW50cyBBdXRvIFNjYWxpbmcgZnJvbVxuICAgKiBpbnRlcmZlcmluZyB3aXRoIGEgc3RhY2sgdXBkYXRlLiBGb3IgZXhhbXBsZSwgeW91IGNhbiBzdXNwZW5kIGFsYXJtaW5nIHNvIHRoYXQgQXV0byBTY2FsaW5nIGRvZXNuJ3QgZXhlY3V0ZSBzY2FsaW5nXG4gICAqIHBvbGljaWVzIGFzc29jaWF0ZWQgd2l0aCBhbiBhbGFybS4gRm9yIHZhbGlkIHZhbHVlcywgc2VlIHRoZSBTY2FsaW5nUHJvY2Vzc2VzLm1lbWJlci5OIHBhcmFtZXRlciBmb3IgdGhlIFN1c3BlbmRQcm9jZXNzZXNcbiAgICogYWN0aW9uIGluIHRoZSBBdXRvIFNjYWxpbmcgQVBJIFJlZmVyZW5jZS5cbiAgICovXG4gIHJlYWRvbmx5IHN1c3BlbmRQcm9jZXNzZXM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIEF1dG8gU2NhbGluZyBncm91cCB3YWl0cyBvbiBzaWduYWxzIGZyb20gbmV3IGluc3RhbmNlcyBkdXJpbmcgYW4gdXBkYXRlLiBVc2UgdGhpcyBwcm9wZXJ0eSB0b1xuICAgKiBlbnN1cmUgdGhhdCBpbnN0YW5jZXMgaGF2ZSBjb21wbGV0ZWQgaW5zdGFsbGluZyBhbmQgY29uZmlndXJpbmcgYXBwbGljYXRpb25zIGJlZm9yZSB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIHVwZGF0ZSBwcm9jZWVkcy5cbiAgICogQVdTIENsb3VkRm9ybWF0aW9uIHN1c3BlbmRzIHRoZSB1cGRhdGUgb2YgYW4gQXV0byBTY2FsaW5nIGdyb3VwIGFmdGVyIG5ldyBFQzIgaW5zdGFuY2VzIGFyZSBsYXVuY2hlZCBpbnRvIHRoZSBncm91cC5cbiAgICogQVdTIENsb3VkRm9ybWF0aW9uIG11c3QgcmVjZWl2ZSBhIHNpZ25hbCBmcm9tIGVhY2ggbmV3IGluc3RhbmNlIHdpdGhpbiB0aGUgc3BlY2lmaWVkIFBhdXNlVGltZSBiZWZvcmUgY29udGludWluZyB0aGUgdXBkYXRlLlxuICAgKiBUbyBzaWduYWwgdGhlIEF1dG8gU2NhbGluZyBncm91cCwgdXNlIHRoZSBjZm4tc2lnbmFsIGhlbHBlciBzY3JpcHQgb3IgU2lnbmFsUmVzb3VyY2UgQVBJLlxuICAgKlxuICAgKiBUbyBoYXZlIGluc3RhbmNlcyB3YWl0IGZvciBhbiBFbGFzdGljIExvYWQgQmFsYW5jaW5nIGhlYWx0aCBjaGVjayBiZWZvcmUgdGhleSBzaWduYWwgc3VjY2VzcywgYWRkIGEgaGVhbHRoLWNoZWNrXG4gICAqIHZlcmlmaWNhdGlvbiBieSB1c2luZyB0aGUgY2ZuLWluaXQgaGVscGVyIHNjcmlwdC4gRm9yIGFuIGV4YW1wbGUsIHNlZSB0aGUgdmVyaWZ5X2luc3RhbmNlX2hlYWx0aCBjb21tYW5kIGluIHRoZSBBdXRvIFNjYWxpbmdcbiAgICogcm9sbGluZyB1cGRhdGVzIHNhbXBsZSB0ZW1wbGF0ZS5cbiAgICovXG4gIHJlYWRvbmx5IHdhaXRPblJlc291cmNlU2lnbmFscz86IGJvb2xlYW47XG59XG5cbi8qKlxuICogU3BlY2lmaWVzIHdoZXRoZXIgYW4gQXV0byBTY2FsaW5nIGdyb3VwIGFuZCB0aGUgaW5zdGFuY2VzIGl0IGNvbnRhaW5zIGFyZSByZXBsYWNlZCBkdXJpbmcgYW4gdXBkYXRlLiBEdXJpbmcgcmVwbGFjZW1lbnQsXG4gKiBBV1MgQ2xvdWRGb3JtYXRpb24gcmV0YWlucyB0aGUgb2xkIGdyb3VwIHVudGlsIGl0IGZpbmlzaGVzIGNyZWF0aW5nIHRoZSBuZXcgb25lLiBJZiB0aGUgdXBkYXRlIGZhaWxzLCBBV1MgQ2xvdWRGb3JtYXRpb25cbiAqIGNhbiByb2xsIGJhY2sgdG8gdGhlIG9sZCBBdXRvIFNjYWxpbmcgZ3JvdXAgYW5kIGRlbGV0ZSB0aGUgbmV3IEF1dG8gU2NhbGluZyBncm91cC5cbiAqXG4gKiBXaGlsZSBBV1MgQ2xvdWRGb3JtYXRpb24gY3JlYXRlcyB0aGUgbmV3IGdyb3VwLCBpdCBkb2Vzbid0IGRldGFjaCBvciBhdHRhY2ggYW55IGluc3RhbmNlcy4gQWZ0ZXIgc3VjY2Vzc2Z1bGx5IGNyZWF0aW5nXG4gKiB0aGUgbmV3IEF1dG8gU2NhbGluZyBncm91cCwgQVdTIENsb3VkRm9ybWF0aW9uIGRlbGV0ZXMgdGhlIG9sZCBBdXRvIFNjYWxpbmcgZ3JvdXAgZHVyaW5nIHRoZSBjbGVhbnVwIHByb2Nlc3MuXG4gKlxuICogV2hlbiB5b3Ugc2V0IHRoZSBXaWxsUmVwbGFjZSBwYXJhbWV0ZXIsIHJlbWVtYmVyIHRvIHNwZWNpZnkgYSBtYXRjaGluZyBDcmVhdGlvblBvbGljeS4gSWYgdGhlIG1pbmltdW0gbnVtYmVyIG9mXG4gKiBpbnN0YW5jZXMgKHNwZWNpZmllZCBieSB0aGUgTWluU3VjY2Vzc2Z1bEluc3RhbmNlc1BlcmNlbnQgcHJvcGVydHkpIGRvbid0IHNpZ25hbCBzdWNjZXNzIHdpdGhpbiB0aGUgVGltZW91dCBwZXJpb2RcbiAqIChzcGVjaWZpZWQgaW4gdGhlIENyZWF0aW9uUG9saWN5IHBvbGljeSksIHRoZSByZXBsYWNlbWVudCB1cGRhdGUgZmFpbHMgYW5kIEFXUyBDbG91ZEZvcm1hdGlvbiByb2xscyBiYWNrIHRvIHRoZSBvbGRcbiAqIEF1dG8gU2NhbGluZyBncm91cC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5BdXRvU2NhbGluZ1JlcGxhY2luZ1VwZGF0ZSB7XG4gIHJlYWRvbmx5IHdpbGxSZXBsYWNlPzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBXaXRoIHNjaGVkdWxlZCBhY3Rpb25zLCB0aGUgZ3JvdXAgc2l6ZSBwcm9wZXJ0aWVzIG9mIGFuIEF1dG8gU2NhbGluZyBncm91cCBjYW4gY2hhbmdlIGF0IGFueSB0aW1lLiBXaGVuIHlvdSB1cGRhdGUgYVxuICogc3RhY2sgd2l0aCBhbiBBdXRvIFNjYWxpbmcgZ3JvdXAgYW5kIHNjaGVkdWxlZCBhY3Rpb24sIEFXUyBDbG91ZEZvcm1hdGlvbiBhbHdheXMgc2V0cyB0aGUgZ3JvdXAgc2l6ZSBwcm9wZXJ0eSB2YWx1ZXMgb2ZcbiAqIHlvdXIgQXV0byBTY2FsaW5nIGdyb3VwIHRvIHRoZSB2YWx1ZXMgdGhhdCBhcmUgZGVmaW5lZCBpbiB0aGUgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cCByZXNvdXJjZSBvZiB5b3VyIHRlbXBsYXRlLFxuICogZXZlbiBpZiBhIHNjaGVkdWxlZCBhY3Rpb24gaXMgaW4gZWZmZWN0LlxuICpcbiAqIElmIHlvdSBkbyBub3Qgd2FudCBBV1MgQ2xvdWRGb3JtYXRpb24gdG8gY2hhbmdlIGFueSBvZiB0aGUgZ3JvdXAgc2l6ZSBwcm9wZXJ0eSB2YWx1ZXMgd2hlbiB5b3UgaGF2ZSBhIHNjaGVkdWxlZCBhY3Rpb24gaW5cbiAqIGVmZmVjdCwgdXNlIHRoZSBBdXRvU2NhbGluZ1NjaGVkdWxlZEFjdGlvbiB1cGRhdGUgcG9saWN5IHRvIHByZXZlbnQgQVdTIENsb3VkRm9ybWF0aW9uIGZyb20gY2hhbmdpbmcgdGhlIE1pblNpemUsIE1heFNpemUsXG4gKiBvciBEZXNpcmVkQ2FwYWNpdHkgcHJvcGVydGllcyB1bmxlc3MgeW91IGhhdmUgbW9kaWZpZWQgdGhlc2UgdmFsdWVzIGluIHlvdXIgdGVtcGxhdGUuXFxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5BdXRvU2NhbGluZ1NjaGVkdWxlZEFjdGlvbiB7XG4gIC8qXG4gICogU3BlY2lmaWVzIHdoZXRoZXIgQVdTIENsb3VkRm9ybWF0aW9uIGlnbm9yZXMgZGlmZmVyZW5jZXMgaW4gZ3JvdXAgc2l6ZSBwcm9wZXJ0aWVzIGJldHdlZW4geW91ciBjdXJyZW50IEF1dG8gU2NhbGluZ1xuICAqIGdyb3VwIGFuZCB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGRlc2NyaWJlZCBpbiB0aGUgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cCByZXNvdXJjZSBvZiB5b3VyIHRlbXBsYXRlIGR1cmluZ1xuICAqIGEgc3RhY2sgdXBkYXRlLiBJZiB5b3UgbW9kaWZ5IGFueSBvZiB0aGUgZ3JvdXAgc2l6ZSBwcm9wZXJ0eSB2YWx1ZXMgaW4geW91ciB0ZW1wbGF0ZSwgQVdTIENsb3VkRm9ybWF0aW9uIHVzZXMgdGhlIG1vZGlmaWVkXG4gICogdmFsdWVzIGFuZCB1cGRhdGVzIHlvdXIgQXV0byBTY2FsaW5nIGdyb3VwLlxuICAqL1xuIHJlYWRvbmx5IGlnbm9yZVVubW9kaWZpZWRHcm91cFNpemVQcm9wZXJ0aWVzPzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBUbyBwZXJmb3JtIGFuIEFXUyBDb2RlRGVwbG95IGRlcGxveW1lbnQgd2hlbiB0aGUgdmVyc2lvbiBjaGFuZ2VzIG9uIGFuIEFXUzo6TGFtYmRhOjpBbGlhcyByZXNvdXJjZSxcbiAqIHVzZSB0aGUgQ29kZURlcGxveUxhbWJkYUFsaWFzVXBkYXRlIHVwZGF0ZSBwb2xpY3kuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuQ29kZURlcGxveUxhbWJkYUFsaWFzVXBkYXRlIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBBV1MgQ29kZURlcGxveSBhcHBsaWNhdGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IGFwcGxpY2F0aW9uTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgQVdTIENvZGVEZXBsb3kgZGVwbG95bWVudCBncm91cC4gVGhpcyBpcyB3aGVyZSB0aGUgdHJhZmZpYy1zaGlmdGluZyBwb2xpY3kgaXMgc2V0LlxuICAgKi9cbiAgcmVhZG9ubHkgZGVwbG95bWVudEdyb3VwTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgTGFtYmRhIGZ1bmN0aW9uIHRvIHJ1biBiZWZvcmUgdHJhZmZpYyByb3V0aW5nIHN0YXJ0cy5cbiAgICovXG4gIHJlYWRvbmx5IGJlZm9yZUFsbG93VHJhZmZpY0hvb2s/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBMYW1iZGEgZnVuY3Rpb24gdG8gcnVuIGFmdGVyIHRyYWZmaWMgcm91dGluZyBjb21wbGV0ZXMuXG4gICAqL1xuICByZWFkb25seSBhZnRlckFsbG93VHJhZmZpY0hvb2s/OiBzdHJpbmc7XG59XG4iXX0=