# Copyright 2023 The etils Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Tree types."""

from typing import Dict, List, Tuple, TypeVar, Union

_T = TypeVar('_T')

# TODO(b/202712189): Add `Any` to the `Union`
# Tree can be arbitrary `chex.dataclass`, jax structure,... so has to be Any
Tree = Union[_T, List['Tree'], Tuple['Tree', ...], Dict[str, 'Tree']]  # pytype: disable=not-supported-yet
