/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.lang.reflect.Array;

public class CastHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 2;

    @Override
    Object process(Command command) throws Exception {
        if (command.getPayload().length != 2) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 2);
        }
        Class<?> newType = (Class<?>)command.getPayload()[0];
        Object value = command.getPayload()[1];
        if (value.getClass().isArray()) {
            Object[] arr = (Object[])value;
            Class<?> newBaseType = newType.getComponentType();
            Object arrayCasted = Array.newInstance(newType.getComponentType(), arr.length);
            for (int i = 0; i < arr.length; ++i) {
                ((Object[])arrayCasted)[i] = this.castValue(newBaseType, arr[i]);
            }
            return arrayCasted;
        }
        Class<?> newBaseType = newType.isArray() ? newType.getComponentType() : newType;
        return this.castValue(newBaseType, value);
    }

    private Object castValue(Class<?> newBaseType, Object o) {
        if (o == null) {
            return null;
        }
        if (newBaseType.isInstance(o)) {
            return o;
        }
        if (Number.class.isAssignableFrom(newBaseType)) {
            if (newBaseType == Byte.class) {
                return ((Number)o).byteValue();
            }
            if (newBaseType == Short.class) {
                return ((Number)o).shortValue();
            }
            if (newBaseType == Integer.class) {
                return ((Number)o).intValue();
            }
            if (newBaseType == Long.class) {
                return ((Number)o).longValue();
            }
            if (newBaseType == Float.class) {
                return Float.valueOf(((Number)o).floatValue());
            }
            if (newBaseType == Double.class) {
                return ((Number)o).doubleValue();
            }
        } else if (newBaseType.isPrimitive()) {
            if (newBaseType == Integer.TYPE) {
                return ((Number)o).intValue();
            }
            if (newBaseType == Long.TYPE) {
                return ((Number)o).longValue();
            }
            if (newBaseType == Double.TYPE) {
                return ((Number)o).doubleValue();
            }
            if (newBaseType == Float.TYPE) {
                return Float.valueOf(((Number)o).floatValue());
            }
            if (newBaseType == Short.TYPE) {
                return ((Number)o).shortValue();
            }
            if (newBaseType == Byte.TYPE) {
                return ((Number)o).byteValue();
            }
            if (newBaseType == Character.TYPE) {
                return Character.valueOf(((Character)o).charValue());
            }
            if (newBaseType == Boolean.TYPE) {
                return (boolean)((Boolean)o);
            }
        }
        throw new ClassCastException("Jvm Cast Handler: Cannot cast " + o.getClass().getName() + " to " + newBaseType.getName());
    }
}

