/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import com.javonet.utils.HandlerUtils;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class InvokeInstanceMethodHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 2;

    @Override
    Object process(Command command) throws Exception {
        Object[] argumentsForInvoke;
        Method foundMethod;
        if (command.getPayload().length < 2) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 2);
        }
        Object objectClass = command.getPayload()[0];
        String methodToInvoke = command.getPayload()[1].toString();
        Object[] arguments = Arrays.stream(command.getPayload()).skip(2L).toArray();
        try {
            Class<?>[] argumentTypesAsPrimitives = HandlerUtils.getArgumentTypesAsPrimitives(arguments);
            foundMethod = objectClass.getClass().getMethod(methodToInvoke, argumentTypesAsPrimitives);
            argumentsForInvoke = HandlerUtils.convertArgumentsToPrimitives(arguments);
        }
        catch (NoSuchMethodException e) {
            try {
                Class<?>[] argumentTypesAsBoxed = HandlerUtils.getArgumentTypesAsBoxed(arguments);
                foundMethod = objectClass.getClass().getMethod(methodToInvoke, argumentTypesAsBoxed);
                argumentsForInvoke = arguments;
            }
            catch (NoSuchMethodException e2) {
                Method[] methods = objectClass.getClass().getMethods();
                StringBuilder message = new StringBuilder("Method " + methodToInvoke + " with arguments " + Arrays.toString(arguments) + " not found in class " + objectClass.getClass().getName() + ". Available methods:\n");
                for (Method method : methods) {
                    message.append(method.getName()).append(" with arguments ").append(Arrays.toString(method.getParameterTypes())).append("\n");
                }
                throw new NoSuchMethodException(message.toString());
            }
        }
        return foundMethod.invoke(objectClass, argumentsForInvoke);
    }
}

