/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.interpreter;

import com.javonet.core.handler.Handler;
import com.javonet.core.protocol.CommandDeserializer;
import com.javonet.core.protocol.CommandSerializer;
import com.javonet.core.receiver.Receiver;
import com.javonet.core.transmitter.Transmitter;
import com.javonet.core.websocketclient.WebSocketClientJav;
import com.javonet.utils.Command;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.exceptions.ExceptionSerializer;
import com.javonet.utils.messagehelper.MessageHelper;
import java.net.URI;

public class Interpreter {
    private final Handler handler = new Handler();
    private final String debugMode = System.getenv("JAVONET_DEBUG") != null ? System.getenv("JAVONET_DEBUG") : "FALSE";

    public Command execute(Command command, IConnectionData connectionData) {
        byte[] responseByteArray;
        if (this.debugMode.equals("TRUE")) {
            System.out.println("Sent command: " + command.toString());
            MessageHelper.getInstance().sendMessageToAppInsights("SentCommand", command.toString());
        }
        byte[] messageByteArray = new CommandSerializer().serialize(command, connectionData);
        if (connectionData.getConnectionType() == ConnectionType.WEB_SOCKET) {
            try {
                responseByteArray = WebSocketClientJav.sendMessage(new URI(connectionData.getHostname()), messageByteArray);
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    return ExceptionSerializer.serializeException(e.getCause(), command);
                }
                return ExceptionSerializer.serializeException(e, command);
            }
        } else {
            responseByteArray = command.getRuntimeName() == RuntimeName.Jvm && connectionData.getConnectionType() == ConnectionType.IN_MEMORY ? new Receiver().sendCommand(messageByteArray) : Transmitter.sendCommand(messageByteArray);
        }
        Command response = new CommandDeserializer(responseByteArray).deserialize();
        if (this.debugMode.equals("TRUE")) {
            System.out.println("Received command: " + response.toString());
            MessageHelper.getInstance().sendMessageToAppInsights("ReceivedCommand", response.toString());
        }
        return response;
    }

    public Command process(byte[] byteArray) {
        Command receivedCommand = new CommandDeserializer(byteArray).deserialize();
        if (this.debugMode.equals("TRUE")) {
            System.out.println("Received command: " + receivedCommand.toString());
            MessageHelper.getInstance().sendMessageToAppInsights("ReceivedCommand", receivedCommand.toString());
        }
        Command response = this.handler.handleCommand(receivedCommand);
        if (this.debugMode.equals("TRUE")) {
            System.out.println("Response command: " + response.toString());
            MessageHelper.getInstance().sendMessageToAppInsights("ResponseCommand", response.toString());
        }
        return response;
    }
}

