/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.utils.Command;
import com.javonet.utils.JType;
import com.javonet.utils.StringEncodingMode;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class TypeSerializer {
    public static byte[] serializePrimitive(Object payloadItem) {
        if (payloadItem == null) {
            return TypeSerializer.serializeNull();
        }
        if (payloadItem.getClass() == String.class) {
            return TypeSerializer.serializeString((String)payloadItem);
        }
        if (payloadItem.getClass() == Integer.class) {
            return TypeSerializer.serializeInt((Integer)payloadItem);
        }
        if (payloadItem.getClass() == Boolean.class) {
            return TypeSerializer.serializeBool((Boolean)payloadItem);
        }
        if (payloadItem.getClass() == Float.class) {
            return TypeSerializer.serializeFloat(((Float)payloadItem).floatValue());
        }
        if (payloadItem.getClass() == Byte.class) {
            return TypeSerializer.serializeByte((Byte)payloadItem);
        }
        if (payloadItem.getClass() == Character.class) {
            return TypeSerializer.serializeChar(((Character)payloadItem).charValue());
        }
        if (payloadItem.getClass() == Long.class) {
            return TypeSerializer.serializeLong((Long)payloadItem);
        }
        if (payloadItem.getClass() == Double.class) {
            return TypeSerializer.serializeDouble((Double)payloadItem);
        }
        if (payloadItem.getClass() == Short.class) {
            return TypeSerializer.serializeShort((Short)payloadItem);
        }
        throw new IllegalArgumentException("Unsupported payload item type: " + payloadItem.getClass() + " for payload item: " + payloadItem);
    }

    protected static byte[] serializeCommand(Command cmd) {
        ByteBuffer buffer = ByteBuffer.allocate(7);
        buffer.put((byte)JType.COMMAND.ordinal());
        buffer.put(TypeSerializer.serializeIntValue(cmd.getPayloadSize()));
        buffer.put((byte)cmd.getRuntimeName().ordinal());
        buffer.put((byte)cmd.getCommandType().ordinal());
        return buffer.array();
    }

    protected static byte[] serializeString(String val) {
        byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length + 6);
        buffer.put((byte)JType.STRING.ordinal());
        buffer.put((byte)StringEncodingMode.UTF8.ordinal());
        buffer.put(TypeSerializer.serializeIntValue(bytes.length));
        buffer.put(Arrays.copyOfRange(bytes, 0, bytes.length));
        return buffer.array();
    }

    protected static byte[] serializeInt(int val) {
        return new byte[]{(byte)JType.INTEGER.ordinal(), 4, (byte)val, (byte)(val >>> 8 & 0xFF), (byte)(val >>> 16 & 0xFF), (byte)(val >>> 24 & 0xFF)};
    }

    protected static byte[] serializeBool(boolean boolValue) {
        return new byte[]{(byte)JType.BOOLEAN.ordinal(), 1, (byte)(boolValue ? 1 : 0)};
    }

    protected static byte[] serializeFloat(float floatValue) {
        int val = Float.floatToIntBits(floatValue);
        return new byte[]{(byte)JType.FLOAT.ordinal(), 4, (byte)val, (byte)(val >>> 8 & 0xFF), (byte)(val >>> 16 & 0xFF), (byte)(val >>> 24 & 0xFF)};
    }

    protected static byte[] serializeByte(byte byteValue) {
        return new byte[]{(byte)JType.BYTE.ordinal(), 1, byteValue};
    }

    protected static byte[] serializeChar(char charValue) {
        return new byte[]{(byte)JType.CHAR.ordinal(), 1, (byte)charValue};
    }

    protected static byte[] serializeLong(long longValue) {
        return new byte[]{(byte)JType.LONG.ordinal(), 8, (byte)(longValue & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 32 & 0xFFL), (byte)(longValue >> 40 & 0xFFL), (byte)(longValue >> 48 & 0xFFL), (byte)(longValue >> 56 & 0xFFL)};
    }

    protected static byte[] serializeDouble(double doubleValue) {
        long val = Double.doubleToLongBits(doubleValue);
        return new byte[]{(byte)JType.DOUBLE.ordinal(), 8, (byte)(val & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 24 & 0xFFL), (byte)(val >> 32 & 0xFFL), (byte)(val >> 40 & 0xFFL), (byte)(val >> 48 & 0xFFL), (byte)(val >> 56 & 0xFFL)};
    }

    protected static byte[] serializeShort(short shortValue) {
        return new byte[]{(byte)JType.INTEGER.ordinal(), 4, (byte)shortValue, (byte)(shortValue >> 8 & 0xFF), 0, 0};
    }

    private static byte[] serializeIntValue(int intValue) {
        return new byte[]{(byte)(intValue & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 24 & 0xFF)};
    }

    protected static byte[] serializeNull() {
        return new byte[]{(byte)JType.NULL.ordinal(), 1, 0};
    }
}

