/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.receiver;

import com.javonet.core.interpreter.Interpreter;
import com.javonet.core.protocol.CommandSerializer;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeLogger;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.connectiondata.InMemoryConnectionData;
import com.javonet.utils.exceptions.ExceptionSerializer;

public class Receiver {
    private static final IConnectionData connectionData;

    public byte[] sendCommand(byte[] messageByteArray) {
        try {
            return new CommandSerializer().serialize(new Interpreter().process(messageByteArray), connectionData);
        }
        catch (Exception ex) {
            Command exceptionCommand = ExceptionSerializer.serializeException(ex, new Command(RuntimeName.Jvm, CommandType.EXCEPTION, new Object[0]));
            return new CommandSerializer().serialize(exceptionCommand, connectionData);
        }
    }

    public byte[] heartBeat(byte[] messageByteArray) {
        return new byte[]{messageByteArray[11], (byte)(messageByteArray[12] - 2)};
    }

    public String getRuntimeInfo() {
        return RuntimeLogger.getRuntimeInfo();
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler((thread2, throwable) -> {
            throw new RuntimeException(throwable);
        });
        connectionData = new InMemoryConnectionData();
    }
}

