/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.websocketclient;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketClientJav
implements AutoCloseable {
    private static final ConcurrentMap<URI, WebSocketClientJav> CLIENTS = new ConcurrentHashMap<URI, WebSocketClientJav>();
    private static final Object CLIENTS_LOCK = new Object();
    private static final int MAX_BINARY_MESSAGE_BYTES = 0x6400000;
    private static final long RECEIVE_TIMEOUT_SECONDS = 120L;
    private static final long CONNECT_TIMEOUT_SECONDS = 30L;
    private volatile InnerClient socket;
    private final BlockingQueue<byte[]> responseQueue = new ArrayBlockingQueue<byte[]>(1);

    private WebSocketClientJav(URI uri) {
        try {
            boolean connected;
            this.socket = new InnerClient(uri, this.responseQueue, 0x6400000);
            if ("wss".equalsIgnoreCase(uri.getScheme())) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, null);
                SSLSocketFactory factory = sslContext.getSocketFactory();
                this.socket.setSocketFactory(factory);
            }
            if (!(connected = this.socket.connectBlocking(30L, TimeUnit.SECONDS))) {
                throw new RuntimeException("Failed to connect to " + uri + " within timeout");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to connect to " + uri, ex);
        }
    }

    public static byte[] sendMessage(URI uri, byte[] message) {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(message, "message");
        WebSocketClientJav client = WebSocketClientJav.createOrGetClient(uri, null);
        try {
            client.sendByteArray(message);
            return client.receiveByteArray();
        }
        catch (RuntimeException ex) {
            client = WebSocketClientJav.createOrGetClient(uri, client);
            client.sendByteArray(message);
            return client.receiveByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(URI uri) {
        Object object = CLIENTS_LOCK;
        synchronized (object) {
            WebSocketClientJav client = (WebSocketClientJav)CLIENTS.remove(uri);
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean getState(URI uri) {
        Object object = CLIENTS_LOCK;
        synchronized (object) {
            WebSocketClientJav client = (WebSocketClientJav)CLIENTS.get(uri);
            if (client == null) {
                return null;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            InnerClient s = client.socket;
            return s != null && s.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WebSocketClientJav createOrGetClient(URI uri, WebSocketClientJav expectedCurrent) {
        Object object = CLIENTS_LOCK;
        synchronized (object) {
            if (expectedCurrent == null) {
                WebSocketClientJav current = (WebSocketClientJav)CLIENTS.get(uri);
                if (current != null) {
                    if (current.socket != null && current.socket.isOpen()) {
                        return current;
                    }
                    current.close();
                    WebSocketClientJav replaced = new WebSocketClientJav(uri);
                    CLIENTS.put(uri, replaced);
                    return replaced;
                }
                WebSocketClientJav created = new WebSocketClientJav(uri);
                CLIENTS.put(uri, created);
                return created;
            }
            WebSocketClientJav current = (WebSocketClientJav)CLIENTS.get(uri);
            if (current == expectedCurrent) {
                current.close();
                CLIENTS.remove(uri);
            }
            WebSocketClientJav recreated = new WebSocketClientJav(uri);
            CLIENTS.put(uri, recreated);
            return recreated;
        }
    }

    private void sendByteArray(byte[] message) {
        this.ensureOpen();
        try {
            this.socket.send(message);
        }
        catch (Exception ex) {
            throw new RuntimeException("WebSocket send failed", ex);
        }
    }

    private byte[] receiveByteArray() {
        try {
            byte[] resp = this.responseQueue.poll(120L, TimeUnit.SECONDS);
            if (resp == null) {
                throw new RuntimeException("Timed out waiting for WebSocket response");
            }
            if (resp.length == 0) {
                throw new RuntimeException("WebSocket closed or errored while waiting for response");
            }
            return resp;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for response", ie);
        }
    }

    private void ensureOpen() {
        if (this.socket == null || !this.socket.isOpen()) {
            throw new IllegalStateException("WebSocket session is not open");
        }
    }

    @Override
    public void close() {
        try {
            if (this.socket != null && this.socket.isOpen()) {
                this.socket.closeBlocking();
            } else if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final class InnerClient
    extends WebSocketClient {
        private final BlockingQueue<byte[]> responseQueue;
        private final int maxBytes;

        InnerClient(URI serverUri, BlockingQueue<byte[]> responseQueue, int maxBytes) {
            super(serverUri);
            this.responseQueue = responseQueue;
            this.maxBytes = maxBytes;
        }

        @Override
        public void onOpen(ServerHandshake handshakedata) {
        }

        @Override
        public void onMessage(String message) {
            this.offerSafe(message.getBytes());
        }

        @Override
        public void onMessage(ByteBuffer bytes) {
            int len = bytes.remaining();
            if (len > this.maxBytes) {
                this.offerSafe(new byte[0]);
                this.close(1009, "Message too large");
                return;
            }
            byte[] arr = new byte[len];
            bytes.get(arr);
            this.offerSafe(arr);
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
            this.offerSafe(new byte[0]);
        }

        @Override
        public void onError(Exception ex) {
            this.offerSafe(new byte[0]);
        }

        private void offerSafe(byte[] data) {
            if (!this.responseQueue.offer(data)) {
                this.responseQueue.poll();
                this.responseQueue.offer(data);
            }
        }
    }
}

