/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.delegatecache.DelegatesCache;
import com.javonet.core.generator.handler.GeneratorHandler;
import com.javonet.core.interpreter.Interpreter;
import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.InvocationContext;
import com.javonet.sdk.internal.AbstractModuleContext;
import com.javonet.sdk.internal.AbstractRuntimeContext;
import com.javonet.sdk.internal.AbstractTypeContext;
import com.javonet.sdk.tools.BinariesUnloader;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TypesHandler;
import com.javonet.utils.UtilsConst;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.exceptions.ExceptionThrower;
import com.javonet.utils.messagehelper.MessageHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RuntimeContext
implements AbstractTypeContext,
AbstractModuleContext,
AbstractRuntimeContext {
    private final RuntimeName runtimeName;
    private final IConnectionData connectionData;
    private Command currentCommand;
    private Command responseCommand;
    private final Interpreter interpreter = new Interpreter();
    private static final ConcurrentMap<RuntimeName, RuntimeContext> memoryRuntimeContexts = new ConcurrentHashMap<RuntimeName, RuntimeContext>();
    private static final ConcurrentMap<String, RuntimeContext> networkRuntimeContexts = new ConcurrentHashMap<String, RuntimeContext>();
    private static final ConcurrentMap<String, RuntimeContext> webSocketRuntimeContexts = new ConcurrentHashMap<String, RuntimeContext>();
    private final GeneratorHandler generatorHandler = new GeneratorHandler();

    public RuntimeName getRuntimeName() {
        return this.runtimeName;
    }

    public IConnectionData getConnectionData() {
        return this.connectionData;
    }

    private RuntimeContext(RuntimeName runtimeName, IConnectionData connectionData) {
        this.runtimeName = runtimeName;
        this.connectionData = connectionData;
        MessageHelper.getInstance().sendMessageToAppInsights("SdkMessage", runtimeName.toString() + " initialized");
        if (this.connectionData.getConnectionType() == ConnectionType.WEB_SOCKET) {
            return;
        }
        if (this.runtimeName == RuntimeName.Jvm && this.connectionData.getConnectionType() == ConnectionType.IN_MEMORY) {
            return;
        }
        BinariesUnloader.extractBinariesFromJar("Native");
        BinariesUnloader.extractBinariesFromJar(runtimeName.toString());
        Transmitter.setJavonetWorkingDirectory(UtilsConst.getJavonetWorkingDirectory());
        if (!UtilsConst.getConfigSource().isEmpty()) {
            Transmitter.setConfigSource(UtilsConst.getConfigSource());
        }
        Transmitter.activate(UtilsConst.getLicenseKey());
    }

    public static RuntimeContext getInstance(RuntimeName runtimeName, IConnectionData connectionData) {
        switch (connectionData.getConnectionType()) {
            case IN_MEMORY: {
                return memoryRuntimeContexts.computeIfAbsent(runtimeName, k -> new RuntimeContext(runtimeName, connectionData));
            }
            case TCP: {
                String networkRuntimeContextsKey = (Object)((Object)runtimeName) + ":" + connectionData.toString();
                return networkRuntimeContexts.computeIfAbsent(networkRuntimeContextsKey, k -> new RuntimeContext(runtimeName, connectionData));
            }
            case WEB_SOCKET: {
                String webSocketRuntimeContextsKey = (Object)((Object)runtimeName) + ":" + connectionData.toString();
                return webSocketRuntimeContexts.computeIfAbsent(webSocketRuntimeContextsKey, k -> new RuntimeContext(runtimeName, connectionData));
            }
        }
        throw new RuntimeException("Unknown connection type: " + (Object)((Object)connectionData.getConnectionType()));
    }

    @Override
    public void execute() {
        this.responseCommand = this.interpreter.execute(this.currentCommand, this.connectionData);
        this.currentCommand = null;
        if (this.responseCommand.getCommandType() == CommandType.EXCEPTION) {
            ExceptionThrower.throwException(this.responseCommand);
        }
    }

    @Override
    public RuntimeContext loadLibrary(String libraryPath) {
        Command localCommand = new Command(this.runtimeName, CommandType.LOAD_LIBRARY, libraryPath);
        this.currentCommand = this.buildCommand(localCommand);
        this.execute();
        return this;
    }

    @Override
    public InvocationContext getType(String typeName, Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_TYPE, this.createArgsArray(typeName, args2));
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext cast(Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.CAST, args2);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext invokeGlobalMethod(Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_GLOBAL_FUNCTION, args2);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public RuntimeContext generateLibrary(Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.GENERATE_LIB, args2);
        this.currentCommand = this.buildCommand(localCommand);
        this.execute();
        this.generatorHandler.generate(this.responseCommand, System.getProperty("user.dir"));
        return this;
    }

    public InvocationContext getEnumItem(Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_ENUM_ITEM, args2);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext asOut(Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.AS_OUT, args2);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext asRef(Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.AS_REF, args2);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext invokeGlobalFunction(String functionName, Object ... args2) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_GLOBAL_FUNCTION, this.createArgsArray(functionName, args2));
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext getGlobalField(String fieldName) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_GLOBAL_FIELD, fieldName);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    private Command buildCommand(Command command) {
        for (int i = 0; i < command.getPayload().length; ++i) {
            command.setPayload(this.encapsulatePayloadItem(command.getPayload()[i]), i);
        }
        return command.prependArgumentToPayload(this.currentCommand);
    }

    private Command encapsulatePayloadItem(Object payloadItem) {
        if (payloadItem == null) {
            return new Command(this.runtimeName, CommandType.VALUE, payloadItem);
        }
        if (payloadItem instanceof Command) {
            for (int i = 0; i < ((Command)payloadItem).getPayload().length; ++i) {
                ((Command)payloadItem).setPayload(this.encapsulatePayloadItem(((Command)payloadItem).getPayload()[i]), i);
            }
            return (Command)payloadItem;
        }
        if (payloadItem instanceof InvocationContext) {
            return ((InvocationContext)payloadItem).getCurrentCommand();
        }
        if (payloadItem instanceof Type) {
            return new Command(this.runtimeName, CommandType.CONVERT_TYPE, TypesHandler.convertTypeToJType((Type)payloadItem));
        }
        if (payloadItem.getClass().isArray()) {
            int length = Array.getLength(payloadItem);
            Object[] objectArray = new Object[length];
            for (int i = 0; i < length; ++i) {
                objectArray[i] = this.encapsulatePayloadItem(Array.get(payloadItem, i));
            }
            return new Command(this.runtimeName, CommandType.ARRAY, objectArray);
        }
        if (payloadItem instanceof Method) {
            Object[] types = new Object[((Method)payloadItem).getParameterCount() + 1];
            for (int i = 0; i < types.length - 1; ++i) {
                types[i] = ((Method)payloadItem).getParameterTypes()[i];
            }
            types[types.length - 1] = ((Method)payloadItem).getReturnType();
            Object[] delegateArray = new Object[]{DelegatesCache.getInstance().addDelegate((Method)payloadItem), RuntimeName.Jvm.ordinal()};
            Object[] args2 = new Object[delegateArray.length + types.length];
            System.arraycopy(delegateArray, 0, args2, 0, delegateArray.length);
            System.arraycopy(types, 0, args2, delegateArray.length, types.length);
            for (int i = 0; i < args2.length; ++i) {
                args2[i] = this.encapsulatePayloadItem(args2[i]);
            }
            return new Command(this.runtimeName, CommandType.PASS_DELEGATE, args2);
        }
        if (TypesHandler.isPrimitiveOrNull(payloadItem).booleanValue()) {
            return new Command(this.runtimeName, CommandType.VALUE, payloadItem);
        }
        throw new IllegalArgumentException("Unsupported payload item type: " + payloadItem.getClass().getName() + " for payload item: " + payloadItem);
    }

    private Object[] createArgsArray(Object arg1, Object ... args2) {
        if (args2 == null) {
            return new Object[]{arg1, null};
        }
        Object[] argsArray = Arrays.copyOf(new Object[]{arg1}, args2.length + 1);
        System.arraycopy(args2, 0, argsArray, 1, args2.length);
        return argsArray;
    }

    public void healthCheck() {
        Command localCommand = new Command(this.runtimeName, CommandType.VALUE, "health_check");
        this.currentCommand = this.buildCommand(localCommand);
        this.execute();
    }
}

