/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.configuration;

import com.javonet.sdk.configuration.Config;
import com.javonet.sdk.configuration.ConfigPriority;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class ConfigsDictionary {
    private static final ConcurrentMap<String, ConcurrentMap<ConfigPriority, Config>> configurationsCollection = new ConcurrentHashMap<String, ConcurrentMap<ConfigPriority, Config>>();
    private static final List<ConfigPriority> prioritiesInOrder = Arrays.stream(ConfigPriority.values()).sorted(Comparator.comparingInt(Enum::ordinal)).collect(Collectors.toList());

    public static void addConfig(String name, ConfigPriority priority, Config config) {
        if (name == null || name.trim().isEmpty()) {
            System.out.println("Config name cannot be null or whitespace. Skipping add.");
            return;
        }
        if (config == null) {
            System.out.println("Config instance is null. Skipping add.");
            return;
        }
        ConcurrentMap perPriority = configurationsCollection.computeIfAbsent(name, k -> new ConcurrentHashMap());
        if (perPriority.putIfAbsent(priority, config) != null) {
            System.out.println("Config with name '" + name + "' and priority '" + (Object)((Object)priority) + "' already exists. Skipping.");
            return;
        }
        System.out.println("Added configuration '" + name + "' with priority '" + (Object)((Object)priority) + "' and parameters " + config);
    }

    public static Config getConfig(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Config name cannot be null or whitespace");
        }
        ConcurrentMap perPriority = (ConcurrentMap)configurationsCollection.get(name);
        if (perPriority == null || perPriority.isEmpty()) {
            throw new IllegalArgumentException("Configuration " + name + " not found");
        }
        for (ConfigPriority priority : prioritiesInOrder) {
            Config cfg = (Config)perPriority.get((Object)priority);
            if (cfg == null) continue;
            System.out.println("Retrieved configuration `" + name + "` with priority `" + (Object)((Object)priority) + "` and parameters " + cfg);
            return cfg;
        }
        throw new IllegalArgumentException("Configuration " + name + " not found");
    }

    public static void clearConfigs() {
        configurationsCollection.clear();
    }
}

