/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.configuration.configresolvers;

import com.javonet.utils.RuntimeName;
import com.javonet.utils.RuntimeNameHandler;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.connectiondata.InMemoryConnectionData;
import com.javonet.utils.connectiondata.TcpConnectionData;
import com.javonet.utils.connectiondata.WsConnectionData;
import java.net.UnknownHostException;

public abstract class ConfigResolver {
    protected static RuntimeName tryParseRuntime(String runtime) {
        if (runtime == null || runtime.trim().isEmpty()) {
            throw new IllegalArgumentException("Runtime string cannot be null or whitespace.");
        }
        runtime = runtime.trim();
        return RuntimeNameHandler.getRuntimeName(runtime);
    }

    protected static IConnectionData buildConnectionData(String hostValue) {
        if (hostValue == null || hostValue.trim().isEmpty()) {
            return new InMemoryConnectionData();
        }
        String hv = hostValue.trim();
        String lower = hv.toLowerCase();
        if (lower.equals("inmemory") || lower.equals("in-memory")) {
            return new InMemoryConnectionData();
        }
        if (lower.startsWith("ws://") || lower.startsWith("wss://")) {
            return new WsConnectionData(hv);
        }
        if (lower.startsWith("tcp://")) {
            try {
                return ConfigResolver.parseTcp(hv.substring(6));
            }
            catch (Exception e) {
                return new InMemoryConnectionData();
            }
        }
        int colon = hv.indexOf(58);
        if (colon > 0 && colon < hv.length() - 1) {
            String portPart = hv.substring(colon + 1);
            int slash = portPart.indexOf(47);
            if (slash >= 0) {
                portPart = portPart.substring(0, slash);
            }
            try {
                int port = Integer.parseInt(portPart);
                String hostOnly = hv.substring(0, colon);
                if (hostOnly != null && !hostOnly.trim().isEmpty()) {
                    try {
                        return new TcpConnectionData(hostOnly, port);
                    }
                    catch (Exception e) {
                        return new InMemoryConnectionData();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new InMemoryConnectionData();
    }

    protected static IConnectionData parseTcp(String address) throws UnknownHostException {
        int port;
        int slash = address.indexOf(47);
        String hostPort = slash >= 0 ? address.substring(0, slash) : address;
        int colon = hostPort.lastIndexOf(58);
        if (colon <= 0 || colon >= hostPort.length() - 1) {
            throw new IllegalArgumentException("Invalid tcp:// format.");
        }
        String host = hostPort.substring(0, colon);
        String portStr = hostPort.substring(colon + 1);
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port in tcp:// address.");
        }
        return new TcpConnectionData(host, port);
    }
}

