/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.tools;

import com.javonet.sdk.Javonet;
import com.javonet.utils.UtilsConst;
import com.javonet.utils.messagehelper.MessageHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public final class BinariesUnloader {
    private static final Map<String, Boolean> extractedForRuntime = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Object> runtimeLocks = new ConcurrentHashMap<String, Object>();

    private BinariesUnloader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractBinariesFromJar(String runtimeName) {
        Object lock;
        if (BinariesUnloader.isAndroid()) {
            return false;
        }
        Boolean done = extractedForRuntime.get(runtimeName);
        if (done != null && done.booleanValue()) {
            return true;
        }
        Object object = lock = runtimeLocks.computeIfAbsent(runtimeName, rn -> new Object());
        synchronized (object) {
            done = extractedForRuntime.get(runtimeName);
            if (done != null && done.booleanValue()) {
                return true;
            }
            try {
                String binariesRuntimePath = BinariesUnloader.getBinariesSpecificPath(runtimeName);
                String currentVersion = BinariesUnloader.getManifestProperty("Version");
                Path BASE_ROOT = Paths.get(UtilsConst.getJavonetWorkingDirectory(), new String[0]);
                Path destRoot = BASE_ROOT.resolve(binariesRuntimePath);
                if (BinariesUnloader.needsExtraction(destRoot, currentVersion)) {
                    BinariesUnloader.ensureDirectory(destRoot);
                    String container = BinariesUnloader.getJarPath(Javonet.class);
                    if (container.contains("!")) {
                        try (JarInputStream jis = BinariesUnloader.openNestedJarStream(container);){
                            BinariesUnloader.extractFromJarInputStream(jis, binariesRuntimePath, BASE_ROOT);
                        }
                    }
                    try (JarFile jarFile = new JarFile(container);){
                        BinariesUnloader.extractFromJarFile(jarFile, binariesRuntimePath, BASE_ROOT);
                    }
                    if (currentVersion != null) {
                        BinariesUnloader.writeVersionFile(destRoot, currentVersion);
                    }
                }
                extractedForRuntime.put(runtimeName, true);
                return true;
            }
            catch (Exception e) {
                BinariesUnloader.safeLog("BinariesUnloader exception: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                extractedForRuntime.put(runtimeName, false);
                return false;
            }
        }
    }

    private static void extractFromJarFile(JarFile jarFile, String prefix, Path baseRoot) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(prefix)) continue;
            BinariesUnloader.extractEntry(entry, () -> jarFile.getInputStream(entry), baseRoot);
        }
    }

    private static void extractFromJarInputStream(JarInputStream jis, String prefix, Path baseRoot) throws IOException {
        JarEntry entry;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (!entry.getName().startsWith(prefix)) continue;
            InputStreamSupplier supplier = () -> jis;
            BinariesUnloader.extractEntry(entry, supplier, baseRoot);
        }
    }

    private static void extractEntry(JarEntry entry, InputStreamSupplier input, Path baseRoot) throws IOException {
        String entryName = entry.getName();
        if (entry.isDirectory()) {
            Path dir = BinariesUnloader.safeResolve(baseRoot, entryName);
            Files.createDirectories(dir, new FileAttribute[0]);
            return;
        }
        Path target = BinariesUnloader.safeResolve(baseRoot, entryName);
        BinariesUnloader.ensureDirectory(target.getParent());
        if (BinariesUnloader.isFileInUse(target.toString())) {
            return;
        }
        Path tmp = target.resolveSibling(target.getFileName() + ".tmp-" + UUID.randomUUID().toString());
        try (InputStream in = input.open();
             OutputStream out = Files.newOutputStream(tmp, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            BinariesUnloader.copy(in, out);
        }
        try {
            Files.move(tmp, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException ex) {
            Files.move(tmp, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static boolean needsExtraction(Path destRoot, String currentVersion) throws IOException {
        if (!Files.isDirectory(destRoot, new LinkOption[0])) {
            return true;
        }
        if (currentVersion == null) {
            return false;
        }
        Path versionFile = destRoot.resolve("version.txt");
        if (!Files.exists(versionFile, new LinkOption[0])) {
            return true;
        }
        String oldVersion = new String(Files.readAllBytes(versionFile), StandardCharsets.UTF_8).replace("'", "").trim();
        return !currentVersion.equals(oldVersion);
    }

    private static void writeVersionFile(Path destRoot, String currentVersion) throws IOException {
        Path versionFile = destRoot.resolve("version.txt");
        BinariesUnloader.ensureDirectory(destRoot);
        Files.write(versionFile, currentVersion.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static String getBinariesSpecificPath(String runtimeName) {
        String osName = BinariesUnloader.getOsName();
        String arch = BinariesUnloader.getOsArch();
        if ("Native".equals(runtimeName) || "Perl".equals(runtimeName)) {
            return "Binaries/" + runtimeName + "/" + osName + "/" + arch + "/";
        }
        return "Binaries/" + runtimeName + "/";
    }

    private static boolean isAndroid() {
        String vendor = System.getProperty("java.vendor", "").toLowerCase(Locale.US);
        String rt = System.getProperty("java.runtime.name", "").toLowerCase(Locale.US);
        String osver = System.getProperty("os.version", "").toLowerCase(Locale.US);
        return vendor.contains("android") || rt.contains("android") || osver.contains("android");
    }

    private static String getOsArch() {
        String arch = System.getProperty("os.arch", "").toLowerCase(Locale.ROOT);
        if (arch.contains("aarch64") || arch.contains("arm64")) {
            return "ARM64";
        }
        if (arch.contains("arm")) {
            return "ARM";
        }
        if (arch.contains("64") || arch.contains("amd64") || arch.contains("x86_64")) {
            return "X64";
        }
        return "X86";
    }

    private static String getOsName() {
        String os = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        if (os.contains("win")) {
            return "Windows";
        }
        if (os.contains("mac")) {
            return "MacOs";
        }
        return "Linux";
    }

    private static JarInputStream openNestedJarStream(String jarUrl) throws IOException {
        URL url = new URL(jarUrl);
        JarURLConnection conn = (JarURLConnection)url.openConnection();
        return new JarInputStream(conn.getInputStream());
    }

    private static String getJarPath(Class<?> aclass) {
        String suffix;
        URL url;
        try {
            url = aclass.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (SecurityException ex) {
            url = aclass.getResource(aclass.getSimpleName() + ".class");
        }
        String extURL = url.toExternalForm();
        if (extURL.contains(".jar!")) {
            return extURL;
        }
        if (!extURL.endsWith(".jar") && (extURL = extURL.replace(suffix = "/" + aclass.getName().replace(".", "/") + ".class", "")).startsWith("jar:") && extURL.endsWith(".jar!")) {
            extURL = extURL.substring(4);
        }
        try {
            return new File(new URL(extURL).toURI()).getAbsolutePath();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            return new File(url.getPath()).getAbsolutePath();
        }
    }

    public static String getManifestProperty(String propertyName) throws IOException {
        Enumeration<URL> resources = BinariesUnloader.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream input = resources.nextElement().openStream();
            Throwable throwable = null;
            try {
                Manifest manifest = new Manifest(input);
                Attributes main = manifest.getMainAttributes();
                String value = main.getValue(propertyName);
                if (value == null) continue;
                String string = value;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                input.close();
            }
        }
        return null;
    }

    private static Path safeResolve(Path baseRoot, String entryName) throws IOException {
        Path allowed;
        Path target = baseRoot.resolve(entryName).normalize();
        if (!target.startsWith(allowed = baseRoot.normalize())) {
            throw new IOException("Blocked suspicious entry path: " + entryName);
        }
        return target;
    }

    private static void ensureDirectory(Path dir) throws IOException {
        if (dir != null && !Files.isDirectory(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    private static void safeLog(String msg) {
        try {
            MessageHelper.getInstance().sendMessageToAppInsights("SdkException", msg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isFileInUse(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            FileLock lock = channel.tryLock();
            if (lock == null) {
                boolean bl2 = true;
                return bl2;
            }
            lock.release();
            boolean bl = false;
            return bl;
        }
        catch (IOException | OverlappingFileLockException e) {
            return true;
        }
    }

    private static interface InputStreamSupplier {
        public InputStream open() throws IOException;
    }
}

