/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.javonet.utils.UtilsConst;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class JsonResolver {
    private final String configSource_;
    private final JsonObject jsonObject;
    private JsonElement runtimes;
    private Boolean isConfigSourcePath = false;

    public Boolean isConfigSourcePath() {
        return this.isConfigSourcePath;
    }

    public JsonResolver(String configSource) {
        this.configSource_ = configSource;
        String jsonText = "";
        try {
            if (Files.exists(Paths.get(this.configSource_, new String[0]), new LinkOption[0])) {
                jsonText = new String(Files.readAllBytes(Paths.get(this.configSource_, new String[0])));
                this.isConfigSourcePath = true;
            } else {
                jsonText = this.configSource_;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Configuration source is not a valid JSON. Check your configuration:\n%s", this.configSource_));
        }
        catch (InvalidPathException e) {
            jsonText = this.configSource_;
        }
        try {
            this.jsonObject = JsonParser.parseString(jsonText).getAsJsonObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Configuration source is not a valid JSON. Check your configuration:\n%s", this.configSource_));
        }
        UtilsConst.setConfigSource(this.configSource_);
    }

    public String getLicenseKey() {
        try {
            return this.jsonObject.get("licenseKey").getAsString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("License key not found in configuration source. Check your configuration source.");
        }
    }

    public String getWorkingDirectory() {
        try {
            return this.jsonObject.get("workingDirectory").getAsString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Working directory not found in configuration source. Check your configuration source.");
        }
    }

    private void getRuntimes() {
        this.runtimes = this.jsonObject.get("runtimes");
    }

    private JsonElement getRuntime(String runtimeName, String configName) {
        this.getRuntimes();
        JsonElement runtime = this.runtimes.getAsJsonObject().get(runtimeName);
        if (runtime.isJsonArray()) {
            for (JsonElement item : runtime.getAsJsonArray()) {
                if (!item.getAsJsonObject().get("name").getAsString().equals(configName)) continue;
                return item;
            }
        } else if (runtime.getAsJsonObject().get("name").getAsString().equals(configName)) {
            return runtime;
        }
        throw new IllegalArgumentException("Runtime config " + configName + " not found in configuration source for runtime " + runtimeName + ". Check your configuration source.");
    }

    private String getRuntimeName(String runtimeName, String configName) {
        JsonElement runtime = this.getRuntime(runtimeName, configName);
        return runtime.getAsJsonObject().get("name").getAsString();
    }

    private JsonElement getChannel(String runtimeName, String configName) {
        JsonElement runtime = this.getRuntime(runtimeName, configName);
        return runtime.getAsJsonObject().get("channel");
    }

    public String getChannelType(String runtimeName, String configName) {
        JsonElement channel = this.getChannel(runtimeName, configName);
        return channel.getAsJsonObject().get("type").getAsString();
    }

    public String getChannelHost(String runtimeName, String configName) {
        JsonElement channel = this.getChannel(runtimeName, configName);
        return channel.getAsJsonObject().get("host").getAsString();
    }

    public int getChannelPort(String runtimeName, String configName) {
        JsonElement channel = this.getChannel(runtimeName, configName);
        return channel.getAsJsonObject().get("port").getAsInt();
    }

    public String getModules(String runtimeName, String configName) {
        JsonElement runtime = this.getRuntime(runtimeName, configName);
        if (runtime.getAsJsonObject().has("modules")) {
            return runtime.getAsJsonObject().get("modules").getAsString();
        }
        return "";
    }
}

