/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.tools.TypeParsingFunctions;

import com.javonet.sdk.InvocationContext;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class NetcoreTypeParsingFunctions {
    private static final long TICKS_AT_UNIX_EPOCH = 621355968000000000L;
    public static final Map<String, Function<InvocationContext, Object>> PARSING_FUNCTIONS;

    private NetcoreTypeParsingFunctions() {
    }

    static {
        HashMap<String, Function<InvocationContext, Object>> tmp = new HashMap<String, Function<InvocationContext, Object>>();
        tmp.put("java.time.Instant", ic -> {
            long ticks = ((Number)ic.getInstanceField("Ticks").execute().getValue()).longValue();
            long epochMillis = (ticks - 621355968000000000L) / 10000L;
            Instant instant = Instant.ofEpochMilli(epochMillis);
            return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        });
        PARSING_FUNCTIONS = Collections.unmodifiableMap(tmp);
    }
}

