/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeName;
import java.util.Arrays;
import java.util.Objects;

public class Command {
    private final RuntimeName runtimeName;
    private final CommandType commandType;
    private final Object[] payload;

    public Command(RuntimeName runtimeName, CommandType commandType, Object ... payload) {
        this.runtimeName = runtimeName;
        this.commandType = commandType;
        this.payload = payload;
    }

    public int getPayloadSize() {
        return this.payload.length;
    }

    public String toString() {
        try {
            StringBuilder result = new StringBuilder("RuntimeName ");
            result.append((Object)this.runtimeName);
            result.append(" ");
            result.append("CommandType ");
            result.append((Object)this.commandType);
            result.append(" ");
            result.append("Payload ");
            for (int i = 0; i < this.payload.length; ++i) {
                if (this.payload[i] == null) {
                    result.append("null");
                } else {
                    result.append(this.payload[i]);
                }
                if (i >= this.payload.length - 1) continue;
                result.append(" ");
            }
            return result.toString();
        }
        catch (Exception ex) {
            return "Error while converting command to string: " + ex.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command that = (Command)o;
        return this.runtimeName == that.runtimeName && this.commandType == that.commandType && Arrays.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return 31 * (Objects.hash(new Object[]{this.runtimeName, this.commandType}) + Arrays.hashCode(this.getHashablePayload()));
    }

    private Object[] getHashablePayload() {
        switch (this.commandType) {
            case VALUE: 
            case LOAD_LIBRARY: 
            case CREATE_INSTANCE: 
            case GET_TYPE: {
                return new Object[]{this.payload[0]};
            }
            case GET_STATIC_FIELD: 
            case SET_STATIC_FIELD: 
            case GET_MODULE: 
            case INVOKE_STATIC_METHOD: 
            case INVOKE_INSTANCE_METHOD: {
                return new Object[]{this.payload[0], this.payload[1]};
            }
        }
        throw new RuntimeException((Object)((Object)this.commandType) + " payload size not implemented");
    }

    public RuntimeName getRuntimeName() {
        return this.runtimeName;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public Object[] getPayload() {
        return this.payload;
    }

    public void setPayload(Object obj, int i) {
        this.payload[i] = obj;
    }

    public Command dropFirstPayloadArg() {
        if (this.payload.length <= 1) {
            return new Command(this.runtimeName, this.commandType, new Object[0]);
        }
        Object[] newPayload = new Object[this.payload.length - 1];
        System.arraycopy(this.payload, 1, newPayload, 0, newPayload.length);
        return new Command(this.runtimeName, this.commandType, newPayload);
    }

    public Command addArgToPayload(Object arg) {
        Object[] newPayload = new Object[this.payload.length + 1];
        System.arraycopy(this.payload, 0, newPayload, 0, this.payload.length);
        newPayload[this.payload.length] = arg;
        return new Command(this.runtimeName, this.commandType, newPayload);
    }

    public Command prependArgumentToPayload(Object arg) {
        if (arg == null) {
            return new Command(this.runtimeName, this.commandType, this.payload);
        }
        Object[] newPayload = new Object[this.payload.length + 1];
        newPayload[0] = arg;
        System.arraycopy(this.payload, 0, newPayload, 1, this.payload.length);
        return new Command(this.runtimeName, this.commandType, newPayload);
    }

    public static Command createResponse(Object response, RuntimeName runtimeName) {
        return new Command(runtimeName, CommandType.VALUE, response);
    }

    public static Command createReference(Object response, RuntimeName runtimeName) {
        return new Command(runtimeName, CommandType.REFERENCE, response);
    }

    public static Command createArrayResponse(Object[] response, RuntimeName runtimeName) {
        return new Command(runtimeName, CommandType.ARRAY, response);
    }
}

