/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils.exceptions;

import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.ExceptionType;
import com.javonet.utils.RuntimeName;
import java.util.Arrays;
import java.util.Optional;

public class ExceptionSerializer {
    public static Command serializeException(Throwable exception, Command command) {
        Command exceptionCommand = new Command(RuntimeName.Jvm, CommandType.EXCEPTION, new Object[0]);
        StringBuilder stackClasses = new StringBuilder();
        StringBuilder stackMethods = new StringBuilder();
        StringBuilder stackLines = new StringBuilder();
        StringBuilder stackFiles = new StringBuilder();
        try {
            StackTraceElement[] stackTraceElements = exception.getStackTrace();
            for (int i = 0; i < stackTraceElements.length; ++i) {
                int line;
                String fileName;
                String methodName;
                String className;
                StackTraceElement frame = stackTraceElements[i];
                try {
                    className = frame.getClassName() != null ? frame.getClassName() : "undefined";
                }
                catch (Exception e) {
                    className = "undefined";
                }
                try {
                    methodName = frame.getMethodName() != null ? frame.getMethodName() : "undefined";
                }
                catch (Exception e) {
                    methodName = "undefined";
                }
                try {
                    fileName = frame.getFileName() != null ? frame.getFileName() : "undefined";
                }
                catch (Exception e) {
                    fileName = "undefined";
                }
                try {
                    line = frame.getLineNumber();
                    if (line < 0) {
                        line = 0;
                    }
                }
                catch (Exception e) {
                    line = 0;
                }
                if (className.contains("javonet") || className.contains("reflect")) continue;
                stackClasses.append(className);
                stackMethods.append(methodName);
                stackLines.append(line);
                stackFiles.append(fileName);
                if (i == stackTraceElements.length - 1) continue;
                stackClasses.append("|");
                stackMethods.append("|");
                stackLines.append("|");
                stackFiles.append("|");
            }
            exceptionCommand = exceptionCommand.addArgToPayload(ExceptionSerializer.getExceptionCode(exception));
            exceptionCommand = exceptionCommand.addArgToPayload(command != null ? command.toString() : "Command is null");
            exceptionCommand = exceptionCommand.addArgToPayload(exception.getClass().getName());
            exceptionCommand = exceptionCommand.addArgToPayload(exception.getMessage());
            exceptionCommand = exceptionCommand.addArgToPayload(stackClasses.toString());
            exceptionCommand = exceptionCommand.addArgToPayload(stackMethods.toString());
            exceptionCommand = exceptionCommand.addArgToPayload(stackLines.toString());
            exceptionCommand = exceptionCommand.addArgToPayload(stackFiles.toString());
        }
        catch (Exception ex) {
            exceptionCommand = new Command(RuntimeName.Jvm, CommandType.EXCEPTION, new Object[0]);
            stackClasses.append("ExceptionSerializer");
            stackMethods.append("serializeException");
            stackLines.append("undefined");
            stackFiles.append("ExceptionSerializer.java");
            exceptionCommand = exceptionCommand.addArgToPayload(ExceptionSerializer.getExceptionCode(ex));
            exceptionCommand = exceptionCommand.addArgToPayload(command != null ? command.toString() : "Command is null");
            exceptionCommand = exceptionCommand.addArgToPayload("Java Exception Serialization Error");
            exceptionCommand = exceptionCommand.addArgToPayload(ex.getMessage());
            exceptionCommand = exceptionCommand.addArgToPayload(stackClasses.toString());
            exceptionCommand = exceptionCommand.addArgToPayload(stackMethods.toString());
            exceptionCommand = exceptionCommand.addArgToPayload(stackLines.toString());
            exceptionCommand = exceptionCommand.addArgToPayload(stackFiles.toString());
        }
        return exceptionCommand;
    }

    private static void serializeStackTrace(StackTraceElement[] stackTraceElements, StringBuilder stackClasses, StringBuilder stackMethods, StringBuilder stackLines, StringBuilder stackFiles) {
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            stackClasses.append(Optional.of(stackTraceElement.getClassName()).orElse("undefined")).append("|");
            stackMethods.append(Optional.of(stackTraceElement.getMethodName()).orElse("undefined")).append("|");
            stackLines.append(Optional.of(stackTraceElement.getLineNumber()).orElse(0)).append("|");
            stackFiles.append(Optional.ofNullable(stackTraceElement.getFileName()).orElse("undefined")).append("|");
        }
    }

    private static StackTraceElement[] getStackTraceAfterReflection(StackTraceElement[] stackTrace) {
        int index = 0;
        for (StackTraceElement element : stackTrace) {
            if (element.getClassName().contains("javonet") || element.getClassName().contains("reflect")) break;
            ++index;
        }
        return Arrays.copyOfRange(stackTrace, 0, index);
    }

    private static Object getExceptionCode(Throwable exception) {
        switch (exception.getClass().getSimpleName()) {
            case "IOException": {
                return ExceptionType.IO_EXCEPTION.ordinal();
            }
            case "FileNotFoundException": {
                return ExceptionType.FILE_NOT_FOUND_EXCEPTION.ordinal();
            }
            case "RuntimeException": {
                return ExceptionType.RUNTIME_EXCEPTION.ordinal();
            }
            case "ArithmeticException": {
                return ExceptionType.ARITHMETIC_EXCEPTION.ordinal();
            }
            case "IllegalArgumentException": {
                return ExceptionType.ILLEGAL_ARGUMENT_EXCEPTION.ordinal();
            }
            case "IndexOutOfBoundsException": 
            case "StringIndexOutOfBoundsException": 
            case "ArrayIndexOutOfBoundsException": {
                return ExceptionType.INDEX_OUT_OF_BOUNDS_EXCEPTION.ordinal();
            }
            case "NullPointerException": {
                return ExceptionType.NULL_POINTER_EXCEPTION.ordinal();
            }
        }
        return ExceptionType.EXCEPTION.ordinal();
    }
}

