/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils.messagehelper;

import com.javonet.sdk.Javonet;
import com.javonet.sdk.tools.HttpConnection;
import com.javonet.utils.UtilsConst;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;

public class MessageHelper {
    private static final String address = "https://dc.services.visualstudio.com/v2/track";
    private static final String instrumentationKey = System.getenv("JAVONET_INSTRUMENTATION_KEY") != null ? System.getenv("JAVONET_INSTRUMENTATION_KEY") : "2c751560-90c8-40e9-b5dd-534566514723";
    private static final String callingRuntimeName = "Jvm";
    private static final String javonetVersion = MessageHelper.getJavonetVersion();
    private static final String nodeName = MessageHelper.getHostName();
    private static final String osName = System.getProperty("os.name");
    private static MessageHelper instance_;
    private static HttpConnection connection;

    private MessageHelper() {
        connection = new HttpConnection(address);
    }

    public static MessageHelper getInstance() {
        if (instance_ == null) {
            instance_ = new MessageHelper();
        }
        return instance_;
    }

    public CompletableFuture<Integer> sendMessageToAppInsights(String operationName, String message) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String licenseKey = UtilsConst.getLicenseKey();
                if (message.contains("BinariesUnloader exception") && licenseKey.equals("javonet-functional-tests-key")) {
                    return 0;
                }
                String formattedDateTime = ZonedDateTime.now(ZoneId.of("GMT")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
                String jsonPayload = String.format("{\"name\":\"AppEvents\",\"time\":\"%s\",\"iKey\":\"%s\",\"tags\":{\"ai.application.ver\":\"%s\",\"ai.cloud.roleInstance\":\"%s\",\"ai.operation.id\":\"0\",\"ai.operation.parentId\":\"0\",\"ai.operation.name\":\"%s\",\"ai.internal.sdkVersion\":\"javonet:2\",\"ai.internal.nodeName\":\"%s\"},\"data\":{\"baseType\":\"EventData\",\"baseData\":{\"ver\":2,\"name\":\"%s\",\"properties\":{\"OperatingSystem\":\"%s\",\"LicenseKey\":\"%s\",\"CallingTechnology\":\"%s\"}}}}", formattedDateTime, instrumentationKey, javonetVersion, nodeName, operationName, nodeName, message, osName, licenseKey, callingRuntimeName);
                return connection.send(jsonPayload);
            }
            catch (Exception ex) {
                return -1;
            }
        });
    }

    public void sendMessageToAppInsightsSync(String operationName, String message) {
        try {
            this.sendMessageToAppInsights(operationName, message).join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getJavonetVersion() {
        return Javonet.class.getPackage().getImplementationVersion();
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "Unknown Host";
        }
    }
}

