import datetime
import typing
from concurrent.futures import Future
from os import PathLike
from typing import Any

import assertionengine

from robotlibcore import DynamicCore  # type: ignore

from .utils.data_types import *
from .base import LibraryComponent


class Browser(DynamicCore):
    timeout: Any = ...
    scope_stack: typing.Dict = ...
    _old_init_args: typing.Dict = ...
    _playwright_state: Any = ...
    _browser_control: Any = ...


    def __init__(self, *_, auto_closing_level: AutoClosingLevel = AutoClosingLevel.TEST, enable_playwright_debug: bool = False, enable_presenter_mode: typing.Union[HighLightElement, bool] = False, external_browser_executable: typing.Optional[typing.Dict[SupportedBrowsers, str]] = None, jsextension: typing.Union[typing.List[str], str, None] = None, playwright_process_port: typing.Optional[int] = None, plugins: typing.Union[typing.List[str], str, None] = None, retry_assertions_for: timedelta = timedelta(seconds=1.0), run_on_failure: str = 'Take Screenshot  fail-screenshot-{index}', selector_prefix: typing.Optional[str] = None, show_keyword_call_banner: typing.Optional[bool] = None, strict: bool = True, timeout: timedelta = timedelta(seconds=10.0)): ...
    def add_cookie(self, name: str, value: str, url: typing.Optional[str] = None, domain: typing.Optional[str] = None, path: typing.Optional[str] = None, expires: typing.Optional[str] = None, httpOnly: typing.Optional[bool] = None, secure: typing.Optional[bool] = None, sameSite: typing.Optional[CookieSameSite] = None): ...
    def add_style_tag(self, content: str): ...
    def check_checkbox(self, selector: str, force: bool = False): ...
    def clear_permissions(self): ...
    def clear_text(self, selector: str): ...
    def click(self, selector: str, button: MouseButton = MouseButton.left, clickCount: Deprecated = Deprecated(), delay: Deprecated = Deprecated(), position_x: Deprecated = Deprecated(), position_y: Deprecated = Deprecated(), force: Deprecated = Deprecated(), noWaitAfter: Deprecated = Deprecated(), *modifiers: Deprecated): ...
    def click_with_options(self, selector: str, button: MouseButton = MouseButton.left, *modifiers: KeyboardModifier, clickCount: int = 1, delay: typing.Optional[datetime.timedelta] = None, force: bool = False, noWaitAfter: bool = False, position_x: typing.Optional[float] = None, position_y: typing.Optional[float] = None, trial: bool = False): ...
    def close_browser(self, browser: typing.Union[SelectionType, str] = SelectionType.CURRENT): ...
    def close_context(self, context: typing.Union[SelectionType, str] = SelectionType.CURRENT, browser: typing.Union[SelectionType, str] = SelectionType.CURRENT): ...
    def close_page(self, page: typing.Union[SelectionType, str] = SelectionType.CURRENT, context: typing.Union[SelectionType, str] = SelectionType.CURRENT, browser: typing.Union[SelectionType, str] = SelectionType.CURRENT): ...
    def connect_to_browser(self, wsEndpoint: str, browser: SupportedBrowsers = SupportedBrowsers.chromium): ...
    def crawl_site(self, url: typing.Optional[str] = None, page_crawl_keyword = 'take_screenshot', max_number_of_page_to_crawl: int = 1000, max_depth_to_crawl: int = 50): ...
    def delete_all_cookies(self): ...
    def deselect_options(self, selector: str): ...
    def download(self, url: str): ...
    def drag_and_drop(self, selector_from: str, selector_to: str, steps: int = 1): ...
    def drag_and_drop_by_coordinates(self, from_x: float, from_y: float, to_x: float, to_y: float, steps: int = 1): ...
    def drag_and_drop_relative_to(self, selector_from: str, x: float = 0.0, y: float = 0.0, steps: int = 1): ...
    def eat_all_cookies(self): ...
    def evaluate_javascript(self, selector: typing.Optional[str] = None, *function: str, arg: typing.Any = None, all_elements: bool = False): ...
    def fill_secret(self, selector: str, secret: str, force: bool = False): ...
    def fill_text(self, selector: str, txt: str, force: bool = False): ...
    def focus(self, selector: str): ...
    def get_attribute(self, selector: str, attribute: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_attribute_names(self, selector: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, *assertion_expected, message: typing.Optional[str] = None): ...
    def get_boundingbox(self, selector: str, key: BoundingBoxFields = BoundingBoxFields.ALL, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_browser_catalog(self, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_browser_ids(self, browser: SelectionType = SelectionType.ALL): ...
    def get_checkbox_state(self, selector: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Union[bool, str] = 'Unchecked', message: typing.Optional[str] = None): ...
    def get_classes(self, selector: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, *assertion_expected, message: typing.Optional[str] = None): ...
    def get_client_size(self, selector: typing.Optional[str] = None, key: SizeFields = SizeFields.ALL, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_console_log(self, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None, *, full: bool = False, last: typing.Union[int, datetime.timedelta, None] = None): ...
    def get_context_ids(self, context: SelectionType = SelectionType.ALL, browser: SelectionType = SelectionType.ALL): ...
    def get_cookie(self, cookie: str, return_type: CookieType = CookieType.dictionary): ...
    def get_cookies(self, return_type: CookieType = CookieType.dictionary): ...
    def get_device(self, name: str): ...
    def get_devices(self): ...
    def get_element(self, selector: str): ...
    def get_element_by(self, selection_strategy: SelectionStrategy, text: typing.Union[str, RegExp], exact: bool = False, all_elements: bool = False): ...
    def get_element_by_role(self, role: ElementRole, *, all_elements: bool = False, checked: typing.Optional[bool] = None, disabled: typing.Optional[bool] = None, exact: typing.Optional[bool] = None, expanded: typing.Optional[bool] = None, include_hidden: typing.Optional[bool] = None, level: typing.Optional[int] = None, name: typing.Union[str, RegExp, None] = None, pressed: typing.Optional[bool] = None, selected: typing.Optional[bool] = None): ...
    def get_element_count(self, selector: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Union[int, str] = 0, message: typing.Optional[str] = None): ...
    def get_element_states(self, selector: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, *assertion_expected: typing.Union[ElementState, str], message: typing.Optional[str] = None, return_names = True): ...
    def get_elements(self, selector: str): ...
    def get_page_errors(self, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None, *, full: bool = False, last: typing.Union[int, datetime.timedelta, None] = None): ...
    def get_page_ids(self, page: SelectionType = SelectionType.ALL, context: SelectionType = SelectionType.ALL, browser: SelectionType = SelectionType.ALL): ...
    def get_page_source(self, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_property(self, selector: str, property: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_scroll_position(self, selector: typing.Optional[str] = None, key: AreaFields = AreaFields.ALL, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_scroll_size(self, selector: typing.Optional[str] = None, key: SizeFields = SizeFields.ALL, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_select_options(self, selector: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_selected_options(self, selector: str, option_attribute: SelectAttribute = SelectAttribute.label, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, *assertion_expected, message: typing.Optional[str] = None): ...
    def get_style(self, selector: str, key: typing.Optional[str] = 'ALL', assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None, pseudo_element: typing.Optional[str] = None): ...
    def get_table_cell_element(self, table: str, column: str, row: str): ...
    def get_table_cell_index(self, selector: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Union[int, str] = 0, message: typing.Optional[str] = None): ...
    def get_table_row_index(self, selector: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Union[int, str] = 0, message: typing.Optional[str] = None): ...
    def get_text(self, selector: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_title(self, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_url(self, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def get_viewport_size(self, key: SizeFields = SizeFields.ALL, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None): ...
    def go_back(self): ...
    def go_forward(self): ...
    def go_to(self, url: str, timeout: typing.Optional[datetime.timedelta] = None): ...
    def grant_permissions(self, *permissions: Permission, origin: typing.Optional[str] = None): ...
    def handle_future_dialogs(self, action: DialogAction, prompt_input: str = ''): ...
    def highlight_elements(self, selector: str, duration: timedelta = timedelta(seconds=5.0), width: str = '2px', style: str = 'dotted', color: str = 'blue'): ...
    def hover(self, selector: str, position_x: typing.Optional[float] = None, position_y: typing.Optional[float] = None, force: bool = False, *modifiers: KeyboardModifier): ...
    def http(self, url: str, method: RequestMethod = RequestMethod.GET, body: typing.Optional[str] = None, headers: typing.Optional[dict] = None): ...
    def keyboard_input(self, action: KeyboardInputAction, input: str, delay: typing.Union[int, datetime.timedelta] = timedelta(seconds=0.0)): ...
    def keyboard_key(self, action: KeyAction, key: str): ...
    def local_storage_clear(self, frame_selector: typing.Optional[str] = None): ...
    def local_storage_get_item(self, key: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None, frame_selector: typing.Optional[str] = None): ...
    def local_storage_remove_item(self, key: str, frame_selector: typing.Optional[str] = None): ...
    def local_storage_set_item(self, key: str, value: str, frame_selector: typing.Optional[str] = None): ...
    def mouse_button(self, action: MouseButtonAction, x: typing.Optional[float] = None, y: typing.Optional[float] = None, button: MouseButton = MouseButton.left, clickCount: int = 1, delay: typing.Union[int, datetime.timedelta] = timedelta(seconds=0.0)): ...
    def mouse_move(self, x: float, y: float, steps: int = 1): ...
    def mouse_move_relative_to(self, selector: str, x: float = 0.0, y: float = 0.0, steps: int = 1): ...
    def mouse_wheel(self, deltaX: int, deltaY: int): ...
    def new_browser(self, browser: SupportedBrowsers = SupportedBrowsers.chromium, headless: bool = True, *, args: typing.Optional[typing.List[str]] = None, channel: typing.Optional[str] = None, chromiumSandbox: bool = False, devtools: bool = False, downloadsPath: typing.Optional[str] = None, env: typing.Optional[typing.Dict] = None, executablePath: typing.Optional[str] = None, firefoxUserPrefs: typing.Optional[typing.Dict[str, typing.Union[str, int, float, bool]]] = None, handleSIGHUP: bool = True, handleSIGINT: bool = True, handleSIGTERM: bool = True, ignoreDefaultArgs: typing.Union[typing.List[str], bool, None] = None, proxy: typing.Optional[Proxy] = None, reuse_existing: bool = True, slowMo: timedelta = timedelta(seconds=0.0), timeout: timedelta = timedelta(seconds=30.0)): ...
    def new_context(self, *, acceptDownloads: bool = True, baseURL: typing.Optional[str] = None, bypassCSP: bool = False, colorScheme: typing.Optional[ColorScheme] = None, defaultBrowserType: typing.Optional[SupportedBrowsers] = None, deviceScaleFactor: typing.Optional[float] = None, extraHTTPHeaders: typing.Optional[typing.Dict[str, str]] = None, forcedColors: ForcedColors = ForcedColors.none, geolocation: typing.Optional[GeoLocation] = None, hasTouch: typing.Optional[bool] = None, hideRfBrowser: Deprecated = Deprecated(), httpCredentials: typing.Optional[HttpCredentials] = None, ignoreHTTPSErrors: bool = False, isMobile: typing.Optional[bool] = None, javaScriptEnabled: bool = True, locale: typing.Optional[str] = None, offline: bool = False, permissions: typing.Optional[typing.List[Permission]] = None, proxy: typing.Optional[Proxy] = None, recordHar: typing.Optional[RecordHar] = None, recordVideo: typing.Optional[RecordVideo] = None, reducedMotion: ReduceMotion = ReduceMotion.no_preference, screen: typing.Optional[typing.Dict[str, int]] = None, serviceWorkers: typing.Optional[ServiceWorkersPermissions] = ServiceWorkersPermissions.allow, storageState: typing.Optional[str] = None, timezoneId: typing.Optional[str] = None, tracing: typing.Optional[str] = None, userAgent: typing.Optional[str] = None, viewport: typing.Optional[ViewportDimensions] = {'width': 1280, 'height': 720}): ...
    def new_page(self, url: typing.Optional[str] = None): ...
    def new_persistent_context(self, userDataDir: str = '', browser: SupportedBrowsers = SupportedBrowsers.chromium, headless: bool = True, *, acceptDownloads: bool = True, args: typing.Optional[typing.List[str]] = None, baseURL: typing.Optional[str] = None, bypassCSP: bool = False, channel: typing.Optional[str] = None, chromiumSandbox: bool = False, colorScheme: typing.Optional[ColorScheme] = None, defaultBrowserType: typing.Optional[SupportedBrowsers] = None, deviceScaleFactor: typing.Optional[float] = None, devtools: bool = False, downloadsPath: typing.Optional[str] = None, env: typing.Optional[typing.Dict] = None, executablePath: typing.Optional[str] = None, extraHTTPHeaders: typing.Optional[typing.Dict[str, str]] = None, forcedColors: ForcedColors = ForcedColors.none, geolocation: typing.Optional[GeoLocation] = None, handleSIGHUP: bool = True, handleSIGINT: bool = True, handleSIGTERM: bool = True, hasTouch: typing.Optional[bool] = None, hideRfBrowser: Deprecated = Deprecated(), httpCredentials: typing.Optional[HttpCredentials] = None, ignoreDefaultArgs: typing.Union[typing.List[str], bool, None] = None, ignoreHTTPSErrors: bool = False, isMobile: typing.Optional[bool] = None, javaScriptEnabled: bool = True, locale: typing.Optional[str] = None, offline: bool = False, permissions: typing.Optional[typing.List[Permission]] = None, proxy: typing.Optional[Proxy] = None, recordHar: typing.Optional[RecordHar] = None, recordVideo: typing.Optional[RecordVideo] = None, reducedMotion: ReduceMotion = ReduceMotion.no_preference, screen: typing.Optional[typing.Dict[str, int]] = None, serviceWorkers: typing.Optional[ServiceWorkersPermissions] = ServiceWorkersPermissions.allow, slowMo: timedelta = timedelta(seconds=0.0), storageState: Deprecated = Deprecated(), timeout: timedelta = timedelta(seconds=30.0), timezoneId: typing.Optional[str] = None, tracing: typing.Optional[str] = None, url: typing.Optional[str] = None, userAgent: typing.Optional[str] = None, viewport: typing.Optional[ViewportDimensions] = {'width': 1280, 'height': 720}): ...
    def open_browser(self, url: typing.Optional[str] = None, browser: SupportedBrowsers = SupportedBrowsers.chromium, headless: bool = False, pause_on_failure: bool = True, bypassCSP = True): ...
    def press_keys(self, selector: str, *keys: str): ...
    def promise_to(self, kw: str, *args): ...
    def promise_to_upload_file(self, path: PathLike): ...
    def promise_to_wait_for_download(self, saveAs: str = ''): ...
    def record_selector(self, label: typing.Optional[str] = None): ...
    def register_keyword_to_run_on_failure(self, keyword: typing.Optional[str], *args: str, scope: Scope = Scope.Global): ...
    def reload(self): ...
    def save_storage_state(self): ...
    def scroll_by(self, selector: typing.Optional[str] = None, vertical: str = 'height', horizontal: str = '0', behavior: ScrollBehavior = ScrollBehavior.auto): ...
    def scroll_to(self, selector: typing.Optional[str] = None, vertical: str = 'top', horizontal: str = 'left', behavior: ScrollBehavior = ScrollBehavior.auto): ...
    def scroll_to_element(self, selector: str): ...
    def select_options_by(self, selector: str, attribute: SelectAttribute, *values): ...
    def session_storage_clear(self, frame_selector: typing.Optional[str] = None): ...
    def session_storage_get_item(self, key: str, assertion_operator: typing.Optional[assertionengine.assertion_engine.AssertionOperator] = None, assertion_expected: typing.Optional[typing.Any] = None, message: typing.Optional[str] = None, frame_selector: typing.Optional[str] = None): ...
    def session_storage_remove_item(self, key: str, frame_selector: typing.Optional[str] = None): ...
    def session_storage_set_item(self, key: str, value: str, frame_selector: typing.Optional[str] = None): ...
    def set_assertion_formatters(self, formatters: typing.Dict[str, typing.List[str]]): ...
    def set_browser_timeout(self, timeout: timedelta, scope: Scope = Scope.Suite): ...
    def set_geolocation(self, latitude: float, longitude: float, accuracy: typing.Optional[float] = None): ...
    def set_offline(self, offline: bool = True): ...
    def set_retry_assertions_for(self, timeout: timedelta, scope: Scope = Scope.Suite): ...
    def set_selector_prefix(self, prefix: typing.Optional[str], scope: Scope = Scope.Suite): ...
    def set_strict_mode(self, mode: bool, scope: Scope = Scope.Suite): ...
    def set_viewport_size(self, width: int, height: int): ...
    def show_keyword_banner(self, show: bool = True, style: str = '', scope: Scope = Scope.Suite): ...
    def switch_browser(self, id: str): ...
    def switch_context(self, id: str, browser: typing.Union[SelectionType, str] = SelectionType.CURRENT): ...
    def switch_page(self, id: typing.Union[NewPageDetails, str], context: typing.Union[SelectionType, str] = SelectionType.CURRENT, browser: typing.Union[SelectionType, str] = SelectionType.CURRENT): ...
    def tab(self, selector: str, force: bool = False, noWaitAfter: bool = False, position_x: typing.Optional[int] = None, position_y: typing.Optional[int] = None, trial: bool = False, *modifiers: KeyboardModifier): ...
    def take_screenshot(self, filename: typing.Optional[str] = 'robotframework-browser-screenshot-{index}', selector: typing.Optional[str] = None, *, crop: typing.Optional[BoundingBox] = None, disableAnimations: bool = False, fileType: ScreenshotFileTypes = ScreenshotFileTypes.png, fullPage: bool = False, log_screenshot: bool = True, mask: typing.Union[typing.List[str], str] = '', maskColor: typing.Optional[str] = None, omitBackground: bool = False, quality: typing.Optional[int] = None, scale: typing.Optional[Scale] = None, return_as: ScreenshotReturnType = ScreenshotReturnType.path_string, timeout: typing.Optional[datetime.timedelta] = None): ...
    def tap(self, selector: str, *modifiers: KeyboardModifier, force: bool = False, noWaitAfter: bool = False, position_x: typing.Optional[int] = None, position_y: typing.Optional[int] = None, trial: bool = False): ...
    def type_secret(self, selector: str, secret: str, delay: timedelta = timedelta(seconds=0.0), clear: bool = True): ...
    def type_text(self, selector: str, txt: str, delay: timedelta = timedelta(seconds=0.0), clear: bool = True): ...
    def uncheck_checkbox(self, selector: str, force: bool = False): ...
    def upload_file_by_selector(self, selector: str, path: PathLike): ...
    def wait_for(self, *promises: Future): ...
    def wait_for_alert(self, action: DialogAction, prompt_input: str = '', text: typing.Optional[str] = None): ...
    def wait_for_all_promises(self): ...
    def wait_for_condition(self, condition: ConditionInputs, *args: typing.Any, timeout: typing.Optional[datetime.timedelta] = None, message: typing.Optional[str] = None): ...
    def wait_for_elements_state(self, selector: str, state: ElementState = ElementState.visible, timeout: typing.Optional[datetime.timedelta] = None, message: typing.Optional[str] = None): ...
    def wait_for_function(self, function: str, selector: str = '', polling: typing.Union[str, datetime.timedelta] = 'raf', timeout: typing.Optional[datetime.timedelta] = None, message: typing.Optional[str] = None): ...
    def wait_for_navigation(self, url: typing.Union[str, RegExp], timeout: typing.Optional[datetime.timedelta] = None, wait_until: PageLoadStates = PageLoadStates.load): ...
    def wait_for_request(self, matcher: typing.Union[str, RegExp] = '', timeout: typing.Optional[datetime.timedelta] = None): ...
    def wait_for_response(self, matcher: typing.Union[str, RegExp] = '', timeout: typing.Optional[datetime.timedelta] = None): ...
    def wait_until_network_is_idle(self, timeout: typing.Optional[datetime.timedelta] = None): ...
    def get_timeout(self, timeout: Union[timedelta, None]) -> float: ...
    def convert_timeout(self, timeout: Union[timedelta, float], to_ms: bool = True) -> float: ...
    def millisecs_to_timestr(self, timeout: float)  -> str: ...
    def get_strict_mode(self, strict: Union[bool, None]) -> bool: ...
    def _parse_run_on_failure_keyword(self, keyword_name: Union[str, None]) -> DelayedKeyword: ...
    def _create_lib_component_from_jsextension(self, jsextension: str) -> LibraryComponent: ...

