# mypy-boto3-guardduty

[![PyPI - mypy-boto3-guardduty](https://img.shields.io/pypi/v/mypy-boto3-guardduty.svg?color=blue)](https://pypi.org/project/mypy-boto3-guardduty)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-guardduty.svg?color=blue)](https://pypi.org/project/mypy-boto3-guardduty)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.GuardDuty 1.14.10](https://boto3.amazonaws.com/v1/documentation/api/1.14.10/reference/services/guardduty.html#GuardDuty) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `GuardDuty` service.

```bash
python -m pip install boto3-stubs[guardduty]
```

## How to use

### Client annotations

`GuardDutyClient` provides annotations for `boto3.client("guardduty")`.

```python
import boto3

from mypy_boto3_guardduty import GuardDutyClient
from mypy_boto3_guardduty.paginator import (
    ListDetectorsPaginator,
    ListFiltersPaginator,
    ListFindingsPaginator,
    ListInvitationsPaginator,
    ListIPSetsPaginator,
    ListMembersPaginator,
    ListOrganizationAdminAccountsPaginator,
    ListThreatIntelSetsPaginator,
)
from mypy_boto3_guardduty.type_defs import AccessControlListTypeDef, ...

client: GuardDutyClient = boto3.client("guardduty")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: GuardDutyClient = session.client("guardduty")
```

### Paginators annotations

`mypy_boto3_guardduty.paginator` module contains type annotations for all paginators.

```python

client: GuardDutyClient = boto3.client("guardduty")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_detectors_paginator: ListDetectorsPaginator = client.get_paginator("list_detectors")
list_filters_paginator: ListFiltersPaginator = client.get_paginator("list_filters")
list_findings_paginator: ListFindingsPaginator = client.get_paginator("list_findings")
list_ip_sets_paginator: ListIPSetsPaginator = client.get_paginator("list_ip_sets")
list_invitations_paginator: ListInvitationsPaginator = client.get_paginator("list_invitations")
list_members_paginator: ListMembersPaginator = client.get_paginator("list_members")
list_organization_admin_accounts_paginator: ListOrganizationAdminAccountsPaginator = client.get_paginator("list_organization_admin_accounts")
list_threat_intel_sets_paginator: ListThreatIntelSetsPaginator = client.get_paginator("list_threat_intel_sets")
```







### Typed dictionations

`mypy_boto3_guardduty.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AccessControlListTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_guardduty` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("guardduty")

session_client = boto3.Session().client("guardduty")
```
