"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScopedAws = exports.Aws = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_reference_1 = require("./private/cfn-reference");
const token_1 = require("./token");
const AWS_ACCOUNTID = 'AWS::AccountId';
const AWS_URLSUFFIX = 'AWS::URLSuffix';
const AWS_NOTIFICATIONARNS = 'AWS::NotificationARNs';
const AWS_PARTITION = 'AWS::Partition';
const AWS_REGION = 'AWS::Region';
const AWS_STACKID = 'AWS::StackId';
const AWS_STACKNAME = 'AWS::StackName';
const AWS_NOVALUE = 'AWS::NoValue';
/**
 * Accessor for pseudo parameters.
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 *
 * @stability stable
 */
class Aws {
    constructor() { }
}
exports.Aws = Aws;
_a = JSII_RTTI_SYMBOL_1;
Aws[_a] = { fqn: "@aws-cdk/core.Aws", version: "1.139.0" };
/**
 * @stability stable
 */
Aws.ACCOUNT_ID = pseudoString(AWS_ACCOUNTID);
/**
 * @stability stable
 */
Aws.URL_SUFFIX = pseudoString(AWS_URLSUFFIX);
/**
 * @stability stable
 */
Aws.NOTIFICATION_ARNS = token_1.Token.asList({ Ref: AWS_NOTIFICATIONARNS }, { displayHint: AWS_NOTIFICATIONARNS });
/**
 * @stability stable
 */
Aws.PARTITION = pseudoString(AWS_PARTITION);
/**
 * @stability stable
 */
Aws.REGION = pseudoString(AWS_REGION);
/**
 * @stability stable
 */
Aws.STACK_ID = pseudoString(AWS_STACKID);
/**
 * @stability stable
 */
Aws.STACK_NAME = pseudoString(AWS_STACKNAME);
/**
 * @stability stable
 */
Aws.NO_VALUE = pseudoString(AWS_NOVALUE);
/**
 * Accessor for scoped pseudo parameters.
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 *
 * @stability stable
 */
class ScopedAws {
    /**
     * @stability stable
     */
    constructor(scope) {
        this.scope = scope;
        jsiiDeprecationWarnings._aws_cdk_core_Construct(scope);
    }
    /**
     * @stability stable
     */
    get accountId() {
        return this.asString(AWS_ACCOUNTID);
    }
    /**
     * @stability stable
     */
    get urlSuffix() {
        return this.asString(AWS_URLSUFFIX);
    }
    /**
     * @stability stable
     */
    get notificationArns() {
        return token_1.Token.asList(cfn_reference_1.CfnReference.forPseudo(AWS_NOTIFICATIONARNS, this.scope), {
            displayHint: AWS_NOTIFICATIONARNS,
        });
    }
    /**
     * @stability stable
     */
    get partition() {
        return this.asString(AWS_PARTITION);
    }
    /**
     * @stability stable
     */
    get region() {
        return this.asString(AWS_REGION);
    }
    /**
     * @stability stable
     */
    get stackId() {
        return this.asString(AWS_STACKID);
    }
    /**
     * @stability stable
     */
    get stackName() {
        return this.asString(AWS_STACKNAME);
    }
    asString(name) {
        return token_1.Token.asString(cfn_reference_1.CfnReference.forPseudo(name, this.scope), { displayHint: name });
    }
}
exports.ScopedAws = ScopedAws;
_b = JSII_RTTI_SYMBOL_1;
ScopedAws[_b] = { fqn: "@aws-cdk/core.ScopedAws", version: "1.139.0" };
function pseudoString(name) {
    // we don't want any ':' in the serialized form,
    // as ':' is the ARN separator,
    // and so we don't want ARN components
    // (which these CFN references like AWS::Partition certainly can be)
    // to contain ':'s themselves
    return token_1.Token.asString({ Ref: name }, { displayHint: name.replace('::', '.') });
}
//# sourceMappingURL=data:application/json;base64,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