(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* :Title: FigLabel *)
(* :Context: SciDraw` *)
(* :Summary: Label object *)
(* :Author: Mark A. Caprio, Department of Physics, University of Notre Dame *)
(* :Copyright: Copyright FIGYEAR, Mark A. Caprio *)
(* :Package Version: FIGVERSION *)
(* :Mathematica Version: MATHVERSION *)
(* :Discussion: FIGDISCUSSION *)
(* :History: See package information file. *)


BeginPackage["SciDraw`",SciDraw`Private`$ExternalContexts];


Unprotect[Evaluate[$Context<>"*"]];


FigLabel::usage="FIGURE OBJECT: FigLabel[point,text] generates a label at the given point.  If point is given as an anchor object, the default text offset and orientation information is taken from the anchor.  FigLabel[object,name,text] or FigLabel[object,name,arg,text] attaches the label to an anchor extracted from the given object.  FigLabel[text] takes its position from the option Position.";


Displacement::usage="Option name for use with figure objects.";


Begin["`Private`"];





DeclareFigClass[
FigLabel,
{"Anchor","TextElement"},
{},
{}
];
DefineFigClassOptions[
FigLabel,
{
(* given position *)
Point->{0,0},

(* anchor position *)
Position->Automatic,

(* label displacement *)
Displacement->None
}
];


BasicLabel[Self_Object][GivenAnchor_Object,TextArt_]:=Module[
{
TextElement,Anchor,
CanvasCenter,CanvasPivot,CanvasRadius,RotationAngle
},

(* validate options *)
FigCheckOption[Self,Displacement,FigDisplacementPattern,FigOptions];

(* generate point *)
Anchor=RelativeTo[FigAnchor[GivenAnchor],(Displacement/.FigOptions)];

(* make text *)
TextElement=FigTextElement[
Anchor,
TextArt,
FigOptions
];

(* save references to spawned objects *)
Self@SetAnchor[Anchor];
Self@SetTextElement[TextElement];

];


Constructor[Class:FigLabel,Self_Object][TextArt_,Opts___?OptionQ]:=FigObjectWrapper[Class,Self,{Opts},

(* validate special option *)
FigCheckOption[Self,Point,FigPointPattern,FigOptions];

BasicLabel[Self][FigAnchor[(Point/.FigOptions)],TextArt]

];


Constructor[Class:FigLabel,Self_Object][p:FigPointPattern,TextArt_,Opts___?OptionQ]:=FigObjectWrapper[Class,Self,{Opts},
BasicLabel[Self][FigAnchor[p],TextArt]
];


Constructor[Class:FigLabel,Self_Object][(n:ObjectNamePattern[FigObject]),Name_,AnchorArg:_:None,TextArt:Except[_?OptionQ],Opts___?OptionQ]:=FigObjectWrapper[Class,Self,{Opts},
(*Print[n," ",Name," ",TextArt," ",{Opts}];*)
BasicLabel[Self][
FigAnchor[n,Name,ResolveOption[Position,{Automatic->AnchorArg},FigOptions]],
TextArt
]
];


MakeAnchor[Class:FigLabel,Self_Object][Name_,Arg_]:=FigMakeAnchorWrapper[Class,Self,Name,Arg,
FigRectangleAnchor[
(Self@GetTextElement[])@GetCenter[],(Self@GetTextElement[])@GetRadius[],(Self@GetTextElement[])@GetPivot[],(Self@GetTextElement[])@GetRotation[],
Name,Arg
]
];
MakeBoundingBox[Class:FigLabel,Self_Object][]:=FigRectangleBoundingBox[
(Self@GetTextElement[])@GetCenter[],(Self@GetTextElement[])@GetRadius[],(Self@GetTextElement[])@GetPivot[],(Self@GetTextElement[])@GetRotation[]
];


End[];


Protect[Evaluate[$Context<>"*"]];
Unprotect[Evaluate[$Context<>"$*"]];
EndPackage[];
