/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.common;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers.SchemaMapSyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.RegexECMA262Helper;
import com.github.fge.msgsimple.bundle.MessageBundle;
import io.ray.shaded.com.google.common.collect.Ordering;
import io.ray.shaded.com.google.common.collect.Sets;
import java.util.HashSet;

public final class PatternPropertiesSyntaxChecker
extends SchemaMapSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new PatternPropertiesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private PatternPropertiesSyntaxChecker() {
        super("patternProperties");
    }

    @Override
    protected void extraChecks(ProcessingReport report, MessageBundle bundle, SchemaTree tree) throws ProcessingException {
        HashSet<String> set = Sets.newHashSet(this.getNode(tree).fieldNames());
        for (String s2 : Ordering.natural().sortedCopy(set)) {
            if (RegexECMA262Helper.regexIsValid(s2)) continue;
            report.error(this.newMsg(tree, bundle, "common.patternProperties.member.notRegex").putArgument("propertyName", s2));
        }
    }
}

