from __future__ import annotations

from typing import Any, Dict
from pathlib import Path
from html import escape

from .base import Payload


class FileContentsPayload(Payload):
    def __init__(self, file: str) -> None:
        super().__init__()
        self._file = file

    def get_type(self) -> str:
        return "custom"

    def get_content(self) -> Dict[str, Any]:
        p = Path(self._file)
        if not p.exists():
            return {
                "content": f"File not found: '{self._file}'",
                "label": "File",
            }

        try:
            contents = p.read_text(encoding="utf-8", errors="replace")
        except Exception:
            contents = ""

        encoded = escape(contents, quote=True).replace("\n", "<br />")
        return {
            "content": encoded,
            "label": p.name,
        }
