from __future__ import annotations

from typing import Any, Dict
import json

from .base import Payload


class JsonStringPayload(Payload):
    def __init__(self, value: Any) -> None:
        super().__init__()
        self._value = value

    def get_type(self) -> str:
        # Use the generic "custom" type so Ray/Buggregator renders it as a
        # standard custom payload with a JSON label.
        return "custom"

    def get_content(self) -> Dict[str, Any]:
        # Encode the given value as a pretty-printed JSON string.
        json_str = json.dumps(self._value, default=str, indent=2, sort_keys=True)
        return {
            "content": json_str,
            "label": "JSON",
        }
