from __future__ import annotations

from typing import Any, Dict

from .base import Payload


class MeasurePayload(Payload):
    def __init__(
        self,
        name: str,
        is_new_timer: bool,
        total_time: float,
        time_since_last_call: float,
    ) -> None:
        super().__init__()
        self._name = name
        self._is_new_timer = is_new_timer
        self._total_time = total_time
        self._time_since_last_call = time_since_last_call

    def get_type(self) -> str:
        return "measure"

    def get_content(self) -> Dict[str, Any]:
        return {
            "name": self._name,
            "is_new_timer": self._is_new_timer,
            "total_time": self._total_time,
            "max_memory_usage_during_total_time": 0,
            "time_since_last_call": self._time_since_last_call,
            "max_memory_usage_since_last_call": 0,
        }
