from __future__ import annotations

from typing import Any, Dict

from .base import Payload


class ScreenColorPayload(Payload):
    def __init__(self, color: str) -> None:
        super().__init__()
        self._color = color

    def get_type(self) -> str:
        return "screen_color"

    def get_content(self) -> Dict[str, Any]:
        return {"color": self._color}
