from __future__ import annotations

from typing import Any, Dict, Iterable, List

from .base import Payload


def _to_primitive(value: Any) -> Any:
    # Simple heuristic: JSON-serializable-ish conversion
    if isinstance(value, (str, int, float, bool)) or value is None:
        return value
    if isinstance(value, dict):
        return {str(k): _to_primitive(v) for k, v in value.items()}
    if isinstance(value, (list, tuple, set)):
        return [_to_primitive(v) for v in value]
    return repr(value)


class TablePayload(Payload):
    def __init__(self, values: Iterable[Any], label: str = "Table") -> None:
        super().__init__()
        self._values = list(values)
        self._label = label

    def get_type(self) -> str:
        return "table"

    def get_content(self) -> Dict[str, Any]:
        values = [_to_primitive(v) for v in self._values]
        return {
            "values": values,
            "label": self._label,
        }
