from __future__ import annotations

from html import escape
from typing import Any, Dict

from .base import Payload


class TextPayload(Payload):
    def __init__(self, text: str = "") -> None:
        super().__init__()
        self._text = text

    def get_type(self) -> str:
        return "custom"

    def get_content(self) -> Dict[str, Any]:
        return {
            "content": self._format_content(),
            "label": "Text",
        }

    def _format_content(self) -> str:
        result = escape(self._text, quote=True)
        return result.replace(" ", "&nbsp;").replace("\n", "<br>")
