from __future__ import annotations

from typing import Any, Dict, List

from .base import Payload


class TracePayload(Payload):
    def __init__(self, frames: List[Dict[str, Any]], start_from_index: int | None = None, limit: int | None = None) -> None:
        super().__init__()
        self._frames = frames
        self._start_from_index = start_from_index
        self._limit = limit

    def get_type(self) -> str:
        return "trace"

    def get_content(self) -> Dict[str, Any]:
        frames = self._frames
        if self._limit is not None:
            start = self._start_from_index or 0
            frames = frames[start : start + self._limit]
        return {"frames": frames}
