from __future__ import annotations


class StopExecutionRequested(Exception):
    """Raised when Ray signals that execution should be stopped."""

    def __init__(self) -> None:
        super().__init__(
            "This exception is raised because you requested to stop the execution in Ray.",
        )


class CouldNotConnectToRay(Exception):
    """Raised when the Ray server is unreachable (not used by default)."""

    def __init__(self, host: str, port: int) -> None:
        super().__init__(
            f"Couldn't connect to Ray. It doesn't seem to be running at {host}:{port}",
        )
