"""ProductionScheduleVersion add on delete cascade to fkey

Revision ID: 4368137b44e1
Revises: 0bd1e89f2a6f
Create Date: 2025-07-23 00:41:37.354903

"""

from alembic import op


# revision identifiers, used by Alembic.
revision = "4368137b44e1"
down_revision = "0bd1e89f2a6f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "production_schedule_version", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f(
                "production_schedule_version_production_schedule_from_fkey"
            ),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("production_schedule_version_project_id_fkey"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            None, "project", ["project_id"], ["id"], ondelete="CASCADE"
        )
        batch_op.create_foreign_key(
            None,
            "production_schedule_version",
            ["production_schedule_from"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table(
        "production_schedule_version_task_link", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f(
                "production_schedule_version_t_production_schedule_version__fkey"
            ),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("production_schedule_version_task_link_task_id_fkey"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            None,
            "production_schedule_version",
            ["production_schedule_version_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            None, "task", ["task_id"], ["id"], ondelete="CASCADE"
        )

    with op.batch_alter_table(
        "production_schedule_version_task_link_person_link", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f(
                "production_schedule_version_task_link_person_lin_person_id_fkey"
            ),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f(
                "production_schedule_version__production_schedule_version__fkey1"
            ),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            None,
            "production_schedule_version_task_link",
            ["production_schedule_version_task_link_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            None, "person", ["person_id"], ["id"], ondelete="CASCADE"
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "production_schedule_version_task_link_person_link", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f(
                "production_schedule_version_task_link_person_lin_person_id_fkey"
            ),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f(
                "production_schedule_version__production_schedule_version__fkey1"
            ),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f(
                "production_schedule_version__production_schedule_version__fkey1"
            ),
            "production_schedule_version_task_link",
            ["production_schedule_version_task_link_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            batch_op.f(
                "production_schedule_version_task_link_person_lin_person_id_fkey"
            ),
            "person",
            ["person_id"],
            ["id"],
        )

    with op.batch_alter_table(
        "production_schedule_version_task_link", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f(
                "production_schedule_version_t_production_schedule_version__fkey"
            ),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("production_schedule_version_task_link_task_id_fkey"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("production_schedule_version_task_link_task_id_fkey"),
            "task",
            ["task_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            batch_op.f(
                "production_schedule_version_t_production_schedule_version__fkey"
            ),
            "production_schedule_version",
            ["production_schedule_version_id"],
            ["id"],
        )

    with op.batch_alter_table(
        "production_schedule_version", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f(
                "production_schedule_version_production_schedule_from_fkey"
            ),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("production_schedule_version_project_id_fkey"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("production_schedule_version_project_id_fkey"),
            "project",
            ["project_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            batch_op.f(
                "production_schedule_version_production_schedule_from_fkey"
            ),
            "production_schedule_version",
            ["production_schedule_from"],
            ["id"],
        )

    # ### end Alembic commands ###
