"""add people salary scale table

Revision ID: 45f739ef962a
Revises: 2762a797f1f9
Create Date: 2025-04-02 10:11:12.544243

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "45f739ef962a"
down_revision = "2762a797f1f9"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "salary_scale",
        sa.Column(
            "department_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("senior_supervisor_salary", sa.Integer(), nullable=False),
        sa.Column("mid_supervisor_salary", sa.Integer(), nullable=False),
        sa.Column("junior_supervisor_salary", sa.Integer(), nullable=False),
        sa.Column("senior_lead_salary", sa.Integer(), nullable=False),
        sa.Column("mid_lead_salary", sa.Integer(), nullable=False),
        sa.Column("junior_lead_salary", sa.Integer(), nullable=False),
        sa.Column("senior_artist_salary", sa.Integer(), nullable=False),
        sa.Column("mid_artist_salary", sa.Integer(), nullable=False),
        sa.Column("junior_artist_salary", sa.Integer(), nullable=False),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["department_id"],
            ["department.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("salary_scale", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_salary_scale_department_id"),
            ["department_id"],
            unique=False,
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("salary_scale", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_salary_scale_department_id"))

    op.drop_table("salary_scale")
    # ### end Alembic commands ###
