"""add budget entry table

Revision ID: 8ab98c178903
Revises: 83e2f33a9b14
Create Date: 2025-04-15 16:56:25.451489

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "8ab98c178903"
down_revision = "83e2f33a9b14"
branch_labels = None
depends_on = None

from zou.app.models.person import POSITION_TYPES, SENIORITY_TYPES


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "budget_entry",
        sa.Column(
            "budget_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "department_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "person_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
        sa.Column("start_date", sa.Date(), nullable=False),
        sa.Column("months_duration", sa.Integer(), nullable=False),
        sa.Column("daily_salary", sa.Float(), nullable=False),
        sa.Column(
            "position",
            sqlalchemy_utils.types.choice.ChoiceType(POSITION_TYPES),
            nullable=True,
        ),
        sa.Column(
            "seniority",
            sqlalchemy_utils.types.choice.ChoiceType(SENIORITY_TYPES),
            nullable=True,
        ),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["budget_id"],
            ["budget.id"],
        ),
        sa.ForeignKeyConstraint(
            ["department_id"],
            ["department.id"],
        ),
        sa.ForeignKeyConstraint(
            ["person_id"],
            ["person.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("budget_entry", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_budget_entry_budget_id"),
            ["budget_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_budget_entry_department_id"),
            ["department_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_budget_entry_person_id"),
            ["person_id"],
            unique=False,
        )

    with op.batch_alter_table("budget", schema=None) as batch_op:
        batch_op.alter_column(
            "project_id", existing_type=sa.UUID(), nullable=True
        )
        batch_op.create_foreign_key(
            "budget_project_id_fkey", "project", ["project_id"], ["id"]
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("budget", schema=None) as batch_op:
        batch_op.drop_constraint("budget_project_id_fkey", type_="foreignkey")
        batch_op.alter_column(
            "project_id", existing_type=sa.UUID(), nullable=False
        )

    with op.batch_alter_table("budget_entry", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_budget_entry_person_id"))
        batch_op.drop_index(batch_op.f("ix_budget_entry_department_id"))
        batch_op.drop_index(batch_op.f("ix_budget_entry_budget_id"))

    op.drop_table("budget_entry")
    # ### end Alembic commands ###
