"""add hardware table

Revision ID: 9af2df17a9d5
Revises: d5665dca188b
Create Date: 2025-07-14 16:30:41.472002

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "9af2df17a9d5"
down_revision = "d5665dca188b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "hardware_item",
        sa.Column("name", sa.String(length=40), nullable=False),
        sa.Column("short_name", sa.String(length=20), nullable=False),
        sa.Column("archived", sa.Boolean(), nullable=True),
        sa.Column("monthly_cost", sa.Integer(), nullable=True),
        sa.Column("inventory_amount", sa.Integer(), nullable=True),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("hardware_item")
    # ### end Alembic commands ###
