"""Add ProductionScheduleVersionTaskLink uc

Revision ID: 0bd1e89f2a6f
Revises: e4b48ca33539
Create Date: 2025-07-22 17:13:16.680191

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "0bd1e89f2a6f"
down_revision = "e4b48ca33539"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "production_schedule_version_task_link", schema=None
    ) as batch_op:
        batch_op.alter_column(
            "production_schedule_version_id",
            existing_type=sa.UUID(),
            nullable=False,
        )
        batch_op.alter_column(
            "task_id", existing_type=sa.UUID(), nullable=False
        )
        batch_op.create_unique_constraint(
            "production_schedule_version_task_link_uc",
            ["production_schedule_version_id", "task_id"],
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "production_schedule_version_task_link", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            "production_schedule_version_task_link_uc", type_="unique"
        )
        batch_op.alter_column(
            "task_id", existing_type=sa.UUID(), nullable=False
        )
        batch_op.alter_column(
            "production_schedule_version_id",
            existing_type=sa.UUID(),
            nullable=False,
        )

    # ### end Alembic commands ###
