# coding: utf-8

"""
    STACKIT MongoDB Service API

    This is the documentation for the STACKIT MongoDB Flex Service API

    The version of the OpenAPI document: 2.0.0
    Contact: support@stackit.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set, Union

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictFloat,
    StrictInt,
    StrictStr,
)
from typing_extensions import Self


class SuggestedIndex(BaseModel):
    """
    SuggestedIndex
    """  # noqa: E501

    id: Optional[StrictStr] = Field(default=None, description="Unique id for this suggested index.")
    impact: Optional[List[StrictStr]] = Field(
        default=None,
        description="List of unique identifiers which correspond the query shapes in this response which pertain to this suggested index.",
    )
    index: Optional[List[Dict[str, StrictInt]]] = Field(
        default=None,
        description="Array of documents that specifies a key in the index and its sort order, ascending or descending.",
    )
    namespace: Optional[StrictStr] = Field(default=None, description="Namespace of the suggested index.")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Estimated percentage performance improvement that the suggested index would provide."
    )
    __properties: ClassVar[List[str]] = ["id", "impact", "index", "namespace", "weight"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SuggestedIndex from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SuggestedIndex from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "impact": obj.get("impact"),
                "index": obj.get("index"),
                "namespace": obj.get("namespace"),
                "weight": obj.get("weight"),
            }
        )
        return _obj
